/*
  Bear Engine

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [BEAR] in the subject of your mails.
*/
/**
 * \file transition_layer.hpp
 * \brief This layer displays transition effects.
 * \author Julien Jorge
 */
#ifndef __BEAR_ENGINE_TRANSITION_LAYER_HPP__
#define __BEAR_ENGINE_TRANSITION_LAYER_HPP__

#include "communication/messageable.hpp"
#include "engine/layer/gui_layer.hpp"

#include "engine/class_export.hpp"

namespace bear
{
  namespace engine
  {
    class transition_effect;

    /**
     * \brief This layer displays transition effects.
     * \author Julien Jorge
     *
     * The progress() method does nothing if the level is paused. Effect coders
     * can prevent the user from setting the pause by returning true in the
     * methods transition_effect::key_pressed() and
     * transition_effect::button_pressed().
     */
    class ENGINE_EXPORT transition_layer:
      public gui_layer,
      public communication::messageable
    {
    public:
      /** \brief The type of a list of scene elements retrieved from the
          layer. */
      typedef gui_layer::scene_element_list scene_element_list;

    public:
      transition_layer( const std::string& name );
      ~transition_layer();

      void build();
      void progress( universe::time_type elapsed_time );
      void render( scene_element_list& e ) const;

      bool key_pressed( const input::key_info& key );
      bool key_maintained( const input::key_info& key );
      bool key_released( const input::key_info& key );
      bool char_pressed( const input::key_info& key );
      bool button_pressed
      ( input::joystick::joy_code button, unsigned int joy_index );
      bool button_maintained
      ( input::joystick::joy_code button, unsigned int joy_index );
      bool button_released
      ( input::joystick::joy_code button, unsigned int joy_index );
      bool mouse_pressed
      ( input::mouse::mouse_code key,
        const claw::math::coordinate_2d<unsigned int>& pos );
      bool mouse_released
      ( input::mouse::mouse_code button,
        const claw::math::coordinate_2d<unsigned int>& pos );
      bool mouse_maintained
      ( input::mouse::mouse_code button,
        const claw::math::coordinate_2d<unsigned int>& pos );
      bool mouse_move( const claw::math::coordinate_2d<unsigned int>& pos );

      void erase_effect( std::size_t id );
      std::size_t push_effect( transition_effect* e );

    public:
      /** \brief An invalid value for the identifiers of the effects. */
      static const std::size_t not_an_id;

    private:
      /** \brief The current effect displayed. */
      transition_effect* m_effect;

      /** \brief The identifier of the current effect. */
      std::size_t m_id;

      /** \brief The next available id for the effects. */
      static std::size_t s_next_id;

    }; // class transition_layer
  } // namespace engine
} // namespace bear

#endif // __BEAR_ENGINE_TRANSITION_LAYER_HPP__
