/***************************************************************************
 *   Copyright (C) 2008 George Norton <george_norton_uk@hotmail.com>       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .        *
 ***************************************************************************/
#include "flickrplasmoid.h"
#include <QPainter>
#include <QFontMetrics>
#include <QSizeF>
#include <QDir>

#include <plasma/svg.h>
#include <plasma/theme.h>

// Url to get interesting photos
const QUrl address =  QUrl("http://api.flickr.com/services/rest/?method=flickr.interestingness.getList&api_key=b5acd1e03f7f266caad2d736f25b078d");

// Not currently used
const QUrl nameLookup = QUrl("http://api.flickr.com/services/rest/?method=flickr.people.getInfo&api_key=b5acd1e03f7f266caad2d736f25b078d&user_id"); // need to append user id

const QString homePath="/.flickrPlasmoid/";

FlickrPlasmoid::FlickrPlasmoid(QObject *parent, const QVariantList &args)
    : Plasma::Applet(parent, args),
    m_svg(this),
    m_icon("document")
    {
    state=ELoadingXML;
    m_svg.setImagePath("widgets/background");
    setBackgroundHints(DefaultBackground);
    firstRun=true;
    image=NULL;
    image2=NULL;
    index=0;
    resize(200,50);

    page = new QWebPage();

    // Request the interesting images XML data
    page->mainFrame()->load(address);
    connect(page, SIGNAL(loadFinished(bool)),
         this, SLOT(loaded(bool)));
    timer.start(120000, this); // Refresh every 120 seconds
    }
 
FlickrPlasmoid::~FlickrPlasmoid()
    {
    timer.stop();
    page->triggerAction(QWebPage::Stop);
    
    delete page;
    delete image;
    delete image2;
    }
 
void FlickrPlasmoid::init()
    {
    } 
 
void FlickrPlasmoid::loaded( bool ok)
    {

    // Error! Don't try and render anything
    if(!ok)
      {
      return;
      }

    page->triggerAction(QWebPage::Stop);

    switch (state)
	{
	case ELoadingXML:
	    {
	    // Parse the XML data from flickr
	    QString html = page->mainFrame()->toHtml();
	    list.clear();

	    int images = html.count("<photo id=\"");
	    int startingPoint=0;

	    for(int x=0; x<images; x++)
	      {
	      // Chop the interesting bits out of the xml data.
	      // Not all of this data is used yet.
	      int userId = html.indexOf("<photo id=\"",startingPoint);
	      int owner = html.indexOf("\" owner=\"",startingPoint);
	      int secret = html.indexOf("\" secret=\"",startingPoint);
	      int server = html.indexOf("\" server=\"",startingPoint);
	      int farm = html.indexOf("\" farm=\"",startingPoint);
	      int title = html.indexOf("\" title=\"",startingPoint);
	      int ispublic = html.indexOf("\" ispublic=\"",startingPoint);

	      flickrImage image;

	      // These magic numbers are the lengths of the strings above
	      image.id=html.mid(userId+11,owner-(userId+11));
	      image.secret=html.mid(secret+10,server-(secret+10));
	      image.server=html.mid(server+10,farm-(server+10));
	      image.farm=html.mid(farm+8,title-(farm+8));

	      list.append(image);

	      // shuffle the starting point along
	      startingPoint=ispublic+1;
	      }
	    state=ELoadingImage;
	    }
	// fall through
	case ELoadingImage:
	    {

	    // See if the image is already cached
	    QDir dir;
	    QString cachedImage = QDir::homePath();
	    cachedImage.append(homePath);
	    cachedImage.append(list[index].id);
	    cachedImage.append(".jpg");

	    if(dir.exists(cachedImage))
	      {
	      state=EFinished;

	      delete image2;
	      image2 = new QImage(cachedImage);

	      // Swap buffers
	      resize(image2->size());
	      QImage* tempImage;
	      tempImage=image;
	      image=image2;
	      image2=tempImage;
	      index++;
	      if(index>=list.count())
		{
		index=0;
		}
	      firstRun=false;
	      
	      update();
	      }
	    else
	      {
	      // Fetch the image. We have to hack up some HTML
	      // as QWebPage wont render an image on its own!
	      QString imageAddress="<html><body><div style=\"position:absolute;top:0px;left:0px;right:0px;bottom:0px\"><img src=\"http://farm";
	      imageAddress.append(list[index].farm);
	      imageAddress.append(".static.flickr.com/");
	      imageAddress.append(list[index].server);
	      imageAddress.append("/");
	      imageAddress.append(list[index].id);
	      imageAddress.append("_");
	      imageAddress.append(list[index].secret);
	      imageAddress.append(".jpg\" /></div></body></html>");
	      picUrl=imageAddress;
	      state=ELoadedImage;

	      // This is annoying, the web page content size only gets bigger
	      // this means you start to get a white border around smaller pictures.
	      // Re-constructing the page works around the problem.
	      page->disconnect();
	      delete page;
	      page = new QWebPage();
	      connect(page, SIGNAL(loadFinished(bool)),
		this, SLOT(loaded(bool)));
	      //
	      page->mainFrame()->setHtml(imageAddress);
	      }
	    }
	break;

	case ELoadedImage:
	  {
	  // Resize
	  QSize viewportsize =page->mainFrame()->contentsSize();
	  page->setViewportSize(viewportsize);
	  resize(viewportsize);
	  
	  delete image2;
	  image2 = new QImage(viewportsize, QImage::Format_ARGB32);

	  QPainter painter(image2);
	  page->mainFrame()->render(&painter);
	  painter.end();

	  // Save the image
	  QDir dir;
	  QString cachedImage = QDir::homePath();
	  cachedImage.append(homePath);
	  dir.mkdir(cachedImage);
	  cachedImage.append(list[index].id);
	  cachedImage.append(".jpg");
	  image2->save(cachedImage,NULL,100);

	  index++;
	  if(index>=list.count())
	    {
	    index=0;
	    }
	  // Swap buffers
	  QImage* tempImage;
	  tempImage=image;
	  image=image2;
	  image2=tempImage;

	  firstRun=false;
	  update();
	  state=EFinished;
	  }
	  break;
	default:
	break;
	};
    }
    
void FlickrPlasmoid::paintInterface(QPainter *p,
        const QStyleOptionGraphicsItem* /*option*/, const QRect &contentsRect)
    {
    p->save();
    p->setPen(Qt::white);
    p->setRenderHint(QPainter::SmoothPixmapTransform);
    p->setRenderHint(QPainter::Antialiasing);

    if(firstRun)
	{
	p->drawText(contentsRect,
	    Qt::AlignBottom | Qt::AlignHCenter,
            "Loading... ");  
	}
    else
	{
	p->drawImage(14, 8, image->scaled(QSize((int)contentsRect.width(), (int)contentsRect.height())), Qt::KeepAspectRatio, Qt::SmoothTransformation);
	}

    p->restore();
    }

 void FlickrPlasmoid::timerEvent(QTimerEvent *event)
    {
     // Refresh
     if (event->timerId() == timer.timerId())
	{
	if(state==EFinished)
	  {
	  count++;
	  if(count>=50) // Every 100 minutes, referesh the list of photos
	    {
	    state=ELoadingXML;
	    count=0;
	    }
	  else
	    {
	    state=ELoadingImage;
	    loaded(true);
	    }
	  }
	if(state==ELoadingXML)
	  {
	  // Try to refresh, this way if the user was offline
	  // we can start going when they go online.
	  page->mainFrame()->load(address);
	  }
      } 
      else 
	  {
	  Plasma::Applet::timerEvent(event);
	  }
    }
 
#include "flickrplasmoid.moc"
