/******************************************************************************
*                             plasma-am4rok                                   *
*******************************************************************************
*                                                                             *
*            Copyright (C) 2008 Giulio Camuffo				      *                             *									      *
*                                                                             *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software               *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA  *
*                                                                             *
*                                                                             *
*                                                                             *
*   For further information contact me at giuliocamuffo@gmail.com	      *
******************************************************************************/

#include "mmprogressbar.h"

MMProgressBar::MMProgressBar(QGraphicsItem *parent)
    : QGraphicsProxyWidget(parent)
{
    bar = new QProgressBar();
    bar->setAttribute(Qt::WA_NoSystemBackground);
    setAttribute(Qt::WA_NoSystemBackground);

    setWidget(bar);

    bar->setMinimumHeight(6);

    bar->show();
    show();
}

MMProgressBar::~MMProgressBar(void){
    setWidget(0);
    delete bar;
}

void MMProgressBar::setValue(int value)
{
    bar->setValue(value);
}

void MMProgressBar::setMaxHeight(double height)
{
    if (height >= 6.0)
    {
	bar->show();
	setMaximumHeight(height);
	bar->setMaximumHeight(height);
    }
    else
    {
	if (height >= 4)
	{
	    bar->show();
	    setMaximumHeight(6);
	    bar->setMaximumHeight(6);
	}
	else
	{
	    bar->hide();
	    setMaximumHeight(0);
	}
    }
}


void MMProgressBar::mousePressEvent(QGraphicsSceneMouseEvent *event){
  if (event->buttons() == Qt::LeftButton){
    double _x = event->pos().x();
    double maxX = geometry().width();
    int value = ((_x/maxX)*100.0);
    bar->setValue(value);

    emit valueChanged(value);
  }
}

#include "mmprogressbar.moc"
