/******************************************************************************
*                             plasma-am4rok                                   *
*******************************************************************************
*                                                                             *
*            Copyright (C) 2008 Giulio Camuffo				      *                             *									      *
*                                                                             *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software               *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA  *
*                                                                             *
*                                                                             *
*                                                                             *
*   For further information contact me at giuliocamuffo@gmail.com	      *
******************************************************************************/


#ifndef MMLABEL_H
#define MMLABEL_H

#include <QWidget>
#include <QLabel>
#include <QColor>
#include <QString>
#include <QFont>
#include <QTimer>
#include <QMouseEvent>

class MyQLabel : public QLabel
{
    Q_OBJECT
    
    public :
	MyQLabel(QWidget *parent);
	~MyQLabel(void);

	void mousePressEvent(QMouseEvent *);

    signals:
	void clicked();
};

class MMLabel : public QWidget
{
    Q_OBJECT

    public:
        MMLabel(QWidget *parent);
        ~MMLabel(void);
        enum DIRECTION{
            RIGHT,
            LEFT,
            STOPPED
        };
	void setText(const QString &text);
	QString text(void) const;
	void setColor(const QColor &);
	void setFont(const QFont &font);
	QFont font(void) const;
	void setAlignment(Qt::Alignment align);
	void setScrollStrings(const bool value);
	bool getScrollStrings(void) const;
	void centerLabel(void);

	void resizeEvent(QResizeEvent *);
	void mousePressEvent(QMouseEvent *);
                       
    private slots:
	void moveString(void);
			
    signals:
	void clicked();

    private:
	MyQLabel *label;
	QString color;
	bool scrollString;
	QTimer timer;
	int direction;
	
	void adjustFonts(void);
};

#endif
