/******************************************************************************
*                             plasma-am4rok                                   *
*******************************************************************************
*                                                                             *
*            Copyright (C) 2008 Giulio Camuffo				      *
*                                                                             *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software               *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA  *
*                                                                             *
*                                                                             *
*                                                                             *
*   For further information contact me at giuliocamuffo@gmail.com	      *
******************************************************************************/

#include "mminfodisplay.h"

#include <klocale.h>

MMInfoDisplay::MMInfoDisplay(QWidget *parent)
    : QGroupBox(parent)
{
    
    m_layout = new QGridLayout(this);
    m_layout->setContentsMargins(0,0,0,0);
    m_layout->setSpacing(0);

    setLayout(m_layout);
    setAttribute(Qt::WA_NoSystemBackground);
    setFlat(true);

    time = new MMLabel(this);
    title = new MMLabel(this);
    artist = new MMLabel(this);
    album = new MMLabel(this);
    track = new MMLabel(this);

    connect(time, SIGNAL(clicked()), this,SIGNAL(clicked()));
    connect(title, SIGNAL(clicked()), this,SIGNAL(clicked()));
    connect(artist, SIGNAL(clicked()), this,SIGNAL(clicked()));
    connect(album, SIGNAL(clicked()), this,SIGNAL(clicked()));
    connect(track, SIGNAL(clicked()), this,SIGNAL(clicked()));

    placeObjects();
}

MMInfoDisplay::~MMInfoDisplay(void)
{
    delete time;
    delete artist;
    delete track;
    delete title;
    delete album;
}

void MMInfoDisplay::placeObjects(void)
{

    QLayoutItem *item;
    while ((item = m_layout->takeAt(0)) != 0)
	delete item;

    if (not isOnPanel)
    {
	track->show();
	m_layout->addWidget(title,0,0);
	m_layout->addWidget(artist,1,0);
	m_layout->addWidget(album,2,0);
	m_layout->addWidget(time,3,0);
	m_layout->addWidget(track,4,0);
    }
    else
    {
	if (not isSlim)
	{
	    track->show();
	    m_layout->addWidget(title,0,0,1,2);
	    m_layout->addWidget(artist,1,0,1,2);
	    m_layout->addWidget(album,2,0,1,2);
	    m_layout->addWidget(time,3,0);
	    m_layout->addWidget(track,3,1);
	}
	else{
	    track->hide();
	    m_layout->addWidget(title,0,0);
	    m_layout->addWidget(artist,0,1);
	    m_layout->addWidget(album,2,0);
	    m_layout->addWidget(time,2,1);
	}
    }

    title->setFont(QFont("Helvetica", 7, QFont::Bold));
    artist->setFont(QFont("Helvetica", 7, QFont::Bold));
    album->setFont(QFont("Helvetica", 7, QFont::Bold));
    time->setFont(QFont("Helvetica", 7, QFont::Bold));
    track->setFont(QFont("Helvetica", 7, QFont::Bold));

}

void MMInfoDisplay::setIsOnPanel(bool value, bool slim)
{
    if ((isOnPanel != value) or (isSlim != slim))
    {
	isOnPanel = value;
	isSlim = slim;
	placeObjects();
    }
}

bool MMInfoDisplay::getIsOnPanel(void)
{
    return isOnPanel;
}

void MMInfoDisplay::setScrollStrings(bool value)
{
    title->setScrollStrings(value);
    artist->setScrollStrings(value);
    time->setScrollStrings(value);
    track->setScrollStrings(value);
    album->setScrollStrings(value);
}

bool MMInfoDisplay::getScrollStrings(void)
{
    return title->getScrollStrings();
}

void MMInfoDisplay::setTime(const QString &value){
    time->setText(value);
}

void MMInfoDisplay::setTitle(const QString &value){
  title->setText(value);
}

void MMInfoDisplay::setArtist(const QString &value){
  artist->setText(value);
}

void MMInfoDisplay::setAlbum(const QString &value){
  album->setText(value);
}

void MMInfoDisplay::setTrack(const QString &value){
  track->setText(value);
}

void MMInfoDisplay::setTextColor(QColor color){
    title->setColor(color);
    artist->setColor(color);
    album->setColor(color);
    time->setColor(color);
    track->setColor(color);
    
    textColor = color;
}

QColor MMInfoDisplay::getTextColor(void)
{
    return textColor;
}

void MMInfoDisplay::mousePressEvent(QMouseEvent *event)
{
    if (event->buttons () == Qt::LeftButton)
	emit clicked();
    else
	event->ignore();
}


#include "mminfodisplay.moc"
