/******************************************************************************
*                             plasma-am4rok                                   *
*******************************************************************************
*                                                                             *
*            Copyright (C) 2008 Giulio Camuffo				      *
*	     Copyright (C) 2008 John Varouhakis                               *
*                                                                             *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License         *
*   along with this program; if not, write to the Free Software               *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA  *
*                                                                             *
*                                                                             *
*                                                                             *
*   For further information contact me at giuliocamuffo@gmail.com	      *
******************************************************************************/

/* 25/03/2008 , author Giulio Camuffo 
added some useful methods*/

#ifndef MMINFODIALOG_H
#define MMINFODIALOG_H

#include <QVBoxLayout>

#include <plasma/dialog.h>

#include "mminfodisplay.h"

class MMInfoDialog: public Plasma::Dialog
{
    Q_OBJECT

    public:
        MMInfoDialog(QWidget *parent=0,
                     Qt::WindowFlags f=Qt::Window);
        ~MMInfoDialog(void);

	void setTitle(const QString &title);
	void setTime(const QString &time);
	void setArtist(const QString &artist);
	void setAlbum(const QString &album);
	void setTrack(const QString &track);
	void setTextColor(QColor color);

    private:
	MMInfoDisplay *infoWidget;

	QVBoxLayout *m_lay;

};

#endif




