#include "voiceform.h"
#include <QFile>
#include <KGlobal>

VoiceForm::VoiceForm(QWidget *parent) :
    QWidget(parent),
    m_ui(new Ui::VoiceForm)
{
    m_ui->setupUi(this);
    m_ui->labelIcon->setPixmap(KIcon("help-hint").pixmap(64,64));

    connect(m_ui->radioFestival, SIGNAL(clicked()), this, SLOT(changeCommandLine()));
    connect(m_ui->radioEspeak, SIGNAL(clicked()), this, SLOT(changeCommandLine()));
    connect(m_ui->radioCustom, SIGNAL(clicked()), this, SLOT(changeCommandLine()));

    checkProgram();

   m_ui->radioFestival->setChecked(true);
   changeCommandLine();
}

VoiceForm::~VoiceForm()
{
    delete m_ui;
}

//=====================================================================
void VoiceForm::changeCommandLine(QString cmd)
{

  if ( cmd != QString())
  m_ui->lineEditCommand->setText(cmd);

  if ( m_ui->radioFestival->isChecked ())
  m_ui->lineEditCommand->setText("echo '$RESULT'|festival --tts");

  if ( m_ui->radioEspeak->isChecked ())
  m_ui->lineEditCommand->setText("espeak '$RESULT'");

  if ( m_ui->radioCustom->isChecked ())
  m_ui->lineEditCommand->setText("");

}

//=====================================================================
void VoiceForm::checkProgram()
{

  if (QFile::exists ("/usr/bin/festival")){
    m_ui->radioFestival->setEnabled(true);
    m_ui->labelFestival->setText(i18n("found"));
  }

  else {
    m_ui->labelFestival->setText(i18n("not found.. please install it"));
    m_ui->radioFestival->setEnabled(false);
  }
  if (QFile::exists ("/usr/bin/espeak")){
    m_ui->labelEspeak->setText(i18n("found"));
    m_ui->radioFestival->setEnabled(true);
  }

  else{
    m_ui->labelEspeak->setText(i18n("not found.. please install it"));
    m_ui->radioEspeak->setEnabled(false);
  }
}