/***********************************************************************************
* Run Command: Simple plasmoid to run commands with support for runners.
* Copyright (C) 2008 - 2009 Michal Dutkiewicz aka Emdek <emdeck@gmail.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/

#ifndef RUNCOMMANDAPPLET_HEADER
#define RUNCOMMANDAPPLET_HEADER

#include <QDateTime>
#include <QGraphicsProxyWidget>
#include <QGraphicsSceneMouseEvent>

#include <KHistoryComboBox>

#include <Plasma/Applet>
#include <Plasma/Dialog>
#include <Plasma/QueryMatch>
#include <Plasma/RunnerManager>

#include "ui_results.h"

class RunCommandApplet : public Plasma::Applet
{
    Q_OBJECT

    public:
        RunCommandApplet(QObject *parent, const QVariantList &args);

        void init();

        QList<QAction*> contextualActions();
        bool eventFilter(QObject *object, QEvent *event);

    public slots:
        void constraintsEvent(Plasma::Constraints);
        void focusWidget();
        void clearHistory();
        void resetColor();
        void queryChanged(const QString &query);
        void resultsChanged(const QList<Plasma::QueryMatch> &matches);
        void getCommand();
        void runCommand(QString command);
        void runMatch(const Plasma::QueryMatch &match);
        void updateTheme();
        void toggleEnableRunners(bool enable);

    protected:
        void mousePressEvent(QGraphicsSceneMouseEvent *event);

    private:
        Plasma::Dialog *m_resultsDialog;
        Plasma::RunnerManager *m_manager;
        KHistoryComboBox *m_comboBox;
        QDateTime m_lastRun;
        QAction *m_enableRunnersAction;
        Ui::results m_resultsUi;
};

#endif
