/******************************************************************************
*                                PlayWolf                                     *
*******************************************************************************
*                                                                             *
*                   Copyright (C) 2008-2009 Giulio Camuffo		      *
*                                                                             *
*   This program is free software; you can redistribute it and/or modify      *
*   it under the terms of the GNU General Public License as published by      *
*   the Free Software Foundation; either version 2 of the License, or         *
*   (at your option) any later version.                                       *
*                                                                             *
*   This program is distributed in the hope that it will be useful,           *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of            *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
*   GNU General Public License for more details.                              *
*                                                                             *
*   You should have received a copy of the GNU General Public License along   *
*   with this program; if not, write to the Free Software Foundation, Inc.,   *
*   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA                *
*                                                                             *
*                                                                             *
*                                                                             *
*   For further information contact me at giuliocamuffo@gmail.com	      *
******************************************************************************/

#ifndef PLAYERCONTROLLER_H
#define PLAYERCONTROLLER_H

#include <QtCore/QVariantMap>
#include <QTimer>
#include <QDBusInterface>

struct Status{
  int int1;
  int int2;
  int int3;
  int int4;
};

class QStringList;

class PlayerController : public QObject
{
    Q_OBJECT

    public:
	static PlayerController* self();
	static void registerPlayWolfInstance();
	static void destroy();

	Status getStatus(void);
	void updateInfos();
	void seekForward(int seconds);
	void seekBack(int seconds);
	int volume(void);
	void volumeUp(void);
	void volumeDown(void);
	int rating(void);
	QVariantMap getMetadata(void);
	QVariantMap getSongMetadata(int song);
	QStringList getPlaylist(int start = 0, int numSongs = -1);
	int getSongPosition();
	void setAmarokPath(bool useCustom, QString& path);
	QString& amarokPath(void);
	bool useCustomAmarokPath(void);
	int getPosition(void);
	void executeAmarok(void);

    public slots:
	void playPause(void);
	void stop(void);
	void prev(void);
	void next(void);
	void showAmarok(void);
	void seek(const int pos);
	void setVolume(int volume);

    private slots:
	void updatePosition(void);
	void updatePlaylist(const int& size = 0);
	void statusChange(const Status &status);
	void trackChange(const QVariantMap &meta);

    signals:
	void metadataChanged(const QVariantMap& metadata);
	void statusChanged(const int& status);
	void positionChanged(const int& position, const int& time);
	void playlistChanged(const QStringList& playlist);
	void clear(void);

    private:
	PlayerController();
	~PlayerController();
	static PlayerController* instance;
	static int m_playWolfInstancesCounter;

	void playerQuery(const QString &query);
	void playerQuery(const QString &query, const int);
	int playerIntQuery(const QString &query);
	int playlistIntQuery(const QString &query);

	QDBusInterface *amarokTracklistDbus;
	QDBusInterface *amarokPlayerDbus;
	QVariantMap metadata;
	QTimer timer;
	bool useCustomAmarokBinPath;
	QString customAmarokBinPath;
};

#endif
