/***********************************************************************************
* Mem Usage: Plasmoid to monitor RAM/Swap Usage.
* Copyright (C) 2008  Alexey Tyapkin
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/
// Here we avoid loading the header multiple times
#ifndef MEMUSAGE_HEADER
#define MEMUSAGE_HEADER
// We need the Plasma Applet headers
#include <KIcon>
 
#include <Plasma/Applet>
#include <Plasma/Svg>
#include <Plasma/DataEngine>
#include <QFont>
#include <QPixmap>
#include <QBitmap>
#include <QBrush>
#include <QPen>
#include <QVector>
#include <QRect>
#include <QPainter>

#include "ui_memUsageSettings.h"
 
class QSizeF;
class QString;
 
// Define our plasma Applet
class memusage : public Plasma::Applet
{
    Q_OBJECT
    public:
	enum {
	width	= 300,
	height	= 120,
	fontSize = 8,
	cTitle	= 0xffffff,
	cFree	= 0x418DD4,
	cUsed	= 0xFF80E0,
	cBuffers = 0x888786,
	cCached = 0xE0DFDF,
	Border	= 0xC0DAFF
	};

	static const QString defaultFontFamily;

        // Basic Create/Destroy
        memusage(QObject *parent, const QVariantList &args);
        ~memusage();
 
        // The paintInterface procedure paints the applet to screen
        void paintInterface(QPainter *painter,
                const QStyleOptionGraphicsItem *option,
                const QRect& contentsRect);
	void init();
	void resizePixmaps();
	void updatePixmaps();
	void updatePie(QPainter *p, int iiRamUsed, int iiRamUsed1, int iiRamCached, int iiRamCached1, int iiRamBuffers,int iiRamBuffers1, int iiRamTotal, QRect ppieRect, QBrush* bbrushes);
	void plasmoidToCfg();
	void defaultsToCfg ();
	void drawGridAndText(QPainter *p, int iiWidth, int iiHeight, QColor cGrid, QFont f, QPen* ppens);
	void drawRamInfo(QPainter *p, QPen* ppens, QRect* rramRects);
	void drawSwapInfo(QPainter *p, QPen* ppens, QRect* sswapRects);

protected:
	void readConfig();
	void writeConfig();


public slots:
	void showConfigurationInterface();
	void cfgToPlasmoid();
	void updatePreview();
	void clicked ( QAbstractButton *button);


protected slots:
        void dataUpdated(const QString& source, const Plasma::DataEngine::Data &data);

    private:
        KIcon m_icon;
	QPixmap Ram;
	QPixmap Swap;

	int iRamTotal;
	int iRamUsed,iRamUsed1;
	int iRamBuffers,iRamBuffers1;
	int iRamCached,iRamCached1;
	int uRamFree,uRamUsed,uRamBuffers,uRamCached;

	int iSwapTotal;
	int iSwapUsed,iSwapUsed1;
	int uSwapFree,uSwapUsed,uSwapBuffers,uSwapCached;
	int iFontSize;

	QFont plasmoidFont;
	QString ramInfo[5][2];
	QRect ramRects[5];
	QString swapInfo[3][2];
	QRect swapRects[3];
	QRect pieRect;
	QPen pens[5];
	QBrush brushes[5];
	QColor cBorder;

	QDialog	*cfg_dialog;
	Ui_memUsageSettings cfg;
	QPixmap preview;

	QPixmap dpm,dpm1;
	QBitmap maskRam;
	QBitmap maskSwap;
	QVector<int> iUsage;

	int iHeight;
	int iWidth;
};
 
const QString memusage::defaultFontFamily="DejaVu Sans";

// This is the command that links your applet to the .desktop file
K_EXPORT_PLASMA_APPLET(memusage, memusage)
#endif
