#ifndef FEEDBACK_PLASMOID_HEADER
#define FEEDBACK_PLASMOID_HEADER

#include <KProcess>

#include <Plasma/PopupApplet>

class QGraphicsLinearLayout;
class QUrl;

namespace Plasma
{
    class Meter;
    class WebView;
}

class Feedback : public Plasma::PopupApplet
{
    Q_OBJECT

    public:
	Feedback( QObject *parent, const QVariantList &args );
	~Feedback();

	QGraphicsWidget* graphicsWidget();
	void init();

    public slots:
	void updateMeter( int progress );

    private slots:
	void executeCommand();
	void gotStdOut();
	void loadUrl();

    private:
	QGraphicsLinearLayout *m_layout;
	QGraphicsWidget *m_graphicsWidget;
	Plasma::WebView *m_webView;
	Plasma::Meter *m_meter;
	KProcess m_proc;
	QString m_output;
	QString m_command;
	QUrl m_url;
};

K_EXPORT_PLASMA_APPLET( feedback, Feedback )
#endif
