/********************************************************************************
 *   Copyright (C) 2008-2009 by Bram Schoenmakers <bramschoenmakers@kde.nl>     *
 *                                                                              *
 *   This program is free software; you can redistribute it and/or modify       *
 *   it under the terms of the GNU General Public License as published by       *
 *   the Free Software Foundation; either version 2 of the License, or          *
 *   (at your option) any later version.                                        *
 *                                                                              *
 *   This program is distributed in the hope that it will be useful,            *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *   GNU General Public License for more details.                               *
 *                                                                              *
 *   You should have received a copy of the GNU General Public License          *
 *   along with this program; if not, write to the                              *
 *   Free Software Foundation, Inc.,                                            *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .             *
 ********************************************************************************/

#ifndef FLICKR_ENGINE_H
#define FLICKR_ENGINE_H

#include <QDomDocument>

#include <KUrl>
#include <Plasma/DataEngine>

#include "types.h"

class KJob;

class FlickrEngine : public Plasma::DataEngine
{
  Q_OBJECT

  Q_PROPERTY( Plasma::DataEngine::Data config READ config WRITE setConfig )
public:
  FlickrEngine( QObject *p_parent, const QVariantList &p_args );
  ~FlickrEngine();

  Plasma::DataEngine::Data config() const;
  void setConfig( const Plasma::DataEngine::Data &p_config );

protected:
  void checkToken();
  static KUrl constructApiUrl( Params &p_arguments, bool p_signed );
  KUrl constructPhotoURL( const QString &p_id, const QString &p_farm, const QString &p_server, const QString &p_secret );
  static QString hashPhoto( const Photo &p_photo );
  void init();
  void processList( const QDomDocument &p_doc );
  void processPhoto( const QDomNode &p_photo );
  bool processResponse( KJob *p_job, QDomDocument *p_doc );
  void retrieveAuthor( const Photo &p_photo );
  void retrievePhoto( const Photo &p_photo );
  void retrievePhotos();
  void retrievePhotoset( const QString &p_photoset_id );
  void retrieveUserFavoriteList();
  void retrieveInterestingnessList();
  void setError( const QString &p_error, ErrorType p_type = ERR_ANY );
  void setPhoto( const Photo &p_photo );
  static QString signCall( const Params &p_arguments );

protected slots:
  void authorJobDone( KJob *p_job );
  void cleanCache();
  void clusterJobDone( KJob *p_job );
  void continueAuthentication();
  void frobJobDone( KJob *p_job );
  void listJobDone( KJob *p_job );
  void markAsFavorite();
  void nextPhoto();
  void nsidJobDone( KJob *p_job );
  void photoJobDone( KJob *p_job );
  void photosetJobDone( KJob *p_job );
  void retrieveClusters( const QString &p_tag );
  void retrieveNSID( const QString &p_username );
  void retrievePhotosets( const QString &p_nsid = QString::null );
  void retrievePhotosByCluster( const QString &p_tag, const QString &p_cluster_id );
  void startAuthentication();
  void tokenCheckDone( KJob *p_job );
  void tokenJobDone( KJob *p_job );

private:
  Plasma::DataEngine::Data m_config;
  PhotoList m_photos;
  PhotoList::iterator m_photo_it;
  QTimer *m_timer;
  QString m_size;
  // here the frob is stored during the authentication.
  // More specifically, to keep it between startAuthentication() and continueAuthentication().
  QString m_frob;
  QString m_token;
  QString m_nsid;
  PhotoListType m_type;
};

#endif // FLICKR_OP_ENGINE_H
