/* Plagiat gallery creation tool for Jakub Steiner's O.R.I.G.I.N.A.L 
 * photo gallery.
 * Copyright (C) 2005 Robert Staudinger <robert.staudinger@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */


#ifndef __PGT_VIEW_H__
#define __PGT_VIEW_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "pgt-galleries.h"
#include "pgt-mainwin.h"
#include "pgt-prefs.h"

G_BEGIN_DECLS

#define PGT_TYPE_VIEW                  (pgt_view_get_gtype ())
#define PGT_VIEW(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), PGT_TYPE_VIEW, PgtView))
#define PGT_VIEW_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), PGT_TYPE_VIEW, PgtViewClass))
#define PGT_IS_VIEW(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PGT_TYPE_VIEW))
#define PGT_IS_VIEW_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), PGT_TYPE_VIEW))
#define PGT_VIEW_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), PGT_TYPE_VIEW, PgtViewClass))

typedef struct _PgtView PgtView;
typedef struct _PgtViewClass PgtViewClass;

GType pgt_view_get_gtype (void);

PgtView* pgt_view_new (void);
void	 pgt_view_create_mainwin (PgtView *self);

/* main window */
gchar const * pgt_view_get_gallery_name (PgtView *self);
gchar const * pgt_view_get_album_name (PgtView *self);
gchar const * pgt_view_get_album_date (PgtView *self);
gchar const * pgt_view_get_album_desc (PgtView *self);
gchar const * pgt_view_get_photo_dir (PgtView *self);
gboolean      pgt_view_get_option (PgtView *self, PgtConvertOption opt);

void pgt_view_set_progress_value (PgtView *self, gfloat val);
void pgt_view_set_progress_text (PgtView *self, gchar const *text);

/* gallery window */
gchar const * pgt_view_gallery_get_name (PgtView *self);
gchar const * pgt_view_gallery_get_url (PgtView *self);
gchar*        pgt_view_gallery_get_selected_name (PgtView *self);

/* only called from model */
void pgt_view_internal_set_gallery_store (PgtView *self, GtkTreeModel *gallery_store);

G_END_DECLS

#endif /* __PGT_VIEW_H__ */
