/* Plagiat gallery creation tool for Jakub Steiner's O.R.I.G.I.N.A.L 
 * photo gallery.
 * Copyright (C) 2005 Robert Staudinger <robert.staudinger@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <string.h>
#include <gtk/gtk.h>
#include "pgt-model.h"
#include "pgt-utils.h"

struct _PgtModel {
	GObject parent;
	gboolean is_disposed;
	PgtView *view;
	GtkTreeModel *gallerystore;
};

struct _PgtModelClass {
	GObjectClass parent;
};

/* properties */
enum {
	_PROP_0,
	PROP_VIEW,
	_NUM_PROPS
};

static GObjectClass *pgt_model_parent_class = NULL;

static void
instance_init (PgtModel *self)
{
	self->is_disposed = FALSE;
	self->view = NULL;

	self->gallerystore = (GtkTreeModel *) gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);	
	/* g_object_ref_sink (self->gallerystore); */
}

static void
instance_dispose (GObject *instance)
{
	PgtModel *self = PGT_MODEL (instance);

	if (self->is_disposed)
		return;

	self->is_disposed = TRUE;

	if (self->view) {
		g_object_unref (self->view);
		self->view = NULL;
	}
	if (self->gallerystore) {
		g_object_unref (self->gallerystore);
		self->gallerystore = NULL;
	}

	pgt_model_parent_class->dispose (G_OBJECT (self));
}

static void
set_property (GObject      *object,
	      guint         prop_id,
	      GValue const *value,
	      GParamSpec   *pspec)
{
	PgtModel *self = PGT_MODEL (object);
	gpointer *p = NULL;

	switch (prop_id) {
	case PROP_VIEW:
		p = g_value_get_object (value);
		if (p) {
			self->view = PGT_VIEW (p);
			g_object_ref (self->view);
			pgt_view_internal_set_gallery_store (self->view, self->gallerystore);
		}
		else if (self->view) {
			g_object_unref (self->view);
			self->view = NULL;
		}
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
	}
}

static void
get_property (GObject    *object,
	      guint       prop_id,
	      GValue     *value,
	      GParamSpec *pspec)
{
	PgtModel *self = PGT_MODEL (object);

	switch (prop_id) {
	case PROP_VIEW:
		g_value_set_pointer (value, (gpointer) self->view);
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
	}
}

static void
class_init (PgtModelClass *klass)
{
	GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

	/* hook gobject vfuncs */
	gobject_class->dispose = instance_dispose;

	pgt_model_parent_class = (GObjectClass*) g_type_class_peek_parent (klass);

	gobject_class->set_property = set_property;
	gobject_class->get_property = get_property;

	g_object_class_install_property (gobject_class,
		PROP_VIEW,
		g_param_spec_object ("view", "View Pointer",
			"Pointer to view instance", PGT_TYPE_VIEW,
			(GParamFlags)(G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY)));
}

GType
pgt_model_get_gtype (void)
{
        static GType type = 0;
        if (!type) {
                static const GTypeInfo info = {
                        sizeof (PgtModelClass),
                        NULL,           /* base_init */
                        NULL,           /* base_finalize */
                        (GClassInitFunc) class_init,
                        NULL,           /* class_finalize */
                        NULL,           /* class_data */
                        sizeof (PgtModel),
                        0,              /* n_preallocs */
                        (GInstanceInitFunc) instance_init,
                };
                type = g_type_register_static (G_TYPE_OBJECT, "PgtModel", &info, (GTypeFlags)0);
        }
        return type;
}

PgtModel*   
pgt_model_new (PgtView *view)
{
	return PGT_MODEL (g_object_new (PGT_TYPE_MODEL, 
					"view", view, 
					NULL));
}

gchar const * 
pgt_model_get_gallery_name (PgtModel *self)
{
	return pgt_view_get_gallery_name (self->view);
}

gchar const * 
pgt_model_get_album_name (PgtModel *self)
{
	return pgt_view_get_album_name (self->view);
}

gchar const * 
pgt_model_get_album_date (PgtModel *self)
{
	return pgt_view_get_album_date (self->view);
}

gchar const * 
pgt_model_get_album_desc (PgtModel *self)
{
	return pgt_view_get_album_desc (self->view);
}

gchar const * 
pgt_model_get_photo_dir (PgtModel *self)
{
	return pgt_view_get_photo_dir (self->view);
}

gboolean      
pgt_model_get_option (PgtModel *self, PgtConvertOption opt)
{
	return pgt_view_get_option (self->view, opt);
}

gboolean 
pgt_model_add_gallery (PgtModel    *self,
		       gchar const *name, 
		       gchar const *url)
{
	GtkTreeIter iter;

	if (!(name && url)) {
		return FALSE;
	}

	gtk_list_store_append (GTK_LIST_STORE (self->gallerystore), &iter);
	gtk_list_store_set (GTK_LIST_STORE (self->gallerystore), &iter, 0, name, 1, url, -1);

	return TRUE;
}

gboolean 
pgt_model_del_gallery (PgtModel *self, 
		       gchar const *name)
{
	GtkTreeIter iter;
	gboolean ret = FALSE;

	if (gtk_tree_model_get_iter_first (GTK_TREE_MODEL (self->gallerystore), &iter)) {
		gchar *s = NULL;
		do {
			gtk_tree_model_get (GTK_TREE_MODEL (self->gallerystore), &iter, 0, &s, -1);
			if (0 == strcmp (name, s)) {
				gtk_list_store_remove (GTK_LIST_STORE (self->gallerystore), &iter);
				g_free (s);
				s = NULL;
				ret = TRUE;
				break;
			}
			g_free (s);
			s = NULL;
		} while (gtk_tree_model_iter_next (GTK_TREE_MODEL (self->gallerystore), &iter));
	}

	return ret;
}
