/* Plagiat gallery creation tool for Jakub Steiner's O.R.I.G.I.N.A.L 
 * photo gallery.
 * Copyright (C) 2005 Robert Staudinger <robert.staudinger@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <glade/glade.h>
#include "pgt-galleries.h"
#include "pgt-utils.h"

struct _PgtGalleries {
	GObject parent;
	gboolean is_disposed;
	GladeXML *xml;
	GtkWidget *win;
	GtkWidget *galleryentry;
	GtkWidget *urlentry;
	GtkWidget *addbtn;
	GtkWidget *gallerylist;
	GtkWidget *delbtn;
	GtkWidget *closebtn;
};

struct _PgtGalleriesClass {
	GObjectClass parent;
	/* signals */
	void (* add_gallery) (PgtGalleries *self);
	void (* del_gallery) (PgtGalleries *self);
	void (* delete) (PgtGalleries *self);
};

/* signals */
enum {
	ADD_GALLERY,
	DEL_GALLERY,
	DELETE,
	_LAST_SIGNAL
};

/* properties */
enum {
	_PROP_0,
	PROP_GALLERY_STORE,
	_NUM_PROPS
};

static guint 	     pgt_galleries_signals[_LAST_SIGNAL] = { 0 };
static GObjectClass *pgt_galleries_parent_class = NULL;


static void
close_cb (PgtGalleries *self, 
	  GtkButton *button)
{
	g_assert (GTK_IS_WINDOW (self->win));
	gtk_widget_destroy (self->win);
}

static void
add_gallery_cb (PgtGalleries  *self, 
		GtkToolButton *widget)
{
	g_signal_emit (self, pgt_galleries_signals[ADD_GALLERY], 0);
}

static void
del_gallery_cb (PgtGalleries  *self, 
		GtkToolButton *widget)
{
	g_signal_emit (self, pgt_galleries_signals[DEL_GALLERY], 0);
}

static void
delete_cb (PgtGalleries *self,
	   GtkWidget    *widget,
	   GdkEvent     *event)
{
	g_signal_emit (self, pgt_galleries_signals[DELETE], 0);
}

static void
instance_init (PgtGalleries *self)
{
	GtkWidget *entrybox = NULL;
	GtkWidget *listbox = NULL;
	GtkTreeViewColumn *column = NULL;

	self->is_disposed = FALSE;

	if (pgt_runs_from_srcdir ()) {
		self->xml = glade_xml_new ("../data/mainwin.glade", NULL, NULL); 
	}
	else {
		self->xml = glade_xml_new (PLAGIAT_DATADIR "/mainwin.glade", NULL, NULL);
	}
	self->win = glade_xml_get_widget (self->xml, "gallerywin");
	gtk_window_set_modal (GTK_WINDOW (self->win), TRUE);	

	entrybox = glade_xml_get_widget (self->xml, "entrybox");

	self->galleryentry = glade_xml_get_widget (self->xml, "galleryentry");
	self->urlentry = glade_xml_get_widget (self->xml, "urlentry");

	self->addbtn = (GtkWidget *) gtk_tool_button_new_from_stock (GTK_STOCK_ADD);
	gtk_box_pack_start (GTK_BOX (entrybox), GTK_WIDGET (self->addbtn), FALSE, FALSE, 0);

	listbox = glade_xml_get_widget (self->xml, "listbox");

	self->gallerylist = glade_xml_get_widget (self->xml, "gallerylist");
	column = gtk_tree_view_column_new_with_attributes (_("Name"), 
							   gtk_cell_renderer_text_new (), 
							   "text", 0, 
							   NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (self->gallerylist), column);
	gtk_tree_view_column_set_visible (column, TRUE);
	column = gtk_tree_view_column_new_with_attributes (_("URL"), 
							   gtk_cell_renderer_text_new (), 
							   "text", 1, 
							   NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (self->gallerylist), column);
	gtk_tree_view_column_set_visible (column, TRUE);

	self->delbtn = (GtkWidget *) gtk_tool_button_new_from_stock (GTK_STOCK_REMOVE);
	gtk_box_pack_start (GTK_BOX (listbox), GTK_WIDGET (self->delbtn), FALSE, FALSE, 0);

	self->closebtn = glade_xml_get_widget (self->xml, "closebtn");
	g_signal_connect_swapped (self->closebtn, "clicked", G_CALLBACK (close_cb), self);


	g_signal_connect_swapped (self->addbtn, "clicked", 
				  G_CALLBACK (add_gallery_cb), self);
	g_signal_connect_swapped (self->delbtn, "clicked", 
				  G_CALLBACK (del_gallery_cb), self);
	g_signal_connect_swapped (self->win, "delete-event", 
				  G_CALLBACK (delete_cb), self);
}

static void
instance_dispose (GObject *instance)
{
	PgtGalleries *self = PGT_GALLERIES (instance);

	if (self->is_disposed)
		return;

	self->is_disposed = TRUE;
	g_object_unref (self->xml);
	self->xml = NULL;

	pgt_galleries_parent_class->dispose (G_OBJECT (self));
}

static void
set_property (GObject      *object,
	      guint         prop_id,
	      GValue const *value,
	      GParamSpec   *pspec)
{
	PgtGalleries *self = PGT_GALLERIES (object);
	GtkTreeModel *gallerystore = NULL;
	gpointer *p = NULL;

	switch (prop_id) {
	case PROP_GALLERY_STORE:
		p = g_value_get_object (value);
		if (p) {
			gallerystore = GTK_TREE_MODEL (p);
			gtk_tree_view_set_model (GTK_TREE_VIEW (self->gallerylist), gallerystore);
		}
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
	}
}

static void
get_property (GObject    *object,
	      guint       prop_id,
	      GValue     *value,
	      GParamSpec *pspec)
{
	PgtGalleries *self = PGT_GALLERIES (object);

	switch (prop_id) {
	case PROP_GALLERY_STORE:
		g_value_set_pointer (value, gtk_tree_view_get_model (GTK_TREE_VIEW (self->gallerylist)));
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
	}
}

static void
class_init (PgtGalleriesClass *klass)
{
	GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

	/* hook gobject vfuncs */
	gobject_class->dispose = instance_dispose;

	pgt_galleries_parent_class = (GObjectClass*) g_type_class_peek_parent (klass);

	gobject_class->set_property = set_property;
	gobject_class->get_property = get_property;

	pgt_galleries_signals [ADD_GALLERY] =
		g_signal_new (
			"add-gallery",
			G_OBJECT_CLASS_TYPE (klass),
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (PgtGalleriesClass, add_gallery),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);

	pgt_galleries_signals [DEL_GALLERY] =
		g_signal_new (
			"del-gallery",
			G_OBJECT_CLASS_TYPE (klass),
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (PgtGalleriesClass, del_gallery),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);

	pgt_galleries_signals [DELETE] =
		g_signal_new (
			"delete",
			G_OBJECT_CLASS_TYPE (klass),
			G_SIGNAL_RUN_LAST,
			G_STRUCT_OFFSET (PgtGalleriesClass, delete),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);


	g_object_class_install_property (gobject_class,
		PROP_GALLERY_STORE,
		g_param_spec_object ("gallery-store", "Gallery Store",
			"GtkListStore for galleries", GTK_TYPE_TREE_MODEL,
			(GParamFlags)(G_PARAM_READWRITE | G_PARAM_CONSTRUCT_ONLY)));
}

GType
pgt_galleries_get_gtype (void)
{
        static GType type = 0;
        if (!type) {
                static const GTypeInfo info = {
                        sizeof (PgtGalleriesClass),
                        NULL,           /* base_init */
                        NULL,           /* base_finalize */
                        (GClassInitFunc) class_init,
                        NULL,           /* class_finalize */
                        NULL,           /* class_data */
                        sizeof (PgtGalleries),
                        0,              /* n_preallocs */
                        (GInstanceInitFunc) instance_init,
                };
                type = g_type_register_static (G_TYPE_OBJECT, "PgtGalleries", &info, (GTypeFlags)0);
        }
        return type;
}

PgtGalleries*   
pgt_galleries_new (GtkTreeModel *gallerystore)
{
	PgtGalleries *galleries = PGT_GALLERIES (g_object_new (PGT_TYPE_GALLERIES, 
						 "gallery-store", gallerystore, 
						 NULL));
	return galleries;
}

GtkWidget* 
pgt_galleries_get_window (PgtGalleries *self)
{
	return self->win;
}

gchar const * 
pgt_galleries_get_name (PgtGalleries *self)
{
	g_assert (GTK_IS_ENTRY (self->galleryentry));
	return gtk_entry_get_text (GTK_ENTRY (self->galleryentry));
}

gchar const * 
pgt_galleries_get_url (PgtGalleries *self)
{
	/*
	GtkEntry *entry = GTK_ENTRY (glade_xml_get_widget (self->xml, "urlentry"));
	return gtk_entry_get_text (entry);
	*/
	g_assert (GTK_IS_ENTRY (self->urlentry));
	return gtk_entry_get_text (GTK_ENTRY (self->urlentry));
}

gchar * 
pgt_galleries_get_selected_name (PgtGalleries *self)
{
	GtkTreeModel *model = gtk_tree_view_get_model (GTK_TREE_VIEW (self->gallerylist));
	GtkTreeSelection *selection = gtk_tree_view_get_selection (GTK_TREE_VIEW (self->gallerylist));
	GtkTreeIter iter;
	gboolean have_selected;
	gchar *value = NULL;

	have_selected = gtk_tree_selection_get_selected (selection, &model, &iter);
	if (have_selected) {
		gtk_tree_model_get (model, &iter, 0, &value, -1);
	}

	return value;
}

void 
pgt_galleries_set_model (PgtGalleries *self, 
			 GtkTreeModel *model)
{
	GtkTreeModel *m = gtk_tree_view_get_model (GTK_TREE_VIEW (self->gallerylist));
	if (model != m) {
		gtk_tree_view_set_model (GTK_TREE_VIEW (self->gallerylist), model);
	}
}
