/* Plagiat gallery creation tool for Jakub Steiner's O.R.I.G.I.N.A.L 
 * photo gallery.
 * Copyright (C) 2005 Robert Staudinger <robert.staudinger@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include <gsf/gsf-utils.h>
#include <gtk/gtk.h>
#include <glade/glade.h>
#include "pgt-controller.h"
#include "pgt-model.h"
#include "pgt-view.h"
#include "pgt-utils.h"

int
main (int argc, char *argv[])
{
	PgtController *controller  = NULL;
	PgtModel *model = NULL;
	PgtView *view = NULL;

	gsf_init ();
	gdk_init (&argc, &argv);
	gtk_init (&argc, &argv);
	glade_init ();

	bindtextdomain (GETTEXT_PACKAGE, PLAGIATLOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);

	view = pgt_view_new ();
	model = pgt_model_new (view);
	controller = pgt_controller_new (model, view);

	pgt_controller_read_config (controller);
	pgt_view_create_mainwin (view);

	gtk_main ();
	return 0;
}
