#! /bin/sh

PATH=/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/sbin/pkspxy
NAME=pkspxy
DESC="PGP key server proxy"
PIDFILE=/var/run/$NAME.pid
CONFIGFILE=/etc/pkspxy.conf

OFFLINE="-o"

test -f $DAEMON || exit 0

set -e

case "$1" in
  start)
	echo -n "Starting $DESC: "
	su pkspxy -c "/sbin/start-stop-daemon --start --quiet \
	    --pidfile $PIDFILE --exec $DAEMON -- $OFFLINE -F $CONFIGFILE" \
	    > $PIDFILE
	echo "$NAME."
	;;
  stop)
	echo -n "Stopping $DESC: "
	start-stop-daemon --stop --oknodo --quiet --pidfile $PIDFILE \
	    --exec $DAEMON
	rm -f $PIDFILE
	echo "$NAME."
	;;
  restart|force-reload)
	sh $0 stop
	sh $0 start
	;;
  *)
	N=/etc/init.d/$NAME
	echo "Usage: $N {start|stop|restart|force-reload}" >&2
	exit 1
	;;
esac

exit 0
