#ifndef __KIF_EDITMENU_H
#define __KIF_EDITMENU_H

#include "browser.h"
#include <kpopupmenu.h>

class UIManager;
void viewRightClickMenu(const QString &currentDir, UIManager *mgr,
                        PixieBrowser *view, const QPoint &pos);
void iconRightClickDelete(const QString &currentDir, PixieBrowser *view);


class EditMenu : public KPopupMenu
{
    Q_OBJECT
public:
    EditMenu(UIManager *manager, QWidget *parent=0, const char *name=0);
    void execItem(Thumbnail *i, const QPoint &pos);
protected slots:
    void aboutToShowSlot();
    void aboutToHideSlot();
    void activatedSlot(int id);
protected:
    UIManager *mgr;
    PixieBrowser *view;
    Thumbnail *current;
    QPopupMenu *addMnu, *delMnu;
};

#endif

