#include "completion.h"
#include "browser.h"
#include <qfileinfo.h>
#include <qdir.h>

PixieComp::PixieComp(PixieBrowser *b)
{
    browser = b;
    setCompletionMode(KGlobalSettings::CompletionShell);
    setOrder(KCompletion::Insertion);
}

PixieComp::~PixieComp()
{
    ;
}

QString PixieComp::makeCompletion(const QString &str)
{
    QFileInfo info(str);
    info.convertToAbs();
    QString pathStr = info.dirPath();

    if(pathStr != currentPath){
        QStringList list;
        if(browser->absPath() == pathStr && !browser->nameFiltered()){
            int i;
            Thumbnail *items = browser->allItems();
            int c = browser->count();
            for(i=0; i < c && items[i].isDir; ++i)
                list.append(pathStr + "/" + items[i].filename);
        }
        else{
            unsigned int i;
            QDir dir(pathStr, QString::null, QDir::Name, QDir::Dirs);
            for(i=0; i < dir.count(); ++i){
                if(dir[i] != "." && dir[i] != "..")
                    list.append(pathStr+"/"+dir[i]);
            }
        }
        setItems(list);
        currentPath = pathStr;
    }
    return(KCompletion::makeCompletion(str));
}

