#ifndef __KIF_BORDER_H
#define __KIF_BORDER_H

#include <qimage.h>
#include <qdialog.h>
#include <qlabel.h>
#include <qbuttongroup.h>
#include <knuminput.h>
#include <kcolorbutton.h>

enum BorderType{Solid=0, Bevel, Liquid, RoundCorner};

class KIFBorderDialog : public QDialog
{
    Q_OBJECT
public:
    KIFBorderDialog(QWidget *parent=0, const char *name=0);
    BorderType borderType(){return((BorderType)btnGrp->id(btnGrp->selected()));}
    int borderWidth(){return(widthInput->value());}
    QColor fgColor(){return(fgBtn->color());}
    QColor bgColor(){return(bgBtn->color());}
public slots:
    void slotBorderType(int type);
    void slotBorderWidth(int w);
    void slotBorderFg(const QColor &c);
    void slotBorderBg(const QColor &c);
protected:
    void updatePreview();

    QButtonGroup *btnGrp;
    KIntNumInput *widthInput;
    KColorButton *fgBtn, *bgBtn;
    QLabel *preview, *fgLbl, *bgLbl;
};

class KIFBorderEffect
{
public:
    static bool solid(QImage &src, QImage &dest, const QColor &fg,
                      int width);
    // minimum width == 3
    static bool liquid(QImage &src, QImage &dest, const QColor &fg,
                       const QColor &bg, int width);
    static bool bevel(QImage &src, QImage &dest, const QColor &topColor,
                      const QColor &btmColor, int width);
    static bool roundCorner(QImage &src, QImage &dest, const QColor &bg);
};

#endif

