#include "attributedialog.h"
#include <knuminput.h>
#include <kseparator.h>
#include <kbuttonbox.h>
#include <klocale.h>
#include <qtextedit.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpushbutton.h>

KIFAttributeDialog::KIFAttributeDialog(bool supportComment, QWidget *parent,
                                       const char *name)
    : QDialog(parent, name, true)
{
    QVBoxLayout *layout = new QVBoxLayout(this, 5, 5);
    QLabel *lbl = new QLabel(i18n("Please select the image quality you wish to use:"), this);
    layout->addWidget(lbl);
    layout->addSpacing(10);
    lbl = new QLabel(i18n("0: Highest compression/least quality,"), this);
    layout->addWidget(lbl);
    lbl = new QLabel(i18n("100: Lowest compression/best quality"), this);
    layout->addWidget(lbl);
    qualityInput = new KIntNumInput(75, this);
    qualityInput->setRange(0, 100);
    qualityInput->setLabel(i18n("Quality"));
    layout->addWidget(qualityInput);

    if(!supportComment)
        commentEdit = NULL;
    else{
        layout->addWidget(new KSeparator(Qt::Horizontal, this));
        lbl = new QLabel(i18n("Image comment:"), this);
        layout->addWidget(lbl);
        commentEdit = new QTextEdit(this);
        commentEdit->setTextFormat(Qt::PlainText);
        commentEdit->setText("Created with PixiePlus - http://www.mosfet.org");
        layout->addWidget(commentEdit);
    }

    layout->addWidget(new KSeparator(Qt::Horizontal, this));
    KButtonBox *bbox = new KButtonBox(this);
    bbox->addStretch(1);
    connect(bbox->addButton(i18n("OK")), SIGNAL(clicked()), this,
            SLOT(accept()));
    connect(bbox->addButton(i18n("Cancel")), SIGNAL(clicked()), this,
            SLOT(reject()));
    layout->addWidget(bbox);
    setCaption(i18n("File Save Options"));
}

int KIFAttributeDialog::quality()
{
    return(qualityInput->value());
}

QString KIFAttributeDialog::comment()
{
    return(commentEdit ? commentEdit->text() : QString::null);
}

