<?php
// +-----------------------------------------------------------------------+
// | Piwigo - a PHP based picture gallery                                  |
// +-----------------------------------------------------------------------+
// | Copyright(C) 2008-2010 Piwigo Team                  http://piwigo.org |
// | Copyright(C) 2003-2008 PhpWebGallery Team    http://phpwebgallery.net |
// | Copyright(C) 2002-2003 Pierrick LE GALL   http://le-gall.net/pierrick |
// +-----------------------------------------------------------------------+
// | This program is free software; you can redistribute it and/or modify  |
// | it under the terms of the GNU General Public License as published by  |
// | the Free Software Foundation                                          |
// |                                                                       |
// | This program is distributed in the hope that it will be useful, but   |
// | WITHOUT ANY WARRANTY; without even the implied warranty of            |
// | MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU      |
// | General Public License for more details.                              |
// |                                                                       |
// | You should have received a copy of the GNU General Public License     |
// | along with this program; if not, write to the Free Software           |
// | Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, |
// | USA.                                                                  |
// +-----------------------------------------------------------------------+

if (!defined('PHPWG_ROOT_PATH'))
{
  die('Hacking attempt!');
}

$upgrade_description =
  'Column #image_category.is_storage replaces #images.storage_category_id';

// +-----------------------------------------------------------------------+
// |                            Upgrade content                            |
// +-----------------------------------------------------------------------+

$query = "
ALTER TABLE ".PREFIX_TABLE."image_category
  ADD COLUMN is_storage ENUM('true','false') DEFAULT 'false'
;";
pwg_query($query);

$query = '
SELECT id, storage_category_id
  FROM '.PREFIX_TABLE.'images
;';
$result = pwg_query($query);

$datas = array();

while ($row = pwg_db_fetch_assoc($result))
{
  array_push(
    $datas,
    array(
      'image_id'    => $row['id'],
      'category_id' => $row['storage_category_id'],
      'is_storage'  => 'true',
      )
    );
}

mass_updates(
  PREFIX_TABLE.'image_category',
  array(
    'primary' => array('image_id', 'category_id'),
    'update'  => array('is_storage')
    ),
  $datas
  );

$query = '
ALTER TABLE '.PREFIX_TABLE.'images
  DROP COLUMN storage_category_id
;';
pwg_query($query);

// +-----------------------------------------------------------------------+
// |                           End notification                            |
// +-----------------------------------------------------------------------+

echo
"\n"
.'Column '.PREFIX_TABLE.'image_category.is_storage created and filled'
."\n"
;
?>
