/*
 * Functions in "common.c"
 *
 */

#ifndef P_COMMONH
#define P_COMMONH

#include <config.h>

/*
 * On linux, vfs.h is used. FreeBSD seems to use param.h and mount.h
 */
#ifdef HAVE_VFS
	#include <sys/vfs.h>
#else
	#include <sys/param.h>
	#include <sys/mount.h>
#endif

#include <mysql/mysql.h>
#include <mysql/mysqld_error.h>

int p_assign(MYSQL *db, char *filename, int minlen, int destarea,
			int context);
char *p_basename(char *src);
int p_checkfile(MYSQL *db, int areaid, char *filename, unsigned long options);
int p_checksubject(MYSQL *db, int areaid, char * subject);
int p_checkfilename(MYSQL *db, char *string);
int p_checkforspace(char *string);
int p_checkfornumber(char *string);
int p_checkforletter(char *string);
int p_checkp(char *path);
MYSQL *p_connect(void);
int p_cp(char *src, char *dest);
int p_dupecheck(MYSQL *src_db, char *filename, int area_id);
// int p_exec(char *cmd, char *args[]);
int p_getdest(char *filename, int context);
char *p_getmisc(MYSQL *db, char *key);
int p_initcfg(MYSQL *db);
int p_makepattern(char *output, char *filename);
int p_md5check(char *md5sum);
int p_mv(char *src, char *dest);
int p_pathcomp(char *path, char *head, char *tail);
int p_query(MYSQL *db, const char * format,...);
int p_setmisc(MYSQL *db, char *key, char *data);
int p_strtolc(char *string);
int p_checkprune(MYSQL *db,char *fullpath);
int p_return_ext(char *filename);

extern char *Results[];

#define RESULT_OK					0 
#define RESULT_LONG_FILENAME 		1
#define RESULT_INVALID_FILENAME 	2
#define RESULT_FILE_EXISTS 			3
#define RESULT_ASSIGN_DELETE 		4
#define RESULT_NAZI_KILL 			5

#endif

