/***************************************************************************
*            qof-address.c
*
*  Thu Oct 21 12:44:16 2004
*  Copyright  2004-2007  Neil Williams  <linux@codehelp.co.uk>
****************************************************************************/
/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
/** @addtogroup Addr 
@{
*/
/** @file  qof-address.c
	@brief QOF address definitions for pilot-link
	@author Copyright (c) 2004-2007 Neil Williams <linux@codehelp.co.uk>
*/

#include <glib.h>
#include <glib/gprintf.h>
#include <qof.h>
#include "pi-address.h"
#include "qof-address.h"
#include "qof-main.h"
#include "pilot-qof.h"

#define QOF_ADDRESS_DESC "Pilot-link QOF address"

static G_GNUC_UNUSED QofLogModule log_module = PQ_MOD_PILOT;

/** \brief Example of QOF wrapping an existing object.

Note that both the Address_t struct and the QofInstance instance are
contained within the object, not referenced using just a pointer.
*/
typedef struct
{
	QofInstance inst;
	Address_t wrap;				// 0.12
	gchar *category;
	const gchar *printable;
} QofAddress;

/** \brief create a new address

 Hack alert: This routine specifically sets a blank
 value in entry[18] - using g_new0() externally
 is not the same.
*/
static QofAddress *
address_create (QofBook * book)
{
	Address_t *qa;
	QofAddress *obj;
	QofCollection *coll;
	GList *all;

	obj = g_new0 (QofAddress, 1);
	qof_instance_init (&obj->inst, PILOT_LINK_QOF_ADDRESS, book);
	coll = qof_book_get_collection (book, PILOT_LINK_QOF_ADDRESS);
	all = qof_collection_get_data (coll);
	all = g_list_prepend (all, obj);
	qof_collection_set_data (coll, all);
	qa = &obj->wrap;
	qa->entry[18] = strdup ("");
	return obj;
}

Address_t * address_get_pilot (QofInstance * inst)
{
	QofAddress * a;

	a = (QofAddress *)inst;
	return &a->wrap;
}

static gchar *
addr_getLastname (QofAddress * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryLastname];
}

static gchar *
addr_getFirstname (QofAddress * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryFirstname];
}

static gchar *
addr_getCompany (QofAddress * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryCompany];
}

static gchar *
addr_getPhoneOne (QofAddress * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryPhone1];
}

static gchar *
addr_getPhoneTwo (QofAddress * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryPhone2];
}

static gchar *
addr_getPhoneThree (QofAddress * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryPhone3];
}

static gchar *
addr_getPhoneFour (QofAddress * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryPhone4];
}

static gchar *
addr_getPhoneFive (QofAddress * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryPhone5];
}

static gchar *
addr_getCity (QofAddress * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryCity];
}

static gchar *
addr_getState (QofAddress * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryState];
}

static gchar *
addr_getZip (QofAddress * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryZip];
}

static gchar *
addr_getCountry (QofAddress * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryCountry];
}

static gchar *
addr_getTitle (QofAddress * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryTitle];
}

static gchar *
addr_getAddress (QofAddress * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryAddress];
}

static gchar *
addr_getCustomOne (QofAddress * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryCustom1];
}

static gchar *
addr_getCustomTwo (QofAddress * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryCustom2];
}

static gchar *
addr_getCustomThree (QofAddress * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryCustom3];
}

static gchar *
addr_getCustomFour (QofAddress * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryCustom4];
}

static gchar *
addr_getNote (QofAddress * a)
{
	Address_t *qa;

	g_return_val_if_fail (a != NULL, NULL);
	qa = &a->wrap;
	return qa->entry[entryNote];
}

static gchar *
addr_getCategory (QofAddress * a)
{
	g_return_val_if_fail (a != NULL, NULL);
	return (a->category);
}

static void
addr_setLastname (QofAddress * a, gchar * h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	if (!h)
		return;
	qa = &a->wrap;
	qa->entry[entryLastname] = g_strdup (qof_util_make_utf8 (h));
}

static void
addr_setFirstname (QofAddress * a, gchar * h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	if (!h)
		return;
	qa = &a->wrap;
	qa->entry[entryFirstname] = g_strdup (qof_util_make_utf8 (h));
}

static void
addr_setCompany (QofAddress * a, gchar * h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	qa = &a->wrap;
	qa->entry[entryCompany] = g_strdup (qof_util_make_utf8 (h));
}

static void
addr_setPhoneOne (QofAddress * a, gchar * h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	if (!h)
		return;
	qa = &a->wrap;
	qa->entry[entryPhone1] = g_strdup (qof_util_make_utf8 (h));
}

static void
addr_setPhoneTwo (QofAddress * a, gchar * h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	qa = &a->wrap;
	qa->entry[entryPhone2] = g_strdup (qof_util_make_utf8 (h));
}

static void
addr_setPhoneThree (QofAddress * a, gchar * h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	if (!h)
		return;
	qa = &a->wrap;
	qa->entry[entryPhone3] = g_strdup (qof_util_make_utf8 (h));
}

static void
addr_setPhoneFour (QofAddress * a, gchar * h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	qa = &a->wrap;
	qa->entry[entryPhone4] = g_strdup (qof_util_make_utf8 (h));
}

static void
addr_setPhoneFive (QofAddress * a, gchar * h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	if (!h)
		return;
	qa = &a->wrap;
	qa->entry[entryPhone5] = g_strdup (qof_util_make_utf8 (h));
}

static void
addr_setAddress (QofAddress * a, gchar * h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	if (!h)
		return;
	qa = &a->wrap;
	qa->entry[entryAddress] = g_strdup (qof_util_make_utf8 (h));
}

static void
addr_setCity (QofAddress * a, gchar * h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	qa = &a->wrap;
	qa->entry[entryCity] = strdup (qof_util_make_utf8 (h));
}

static void
addr_setState (QofAddress * a, gchar * h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	qa = &a->wrap;
	qa->entry[entryState] = g_strdup (qof_util_make_utf8 (h));
}

static void
addr_setZip (QofAddress * a, gchar * h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	if (!h)
		return;
	qa = &a->wrap;
	qa->entry[entryZip] = g_strdup (qof_util_make_utf8 (h));
}

static void
addr_setCountry (QofAddress * a, gchar * h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	qa = &a->wrap;
	qa->entry[entryCountry] = g_strdup (qof_util_make_utf8 (h));
}

static void
addr_setTitle (QofAddress * a, gchar * h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	if (!h)
		return;
	qa = &a->wrap;
	qa->entry[entryTitle] = g_strdup (qof_util_make_utf8 (h));
}

static void
addr_setCustomOne (QofAddress * a, gchar * h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	if (!h)
		return;
	qa = &a->wrap;
	qa->entry[entryCustom1] = g_strdup (qof_util_make_utf8 (h));
}

static void
addr_setCustomTwo (QofAddress * a, gchar * h)
{
	Address_t *qa;

	g_return_if_fail (a != NULL);
	if (!h)
		return;
	qa = &a->wrap;
	qa->entry[entryCustom2] = g_strdup (qof_util_make_utf8 (h));
}

static void
addr_setCustomThree (QofAddress * a, gchar * h)
{
	Address_t *qa;

	g_return_if_fail (a);
	if (!h)
		return;
	qa = &a->wrap;
	qa->entry[entryCustom3] = g_strdup (qof_util_make_utf8 (h));
}

static void
addr_setCustomFour (QofAddress * a, gchar * h)
{
	Address_t *qa;

	g_return_if_fail (a);
	if (!h)
		return;
	qa = &a->wrap;
	qa->entry[entryCustom4] = g_strdup (qof_util_make_utf8 (h));
}

static void
addr_setNote (QofAddress * a, gchar * h)
{
	Address_t *qa;

	g_return_if_fail (a);
	if (!h)
		return;
	qa = &a->wrap;
	qa->entry[entryNote] = g_strdup (qof_util_make_utf8 (h));
}

static void
addr_setCategory (QofAddress * a, gchar * h)
{
	g_return_if_fail (a);
	if (!h)
		return;
	a->category = g_strdup (qof_util_make_utf8 (h));
}

static const gchar *
addressPrintable (gpointer instance)
{
	QofAddress *obj;

	obj = (QofAddress *) instance;
	if (!obj)
		return NULL;
	if (addr_getFirstname (obj))
	{
		obj->printable = g_strconcat (addr_getFirstname (obj), " ",
			addr_getLastname (obj), NULL);
		return obj->printable;
	}
	else
		return addr_getTitle (obj);
}

static QofObject address_object_def = {
  interface_version:QOF_OBJECT_VERSION,
  e_type:PILOT_LINK_QOF_ADDRESS,
  type_label:QOF_ADDRESS_DESC,
  create:(gpointer) address_create,
  book_begin:NULL,
  book_end:NULL,
  is_dirty:qof_collection_is_dirty,
  mark_clean:qof_collection_mark_clean,
  foreach:qof_collection_foreach,
  printable:addressPrintable,
  version_cmp:(gint (*)(gpointer, gpointer)) qof_instance_version_cmp,
};

gboolean
AddressRegister (void)
{
	static QofParam params[] = {
		{ADDR_LAST_NAME, QOF_TYPE_STRING, (QofAccessFunc) addr_getLastname,
				(QofSetterFunc) addr_setLastname},
		{ADDR_FIRST_NAME, QOF_TYPE_STRING,
				(QofAccessFunc) addr_getFirstname,
				(QofSetterFunc) addr_setFirstname},
		{ADDR_COMPANY, QOF_TYPE_STRING, (QofAccessFunc) addr_getCompany,
				(QofSetterFunc) addr_setCompany},
		{ADDR_PHONE_ONE, QOF_TYPE_STRING, (QofAccessFunc) addr_getPhoneOne,
				(QofSetterFunc) addr_setPhoneOne},
		{ADDR_PHONE_TWO, QOF_TYPE_STRING, (QofAccessFunc) addr_getPhoneTwo,
				(QofSetterFunc) addr_setPhoneTwo},
		{ADDR_PHONE_THREE, QOF_TYPE_STRING,
				(QofAccessFunc) addr_getPhoneThree,
				(QofSetterFunc) addr_setPhoneThree},
		{ADDR_PHONE_FOUR, QOF_TYPE_STRING,
				(QofAccessFunc) addr_getPhoneFour,
				(QofSetterFunc) addr_setPhoneFour},
		{ADDR_PHONE_FIVE, QOF_TYPE_STRING,
				(QofAccessFunc) addr_getPhoneFive,
				(QofSetterFunc) addr_setPhoneFive},
		{ADDR_ADDRESS, QOF_TYPE_STRING, (QofAccessFunc) addr_getAddress,
				(QofSetterFunc) addr_setAddress},
		{ADDR_CITY, QOF_TYPE_STRING, (QofAccessFunc) addr_getCity,
				(QofSetterFunc) addr_setCity},
		{ADDR_STATE, QOF_TYPE_STRING, (QofAccessFunc) addr_getState,
				(QofSetterFunc) addr_setState},
		{ADDR_ZIP, QOF_TYPE_STRING, (QofAccessFunc) addr_getZip,
				(QofSetterFunc) addr_setZip},
		{ADDR_COUNTRY, QOF_TYPE_STRING, (QofAccessFunc) addr_getCountry,
				(QofSetterFunc) addr_setCountry},
		{ADDR_TITLE, QOF_TYPE_STRING, (QofAccessFunc) addr_getTitle,
				(QofSetterFunc) addr_setTitle},
		{ADDR_CUSTOM_ONE, QOF_TYPE_STRING,
				(QofAccessFunc) addr_getCustomOne,
				(QofSetterFunc) addr_setCustomOne},
		{ADDR_CUSTOM_TWO, QOF_TYPE_STRING,
				(QofAccessFunc) addr_getCustomTwo,
				(QofSetterFunc) addr_setCustomTwo},
		{ADDR_CUSTOM_THREE, QOF_TYPE_STRING,
				(QofAccessFunc) addr_getCustomThree,
				(QofSetterFunc) addr_setCustomThree},
		{ADDR_CUSTOM_FOUR, QOF_TYPE_STRING,
				(QofAccessFunc) addr_getCustomFour,
				(QofSetterFunc) addr_setCustomFour},
		{ADDR_NOTE, QOF_TYPE_STRING, (QofAccessFunc) addr_getNote,
				(QofSetterFunc) addr_setNote},
		{ADDR_CATEGORY, QOF_TYPE_STRING, (QofAccessFunc) addr_getCategory,
				(QofSetterFunc) addr_setCategory},
		{QOF_PARAM_BOOK, QOF_ID_BOOK,
				(QofAccessFunc) qof_instance_get_book, NULL},
		{QOF_PARAM_GUID, QOF_TYPE_GUID,
				(QofAccessFunc) qof_instance_get_guid, NULL},
		{NULL},
	};

	qof_class_register (PILOT_LINK_QOF_ADDRESS, NULL, params);

//	pilot_qof_pack_register (&address_pack_def);

	return qof_object_register (&address_object_def);
}

/** @} */
