/* Generated from "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod" by precompile.pike running Pike v8.0 release 609
 *
 * Do NOT edit this file.
 */

#undef PRECOMPILE_API_VERSION
#define PRECOMPILE_API_VERSION 6

#undef PRECOMPILE_SUB_PIKEVARS
#define PRECOMPILE_SUB_PIKEVARS 1

#undef PRECOMPILE_DYNAMIC_TYPES
#define PRECOMPILE_DYNAMIC_TYPES 1



#undef cmod___CMOD__
#define cmod___CMOD__ 1
#line 1 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
#line 1 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
#line 1 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
#line 3003 "/home/zino/hack/pike8-rel/pike/lib/modules/Tools.pmod/Standalone.pmod/precompile.pike"







#line 3010 "/home/zino/hack/pike8-rel/pike/lib/modules/Tools.pmod/Standalone.pmod/precompile.pike"
#line 1 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
#line 1 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
/* nettle.cmod -*- c -*- */

#include "global.h"
#include "interpret.h"
#include "svalue.h"
/* For this_object() */
#include "object.h"
#include "operators.h"
#include "module_support.h"
#include "threads.h"
#include "pike_memory.h"

#include "nettle_config.h"

#ifdef HAVE_LIBNETTLE

#include "nettle.h"

#include <nettle/yarrow.h>

#include <stdio.h>
#include <stdarg.h>



#ifndef PIKE_UNUSED_ATTRIBUTE
#define PIKE_UNUSED_ATTRIBUTE
#endif
#define CMOD_MAP_PROGRAM_IDS_DEFINED 1
static int ___cmod_map_program_ids(int id) PIKE_UNUSED_ATTRIBUTE;
#ifndef TYPEOF
/* Compat with older Pikes. */
#define TYPEOF(SVAL)	((SVAL).type)
#define SUBTYPEOF(SVAL)	((SVAL).subtype)
#define SET_SVAL_TYPE(SVAL, TYPE)	(TYPEOF(SVAL) = TYPE)
#define SET_SVAL_SUBTYPE(SVAL, TYPE)	(SUBTYPEOF(SVAL) = TYPE)
#define SET_SVAL(SVAL, TYPE, SUBTYPE, FIELD, EXPR) do {	\
    /* Set the type afterwards to avoid a clobbered	\
     * svalue in case EXPR throws. */			\
    (SVAL).u.FIELD = (EXPR);				\
    SET_SVAL_TYPE((SVAL), (TYPE));			\
    SET_SVAL_SUBTYPE((SVAL), (SUBTYPE));		\
  } while(0)
#endif /* !TYPEOF */
#ifndef PIKE_UNUSED
/* Compat with Pike 7.8 and earlier. */
/* NB: Not strictly correct; PIKE_UNUSED was added the
 *     day after set_program_id_to_id(), but good enough.
 */
#ifndef UNUSED
#define UNUSED(X)	X
#endif
#ifndef set_program_id_to_id
/* NB: Recent Pike 7.8 has a #define that conflicts with
 *     the following declaration.
 */
static void set_program_id_to_id(void*UNUSED(id)){}
#endif
#else /* */
PMOD_EXPORT void set_program_id_to_id( int (*to)(int) );
#endif /* !PIKE_UNUSED */


#ifndef DEFAULT_CMOD_STORAGE
#define CMOD_COND_USED
#define DEFAULT_CMOD_STORAGE static
#endif
#define module_strings_declared
static struct pike_string *module_strings[1] = {
  NULL,
};
#ifndef CMOD_COND_USED
# define f_Nettle_Fortuna_random_string_fun_num_used 1
#else
#undef f_Nettle_Fortuna_random_string_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Nettle_Yarrow_create_fun_num_used 1
#else
#undef f_Nettle_Yarrow_create_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Nettle_Yarrow_seed_fun_num_used 1
#else
#undef f_Nettle_Yarrow_seed_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Nettle_Yarrow_update_fun_num_used 1
#else
#undef f_Nettle_Yarrow_update_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define Nettle_Yarrow_program_fun_num_used 1
#else
#undef Nettle_Yarrow_program_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Nettle_Fortuna_reseed_fun_num_used 1
#else
#undef f_Nettle_Fortuna_reseed_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define Nettle_Fortuna_program_fun_num_used 1
#else
#undef Nettle_Fortuna_program_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Nettle_version_fun_num_used 1
#else
#undef f_Nettle_version_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Nettle_rsa_unpad_fun_num_used 1
#else
#undef f_Nettle_rsa_unpad_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Nettle_crypt_md5_fun_num_used 1
#else
#undef f_Nettle_crypt_md5_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Nettle_Yarrow_is_seeded_fun_num_used 1
#else
#undef f_Nettle_Yarrow_is_seeded_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Nettle_Yarrow_force_reseed_fun_num_used 1
#else
#undef f_Nettle_Yarrow_force_reseed_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Nettle_Yarrow_needed_sources_fun_num_used 1
#else
#undef f_Nettle_Yarrow_needed_sources_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Nettle_Yarrow_random_string_fun_num_used 1
#else
#undef f_Nettle_Yarrow_random_string_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Nettle_Yarrow_get_seed_fun_num_used 1
#else
#undef f_Nettle_Yarrow_get_seed_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Nettle_Yarrow_min_seed_size_fun_num_used 1
#else
#undef f_Nettle_Yarrow_min_seed_size_fun_num_used
#endif
/*! @module Nettle
 *! Low level crypto functions used by the @[Crypto] module. Unless
 *! you are doing something very special, you would want to use the
 *! Crypto module instead.
 */

/*! @decl string version()
 *! Returns the version of the Nettle library, e.g. "3.1". 0 is
 *! returned when runtime version is unknown.
 */
#define f_Nettle_version_defined

#ifdef f_Nettle_version_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Nettle_version_fun_num = 0;

#endif /* f_Nettle_version_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Nettle_version(INT32 args) {
#line 36 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if(args != 0) wrong_number_of_args_error("version",args,0);
{
#ifdef HAVE_NETTLE_VERSION_H
 push_constant_text("%d.%d");
#ifdef HAVE_NETTLE_VERSION_MAJOR
 push_int( nettle_version_major() );
push_int( nettle_version_minor() );
#else
 /* Probably Nettle 3.1.1. */
push_int( NETTLE_VERSION_MAJOR );
push_int( NETTLE_VERSION_MINOR );
#endif
 f_sprintf(3);
#else
 push_int(0);
#endif
}

}
/*! @class Yarrow
 *!
 *! Yarrow is a family of pseudo-randomness generators, designed for
 *! cryptographic use, by John Kelsey, Bruce Schneier and Niels Ferguson.
 *! Yarrow-160 is described in a paper at
 *! @url{http://www.schneier.com/paper-yarrow.html@}, and it uses SHA1 and
 *! triple-DES, and has a 160-bit internal state. Nettle implements
 *! Yarrow-256, which is similar, but uses SHA256 and AES to get an
 *! internal state of 256 bits.
 */

#undef class_Nettle_Yarrow_defined
#define class_Nettle_Yarrow_defined
DEFAULT_CMOD_STORAGE struct program *Nettle_Yarrow_program=NULL;

#ifdef Nettle_Yarrow_program_fun_num_used
DEFAULT_CMOD_STORAGE int Nettle_Yarrow_program_fun_num=-1;
#endif /* Nettle_Yarrow_program_fun_num_used */

#undef var_ctx_Nettle_Yarrow_defined
#define var_ctx_Nettle_Yarrow_defined

#undef var_sources_Nettle_Yarrow_defined
#define var_sources_Nettle_Yarrow_defined

#undef THIS
#define THIS ((struct Nettle_Yarrow_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_NETTLE_YARROW
#define THIS_NETTLE_YARROW ((struct Nettle_Yarrow_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_NETTLE_YARROW
#define OBJ2_NETTLE_YARROW(o) ((struct Nettle_Yarrow_struct *)(o->storage+Nettle_Yarrow_storage_offset))

#undef GET_NETTLE_YARROW_STORAGE
#define GET_NETTLE_YARROW_STORAGE(o) ((struct Nettle_Yarrow_struct *)(o->storage+Nettle_Yarrow_storage_offset)
static ptrdiff_t Nettle_Yarrow_storage_offset;
struct Nettle_Yarrow_struct {

#ifdef var_ctx_Nettle_Yarrow_defined
#line 67 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
struct yarrow256_ctx ctx;
#endif /* var_ctx_Nettle_Yarrow_defined */

#ifdef var_sources_Nettle_Yarrow_defined
#line 68 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
struct yarrow_source *sources;
#endif /* var_sources_Nettle_Yarrow_defined */
};
#ifdef PIKE_DEBUG
/* Ensure the struct is used in a variable declaration, or else gdb might not see it. */
static struct Nettle_Yarrow_struct *Nettle_Yarrow_gdb_dummy_ptr;
#endif
#line 70 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
;

/*! @decl void create(void|int sources)
   *! The number of entropy sources that will feed entropy to the
   *! random number generator is given as an argument to Yarrow
   *! during instantiation.
   *! @seealso
   *!   @[update]
   */
#define f_Nettle_Yarrow_create_defined

#ifdef f_Nettle_Yarrow_create_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Nettle_Yarrow_create_fun_num = 0;

#endif /* f_Nettle_Yarrow_create_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Nettle_Yarrow_create(INT32 args) {
#line 79 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
struct svalue * arg;
#line 79 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if(args > 1) wrong_number_of_args_error("create",args,1);
#line 79 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if ((args > 0) &&
    ((TYPEOF(Pike_sp[0-args]) != PIKE_T_INT) ||
     (SUBTYPEOF(Pike_sp[0-args]) != NUMBER_UNDEFINED))) {
#line 79 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if(TYPEOF(Pike_sp[0-args]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("create",1,"void|int");
#line 79 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
arg=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
#line 79 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
} else arg = NULL;
#line 81 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
{
INT32 num = 0;

if(arg) {
if (TYPEOF(*arg) != PIKE_T_INT)
Pike_error("Bad argument type.\n");
num = arg->u.integer;
if(num < 0)
Pike_error("Invalid number of sources.\n");
free (THIS->sources);
THIS->sources = xalloc(sizeof(struct yarrow_source)*num);
}
else
{
free (THIS->sources);
THIS->sources = NULL;
}
yarrow256_init(&THIS->ctx, num, THIS->sources);
}

}
/*! @decl Yarrow seed(string(0..255) data)
   *!
   *! The random generator needs to be seeded before it can be used.
   *! The seed must be at least 32 characters long. The seed could be
   *! stored from a previous run by inserting the value returned from
   *! previous @[random_string] call.
   *!
   *! @returns
   *!   Returns the called object.
   *! @seealso
   *!   @[min_seed_size], @[is_seeded]
   */
#define f_Nettle_Yarrow_seed_defined

#ifdef f_Nettle_Yarrow_seed_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Nettle_Yarrow_seed_fun_num = 0;

#endif /* f_Nettle_Yarrow_seed_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Nettle_Yarrow_seed(INT32 args) {
#line 113 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
struct pike_string * data;
#line 113 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if(args != 1) wrong_number_of_args_error("seed",args,1);
#line 113 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("seed",1,"string(0..255)");
#line 113 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
debug_malloc_pass(data=Pike_sp[0-1].u.string);
#line 115 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
{
if(data->len < YARROW256_SEED_FILE_SIZE)
Pike_error("Seed must be at least %d characters.\n",
YARROW256_SEED_FILE_SIZE);

NO_WIDE_STRING(data);
yarrow256_seed(&THIS->ctx, data->len, STR0(data));
do { struct object * ret_=(this_object()); pop_stack(); push_object(ret_); return; }while(0);
#line 123 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
}

}
/*! @decl int(0..) min_seed_size()
   *! Returns the minimal number of characters that the @[seed]
   *! needs to properly seed the random number generator.
   *! @seealso
   *!   @[seed]
   */
#define f_Nettle_Yarrow_min_seed_size_defined

#ifdef f_Nettle_Yarrow_min_seed_size_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Nettle_Yarrow_min_seed_size_fun_num = 0;

#endif /* f_Nettle_Yarrow_min_seed_size_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Nettle_Yarrow_min_seed_size(INT32 args) {
#line 131 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if(args != 0) wrong_number_of_args_error("min_seed_size",args,0);
#line 133 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
{
do { INT_TYPE ret_=(YARROW256_SEED_FILE_SIZE);  push_int(ret_); return; }while(0);
#line 135 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
}

}
/*! @decl int(0..1) is_seeded()
   *! Returns 1 if the random generator is seeded and ready
   *! to generator output. 0 otherwise.
   *! @seealso
   *!   @[seed]
   */
#define f_Nettle_Yarrow_is_seeded_defined

#ifdef f_Nettle_Yarrow_is_seeded_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Nettle_Yarrow_is_seeded_fun_num = 0;

#endif /* f_Nettle_Yarrow_is_seeded_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Nettle_Yarrow_is_seeded(INT32 args) {
#line 143 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if(args != 0) wrong_number_of_args_error("is_seeded",args,0);
#line 145 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
{
do { INT_TYPE ret_=(yarrow256_is_seeded(&THIS->ctx));  push_int(ret_); return; }while(0);
#line 147 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
}

}
/*! @decl void force_reseed()
   *! By calling this function entropy is moved from the slow
   *! pool to the fast pool. Read more about Yarrow before using
   *! this.
   */
#define f_Nettle_Yarrow_force_reseed_defined

#ifdef f_Nettle_Yarrow_force_reseed_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Nettle_Yarrow_force_reseed_fun_num = 0;

#endif /* f_Nettle_Yarrow_force_reseed_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Nettle_Yarrow_force_reseed(INT32 args) {
#line 154 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if(args != 0) wrong_number_of_args_error("force_reseed",args,0);
#line 156 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
{
#ifdef HAVE_NETTLE_YARROW256_SLOW_RESEED
 /* From change notes for Nettle 2.0:
     *
     * * Changes to the yarrow256 interface. The function
     *   yarrow256_force_reseed has been replaced by the two
     *   functions yarrow256_fast_reseed and yarrow256_slow_reseed,
     *   which were previously static.
     */
yarrow256_slow_reseed(&THIS->ctx);
#else
 yarrow256_force_reseed(&THIS->ctx);
#endif
 }

}
/*! @decl int(0..1) update(string(0..255) data, int source, int entropy)
   *! Inject additional entropy into the random number generator.
   *!
   *! @seealso
   *!   @[create]
   */
#define f_Nettle_Yarrow_update_defined

#ifdef f_Nettle_Yarrow_update_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Nettle_Yarrow_update_fun_num = 0;

#endif /* f_Nettle_Yarrow_update_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Nettle_Yarrow_update(INT32 args) {
#line 177 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
struct pike_string * data;
#line 177 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
INT_TYPE source;
#line 177 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
INT_TYPE entropy;
#line 177 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if(args != 3) wrong_number_of_args_error("update",args,3);
#line 177 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if(TYPEOF(Pike_sp[0-3]) != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("update",1,"string(0..255)");
#line 177 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
debug_malloc_pass(data=Pike_sp[0-3].u.string);
#line 177 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if(TYPEOF(Pike_sp[1-3]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("update",2,"int");
#line 177 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
source=Pike_sp[1-3].u.integer;
#line 177 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if(TYPEOF(Pike_sp[2-3]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("update",3,"int");
#line 177 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
entropy=Pike_sp[2-3].u.integer;
#line 179 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
{
int ret;
/* FIXME: Wide strings could actually be supported here */
NO_WIDE_STRING(data);
if( !THIS->sources )
Pike_error("This random generator has no sources.\n");
if( source<0 || (unsigned)source>=THIS->ctx.nsources )
Pike_error("Invalid random source.\n");
if( entropy<0 )
Pike_error("Entropy must be positive.\n");
if( entropy>(data->len*8) )
Pike_error("Impossibly large entropy value.\n");
ret = yarrow256_update(&THIS->ctx, source, entropy, data->len,
(const uint8_t *)data->str);
do { INT_TYPE ret_=(ret); pop_n_elems(3); push_int(ret_); return; }while(0);
#line 194 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
}

}
/*! @decl int(0..) needed_sources()
   *! The number of sources that must reach the threshold before a
   *! slow reseed will happen.
   */
#define f_Nettle_Yarrow_needed_sources_defined

#ifdef f_Nettle_Yarrow_needed_sources_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Nettle_Yarrow_needed_sources_fun_num = 0;

#endif /* f_Nettle_Yarrow_needed_sources_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Nettle_Yarrow_needed_sources(INT32 args) {
#line 200 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if(args != 0) wrong_number_of_args_error("needed_sources",args,0);
#line 202 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
{
do { INT_TYPE ret_=(yarrow256_needed_sources(&THIS->ctx));  push_int(ret_); return; }while(0);
#line 204 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
}

}
/*! @decl string(0..255) random_string(int length)
   *! Returns a pseudo-random string of the requested @[length].
   */
#define f_Nettle_Yarrow_random_string_defined

#ifdef f_Nettle_Yarrow_random_string_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Nettle_Yarrow_random_string_fun_num = 0;

#endif /* f_Nettle_Yarrow_random_string_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Nettle_Yarrow_random_string(INT32 args) {
#line 209 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
INT_TYPE length;
#line 209 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if(args != 1) wrong_number_of_args_error("random_string",args,1);
#line 209 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("random_string",1,"int");
#line 209 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
length=Pike_sp[0-1].u.integer;
#line 211 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
{
struct pike_string *rnd;
if(length < 0)
Pike_error("Invalid length, must be positive.\n");
if( !yarrow256_is_seeded(&THIS->ctx) )
Pike_error("Random generator not seeded.\n");
rnd = begin_shared_string(length);
yarrow256_random(&THIS->ctx, length, (uint8_t *)rnd->str);
do { struct pike_string * ret_=(end_shared_string(rnd)); pop_stack(); push_string(ret_); return; }while(0);
#line 220 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
}

}
/*! @decl string(0..255) get_seed()
   *!   Returns part of the internal state so that it can be saved for
   *!   later seeding. This method is deprecated. Instead read the
   *!   @[min_seed_size] number of bytes from the @[random_string]
   *!   method.
   *!
   *! @seealso
   *!   @[seed()], @[random_string()]
   */
#define f_Nettle_Yarrow_get_seed_defined

#ifdef f_Nettle_Yarrow_get_seed_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Nettle_Yarrow_get_seed_fun_num = 0;

#endif /* f_Nettle_Yarrow_get_seed_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Nettle_Yarrow_get_seed(INT32 args) {
#line 231 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if(args != 0) wrong_number_of_args_error("get_seed",args,0);
#line 234 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
{
push_int(YARROW256_SEED_FILE_SIZE);
f_Nettle_Yarrow_random_string(1);
}

}

#undef internal_init_Nettle_Yarrow_defined
#define internal_init_Nettle_Yarrow_defined

#undef Nettle_Yarrow_event_handler_defined
#define Nettle_Yarrow_event_handler_defined
static void init_Nettle_Yarrow_struct(void)
#line 240 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
{
THIS->sources = NULL;
yarrow256_init(&THIS->ctx, 0, NULL);
}


#undef internal_exit_Nettle_Yarrow_defined
#define internal_exit_Nettle_Yarrow_defined

#undef Nettle_Yarrow_event_handler_defined
#define Nettle_Yarrow_event_handler_defined
static void exit_Nettle_Yarrow_struct(void)
#line 247 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
{
if( THIS->sources )
{
free(THIS->sources);
}
}

#ifdef Nettle_Yarrow_event_handler_defined
static void Nettle_Yarrow_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_Nettle_Yarrow_defined
  case PROG_EVENT_INIT: init_Nettle_Yarrow_struct(); break;

#endif /* internal_init_Nettle_Yarrow_defined */

#ifdef internal_exit_Nettle_Yarrow_defined
  case PROG_EVENT_EXIT: exit_Nettle_Yarrow_struct(); break;

#endif /* internal_exit_Nettle_Yarrow_defined */
  default: break; 
  }
}

#endif /* Nettle_Yarrow_event_handler_defined */
/*! @endclass
 */

#line 258 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
#define INCREMENT(size, ctr)			\
  do {						\
    unsigned increment_i = (size) - 1;		\
    if (++(ctr)[increment_i] == 0)		\
      while (increment_i > 0			\
	     && ++(ctr)[--increment_i] == 0 )	\
	;					\
  } while (0)

/*! @class Fortuna
 *!
 *! Implements the Fortuna PRNG generator, designed by Niels Ferguson and
 *! Bruce Schneier and described in Practical Cryptography. Web
 *! published exerpt at https://www.schneier.com:443/fortuna.pdf
 *!
 *! This implementation uses AES256 to generate output and SHA256 to
 *! generate keys.
 *!
 *! To use this class an entropy accumulator needs to be implemented
 *! and supply the @[reseed()] method with new entopy.
 */

#undef class_Nettle_Fortuna_defined
#define class_Nettle_Fortuna_defined
DEFAULT_CMOD_STORAGE struct program *Nettle_Fortuna_program=NULL;

#ifdef Nettle_Fortuna_program_fun_num_used
DEFAULT_CMOD_STORAGE int Nettle_Fortuna_program_fun_num=-1;
#endif /* Nettle_Fortuna_program_fun_num_used */

#undef var_aes_ctx_Nettle_Fortuna_defined
#define var_aes_ctx_Nettle_Fortuna_defined

#undef var_sha_ctx_Nettle_Fortuna_defined
#define var_sha_ctx_Nettle_Fortuna_defined

#undef var_key_Nettle_Fortuna_defined
#define var_key_Nettle_Fortuna_defined

#undef var_ctr_Nettle_Fortuna_defined
#define var_ctr_Nettle_Fortuna_defined

#undef var_data_Nettle_Fortuna_defined
#define var_data_Nettle_Fortuna_defined

#undef THIS
#define THIS ((struct Nettle_Fortuna_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_NETTLE_FORTUNA
#define THIS_NETTLE_FORTUNA ((struct Nettle_Fortuna_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_NETTLE_FORTUNA
#define OBJ2_NETTLE_FORTUNA(o) ((struct Nettle_Fortuna_struct *)(o->storage+Nettle_Fortuna_storage_offset))

#undef GET_NETTLE_FORTUNA_STORAGE
#define GET_NETTLE_FORTUNA_STORAGE(o) ((struct Nettle_Fortuna_struct *)(o->storage+Nettle_Fortuna_storage_offset)
static ptrdiff_t Nettle_Fortuna_storage_offset;
struct Nettle_Fortuna_struct {

#ifdef var_aes_ctx_Nettle_Fortuna_defined
#line 282 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
struct aes_ctx aes_ctx;
#endif /* var_aes_ctx_Nettle_Fortuna_defined */

#ifdef var_sha_ctx_Nettle_Fortuna_defined
#line 283 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
struct sha256_ctx sha_ctx;
#endif /* var_sha_ctx_Nettle_Fortuna_defined */

#ifdef var_key_Nettle_Fortuna_defined
#line 284 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
uint8_t *key;
#endif /* var_key_Nettle_Fortuna_defined */

#ifdef var_ctr_Nettle_Fortuna_defined
#line 285 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
uint8_t *ctr;
#endif /* var_ctr_Nettle_Fortuna_defined */

#ifdef var_data_Nettle_Fortuna_defined
#line 286 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
uint8_t *data;
#endif /* var_data_Nettle_Fortuna_defined */
};
#ifdef PIKE_DEBUG
/* Ensure the struct is used in a variable declaration, or else gdb might not see it. */
static struct Nettle_Fortuna_struct *Nettle_Fortuna_gdb_dummy_ptr;
#endif
#line 288 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
;

#ifndef AES256_KEY_SIZE
#define AES256_KEY_SIZE	(256>>3)
#endif

static void fortuna_generate(void)
{
aes_encrypt(&THIS->aes_ctx, 16, THIS->data, THIS->ctr);
INCREMENT(16, THIS->ctr);
}

static void fortuna_rekey(void)
{
fortuna_generate();
memcpy(THIS->key, THIS->data, 16);
fortuna_generate();
memcpy(THIS->key+16, THIS->data, 16);
aes_set_encrypt_key(&THIS->aes_ctx, AES256_KEY_SIZE, THIS->key);
}

/*! @decl void reseed(string(8bit) data)
   *! Generates new a new key based on the provided additional
   *! entropy.
   */
#define f_Nettle_Fortuna_reseed_defined

#ifdef f_Nettle_Fortuna_reseed_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Nettle_Fortuna_reseed_fun_num = 0;

#endif /* f_Nettle_Fortuna_reseed_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Nettle_Fortuna_reseed(INT32 args) {
#line 313 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
struct pike_string * data;
#line 313 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if(args != 1) wrong_number_of_args_error("reseed",args,1);
#line 313 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("reseed",1,"string(0..255)");
#line 313 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
debug_malloc_pass(data=Pike_sp[0-1].u.string);
{
sha256_update(&THIS->sha_ctx, 32, THIS->key);
sha256_update(&THIS->sha_ctx, data->len, (const uint8_t *)data->str);
sha256_digest(&THIS->sha_ctx, 32, THIS->key);
aes_set_encrypt_key(&THIS->aes_ctx, AES256_KEY_SIZE, THIS->key);
INCREMENT(16, THIS->ctr);
}

}
/*! @decl string(8bit) random_string(int(0..) len)
   *!
   *! Generates @[len] amount of pseudo random data. In contrast with
   *! the Fortuna PseudoRandomData function, which only allows 2^20
   *! bytes of random data per call, the necessary rekey operations
   *! are here performed internally, so no such restrictions apply.
   */
#define f_Nettle_Fortuna_random_string_defined

#ifdef f_Nettle_Fortuna_random_string_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Nettle_Fortuna_random_string_fun_num = 0;

#endif /* f_Nettle_Fortuna_random_string_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Nettle_Fortuna_random_string(INT32 args) {
#line 329 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
INT_TYPE len;
#line 329 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if(args != 1) wrong_number_of_args_error("random_string",args,1);
#line 329 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("random_string",1,"int");
#line 329 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
len=Pike_sp[0-1].u.integer;
{
int stored = 0;
struct string_builder s;

if(len<0) Pike_error("Length has to be positive.\n");
init_string_builder_alloc(&s, len+16, 0);

while( stored < len )
{
fortuna_generate();
string_builder_binary_strcat(&s, (const char *)THIS->data,
MINIMUM(16, (len-stored)));

/* This should really be MINIMUM(16, (len-stored)) instead of
         16, but it is only less than 16 in the last round, so it
         doesn't matter if we rekey here or not. */
stored += 16;

if( !(stored % (1<<20)) )
fortuna_rekey();
}

/* Inverse of the above conditional, to avoid having fortuna_rekey
       applied twice in the rare condition that the string length is a
       multiple of 1<<20. */
if( (stored % (1<<20)) )
fortuna_rekey();

do { struct pike_string * ret_=(finish_string_builder(&s)); pop_stack(); push_string(ret_); return; }while(0);
#line 359 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
}

}

#undef internal_init_Nettle_Fortuna_defined
#define internal_init_Nettle_Fortuna_defined

#undef Nettle_Fortuna_event_handler_defined
#define Nettle_Fortuna_event_handler_defined
static void init_Nettle_Fortuna_struct(void)
#line 362 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
{
THIS->ctr = xcalloc(1,16);
THIS->key = xcalloc(1,32);
aes_set_encrypt_key(&THIS->aes_ctx, AES256_KEY_SIZE, THIS->key);
sha256_init(&THIS->sha_ctx);
THIS->data = xalloc(16);
}


#undef internal_exit_Nettle_Fortuna_defined
#define internal_exit_Nettle_Fortuna_defined

#undef Nettle_Fortuna_event_handler_defined
#define Nettle_Fortuna_event_handler_defined
static void exit_Nettle_Fortuna_struct(void)
#line 372 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
{
free(THIS->ctr);
free(THIS->key);
free(THIS->data);
}

#ifdef Nettle_Fortuna_event_handler_defined
static void Nettle_Fortuna_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_Nettle_Fortuna_defined
  case PROG_EVENT_INIT: init_Nettle_Fortuna_struct(); break;

#endif /* internal_init_Nettle_Fortuna_defined */

#ifdef internal_exit_Nettle_Fortuna_defined
  case PROG_EVENT_EXIT: exit_Nettle_Fortuna_struct(); break;

#endif /* internal_exit_Nettle_Fortuna_defined */
  default: break; 
  }
}

#endif /* Nettle_Fortuna_event_handler_defined */
/*! @endclass
 */

/*! @decl int(0..) rsa_unpad(string(0..255) data, int type)
 *!
 *! Unpads a message that has been padded according to
 *! RSAES-PKCS1-V1_5-ENCODE(message) in PKCS#1 v2.2. The padding
 *! method used on the original message must be provided in the
 *! @[type] parameter. All content dependent processing is done in
 *! constant time for the same padding type and @[data] length.
 */
#define f_Nettle_rsa_unpad_defined

#ifdef f_Nettle_rsa_unpad_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Nettle_rsa_unpad_fun_num = 0;

#endif /* f_Nettle_rsa_unpad_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Nettle_rsa_unpad(INT32 args) {
#line 390 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
struct pike_string * data;
#line 390 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
INT_TYPE type;
#line 390 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if(args != 2) wrong_number_of_args_error("rsa_unpad",args,2);
#line 390 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if(TYPEOF(Pike_sp[0-2]) != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("rsa_unpad",1,"string(0..255)");
#line 390 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
debug_malloc_pass(data=Pike_sp[0-2].u.string);
#line 390 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if(TYPEOF(Pike_sp[1-2]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("rsa_unpad",2,"int");
#line 390 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
type=Pike_sp[1-2].u.integer;
{
int i, pad=0, nonpad=0, pos=0;
unsigned char *str;

NO_WIDE_STRING(data);

/* Indata is smaller than minimum size, so we can exit immediately
     without timing issue. 1 type + 8 padding + 1 delimiter + 1 value
     = 11 bytes. */
if(data->len < 11 ) do { INT_TYPE ret_=(0); pop_n_elems(2); push_int(ret_); return; }while(0);
#line 401 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
str = (unsigned char*)data->str + data->len - 1;

for(i=data->len-1; i>0; i--,str--)
{
switch(*str)
{
case 0: pos=i; break;
case 0xff: pad=i; break;
default: nonpad=i; break;
}
}

if( type==2 )
{
nonpad=pos+1;
pad=1;
}

if( (pad==1) + (nonpad>pos) + (*str==type) + (pos>8) == 4 )
do { INT_TYPE ret_=(pos+1); pop_n_elems(2); push_int(ret_); return; }while(0);do { INT_TYPE ret_=(
#line 421 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
0); pop_n_elems(2); push_int(ret_); return; }while(0);
#line 422 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
}


}
/*! @decl string(0..127) crypt_md5(string(0..255) password, @
 *!                                string(0..255) salt,@
 *!                                void|string(0..255) magic)
 *! Does the crypt_md5 abrakadabra (MD5 + snakeoil). It is assumed
 *! that @[salt] does not contain "$".
 *!
 *! The @[password] memory will be cleared before released.
 */
#define f_Nettle_crypt_md5_defined

#ifdef f_Nettle_crypt_md5_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Nettle_crypt_md5_fun_num = 0;

#endif /* f_Nettle_crypt_md5_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Nettle_crypt_md5(INT32 args) {
#line 433 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
struct pike_string * pw;
#line 433 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
struct pike_string * salt;
struct pike_string * magic;
#line 433 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if(args < 2) wrong_number_of_args_error("crypt_md5",args,2);
#line 433 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if(args > 3) wrong_number_of_args_error("crypt_md5",args,3);
#line 433 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if(TYPEOF(Pike_sp[0-args]) != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("crypt_md5",1,"string");
#line 433 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
debug_malloc_pass(pw=Pike_sp[0-args].u.string);
#line 433 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if(TYPEOF(Pike_sp[1-args]) != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("crypt_md5",2,"string");
#line 433 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
debug_malloc_pass(salt=Pike_sp[1-args].u.string);
if (args > 2 &&
    (TYPEOF(Pike_sp[2-args]) != PIKE_T_INT ||
     Pike_sp[2-args].u.integer)) {
#line 434 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
if(TYPEOF(Pike_sp[2-args]) != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("crypt_md5",3,"void|string");
#line 434 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
debug_malloc_pass(magic=Pike_sp[2-args].u.string);
#line 434 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
} else magic = NULL;
#line 441 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
{
char *hash;

/* Censor the password. */
push_string(pw);
args++;
add_ref(Pike_sp[-args].u.string = module_strings[0] /* "censored" */);

NO_WIDE_STRING(pw);
NO_WIDE_STRING(salt);

pw->flags |= STRING_CLEAR_ON_EXIT;

if(!magic)
{
hash = pike_crypt_md5(pw->len, pw->str, salt->len, salt->str,
3, "$1$");
}
else
{
NO_WIDE_STRING(magic);
hash = pike_crypt_md5(pw->len, pw->str, salt->len, salt->str,
magic->len, magic->str);
}

push_text(hash);
}

}
/*! @endmodule
 */

#line 472 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
#endif /* HAVE_LIBNETTLE */

PIKE_MODULE_INIT
{
#ifdef __NT__
 struct program *nt_program = NULL;
struct object *nt_object = NULL;
#endif /* __NT__ */
 
#ifdef module_strings_declared
module_strings[0] = 
  make_shared_binary_string("censored",
                            CONSTANT_STRLEN("censored"));
#endif

#ifdef CMOD_MAP_PROGRAM_IDS_DEFINED
set_program_id_to_id( ___cmod_map_program_ids );

#endif /* CMOD_MAP_PROGRAM_IDS_DEFINED */

#ifdef class_Nettle_Yarrow_defined

#ifdef PROG_NETTLE_YARROW_ID
#line 64 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
  START_NEW_PROGRAM_ID(NETTLE_YARROW);
#else
#line 64 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
  start_new_program();

#endif /* PROG_NETTLE_YARROW_ID */
#line 64 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
  Nettle_Yarrow_program = Pike_compiler->new_program;

#ifndef tObjImpl_NETTLE_YARROW

#undef tObjIs_NETTLE_YARROW
#define tObjIs_NETTLE_YARROW "\3\1\177\0\0\2"

#undef tObjImpl_NETTLE_YARROW
#define tObjImpl_NETTLE_YARROW "\3\0\177\0\0\2"

#endif /* tObjImpl_NETTLE_YARROW */

#ifdef THIS_NETTLE_YARROW
  Nettle_Yarrow_storage_offset = ADD_STORAGE(struct Nettle_Yarrow_struct);
#endif /* THIS_NETTLE_YARROW */

#ifdef Nettle_Yarrow_event_handler_defined
  pike_set_prog_event_callback(Nettle_Yarrow_event_handler);

#ifndef Nettle_Yarrow_gc_live_obj
  Pike_compiler->new_program->flags &= ~PROGRAM_LIVE_OBJ;

#endif /* Nettle_Yarrow_gc_live_obj */

#endif /* Nettle_Yarrow_event_handler_defined */

#ifdef f_Nettle_Yarrow_create_defined

#ifdef f_Nettle_Yarrow_create_fun_num_used
  f_Nettle_Yarrow_create_fun_num =
#endif /* f_Nettle_Yarrow_create_fun_num_used */
#line 79 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
    ADD_FUNCTION2("create", f_Nettle_Yarrow_create, tFunc(tOr(tVoid,"\10\200\0\0\0\177\377\377\377"),tVoid), ID_PROTECTED, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Nettle_Yarrow_create_defined */

#ifdef f_Nettle_Yarrow_seed_defined

#ifdef f_Nettle_Yarrow_seed_fun_num_used
  f_Nettle_Yarrow_seed_fun_num =
#endif /* f_Nettle_Yarrow_seed_fun_num_used */
#line 113 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
    ADD_FUNCTION2("seed", f_Nettle_Yarrow_seed, tFunc(tStr8,tObj), 0, OPT_SIDE_EFFECT);

#endif /* f_Nettle_Yarrow_seed_defined */

#ifdef f_Nettle_Yarrow_min_seed_size_defined

#ifdef f_Nettle_Yarrow_min_seed_size_fun_num_used
  f_Nettle_Yarrow_min_seed_size_fun_num =
#endif /* f_Nettle_Yarrow_min_seed_size_fun_num_used */
#line 131 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
    ADD_FUNCTION2("min_seed_size", f_Nettle_Yarrow_min_seed_size, tFunc(tNone,"\10\0\0\0\0\177\377\377\377"), 0, OPT_TRY_OPTIMIZE);

#endif /* f_Nettle_Yarrow_min_seed_size_defined */

#ifdef f_Nettle_Yarrow_is_seeded_defined

#ifdef f_Nettle_Yarrow_is_seeded_fun_num_used
  f_Nettle_Yarrow_is_seeded_fun_num =
#endif /* f_Nettle_Yarrow_is_seeded_fun_num_used */
#line 143 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
    ADD_FUNCTION2("is_seeded", f_Nettle_Yarrow_is_seeded, tFunc(tNone,"\10\0\0\0\0\0\0\0\1"), 0, OPT_EXTERNAL_DEPEND);

#endif /* f_Nettle_Yarrow_is_seeded_defined */

#ifdef f_Nettle_Yarrow_force_reseed_defined

#ifdef f_Nettle_Yarrow_force_reseed_fun_num_used
  f_Nettle_Yarrow_force_reseed_fun_num =
#endif /* f_Nettle_Yarrow_force_reseed_fun_num_used */
#line 154 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
    ADD_FUNCTION2("force_reseed", f_Nettle_Yarrow_force_reseed, tFunc(tNone,tVoid), 0, OPT_SIDE_EFFECT);

#endif /* f_Nettle_Yarrow_force_reseed_defined */

#ifdef f_Nettle_Yarrow_update_defined

#ifdef f_Nettle_Yarrow_update_fun_num_used
  f_Nettle_Yarrow_update_fun_num =
#endif /* f_Nettle_Yarrow_update_fun_num_used */
#line 177 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
    ADD_FUNCTION2("update", f_Nettle_Yarrow_update, tFunc(tStr8 "\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377","\10\0\0\0\0\0\0\0\1"), 0, OPT_SIDE_EFFECT);

#endif /* f_Nettle_Yarrow_update_defined */

#ifdef f_Nettle_Yarrow_needed_sources_defined

#ifdef f_Nettle_Yarrow_needed_sources_fun_num_used
  f_Nettle_Yarrow_needed_sources_fun_num =
#endif /* f_Nettle_Yarrow_needed_sources_fun_num_used */
#line 200 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
    ADD_FUNCTION2("needed_sources", f_Nettle_Yarrow_needed_sources, tFunc(tNone,"\10\0\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND);

#endif /* f_Nettle_Yarrow_needed_sources_defined */

#ifdef f_Nettle_Yarrow_random_string_defined

#ifdef f_Nettle_Yarrow_random_string_fun_num_used
  f_Nettle_Yarrow_random_string_fun_num =
#endif /* f_Nettle_Yarrow_random_string_fun_num_used */
    ADD_FUNCTION2("random_string", f_Nettle_Yarrow_random_string, tFunc("\10\200\0\0\0\177\377\377\377",tStr8), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Nettle_Yarrow_random_string_defined */

#ifdef f_Nettle_Yarrow_get_seed_defined

#ifdef f_Nettle_Yarrow_get_seed_fun_num_used
  f_Nettle_Yarrow_get_seed_fun_num =
#endif /* f_Nettle_Yarrow_get_seed_fun_num_used */
#line 231 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
    ADD_FUNCTION2("get_seed", f_Nettle_Yarrow_get_seed, tDeprecated(tFunc(tNone, tStr8)), 0, OPT_EXTERNAL_DEPEND);

#endif /* f_Nettle_Yarrow_get_seed_defined */
#line 65 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
  Pike_compiler->new_program->flags |= PROGRAM_CLEAR_STORAGE;
#line 64 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
  Nettle_Yarrow_program=end_program();
#line 64 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
#ifdef Nettle_Yarrow_program_fun_num_used
Nettle_Yarrow_program_fun_num=
#endif
 add_program_constant("Yarrow",Nettle_Yarrow_program,0);

#endif /* class_Nettle_Yarrow_defined */

#ifdef class_Nettle_Fortuna_defined

#ifdef PROG_NETTLE_FORTUNA_ID
#line 279 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
  START_NEW_PROGRAM_ID(NETTLE_FORTUNA);
#else
#line 279 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
  start_new_program();

#endif /* PROG_NETTLE_FORTUNA_ID */
#line 279 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
  Nettle_Fortuna_program = Pike_compiler->new_program;

#ifndef tObjImpl_NETTLE_FORTUNA

#undef tObjIs_NETTLE_FORTUNA
#define tObjIs_NETTLE_FORTUNA "\3\1\177\0\0\3"

#undef tObjImpl_NETTLE_FORTUNA
#define tObjImpl_NETTLE_FORTUNA "\3\0\177\0\0\3"

#endif /* tObjImpl_NETTLE_FORTUNA */

#ifdef THIS_NETTLE_FORTUNA
  Nettle_Fortuna_storage_offset = ADD_STORAGE(struct Nettle_Fortuna_struct);
#endif /* THIS_NETTLE_FORTUNA */

#ifdef Nettle_Fortuna_event_handler_defined
  pike_set_prog_event_callback(Nettle_Fortuna_event_handler);

#ifndef Nettle_Fortuna_gc_live_obj
  Pike_compiler->new_program->flags &= ~PROGRAM_LIVE_OBJ;

#endif /* Nettle_Fortuna_gc_live_obj */

#endif /* Nettle_Fortuna_event_handler_defined */

#ifdef f_Nettle_Fortuna_reseed_defined

#ifdef f_Nettle_Fortuna_reseed_fun_num_used
  f_Nettle_Fortuna_reseed_fun_num =
#endif /* f_Nettle_Fortuna_reseed_fun_num_used */
#line 313 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
    ADD_FUNCTION2("reseed", f_Nettle_Fortuna_reseed, tFunc(tStr8,tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Nettle_Fortuna_reseed_defined */

#ifdef f_Nettle_Fortuna_random_string_defined

#ifdef f_Nettle_Fortuna_random_string_fun_num_used
  f_Nettle_Fortuna_random_string_fun_num =
#endif /* f_Nettle_Fortuna_random_string_fun_num_used */
#line 329 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
    ADD_FUNCTION2("random_string", f_Nettle_Fortuna_random_string, tFunc("\10\200\0\0\0\177\377\377\377",tStr8), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Nettle_Fortuna_random_string_defined */
#line 280 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
  Pike_compiler->new_program->flags |= PROGRAM_CLEAR_STORAGE;
#line 279 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
  Nettle_Fortuna_program=end_program();
#line 279 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
#ifdef Nettle_Fortuna_program_fun_num_used
Nettle_Fortuna_program_fun_num=
#endif
 add_program_constant("Fortuna",Nettle_Fortuna_program,0);

#endif /* class_Nettle_Fortuna_defined */

#ifdef f_Nettle_version_defined

#ifdef f_Nettle_version_fun_num_used
  f_Nettle_version_fun_num =
#endif /* f_Nettle_version_fun_num_used */
#line 36 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
    ADD_FUNCTION2("version", f_Nettle_version, tFunc(tNone,tStr), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Nettle_version_defined */

#ifdef f_Nettle_rsa_unpad_defined

#ifdef f_Nettle_rsa_unpad_fun_num_used
  f_Nettle_rsa_unpad_fun_num =
#endif /* f_Nettle_rsa_unpad_fun_num_used */
#line 390 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
    ADD_FUNCTION2("rsa_unpad", f_Nettle_rsa_unpad, tFunc(tStr8 "\10\200\0\0\0\177\377\377\377","\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Nettle_rsa_unpad_defined */

#ifdef f_Nettle_crypt_md5_defined

#ifdef f_Nettle_crypt_md5_fun_num_used
  f_Nettle_crypt_md5_fun_num =
#endif /* f_Nettle_crypt_md5_fun_num_used */
#line 433 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
    ADD_FUNCTION2("crypt_md5", f_Nettle_crypt_md5, tFunc(tStr8 tStr8 tOr(tStr8, tVoid), tStr7), 0, OPT_TRY_OPTIMIZE);

#endif /* f_Nettle_crypt_md5_defined */

#ifdef CMOD_MAP_PROGRAM_IDS_DEFINED
set_program_id_to_id( 0 );
#endif /* CMOD_MAP_PROGRAM_IDS_DEFINED */
#line 480 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
;
#ifdef HAVE_LIBNETTLE
 hash_init();
mac_init();
cipher_init();
aead_init();
#endif /* HAVE_LIBNETTLE */
#ifdef __NT__
 start_new_program();
nt_init();
nt_program = end_program();
add_object_constant("NT", nt_object=clone_object(nt_program,0), 0);
free_object(nt_object);
free_program(nt_program);
#endif /* __NT__ */
#ifdef HAVE_LIBHOGWEED
 hogweed_init();
#endif
}

PIKE_MODULE_EXIT
{
#ifdef HAVE_LIBNETTLE
 aead_exit();
cipher_exit();
mac_exit();
hash_exit();
#endif /* HAVE_LIBNETTLE */
#ifdef __NT__
 nt_exit();
#endif /* __NT__ */
#ifdef HAVE_LIBHOGWEED
 hogweed_exit();
#endif
 
#ifdef class_Nettle_Yarrow_defined
  if(Nettle_Yarrow_program) {
#line 64 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
    free_program(Nettle_Yarrow_program);
    Nettle_Yarrow_program=0;
  }

#endif /* class_Nettle_Yarrow_defined */

#ifdef class_Nettle_Fortuna_defined
  if(Nettle_Fortuna_program) {
#line 279 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
    free_program(Nettle_Fortuna_program);
    Nettle_Fortuna_program=0;
  }

#endif /* class_Nettle_Fortuna_defined */

#ifdef module_strings_declared
{
  int i;
  for(i=0; i < 1; i++) {
    if (module_strings[i]) free_string(module_strings[i]);
    module_strings[i] = NULL;
  }
}
#endif
#line 514 "/home/zino/hack/pike8-rel/pike/src/post_modules/Nettle/nettle.cmod"
;
}


#ifdef CMOD_MAP_PROGRAM_IDS_DEFINED
static int ___cmod_map_program_ids(int id)
{
  int i = 0;
  if( (id&0x7f000000) != 0x7f000000 ) return id;
  id = id&0x00ffffff;
#ifdef class_Nettle_Yarrow_defined
if(id==2) return Nettle_Yarrow_program->id;
#endif
#ifdef class_Nettle_Fortuna_defined
if(id==3) return Nettle_Fortuna_program->id;
#endif
  return 0;
}
#endif /* CMOD_MAP_PROGRAM_IDS_DEFINED */
