/* Generated from "/home/per/src/pike80/src/modules/Inotify/inotify.cmod" by precompile.pike running Pike v8.1 release 0
 *
 * Do NOT edit this file.
 */

#undef PRECOMPILE_API_VERSION
#define PRECOMPILE_API_VERSION 6



#undef cmod___CMOD__
#define cmod___CMOD__ 1
#line 1 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
#line 1 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
#line 1 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
#line 2979 "/home/per/src/pike80/lib/modules/Tools.pmod/Standalone.pmod/precompile.pike"







#line 2986 "/home/per/src/pike80/lib/modules/Tools.pmod/Standalone.pmod/precompile.pike"
#line 1 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
#line 1 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
/* vim:syntax=c
 */
/* -*- c -*-
|| This file is part of Pike. For copyright information see COPYRIGHT.
|| Pike is distributed under GPL, LGPL and MPL. See the file COPYING
|| for more information.
*/

/* Module for the linux inotify api.
 *
 * Ref: inotify(7)
 *
 */

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include "global.h"
#include "interpret.h"
#include "module.h"
#include "program.h"
#include "stralloc.h"
#include "svalue.h"
#include "object.h"
#include "pike_types.h"
#include "builtin_functions.h"
#include "fdlib.h"
#include "pike_threadlib.h"

#ifdef HAVE_SYS_INOTIFY_H

#include <sys/inotify.h>
#include <errno.h>
#include <unistd.h>

/* Autoconf helpfully litters generated files with colliding defines. */
#undef PACKAGE_BUGREPORT
#undef PACKAGE_NAME
#undef PACKAGE_STRING
#undef PACKAGE_TARNAME
#undef PACKAGE_URL
#undef PACKAGE_VERSION

#include "modules/_Stdio/file_machine.h"
#include "modules/_Stdio/file.h"



#define CMOD_MAP_PROGRAM_IDS_DEFINED 1
static int ___cmod_map_program_ids(int id);
#ifndef TYPEOF
static void set_program_id_to_id(void*UNUSED(id)){}
/* Compat with older Pikes. */
#define TYPEOF(SVAL)	((SVAL).type)
#define SUBTYPEOF(SVAL)	((SVAL).subtype)
#define SET_SVAL_TYPE(SVAL, TYPE)	(TYPEOF(SVAL) = TYPE)
#define SET_SVAL_SUBTYPE(SVAL, TYPE)	(SUBTYPEOF(SVAL) = TYPE)
#define SET_SVAL(SVAL, TYPE, SUBTYPE, FIELD, EXPR) do {	\
    /* Set the type afterwards to avoid a clobbered	\
     * svalue in case EXPR throws. */			\
    (SVAL).u.FIELD = (EXPR);				\
    SET_SVAL_TYPE((SVAL), (TYPE));			\
    SET_SVAL_SUBTYPE((SVAL), (SUBTYPE));		\
  } while(0)
#else /* */
PMOD_EXPORT void set_program_id_to_id( int (*to)(int) );
#endif /* !TYPEOF */


#ifndef DEFAULT_CMOD_STORAGE
#define CMOD_COND_USED
#define DEFAULT_CMOD_STORAGE static
#endif
#ifndef CMOD_COND_USED
# define f_Inotify_cq__Instance_get_fd_fun_num_used 1
#else
#undef f_Inotify_cq__Instance_get_fd_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Inotify_parse_event_fun_num_used 1
#else
#undef f_Inotify_parse_event_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define Inotify_cq__Instance_program_fun_num_used 1
#else
#undef Inotify_cq__Instance_program_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Inotify_cq__Instance_fd_fun_num_used 1
#else
#undef f_Inotify_cq__Instance_fd_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Inotify_cq__Instance_add_watch_fun_num_used 1
#else
#undef f_Inotify_cq__Instance_add_watch_fun_num_used
#endif
#ifndef CMOD_COND_USED
# define f_Inotify_cq__Instance_rm_watch_fun_num_used 1
#else
#undef f_Inotify_cq__Instance_rm_watch_fun_num_used
#endif
/*! @module System */

/*! @module Inotify
 *! This module implements an API to linux inotify. It is available on all
 *! kernels from version 2.6.13 onwards. Inotify offers fast and scalable file
 *! notifications.
 */

/*! @decl constant IN_ALL_EVENTS
 *! This is a derived constant that is not part of the standard inotify API. It
 *! is the union of all other constants.
 *!
 *! @decl constant IN_ACCESS
 *! @decl constant IN_ATTRIB
 *! @decl constant IN_CLOSE
 *! @decl constant IN_CLOSE_WRITE
 *! @decl constant IN_CLOSE_NOWRITE
 *! @decl constant IN_CREATE
 *! @decl constant IN_DELETE
 *! @decl constant IN_DELETE_SELF
 *! @decl constant IN_MODIFY
 *! @decl constant IN_MOVE_SELF
 *! @decl constant IN_MOVED_FROM
 *! @decl constant IN_MOVED_TO
 *! @decl constant IN_OPEN
 *! @decl constant IN_MOVE
 *! @decl constant IN_CLOSE
 *! @decl constant IN_DONT_FOLLOW
 *! @decl constant IN_MASK_ADD
 *! @decl constant IN_ONESHOT
 *! @decl constant IN_ONLYDIR
 *! @decl constant IN_IGNORED
 *! @decl constant IN_ISDIR
 *! @decl constant IN_Q_OVERFLOW
 *! @decl constant IN_UNMOUNT
 *! 	Please have a look at the inotify(7) manpage for information about
 *!	these constants.
 *! @note
 *! 	Some constants may not be available when the module has been
 *!	compiled on a machine with linux kernel before 2.6.15. See the
 *!	manpage for more details.
 */

/*! @decl array(string|int) parse_event(string data)
 *! Parses one inotify_event struct from @expr{data@}.
 *! @returns
 *! 	Returns an array consisting of
 *! 	@array
 *!	    @elem int 0
 *! 		The watch descriptor returned by @[_Instance()->add_watch()]
 *!		when the watch for this file was added.
 *!	    @elem int 1
 *! 		An integer that describes the event that occured. See
 *!		the inotify manpage for a list of possible events and
 *!		their numerical identifiers.
 *!	    @elem int 2
 *! 		An integer cookie that can be used to group together
 *!		different events that were triggered by moving a file
 *!		from one location to another.
 *! 	    @elem string 3
 *! 		The name of the file. This will only be present if the
 *!		event happened to a file in a directory that was
 *!		watched, e.g. with @[System.Inotify.IN_CREATE].
 *! 		Otherwise this will be 0.
 *!	    @elem int 4
 *! 		The length of the data that has been parsed. If the @[data]
 *!		string contains more than one inotify event, this parse
 *!		function needs to be called again with the remainder as
 *!		an argument.
 *! 	@endarray
 */
#define f_Inotify_parse_event_defined

#ifdef f_Inotify_parse_event_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Inotify_parse_event_fun_num = 0;

#endif /* f_Inotify_parse_event_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Inotify_parse_event(INT32 args) {
#line 121 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
struct pike_string * data;
#line 121 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
if(args != 1) wrong_number_of_args_error("parse_event",args,1);
#line 121 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("parse_event",1,"string");
#line 121 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
debug_malloc_pass(data=Pike_sp[0-1].u.string);
#line 121 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
{
struct inotify_event event;
size_t len;
const char * d;

if (data->size_shift)
Pike_error("Inotify events should not be wide.\n");

if ((size_t)data->len < sizeof(struct inotify_event))
Pike_error("Malformed data.\n");

d = data->str;

memcpy(&event, d, sizeof(struct inotify_event));

push_int(event.wd);
push_int((int)event.mask);
push_int((int)event.cookie);

if (event.len) {
if (event.len > data->len - sizeof(struct inotify_event))
Pike_error("Data missing. Got %u expected %u bytes.\n", (unsigned)(data->len - sizeof(struct inotify_event)), event.len);
d += sizeof(struct inotify_event);
push_string(make_shared_binary_string(d, strnlen(d, event.len)));
} else {
push_int(0);
}

push_int((int)(event.len + sizeof(struct inotify_event)));

f_aggregate(5);
stack_swap();
pop_stack();
}

}
/*! @class _Instance
 *! 	Simple wrapper class that gives direct access to the @tt{inotify(7)@}
 *!	interface. On create an inotify instance is initiated by calling
 *!	@tt{inotify_init(2)@}. Every object of this class has its own inotify
 *!	file descriptor. Use this class only if you want direct access to
 *!	the file descriptor to read from it manually. For a more user
 *!	friendly inferface use @[System.Inotify.Instance].
 *!
 *! @seealso
 *!     @[System.Inotify.Instance]
 */

#undef class_Inotify_cq__Instance_defined
#define class_Inotify_cq__Instance_defined
DEFAULT_CMOD_STORAGE struct program *Inotify_cq__Instance_program=NULL;

#ifdef Inotify_cq__Instance_program_fun_num_used
static int Inotify_cq__Instance_program_fun_num=-1;
#endif /* Inotify_cq__Instance_program_fun_num_used */

#undef var_fd_Inotify_cq__Instance_defined
#define var_fd_Inotify_cq__Instance_defined

#undef var_fd_object_Inotify_cq__Instance_defined
#define var_fd_object_Inotify_cq__Instance_defined

#undef THIS
#define THIS ((struct Inotify_cq__Instance_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_INOTIFY_CQ__INSTANCE
#define THIS_INOTIFY_CQ__INSTANCE ((struct Inotify_cq__Instance_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_INOTIFY_CQ__INSTANCE
#define OBJ2_INOTIFY_CQ__INSTANCE(o) ((struct Inotify_cq__Instance_struct *)(o->storage+Inotify_cq__Instance_storage_offset))

#undef GET_INOTIFY_CQ__INSTANCE_STORAGE
#define GET_INOTIFY_CQ__INSTANCE_STORAGE(o) ((struct Inotify_cq__Instance_struct *)(o->storage+Inotify_cq__Instance_storage_offset)
static ptrdiff_t Inotify_cq__Instance_storage_offset;
struct Inotify_cq__Instance_struct {

#ifdef var_fd_Inotify_cq__Instance_defined
#line 168 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
int fd;
#endif /* var_fd_Inotify_cq__Instance_defined */

#ifdef var_fd_object_Inotify_cq__Instance_defined
#line 169 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
struct object * fd_object;
#endif /* var_fd_object_Inotify_cq__Instance_defined */
};
#ifdef PIKE_DEBUG
/* Ensure the struct is used in a variable declaration, or else gdb might not see it. */
static struct Inotify_cq__Instance_struct *Inotify_cq__Instance_gdb_dummy_ptr;
#endif
/*! @decl int add_watch(string file, int mask)
     *! Add a watch for a certain file or directory and specific events.
     *! Adding more than one watch for one file will overwrite the
     *! previous watch unless @[System.Inotify.IN_MASK_ADD] is contained
     *! in the mask.
     *! @param path
     *!	    Path of the file or directory.
     *! @param mask
     *!	    Integer mask specifying the event type. This can be a
     *!	    combination of different event types using bitwise OR.
     *!	    See the inotify manpage for possible values and their
     *!	    description. The values defined by the inotify header
     *!	    file are exported by @[System.Inotify] as constants
     *!	    using the same names (e.g. @[System.Inotify.IN_CREATE]).
     *! @returns
     *!     Returns a watch descriptor.
     *! @note
     *!	    Subdirectories are not watched. If you want to watch
     *!	    subdirectories as well, you need to add watches for
     *!	    them individually.
     *!
     *! @seealso
     *!     @[rm_watch()], @[parse_event()]
     */
#define f_Inotify_cq__Instance_add_watch_defined

#ifdef f_Inotify_cq__Instance_add_watch_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Inotify_cq__Instance_add_watch_fun_num = 0;

#endif /* f_Inotify_cq__Instance_add_watch_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Inotify_cq__Instance_add_watch(INT32 args) {
#line 195 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
struct pike_string * file;
#line 195 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
INT_TYPE mask;
#line 195 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
if(args != 2) wrong_number_of_args_error("add_watch",args,2);
#line 195 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
if(TYPEOF(Pike_sp[0-2]) != PIKE_T_STRING) SIMPLE_ARG_TYPE_ERROR("add_watch",1,"string");
#line 195 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
debug_malloc_pass(file=Pike_sp[0-2].u.string);
#line 195 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
if(TYPEOF(Pike_sp[1-2]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("add_watch",2,"int");
#line 195 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
mask=Pike_sp[1-2].u.integer;
#line 195 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
{
INT32 err;

if (file->size_shift)
Pike_error("Widestring filenames are not allowed.\n");

err = inotify_add_watch(THIS->fd, file->str, (INT32)mask);

if (err == -1)
Pike_error("inotify_add_watch failed: %s\n",
strerror(errno));
else
do { INT_TYPE ret_=(err); pop_n_elems(2); push_int(ret_); return; }while(0);
#line 208 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
}


}
/*! @decl object get_fd()
     *! @returns
     *!	    Returns the file descriptor associated with this inotify instance.
     *! @note
     *!	    Use @[fd()] instead.
     */
#define f_Inotify_cq__Instance_get_fd_defined

#ifdef f_Inotify_cq__Instance_get_fd_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Inotify_cq__Instance_get_fd_fun_num = 0;

#endif /* f_Inotify_cq__Instance_get_fd_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Inotify_cq__Instance_get_fd(INT32 args) {
#line 217 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
if(args != 0) wrong_number_of_args_error("get_fd",args,0);
#line 217 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
{
push_int(THIS->fd);
}

}
/*! @decl object fd()
     *! @returns
     *!	    Returns a instance of @[Stdio.Fd] corresponding to the inotify instance. This can passed to
     *!	    @[Stdio.File()->assign()].
     */
#define f_Inotify_cq__Instance_fd_defined

#ifdef f_Inotify_cq__Instance_fd_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Inotify_cq__Instance_fd_fun_num = 0;

#endif /* f_Inotify_cq__Instance_fd_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Inotify_cq__Instance_fd(INT32 args) {
#line 226 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
if(args != 0) wrong_number_of_args_error("fd",args,0);
#line 226 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
{
ref_push_object(THIS->fd_object);
}

}
/*! @decl int rm_watch(int wd)
     *! Remove a watch.
     *! @param wd
     *!	    The watch descriptor that was returned by @[add_watch()].
     */
#define f_Inotify_cq__Instance_rm_watch_defined

#ifdef f_Inotify_cq__Instance_rm_watch_fun_num_used
DEFAULT_CMOD_STORAGE ptrdiff_t f_Inotify_cq__Instance_rm_watch_fun_num = 0;

#endif /* f_Inotify_cq__Instance_rm_watch_fun_num_used */
DEFAULT_CMOD_STORAGE void f_Inotify_cq__Instance_rm_watch(INT32 args) {
#line 235 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
INT_TYPE wd;
#line 235 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
if(args != 1) wrong_number_of_args_error("rm_watch",args,1);
#line 235 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
if(TYPEOF(Pike_sp[0-1]) != PIKE_T_INT) SIMPLE_ARG_TYPE_ERROR("rm_watch",1,"int");
#line 235 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
wd=Pike_sp[0-1].u.integer;
#line 235 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
{
INT32 err;

err = inotify_rm_watch(THIS->fd, wd);

if (err == 0) {
return;
}

if (errno == EINVAL) {
Pike_error("Wrong argument to rm_watch().\n");
} else if (errno == EBADF) {
Pike_error("Oups. I feel funny inside.\n");
}
}

}

#undef internal_init_Inotify_cq__Instance_defined
#define internal_init_Inotify_cq__Instance_defined

#undef Inotify_cq__Instance_event_handler_defined
#define Inotify_cq__Instance_event_handler_defined
static void init_Inotify_cq__Instance_struct(void)
#line 251 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
{
struct object * o;
THIS->fd = inotify_init();
THIS->fd_object = NULL;

if (THIS->fd == -1) switch (errno) {
case EMFILE:
Pike_error("User limit on inotify instances reached.\n");
case ENFILE:
Pike_error("User limit on file descriptors reached.\n");
case ENOMEM:
Pike_error("No free kernel memory available.\n");
}

o = file_make_object_from_fd(THIS->fd, FILE_READ, fd_CAN_NONBLOCK);
/* We will close the inotify fd on EXIT */
((struct my_file *)(o->storage + o->prog->inherits->storage_offset))->flags |= FILE_NO_CLOSE_ON_DESTRUCT;
THIS->fd_object = o;
}


#undef Inotify_cq__Instance_gc_live_obj
#define Inotify_cq__Instance_gc_live_obj

#undef internal_exit_Inotify_cq__Instance_defined
#define internal_exit_Inotify_cq__Instance_defined

#undef Inotify_cq__Instance_event_handler_defined
#define Inotify_cq__Instance_event_handler_defined
static void exit_Inotify_cq__Instance_struct(void)
#line 271 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
{
if (THIS->fd_object) {
free_object(THIS->fd_object);
THIS->fd_object = NULL;
}
if (THIS->fd != -1) {
int fd = THIS->fd;
/*
	     * currently (linux 3.4.9) closing an inotify fd takes in the order of 100 ms
	     */
THREADS_ALLOW();
close(fd);
THREADS_DISALLOW();
}
}

#ifdef Inotify_cq__Instance_event_handler_defined
static void Inotify_cq__Instance_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_Inotify_cq__Instance_defined
  case PROG_EVENT_INIT: init_Inotify_cq__Instance_struct(); break;

#endif /* internal_init_Inotify_cq__Instance_defined */

#ifdef internal_exit_Inotify_cq__Instance_defined
  case PROG_EVENT_EXIT: exit_Inotify_cq__Instance_struct(); break;

#endif /* internal_exit_Inotify_cq__Instance_defined */
  default: break; 
  }
}

#endif /* Inotify_cq__Instance_event_handler_defined */
/*! @endclass
 */

#line 291 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
#define ADD_ICONST(name) do {			\
    add_integer_constant(#name, name, 0);	\
} while(0);

#else /* !HAVE_SYS_INOTIFY_H */

#define ADD_ICONST(name)

#endif /* HAVE_SYS_INOTIFY_H */

PIKE_MODULE_INIT {
ADD_ICONST(IN_ACCESS);
ADD_ICONST(IN_ALL_EVENTS);
ADD_ICONST(IN_ATTRIB);
ADD_ICONST(IN_CLOSE_WRITE);
ADD_ICONST(IN_CLOSE_NOWRITE);
ADD_ICONST(IN_CREATE);
ADD_ICONST(IN_DELETE);
ADD_ICONST(IN_DELETE_SELF);
ADD_ICONST(IN_MODIFY);
ADD_ICONST(IN_MOVE_SELF);
ADD_ICONST(IN_MOVED_FROM);
ADD_ICONST(IN_MOVED_TO);
ADD_ICONST(IN_OPEN);

ADD_ICONST(IN_MOVE);
ADD_ICONST(IN_CLOSE);

/* some of these came with 2.6.15 linux and 2.5 glibc */
#ifdef IN_DONT_FOLLOW
 ADD_ICONST(IN_DONT_FOLLOW);
#endif
#ifdef IN_MASK_ADD
 ADD_ICONST(IN_MASK_ADD);
#endif
 ADD_ICONST(IN_ONESHOT);
#ifdef IN_ONLYDIR
 ADD_ICONST(IN_ONLYDIR);
#endif

ADD_ICONST(IN_IGNORED);
ADD_ICONST(IN_ISDIR);
ADD_ICONST(IN_Q_OVERFLOW);
ADD_ICONST(IN_UNMOUNT);


#ifdef CMOD_MAP_PROGRAM_IDS_DEFINED
set_program_id_to_id( ___cmod_map_program_ids );

#endif /* CMOD_MAP_PROGRAM_IDS_DEFINED */

#ifdef class_Inotify_cq__Instance_defined

#ifdef PROG_INOTIFY_CQ__INSTANCE_ID
#line 167 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
  START_NEW_PROGRAM_ID(INOTIFY_CQ__INSTANCE);
#else
#line 167 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
  start_new_program();

#endif /* PROG_INOTIFY_CQ__INSTANCE_ID */
#line 167 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
  Inotify_cq__Instance_program = Pike_compiler->new_program;

#ifndef tObjImpl_INOTIFY_CQ__INSTANCE

#undef tObjIs_INOTIFY_CQ__INSTANCE
#define tObjIs_INOTIFY_CQ__INSTANCE "\3\1\177\0\0\2"

#undef tObjImpl_INOTIFY_CQ__INSTANCE
#define tObjImpl_INOTIFY_CQ__INSTANCE "\3\0\177\0\0\2"

#endif /* tObjImpl_INOTIFY_CQ__INSTANCE */

#ifdef THIS_INOTIFY_CQ__INSTANCE
  Inotify_cq__Instance_storage_offset = ADD_STORAGE(struct Inotify_cq__Instance_struct);
#endif /* THIS_INOTIFY_CQ__INSTANCE */

#ifdef Inotify_cq__Instance_event_handler_defined
  pike_set_prog_event_callback(Inotify_cq__Instance_event_handler);

#ifndef Inotify_cq__Instance_gc_live_obj
  Pike_compiler->new_program->flags &= ~PROGRAM_LIVE_OBJ;

#endif /* Inotify_cq__Instance_gc_live_obj */

#endif /* Inotify_cq__Instance_event_handler_defined */

#ifdef f_Inotify_cq__Instance_add_watch_defined

#ifdef f_Inotify_cq__Instance_add_watch_fun_num_used
  f_Inotify_cq__Instance_add_watch_fun_num =
#endif /* f_Inotify_cq__Instance_add_watch_fun_num_used */
#line 195 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
    ADD_FUNCTION2("add_watch", f_Inotify_cq__Instance_add_watch, tFunc(tStr "\10\200\0\0\0\177\377\377\377","\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Inotify_cq__Instance_add_watch_defined */

#ifdef f_Inotify_cq__Instance_get_fd_defined

#ifdef f_Inotify_cq__Instance_get_fd_fun_num_used
  f_Inotify_cq__Instance_get_fd_fun_num =
#endif /* f_Inotify_cq__Instance_get_fd_fun_num_used */
#line 217 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
    ADD_FUNCTION2("get_fd", f_Inotify_cq__Instance_get_fd, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Inotify_cq__Instance_get_fd_defined */

#ifdef f_Inotify_cq__Instance_fd_defined

#ifdef f_Inotify_cq__Instance_fd_fun_num_used
  f_Inotify_cq__Instance_fd_fun_num =
#endif /* f_Inotify_cq__Instance_fd_fun_num_used */
    ADD_FUNCTION2("fd", f_Inotify_cq__Instance_fd, tFunc(tNone,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Inotify_cq__Instance_fd_defined */

#ifdef f_Inotify_cq__Instance_rm_watch_defined

#ifdef f_Inotify_cq__Instance_rm_watch_fun_num_used
  f_Inotify_cq__Instance_rm_watch_fun_num =
#endif /* f_Inotify_cq__Instance_rm_watch_fun_num_used */
    ADD_FUNCTION2("rm_watch", f_Inotify_cq__Instance_rm_watch, tFunc("\10\200\0\0\0\177\377\377\377",tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Inotify_cq__Instance_rm_watch_defined */
#line 167 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
  Inotify_cq__Instance_program=end_program();
#line 167 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
#ifdef Inotify_cq__Instance_program_fun_num_used
Inotify_cq__Instance_program_fun_num=
#endif
 add_program_constant("_Instance",Inotify_cq__Instance_program,0);

#endif /* class_Inotify_cq__Instance_defined */

#ifdef f_Inotify_parse_event_defined

#ifdef f_Inotify_parse_event_fun_num_used
  f_Inotify_parse_event_fun_num =
#endif /* f_Inotify_parse_event_fun_num_used */
#line 121 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
    ADD_FUNCTION2("parse_event", f_Inotify_parse_event, tFunc(tStr,tArr(tOr(tStr,"\10\200\0\0\0\177\377\377\377"))), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Inotify_parse_event_defined */

#ifdef CMOD_MAP_PROGRAM_IDS_DEFINED
set_program_id_to_id( 0 );
#endif /* CMOD_MAP_PROGRAM_IDS_DEFINED */
#line 337 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
}

PIKE_MODULE_EXIT {

#ifdef class_Inotify_cq__Instance_defined
  if(Inotify_cq__Instance_program) {
#line 167 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
    free_program(Inotify_cq__Instance_program);
    Inotify_cq__Instance_program=0;
  }

#endif /* class_Inotify_cq__Instance_defined */
#line 341 "/home/per/src/pike80/src/modules/Inotify/inotify.cmod"
}

/*! @endmodule
 */
/*! @endmodule
 */


#ifdef CMOD_MAP_PROGRAM_IDS_DEFINED
static int ___cmod_map_program_ids(int id)
{
  int i = 0;
  if( (id&0x7f000000) != 0x7f000000 ) return id;
  id = id&0x00ffffff;
#ifdef class_Inotify_cq__Instance_defined
if(id==2) return Inotify_cq__Instance_program->id;
#endif
  return 0;
}
#endif /* CMOD_MAP_PROGRAM_IDS_DEFINED */
