#line 1 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
/* -*- c -*-
|| This file is part of Pike. For copyright information see COPYRIGHT.
|| Pike is distributed under GPL, LGPL and MPL. See the file COPYING
|| for more information.
|| $Id: mpf.cmod,v 1.28 2004/03/23 18:56:57 nilsson Exp $
*/

#include "global.h"
RCSID("$Id: mpf.cmod,v 1.28 2004/03/23 18:56:57 nilsson Exp $");
#include "gmp_machine.h"

#if defined(HAVE_GMP2_GMP_H) && defined(HAVE_LIBGMP2)
#define USE_GMP2
#else /* !HAVE_GMP2_GMP_H || !HAVE_LIBGMP2 */
#if defined(HAVE_GMP_H) && defined(HAVE_LIBGMP)
#define USE_GMP
#endif /* HAVE_GMP_H && HAVE_LIBGMP */
#endif /* HAVE_GMP2_GMP_H && HAVE_LIBGMP2 */

#if defined(USE_GMP) || defined(USE_GMP2)

#include "interpret.h"
#include "svalue.h"
#include "stralloc.h"
#include "array.h"
#include "pike_macros.h"
#include "program.h"
#include "stralloc.h"
#include "object.h"
#include "pike_types.h"
#include "pike_error.h"
#include "builtin_functions.h"
#include "module_support.h"
#include "bignum.h"
#include "operators.h"
#include "mapping.h"

#include "my_gmp.h"

#include <limits.h>
#include <math.h>


#define sp Pike_sp
#define fp Pike_fp

#define THISMPF (&(THIS->n))

#ifndef CHAR_BITS
#define CHAR_BITS 8
#endif

#define PUSH_REDUCED(o) push_object(o)

/*! @module Gmp
 */

/*! @class mpf
 *! GMP floating point number.
 *!
 *! The mantissa of each float has a user-selectable precision,
 *! limited only by available memory. Each variable has its own
 *! precision, and that can be increased or decreased at any time.
 *!
 *! The exponent of each float is a fixed precision, one machine word
 *! on most systems. In the current implementation the exponent is a
 *! count of limbs, so for example on a 32-bit system this means a
 *! range of roughly 2^-68719476768 to 2^68719476736, or on a 64-bit
 *! system this will be greater.
 *!
 *! Each variable keeps a size for the mantissa data actually in use.
 *! This means that if a float is exactly represented in only a few
 *! bits then only those bits will be used in a calculation, even if
 *! the selected precision is high.
 *!
 *! All calculations are performed to the precision of the destination
 *! variable. Each function is defined to calculate with "infinite
 *! precision" followed by a truncation to the destination precision,
 *! but of course the work done is only what's needed to determine a
 *! result under that definition.
 *!
 *! The precision selected for a variable is a minimum value, GMP may
 *! increase it a little to facilitate efficient calculation.
 *! Currently this means rounding up to a whole limb, and then
 *! sometimes having a further partial limb, depending on the high
 *! limb of the mantissa. But applications shouldn't be concerned by
 *! such details.
 *!
 *! The mantissa in stored in binary, as might be imagined from the
 *! fact precisions are expressed in bits. One consequence of this is
 *! that decimal fractions like 0.1 cannot be represented exactly. The
 *! same is true of plain IEEE double floats. This makes both highly
 *! unsuitable for calculations involving money or other values that
 *! should be exact decimal fractions. (Suitably scaled integers, or
 *! perhaps rationals, are better choices.)
 *!
 *! mpf functions and variables have no special notion of infinity or
 *! not-a-number, and applications must take care not to overflow the
 *! exponent or results will be unpredictable. This might change in a
 *! future release.
 *!
 *! Note that the mpf functions are not intended as a smooth extension
 *! to IEEE P754 arithmetic. In particular results obtained on one
 *! computer often differ from the results on a computer with a
 *! different word size.
 */

/*  id PROG_GMP_MPF_ID; */

#undef class_mpf_defined
#define class_mpf_defined
struct program *mpf_program=0;
int mpf_program_fun_num=-1;

#undef var_n_mpf_defined
#define var_n_mpf_defined

#undef THIS
#define THIS ((struct mpf_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_MPF
#define THIS_MPF ((struct mpf_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_MPF
#define OBJ2_MPF(o) ((struct mpf_struct *)(o->storage+mpf_storage_offset))

#undef GET_MPF_STORAGE
#define GET_MPF_STORAGE ((struct mpf_struct *)(o->storage+mpf_storage_offset)
static ptrdiff_t mpf_storage_offset;
struct mpf_struct {

#ifdef var_n_mpf_defined
#line 111 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
MP_FLT n;
#endif /* var_n_mpf_defined */
};
#line 113 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
static void get_mpf_from_digits(MP_FLT *tmp,
				  struct pike_string *digits,
				  int base)
    {
      p_wchar0 *str;
  
      if(digits->size_shift)
	Pike_error("Illegal characters, cannot convert to Gmp.mpf.\n");
      str=STR0(digits);

      mpf_set_str(THISMPF, (char *)str, base);      
    }

  static void get_new_mpf(MP_FLT *tmp, struct svalue *s)
    {
      switch(s->type)
      {
	case T_FLOAT:
	{
	  mpf_set_d(tmp, (double) s->u.float_number);
	  break;
	}
	  
	case T_INT:
	  mpf_set_si(tmp, (signed long int) s->u.integer);
	  break;
	  
	case T_OBJECT:
	  if(s->u.object->prog == mpzmod_program)
	  {
	    mpf_set_z(tmp, OBTOMPZ(s->u.object));
	    break;
	  }

	  if(s->u.object->prog == mpq_program)
	  {
	    mpf_set_q(tmp, OBTOMPQ(s->u.object));
	    break;
	  }
	  
	  if(s->u.object->prog == mpf_program)
	  {
	    mpf_set(tmp, OBTOMPF(s->u.object));
	    break;
	  }
	  
	  if (s->u.object->prog) {
	    Pike_error("Wrong type of object (id:%d), cannot convert to Gmp.mpf.\n",
		       s->u.object->prog->id);
	  } else {
	    /* Destructed object. Use as zero. */
	    mpf_set_si(tmp, 0);
	  }
	  break;
	  
	default:
	  Pike_error("Cannot convert argument to Gmp.mpf.\n");
      }
    }
  
  /* FIXME: */
  /*! @decl static void create(void|int|string|float|object x, @
   *!                          void|int(0..) precision)
   *! @decl static void create(string x, int(0..) precision, int(2..36) base)
   */
  #define f_mpf_create_defined
ptrdiff_t f_mpf_create_fun_num = 0;
void f_mpf_create(INT32 args) {
#line 178 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
struct svalue * x;
#line 178 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
struct svalue * precision;
struct svalue * base;
#line 178 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if(args > 3) wrong_number_of_args_error("create",args,3);
if (args > 0) {
#line 178 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
x=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
} else x=0;
if (args > 1) {
#line 178 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
precision=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
} else precision=0;
if (args > 2) {
#line 179 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
base=Pike_sp+2-args; dmalloc_touch_svalue(Pike_sp+2-args);
} else base=0;
#line 182 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
{
    int base=0;
	
    switch(args)
    {
      case 3:
	base=sp[2-args].u.integer;
	if(base<2 || base>36)
	  Pike_error("Bad argument 3 to Gmp.mpf, must be 2 <= base <= 36, not %d.\n",base);
	if(sp[-args].type != T_STRING)
	  Pike_error("First argument to Gmp.mpf must be a string when specifying a base.\n");

      case 2:
	if(sp[1-args].type == T_INT)
	{
	  if(sp[1-args].u.integer<0) {
	    Pike_error("Bad argument 2 to Gmp.mpf, must be positive.\n");
	  } else if (sp[1-args].u.integer > 0x10000) {
	    Pike_error("Bad argument 2 to Gmp.mpf, must be <= 0x10000.\n");
	  }
	  mpf_set_prec(THISMPF, sp[1-args].u.integer);
	}

      case 1:
	if(x->type == T_STRING)
	{
	  if(x->u.string->size_shift)
	    Pike_error("First argument to Gmp.mpf must not be a wide string.\n");
	  mpf_set_str(THISMPF, (char *)STR0(x->u.string), base);
	}else{
	  get_new_mpf(THISMPF, sp-args);
	}

      case 0: break;
    }
  }

  }
/*! @decl static int __hash()
   */
  #define f_mpf_cq___hash_defined
ptrdiff_t f_mpf_cq___hash_fun_num = 0;
void f_mpf_cq___hash(INT32 args) {
#line 221 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if(args != 0) wrong_number_of_args_error("__hash",args,0);
#line 223 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
{
      /* from hash_svalue */
      do { INT_TYPE ret_=(
#line 226 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
DO_NOT_WARN((unsigned INT32)(mpf_get_d(THISMPF) *
				     16843009.731757771173)));  push_int(ret_); return; }while(0);
#line 228 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
}

  }
/*! @decl int|object get_int()
   */
  #define f_mpf_get_int_defined
ptrdiff_t f_mpf_get_int_fun_num = 0;
void f_mpf_get_int(INT32 args) {
#line 232 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if(args != 0) wrong_number_of_args_error("get_int",args,0);
{
      struct object * ret;
      ref_push_object(fp->current_object);
#ifdef AUTO_BIGNUM
      ret=clone_object(bignum_program, 1);
      mpzmod_reduce(ret);
#else
      ret=clone_object(mpzmod_program, 1);
      push_int(mpz_get_si(OBTOMPZ(ret)));
      free_object(ret);
#endif
    }

  }
/*! @decl float get_float()
   *! Returns the value of the object as a float.
   */
  #define f_mpf_get_float_defined
ptrdiff_t f_mpf_get_float_fun_num = 0;
void f_mpf_get_float(INT32 args) {
#line 249 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if(args != 0) wrong_number_of_args_error("get_float",args,0);
{
      do { FLOAT_TYPE ret_=((FLOAT_TYPE) mpf_get_d(THISMPF));  push_float(ret_); return; }while(0);
#line 252 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
}

  }
/*! @decl string get_string()
   */
  #define f_mpf_get_string_defined
ptrdiff_t f_mpf_get_string_fun_num = 0;
void f_mpf_get_string(INT32 args) {
#line 256 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if(args != 0) wrong_number_of_args_error("get_string",args,0);
{
      /* Hmm, maybe I should have used a string builder instead? */
      mp_exp_t expptr;
      char *tmp=mpf_get_str(0, &expptr, 10, 0, THISMPF);
      int len=strlen(tmp);
      struct pike_string *ret=begin_shared_string(len + 32);
      char *out = (char *)STR0(ret);
      char *outbase=out;
      char *in=tmp;
      if(in[0]=='-')
      {
	*(out++)=*(in++);
	len--;
      }
      /* This could be better, but for now I just try to
       * avoid special cases
       */
      if(expptr == len)
      {
	/* Copy numbers straight */
	if(len)
	{
	  MEMCPY(out,in,len);
	  out+=len;
	}else{
	  *(out++)='0';
	}
      }else{
	if(expptr >= len || expptr < 0)
	{
	  /* N.NNNNNNNeNNN */
	  *(out++)=*(in++);
	  *(out++)='.';
	  MEMCPY(out,in,len-1);
	  out+=len-1;
	  in+=len+1;
	  sprintf(out,"e%ld",(long)(expptr-1));
	  out+=strlen(out);
	}else{
	  /* NNNNNNN.NNNNNNN */
	  MEMCPY(out,in,expptr);
	  out+=expptr;
	  in+=expptr;
	  *(out++)='.';
	  MEMCPY(out,in,len-expptr);
	  out += len-expptr;
	}
      }
      *out=0;
      free(tmp);
      do { struct pike_string * ret_=(end_and_resize_shared_string(ret, out - outbase));  push_string(ret_); return; }while(0);
#line 308 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
}

  }
#line 310 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
static int lookup(char *name,
		    struct mapping *m,
		    char *ind,
		    int def)
    {
      struct svalue *sv;
      if((sv=simple_mapping_string_lookup(m,ind)))
      {
	if(sv->type == T_INT)
	{
	  return sv->u.integer;
	}else{
	  Pike_error("\"%s\" argument to %s is not an integer.\n",ind,name);

	}
      }
      return def;
    }

  /*! @decl static string _sprintf(int c, mapping flags)
   */
  #define f_mpf_cq__sprintf_defined
ptrdiff_t f_mpf_cq__sprintf_fun_num = 0;
void f_mpf_cq__sprintf(INT32 args) {
#line 331 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
INT_TYPE c;
#line 331 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
struct mapping * flags;
#line 331 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if(args != 2) wrong_number_of_args_error("_sprintf",args,2);
#line 331 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if(Pike_sp[0-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("_sprintf",1,"int");
c=Pike_sp[0-2].u.integer;
#line 331 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if(Pike_sp[1-2].type != PIKE_T_MAPPING) SIMPLE_BAD_ARG_ERROR("_sprintf",2,"mapping(mixed:mixed)");
#line 331 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
debug_malloc_pass(flags=Pike_sp[1-2].u.mapping);
#line 333 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
{
      /* We should use this code for good...
      INT_TYPE precision, width, base = 0, mask_shift = 0;
      struct pike_string *s = 0;
      INT_TYPE flag_left;

      precision=lookup("Gmp.mpf->_sprintf",flags,"precision",7);
      width=lookup("Gmp.mpf->_sprintf",flags,"width",-1);
      flag_left=lookup("Gmp.mpf->_sprintf",flags,"flag_left",0);
      */
      pop_n_elems(args);

      switch(c)
      {
	default:
	  push_undefined();
	  return;

	case 'O':
	  push_constant_text ("Gmp.mpf(");
	  f_mpf_get_string(0);
	  push_constant_text (")");
	  f_add (3);
	  return;

	  /* Fixme: Support g/e/E */
	case 'g':
	case 'e':
	case 'E':
	case 'f':
	  f_mpf_get_string(0);
	  return;
      }
    }
  
  }
/*! @decl static int(0..1) _is_type(string arg)
   *!   The Gmp.mpf object will claim to be a @expr{"float"@}.
   *! @fixme
   *!   Perhaps it should also return true for @expr{"object"@}?
   */
  #define f_mpf_cq__is_type_defined
ptrdiff_t f_mpf_cq__is_type_fun_num = 0;
void f_mpf_cq__is_type(INT32 args) {
#line 373 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
struct pike_string * arg;
#line 373 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if(args != 1) wrong_number_of_args_error("_is_type",args,1);
#line 373 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("_is_type",1,"string");
#line 373 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
debug_malloc_pass(arg=Pike_sp[0-1].u.string);
#line 375 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
{
      push_constant_text("float");
      f_eq(2);
    }

  }
/*! @decl static mixed cast(string to)
   */
  #define f_mpf_cast_defined
ptrdiff_t f_mpf_cast_fun_num = 0;
void f_mpf_cast(INT32 args) {
#line 382 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
struct pike_string * s;
#line 382 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if(args != 1) wrong_number_of_args_error("cast",args,1);
#line 382 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("cast",1,"string");
#line 382 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
debug_malloc_pass(s=Pike_sp[0-1].u.string);
#line 384 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
{
    add_ref(s);
      
    pop_n_elems(args);
      
    if (s->len) {
      switch(s->str[0])
      {
	case 's':
	  if(!strcmp(s->str, "string"))
	  {
	    free_string(s);
	    f_mpf_get_string(0);
	    return;
	  }
	  break;

	case 'i':
	  if(!strncmp(s->str, "int", 3))
	  {
	    free_string(s);
	    f_mpf_get_int(0);
	    return;
	  }
	  break;

	case 'f':
	  if(!strcmp(s->str, "float"))
	  {
	    free_string(s);
	    f_mpf_get_float(0);
	    return;
	  }
	  break;
	  
	case 'o':
	  if(!strcmp(s->str, "object"))
	  {
	    push_object(this_object());
	  }
	  break;
	  
	case 'm':
	  if(!strcmp(s->str, "mixed"))
	  {
	    push_object(this_object());
	  }
	  break;	  
      }
    }  
    free_string(s);
      
    Pike_error("Gmp.mpf cast to \"%s\" is other type than int, string or float.\n",
	       s->str);
  }

}
#line 440 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
#ifdef DEBUG_MALLOC
#define get_mpf(X,Y,Z) \
 (debug_get_mpf((X),(Y),(Z)),( (X)->type==T_OBJECT? debug_malloc_touch((X)->u.object) :0 ),debug_get_mpf((X),(Y),(Z)))
#else
#define get_mpf debug_get_mpf 
#endif

  static struct object *get_mpf_with_prec(unsigned long int prec)
    {
      struct object *o=clone_object(mpf_program,0);
      mpf_init2(OBTOMPF(o), prec);
      return o;
    }

/* Converts an svalue, located on the stack, to an mpf object */
  static MP_FLT *debug_get_mpf(struct svalue *s,
			       int throw_error,
			       unsigned long int default_prec)
    {
#define MPF_ERROR(x) if (throw_error) Pike_error(x)
      struct object *o;
      unsigned long int prec=1;
      switch(s->type)
      {
	default:
	  MPF_ERROR("Wrong type of value, cannot convert to Gmp.mpf.\n");
	  return 0;
	  
	case T_OBJECT:
	  if(s->u.object->prog == mpf_program)
	    return (MP_FLT *)s->u.object->storage;

	  if(s->u.object->prog == mpzmod_program)
	  {
	    prec=mpz_size(OBTOMPZ(s->u.object)) * 
	      sizeof(mp_limb_t) * CHAR_BITS;
	    break;
	  }

	  /* This is tricky, how precice should we be? */
	  if(s->u.object->prog == mpq_program)
	  {
	    if(default_prec)
	      prec=default_prec;
	    else
	      prec=mpf_get_prec(THISMPF);
	    break;
	  }

	  if(!throw_error && s->u.object->prog) return 0;
	  break;

	case T_INT:
	  prec=sizeof(s->u.integer)*CHAR_BITS;
	  break;

	case T_FLOAT:
	  prec=sizeof(s->u.float_number)*CHAR_BITS;
	  break;
      }
      
      o=get_mpf_with_prec(prec);
      get_new_mpf(OBTOMPF(o), s);
      free_svalue(s);
      s->u.object=o;
      s->type=T_OBJECT;
      return (MP_FLT *)o->storage;
    }


#ifdef BIG_PIKE_INT
#define TOOBIGTEST(X) (sp[X-args].u.integer>MAX_INT32 || sp[X-args].u.integer<0)
#else
#define TOOBIGTEST(X) (sp[X-args].u.integer < 0)
#endif

  static int add_convert_args(INT32 args)
    {
      INT32 e;
      unsigned long int tmp;
      unsigned long int prec=mpf_get_prec(THISMPF);

      for(e=0; e<args; e++)
      {
	if(sp[e-args].type != T_INT || TOOBIGTEST(e))
	  tmp=mpf_get_prec( get_mpf(sp+e-args, 1, prec) );
	else
	  tmp=sizeof(sp[e-args].u.integer)*CHAR_BITS;
	if(tmp>prec) prec=tmp;
      }
      return prec;
    }


  static void add_args(MP_FLT *res, INT32 args)
    {
      INT32 e;
      for(e=0;e<args;e++)
      {
	if(sp[e-args].type == T_INT)
	{
	  if(sp[e-args].u.integer > 0)
	    mpf_add_ui(res, res, sp[e-args].u.integer);
	}else{
	  mpf_add(res, res, OBTOMPF(sp[e-args].u.object));
	}
      }
    }

  /*! @decl static Gmp.mpf `+(int|float|object ... a)
   */
  #define f_mpf_cq__backtick_add_defined
ptrdiff_t f_mpf_cq__backtick_add_fun_num = 0;
void f_mpf_cq__backtick_add(INT32 args) {
#line 551 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
struct svalue * a;
#line 551 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 551 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  } while (++argcnt < args-0);
  a=Pike_sp+0-args;
} else a=0;
#line 553 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
{
      struct object *res;

      res = get_mpf_with_prec( add_convert_args(args) );
      mpf_set(OBTOMPF(res), THISMPF);
      add_args(OBTOMPF(res), args);
      
      do { struct object * ret_=(res); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 561 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
}

  }
#line 563 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
/* @decl static Gmp.mpf ``+(int|float|object .. a)
   */
  #define f_mpf_cq__backtick_backtick_add_defined
ptrdiff_t f_mpf_cq__backtick_backtick_add_fun_num = 0;
void f_mpf_cq__backtick_backtick_add(INT32 args) {
#line 565 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
struct svalue * a;
#line 565 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 565 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  } while (++argcnt < args-0);
  a=Pike_sp+0-args;
} else a=0;
#line 567 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
{
      struct object *res;

      res = get_mpf_with_prec( add_convert_args(args) );


      mpf_set(OBTOMPF(res), THISMPF);
      add_args(OBTOMPF(res), args);
      
      do { struct object * ret_=(res); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 577 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
}

  }
/*! @decl static Gmp.mpf `+=(int|float|object ... a)
   */
  #define f_mpf_cq__backtick_add_eq_defined
ptrdiff_t f_mpf_cq__backtick_add_eq_fun_num = 0;
void f_mpf_cq__backtick_add_eq(INT32 args) {
#line 581 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
struct svalue * a;
#line 581 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 581 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  } while (++argcnt < args-0);
  a=Pike_sp+0-args;
} else a=0;
#line 583 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
{
    unsigned long int prec;
    prec=add_convert_args(args);
    if(prec > mpf_get_prec(THISMPF))
      mpf_set_prec(THISMPF, prec);

    add_args(THISMPF, args);
    
    do { struct object * ret_=(fp->current_object); add_ref(ret_); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 592 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
}

  }
/*! @decl Gmp.mpf set_precision(int(0..) prec)
   *! Sets the precision of the current object to be at
   *! least @[prec] bits. The precision is limited to 128Kb.
   *! The current object will be returned.
   */
  #define f_mpf_set_precision_defined
ptrdiff_t f_mpf_set_precision_fun_num = 0;
void f_mpf_set_precision(INT32 args) {
#line 599 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
INT_TYPE prec;
#line 599 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if(args != 1) wrong_number_of_args_error("set_precision",args,1);
#line 599 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("set_precision",1,"int(0..)");
prec=Pike_sp[0-1].u.integer;
#line 600 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
{
      if(prec<0) {
	Pike_error("Precision must be positive.\n");
      } else if (prec > 0x10000) {
	Pike_error("Precision must be less than or equal to 0x10000.\n");
      }
      mpf_set_prec(THISMPF, prec);
      do { struct object * ret_=(fp->current_object); add_ref(ret_); pop_stack(); push_object(ret_); return; }while(0);
#line 608 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
}

  }
/*! @decl int(0..) get_precision()
   *! Returns the current precision, in bits.
   */
  #define f_mpf_get_precision_defined
ptrdiff_t f_mpf_get_precision_fun_num = 0;
void f_mpf_get_precision(INT32 args) {
#line 613 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if(args != 0) wrong_number_of_args_error("get_precision",args,0);
#line 613 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
{
    do { INT_TYPE ret_=(mpf_get_prec(THISMPF));  push_int(ret_); return; }while(0);
#line 615 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
}

  }
#line 617 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
static void mult_args(MP_FLT *res,
			INT32 args)
    {
      INT32 e;
      for(e=0;e<args;e++)
      {
	if(sp[e-args].type == T_INT)
	  mpf_mul_ui(res, res, sp[e-args].u.integer);
	else
	  mpf_mul(res, res, OBTOMPF(sp[e-args].u.object));
      }
    }

  /*! @decl static Gmp.mpf `*(int|float|object ... a)
   */
  #define f_mpf_cq__backtick_2A_defined
ptrdiff_t f_mpf_cq__backtick_2A_fun_num = 0;
void f_mpf_cq__backtick_2A(INT32 args) {
#line 632 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
struct svalue * a;
#line 632 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 632 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  } while (++argcnt < args-0);
  a=Pike_sp+0-args;
} else a=0;
#line 634 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
{
      struct object *res;
      res = get_mpf_with_prec( add_convert_args(args) );
      mpf_set(OBTOMPF(res), THISMPF);
      mult_args(OBTOMPF(res), args);
      
      do { struct object * ret_=(res); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 641 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
}

  }
/*! @decl static Gmp.mpf ``*(int|float|object ... a)
   */
  #define f_mpf_cq__backtick_backtick_2A_defined
ptrdiff_t f_mpf_cq__backtick_backtick_2A_fun_num = 0;
void f_mpf_cq__backtick_backtick_2A(INT32 args) {
#line 645 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
struct svalue * a;
#line 645 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 645 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  } while (++argcnt < args-0);
  a=Pike_sp+0-args;
} else a=0;
#line 647 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
{
      struct object *res;

      res = get_mpf_with_prec( add_convert_args(args) );
      mpf_set(OBTOMPF(res), THISMPF);
      mult_args(OBTOMPF(res), args);

      do { struct object * ret_=(res); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 655 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
}

  }
/*! @decl static Gmp.mpf `*=(int|float|object ... a)
   */
  #define f_mpf_cq__backtick_2A_eq_defined
ptrdiff_t f_mpf_cq__backtick_2A_eq_fun_num = 0;
void f_mpf_cq__backtick_2A_eq(INT32 args) {
#line 659 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
struct svalue * a;
#line 659 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 659 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  } while (++argcnt < args-0);
  a=Pike_sp+0-args;
} else a=0;
#line 661 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
{
    unsigned long int prec;
    prec=add_convert_args(args);

    if(prec > mpf_get_prec(THISMPF))
      mpf_set_prec(THISMPF, prec);

    mult_args(THISMPF, args);
    do { struct object * ret_=(fp->current_object); add_ref(ret_); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 670 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
}

  }
#line 672 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
static void sub_args(MP_FLT *res,
			INT32 args)
    {
      INT32 e;
      for(e=0;e<args;e++)
      {
	if(sp[e-args].type == T_INT)
	  mpf_sub_ui(res, res, sp[e-args].u.integer);
	else
	  mpf_sub(res, res, OBTOMPF(sp[e-args].u.object));
      }
    }

  /*! @decl static Gmp.mpf `-(int|float|object ... a)
   */
  #define f_mpf_cq__backtick_2D_defined
ptrdiff_t f_mpf_cq__backtick_2D_fun_num = 0;
void f_mpf_cq__backtick_2D(INT32 args) {
#line 687 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
struct svalue * a;
#line 687 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 687 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  } while (++argcnt < args-0);
  a=Pike_sp+0-args;
} else a=0;
#line 689 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
{
      struct object *res;
      
      res = get_mpf_with_prec( add_convert_args(args) );
      
      if(args)
      {
	mpf_set(OBTOMPF(res), THISMPF);
	sub_args(OBTOMPF(res), args);
      }else{
	mpf_neg(OBTOMPF(res), THISMPF);
      }
      
      do { struct object * ret_=(res); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 703 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
}

  }
/*! @decl static Gmp.mpf ``-(int|float|object sv)
   */
  #define f_mpf_cq__backtick_backtick_2D_defined
ptrdiff_t f_mpf_cq__backtick_backtick_2D_fun_num = 0;
void f_mpf_cq__backtick_backtick_2D(INT32 args) {
#line 707 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
struct svalue * sv;
#line 707 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if(args != 1) wrong_number_of_args_error("``-",args,1);
#line 707 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
sv=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 709 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
{
      struct object *res;
      MP_FLT *a=get_mpf(sv,1, 0);
      res = get_mpf_with_prec( MAXIMUM( mpf_get_prec(THISMPF),
					mpf_get_prec(a) ));
      mpf_sub(OBTOMPF(res), a, THISMPF);
      do { struct object * ret_=(res); pop_stack(); push_object(ret_); return; }while(0);
#line 716 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
}

  }
/*! @decl static Gmp.mpf `/(int|float|object ... a)
   */
  #define f_mpf_cq__backtick_2F_defined
ptrdiff_t f_mpf_cq__backtick_2F_fun_num = 0;
void f_mpf_cq__backtick_2F(INT32 args) {
#line 720 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
struct svalue * a;
#line 720 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 720 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  } while (++argcnt < args-0);
  a=Pike_sp+0-args;
} else a=0;
#line 722 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
{
      INT32 e;
      struct object *res;
      unsigned long int tmp;
      unsigned long int prec=mpf_get_prec(THISMPF);

      for(e=0; e<args; e++)
      {
	if(sp[e-args].type != T_INT || TOOBIGTEST(e))
	{
	  MP_FLT *a=get_mpf(sp+e-args, 1, prec);
	  tmp=mpf_get_prec(a);
	  if(!mpf_sgn(a))
	    SIMPLE_DIVISION_BY_ZERO_ERROR ("Gmp.mpf->`/");
	}else{
	  tmp=sizeof(sp[e-args].u.integer)*CHAR_BITS;
	  if(!sp[e-args].u.integer)
	    SIMPLE_DIVISION_BY_ZERO_ERROR ("Gmp.mpf->`/");
	}
	if(tmp>prec) prec=tmp;
      }

      res=get_mpf_with_prec(prec);
      mpf_set(OBTOMPF(res), THISMPF);
      for(e=0;e<args;e++)
      {
	if(Pike_sp[e-args].type == T_INT)
	{
	  mpf_div_ui(OBTOMPF(res), OBTOMPF(res), sp[e-args].u.integer);
	}else{
	  mpf_div(OBTOMPF(res), OBTOMPF(res), OBTOMPF(sp[e-args].u.object));
	}
      }
      
      do { struct object * ret_=(res); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 757 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
}

  }
#line 759 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
/* Working here */
  /*! @decl static Gmp.mpf ``/(int|float|object sv)
   */
  #define f_mpf_cq__backtick_backtick_2F_defined
ptrdiff_t f_mpf_cq__backtick_backtick_2F_fun_num = 0;
void f_mpf_cq__backtick_backtick_2F(INT32 args) {
#line 762 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
struct svalue * sv;
#line 762 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if(args != 1) wrong_number_of_args_error("``/",args,1);
#line 762 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
sv=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 764 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
{
      MP_FLT *a;
      struct object *res = NULL;
      if(!mpf_sgn(THISMPF))
	SIMPLE_DIVISION_BY_ZERO_ERROR ("Gmp.mpf->``/");
      
      a=get_mpf(sv,1,0);

      res = get_mpf_with_prec( MAXIMUM( mpf_get_prec(THISMPF),
					mpf_get_prec(a) ));

      mpf_div(OBTOMPF(res), a, THISMPF);
      
      do { struct object * ret_=(res); pop_stack(); push_object(ret_); return; }while(0);
#line 778 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
}

  }
#line 780 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
/* mpf has no floor() operator, so modulo is kind of hard to
   * implement. Need it? Send me an implementation. /Hubbe
   */

  
  /* defined as -1-x */
  /*! @decl static Gmp.mpf `~()
   */
  #define f_mpf_cq__backtick_7E_defined
ptrdiff_t f_mpf_cq__backtick_7E_fun_num = 0;
void f_mpf_cq__backtick_7E(INT32 args) {
#line 788 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if(args != 0) wrong_number_of_args_error("`~",args,0);
#line 790 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
{
      struct object *o;
      o=get_mpf_with_prec(mpf_get_prec(THISMPF));
      mpf_set_si(OBTOMPF(o), -1);
      mpf_sub(OBTOMPF(o),OBTOMPF(o), THISMPF);
      
      do { struct object * ret_=(o);  push_object(ret_); return; }while(0);
#line 797 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
}

}
#line 799 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
#define CMPOP(OP) 					\
      ((q->type != T_INT || TOOBIGTEST(0)) ?		\
       mpf_cmp(THISMPF, get_mpf(q, 1, 0)) OP 0 :	\
       mpf_cmp_ui(THISMPF, q->u.integer) OP 0)
	
  /*! @decl static int(0..1) `>(mixed q)
   */
  #define f_mpf_cq__backtick_3E_defined
ptrdiff_t f_mpf_cq__backtick_3E_fun_num = 0;
void f_mpf_cq__backtick_3E(INT32 args) {
#line 806 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
struct svalue * q;
#line 806 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if(args != 1) wrong_number_of_args_error("`>",args,1);
#line 806 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
q=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 808 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
{
      do { INT_TYPE ret_=(CMPOP(>)); pop_stack(); push_int(ret_); return; }while(0);
#line 810 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
}

  }
/*! @decl static int(0..1) `<(mixed q)
   */
  #define f_mpf_cq__backtick_3C_defined
ptrdiff_t f_mpf_cq__backtick_3C_fun_num = 0;
void f_mpf_cq__backtick_3C(INT32 args) {
#line 814 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
struct svalue * q;
#line 814 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if(args != 1) wrong_number_of_args_error("`<",args,1);
#line 814 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
q=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 816 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
{
      do { INT_TYPE ret_=(CMPOP(<)); pop_stack(); push_int(ret_); return; }while(0);
#line 818 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
}

  }
/*! @decl static int(0..1) `>=(mixed q)
   */
  #define f_mpf_cq__backtick_3E_eq_defined
ptrdiff_t f_mpf_cq__backtick_3E_eq_fun_num = 0;
void f_mpf_cq__backtick_3E_eq(INT32 args) {
#line 822 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
struct svalue * q;
#line 822 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if(args != 1) wrong_number_of_args_error("`>=",args,1);
#line 822 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
q=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 824 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
{
    do { INT_TYPE ret_=(CMPOP(>=)); pop_stack(); push_int(ret_); return; }while(0);
#line 826 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
}
  
  }
/*! @decl static int(0..1) `<=(mixed q)
   */
  #define f_mpf_cq__backtick_3C_eq_defined
ptrdiff_t f_mpf_cq__backtick_3C_eq_fun_num = 0;
void f_mpf_cq__backtick_3C_eq(INT32 args) {
#line 830 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
struct svalue * q;
#line 830 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if(args != 1) wrong_number_of_args_error("`<=",args,1);
#line 830 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
q=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 832 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
{
    do { INT_TYPE ret_=(CMPOP(<=)); pop_stack(); push_int(ret_); return; }while(0);
#line 834 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
}


  }
/*! @decl static int(0..1) `==(mixed q)
   */
  #define f_mpf_cq__backtick_eq_eq_defined
ptrdiff_t f_mpf_cq__backtick_eq_eq_fun_num = 0;
void f_mpf_cq__backtick_eq_eq(INT32 args) {
#line 839 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
struct svalue * q;
#line 839 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if(args != 1) wrong_number_of_args_error("`==",args,1);
#line 839 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
q=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 841 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
{
    MP_FLT *arg;
    /* FIXME: We need separate TOOBIGTEST for *_si and *_ui */
    if(q->type == T_INT && TOOBIGTEST(0))
      do { INT_TYPE ret_=(mpf_cmp_si(THISMPF, q->u.integer) == 0); pop_stack(); push_int(ret_); return; }while(0);
#line 846 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
arg=get_mpf(q, 0, 0);
    do { INT_TYPE ret_=((arg && !mpf_cmp(THISMPF, arg))); pop_stack(); push_int(ret_); return; }while(0);
#line 848 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
}

  }
/*! @decl static int(0..1) `!=(mixed q)
   */
  #define f_mpf_cq__backtick_21_eq_defined
ptrdiff_t f_mpf_cq__backtick_21_eq_fun_num = 0;
void f_mpf_cq__backtick_21_eq(INT32 args) {
#line 852 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
struct svalue * q;
#line 852 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if(args != 1) wrong_number_of_args_error("`!=",args,1);
#line 852 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
q=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 854 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
{
    MP_FLT *arg;
    if(q->type == T_INT && TOOBIGTEST(0))
      do { INT_TYPE ret_=(mpf_cmp_si(THISMPF, q->u.integer) != 0); pop_stack(); push_int(ret_); return; }while(0);
#line 858 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
arg=get_mpf(q, 0, 0);
    do { INT_TYPE ret_=((!arg || mpf_cmp(THISMPF, arg))); pop_stack(); push_int(ret_); return; }while(0);
#line 860 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
}

  }
/*! @decl int sgn()
   */
  #define f_mpf_sgn_defined
ptrdiff_t f_mpf_sgn_fun_num = 0;
void f_mpf_sgn(INT32 args) {
#line 864 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if(args != 0) wrong_number_of_args_error("sgn",args,0);
{
      do { INT_TYPE ret_=(mpf_sgn(THISMPF));  push_int(ret_); return; }while(0);
#line 867 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
}

  }
/*! @decl static int(0..1) `!()
   */
  #define f_mpf_cq__backtick_21_defined
ptrdiff_t f_mpf_cq__backtick_21_fun_num = 0;
void f_mpf_cq__backtick_21(INT32 args) {
#line 871 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
if(args != 0) wrong_number_of_args_error("`!",args,0);
#line 873 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
{
      do { INT_TYPE ret_=(!mpf_sgn(THISMPF));  push_int(ret_); return; }while(0);
#line 875 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
}

  }

#undef internal_init_mpf_defined
#define internal_init_mpf_defined

#undef mpf_event_handler_defined
#define mpf_event_handler_defined
static void init_mpf_struct(void)
#line 878 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
{
#ifdef PIKE_DEBUG
      if(!fp) Pike_fatal("ZERO FP\n");
      if(!THISMPF) Pike_fatal("ZERO THISMPF\n");
#endif
      mpf_init(THISMPF);
    }
  
  
#undef internal_exit_mpf_defined
#define internal_exit_mpf_defined

#undef mpf_event_handler_defined
#define mpf_event_handler_defined
static void exit_mpf_struct(void)
#line 887 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
{
#ifdef PIKE_DEBUG
      if(!fp) Pike_fatal("ZERO FP\n");
      if(!THISMPF) Pike_fatal("ZERO THISMPF\n");
#endif
      mpf_clear(THISMPF);
    }
  

#ifdef mpf_event_handler_defined
static void mpf_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_mpf_defined
  case PROG_EVENT_INIT: init_mpf_struct(); break;

#endif /* internal_init_mpf_defined */

#ifdef internal_exit_mpf_defined
  case PROG_EVENT_EXIT: exit_mpf_struct(); break;

#endif /* internal_exit_mpf_defined */
  default: break; 
  }
}

#endif /* mpf_event_handler_defined */
/*! @endclass
 */

/*! @endmodule
 */

#line 903 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
#endif /* USE_GMP */


void pike_init_mpf_module(void)
{
  
#ifdef class_mpf_defined

#ifdef PROG_MPF_ID
  START_NEW_PROGRAM_ID(MPF);
#else
  start_new_program();

#endif /* PROG_MPF_ID */

#ifndef tObjImpl_MPF

#undef tObjImpl_MPF
#define tObjImpl_MPF tObj

#endif /* tObjImpl_MPF */

#ifdef THIS_MPF

  mpf_storage_offset=ADD_STORAGE(struct mpf_struct);

#endif /* THIS_MPF */

#ifdef mpf_event_handler_defined
  pike_set_prog_event_callback(mpf_event_handler);

#endif /* mpf_event_handler_defined */

#ifdef f_mpf_create_defined
#line 178 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_create_fun_num =
    ADD_FUNCTION2("create", f_mpf_create, tOr(tFunc(tOr5(tVoid,tString,"\10\200\0\0\0\177\377\377\377",tFloat,tObj) tOr(tVoid,"\10\0\0\0\1\177\377\377\377"),tVoid),tFunc(tString "\10\0\0\0\0\177\377\377\377" "\10\0\0\0\2\0\0\0\44",tVoid)), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_create_defined */

#ifdef f_mpf_cq___hash_defined
#line 221 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_cq___hash_fun_num =
    ADD_FUNCTION2("__hash", f_mpf_cq___hash, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_cq___hash_defined */

#ifdef f_mpf_get_int_defined
#line 232 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_get_int_fun_num =
    ADD_FUNCTION2("get_int", f_mpf_get_int, tFunc(tNone,tOr("\10\200\0\0\0\177\377\377\377",tObj)), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_get_int_defined */

#ifdef f_mpf_get_float_defined
#line 249 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_get_float_fun_num =
    ADD_FUNCTION2("get_float", f_mpf_get_float, tFunc(tNone,tFloat), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_get_float_defined */

#ifdef f_mpf_get_string_defined
#line 256 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_get_string_fun_num =
    ADD_FUNCTION2("get_string", f_mpf_get_string, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_get_string_defined */

#ifdef f_mpf_cq__sprintf_defined
#line 331 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_cq__sprintf_fun_num =
    ADD_FUNCTION2("_sprintf", f_mpf_cq__sprintf, tFunc("\10\200\0\0\0\177\377\377\377" tMapping,tString), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_cq__sprintf_defined */

#ifdef f_mpf_cq__is_type_defined
#line 373 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_cq__is_type_fun_num =
    ADD_FUNCTION2("_is_type", f_mpf_cq__is_type, tFunc(tString,"\10\0\0\0\0\0\0\0\1"), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_cq__is_type_defined */

#ifdef f_mpf_cast_defined
#line 382 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_cast_fun_num =
    ADD_FUNCTION2("cast", f_mpf_cast, tFunc(tString,tMix), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_cast_defined */

#ifdef f_mpf_cq__backtick_add_defined
#line 551 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_cq__backtick_add_fun_num =
    ADD_FUNCTION2("`+", f_mpf_cq__backtick_add, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_cq__backtick_add_defined */

#ifdef f_mpf_cq__backtick_backtick_add_defined
#line 565 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_cq__backtick_backtick_add_fun_num =
    ADD_FUNCTION2("``+", f_mpf_cq__backtick_backtick_add, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_cq__backtick_backtick_add_defined */

#ifdef f_mpf_cq__backtick_add_eq_defined
#line 581 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_cq__backtick_add_eq_fun_num =
    ADD_FUNCTION2("`+=", f_mpf_cq__backtick_add_eq, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_cq__backtick_add_eq_defined */

#ifdef f_mpf_set_precision_defined
#line 599 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_set_precision_fun_num =
    ADD_FUNCTION2("set_precision", f_mpf_set_precision, tFunc("\10\0\0\0\0\177\377\377\377",tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_set_precision_defined */

#ifdef f_mpf_get_precision_defined
#line 613 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_get_precision_fun_num =
    ADD_FUNCTION2("get_precision", f_mpf_get_precision, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_get_precision_defined */

#ifdef f_mpf_cq__backtick_2A_defined
#line 632 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_cq__backtick_2A_fun_num =
    ADD_FUNCTION2("`*", f_mpf_cq__backtick_2A, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_cq__backtick_2A_defined */

#ifdef f_mpf_cq__backtick_backtick_2A_defined
#line 645 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_cq__backtick_backtick_2A_fun_num =
    ADD_FUNCTION2("``*", f_mpf_cq__backtick_backtick_2A, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_cq__backtick_backtick_2A_defined */

#ifdef f_mpf_cq__backtick_2A_eq_defined
#line 659 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_cq__backtick_2A_eq_fun_num =
    ADD_FUNCTION2("`*=", f_mpf_cq__backtick_2A_eq, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_cq__backtick_2A_eq_defined */

#ifdef f_mpf_cq__backtick_2D_defined
#line 687 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_cq__backtick_2D_fun_num =
    ADD_FUNCTION2("`-", f_mpf_cq__backtick_2D, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_cq__backtick_2D_defined */

#ifdef f_mpf_cq__backtick_backtick_2D_defined
#line 707 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_cq__backtick_backtick_2D_fun_num =
    ADD_FUNCTION2("``-", f_mpf_cq__backtick_backtick_2D, tFunc(tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_cq__backtick_backtick_2D_defined */

#ifdef f_mpf_cq__backtick_2F_defined
#line 720 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_cq__backtick_2F_fun_num =
    ADD_FUNCTION2("`/", f_mpf_cq__backtick_2F, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_cq__backtick_2F_defined */

#ifdef f_mpf_cq__backtick_backtick_2F_defined
#line 762 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_cq__backtick_backtick_2F_fun_num =
    ADD_FUNCTION2("``/", f_mpf_cq__backtick_backtick_2F, tFunc(tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_cq__backtick_backtick_2F_defined */

#ifdef f_mpf_cq__backtick_7E_defined
#line 788 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_cq__backtick_7E_fun_num =
    ADD_FUNCTION2("`~", f_mpf_cq__backtick_7E, tFunc(tNone,tObj), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_cq__backtick_7E_defined */

#ifdef f_mpf_cq__backtick_3E_defined
#line 806 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_cq__backtick_3E_fun_num =
    ADD_FUNCTION2("`>", f_mpf_cq__backtick_3E, tFunc(tMix,"\10\0\0\0\0\0\0\0\1"), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_cq__backtick_3E_defined */

#ifdef f_mpf_cq__backtick_3C_defined
#line 814 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_cq__backtick_3C_fun_num =
    ADD_FUNCTION2("`<", f_mpf_cq__backtick_3C, tFunc(tMix,"\10\0\0\0\0\0\0\0\1"), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_cq__backtick_3C_defined */

#ifdef f_mpf_cq__backtick_3E_eq_defined
#line 822 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_cq__backtick_3E_eq_fun_num =
    ADD_FUNCTION2("`>=", f_mpf_cq__backtick_3E_eq, tFunc(tMix,"\10\0\0\0\0\0\0\0\1"), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_cq__backtick_3E_eq_defined */

#ifdef f_mpf_cq__backtick_3C_eq_defined
#line 830 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_cq__backtick_3C_eq_fun_num =
    ADD_FUNCTION2("`<=", f_mpf_cq__backtick_3C_eq, tFunc(tMix,"\10\0\0\0\0\0\0\0\1"), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_cq__backtick_3C_eq_defined */

#ifdef f_mpf_cq__backtick_eq_eq_defined
#line 839 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_cq__backtick_eq_eq_fun_num =
    ADD_FUNCTION2("`==", f_mpf_cq__backtick_eq_eq, tFunc(tMix,"\10\0\0\0\0\0\0\0\1"), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_cq__backtick_eq_eq_defined */

#ifdef f_mpf_cq__backtick_21_eq_defined
#line 852 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_cq__backtick_21_eq_fun_num =
    ADD_FUNCTION2("`!=", f_mpf_cq__backtick_21_eq, tFunc(tMix,"\10\200\0\0\0\177\377\377\377"), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_cq__backtick_21_eq_defined */

#ifdef f_mpf_sgn_defined
#line 864 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_sgn_fun_num =
    ADD_FUNCTION2("sgn", f_mpf_sgn, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_sgn_defined */

#ifdef f_mpf_cq__backtick_21_defined
#line 871 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
  f_mpf_cq__backtick_21_fun_num =
    ADD_FUNCTION2("`!", f_mpf_cq__backtick_21, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpf_cq__backtick_21_defined */
  mpf_program=end_program();
  mpf_program_fun_num=add_program_constant("mpf",mpf_program,0);

#endif /* class_mpf_defined */
#line 909 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
}

void pike_exit_mpf_module(void)
{
  
#ifdef class_mpf_defined
  if(mpf_program) {
    free_program(mpf_program);
    mpf_program=0;
  }

#endif /* class_mpf_defined */
#line 914 "/tmp/pikedeb.ea910e171c/7.6/src/modules/Gmp/mpf.cmod"
}

