#line 1 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
/* cipher.cmod -*- c -*- */

#include "global.h"
RCSID("$Id: cipher.cmod,v 1.30 2004/02/21 18:36:35 nilsson Exp $");
#include "interpret.h"
#include "svalue.h"
#include "array.h"
#include "operators.h"
#include "threads.h"

/* For this_object() */
#include "object.h"
#include "module_support.h"

#include "nettle_config.h"

#ifdef HAVE_LIBNETTLE

#include "nettle.h"

#include <nettle/aes.h>
#include <nettle/arcfour.h>
#include <nettle/blowfish.h>
#include <nettle/des.h>
#include <nettle/cast128.h>
#include <nettle/serpent.h>
#include <nettle/twofish.h>
#include "idea.h"
#include <nettle/nettle-meta.h>

#include <assert.h>
#include <stdio.h>
#include <stdarg.h>

#if 0
static void
werror(const char *format, ...)
{
  va_list args;

  va_start(args, format);
  vfprintf(stderr, format, args);
  va_end(args);
}
#else
#define werror(x)
#endif

/*! @module Nettle
 */

/* Calls Pike_error on errors */ 
typedef void (*pike_nettle_set_key_func)(void *ctx,
					 ptrdiff_t length, const char *key,
					 /* Force means to use key even if it is weak */
					 int force);

struct pike_cipher
{
  const char *name;
  
  unsigned context_size;

  unsigned block_size;

  /* Suggested key size; other sizes are sometimes possible. */
  unsigned key_size;

  pike_nettle_set_key_func set_encrypt_key;
  pike_nettle_set_key_func set_decrypt_key;

  nettle_crypt_func encrypt;
  nettle_crypt_func decrypt;
};

#define _PIKE_CIPHER(name, NAME) {		\
  #name,					\
  sizeof(struct name##_ctx),			\
  NAME##_BLOCK_SIZE,				\
  NAME##_KEY_SIZE,				\
  pike_##name##_set_encrypt_key,		\
  pike_##name##_set_decrypt_key,		\
  (nettle_crypt_func) name##_encrypt,		\
  (nettle_crypt_func) name##_decrypt,		\
}

/*! @class CipherInfo
 *!
 *! Represents information about a cipher algorithm, such as
 *! name, key size, and block size.
 */

#undef class_CipherInfo_defined
#define class_CipherInfo_defined
struct program *CipherInfo_program=NULL;
static int CipherInfo_program_fun_num=-1;

#undef var_meta_CipherInfo_defined
#define var_meta_CipherInfo_defined

#undef THIS
#define THIS ((struct CipherInfo_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_CIPHERINFO
#define THIS_CIPHERINFO ((struct CipherInfo_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_CIPHERINFO
#define OBJ2_CIPHERINFO(o) ((struct CipherInfo_struct *)(o->storage+CipherInfo_storage_offset))

#undef GET_CIPHERINFO_STORAGE
#define GET_CIPHERINFO_STORAGE ((struct CipherInfo_struct *)(o->storage+CipherInfo_storage_offset)
static ptrdiff_t CipherInfo_storage_offset;
struct CipherInfo_struct {

#ifdef var_meta_CipherInfo_defined
#line 94 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
const struct pike_cipher *meta;
#endif /* var_meta_CipherInfo_defined */
};
/*! @decl string name(void)
   *!
   *! @returns
   *!   A human readable name for the algorithm.
   */
  #define f_CipherInfo_name_defined
ptrdiff_t f_CipherInfo_name_fun_num = 0;
void f_CipherInfo_name(INT32 args) {
#line 101 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
if(args != 0) wrong_number_of_args_error("name",args,0);
#line 103 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
{
      if (!THIS->meta)
	Pike_error("CipherInfo not properly initialized.\n");

      push_text(THIS->meta->name);
    }

  }
/*! @decl string key_size(void)
   *!
   *! @returns
   *!   The recommended key size for the cipher.
   */
  #define f_CipherInfo_key_size_defined
ptrdiff_t f_CipherInfo_key_size_fun_num = 0;
void f_CipherInfo_key_size(INT32 args) {
#line 115 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
if(args != 0) wrong_number_of_args_error("key_size",args,0);
#line 117 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
{
      if (!THIS->meta)
	Pike_error("CipherInfo not properly initialized.\n");

      push_int(THIS->meta->key_size);
    }
  
  }
/*! @decl string block_size(void)
   *!
   *! @returns
   *!   The block size of the cipher (1 for stream ciphers).
   */
  #define f_CipherInfo_block_size_defined
ptrdiff_t f_CipherInfo_block_size_fun_num = 0;
void f_CipherInfo_block_size(INT32 args) {
#line 129 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
if(args != 0) wrong_number_of_args_error("block_size",args,0);
#line 131 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
{
      if (!THIS->meta)
	Pike_error("CipherInfo not properly initialized.\n");

      push_int(THIS->meta->block_size);
    }
  }

#undef internal_init_CipherInfo_defined
#define internal_init_CipherInfo_defined

#undef CipherInfo_event_handler_defined
#define CipherInfo_event_handler_defined
static void init_CipherInfo_struct(void)
#line 138 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
{
      THIS->meta = NULL;
    }

#ifdef CipherInfo_event_handler_defined
static void CipherInfo_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_CipherInfo_defined
  case PROG_EVENT_INIT: init_CipherInfo_struct(); break;

#endif /* internal_init_CipherInfo_defined */
  default: break; 
  }
}

#endif /* CipherInfo_event_handler_defined */
/*! @endclass
 */

#line 145 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
#define GET_INFO(o) \
((struct CipherInfo_struct *) get_storage((o), CipherInfo_program))

/* Generate a random string of length @[size] on top of the stack. */
static void low_make_key(INT32 size)
{
  push_text("Crypto.Random");
  SAFE_APPLY_MASTER("resolv",1);
  if(Pike_sp[-1].type!=T_OBJECT)
    Pike_error("Failed to resolv Crypto.Random.\n");
  push_int(size);
  apply(Pike_sp[-2].u.object, "random_string", 1);
  stack_swap();
  pop_stack();
}

/*! @class CipherState
 *!
 *! Base class for hashing contexts.
 */

#undef class_CipherState_defined
#define class_CipherState_defined
struct program *CipherState_program=NULL;
static int CipherState_program_fun_num=-1;

#undef inherit_CipherInfo_CipherState_defined
#define inherit_CipherInfo_CipherState_defined

#undef var_crypt_CipherState_defined
#define var_crypt_CipherState_defined

#undef var_ctx_CipherState_defined
#define var_ctx_CipherState_defined

#undef var_key_size_CipherState_defined
#define var_key_size_CipherState_defined

#undef THIS
#define THIS ((struct CipherState_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_CIPHERSTATE
#define THIS_CIPHERSTATE ((struct CipherState_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_CIPHERSTATE
#define OBJ2_CIPHERSTATE(o) ((struct CipherState_struct *)(o->storage+CipherState_storage_offset))

#undef GET_CIPHERSTATE_STORAGE
#define GET_CIPHERSTATE_STORAGE ((struct CipherState_struct *)(o->storage+CipherState_storage_offset)
static ptrdiff_t CipherState_storage_offset;
struct CipherState_struct {

#ifdef var_crypt_CipherState_defined
#line 168 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
nettle_crypt_func crypt;
#endif /* var_crypt_CipherState_defined */

#ifdef var_ctx_CipherState_defined
#line 169 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
void *ctx;
#endif /* var_ctx_CipherState_defined */

#ifdef var_key_size_CipherState_defined
#line 170 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
int key_size;
#endif /* var_key_size_CipherState_defined */
};
#line 172 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
/* FIXME: Create should copy state from the other object, if
   * provided. */

  /*! @decl CipherState set_encrypt_key(string key, void|int force)
   *!
   *! Initializes the object for encryption.
   *!
   *! @seealso
   *!   @[set_decrypt_key], @[crypt]
   */
  #define f_CipherState_set_encrypt_key_defined
ptrdiff_t f_CipherState_set_encrypt_key_fun_num = 0;
void f_CipherState_set_encrypt_key(INT32 args) {
#line 182 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
struct pike_string * key;
#line 182 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
struct svalue * force;
#line 182 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
if(args < 1) wrong_number_of_args_error("set_encrypt_key",args,1);
#line 182 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
if(args > 2) wrong_number_of_args_error("set_encrypt_key",args,2);
#line 182 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
if(Pike_sp[0-args].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("set_encrypt_key",1,"string");
#line 182 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
debug_malloc_pass(key=Pike_sp[0-args].u.string);
if (args > 1) {
#line 182 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
if(Pike_sp[1-args].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("set_encrypt_key",2,"void|int");
#line 182 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
force=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
} else force=0;
{
      struct CipherInfo_struct *info = GET_INFO(Pike_fp->current_object);
      assert(info);
      
      if (!THIS->ctx || !info->meta)
	Pike_error("CipherState not properly initialized.\n");

      NO_WIDE_STRING(key);
      info->meta->set_encrypt_key(THIS->ctx, key->len, key->str,
				  force ? force->u.integer : 0);

      THIS->crypt = info->meta->encrypt;
      THIS->key_size = key->len;

      push_object(this_object());
    }

  }
/*! @decl CipherState set_decrypt_key(string key, void|int force)
   *!
   *! Initializes the object for decryption.
   *!
   *! @seealso
   *!   @[set_encrypt_key], @[crypt]
   */
  #define f_CipherState_set_decrypt_key_defined
ptrdiff_t f_CipherState_set_decrypt_key_fun_num = 0;
void f_CipherState_set_decrypt_key(INT32 args) {
#line 208 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
struct pike_string * key;
#line 208 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
struct svalue * force;
#line 208 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
if(args < 1) wrong_number_of_args_error("set_decrypt_key",args,1);
#line 208 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
if(args > 2) wrong_number_of_args_error("set_decrypt_key",args,2);
#line 208 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
if(Pike_sp[0-args].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("set_decrypt_key",1,"string");
#line 208 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
debug_malloc_pass(key=Pike_sp[0-args].u.string);
if (args > 1) {
#line 208 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
if(Pike_sp[1-args].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("set_decrypt_key",2,"void|int");
#line 208 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
force=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
} else force=0;
{
      struct CipherInfo_struct *info = GET_INFO(Pike_fp->current_object);
      assert(info);
      
      if (!THIS->ctx || !info->meta)
	Pike_error("CipherState not properly initialized.\n");

      NO_WIDE_STRING(key);
      info->meta->set_decrypt_key(THIS->ctx, key->len, key->str,
				  force ? force->u.integer : 0);
      THIS->crypt = info->meta->decrypt;
      THIS->key_size = key->len;

      push_object(this_object());
    }

  }
/*! @decl string make_key()
   *!
   *! Generate a key by calling @[Crypto.Random.random_string] and
   *! initialize this object for encryption with that key.
   *!
   *! @returns
   *!   The generated key.
   *!
   *! @seealso
   *!   @[set_encrypt_key]
   */
  #define f_CipherState_make_key_defined
ptrdiff_t f_CipherState_make_key_fun_num = 0;
void f_CipherState_make_key(INT32 args) {
#line 237 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
if(args != 0) wrong_number_of_args_error("make_key",args,0);
#line 239 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
{
    struct CipherInfo_struct *info = GET_INFO(Pike_fp->current_object);
    assert(info);

    low_make_key(info->meta->key_size);

    /* FIXME: There should be a check for weak keys so this never throws. */
    stack_dup();
    f_CipherState_set_encrypt_key(1);
    pop_stack();
  }

  }
/*! @decl string crypt(string data)
   *!
   *! Encrypts or decrypts data, using the current key.
   *!
   *! @param data
   *!   For block ciphers, data must be an integral number of blocks.
   *!
   *! @returns
   *!   The encrypted or decrypted data.
   */
  #define f_CipherState_crypt_defined
ptrdiff_t f_CipherState_crypt_fun_num = 0;
void f_CipherState_crypt(INT32 args) {
#line 261 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
struct pike_string * data;
#line 261 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
if(args != 1) wrong_number_of_args_error("crypt",args,1);
#line 261 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("crypt",1,"string");
#line 261 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
debug_malloc_pass(data=Pike_sp[0-1].u.string);
#line 263 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
{
      struct CipherInfo_struct *info = GET_INFO(Pike_fp->current_object);
      struct pike_string *s;
      assert(info);
      
      if (!THIS->ctx || !THIS->crypt|| !info->meta)
	Pike_error("CipherState not properly initialized.\n");

      NO_WIDE_STRING(data);

      if (data->len % info->meta->block_size)
	Pike_error("Data must be an integral number of blocks.\n");

      s = begin_shared_string(data->len);
      THIS->crypt(THIS->ctx, data->len, s->str, data->str);
      push_string(end_shared_string(s));
    }

  }
/*! @decl string key_size(void)
   *!
   *! @returns
   *!   The actual key size for this cipher.
   */
  #define f_CipherState_key_size_defined
ptrdiff_t f_CipherState_key_size_fun_num = 0;
void f_CipherState_key_size(INT32 args) {
#line 286 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
if(args != 0) wrong_number_of_args_error("key_size",args,0);
#line 288 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
{
      do { INT_TYPE ret_=(THIS->key_size);  push_int(ret_); return; }while(0);
#line 290 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
}

  }

#undef internal_init_CipherState_defined
#define internal_init_CipherState_defined

#undef CipherState_event_handler_defined
#define CipherState_event_handler_defined
static void init_CipherState_struct(void)
#line 293 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
{
      THIS->ctx = NULL;
      THIS->crypt = NULL;
      THIS->key_size = 0;
    }

  
#undef internal_exit_CipherState_defined
#define internal_exit_CipherState_defined

#undef CipherState_event_handler_defined
#define CipherState_event_handler_defined
static void exit_CipherState_struct(void)
#line 300 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
{
      if (THIS->ctx && Pike_fp->current_object->prog)
      {
	struct CipherInfo_struct *info = GET_INFO(Pike_fp->current_object);
	assert(info);
	assert(info->meta);
	memset(THIS->ctx, 0, info->meta->context_size);
      }
    }

#ifdef CipherState_event_handler_defined
static void CipherState_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_CipherState_defined
  case PROG_EVENT_INIT: init_CipherState_struct(); break;

#endif /* internal_init_CipherState_defined */

#ifdef internal_exit_CipherState_defined
  case PROG_EVENT_EXIT: exit_CipherState_struct(); break;

#endif /* internal_exit_CipherState_defined */
  default: break; 
  }
}

#endif /* CipherState_event_handler_defined */
/*! @endclass CipherState */

#line 312 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
static void
pike_aes_set_encrypt_key(void *ctx,
			 ptrdiff_t length, const char *key,
			 int force)
{
  if (length == 16 || length == 24 || length == 32)
    aes_set_encrypt_key(ctx, length, key);
  else
    Pike_error("AES_Info: Bad keysize for AES.\n");
}

static void
pike_aes_set_decrypt_key(void *ctx,
			 ptrdiff_t length, const char *key,
			 int force)
{
  if (length == 16 || length == 24 || length == 32)
    aes_set_decrypt_key(ctx, length, key);
  else
    Pike_error("AES_Info: Bad keysize for AES.\n");
}

/*! @class AES_Info
 *!
 *! Internal mixin class, intended to be multiply inherited
 *! together with CipherInfo.
 */

#undef class_AES_Info_defined
#define class_AES_Info_defined
struct program *AES_Info_program=NULL;
static int AES_Info_program_fun_num=-1;

#undef internal_init_AES_Info_defined
#define internal_init_AES_Info_defined

#undef AES_Info_event_handler_defined
#define AES_Info_event_handler_defined
static void init_AES_Info_struct(void)
#line 342 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
{
      static const struct pike_cipher pike_aes = _PIKE_CIPHER(aes, AES);
      struct CipherInfo_struct *CipherInfo = GET_INFO(Pike_fp->current_object);

      if (CipherInfo && !CipherInfo->meta)
	CipherInfo->meta = &pike_aes;
    }

#ifdef AES_Info_event_handler_defined
static void AES_Info_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_AES_Info_defined
  case PROG_EVENT_INIT: init_AES_Info_struct(); break;

#endif /* internal_init_AES_Info_defined */
  default: break; 
  }
}

#endif /* AES_Info_event_handler_defined */
/*! @endclass AES_Info */

/*! @class AES_State
 *!
 *! State for AES encyption
 */

#undef class_AES_State_defined
#define class_AES_State_defined
struct program *AES_State_program=NULL;
static int AES_State_program_fun_num=-1;

#undef inherit_AES_Info_AES_State_defined
#define inherit_AES_Info_AES_State_defined

#undef inherit_CipherState_AES_State_defined
#define inherit_CipherState_AES_State_defined

#undef var_aes_AES_State_defined
#define var_aes_AES_State_defined

#undef THIS
#define THIS ((struct AES_State_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_AES_STATE
#define THIS_AES_STATE ((struct AES_State_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_AES_STATE
#define OBJ2_AES_STATE(o) ((struct AES_State_struct *)(o->storage+AES_State_storage_offset))

#undef GET_AES_STATE_STORAGE
#define GET_AES_STATE_STORAGE ((struct AES_State_struct *)(o->storage+AES_State_storage_offset)
static ptrdiff_t AES_State_storage_offset;
struct AES_State_struct {

#ifdef var_aes_AES_State_defined
#line 361 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
struct aes_ctx aes;
#endif /* var_aes_AES_State_defined */
};

#undef internal_init_AES_State_defined
#define internal_init_AES_State_defined

#undef AES_State_event_handler_defined
#define AES_State_event_handler_defined
static void init_AES_State_struct(void)
#line 364 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
{
      struct CipherState_struct *state
	= (struct CipherState_struct *) get_storage(Pike_fp->current_object,
						    CipherState_program);

      assert(state);
      state->ctx = &THIS->aes;
    }

#ifdef AES_State_event_handler_defined
static void AES_State_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_AES_State_defined
  case PROG_EVENT_INIT: init_AES_State_struct(); break;

#endif /* internal_init_AES_State_defined */
  default: break; 
  }
}

#endif /* AES_State_event_handler_defined */
/*! @endclass AES_State */

#line 375 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
static void
pike_arcfour_set_key(void *ctx,
		     ptrdiff_t length, const char *key,
		     int force)
{
  if (length < ARCFOUR_MIN_KEY_SIZE || length > ARCFOUR_MAX_KEY_SIZE)
    Pike_error("ARCFOUR_Info: Bad keysize for ARCFOUR.\n");

  arcfour_set_key(ctx, length, key);
}
#define pike_arcfour_set_encrypt_key pike_arcfour_set_key
#define pike_arcfour_set_decrypt_key pike_arcfour_set_key
#define arcfour_encrypt arcfour_crypt
#define arcfour_decrypt arcfour_crypt
#define ARCFOUR_BLOCK_SIZE 1

/*! @class ARCFOUR_Info
 *!
 *! Internal mixin class, intended to be multiply inherited
 *! together with CipherInfo.
 */

#undef class_ARCFOUR_Info_defined
#define class_ARCFOUR_Info_defined
struct program *ARCFOUR_Info_program=NULL;
static int ARCFOUR_Info_program_fun_num=-1;

#undef internal_init_ARCFOUR_Info_defined
#define internal_init_ARCFOUR_Info_defined

#undef ARCFOUR_Info_event_handler_defined
#define ARCFOUR_Info_event_handler_defined
static void init_ARCFOUR_Info_struct(void)
#line 399 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
{
      static const struct pike_cipher pike_arcfour = _PIKE_CIPHER(arcfour, ARCFOUR);
      struct CipherInfo_struct *CipherInfo = GET_INFO(Pike_fp->current_object);

      if (CipherInfo && !CipherInfo->meta)
	CipherInfo->meta = &pike_arcfour;
    }

#ifdef ARCFOUR_Info_event_handler_defined
static void ARCFOUR_Info_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_ARCFOUR_Info_defined
  case PROG_EVENT_INIT: init_ARCFOUR_Info_struct(); break;

#endif /* internal_init_ARCFOUR_Info_defined */
  default: break; 
  }
}

#endif /* ARCFOUR_Info_event_handler_defined */
/*! @endclass ARCFOUR_Info */

/*! @class ARCFOUR_State
 *!
 *! State for ARCFOUR encyption
 */

#undef class_ARCFOUR_State_defined
#define class_ARCFOUR_State_defined
struct program *ARCFOUR_State_program=NULL;
static int ARCFOUR_State_program_fun_num=-1;

#undef inherit_ARCFOUR_Info_ARCFOUR_State_defined
#define inherit_ARCFOUR_Info_ARCFOUR_State_defined

#undef inherit_CipherState_ARCFOUR_State_defined
#define inherit_CipherState_ARCFOUR_State_defined

#undef var_arcfour_ARCFOUR_State_defined
#define var_arcfour_ARCFOUR_State_defined

#undef THIS
#define THIS ((struct ARCFOUR_State_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_ARCFOUR_STATE
#define THIS_ARCFOUR_STATE ((struct ARCFOUR_State_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_ARCFOUR_STATE
#define OBJ2_ARCFOUR_STATE(o) ((struct ARCFOUR_State_struct *)(o->storage+ARCFOUR_State_storage_offset))

#undef GET_ARCFOUR_STATE_STORAGE
#define GET_ARCFOUR_STATE_STORAGE ((struct ARCFOUR_State_struct *)(o->storage+ARCFOUR_State_storage_offset)
static ptrdiff_t ARCFOUR_State_storage_offset;
struct ARCFOUR_State_struct {

#ifdef var_arcfour_ARCFOUR_State_defined
#line 418 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
struct arcfour_ctx arcfour;
#endif /* var_arcfour_ARCFOUR_State_defined */
};

#undef internal_init_ARCFOUR_State_defined
#define internal_init_ARCFOUR_State_defined

#undef ARCFOUR_State_event_handler_defined
#define ARCFOUR_State_event_handler_defined
static void init_ARCFOUR_State_struct(void)
#line 421 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
{
      struct CipherState_struct *state
	= (struct CipherState_struct *) get_storage(Pike_fp->current_object,
						    CipherState_program);

      assert(state);
      state->ctx = &THIS->arcfour;
    }

#ifdef ARCFOUR_State_event_handler_defined
static void ARCFOUR_State_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_ARCFOUR_State_defined
  case PROG_EVENT_INIT: init_ARCFOUR_State_struct(); break;

#endif /* internal_init_ARCFOUR_State_defined */
  default: break; 
  }
}

#endif /* ARCFOUR_State_event_handler_defined */
/*! @endclass ARCFOUR_State */

#line 432 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
static void
pike_blowfish_set_key(void *ctx,
		      ptrdiff_t length, const char *key,
		      int force)
{
  if (length < BLOWFISH_MIN_KEY_SIZE || length > BLOWFISH_MAX_KEY_SIZE)
    Pike_error("BLOWFISH_Info: Bad keysize for BLOWFISH.\n");
  if (!blowfish_set_key(ctx, length, key))
    Pike_error("BLOWFISH_Info: Key is weak (and force flag is currently ignored).\n");
}
#define pike_blowfish_set_encrypt_key pike_blowfish_set_key
#define pike_blowfish_set_decrypt_key pike_blowfish_set_key


/*! @class BLOWFISH_Info
 *!
 *! Internal mixin class, intended to be multiply inherited
 *! together with CipherInfo.
 */

#undef class_BLOWFISH_Info_defined
#define class_BLOWFISH_Info_defined
struct program *BLOWFISH_Info_program=NULL;
static int BLOWFISH_Info_program_fun_num=-1;

#undef internal_init_BLOWFISH_Info_defined
#define internal_init_BLOWFISH_Info_defined

#undef BLOWFISH_Info_event_handler_defined
#define BLOWFISH_Info_event_handler_defined
static void init_BLOWFISH_Info_struct(void)
#line 454 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
{
      static const struct pike_cipher pike_blowfish = _PIKE_CIPHER(blowfish, BLOWFISH);
      struct CipherInfo_struct *CipherInfo = GET_INFO(Pike_fp->current_object);

      if (CipherInfo && !CipherInfo->meta)
	CipherInfo->meta = &pike_blowfish;
    }

#ifdef BLOWFISH_Info_event_handler_defined
static void BLOWFISH_Info_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_BLOWFISH_Info_defined
  case PROG_EVENT_INIT: init_BLOWFISH_Info_struct(); break;

#endif /* internal_init_BLOWFISH_Info_defined */
  default: break; 
  }
}

#endif /* BLOWFISH_Info_event_handler_defined */
/*! @endclass BLOWFISH_Info */

/*! @class BLOWFISH_State
 *!
 *! State for Blowfish encyption
 */

#undef class_BLOWFISH_State_defined
#define class_BLOWFISH_State_defined
struct program *BLOWFISH_State_program=NULL;
static int BLOWFISH_State_program_fun_num=-1;

#undef inherit_BLOWFISH_Info_BLOWFISH_State_defined
#define inherit_BLOWFISH_Info_BLOWFISH_State_defined

#undef inherit_CipherState_BLOWFISH_State_defined
#define inherit_CipherState_BLOWFISH_State_defined

#undef var_blowfish_BLOWFISH_State_defined
#define var_blowfish_BLOWFISH_State_defined

#undef THIS
#define THIS ((struct BLOWFISH_State_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_BLOWFISH_STATE
#define THIS_BLOWFISH_STATE ((struct BLOWFISH_State_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_BLOWFISH_STATE
#define OBJ2_BLOWFISH_STATE(o) ((struct BLOWFISH_State_struct *)(o->storage+BLOWFISH_State_storage_offset))

#undef GET_BLOWFISH_STATE_STORAGE
#define GET_BLOWFISH_STATE_STORAGE ((struct BLOWFISH_State_struct *)(o->storage+BLOWFISH_State_storage_offset)
static ptrdiff_t BLOWFISH_State_storage_offset;
struct BLOWFISH_State_struct {

#ifdef var_blowfish_BLOWFISH_State_defined
#line 473 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
struct blowfish_ctx blowfish;
#endif /* var_blowfish_BLOWFISH_State_defined */
};

#undef internal_init_BLOWFISH_State_defined
#define internal_init_BLOWFISH_State_defined

#undef BLOWFISH_State_event_handler_defined
#define BLOWFISH_State_event_handler_defined
static void init_BLOWFISH_State_struct(void)
#line 476 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
{
      struct CipherState_struct *state
	= (struct CipherState_struct *) get_storage(Pike_fp->current_object,
						    CipherState_program);

      assert(state);
      state->ctx = &THIS->blowfish;
    }

#ifdef BLOWFISH_State_event_handler_defined
static void BLOWFISH_State_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_BLOWFISH_State_defined
  case PROG_EVENT_INIT: init_BLOWFISH_State_struct(); break;

#endif /* internal_init_BLOWFISH_State_defined */
  default: break; 
  }
}

#endif /* BLOWFISH_State_event_handler_defined */
/*! @endclass BLOWFISH_State */

#line 487 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
static void
pike_cast128_set_key(void *ctx,
		     ptrdiff_t length, const char *key,
		     int force)
{
  if (length < CAST128_MIN_KEY_SIZE || length > CAST128_MAX_KEY_SIZE)
    Pike_error("CAST128_info: Bad keysize for CAST128.\n");
  
  cast128_set_key(ctx, length, key);
}
#define pike_cast128_set_encrypt_key pike_cast128_set_key
#define pike_cast128_set_decrypt_key pike_cast128_set_key

/*! @class CAST128_Info
 *!
 *! Internal mixin class, intended to be multiply inherited
 *! together with CipherInfo. */


#undef class_CAST128_Info_defined
#define class_CAST128_Info_defined
struct program *CAST128_Info_program=NULL;
static int CAST128_Info_program_fun_num=-1;

#undef internal_init_CAST128_Info_defined
#define internal_init_CAST128_Info_defined

#undef CAST128_Info_event_handler_defined
#define CAST128_Info_event_handler_defined
static void init_CAST128_Info_struct(void)
#line 508 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
{
      static const struct pike_cipher pike_cast128 = _PIKE_CIPHER(cast128, CAST128);
      struct CipherInfo_struct *CipherInfo = GET_INFO(Pike_fp->current_object);

      if (CipherInfo && !CipherInfo->meta)
	CipherInfo->meta = &pike_cast128;
    }

#ifdef CAST128_Info_event_handler_defined
static void CAST128_Info_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_CAST128_Info_defined
  case PROG_EVENT_INIT: init_CAST128_Info_struct(); break;

#endif /* internal_init_CAST128_Info_defined */
  default: break; 
  }
}

#endif /* CAST128_Info_event_handler_defined */
/*! @endclass CAST128_Info */

/*! @class CAST128_State
 *!
 *! State for CAST128 encyption
 */

#undef class_CAST128_State_defined
#define class_CAST128_State_defined
struct program *CAST128_State_program=NULL;
static int CAST128_State_program_fun_num=-1;

#undef inherit_CAST128_Info_CAST128_State_defined
#define inherit_CAST128_Info_CAST128_State_defined

#undef inherit_CipherState_CAST128_State_defined
#define inherit_CipherState_CAST128_State_defined

#undef var_cast128_CAST128_State_defined
#define var_cast128_CAST128_State_defined

#undef THIS
#define THIS ((struct CAST128_State_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_CAST128_STATE
#define THIS_CAST128_STATE ((struct CAST128_State_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_CAST128_STATE
#define OBJ2_CAST128_STATE(o) ((struct CAST128_State_struct *)(o->storage+CAST128_State_storage_offset))

#undef GET_CAST128_STATE_STORAGE
#define GET_CAST128_STATE_STORAGE ((struct CAST128_State_struct *)(o->storage+CAST128_State_storage_offset)
static ptrdiff_t CAST128_State_storage_offset;
struct CAST128_State_struct {

#ifdef var_cast128_CAST128_State_defined
#line 527 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
struct cast128_ctx cast128;
#endif /* var_cast128_CAST128_State_defined */
};

#undef internal_init_CAST128_State_defined
#define internal_init_CAST128_State_defined

#undef CAST128_State_event_handler_defined
#define CAST128_State_event_handler_defined
static void init_CAST128_State_struct(void)
#line 530 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
{
      struct CipherState_struct *state
	= (struct CipherState_struct *) get_storage(Pike_fp->current_object,
						    CipherState_program);

      assert(state);
      state->ctx = &THIS->cast128;
    }

#ifdef CAST128_State_event_handler_defined
static void CAST128_State_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_CAST128_State_defined
  case PROG_EVENT_INIT: init_CAST128_State_struct(); break;

#endif /* internal_init_CAST128_State_defined */
  default: break; 
  }
}

#endif /* CAST128_State_event_handler_defined */
/*! @endclass CAST128_State */

#line 541 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
static void
pike_des_set_key(void *c,
		 ptrdiff_t length, const char *key,
		 int force)
{
  struct des_ctx *ctx = (struct des_ctx *) c;
  if (length != 8)
    Pike_error("DES_INFO: Bad keysize for DES.\n");

  if (!des_set_key(ctx, key))
  {
    switch (ctx->status)
    {
    case DES_WEAK_KEY:
      if (force)
	/* Use key anyway */
	ctx->status = DES_OK;
      else
	Pike_error("DES_INFO: Key is weak.\n");
      break;
      
    case DES_BAD_PARITY:
      /* FIXME: I don't think this should be visible in the user
       * interface, the parity bits should just be ignored. */
      Pike_error("DES_INFO: Key has bad parity.\n");
    default:
      Pike_error("DES_INFO: Unexpected error, please send a bug report.\n");
    }
  }
}

#define pike_des_set_encrypt_key pike_des_set_key
#define pike_des_set_decrypt_key pike_des_set_key

/*! @class DES_Info
 *!
 *! Internal mixin class, intended to be multiply inherited
 *! together with CipherInfo. */


#undef class_DES_Info_defined
#define class_DES_Info_defined
struct program *DES_Info_program=NULL;
static int DES_Info_program_fun_num=-1;

#undef internal_init_DES_Info_defined
#define internal_init_DES_Info_defined

#undef DES_Info_event_handler_defined
#define DES_Info_event_handler_defined
static void init_DES_Info_struct(void)
#line 583 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
{
      static const struct pike_cipher pike_des = _PIKE_CIPHER(des, DES);
      struct CipherInfo_struct *CipherInfo = GET_INFO(Pike_fp->current_object);

      if (CipherInfo && !CipherInfo->meta)
	CipherInfo->meta = &pike_des;
    }

  /*! @decl string fix_parity(string key)
   *! Sets the last bit in every byte in @[key] to reflect the parity.
   *! If a seven byte key is used, it will be expanded into eight
   *! bytes. If a key longer than eight characters is used, it will
   *! be truncated to eight characters.
   */
  #define f_DES_Info_fix_parity_defined
ptrdiff_t f_DES_Info_fix_parity_fun_num = 0;
void f_DES_Info_fix_parity(INT32 args) {
#line 597 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
struct pike_string * key;
#line 597 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
if(args != 1) wrong_number_of_args_error("fix_parity",args,1);
#line 597 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("fix_parity",1,"string");
#line 597 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
debug_malloc_pass(key=Pike_sp[0-1].u.string);
{
    uint8_t buf[8];
    if(key->len < 7)
      Pike_error("Key must be at least 7 characters.\n");

    if(key->len == 7) {
      buf[0] = key->str[0]&254;
      buf[1] = (key->str[0]&1)<<7 | (key->str[1]>>1 & 126);
      buf[2] = (key->str[1]&3)<<6 | (key->str[2]>>2 & 62);
      buf[3] = (key->str[2]&7)<<5 | (key->str[3]>>3 & 30);
      buf[4] = (key->str[3]&15)<<4 | (key->str[4]>>4 & 14);
      buf[5] = (key->str[4]&31)<<3 | (key->str[5]>>5 & 6);
      buf[6] = (key->str[5]&63)<<2 | (key->str[6]>>6 & 2);
      buf[7] = (key->str[6]&127)<<1;
    }
    else
      MEMCPY(buf, key->str, 8);

    des_fix_parity(8, buf, buf);
    do { struct pike_string * ret_=(make_shared_binary_string(buf, 8)); pop_stack(); push_string(ret_); return; }while(0);
#line 618 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
}
}

#ifdef DES_Info_event_handler_defined
static void DES_Info_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_DES_Info_defined
  case PROG_EVENT_INIT: init_DES_Info_struct(); break;

#endif /* internal_init_DES_Info_defined */
  default: break; 
  }
}

#endif /* DES_Info_event_handler_defined */
/*! @endclass DES_Info */

/*! @class DES_State
 *!
 *! State for DES encyption
 */

#undef class_DES_State_defined
#define class_DES_State_defined
struct program *DES_State_program=NULL;
static int DES_State_program_fun_num=-1;

#undef inherit_DES_Info_DES_State_defined
#define inherit_DES_Info_DES_State_defined

#undef inherit_CipherState_DES_State_defined
#define inherit_CipherState_DES_State_defined

#undef var_des_DES_State_defined
#define var_des_DES_State_defined

#undef THIS
#define THIS ((struct DES_State_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_DES_STATE
#define THIS_DES_STATE ((struct DES_State_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_DES_STATE
#define OBJ2_DES_STATE(o) ((struct DES_State_struct *)(o->storage+DES_State_storage_offset))

#undef GET_DES_STATE_STORAGE
#define GET_DES_STATE_STORAGE ((struct DES_State_struct *)(o->storage+DES_State_storage_offset)
static ptrdiff_t DES_State_storage_offset;
struct DES_State_struct {

#ifdef var_des_DES_State_defined
#line 631 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
struct des_ctx des;
#endif /* var_des_DES_State_defined */
};

#undef internal_init_DES_State_defined
#define internal_init_DES_State_defined

#undef DES_State_event_handler_defined
#define DES_State_event_handler_defined
static void init_DES_State_struct(void)
#line 634 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
{
      struct CipherState_struct *state
	= (struct CipherState_struct *) get_storage(Pike_fp->current_object,
						    CipherState_program);

      assert(state);
      state->ctx = &THIS->des;
    }

  #define f_DES_State_make_key_defined
ptrdiff_t f_DES_State_make_key_fun_num = 0;
void f_DES_State_make_key(INT32 args) {
#line 643 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
if(args != 0) wrong_number_of_args_error("make_key",args,0);
{
    struct CipherInfo_struct *info = GET_INFO(Pike_fp->current_object);
    struct CipherState_struct *state
	= (struct CipherState_struct *) get_storage(Pike_fp->current_object,
						    CipherState_program);
    assert(info);
    assert(state);

    low_make_key(info->meta->key_size);
    f_DES_Info_fix_parity(1);

    /* FIXME: There should be a check for weak keys so this never throws. */
    info->meta->set_encrypt_key(state->ctx, Pike_sp[-1].u.string->len,
				Pike_sp[-1].u.string->str, 0);

    state->crypt = info->meta->encrypt;
    state->key_size = Pike_sp[-1].u.string->len;
  }
}

#ifdef DES_State_event_handler_defined
static void DES_State_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_DES_State_defined
  case PROG_EVENT_INIT: init_DES_State_struct(); break;

#endif /* internal_init_DES_State_defined */
  default: break; 
  }
}

#endif /* DES_State_event_handler_defined */
/*! @endclass DES_State */

#line 665 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
void f_DES3_Info_fix_parity(INT32);

static void
pike_des3_set_key(void *c,
		  ptrdiff_t length, char *key,
		  int force)
{
  struct des3_ctx *ctx = (struct des3_ctx *) c;
  int i;
  char nkotb[24];

  switch( length ) {
  case 7+7:
    push_string(make_shared_binary_string(key, length));
    push_text("1234567");
    f_add(2);
    f_DES3_Info_fix_parity(1);

    MEMCPY(nkotb, Pike_sp[-1].u.string->str, 8+8);
    pop_stack();

    key = nkotb;
    length = 8+8;
    /* fallthrough */
  case 8+8:
    push_string(make_shared_binary_string(key, length));
    push_string(make_shared_binary_string(key, length));
    push_int(0);
    push_int(7);
    o_range();
    f_add(2);

    MEMCPY(nkotb, Pike_sp[-1].u.string->str, 8+8+8);
    pop_stack();

    key = nkotb;
    length = 8+8+8;
    break;

  case 7+7+7:
    push_string(make_shared_binary_string(key, length));
    f_DES3_Info_fix_parity(1);
    MEMCPY(nkotb, Pike_sp[-1].u.string->str, 8+8+8);
    pop_stack();

    key = nkotb;
    length = 8+8+8;
    break;

  case 8+8+8:
    break;

  default:
    Pike_error("DES3_INFO: Bad keysize for DES3.\n");
    break;
  }

  /* The hack of resetting ctx->status to use a weak key doesn't
   * currently work with nettle's des3_set_key function. So we set the
   * individual keys by ourself. */
  for (i = 0; i<3; i++, key += DES_KEY_SIZE)
    if (!des_set_key(&ctx->des[i], key))
      switch (ctx->des[i].status)
      {
      case DES_WEAK_KEY:
	if (force)
	  /* Use key anyway */
	  ctx->des[i].status = DES_OK;
	else
	  Pike_error("DES3_INFO: Key is weak.\n");
	break;
      
      case DES_BAD_PARITY:
	/* FIXME: I don't think this should be visible in the user
	 * interface, the parity bits should just be ignored. */
	Pike_error("DES3_INFO: Key has bad parity.\n");
      default:
	Pike_error("DES3_INFO: Unexpected error, please send a bug report.\n");
    }
}
#define pike_des3_set_encrypt_key pike_des3_set_key
#define pike_des3_set_decrypt_key pike_des3_set_key


/*! @class DES3_Info
 *!
 *! Internal mixin class, intended to be multiply inherited
 *! together with CipherInfo. */


#undef class_DES3_Info_defined
#define class_DES3_Info_defined
struct program *DES3_Info_program=NULL;
static int DES3_Info_program_fun_num=-1;

#undef internal_init_DES3_Info_defined
#define internal_init_DES3_Info_defined

#undef DES3_Info_event_handler_defined
#define DES3_Info_event_handler_defined
static void init_DES3_Info_struct(void)
#line 757 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
{
      static const struct pike_cipher pike_des3 = _PIKE_CIPHER(des3, DES3);
      struct CipherInfo_struct *CipherInfo = GET_INFO(Pike_fp->current_object);

      if (CipherInfo && !CipherInfo->meta)
	CipherInfo->meta = &pike_des3;
    }

  /*! @decl string fix_parity(string key)
   *! Sets the last bit in every byte in @[key] to reflect the parity.
   *! If a 21 byte key is used, it will be expanded into 24
   *! bytes. If a key longer than 24 characters is used, it will
   *! be truncated to 24 characters.
   */
  #define f_DES3_Info_fix_parity_defined
ptrdiff_t f_DES3_Info_fix_parity_fun_num = 0;
void f_DES3_Info_fix_parity(INT32 args) {
#line 771 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
struct pike_string * key;
#line 771 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
if(args != 1) wrong_number_of_args_error("fix_parity",args,1);
#line 771 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("fix_parity",1,"string");
#line 771 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
debug_malloc_pass(key=Pike_sp[0-1].u.string);
{
    INT32 i;
    struct array *arr;

    if(key->len < 24 && key->len != 21)
      Pike_error("Key must be 21 or >=24 characters.\n");

    /* Split the string */
    if(key->len==21)
      push_int(7);
    else
      push_int(8);
    f_divide(2);
    arr = Pike_sp[-1].u.array;
    add_ref(arr);
    pop_stack();

    /* fix_parity for every subkey */
    for(i=0; i<3; i++) {
      push_int(0);
      array_index(&Pike_sp[-1], arr, i);
      f_DES_Info_fix_parity(1);
    }
    free_array(arr);

    /* Join the subkeys */
    f_add(3);
  }
}

#ifdef DES3_Info_event_handler_defined
static void DES3_Info_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_DES3_Info_defined
  case PROG_EVENT_INIT: init_DES3_Info_struct(); break;

#endif /* internal_init_DES3_Info_defined */
  default: break; 
  }
}

#endif /* DES3_Info_event_handler_defined */
/*! @endclass DES3_Info */

/*! @class DES3_State
 *!
 *! State for DES3 encyption
 */

#undef class_DES3_State_defined
#define class_DES3_State_defined
struct program *DES3_State_program=NULL;
static int DES3_State_program_fun_num=-1;

#undef inherit_DES3_Info_DES3_State_defined
#define inherit_DES3_Info_DES3_State_defined

#undef inherit_CipherState_DES3_State_defined
#define inherit_CipherState_DES3_State_defined

#undef var_des3_DES3_State_defined
#define var_des3_DES3_State_defined

#undef THIS
#define THIS ((struct DES3_State_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_DES3_STATE
#define THIS_DES3_STATE ((struct DES3_State_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_DES3_STATE
#define OBJ2_DES3_STATE(o) ((struct DES3_State_struct *)(o->storage+DES3_State_storage_offset))

#undef GET_DES3_STATE_STORAGE
#define GET_DES3_STATE_STORAGE ((struct DES3_State_struct *)(o->storage+DES3_State_storage_offset)
static ptrdiff_t DES3_State_storage_offset;
struct DES3_State_struct {

#ifdef var_des3_DES3_State_defined
#line 812 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
struct des3_ctx des3;
#endif /* var_des3_DES3_State_defined */
};

#undef internal_init_DES3_State_defined
#define internal_init_DES3_State_defined

#undef DES3_State_event_handler_defined
#define DES3_State_event_handler_defined
static void init_DES3_State_struct(void)
#line 815 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
{
      struct CipherState_struct *state
	= (struct CipherState_struct *) get_storage(Pike_fp->current_object,
						    CipherState_program);

      assert(state);
      state->ctx = &THIS->des3;
    }

  #define f_DES3_State_make_key_defined
ptrdiff_t f_DES3_State_make_key_fun_num = 0;
void f_DES3_State_make_key(INT32 args) {
#line 824 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
if(args != 0) wrong_number_of_args_error("make_key",args,0);
{
    struct CipherInfo_struct *info = GET_INFO(Pike_fp->current_object);
    struct CipherState_struct *state
	= (struct CipherState_struct *) get_storage(Pike_fp->current_object,
						    CipherState_program);
    assert(info);
    assert(state);

    low_make_key(info->meta->key_size);
    f_DES3_Info_fix_parity(1);

    /* FIXME: There should be a check for weak keys so this never throws. */
    info->meta->set_encrypt_key(state->ctx, Pike_sp[-1].u.string->len,
				Pike_sp[-1].u.string->str, 0);

    state->crypt = info->meta->encrypt;
    state->key_size = Pike_sp[-1].u.string->len;
  }
}

#ifdef DES3_State_event_handler_defined
static void DES3_State_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_DES3_State_defined
  case PROG_EVENT_INIT: init_DES3_State_struct(); break;

#endif /* internal_init_DES3_State_defined */
  default: break; 
  }
}

#endif /* DES3_State_event_handler_defined */
/*! @endclass DES3_State */

#line 846 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
static void
pike_serpent_set_key(void *ctx,
		     ptrdiff_t length, const char *key,
		     int force)
{
  if (length < SERPENT_MIN_KEY_SIZE || length > SERPENT_MAX_KEY_SIZE)
    Pike_error("SERPENT_Info: Bad keysize for SERPENT.\n");
  
  serpent_set_key(ctx, length, key);
}
#define pike_serpent_set_encrypt_key pike_serpent_set_key
#define pike_serpent_set_decrypt_key pike_serpent_set_key

/*! @class Serpent_Info
 *!
 *! Internal mixin class, intended to be multiply inherited
 *! together with CipherInfo. */


#undef class_Serpent_Info_defined
#define class_Serpent_Info_defined
struct program *Serpent_Info_program=NULL;
static int Serpent_Info_program_fun_num=-1;

#undef internal_init_Serpent_Info_defined
#define internal_init_Serpent_Info_defined

#undef Serpent_Info_event_handler_defined
#define Serpent_Info_event_handler_defined
static void init_Serpent_Info_struct(void)
#line 867 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
{
      static const struct pike_cipher pike_serpent = _PIKE_CIPHER(serpent, SERPENT);
      struct CipherInfo_struct *CipherInfo = GET_INFO(Pike_fp->current_object);

      if (CipherInfo && !CipherInfo->meta)
	CipherInfo->meta = &pike_serpent;
    }

#ifdef Serpent_Info_event_handler_defined
static void Serpent_Info_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_Serpent_Info_defined
  case PROG_EVENT_INIT: init_Serpent_Info_struct(); break;

#endif /* internal_init_Serpent_Info_defined */
  default: break; 
  }
}

#endif /* Serpent_Info_event_handler_defined */
/*! @endclass Serpent_Info */

/*! @class Serpent_State
 *!
 *! State for Serpent encyption
 */

#undef class_Serpent_State_defined
#define class_Serpent_State_defined
struct program *Serpent_State_program=NULL;
static int Serpent_State_program_fun_num=-1;

#undef inherit_Serpent_Info_Serpent_State_defined
#define inherit_Serpent_Info_Serpent_State_defined

#undef inherit_CipherState_Serpent_State_defined
#define inherit_CipherState_Serpent_State_defined

#undef var_serpent_Serpent_State_defined
#define var_serpent_Serpent_State_defined

#undef THIS
#define THIS ((struct Serpent_State_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_SERPENT_STATE
#define THIS_SERPENT_STATE ((struct Serpent_State_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_SERPENT_STATE
#define OBJ2_SERPENT_STATE(o) ((struct Serpent_State_struct *)(o->storage+Serpent_State_storage_offset))

#undef GET_SERPENT_STATE_STORAGE
#define GET_SERPENT_STATE_STORAGE ((struct Serpent_State_struct *)(o->storage+Serpent_State_storage_offset)
static ptrdiff_t Serpent_State_storage_offset;
struct Serpent_State_struct {

#ifdef var_serpent_Serpent_State_defined
#line 886 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
struct serpent_ctx serpent;
#endif /* var_serpent_Serpent_State_defined */
};

#undef internal_init_Serpent_State_defined
#define internal_init_Serpent_State_defined

#undef Serpent_State_event_handler_defined
#define Serpent_State_event_handler_defined
static void init_Serpent_State_struct(void)
#line 889 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
{
      struct CipherState_struct *state
	= (struct CipherState_struct *) get_storage(Pike_fp->current_object,
						    CipherState_program);

      assert(state);
      state->ctx = &THIS->serpent;
    }

#ifdef Serpent_State_event_handler_defined
static void Serpent_State_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_Serpent_State_defined
  case PROG_EVENT_INIT: init_Serpent_State_struct(); break;

#endif /* internal_init_Serpent_State_defined */
  default: break; 
  }
}

#endif /* Serpent_State_event_handler_defined */
/*! @endclass Serpent_State */

#line 900 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
static void
pike_twofish_set_key(void *ctx,
		     ptrdiff_t length, const char *key,
		     int force)
{
  if (length < TWOFISH_MIN_KEY_SIZE || length > TWOFISH_MAX_KEY_SIZE)
    Pike_error("TWOFISH_Info: Bad keysize for TWOFISH.\n");

  twofish_set_key(ctx, length, key);
}
#define pike_twofish_set_encrypt_key pike_twofish_set_key
#define pike_twofish_set_decrypt_key pike_twofish_set_key

/*! @class Twofish_Info
 *!
 *! Internal mixin class, intended to be multiply inherited
 *! together with CipherInfo. */


#undef class_Twofish_Info_defined
#define class_Twofish_Info_defined
struct program *Twofish_Info_program=NULL;
static int Twofish_Info_program_fun_num=-1;

#undef internal_init_Twofish_Info_defined
#define internal_init_Twofish_Info_defined

#undef Twofish_Info_event_handler_defined
#define Twofish_Info_event_handler_defined
static void init_Twofish_Info_struct(void)
#line 921 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
{
      static const struct pike_cipher pike_twofish = _PIKE_CIPHER(twofish, TWOFISH);
      struct CipherInfo_struct *CipherInfo = GET_INFO(Pike_fp->current_object);

      if (CipherInfo && !CipherInfo->meta)
	CipherInfo->meta = &pike_twofish;
    }

#ifdef Twofish_Info_event_handler_defined
static void Twofish_Info_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_Twofish_Info_defined
  case PROG_EVENT_INIT: init_Twofish_Info_struct(); break;

#endif /* internal_init_Twofish_Info_defined */
  default: break; 
  }
}

#endif /* Twofish_Info_event_handler_defined */
/*! @endclass Twofish_Info */

/*! @class Twofish_State
 *!
 *! State for Twofish encyption
 */

#undef class_Twofish_State_defined
#define class_Twofish_State_defined
struct program *Twofish_State_program=NULL;
static int Twofish_State_program_fun_num=-1;

#undef inherit_Twofish_Info_Twofish_State_defined
#define inherit_Twofish_Info_Twofish_State_defined

#undef inherit_CipherState_Twofish_State_defined
#define inherit_CipherState_Twofish_State_defined

#undef var_twofish_Twofish_State_defined
#define var_twofish_Twofish_State_defined

#undef THIS
#define THIS ((struct Twofish_State_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_TWOFISH_STATE
#define THIS_TWOFISH_STATE ((struct Twofish_State_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_TWOFISH_STATE
#define OBJ2_TWOFISH_STATE(o) ((struct Twofish_State_struct *)(o->storage+Twofish_State_storage_offset))

#undef GET_TWOFISH_STATE_STORAGE
#define GET_TWOFISH_STATE_STORAGE ((struct Twofish_State_struct *)(o->storage+Twofish_State_storage_offset)
static ptrdiff_t Twofish_State_storage_offset;
struct Twofish_State_struct {

#ifdef var_twofish_Twofish_State_defined
#line 940 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
struct twofish_ctx twofish;
#endif /* var_twofish_Twofish_State_defined */
};

#undef internal_init_Twofish_State_defined
#define internal_init_Twofish_State_defined

#undef Twofish_State_event_handler_defined
#define Twofish_State_event_handler_defined
static void init_Twofish_State_struct(void)
#line 943 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
{
      struct CipherState_struct *state
	= (struct CipherState_struct *) get_storage(Pike_fp->current_object,
						    CipherState_program);

      assert(state);
      state->ctx = &THIS->twofish;
    }

#ifdef Twofish_State_event_handler_defined
static void Twofish_State_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_Twofish_State_defined
  case PROG_EVENT_INIT: init_Twofish_State_struct(); break;

#endif /* internal_init_Twofish_State_defined */
  default: break; 
  }
}

#endif /* Twofish_State_event_handler_defined */
/*! @endclass Twofish_State */

#line 954 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
static void
pike_idea_set_encrypt_key(struct idea_ctx *ctx,
			 ptrdiff_t length, const char *key,
			 int force)
{
  if (length == IDEA_KEY_SIZE)
    idea_expand((unsigned INT16 *)ctx->ctx, (unsigned INT8 *)key);
  else
    Pike_error("IDEA_Info: Bad keysize for IDEA.\n");
}

static void
pike_idea_set_decrypt_key(struct idea_ctx *ctx,
			 ptrdiff_t length, const char *key,
			 int force)
{
  if (length == IDEA_KEY_SIZE) {
    idea_expand((unsigned INT16 *)ctx->ctx, (unsigned INT8 *)key);
    idea_invert((unsigned INT16 *)ctx->ctx, (unsigned INT16 *)ctx->ctx);
  }
  else
    Pike_error("IDEA_Info: Bad keysize for IDEA.\n");
}

#define idea_encrypt idea_crypt_blocks
#define idea_decrypt idea_crypt_blocks

/*! @class IDEA_Info
 *!
 *! Internal mixin class, intended to be multiply inherited
 *! together with CipherInfo.
 */

#undef class_IDEA_Info_defined
#define class_IDEA_Info_defined
struct program *IDEA_Info_program=NULL;
static int IDEA_Info_program_fun_num=-1;

#undef internal_init_IDEA_Info_defined
#define internal_init_IDEA_Info_defined

#undef IDEA_Info_event_handler_defined
#define IDEA_Info_event_handler_defined
static void init_IDEA_Info_struct(void)
#line 989 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
{
      static const struct pike_cipher pike_idea = _PIKE_CIPHER(idea, IDEA);
      struct CipherInfo_struct *CipherInfo = GET_INFO(Pike_fp->current_object);

      if (CipherInfo && !CipherInfo->meta)
	CipherInfo->meta = &pike_idea;
    }

#ifdef IDEA_Info_event_handler_defined
static void IDEA_Info_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_IDEA_Info_defined
  case PROG_EVENT_INIT: init_IDEA_Info_struct(); break;

#endif /* internal_init_IDEA_Info_defined */
  default: break; 
  }
}

#endif /* IDEA_Info_event_handler_defined */
/*! @endclass IDEA_Info */

/*! @class IDEA_State
 *!
 *! State for IDEA encyption
 */

#undef class_IDEA_State_defined
#define class_IDEA_State_defined
struct program *IDEA_State_program=NULL;
static int IDEA_State_program_fun_num=-1;

#undef inherit_IDEA_Info_IDEA_State_defined
#define inherit_IDEA_Info_IDEA_State_defined

#undef inherit_CipherState_IDEA_State_defined
#define inherit_CipherState_IDEA_State_defined

#undef var_idea_IDEA_State_defined
#define var_idea_IDEA_State_defined

#undef THIS
#define THIS ((struct IDEA_State_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_IDEA_STATE
#define THIS_IDEA_STATE ((struct IDEA_State_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_IDEA_STATE
#define OBJ2_IDEA_STATE(o) ((struct IDEA_State_struct *)(o->storage+IDEA_State_storage_offset))

#undef GET_IDEA_STATE_STORAGE
#define GET_IDEA_STATE_STORAGE ((struct IDEA_State_struct *)(o->storage+IDEA_State_storage_offset)
static ptrdiff_t IDEA_State_storage_offset;
struct IDEA_State_struct {

#ifdef var_idea_IDEA_State_defined
#line 1008 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
struct idea_ctx idea;
#endif /* var_idea_IDEA_State_defined */
};

#undef internal_init_IDEA_State_defined
#define internal_init_IDEA_State_defined

#undef IDEA_State_event_handler_defined
#define IDEA_State_event_handler_defined
static void init_IDEA_State_struct(void)
#line 1011 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
{
      struct CipherState_struct *state
	= (struct CipherState_struct *) get_storage(Pike_fp->current_object,
						    CipherState_program);

      assert(state);
      state->ctx = &THIS->idea;
    }

#ifdef IDEA_State_event_handler_defined
static void IDEA_State_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_IDEA_State_defined
  case PROG_EVENT_INIT: init_IDEA_State_struct(); break;

#endif /* internal_init_IDEA_State_defined */
  default: break; 
  }
}

#endif /* IDEA_State_event_handler_defined */
/*! @endclass IDEA_State */

/*! @endmodule Nettle */

#line 1024 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
void
cipher_init(void)
{
  
#ifdef class_CipherInfo_defined

#ifdef PROG_CIPHERINFO_ID
#line 92 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  START_NEW_PROGRAM_ID(CIPHERINFO);
#else
#line 92 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  start_new_program();

#endif /* PROG_CIPHERINFO_ID */

#ifndef tObjImpl_CIPHERINFO

#undef tObjImpl_CIPHERINFO
#define tObjImpl_CIPHERINFO tObj

#endif /* tObjImpl_CIPHERINFO */

#ifdef THIS_CIPHERINFO

  CipherInfo_storage_offset=ADD_STORAGE(struct CipherInfo_struct);

#endif /* THIS_CIPHERINFO */

#ifdef CipherInfo_event_handler_defined
  pike_set_prog_event_callback(CipherInfo_event_handler);

#endif /* CipherInfo_event_handler_defined */

#ifdef f_CipherInfo_name_defined
  f_CipherInfo_name_fun_num =
#line 101 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    ADD_FUNCTION2("name", f_CipherInfo_name, tFunc(tNone,tString), 0, OPT_TRY_OPTIMIZE);

#endif /* f_CipherInfo_name_defined */

#ifdef f_CipherInfo_key_size_defined
  f_CipherInfo_key_size_fun_num =
#line 115 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    ADD_FUNCTION2("key_size", f_CipherInfo_key_size, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_TRY_OPTIMIZE);

#endif /* f_CipherInfo_key_size_defined */

#ifdef f_CipherInfo_block_size_defined
  f_CipherInfo_block_size_fun_num =
#line 129 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    ADD_FUNCTION2("block_size", f_CipherInfo_block_size, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_TRY_OPTIMIZE);

#endif /* f_CipherInfo_block_size_defined */
#line 92 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  CipherInfo_program=end_program();
#line 92 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  CipherInfo_program_fun_num=add_program_constant("CipherInfo",CipherInfo_program,0);

#endif /* class_CipherInfo_defined */

#ifdef class_CipherState_defined

#ifdef PROG_CIPHERSTATE_ID
#line 165 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  START_NEW_PROGRAM_ID(CIPHERSTATE);
#else
#line 165 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  start_new_program();

#endif /* PROG_CIPHERSTATE_ID */

#ifndef tObjImpl_CIPHERSTATE

#undef tObjImpl_CIPHERSTATE
#define tObjImpl_CIPHERSTATE tObj

#endif /* tObjImpl_CIPHERSTATE */

#ifdef THIS_CIPHERSTATE

  CipherState_storage_offset=ADD_STORAGE(struct CipherState_struct);

#endif /* THIS_CIPHERSTATE */

#ifdef inherit_CipherInfo_CipherState_defined
#line 167 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  low_inherit(CipherInfo_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_CipherInfo_CipherState_defined */

#ifdef CipherState_event_handler_defined
  pike_set_prog_event_callback(CipherState_event_handler);

#endif /* CipherState_event_handler_defined */

#ifdef f_CipherState_set_encrypt_key_defined
  f_CipherState_set_encrypt_key_fun_num =
#line 182 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    ADD_FUNCTION2("set_encrypt_key", f_CipherState_set_encrypt_key, tFunc(tString tOr(tVoid,"\10\200\0\0\0\177\377\377\377"),tObj), 0, OPT_SIDE_EFFECT);

#endif /* f_CipherState_set_encrypt_key_defined */

#ifdef f_CipherState_set_decrypt_key_defined
  f_CipherState_set_decrypt_key_fun_num =
#line 208 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    ADD_FUNCTION2("set_decrypt_key", f_CipherState_set_decrypt_key, tFunc(tString tOr(tVoid,"\10\200\0\0\0\177\377\377\377"),tObj), 0, OPT_SIDE_EFFECT);

#endif /* f_CipherState_set_decrypt_key_defined */

#ifdef f_CipherState_make_key_defined
  f_CipherState_make_key_fun_num =
#line 237 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    ADD_FUNCTION2("make_key", f_CipherState_make_key, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND);

#endif /* f_CipherState_make_key_defined */

#ifdef f_CipherState_crypt_defined
  f_CipherState_crypt_fun_num =
#line 261 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    ADD_FUNCTION2("crypt", f_CipherState_crypt, tFunc(tString,tString), 0, OPT_EXTERNAL_DEPEND);

#endif /* f_CipherState_crypt_defined */

#ifdef f_CipherState_key_size_defined
  f_CipherState_key_size_fun_num =
#line 286 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    ADD_FUNCTION2("key_size", f_CipherState_key_size, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND);

#endif /* f_CipherState_key_size_defined */
#line 165 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  CipherState_program=end_program();
#line 165 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  CipherState_program_fun_num=add_program_constant("CipherState",CipherState_program,0);

#endif /* class_CipherState_defined */

#ifdef class_AES_Info_defined

#ifdef PROG_AES_INFO_ID
#line 339 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  START_NEW_PROGRAM_ID(AES_INFO);
#else
#line 339 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  start_new_program();

#endif /* PROG_AES_INFO_ID */

#ifndef tObjImpl_AES_INFO

#undef tObjImpl_AES_INFO
#define tObjImpl_AES_INFO tObj

#endif /* tObjImpl_AES_INFO */

#ifdef THIS_AES_INFO

  AES_Info_storage_offset=ADD_STORAGE(struct AES_Info_struct);

#endif /* THIS_AES_INFO */

#ifdef AES_Info_event_handler_defined
  pike_set_prog_event_callback(AES_Info_event_handler);

#endif /* AES_Info_event_handler_defined */
#line 339 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  AES_Info_program=end_program();
#line 339 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  AES_Info_program_fun_num=add_program_constant("AES_Info",AES_Info_program,0);

#endif /* class_AES_Info_defined */

#ifdef class_AES_State_defined

#ifdef PROG_AES_STATE_ID
#line 357 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  START_NEW_PROGRAM_ID(AES_STATE);
#else
#line 357 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  start_new_program();

#endif /* PROG_AES_STATE_ID */

#ifndef tObjImpl_AES_STATE

#undef tObjImpl_AES_STATE
#define tObjImpl_AES_STATE tObj

#endif /* tObjImpl_AES_STATE */

#ifdef THIS_AES_STATE

  AES_State_storage_offset=ADD_STORAGE(struct AES_State_struct);

#endif /* THIS_AES_STATE */

#ifdef inherit_AES_Info_AES_State_defined
#line 359 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  low_inherit(AES_Info_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_AES_Info_AES_State_defined */

#ifdef inherit_CipherState_AES_State_defined
#line 360 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  low_inherit(CipherState_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_CipherState_AES_State_defined */

#ifdef AES_State_event_handler_defined
  pike_set_prog_event_callback(AES_State_event_handler);

#endif /* AES_State_event_handler_defined */
#line 357 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  AES_State_program=end_program();
#line 357 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  AES_State_program_fun_num=add_program_constant("AES_State",AES_State_program,0);

#endif /* class_AES_State_defined */

#ifdef class_ARCFOUR_Info_defined

#ifdef PROG_ARCFOUR_INFO_ID
#line 396 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  START_NEW_PROGRAM_ID(ARCFOUR_INFO);
#else
#line 396 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  start_new_program();

#endif /* PROG_ARCFOUR_INFO_ID */

#ifndef tObjImpl_ARCFOUR_INFO

#undef tObjImpl_ARCFOUR_INFO
#define tObjImpl_ARCFOUR_INFO tObj

#endif /* tObjImpl_ARCFOUR_INFO */

#ifdef THIS_ARCFOUR_INFO

  ARCFOUR_Info_storage_offset=ADD_STORAGE(struct ARCFOUR_Info_struct);

#endif /* THIS_ARCFOUR_INFO */

#ifdef ARCFOUR_Info_event_handler_defined
  pike_set_prog_event_callback(ARCFOUR_Info_event_handler);

#endif /* ARCFOUR_Info_event_handler_defined */
#line 396 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  ARCFOUR_Info_program=end_program();
#line 396 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  ARCFOUR_Info_program_fun_num=add_program_constant("ARCFOUR_Info",ARCFOUR_Info_program,0);

#endif /* class_ARCFOUR_Info_defined */

#ifdef class_ARCFOUR_State_defined

#ifdef PROG_ARCFOUR_STATE_ID
#line 414 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  START_NEW_PROGRAM_ID(ARCFOUR_STATE);
#else
#line 414 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  start_new_program();

#endif /* PROG_ARCFOUR_STATE_ID */

#ifndef tObjImpl_ARCFOUR_STATE

#undef tObjImpl_ARCFOUR_STATE
#define tObjImpl_ARCFOUR_STATE tObj

#endif /* tObjImpl_ARCFOUR_STATE */

#ifdef THIS_ARCFOUR_STATE

  ARCFOUR_State_storage_offset=ADD_STORAGE(struct ARCFOUR_State_struct);

#endif /* THIS_ARCFOUR_STATE */

#ifdef inherit_ARCFOUR_Info_ARCFOUR_State_defined
#line 416 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  low_inherit(ARCFOUR_Info_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_ARCFOUR_Info_ARCFOUR_State_defined */

#ifdef inherit_CipherState_ARCFOUR_State_defined
#line 417 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  low_inherit(CipherState_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_CipherState_ARCFOUR_State_defined */

#ifdef ARCFOUR_State_event_handler_defined
  pike_set_prog_event_callback(ARCFOUR_State_event_handler);

#endif /* ARCFOUR_State_event_handler_defined */
#line 414 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  ARCFOUR_State_program=end_program();
#line 414 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  ARCFOUR_State_program_fun_num=add_program_constant("ARCFOUR_State",ARCFOUR_State_program,0);

#endif /* class_ARCFOUR_State_defined */

#ifdef class_BLOWFISH_Info_defined

#ifdef PROG_BLOWFISH_INFO_ID
#line 451 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  START_NEW_PROGRAM_ID(BLOWFISH_INFO);
#else
#line 451 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  start_new_program();

#endif /* PROG_BLOWFISH_INFO_ID */

#ifndef tObjImpl_BLOWFISH_INFO

#undef tObjImpl_BLOWFISH_INFO
#define tObjImpl_BLOWFISH_INFO tObj

#endif /* tObjImpl_BLOWFISH_INFO */

#ifdef THIS_BLOWFISH_INFO

  BLOWFISH_Info_storage_offset=ADD_STORAGE(struct BLOWFISH_Info_struct);

#endif /* THIS_BLOWFISH_INFO */

#ifdef BLOWFISH_Info_event_handler_defined
  pike_set_prog_event_callback(BLOWFISH_Info_event_handler);

#endif /* BLOWFISH_Info_event_handler_defined */
#line 451 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  BLOWFISH_Info_program=end_program();
#line 451 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  BLOWFISH_Info_program_fun_num=add_program_constant("BLOWFISH_Info",BLOWFISH_Info_program,0);

#endif /* class_BLOWFISH_Info_defined */

#ifdef class_BLOWFISH_State_defined

#ifdef PROG_BLOWFISH_STATE_ID
#line 469 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  START_NEW_PROGRAM_ID(BLOWFISH_STATE);
#else
#line 469 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  start_new_program();

#endif /* PROG_BLOWFISH_STATE_ID */

#ifndef tObjImpl_BLOWFISH_STATE

#undef tObjImpl_BLOWFISH_STATE
#define tObjImpl_BLOWFISH_STATE tObj

#endif /* tObjImpl_BLOWFISH_STATE */

#ifdef THIS_BLOWFISH_STATE

  BLOWFISH_State_storage_offset=ADD_STORAGE(struct BLOWFISH_State_struct);

#endif /* THIS_BLOWFISH_STATE */

#ifdef inherit_BLOWFISH_Info_BLOWFISH_State_defined
#line 471 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  low_inherit(BLOWFISH_Info_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_BLOWFISH_Info_BLOWFISH_State_defined */

#ifdef inherit_CipherState_BLOWFISH_State_defined
#line 472 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  low_inherit(CipherState_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_CipherState_BLOWFISH_State_defined */

#ifdef BLOWFISH_State_event_handler_defined
  pike_set_prog_event_callback(BLOWFISH_State_event_handler);

#endif /* BLOWFISH_State_event_handler_defined */
#line 469 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  BLOWFISH_State_program=end_program();
#line 469 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  BLOWFISH_State_program_fun_num=add_program_constant("BLOWFISH_State",BLOWFISH_State_program,0);

#endif /* class_BLOWFISH_State_defined */

#ifdef class_CAST128_Info_defined

#ifdef PROG_CAST128_INFO_ID
#line 505 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  START_NEW_PROGRAM_ID(CAST128_INFO);
#else
#line 505 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  start_new_program();

#endif /* PROG_CAST128_INFO_ID */

#ifndef tObjImpl_CAST128_INFO

#undef tObjImpl_CAST128_INFO
#define tObjImpl_CAST128_INFO tObj

#endif /* tObjImpl_CAST128_INFO */

#ifdef THIS_CAST128_INFO

  CAST128_Info_storage_offset=ADD_STORAGE(struct CAST128_Info_struct);

#endif /* THIS_CAST128_INFO */

#ifdef CAST128_Info_event_handler_defined
  pike_set_prog_event_callback(CAST128_Info_event_handler);

#endif /* CAST128_Info_event_handler_defined */
#line 505 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  CAST128_Info_program=end_program();
#line 505 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  CAST128_Info_program_fun_num=add_program_constant("CAST128_Info",CAST128_Info_program,0);

#endif /* class_CAST128_Info_defined */

#ifdef class_CAST128_State_defined

#ifdef PROG_CAST128_STATE_ID
#line 523 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  START_NEW_PROGRAM_ID(CAST128_STATE);
#else
#line 523 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  start_new_program();

#endif /* PROG_CAST128_STATE_ID */

#ifndef tObjImpl_CAST128_STATE

#undef tObjImpl_CAST128_STATE
#define tObjImpl_CAST128_STATE tObj

#endif /* tObjImpl_CAST128_STATE */

#ifdef THIS_CAST128_STATE

  CAST128_State_storage_offset=ADD_STORAGE(struct CAST128_State_struct);

#endif /* THIS_CAST128_STATE */

#ifdef inherit_CAST128_Info_CAST128_State_defined
#line 525 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  low_inherit(CAST128_Info_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_CAST128_Info_CAST128_State_defined */

#ifdef inherit_CipherState_CAST128_State_defined
#line 526 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  low_inherit(CipherState_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_CipherState_CAST128_State_defined */

#ifdef CAST128_State_event_handler_defined
  pike_set_prog_event_callback(CAST128_State_event_handler);

#endif /* CAST128_State_event_handler_defined */
#line 523 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  CAST128_State_program=end_program();
#line 523 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  CAST128_State_program_fun_num=add_program_constant("CAST128_State",CAST128_State_program,0);

#endif /* class_CAST128_State_defined */

#ifdef class_DES_Info_defined

#ifdef PROG_DES_INFO_ID
#line 580 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  START_NEW_PROGRAM_ID(DES_INFO);
#else
#line 580 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  start_new_program();

#endif /* PROG_DES_INFO_ID */

#ifndef tObjImpl_DES_INFO

#undef tObjImpl_DES_INFO
#define tObjImpl_DES_INFO tObj

#endif /* tObjImpl_DES_INFO */

#ifdef THIS_DES_INFO

  DES_Info_storage_offset=ADD_STORAGE(struct DES_Info_struct);

#endif /* THIS_DES_INFO */

#ifdef DES_Info_event_handler_defined
  pike_set_prog_event_callback(DES_Info_event_handler);

#endif /* DES_Info_event_handler_defined */

#ifdef f_DES_Info_fix_parity_defined
  f_DES_Info_fix_parity_fun_num =
#line 597 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    ADD_FUNCTION2("fix_parity", f_DES_Info_fix_parity, tFunc(tString,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_DES_Info_fix_parity_defined */
#line 580 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  DES_Info_program=end_program();
#line 580 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  DES_Info_program_fun_num=add_program_constant("DES_Info",DES_Info_program,0);

#endif /* class_DES_Info_defined */

#ifdef class_DES_State_defined

#ifdef PROG_DES_STATE_ID
#line 627 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  START_NEW_PROGRAM_ID(DES_STATE);
#else
#line 627 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  start_new_program();

#endif /* PROG_DES_STATE_ID */

#ifndef tObjImpl_DES_STATE

#undef tObjImpl_DES_STATE
#define tObjImpl_DES_STATE tObj

#endif /* tObjImpl_DES_STATE */

#ifdef THIS_DES_STATE

  DES_State_storage_offset=ADD_STORAGE(struct DES_State_struct);

#endif /* THIS_DES_STATE */

#ifdef inherit_DES_Info_DES_State_defined
#line 629 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  low_inherit(DES_Info_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_DES_Info_DES_State_defined */

#ifdef inherit_CipherState_DES_State_defined
#line 630 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  low_inherit(CipherState_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_CipherState_DES_State_defined */

#ifdef DES_State_event_handler_defined
  pike_set_prog_event_callback(DES_State_event_handler);

#endif /* DES_State_event_handler_defined */

#ifdef f_DES_State_make_key_defined
  f_DES_State_make_key_fun_num =
#line 643 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    ADD_FUNCTION2("make_key", f_DES_State_make_key, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_DES_State_make_key_defined */
#line 627 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  DES_State_program=end_program();
#line 627 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  DES_State_program_fun_num=add_program_constant("DES_State",DES_State_program,0);

#endif /* class_DES_State_defined */

#ifdef class_DES3_Info_defined

#ifdef PROG_DES3_INFO_ID
#line 754 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  START_NEW_PROGRAM_ID(DES3_INFO);
#else
#line 754 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  start_new_program();

#endif /* PROG_DES3_INFO_ID */

#ifndef tObjImpl_DES3_INFO

#undef tObjImpl_DES3_INFO
#define tObjImpl_DES3_INFO tObj

#endif /* tObjImpl_DES3_INFO */

#ifdef THIS_DES3_INFO

  DES3_Info_storage_offset=ADD_STORAGE(struct DES3_Info_struct);

#endif /* THIS_DES3_INFO */

#ifdef DES3_Info_event_handler_defined
  pike_set_prog_event_callback(DES3_Info_event_handler);

#endif /* DES3_Info_event_handler_defined */

#ifdef f_DES3_Info_fix_parity_defined
  f_DES3_Info_fix_parity_fun_num =
#line 771 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    ADD_FUNCTION2("fix_parity", f_DES3_Info_fix_parity, tFunc(tString,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_DES3_Info_fix_parity_defined */
#line 754 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  DES3_Info_program=end_program();
#line 754 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  DES3_Info_program_fun_num=add_program_constant("DES3_Info",DES3_Info_program,0);

#endif /* class_DES3_Info_defined */

#ifdef class_DES3_State_defined

#ifdef PROG_DES3_STATE_ID
#line 808 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  START_NEW_PROGRAM_ID(DES3_STATE);
#else
#line 808 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  start_new_program();

#endif /* PROG_DES3_STATE_ID */

#ifndef tObjImpl_DES3_STATE

#undef tObjImpl_DES3_STATE
#define tObjImpl_DES3_STATE tObj

#endif /* tObjImpl_DES3_STATE */

#ifdef THIS_DES3_STATE

  DES3_State_storage_offset=ADD_STORAGE(struct DES3_State_struct);

#endif /* THIS_DES3_STATE */

#ifdef inherit_DES3_Info_DES3_State_defined
#line 810 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  low_inherit(DES3_Info_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_DES3_Info_DES3_State_defined */

#ifdef inherit_CipherState_DES3_State_defined
#line 811 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  low_inherit(CipherState_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_CipherState_DES3_State_defined */

#ifdef DES3_State_event_handler_defined
  pike_set_prog_event_callback(DES3_State_event_handler);

#endif /* DES3_State_event_handler_defined */

#ifdef f_DES3_State_make_key_defined
  f_DES3_State_make_key_fun_num =
#line 824 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    ADD_FUNCTION2("make_key", f_DES3_State_make_key, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_DES3_State_make_key_defined */
#line 808 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  DES3_State_program=end_program();
#line 808 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  DES3_State_program_fun_num=add_program_constant("DES3_State",DES3_State_program,0);

#endif /* class_DES3_State_defined */

#ifdef class_Serpent_Info_defined

#ifdef PROG_SERPENT_INFO_ID
#line 864 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  START_NEW_PROGRAM_ID(SERPENT_INFO);
#else
#line 864 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  start_new_program();

#endif /* PROG_SERPENT_INFO_ID */

#ifndef tObjImpl_SERPENT_INFO

#undef tObjImpl_SERPENT_INFO
#define tObjImpl_SERPENT_INFO tObj

#endif /* tObjImpl_SERPENT_INFO */

#ifdef THIS_SERPENT_INFO

  Serpent_Info_storage_offset=ADD_STORAGE(struct Serpent_Info_struct);

#endif /* THIS_SERPENT_INFO */

#ifdef Serpent_Info_event_handler_defined
  pike_set_prog_event_callback(Serpent_Info_event_handler);

#endif /* Serpent_Info_event_handler_defined */
#line 864 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  Serpent_Info_program=end_program();
#line 864 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  Serpent_Info_program_fun_num=add_program_constant("Serpent_Info",Serpent_Info_program,0);

#endif /* class_Serpent_Info_defined */

#ifdef class_Serpent_State_defined

#ifdef PROG_SERPENT_STATE_ID
#line 882 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  START_NEW_PROGRAM_ID(SERPENT_STATE);
#else
#line 882 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  start_new_program();

#endif /* PROG_SERPENT_STATE_ID */

#ifndef tObjImpl_SERPENT_STATE

#undef tObjImpl_SERPENT_STATE
#define tObjImpl_SERPENT_STATE tObj

#endif /* tObjImpl_SERPENT_STATE */

#ifdef THIS_SERPENT_STATE

  Serpent_State_storage_offset=ADD_STORAGE(struct Serpent_State_struct);

#endif /* THIS_SERPENT_STATE */

#ifdef inherit_Serpent_Info_Serpent_State_defined
#line 884 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  low_inherit(Serpent_Info_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_Serpent_Info_Serpent_State_defined */

#ifdef inherit_CipherState_Serpent_State_defined
#line 885 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  low_inherit(CipherState_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_CipherState_Serpent_State_defined */

#ifdef Serpent_State_event_handler_defined
  pike_set_prog_event_callback(Serpent_State_event_handler);

#endif /* Serpent_State_event_handler_defined */
#line 882 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  Serpent_State_program=end_program();
#line 882 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  Serpent_State_program_fun_num=add_program_constant("Serpent_State",Serpent_State_program,0);

#endif /* class_Serpent_State_defined */

#ifdef class_Twofish_Info_defined

#ifdef PROG_TWOFISH_INFO_ID
#line 918 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  START_NEW_PROGRAM_ID(TWOFISH_INFO);
#else
#line 918 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  start_new_program();

#endif /* PROG_TWOFISH_INFO_ID */

#ifndef tObjImpl_TWOFISH_INFO

#undef tObjImpl_TWOFISH_INFO
#define tObjImpl_TWOFISH_INFO tObj

#endif /* tObjImpl_TWOFISH_INFO */

#ifdef THIS_TWOFISH_INFO

  Twofish_Info_storage_offset=ADD_STORAGE(struct Twofish_Info_struct);

#endif /* THIS_TWOFISH_INFO */

#ifdef Twofish_Info_event_handler_defined
  pike_set_prog_event_callback(Twofish_Info_event_handler);

#endif /* Twofish_Info_event_handler_defined */
#line 918 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  Twofish_Info_program=end_program();
#line 918 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  Twofish_Info_program_fun_num=add_program_constant("Twofish_Info",Twofish_Info_program,0);

#endif /* class_Twofish_Info_defined */

#ifdef class_Twofish_State_defined

#ifdef PROG_TWOFISH_STATE_ID
#line 936 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  START_NEW_PROGRAM_ID(TWOFISH_STATE);
#else
#line 936 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  start_new_program();

#endif /* PROG_TWOFISH_STATE_ID */

#ifndef tObjImpl_TWOFISH_STATE

#undef tObjImpl_TWOFISH_STATE
#define tObjImpl_TWOFISH_STATE tObj

#endif /* tObjImpl_TWOFISH_STATE */

#ifdef THIS_TWOFISH_STATE

  Twofish_State_storage_offset=ADD_STORAGE(struct Twofish_State_struct);

#endif /* THIS_TWOFISH_STATE */

#ifdef inherit_Twofish_Info_Twofish_State_defined
#line 938 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  low_inherit(Twofish_Info_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_Twofish_Info_Twofish_State_defined */

#ifdef inherit_CipherState_Twofish_State_defined
#line 939 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  low_inherit(CipherState_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_CipherState_Twofish_State_defined */

#ifdef Twofish_State_event_handler_defined
  pike_set_prog_event_callback(Twofish_State_event_handler);

#endif /* Twofish_State_event_handler_defined */
#line 936 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  Twofish_State_program=end_program();
#line 936 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  Twofish_State_program_fun_num=add_program_constant("Twofish_State",Twofish_State_program,0);

#endif /* class_Twofish_State_defined */

#ifdef class_IDEA_Info_defined

#ifdef PROG_IDEA_INFO_ID
#line 986 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  START_NEW_PROGRAM_ID(IDEA_INFO);
#else
#line 986 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  start_new_program();

#endif /* PROG_IDEA_INFO_ID */

#ifndef tObjImpl_IDEA_INFO

#undef tObjImpl_IDEA_INFO
#define tObjImpl_IDEA_INFO tObj

#endif /* tObjImpl_IDEA_INFO */

#ifdef THIS_IDEA_INFO

  IDEA_Info_storage_offset=ADD_STORAGE(struct IDEA_Info_struct);

#endif /* THIS_IDEA_INFO */

#ifdef IDEA_Info_event_handler_defined
  pike_set_prog_event_callback(IDEA_Info_event_handler);

#endif /* IDEA_Info_event_handler_defined */
#line 986 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  IDEA_Info_program=end_program();
#line 986 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  IDEA_Info_program_fun_num=add_program_constant("IDEA_Info",IDEA_Info_program,0);

#endif /* class_IDEA_Info_defined */

#ifdef class_IDEA_State_defined

#ifdef PROG_IDEA_STATE_ID
#line 1004 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  START_NEW_PROGRAM_ID(IDEA_STATE);
#else
#line 1004 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  start_new_program();

#endif /* PROG_IDEA_STATE_ID */

#ifndef tObjImpl_IDEA_STATE

#undef tObjImpl_IDEA_STATE
#define tObjImpl_IDEA_STATE tObj

#endif /* tObjImpl_IDEA_STATE */

#ifdef THIS_IDEA_STATE

  IDEA_State_storage_offset=ADD_STORAGE(struct IDEA_State_struct);

#endif /* THIS_IDEA_STATE */

#ifdef inherit_IDEA_Info_IDEA_State_defined
#line 1006 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  low_inherit(IDEA_Info_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_IDEA_Info_IDEA_State_defined */

#ifdef inherit_CipherState_IDEA_State_defined
#line 1007 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  low_inherit(CipherState_program, NULL, -1, 0, 0, NULL);
#endif /* inherit_CipherState_IDEA_State_defined */

#ifdef IDEA_State_event_handler_defined
  pike_set_prog_event_callback(IDEA_State_event_handler);

#endif /* IDEA_State_event_handler_defined */
#line 1004 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  IDEA_State_program=end_program();
#line 1004 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
  IDEA_State_program_fun_num=add_program_constant("IDEA_State",IDEA_State_program,0);

#endif /* class_IDEA_State_defined */
#line 1027 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
;
}

void
cipher_exit(void)
{
  
#ifdef class_CipherInfo_defined
  if(CipherInfo_program) {
#line 92 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    free_program(CipherInfo_program);
    CipherInfo_program=0;
  }

#endif /* class_CipherInfo_defined */

#ifdef class_CipherState_defined
  if(CipherState_program) {
#line 165 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    free_program(CipherState_program);
    CipherState_program=0;
  }

#endif /* class_CipherState_defined */

#ifdef class_AES_Info_defined
  if(AES_Info_program) {
#line 339 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    free_program(AES_Info_program);
    AES_Info_program=0;
  }

#endif /* class_AES_Info_defined */

#ifdef class_AES_State_defined
  if(AES_State_program) {
#line 357 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    free_program(AES_State_program);
    AES_State_program=0;
  }

#endif /* class_AES_State_defined */

#ifdef class_ARCFOUR_Info_defined
  if(ARCFOUR_Info_program) {
#line 396 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    free_program(ARCFOUR_Info_program);
    ARCFOUR_Info_program=0;
  }

#endif /* class_ARCFOUR_Info_defined */

#ifdef class_ARCFOUR_State_defined
  if(ARCFOUR_State_program) {
#line 414 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    free_program(ARCFOUR_State_program);
    ARCFOUR_State_program=0;
  }

#endif /* class_ARCFOUR_State_defined */

#ifdef class_BLOWFISH_Info_defined
  if(BLOWFISH_Info_program) {
#line 451 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    free_program(BLOWFISH_Info_program);
    BLOWFISH_Info_program=0;
  }

#endif /* class_BLOWFISH_Info_defined */

#ifdef class_BLOWFISH_State_defined
  if(BLOWFISH_State_program) {
#line 469 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    free_program(BLOWFISH_State_program);
    BLOWFISH_State_program=0;
  }

#endif /* class_BLOWFISH_State_defined */

#ifdef class_CAST128_Info_defined
  if(CAST128_Info_program) {
#line 505 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    free_program(CAST128_Info_program);
    CAST128_Info_program=0;
  }

#endif /* class_CAST128_Info_defined */

#ifdef class_CAST128_State_defined
  if(CAST128_State_program) {
#line 523 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    free_program(CAST128_State_program);
    CAST128_State_program=0;
  }

#endif /* class_CAST128_State_defined */

#ifdef class_DES_Info_defined
  if(DES_Info_program) {
#line 580 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    free_program(DES_Info_program);
    DES_Info_program=0;
  }

#endif /* class_DES_Info_defined */

#ifdef class_DES_State_defined
  if(DES_State_program) {
#line 627 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    free_program(DES_State_program);
    DES_State_program=0;
  }

#endif /* class_DES_State_defined */

#ifdef class_DES3_Info_defined
  if(DES3_Info_program) {
#line 754 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    free_program(DES3_Info_program);
    DES3_Info_program=0;
  }

#endif /* class_DES3_Info_defined */

#ifdef class_DES3_State_defined
  if(DES3_State_program) {
#line 808 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    free_program(DES3_State_program);
    DES3_State_program=0;
  }

#endif /* class_DES3_State_defined */

#ifdef class_Serpent_Info_defined
  if(Serpent_Info_program) {
#line 864 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    free_program(Serpent_Info_program);
    Serpent_Info_program=0;
  }

#endif /* class_Serpent_Info_defined */

#ifdef class_Serpent_State_defined
  if(Serpent_State_program) {
#line 882 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    free_program(Serpent_State_program);
    Serpent_State_program=0;
  }

#endif /* class_Serpent_State_defined */

#ifdef class_Twofish_Info_defined
  if(Twofish_Info_program) {
#line 918 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    free_program(Twofish_Info_program);
    Twofish_Info_program=0;
  }

#endif /* class_Twofish_Info_defined */

#ifdef class_Twofish_State_defined
  if(Twofish_State_program) {
#line 936 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    free_program(Twofish_State_program);
    Twofish_State_program=0;
  }

#endif /* class_Twofish_State_defined */

#ifdef class_IDEA_Info_defined
  if(IDEA_Info_program) {
#line 986 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    free_program(IDEA_Info_program);
    IDEA_Info_program=0;
  }

#endif /* class_IDEA_Info_defined */

#ifdef class_IDEA_State_defined
  if(IDEA_State_program) {
#line 1004 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
    free_program(IDEA_State_program);
    IDEA_State_program=0;
  }

#endif /* class_IDEA_State_defined */
#line 1033 "/tmp/pikedeb.7ceda5aea7/7.6/src/post_modules/Nettle/cipher.cmod"
;
}

#endif /* HAVE_LIBNETTLE */

