#line 1 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
/* -*- c -*-
|| This file is part of Pike. For copyright information see COPYRIGHT.
|| Pike is distributed under GPL, LGPL and MPL. See the file COPYING
|| for more information.
|| $Id: mpq.cmod,v 1.16 2003/03/28 23:54:24 mast Exp $
*/

#include "global.h"
RCSID("$Id: mpq.cmod,v 1.16 2003/03/28 23:54:24 mast Exp $");
#include "gmp_machine.h"

#if defined(HAVE_GMP2_GMP_H) && defined(HAVE_LIBGMP2)
#define USE_GMP2
#else /* !HAVE_GMP2_GMP_H || !HAVE_LIBGMP2 */
#if defined(HAVE_GMP_H) && defined(HAVE_LIBGMP)
#define USE_GMP
#endif /* HAVE_GMP_H && HAVE_LIBGMP */
#endif /* HAVE_GMP2_GMP_H && HAVE_LIBGMP2 */

#if defined(USE_GMP) || defined(USE_GMP2)

#include "interpret.h"
#include "svalue.h"
#include "stralloc.h"
#include "array.h"
#include "pike_macros.h"
#include "program.h"
#include "stralloc.h"
#include "object.h"
#include "pike_types.h"
#include "pike_error.h"
#include "builtin_functions.h"
#include "opcodes.h"
#include "module_support.h"
#include "bignum.h"
#include "operators.h"
#include "mapping.h"

#include "my_gmp.h"

#include <limits.h>
#include <math.h>


#define sp Pike_sp
#define fp Pike_fp

#define THISMPQ (&(THIS->n))

#define PUSH_REDUCED(o) push_object(o)

/*  id PROG_GMP_MPQ_ID; */

#undef class_mpq_defined
#define class_mpq_defined
struct program *mpq_program=0;

#undef var_n_mpq_defined
#define var_n_mpq_defined

#undef THIS
#define THIS ((struct mpq_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_MPQ
#define THIS_MPQ ((struct mpq_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_MPQ
#define OBJ2_MPQ(o) ((struct mpq_struct *)(o->storage+mpq_storage_offset))

#undef GET_MPQ_STORAGE
#define GET_MPQ_STORAGE ((struct mpq_struct *)(o->storage+mpq_storage_offset)
static ptrdiff_t mpq_storage_offset;
struct mpq_struct {

#ifdef var_n_mpq_defined
#line 55 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
MP_RAT n;
#endif /* var_n_mpq_defined */
};
#line 57 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
static void get_mpq_from_digits(MP_RAT *tmp,
				  struct pike_string *digits,
				  int base)
    {
      p_wchar0 *str;
  
      if(digits->size_shift)
	Pike_error("Illegal characters, cannot convert to Mpq.\n");
      str=STR0(digits);
      
      get_mpz_from_digits(mpq_numref(tmp), digits, base);
      
      if(!base || ((base >= 2) && (base <= 36)))
      {
	int offset = 0;
	int neg = 0;
	int dotfound = 0;
	
	if(digits->len > 1)
	{
	  if(str[0] == '+')
	    offset ++;
	  else if(str[0] == '-')
	  {
	    offset ++;
	    neg = 1;
	  }
	  
	  /* We need to fix the case with binary
	     0b101... and -0b101... numbers. */
	  if(!base && digits->len > 2)
	  {
	    if(str[offset] == '0')
	    {
	      switch(str[offset+1])
	      {
		case 'b':
		case 'B':
		  offset+=2;
		  base=2;
		  break;
		  
		case '0':
		  offset+=2;
		  base=8;
		  break;
		  
		case 'x':
		  offset+=2;
		  base=16;
		  break;
	      }
	    }
	  }
	}

	if(!base) base=10;
	
	mpq_set_ui(tmp, 0, 1);
	while(str[offset])
	{
	  int x=255;
	  if(str[offset] == '.')
	  {
	    offset++;
	    if(dotfound)
	      Pike_error("Invalid digits, cannot convert to mpq.\n");
	    dotfound++;
	    continue;
	  }
	  
	  if(str[offset] >= '0' && str[offset] <= '9')
	    x=str[offset]-'0';
	  else if(str[offset] >='a' && str[offset] <= 'z')
	    x=str[offset]-'a';
	  else if(str[offset] >='A' && str[offset] <= 'Z')
	    x=str[offset]-'A';
	  
	  if(x > base)
	    Pike_error("Invalid digits, cannot convert to mpq.\n");
	  
	  mpz_mul_ui(mpq_numref(tmp),
		     mpq_numref(tmp),
		     base);
	  if(dotfound)
	  {
	    mpz_mul_ui(mpq_denref(tmp),
		       mpq_denref(tmp),
		       base);
	  }
	  mpz_add_ui(mpq_numref(tmp),
		     mpq_numref(tmp),
		     x);
	  offset++;
	}

	if(dotfound)
	  mpq_canonicalize(tmp);

	if(neg)
	  mpz_neg(mpq_numref(tmp), mpq_numref(tmp));
      }
      else if(base == 256)
      {
	mpq_set_ui(tmp, 1, 1);
	get_mpz_from_digits(mpq_numref(tmp), digits, base);
      }
      else
      {
	Pike_error("invalid base.\n");
      }
    }

  static void get_new_mpq(MP_RAT *tmp, struct svalue *s)
    {
      switch(s->type)
      {
	case T_FLOAT:
	{
	  double t;
	  int y;
	  t=FREXP((double) s->u.float_number, &y);

	  t*=pow(2.0,48.0);
	  y-=48;

	  mpz_set_d(mpq_numref(tmp), t);
	  mpz_set_ui(mpq_denref(tmp), 1);
	  if(y>0)
	    mpz_mul_2exp(mpq_numref(tmp),mpq_numref(tmp),y);
	  else if(y<0)
	    mpz_mul_2exp(mpq_denref(tmp),mpq_denref(tmp),-y);

	  mpq_canonicalize(tmp);
	  break;
	}
	  
	case T_INT:
	  get_new_mpz(mpq_numref(tmp), s);
	  mpz_set_si(mpq_denref(tmp),1);
	  break;
	  
	case T_OBJECT:
	  if(s->u.object->prog == mpzmod_program)
	  {
	    mpq_set_z(tmp, OBTOMPZ(s->u.object));
	    break;
	  }
	  
	  if(s->u.object->prog == mpq_program)
	  {
	    mpq_set(tmp, OBTOMPQ(s->u.object));
	    break;
	  }
	  
	  if (s->u.object->prog) {
	    Pike_error("Wrong type of object (id:%d), cannot convert to mpq.\n",
		       s->u.object->prog->id);
	  } else {
	    /* Destructed object. Use as zero. */
	    mpq_set_si(tmp, 0, 1);
	  }
	  break;
	  
	default:
	  Pike_error("cannot convert argument to mpq.\n");
      }
    }
  
  #define f_mpq_create_defined
void f_mpq_create(INT32 args) {
#line 226 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
struct svalue * x;
#line 226 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
struct svalue * base;
#line 226 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if(args > 2) wrong_number_of_args_error("create",args,2);
if(args > 0) { 
#line 226 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
x=Pike_sp+0-args; dmalloc_touch_svalue(Pike_sp+0-args);
}else{
x=0;
}if(args > 1) { 
#line 226 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
base=Pike_sp+1-args; dmalloc_touch_svalue(Pike_sp+1-args);
}else{
base=0;
}{
    switch(args)
    {
      case 1:
	if(sp[-args].type == T_STRING)
	  get_mpq_from_digits(THISMPQ, sp[-args].u.string, 0);
	else
	  get_new_mpq(THISMPQ, sp-args);
	break;
	
      case 2:
	/* Args are string of digits and integer base */
	/* or int num / den */
	
	if (sp[1-args].type != T_INT)
	  Pike_error("Bad arg 2 for Gmp.mpq(), expected integer.\n");

	switch(sp[-args].type)
	{
	  default:
	    Pike_error("bad argument 1 for Gmp.Mpq()\n");

	  case T_STRING:
	    get_mpq_from_digits(THISMPQ, sp[-args].u.string, sp[1-args].u.integer);
	    break;

	  case T_INT:
	    mpq_set_num(THISMPQ,get_mpz(sp-args,1));
	    mpq_set_den(THISMPQ,get_mpz(sp-args+1,1));
	    mpq_canonicalize(THISMPQ);
	    break;
	}
	break;
	
      default:
	Pike_error("Too many arguments to Mpq->create()\n");
	
      case 0:
	break;	/* Needed by AIX cc */
    }
  }
  
  }
#define f_mpq_get_int_defined
void f_mpq_get_int(INT32 args) {
#line 271 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if(args != 0) wrong_number_of_args_error("get_int",args,0);
{
      struct object *res = fast_clone_object(mpzmod_program, 0);
      mpz_tdiv_q(OBTOMPZ(res), mpq_numref(THISMPQ), mpq_denref(THISMPQ));
      /* FIXME */
#ifdef AUTO_BIGNUM
      mpzmod_reduce(res);
#else
      free_object(res);
      push_int(mpz_get_si(OBTOMPZ(res)));
#endif /* AUTO_BIGNUM */
    }

  }
#define f_mpq_cq___hash_defined
void f_mpq_cq___hash(INT32 args) {
#line 284 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if(args != 0) wrong_number_of_args_error("__hash",args,0);
#line 286 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
{
      do { INT_TYPE ret_=(
#line 288 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
mpz_get_si(mpq_numref(THISMPQ)) * 1000003 +
	mpz_get_si(mpq_denref(THISMPQ)));  push_int(ret_); return; }while(0);
#line 290 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
}

  }
#define f_mpq_get_float_defined
void f_mpq_get_float(INT32 args) {
#line 292 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if(args != 0) wrong_number_of_args_error("get_float",args,0);
{
      do { FLOAT_TYPE ret_=((FLOAT_TYPE) mpq_get_d(THISMPQ));  push_float(ret_); return; }while(0);
#line 295 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
}


  }
#define f_mpq_get_string_defined
void f_mpq_get_string(INT32 args) {
#line 298 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if(args != 0) wrong_number_of_args_error("get_string",args,0);
{
      push_string(low_get_mpz_digits(mpq_numref(THISMPQ),10));
      push_constant_text("/");
      push_string(low_get_mpz_digits(mpq_denref(THISMPQ),10));
      f_add(3);
    }

  }
#line 306 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
static int lookup(char *name,
		    struct mapping *m,
		    char *ind,
		    int def)
    {
      struct svalue *sv;
      if((sv=simple_mapping_string_lookup(m,ind)))
      {
	if(sv->type == T_INT)
	{
	  return sv->u.integer;
	}else{
	  Pike_error("\"%s\" argument to %s is not an integer.\n",ind,name);

	}
      }
      return def;
    }
		    

  #define f_mpq_cq__sprintf_defined
void f_mpq_cq__sprintf(INT32 args) {
#line 326 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
INT_TYPE c;
#line 326 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
struct mapping * flags;
#line 326 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if(args != 2) wrong_number_of_args_error("_sprintf",args,2);
#line 326 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if(Pike_sp[0-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("_sprintf",1,"int");
c=Pike_sp[0-2].u.integer;
#line 326 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if(Pike_sp[1-2].type != PIKE_T_MAPPING) SIMPLE_BAD_ARG_ERROR("_sprintf",2,"mapping(mixed:mixed)");
#line 326 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
debug_malloc_pass(flags=Pike_sp[1-2].u.mapping);
#line 328 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
{
      INT_TYPE precision, width, base = 0, mask_shift = 0;
      struct pike_string *s = 0;
      INT_TYPE flag_left;

      precision=lookup("Gmp.Mpq->_sprintf",flags,"precision",7);
      width=lookup("Gmp.Mpq->_sprintf",flags,"width",-1);
      flag_left=lookup("Gmp.Mpq->_sprintf",flags,"flag_left",0);
      pop_n_elems(args);
      if(precision<0) precision=0;
      
      switch(c)
      {
	default:
	  push_undefined();
	  return;

	case 'O':
	  f_mpq_get_string(0);
	  return;

	  /* Fixme: Support g/e/E */
	case 'g':
	case 'e':
	case 'E':
	case 'f':
	{
	  mpz_t tmp;
	  ptrdiff_t len;
	  base=10;

	  mpz_init(tmp);
	  mpz_ui_pow_ui(tmp, 10, precision);
	  mpz_mul(tmp, tmp, mpq_numref(THISMPQ));
	  mpz_tdiv_q(tmp, tmp, mpq_denref(THISMPQ));
	  /* one for the pot... */
	  precision++;
	  /* present 'tmp' and insert dot */
	  len = mpz_sizeinbase(tmp, base) + 3;
	  s = begin_shared_string(len);
	  if(len/2 > precision)
	  {
	    mpz_get_str(s->str+1, base, tmp);
	    /* Find NULL character */
	    len-=4;
	    if (len < 1) len = 1;
	    while(s->str[len]) len++;
	    MEMMOVE(s->str, s->str+1, len-precision);
	  }else{
	    mpz_get_str(s->str, base, tmp);
	    /* Find NULL character */
	    len-=5;
	    if (len < 0) len = 0;
	    while(s->str[len]) len++;
	    MEMMOVE(s->str+len-precision+1,
		    s->str+len-precision,
		    precision+1);
	    len++;
	  }
	  mpz_clear(tmp);
	  s->str[len-precision]='.';
	  push_string(end_and_resize_shared_string(s, len));
	}
      }
    }
  

  }
#define f_mpq_cq__is_type_defined
void f_mpq_cq__is_type(INT32 args) {
#line 395 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
struct pike_string * arg;
#line 395 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("_is_type",args,1);
#line 395 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("_is_type",1,"string");
#line 395 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
debug_malloc_pass(arg=Pike_sp[0-1].u.string);
#line 397 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
{
      push_constant_text("float");
      f_eq(2);
    }
  
  }
#define f_mpq_cast_defined
void f_mpq_cast(INT32 args) {
#line 402 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
struct pike_string * s;
#line 402 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("cast",args,1);
#line 402 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("cast",1,"string");
#line 402 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
debug_malloc_pass(s=Pike_sp[0-1].u.string);
#line 404 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
{
      add_ref(s);
      
      pop_n_elems(args);
      
      switch(s->str[0])
      {
	case 'i':
	  if(!strncmp(s->str, "int", 3))
	  {
	    free_string(s);
	    f_mpq_get_int(0);
	    return;
	  }
	  break;
	  
	case 's':
	  if(!strcmp(s->str, "string"))
	  {
	    free_string(s);
	    f_mpq_get_string(0);
	    return;
	  }
	  break;

	case 'f':
	  if(!strcmp(s->str, "float"))
	  {
	    free_string(s);
	    f_mpq_get_float(0);
	    return;
	  }
	  break;
	  
	case 'o':
	  if(!strcmp(s->str, "object"))
	  {
	    push_object(this_object());
	  }
	  break;
	  
	case 'm':
	  if(!strcmp(s->str, "mixed"))
	  {
	    push_object(this_object());
	  }
	  break;
	  
      }
      
      free_string(s);
      
      Pike_error("mpq->cast() to \"%s\" is other type than string, int or float.\n",
		 s->str);
    }

}
#line 460 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
#ifdef DEBUG_MALLOC
#define get_mpq(X,Y) \
 (debug_get_mpq((X),(Y)),( (X)->type==T_OBJECT? debug_malloc_touch((X)->u.object) :0 ),debug_get_mpq((X),(Y)))
#else
#define get_mpq debug_get_mpq 
#endif

/* Converts an svalue, located on the stack, to an mpq object */
  static MP_RAT *debug_get_mpq(struct svalue *s, int throw_error)
    {
#define MPQ_ERROR(x) if (throw_error) Pike_error(x)
      struct object *o;
      switch(s->type)
      {
	default:
	  MPQ_ERROR("Wrong type of value, cannot convert to mpq.\n");
	  return 0;
	  
	case T_OBJECT:
	  if(s->u.object->prog == mpq_program)
	    return (MP_RAT *)s->u.object->storage;
	  
	  if(!throw_error && 
	     s->u.object->prog != mpzmod_program &&
	     s->u.object->prog)
	    return 0;
	  
	  /* Fall through */
	case T_INT:
	case T_FLOAT:
	  o=fast_clone_object(mpq_program,0);
	  get_new_mpq(OBTOMPQ(o), s);
	  free_svalue(s);
	  s->u.object=o;
	  s->type=T_OBJECT;
	  return (MP_RAT *)o->storage;
      }
    }


  #define f_mpq_cq__backtick_add_defined
void f_mpq_cq__backtick_add(INT32 args) {
#line 500 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
struct svalue * a;
#line 500 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 500 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  } while (++argcnt < args-0);
  a=Pike_sp+0-args;
} else a=0;
#line 502 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
{
      INT32 e;
      struct object *res;
      for(e=0; e<args; e++)
	get_mpq(sp+e-args, 1);
      res = fast_clone_object(mpq_program, 0);
      mpq_set(OBTOMPQ(res), THISMPQ);
      for(e=0;e<args;e++)
	mpq_add(OBTOMPQ(res), OBTOMPQ(res), OBTOMPQ(sp[e-args].u.object));
      
      do { struct object * ret_=(res); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 513 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
}
  
  }
#define f_mpq_cq__backtick_backtick_add_defined
void f_mpq_cq__backtick_backtick_add(INT32 args) {
#line 515 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
struct svalue * a;
#line 515 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 515 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  } while (++argcnt < args-0);
  a=Pike_sp+0-args;
} else a=0;
#line 517 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
{
      INT32 e;
      struct object *res;
      for(e=0; e<args; e++)
	get_mpq(sp+e-args, 1);
      res = fast_clone_object(mpq_program, 0);
      mpq_set(OBTOMPQ(res), THISMPQ);
      for(e=0;e<args;e++)
	mpq_add(OBTOMPQ(res), OBTOMPQ(res), OBTOMPQ(sp[e-args].u.object));
      
      do { struct object * ret_=(res); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 528 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
}

  }
#define f_mpq_cq__backtick_add_eq_defined
void f_mpq_cq__backtick_add_eq(INT32 args) {
#line 530 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
struct svalue * a;
#line 530 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 530 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  } while (++argcnt < args-0);
  a=Pike_sp+0-args;
} else a=0;
#line 532 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
{
    INT32 e;
    for(e=0; e<args; e++)
      get_mpq(sp+e-args, 1);
    for(e=0;e<args;e++)
      mpq_add(THISMPQ, THISMPQ, OBTOMPQ(sp[e-args].u.object));
    
    do { struct object * ret_=(fp->current_object); add_ref(ret_); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 540 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
}
  

}
#line 543 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
#ifdef BIG_PIKE_INT
#define TOOBIGTEST || sp[e-args].u.integer>MAX_INT32
#else
#define TOOBIGTEST 
#endif

  static void mult_convert_args(INT32 args)
    {
      INT32 e;
      for(e=0; e<args; e++)
      {
	if(sp[e-args].type == T_OBJECT)
	{
	  if(sp[e-args].u.object->prog == mpzmod_program)
	    continue;
#ifdef AUTO_BIGNUM
	  if(sp[e-args].u.object->prog == bignum_program)
	    continue;
#endif
	}
	
	if(sp[e-args].type != T_INT || sp[e-args].u.integer<=0 TOOBIGTEST)
	  get_mpq(sp+e-args, 1);
      }
    }
  
  static void mult_args(MP_RAT *res,
			INT32 e,
			INT32 args)
    {
      int norm=0;
      for(;e<args;e++)
      {
	if(sp[e-args].type == T_INT)
	{
	  mpz_mul_ui(mpq_numref(res),
		      mpq_numref(res),
		      sp[e-args].u.integer);
	  norm++;
	}
	else if(sp[e-args].u.object->prog == mpq_program)
	{
	  mpq_mul(res, res, OBTOMPQ(sp[e-args].u.object));
	}else{
	  norm++;
	  mpz_mul(mpq_numref(res),
		   mpq_numref(res),
		   OBTOMPZ(sp[e-args].u.object));
	}
      }
      
      if(norm) mpq_canonicalize(res);
    }
  
  #define f_mpq_cq__backtick_2A_defined
void f_mpq_cq__backtick_2A(INT32 args) {
#line 597 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
struct svalue * a;
#line 597 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 597 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  } while (++argcnt < args-0);
  a=Pike_sp+0-args;
} else a=0;
#line 599 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
{
      struct object *res;
      mult_convert_args(args);
      
      res = fast_clone_object(mpq_program, 0);
      mpq_set(OBTOMPQ(res), THISMPQ);
      mult_args(OBTOMPQ(res), 0,args);
      
      do { struct object * ret_=(res); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 608 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
}

  }
#define f_mpq_cq__backtick_backtick_2A_defined
void f_mpq_cq__backtick_backtick_2A(INT32 args) {
#line 610 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
struct svalue * a;
#line 610 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 610 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  } while (++argcnt < args-0);
  a=Pike_sp+0-args;
} else a=0;
#line 612 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
{
      struct object *res;
      mult_convert_args(args);
      
      res = fast_clone_object(mpq_program, 0);
      mpq_set(OBTOMPQ(res), THISMPQ);
      mult_args(OBTOMPQ(res), 0,args);
      
      do { struct object * ret_=(res); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 621 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
}

  }
#define f_mpq_cq__backtick_2A_eq_defined
void f_mpq_cq__backtick_2A_eq(INT32 args) {
#line 623 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
struct svalue * a;
#line 623 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 623 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  } while (++argcnt < args-0);
  a=Pike_sp+0-args;
} else a=0;
#line 625 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
{
    mult_convert_args(args);
    mult_args(THISMPQ, 0,args);
    do { struct object * ret_=(fp->current_object); add_ref(ret_); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 629 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
}
  
  }
#define f_mpq_cq__backtick_2D_defined
void f_mpq_cq__backtick_2D(INT32 args) {
#line 631 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
struct svalue * a;
#line 631 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 631 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  } while (++argcnt < args-0);
  a=Pike_sp+0-args;
} else a=0;
#line 633 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
{
      INT32 e;
      struct object *res;
      
      if (args)
	for (e = 0; e<args; e++)
	  get_mpq(sp + e - args, 1);
      
      res = fast_clone_object(mpq_program, 0);
      mpq_set(OBTOMPQ(res), THISMPQ);
      
      if(args)
      {
	for(e=0;e<args;e++)
	  mpq_sub(OBTOMPQ(res), OBTOMPQ(res), OBTOMPQ(sp[e-args].u.object));
      }else{
	mpq_neg(OBTOMPQ(res), OBTOMPQ(res));
      }
      
      do { struct object * ret_=(res); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 653 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
}

  }
#define f_mpq_cq__backtick_backtick_2D_defined
void f_mpq_cq__backtick_backtick_2D(INT32 args) {
#line 655 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
struct svalue * sv;
#line 655 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("``-",args,1);
#line 655 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
sv=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 657 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
{
      struct object *res;
      MP_RAT *a=get_mpq(sv,1);
      res = fast_clone_object(mpq_program, 0);
      mpq_sub(OBTOMPQ(res), a, THISMPQ);
      do { struct object * ret_=(res); pop_stack(); push_object(ret_); return; }while(0);
#line 663 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
}
  
  }
#define f_mpq_cq__backtick_2F_defined
void f_mpq_cq__backtick_2F(INT32 args) {
#line 665 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
struct svalue * a;
#line 665 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 665 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  } while (++argcnt < args-0);
  a=Pike_sp+0-args;
} else a=0;
#line 667 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
{
      INT32 e;
      struct object *res;
      
      for(e=0;e<args;e++)
	if (!mpq_sgn(get_mpq(sp+e-args, 1)))
	  Pike_error("Division by zero.\n");
      
      res = fast_clone_object(mpq_program, 0);
      mpq_set(OBTOMPQ(res), THISMPQ);
      for(e=0;e<args;e++)	
	mpq_div(OBTOMPQ(res), OBTOMPQ(res), OBTOMPQ(sp[e-args].u.object));
      
      do { struct object * ret_=(res); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 681 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
}
  
  }
#define f_mpq_cq__backtick_backtick_2F_defined
void f_mpq_cq__backtick_backtick_2F(INT32 args) {
#line 683 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
struct svalue * sv;
#line 683 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("``/",args,1);
#line 683 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
sv=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 685 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
{
      MP_RAT *a;
      struct object *res = NULL;
      if(!mpq_sgn(THISMPQ))
	Pike_error("Division by zero.\n");
      
      a=get_mpq(sv,1);
      
      res=fast_clone_object(mpq_program,0);
      mpq_div(OBTOMPQ(res), a, THISMPQ);
      
      do { struct object * ret_=(res); pop_stack(); push_object(ret_); return; }while(0);
#line 697 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
}

  }
#line 699 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
/* a%b =  a -  floor(a/b)*b */
  #define f_mpq_cq__backtick_25_defined
void f_mpq_cq__backtick_25(INT32 args) {
#line 700 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
struct svalue * a;
#line 700 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 700 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  } while (++argcnt < args-0);
  a=Pike_sp+0-args;
} else a=0;
#line 702 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
{
      INT32 e;
      struct object *res;
      mpq_t tmp;
      
      for(e=0;e<args;e++)
	if (!mpq_sgn(get_mpq(sp+e-args, 1)))
	  Pike_error("Modulo by zero.\n");	
  
      res = fast_clone_object(mpq_program, 0);
      
      mpq_init(tmp);
      mpq_set(OBTOMPQ(res), THISMPQ);
      
      for(e=0;e<args;e++)
      {
	mpz_mul(mpq_numref(tmp),
		mpq_numref(OBTOMPQ(res)),
		mpq_denref(OBTOMPQ(sp[e-args].u.object)));
	
	mpz_tdiv_q(mpq_numref(tmp),
		   mpq_numref(tmp),
		   mpq_denref(tmp));
	
	mpz_tdiv_q(mpq_numref(tmp),
		   mpq_numref(tmp),
		   mpq_numref(OBTOMPQ(sp[e-args].u.object)));
	
	mpz_set_si(mpq_denref(tmp),1);
	
	mpq_mul(tmp, tmp, OBTOMPQ(sp[e-args].u.object));
	mpq_sub(OBTOMPQ(res), OBTOMPQ(res), tmp);
      }
      mpq_clear(tmp);
      
      do { struct object * ret_=(res); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 738 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
}

  }
#define f_mpq_cq__backtick_backtick_25_defined
void f_mpq_cq__backtick_backtick_25(INT32 args) {
#line 740 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
struct svalue * a;
#line 740 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if (args > 0) {
  INT32 argcnt = 0;
  do {
    dmalloc_touch_svalue(Pike_sp+0+argcnt-args);
#line 740 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  } while (++argcnt < args-0);
  a=Pike_sp+0-args;
} else a=0;
#line 742 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
{
      MP_RAT *a;
      
      struct object *res;
      if(!mpq_sgn(THISMPQ))
	Pike_error("Modulo by zero.\n");
      
      if(args!=1)
	Pike_error("Gmp.mpq->``%%() called with more than one argument.\n");
      
      a=get_mpq(sp-1,1);
      
      res=fast_clone_object(mpq_program,0);
      
      mpz_mul(mpq_numref(OBTOMPQ(res)), mpq_numref(a), mpq_denref(THISMPQ));
      
      mpz_tdiv_q(mpq_numref(OBTOMPQ(res)),
		 mpq_numref(OBTOMPQ(res)),
		 mpq_denref(OBTOMPQ(res)));
		 
      mpz_tdiv_q(mpq_numref(OBTOMPQ(res)),
		 mpq_numref(OBTOMPQ(res)),
		 mpq_numref(a));
      
      mpz_set_si(mpq_denref(OBTOMPQ(res)),1);
      
      mpq_mul(OBTOMPQ(res), OBTOMPQ(res), THISMPQ);
      mpq_sub(OBTOMPQ(res), a, OBTOMPQ(res));
      
      do { struct object * ret_=(res); pop_n_elems(args); push_object(ret_); return; }while(0);
#line 772 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
}

  }
#define f_mpq_invert_defined
void f_mpq_invert(INT32 args) {
#line 774 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if(args != 0) wrong_number_of_args_error("invert",args,0);
{
      struct object *res;
      if (!mpq_sgn(THISMPQ))
	Pike_error("divide by zero in mpq->invert\n");
      res = fast_clone_object(mpq_program, 0);
      mpq_inv(OBTOMPQ(res), THISMPQ);
      do { struct object * ret_=(res);  push_object(ret_); return; }while(0);
#line 782 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
}
  
  }
#line 784 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
/* defined as -1-x */
  #define f_mpq_cq__backtick_7E_defined
void f_mpq_cq__backtick_7E(INT32 args) {
#line 785 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if(args != 0) wrong_number_of_args_error("`~",args,0);
#line 787 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
{
      struct object *o;
      o=fast_clone_object(mpq_program,0);
      mpq_set_si(OBTOMPQ(o), -1, 1);
      mpq_sub(OBTOMPQ(o),OBTOMPQ(o), THISMPQ);
      
      do { struct object * ret_=(o);  push_object(ret_); return; }while(0);
#line 794 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
}

  }
#define f_mpq_cq__backtick_3E_defined
void f_mpq_cq__backtick_3E(INT32 args) {
#line 796 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
struct svalue * q;
#line 796 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("`>",args,1);
#line 796 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
q=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 798 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
{
      do { INT_TYPE ret_=(mpq_cmp(THISMPQ, get_mpq(q, 1)) > 0); pop_stack(); push_int(ret_); return; }while(0);
#line 800 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
}

  }
#define f_mpq_cq__backtick_3C_defined
void f_mpq_cq__backtick_3C(INT32 args) {
#line 802 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
struct svalue * q;
#line 802 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("`<",args,1);
#line 802 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
q=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 804 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
{
      do { INT_TYPE ret_=(mpq_cmp(THISMPQ, get_mpq(q, 1)) < 0); pop_stack(); push_int(ret_); return; }while(0);
#line 806 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
}
  
  }
#define f_mpq_cq__backtick_3E_eq_defined
void f_mpq_cq__backtick_3E_eq(INT32 args) {
#line 808 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
struct svalue * q;
#line 808 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("`>=",args,1);
#line 808 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
q=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 810 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
{
    do { INT_TYPE ret_=(mpq_cmp(THISMPQ, get_mpq(q, 1)) >= 0); pop_stack(); push_int(ret_); return; }while(0);
#line 812 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
}
  
  }
#define f_mpq_cq__backtick_3C_eq_defined
void f_mpq_cq__backtick_3C_eq(INT32 args) {
#line 814 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
struct svalue * q;
#line 814 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("`<=",args,1);
#line 814 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
q=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 816 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
{
    do { INT_TYPE ret_=(mpq_cmp(THISMPQ, get_mpq(q, 1)) <= 0); pop_stack(); push_int(ret_); return; }while(0);
#line 818 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
}


  }
#define f_mpq_cq__backtick_eq_eq_defined
void f_mpq_cq__backtick_eq_eq(INT32 args) {
#line 821 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
struct svalue * q;
#line 821 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("`==",args,1);
#line 821 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
q=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 823 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
{
    MP_RAT *arg=get_mpq(q, 0);
    do { INT_TYPE ret_=(arg && !mpq_cmp(THISMPQ, arg)); pop_stack(); push_int(ret_); return; }while(0);
#line 826 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
}

  }
#define f_mpq_cq__backtick_21_eq_defined
void f_mpq_cq__backtick_21_eq(INT32 args) {
#line 828 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
struct svalue * q;
#line 828 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if(args != 1) wrong_number_of_args_error("`!=",args,1);
#line 828 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
q=Pike_sp+0-1; dmalloc_touch_svalue(Pike_sp+0-1);
#line 830 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
{
    MP_RAT *arg=get_mpq(q, 0);
    do { INT_TYPE ret_=(!(arg && !mpq_cmp(THISMPQ, arg))); pop_stack(); push_int(ret_); return; }while(0);
#line 833 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
}

  }
#define f_mpq_sgn_defined
void f_mpq_sgn(INT32 args) {
#line 835 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if(args != 0) wrong_number_of_args_error("sgn",args,0);
{
      do { INT_TYPE ret_=(mpq_sgn(THISMPQ));  push_int(ret_); return; }while(0);
#line 838 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
}

  }
#define f_mpq_cq__backtick_21_defined
void f_mpq_cq__backtick_21(INT32 args) {
#line 840 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
if(args != 0) wrong_number_of_args_error("`!",args,0);
#line 842 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
{
      do { INT_TYPE ret_=(!mpq_sgn(THISMPQ));  push_int(ret_); return; }while(0);
#line 844 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
}

  }

#undef internal_init_mpq_defined
#define internal_init_mpq_defined

#undef mpq_event_handler_defined
#define mpq_event_handler_defined
static void init_mpq_struct(void)
#line 847 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
{
#ifdef PIKE_DEBUG
      if(!fp) Pike_fatal("ZERO FP\n");
      if(!THISMPQ) Pike_fatal("ZERO THISMPQ\n");
#endif
      mpq_init(THISMPQ);
    }
  
  
#undef internal_exit_mpq_defined
#define internal_exit_mpq_defined

#undef mpq_event_handler_defined
#define mpq_event_handler_defined
static void exit_mpq_struct(void)
#line 856 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
{
#ifdef PIKE_DEBUG
      if(!fp) Pike_fatal("ZERO FP\n");
      if(!THISMPQ) Pike_fatal("ZERO THISMPQ\n");
#endif
      mpq_clear(THISMPQ);
    }
  

#ifdef mpq_event_handler_defined
static void mpq_event_handler(int ev) {
  switch(ev) {

#ifdef internal_init_mpq_defined
  case PROG_EVENT_INIT: init_mpq_struct(); break;

#endif /* internal_init_mpq_defined */

#ifdef internal_exit_mpq_defined
  case PROG_EVENT_EXIT: exit_mpq_struct(); break;

#endif /* internal_exit_mpq_defined */
  default: break; 
  }
}

#endif /* mpq_event_handler_defined */
#line 866 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
#endif /* USE_GMP */


void pike_init_mpq_module(void)
{
  
#ifdef class_mpq_defined

#ifdef PROG_MPQ_ID
  START_NEW_PROGRAM_ID(MPQ);
#else
  start_new_program();

#endif /* PROG_MPQ_ID */

#ifdef THIS_MPQ

  mpq_storage_offset=ADD_STORAGE(struct mpq_struct);

#endif /* THIS_MPQ */

#ifdef mpq_event_handler_defined
  pike_set_prog_event_callback(mpq_event_handler);

#endif /* mpq_event_handler_defined */

#ifdef f_mpq_create_defined
#line 226 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("create", f_mpq_create, tOr3(tFunc(tOr5(tVoid,tString,"\10\200\0\0\0\177\377\377\377",tFloat,tObj),tVoid),tFunc(tString "\10\200\0\0\0\177\377\377\377",tVoid),tFunc("\10\200\0\0\0\177\377\377\377" "\10\200\0\0\0\177\377\377\377",tVoid)), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_create_defined */

#ifdef f_mpq_get_int_defined
#line 271 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("get_int", f_mpq_get_int, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_get_int_defined */

#ifdef f_mpq_cq___hash_defined
#line 284 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("__hash", f_mpq_cq___hash, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq___hash_defined */

#ifdef f_mpq_get_float_defined
#line 292 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("get_float", f_mpq_get_float, tFunc(tNone,tFloat), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_get_float_defined */

#ifdef f_mpq_get_string_defined
#line 298 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("get_string", f_mpq_get_string, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_get_string_defined */

#ifdef f_mpq_cq__sprintf_defined
#line 326 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("_sprintf", f_mpq_cq__sprintf, tFunc("\10\200\0\0\0\177\377\377\377" tMapping,tString), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__sprintf_defined */

#ifdef f_mpq_cq__is_type_defined
#line 395 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("_is_type", f_mpq_cq__is_type, tFunc(tString,tVoid), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__is_type_defined */

#ifdef f_mpq_cast_defined
#line 402 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("cast", f_mpq_cast, tFunc(tString,tVoid), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cast_defined */

#ifdef f_mpq_cq__backtick_add_defined
#line 500 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("`+", f_mpq_cq__backtick_add, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_add_defined */

#ifdef f_mpq_cq__backtick_backtick_add_defined
#line 515 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("``+", f_mpq_cq__backtick_backtick_add, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_backtick_add_defined */

#ifdef f_mpq_cq__backtick_add_eq_defined
#line 530 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("`+=", f_mpq_cq__backtick_add_eq, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_add_eq_defined */

#ifdef f_mpq_cq__backtick_2A_defined
#line 597 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("`*", f_mpq_cq__backtick_2A, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_2A_defined */

#ifdef f_mpq_cq__backtick_backtick_2A_defined
#line 610 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("``*", f_mpq_cq__backtick_backtick_2A, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_backtick_2A_defined */

#ifdef f_mpq_cq__backtick_2A_eq_defined
#line 623 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("`*=", f_mpq_cq__backtick_2A_eq, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_2A_eq_defined */

#ifdef f_mpq_cq__backtick_2D_defined
#line 631 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("`-", f_mpq_cq__backtick_2D, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_2D_defined */

#ifdef f_mpq_cq__backtick_backtick_2D_defined
#line 655 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("``-", f_mpq_cq__backtick_backtick_2D, tFunc(tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_backtick_2D_defined */

#ifdef f_mpq_cq__backtick_2F_defined
#line 665 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("`/", f_mpq_cq__backtick_2F, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_2F_defined */

#ifdef f_mpq_cq__backtick_backtick_2F_defined
#line 683 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("``/", f_mpq_cq__backtick_backtick_2F, tFunc(tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_backtick_2F_defined */

#ifdef f_mpq_cq__backtick_25_defined
#line 700 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("`%", f_mpq_cq__backtick_25, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_25_defined */

#ifdef f_mpq_cq__backtick_backtick_25_defined
#line 740 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("``%", f_mpq_cq__backtick_backtick_25, tFuncV(tNone,tOr3("\10\200\0\0\0\177\377\377\377",tFloat,tObj),tObj), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_backtick_25_defined */

#ifdef f_mpq_invert_defined
#line 774 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("invert", f_mpq_invert, tFunc(tNone,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_invert_defined */

#ifdef f_mpq_cq__backtick_7E_defined
#line 785 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("`~", f_mpq_cq__backtick_7E, tFunc(tNone,tObj), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_7E_defined */

#ifdef f_mpq_cq__backtick_3E_defined
#line 796 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("`>", f_mpq_cq__backtick_3E, tFunc(tMix,"\10\200\0\0\0\177\377\377\377"), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_3E_defined */

#ifdef f_mpq_cq__backtick_3C_defined
#line 802 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("`<", f_mpq_cq__backtick_3C, tFunc(tMix,"\10\200\0\0\0\177\377\377\377"), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_3C_defined */

#ifdef f_mpq_cq__backtick_3E_eq_defined
#line 808 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("`>=", f_mpq_cq__backtick_3E_eq, tFunc(tMix,"\10\200\0\0\0\177\377\377\377"), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_3E_eq_defined */

#ifdef f_mpq_cq__backtick_3C_eq_defined
#line 814 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("`<=", f_mpq_cq__backtick_3C_eq, tFunc(tMix,"\10\200\0\0\0\177\377\377\377"), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_3C_eq_defined */

#ifdef f_mpq_cq__backtick_eq_eq_defined
#line 821 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("`==", f_mpq_cq__backtick_eq_eq, tFunc(tMix,"\10\200\0\0\0\177\377\377\377"), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_eq_eq_defined */

#ifdef f_mpq_cq__backtick_21_eq_defined
#line 828 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("`!=", f_mpq_cq__backtick_21_eq, tFunc(tMix,"\10\200\0\0\0\177\377\377\377"), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_21_eq_defined */

#ifdef f_mpq_sgn_defined
#line 835 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
  ADD_FUNCTION2("sgn", f_mpq_sgn, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_sgn_defined */

#ifdef f_mpq_cq__backtick_21_defined
  ADD_FUNCTION2("`!", f_mpq_cq__backtick_21, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), ID_STATIC, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_mpq_cq__backtick_21_defined */
  mpq_program=end_program();
  add_program_constant("mpq",mpq_program,0);

#endif /* class_mpq_defined */
#line 872 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
}

void pike_exit_mpq_module(void)
{
  
#ifdef class_mpq_defined
  if(mpq_program) {
    free_program(mpq_program);
    mpq_program=0;
  }

#endif /* class_mpq_defined */
#line 877 "/tmp/pikedeb.5a120871e4/7.4/src/modules/Gmp/mpq.cmod"
}

