/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment unit test for pgmdrawable.c
 *
 * Copyright © 2006, 2007 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/* FIXME: Not complete */

#include <gst/check/gstcheck.h>
#include <pgm/pgm.h>

/* test default values */
GST_START_TEST (test_drawable_default_values)
{
  PgmDrawable *drawable;
  PgmError ret;
  gfloat width, height;
  gfloat x, y, z;
  guchar r, g, b, a;
  guchar opacity;

  pgm_init (NULL, NULL);
  drawable = pgm_image_new ();

  /* size */
  ret = pgm_drawable_get_size (drawable, &width, &height);
  fail_if (ret != PGM_ERROR_OK, "drawable_get_size error");
  fail_if (width != 1.0f || height != 1.0f, "bad default size");

  /* position */
  ret = pgm_drawable_get_position (drawable, &x, &y, &z);
  fail_if (ret != PGM_ERROR_OK, "drawable_get_position error");
  fail_if (x != 0.0f || y != 0.0f || z != 0.0f, "bad default position");

  /* color */
  ret = pgm_drawable_get_fg_color (drawable, &r, &g, &b, &a);
  fail_if (ret != PGM_ERROR_OK, "drawable_get_fg_color error");
  fail_if (r != 0xFF || g != 0xFF || b != 0xFF || a != 0xFF,
           "bad default color");

  /* opacity */
  ret = pgm_drawable_get_opacity (drawable, &opacity);
  fail_if (ret != PGM_ERROR_OK, "drawable_get_opacity error");
  fail_if (opacity != 0xFF, "bad default opacity");

  gst_object_unref (GST_OBJECT_CAST (drawable));
  pgm_deinit ();
}
GST_END_TEST

/* test set/get correctness */
GST_START_TEST (test_drawable_set_get_correctness)
{
  PgmDrawable *drawable;
  PgmError ret;
  gfloat width, height;
  gfloat x, y, z;
  guchar r, g, b, a;
  guchar opacity;

  pgm_init (NULL, NULL);
  drawable = pgm_image_new ();

  /* size */
  ret = pgm_drawable_set_size (drawable, 55.55f, 66.66f);
  fail_if (ret != PGM_ERROR_OK, "drawable_set_size error");
  ret = pgm_drawable_get_size (drawable, &width, &height);
  fail_if (ret != PGM_ERROR_OK, "drawable_get_size error");
  fail_if (width != 55.55f || height != 66.66f, "size not set");

  /* position */
  ret = pgm_drawable_set_position (drawable, 1.1f, 2.2f, 3.3f);
  fail_if (ret != PGM_ERROR_OK, "drawable_set_position error");
  ret = pgm_drawable_get_position (drawable, &x, &y, &z);
  fail_if (ret != PGM_ERROR_OK, "drawable_get_position error");
  fail_if (x != 1.1f || y != 2.2f || z != 3.3f, "position not set");

  /* color */
  ret = pgm_drawable_set_fg_color (drawable, 0xA0, 0xA1, 0xA2, 0xA3);
  fail_if (ret != PGM_ERROR_OK, "drawable_set_fg_color error");
  ret = pgm_drawable_get_fg_color (drawable, &r, &g, &b, &a);
  fail_if (ret != PGM_ERROR_OK, "drawable_get_fg_color error");
  fail_if (r != 0xA0 || g != 0xA1 || b != 0xA2 || a != 0xA3, "color not set");

  /* opacity */
  ret = pgm_drawable_set_opacity (drawable, 0xAB);
  fail_if (ret != PGM_ERROR_OK, "drawable_set_opacity error");
  ret = pgm_drawable_get_opacity (drawable, &opacity);
  fail_if (ret != PGM_ERROR_OK, "drawable_get_opacity error");
  fail_if (opacity != 0xAB, "opacity not set");

  gst_object_unref (GST_OBJECT_CAST (drawable));
  pgm_deinit ();
}
GST_END_TEST

/* test drawable visibility before and after being added in a canvas */
/* GST_START_TEST (test_drawable_visibility) */
/* { */
/*   PgmError ret; */
/*   PgmCanvas *canvas; */
/*   PgmDrawable *drawable; */

/*   pgm_init ("boilerplate", NULL, NULL); */

/*   canvas = PGM_CANVAS (pgm_create_viewport ()); */
/*   drawable = PGM_DRAWABLE (pgm_create_image ()); */

/*   /\* must be invisible before being added *\/ */
/*   fail_if (pgm_drawable_is_visible (drawable), */
/*            "drawable visible before being added"); */

/*   /\* must be visible after being added *\/ */
/*   ret = pgm_canvas_add_drawable (canvas, drawable, PGM_DRAWABLE_NEAR); */
/*   fail_if (ret != PGM_ERROR_OK, "canvas_add_drawable error"); */
/*   fail_unless (pgm_drawable_is_visible (drawable), */
/*                "drawable invisible after being added"); */

/*   /\* must be invisible after being removed *\/ */
/*   ret = pgm_canvas_del_drawable (canvas, drawable); */
/*   fail_if (ret != PGM_ERROR_OK, "canvas_del_drawable error"); */
/*   fail_if (pgm_drawable_is_visible (drawable), */
/*            "drawable visible after being removed"); */

/*   gst_object_unref (GST_OBJECT_CAST (canvas)); */
/*   pgm_deinit (); */
/* } */
/* GST_END_TEST */

Suite *
pgm_drawable_suite (void)
{
  Suite *s = suite_create ("PgmDrawable");
  TCase *tc_chain = tcase_create ("pgmdrawable tests");

  suite_add_tcase (s, tc_chain);
  tcase_add_test (tc_chain, test_drawable_default_values);
  tcase_add_test (tc_chain, test_drawable_set_get_correctness);
  /* tcase_add_test (tc_chain, test_drawable_visibility); */

  return s;
}

GST_CHECK_MAIN (pgm_drawable);
