# -*- mode: python; coding: utf-8 -*-
#
# Pigment Python binding image example
#
# Copyright © 2006, 2007 Fluendo Embedded S.L.
#
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, write to the
# Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
#
# Author: Loïc Molinari <loic@fluendo.com>

import sys, os, pgm, gobject, gtk.gdk

# Update the viewport on an expose event
def on_expose(viewport, event):
    viewport.update()

# Terminate the mainloop on a delete event
def on_delete(viewport, event):
    pgm.main_quit()

def main(args):
    # OpenGL viewport creation
    factory = pgm.ViewportFactory('opengl')
    gl = factory.create()
    gl.title = 'Image'
    icon = gtk.gdk.pixbuf_new_from_file("examples/pictures/fluendo.png")
    gl.icon = icon

    # Canvas and image drawable creation
    cvs = pgm.Canvas()
    img = pgm.Image()

    # Bind the canvas to the OpenGL viewport
    gl.set_canvas(cvs)

    # Load an image from a file descriptor
    fd = os.open('examples/pictures/fluendo.png', os.O_RDONLY)
    img.set_from_fd(fd)
    img.bg_color = (255, 255, 255, 0)

    # Center the image
    img.position = (1.5, 1.0, 0.0)

    # A drawable needs to be shown
    img.show()

    # Add it to the middle layer of the canvas
    cvs.add(pgm.DRAWABLE_MIDDLE, img)

    # Let's connect our callbacks and start the mainloop
    gl.connect('expose-event', on_expose)
    gl.connect('delete-event', on_delete)
    gl.show()
    gl.update()
    pgm.main()

if __name__ == '__main__':
    sys.exit(main(sys.argv[1:]))
