/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment OpenGL ES-CM 1.1 plugin
 *
 * Copyright © 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Loïc Molinari <loic@fluendo.com>
 */

#ifndef __PGM_GLES_X_BACKEND_H__
#define __PGM_GLES_X_BACKEND_H__

#include <GLES/egl.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "pgmglesbackend.h"

G_BEGIN_DECLS

#define PGM_TYPE_GLES_X_BACKEND (pgm_gles_x_backend_get_type ())
#define PGM_GLES_X_BACKEND(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), PGM_TYPE_GLES_X_BACKEND, PgmGlesXBackend))
#define PGM_GLES_X_BACKEND_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), PGM_TYPE_GLES_X_BACKEND, PgmGlesXBackendClass))
#define PGM_IS_GLES_X_BACKEND(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), PGM_TYPE_GLES_X_BACKEND))
#define PGM_IS_GLES_X_BACKEND_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), PGM_TYPE_GLES_X_BACKEND))
#define PGM_GLES_X_BACKEND_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS((obj), PGM_TYPE_GLES_X_BACKEND, PgmGlesXBackendClass))

typedef struct _PgmGlesXBackend       PgmGlesXBackend;
typedef struct _PgmGlesXBackendClass  PgmGlesXBackendClass;
typedef struct _PgmGlesXBackendSource PgmGlesXBackendSource;

struct _PgmGlesXBackend {
  PgmGlesBackend parent;

  /* X connection and window management */
  Display *xdisplay;
  Window   win;
  gint     screen;
  gint     root;

  /* X atoms */
  Atom *atom;

  /* EGL structures */
  EGLDisplay egldisplay;
  EGLSurface surface;
  EGLContext context;

  /* EGL informations */
  const gchar *vendor;
  const gchar *extensions;
  const gchar *version;

  /* Event handling source id */
  guint event_id;

  /* Screen informations */
  gint resolution_width;
  gint resolution_height;
  gint size_mm_width;
  gint size_mm_height;

  /* States */
  gboolean created;
};

struct _PgmGlesXBackendClass {
  PgmGlesBackendClass parent_class;
};

/* Event source */
struct _PgmGlesXBackendSource {
  GSource source;
  GPollFD poll_fd;

  /* Keep track of the backend */
  PgmGlesXBackend *glesxbackend;
};

GType           pgm_gles_x_backend_get_type (void) G_GNUC_CONST;

PgmGlesBackend *pgm_gles_x_backend_new      (PgmGlesContext *glescontext);
void            pgm_gles_x_backend_register (GTypeModule *module);

G_END_DECLS

#endif /* __PGM_GLES_X_BACKEND_H__ */
