/* -*- Mode: C; c-basic-offset: 2; indent-tabs-mode: nil -*-
 *
 * Pigment unit test for pgmcanvas.c
 *
 * Copyright © 2006, 2007, 2008 Fluendo Embedded S.L.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * FIXME: pgm_canvas_regenerate
 */

#include <tests/check/common/pgmcheck.h>
#include <pgm/pgm.h>

#include "pgmplugintestsuite.h"


PGM_START_TEST (test_canvas_get_pixel_formats)
{
  PgmCanvas *canvas = NULL;
  PgmViewport *viewport = NULL;
  gulong pixel_formats = 1234567890;

  canvas = pgm_canvas_new ();
  fail_if (NULL == canvas, "canvas creation failed");

  ASSERT_PGM_ERROR_WITH_CRITICAL
    (pgm_canvas_get_pixel_formats (NULL, &pixel_formats));
  ASSERT_PGM_ERROR_WITH_CRITICAL (pgm_canvas_get_pixel_formats (canvas, NULL));

  ASSERT_PGM_SUCCESS (pgm_canvas_get_pixel_formats (canvas, &pixel_formats));
  fail_if (0 != pixel_formats,
           "unbound canvas reports erroneous supported formats");

  ASSERT_PGM_SUCCESS (pgm_viewport_factory_make (PGM_TEST_PLUGIN, &viewport));
  ASSERT_PGM_SUCCESS (pgm_viewport_set_canvas (viewport, canvas));
  ASSERT_PGM_SUCCESS (pgm_canvas_get_pixel_formats (canvas, &pixel_formats));
  fail_if (0 == pixel_formats,
           "bound canvas reports erroneous supported formats");

  gst_object_unref (viewport);
  gst_object_unref (canvas);
}
PGM_END_TEST

Suite *
pgm_canvas_suite (void)
{
  Suite *s = suite_create ("PgmCanvas");
  TCase *tc_chain = tcase_create ("pgmcanvas tests");

  PGM_USE_STANDARD_FIXTURES (tc_chain);

  suite_add_tcase (s, tc_chain);
  tcase_add_test (tc_chain, test_canvas_get_pixel_formats);

  return s;
}

