/***************************************************************************
 *   Copyright (C) 2003 by Yann Bouan                                      *
 *   <yann@bouan.net>                                                      *
 *                                                                         *
 *   Copyright (C) 2003 by Claudio J. Chiabai                              *
 *   <chiabai@users.sourceforge.net>                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "picwiz.h"
#include <kapplication.h>
#include <kaboutdata.h>
#include <kdebug.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kmessagebox.h>

static const char description[] =
  I18N_NOOP("A picture resizing wizard.");

static const char version[] = "0.3.1";

static KCmdLineOptions options[] =
  {
    { "+[URL]", I18N_NOOP( "Image to resize." ), 0 },
    KCmdLineLastOption
  };

int main(int argc, char **argv)
{
  KAboutData about("picwiz", I18N_NOOP("Picture Wizard"), version, description,
                   KAboutData::License_GPL, "(C) 2003 Yann Bouan", 0, "http://picwiz.sourceforge.net",
                   "picwiz@bouan.net");

  about.addAuthor( "Yann Bouan", I18N_NOOP("Author & maintainer"),	"picwiz@bouan.net");
  about.addAuthor( "Claudio J. Chiabai",  I18N_NOOP("Port KDE"), "chiabai@users.sourceforge.net" );

  KCmdLineArgs::init(argc, argv, &about);
  KCmdLineArgs::addCmdLineOptions( options );

  KApplication app;

         if (KCmdLineArgs::parsedArgs()->count() == 0)
         {
           kdDebug() << " No files ...!!" << endl;
           return 0;
         }

  PicWiz *mainWin = 0;

  mainWin = new PicWiz();
  app.setMainWidget( mainWin );
  mainWin->show();

  // mainWin has WDestructiveClose flag by default, so it will delete itself.
  return app.exec();
}

