;; -*-emacs-lisp-*-
;;
;; Emacs startup file for the Debian picolisp package
;;
;; To avoid a dependency on emacsen for our modes and avoid having a
;; separate picolisp-el package, we don't byte-compile the .el
;; files, so we only need to add a source directory to load-path.

(let ((package-dir "/usr/share/emacs/site-lisp/picolisp"))
;; If package-dir does not exist, the picolisp package must have
;; removed but not purged, and we should skip the setup.
  (when (file-directory-p package-dir)
    (if (fboundp 'debian-pkg-add-load-path-item)
        (debian-pkg-add-load-path-item package-dir)
      (setq load-path (cons package-dir load-path)))
    (autoload 'run-picolisp "inferior-picolisp")
    (autoload 'picolisp-mode "picolisp"
      "Major mode for editing picolisp files." t)
    (add-to-list 'auto-mode-alist '("\\.l\\'" . picolisp-mode))
    (autoload 'picolisp-wiki-mode "picolisp-wiki-mode"
      "Major mode for editing Picolisp-Wiki files" t)
    (setq auto-mode-alist
          (cons '("\\.plw" . picolisp-wiki-mode) auto-mode-alist))))

