/*
 * Copyright (c) 1994 Cygnus Support.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * and/or other materials related to such
 * distribution and use acknowledge that the software was developed
 * at Cygnus Support, Inc.  Cygnus Support, Inc. may not be used to
 * endorse or promote products derived from this software without
 * specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
#include "test.h"
 one_line_type atan2_vec[] = {
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbff00000, 0x00000000, 0xbff00000, 0x00000000},	/* -2.35619=f(-1, -1)*/
{64, 0,123,__LINE__, 0xc002a4fc, 0x28e95ed8, 0xbff00000, 0x00000000, 0xbfee6666, 0x66666666},	/* -2.33056=f(-1, -0.95)*/
{64, 0,123,__LINE__, 0xc0026dcb, 0xd423977c, 0xbff00000, 0x00000000, 0xbfeccccc, 0xcccccccc},	/* -2.30361=f(-1, -0.9)*/
{64, 0,123,__LINE__, 0xc00233cb, 0x72d34279, 0xbff00000, 0x00000000, 0xbfeb3333, 0x33333332},	/* -2.27529=f(-1, -0.85)*/
{64, 0,123,__LINE__, 0xc001f6dc, 0x3e631130, 0xbff00000, 0x00000000, 0xbfe99999, 0x99999998},	/* -2.24554=f(-1, -0.8)*/
{64, 0,123,__LINE__, 0xc001b6e1, 0x92ebbe44, 0xbff00000, 0x00000000, 0xbfe7ffff, 0xfffffffe},	/* -2.2143=f(-1, -0.75)*/
{64, 0,123,__LINE__, 0xc00173c1, 0xf5810bb7, 0xbff00000, 0x00000000, 0xbfe66666, 0x66666664},	/* -2.18152=f(-1, -0.7)*/
{64, 0,123,__LINE__, 0xc0012d68, 0x46b76641, 0xbff00000, 0x00000000, 0xbfe4cccc, 0xccccccca},	/* -2.14717=f(-1, -0.65)*/
{64, 0,123,__LINE__, 0xc000e3c5, 0x1fa059c4, 0xbff00000, 0x00000000, 0xbfe33333, 0x33333330},	/* -2.11122=f(-1, -0.6)*/
{64, 0,123,__LINE__, 0xc00096d0, 0x5371b1c4, 0xbff00000, 0x00000000, 0xbfe19999, 0x99999996},	/* -2.07364=f(-1, -0.55)*/
{63, 0,123,__LINE__, 0xc000468a, 0x8ace4df5, 0xbff00000, 0x00000000, 0xbfdfffff, 0xfffffff9},	/* -2.03444=f(-1, -0.5)*/
{64, 0,123,__LINE__, 0xbfffe5fd, 0xcebfcb86, 0xbff00000, 0x00000000, 0xbfdccccc, 0xccccccc6},	/* -1.99365=f(-1, -0.45)*/
{64, 0,123,__LINE__, 0xbfff3889, 0x2f1e0c87, 0xbff00000, 0x00000000, 0xbfd99999, 0x99999993},	/* -1.9513=f(-1, -0.4)*/
{63, 0,123,__LINE__, 0xbffe8500, 0x76ee9e8c, 0xbff00000, 0x00000000, 0xbfd66666, 0x66666660},	/* -1.90747=f(-1, -0.35)*/
{63, 0,123,__LINE__, 0xbffdcbc9, 0xedcbd8d8, 0xbff00000, 0x00000000, 0xbfd33333, 0x3333332d},	/* -1.86225=f(-1, -0.3)*/
{64, 0,123,__LINE__, 0xbffd0d6a, 0x1369bd33, 0xbff00000, 0x00000000, 0xbfcfffff, 0xfffffff4},	/* -1.81577=f(-1, -0.25)*/
{63, 0,123,__LINE__, 0xbffc4a83, 0x936311d8, 0xbff00000, 0x00000000, 0xbfc99999, 0x9999998e},	/* -1.76819=f(-1, -0.2)*/
{63, 0,123,__LINE__, 0xbffb83d5, 0xc13f26b7, 0xbff00000, 0x00000000, 0xbfc33333, 0x33333328},	/* -1.71969=f(-1, -0.15)*/
{64, 0,123,__LINE__, 0xbffaba39, 0x7c7259dc, 0xbff00000, 0x00000000, 0xbfb99999, 0x99999983},	/* -1.67046=f(-1, -0.1)*/
{63, 0,123,__LINE__, 0xbff9ee9c, 0x8100c210, 0xbff00000, 0x00000000, 0xbfa99999, 0x9999996c},	/* -1.62075=f(-1, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d17, 0xbff00000, 0x00000000, 0x3cb70000, 0x00000000},	/* -1.5708=f(-1, 3.19189e-16)*/
{64, 0,123,__LINE__, 0xbff8555a, 0x2787981e, 0xbff00000, 0x00000000, 0x3fa99999, 0x999999c8},	/* -1.52084=f(-1, 0.05)*/
{64, 0,123,__LINE__, 0xbff789bd, 0x2c160052, 0xbff00000, 0x00000000, 0x3fb99999, 0x999999b1},	/* -1.47113=f(-1, 0.1)*/
{64, 0,123,__LINE__, 0xbff6c020, 0xe7493376, 0xbff00000, 0x00000000, 0x3fc33333, 0x3333333f},	/* -1.42191=f(-1, 0.15)*/
{64, 0,123,__LINE__, 0xbff5f973, 0x15254855, 0xbff00000, 0x00000000, 0x3fc99999, 0x999999a6},	/* -1.3734=f(-1, 0.2)*/
{64, 0,123,__LINE__, 0xbff5368c, 0x951e9cfb, 0xbff00000, 0x00000000, 0x3fd00000, 0x00000006},	/* -1.32582=f(-1, 0.25)*/
{63, 0,123,__LINE__, 0xbff4782c, 0xbabc8155, 0xbff00000, 0x00000000, 0x3fd33333, 0x33333339},	/* -1.27934=f(-1, 0.3)*/
{64, 0,123,__LINE__, 0xbff3bef6, 0x3199bba1, 0xbff00000, 0x00000000, 0x3fd66666, 0x6666666c},	/* -1.23412=f(-1, 0.35)*/
{64, 0,123,__LINE__, 0xbff30b6d, 0x796a4da7, 0xbff00000, 0x00000000, 0x3fd99999, 0x9999999f},	/* -1.19029=f(-1, 0.4)*/
{64, 0,123,__LINE__, 0xbff25df8, 0xd9c88ea8, 0xbff00000, 0x00000000, 0x3fdccccc, 0xccccccd2},	/* -1.14794=f(-1, 0.45)*/
{64, 0,123,__LINE__, 0xbff1b6e1, 0x92ebbe43, 0xbff00000, 0x00000000, 0x3fe00000, 0x00000003},	/* -1.10715=f(-1, 0.5)*/
{64, 0,123,__LINE__, 0xbff11656, 0x01a4f6a5, 0xbff00000, 0x00000000, 0x3fe19999, 0x9999999d},	/* -1.06795=f(-1, 0.55)*/
{64, 0,123,__LINE__, 0xbff07c6c, 0x6947a6a6, 0xbff00000, 0x00000000, 0x3fe33333, 0x33333337},	/* -1.03038=f(-1, 0.6)*/
{64, 0,123,__LINE__, 0xbfefd24c, 0x36331b59, 0xbff00000, 0x00000000, 0x3fe4cccc, 0xccccccd1},	/* -0.994421=f(-1, 0.65)*/
{64, 0,123,__LINE__, 0xbfeeb8e5, 0x7b0c8580, 0xbff00000, 0x00000000, 0x3fe66666, 0x6666666b},	/* -0.96007=f(-1, 0.7)*/
{64, 0,123,__LINE__, 0xbfedac67, 0x0561bb4c, 0xbff00000, 0x00000000, 0x3fe80000, 0x00000005},	/* -0.927295=f(-1, 0.75)*/
{64, 0,123,__LINE__, 0xbfecac7c, 0x57846f9b, 0xbff00000, 0x00000000, 0x3fe99999, 0x9999999f},	/* -0.896055=f(-1, 0.8)*/
{64, 0,123,__LINE__, 0xbfebb8bf, 0x85c3aa79, 0xbff00000, 0x00000000, 0x3feb3333, 0x33333339},	/* -0.866302=f(-1, 0.85)*/
{64, 0,123,__LINE__, 0xbfead0be, 0x0082566f, 0xbff00000, 0x00000000, 0x3feccccc, 0xccccccd3},	/* -0.837981=f(-1, 0.9)*/
{64, 0,123,__LINE__, 0xbfe9f3fc, 0xad6b38ff, 0xbff00000, 0x00000000, 0x3fee6666, 0x6666666d},	/* -0.811034=f(-1, 0.95)*/
{64, 0,123,__LINE__, 0xc0030dfc, 0xd57ce4cd, 0xbfee6666, 0x66666666, 0xbff00000, 0x00000000},	/* -2.38183=f(-0.95, -1)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfee6666, 0x66666666, 0xbfee6666, 0x66666666},	/* -2.35619=f(-0.95, -0.95)*/
{64, 0,123,__LINE__, 0xc002a225, 0xffe678cc, 0xbfee6666, 0x66666666, 0xbfeccccc, 0xcccccccc},	/* -2.32917=f(-0.95, -0.9)*/
{64, 0,123,__LINE__, 0xc00267d3, 0x4beb12ff, 0xbfee6666, 0x66666666, 0xbfeb3333, 0x33333332},	/* -2.3007=f(-0.95, -0.85)*/
{64, 0,123,__LINE__, 0xc0022a5f, 0x18f3451e, 0xbfee6666, 0x66666666, 0xbfe99999, 0x99999998},	/* -2.27069=f(-0.95, -0.8)*/
{64, 0,123,__LINE__, 0xc001e9a5, 0xc99335b0, 0xbfee6666, 0x66666666, 0xbfe7ffff, 0xfffffffe},	/* -2.23909=f(-0.95, -0.75)*/
{64, 0,123,__LINE__, 0xc001a586, 0x8fc6c8d0, 0xbfee6666, 0x66666666, 0xbfe66666, 0x66666664},	/* -2.20582=f(-0.95, -0.7)*/
{64, 0,123,__LINE__, 0xc0015de4, 0xca763c22, 0xbfee6666, 0x66666666, 0xbfe4cccc, 0xccccccca},	/* -2.17085=f(-0.95, -0.65)*/
{64, 0,123,__LINE__, 0xc00112a9, 0x9ee56458, 0xbfee6666, 0x66666666, 0xbfe33333, 0x33333330},	/* -2.13411=f(-0.95, -0.6)*/
{63, 0,123,__LINE__, 0xc000c3c5, 0xca449e51, 0xbfee6666, 0x66666666, 0xbfe19999, 0x99999996},	/* -2.09559=f(-0.95, -0.55)*/
{63, 0,123,__LINE__, 0xc0007133, 0xa108dee3, 0xbfee6666, 0x66666666, 0xbfdfffff, 0xfffffff9},	/* -2.05527=f(-0.95, -0.5)*/
{64, 0,123,__LINE__, 0xc0001af9, 0x294450fa, 0xbfee6666, 0x66666666, 0xbfdccccc, 0xccccccc6},	/* -2.01317=f(-0.95, -0.45)*/
{64, 0,123,__LINE__, 0xbfff8254, 0x66b1ec6c, 0xbfee6666, 0x66666666, 0xbfd99999, 0x99999993},	/* -1.96932=f(-0.95, -0.4)*/
{64, 0,123,__LINE__, 0xbffec7d4, 0x93fc7aa8, 0xbfee6666, 0x66666666, 0xbfd66666, 0x66666660},	/* -1.92379=f(-0.95, -0.35)*/
{64, 0,123,__LINE__, 0xbffe06dc, 0x9297b73f, 0xbfee6666, 0x66666666, 0xbfd33333, 0x3333332d},	/* -1.87668=f(-0.95, -0.3)*/
{63, 0,123,__LINE__, 0xbffd3ffa, 0xcd08c0c1, 0xbfee6666, 0x66666666, 0xbfcfffff, 0xfffffff4},	/* -1.82812=f(-0.95, -0.25)*/
{64, 0,123,__LINE__, 0xbffc73e2, 0xe46d7f72, 0xbfee6666, 0x66666666, 0xbfc99999, 0x9999998e},	/* -1.77829=f(-0.95, -0.2)*/
{63, 0,123,__LINE__, 0xbffba36c, 0x4c864173, 0xbfee6666, 0x66666666, 0xbfc33333, 0x33333328},	/* -1.7274=f(-0.95, -0.15)*/
{64, 0,123,__LINE__, 0xbffacf8e, 0xc523642f, 0xbfee6666, 0x66666666, 0xbfb99999, 0x99999983},	/* -1.67567=f(-0.95, -0.1)*/
{64, 0,123,__LINE__, 0xbff9f95c, 0xaa6341c4, 0xbfee6666, 0x66666666, 0xbfa99999, 0x9999996c},	/* -1.62338=f(-0.95, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d17, 0xbfee6666, 0x66666666, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.95, 3.19189e-16)*/
{64, 0,123,__LINE__, 0xbff84a99, 0xfe25186a, 0xbfee6666, 0x66666666, 0x3fa99999, 0x999999c8},	/* -1.51821=f(-0.95, 0.05)*/
{64, 0,123,__LINE__, 0xbff77467, 0xe364f5ff, 0xbfee6666, 0x66666666, 0x3fb99999, 0x999999b1},	/* -1.46592=f(-0.95, 0.1)*/
{64, 0,123,__LINE__, 0xbff6a08a, 0x5c0218ba, 0xbfee6666, 0x66666666, 0x3fc33333, 0x3333333f},	/* -1.41419=f(-0.95, 0.15)*/
{64, 0,123,__LINE__, 0xbff5d013, 0xc41adabc, 0xbfee6666, 0x66666666, 0x3fc99999, 0x999999a6},	/* -1.3633=f(-0.95, 0.2)*/
{64, 0,123,__LINE__, 0xbff503fb, 0xdb7f996c, 0xbfee6666, 0x66666666, 0x3fd00000, 0x00000006},	/* -1.31347=f(-0.95, 0.25)*/
{64, 0,123,__LINE__, 0xbff43d1a, 0x15f0a2ef, 0xbfee6666, 0x66666666, 0x3fd33333, 0x33333339},	/* -1.26492=f(-0.95, 0.3)*/
{64, 0,123,__LINE__, 0xbff37c22, 0x148bdf86, 0xbfee6666, 0x66666666, 0x3fd66666, 0x6666666c},	/* -1.21781=f(-0.95, 0.35)*/
{64, 0,123,__LINE__, 0xbff2c1a2, 0x41d66dc2, 0xbfee6666, 0x66666666, 0x3fd99999, 0x9999999f},	/* -1.17227=f(-0.95, 0.4)*/
{64, 0,123,__LINE__, 0xbff20e04, 0x55ffb83a, 0xbfee6666, 0x66666666, 0x3fdccccc, 0xccccccd2},	/* -1.12842=f(-0.95, 0.45)*/
{64, 0,123,__LINE__, 0xbff1618f, 0x66769c68, 0xbfee6666, 0x66666666, 0x3fe00000, 0x00000003},	/* -1.08632=f(-0.95, 0.5)*/
{64, 0,123,__LINE__, 0xbff0bc6b, 0x13ff1d8c, 0xbfee6666, 0x66666666, 0x3fe19999, 0x9999999d},	/* -1.046=f(-0.95, 0.55)*/
{64, 0,123,__LINE__, 0xbff01ea3, 0x6abd917e, 0xbfee6666, 0x66666666, 0x3fe33333, 0x33333337},	/* -1.00748=f(-0.95, 0.6)*/
{63, 0,123,__LINE__, 0xbfef105a, 0x2737c3d6, 0xbfee6666, 0x66666666, 0x3fe4cccc, 0xccccccd1},	/* -0.970746=f(-0.95, 0.65)*/
{64, 0,123,__LINE__, 0xbfedf1d3, 0x11f5911e, 0xbfee6666, 0x66666666, 0x3fe66666, 0x6666666b},	/* -0.93577=f(-0.95, 0.7)*/
{64, 0,123,__LINE__, 0xbfece156, 0x2ac3dd9e, 0xbfee6666, 0x66666666, 0x3fe80000, 0x00000005},	/* -0.902507=f(-0.95, 0.75)*/
{64, 0,123,__LINE__, 0xbfebde70, 0xed439fe3, 0xbfee6666, 0x66666666, 0x3fe99999, 0x9999999f},	/* -0.870903=f(-0.95, 0.8)*/
{63, 0,123,__LINE__, 0xbfeae8a0, 0x21646860, 0xbfee6666, 0x66666666, 0x3feb3333, 0x33333339},	/* -0.840897=f(-0.95, 0.85)*/
{64, 0,123,__LINE__, 0xbfe9ff55, 0x5176d12f, 0xbfee6666, 0x66666666, 0x3feccccc, 0xccccccd3},	/* -0.812419=f(-0.95, 0.9)*/
{64, 0,123,__LINE__, 0xbfe921fb, 0x54442d15, 0xbfee6666, 0x66666666, 0x3fee6666, 0x6666666d},	/* -0.785398=f(-0.95, 0.95)*/
{64, 0,123,__LINE__, 0xc003452d, 0x2a42ac29, 0xbfeccccc, 0xcccccccc, 0xbff00000, 0x00000000},	/* -2.40878=f(-0.9, -1)*/
{64, 0,123,__LINE__, 0xc00310d2, 0xfe7fcad9, 0xbfeccccc, 0xcccccccc, 0xbfee6666, 0x66666666},	/* -2.38321=f(-0.9, -0.95)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfeccccc, 0xcccccccc, 0xbfeccccc, 0xcccccccc},	/* -2.35619=f(-0.9, -0.9)*/
{64, 0,123,__LINE__, 0xc0029efc, 0xe9f0f591, 0xbfeccccc, 0xcccccccc, 0xbfeb3333, 0x33333332},	/* -2.32763=f(-0.9, -0.85)*/
{64, 0,123,__LINE__, 0xc0026127, 0x862b05f6, 0xbfeccccc, 0xcccccccc, 0xbfe99999, 0x99999998},	/* -2.29744=f(-0.9, -0.8)*/
{63, 0,123,__LINE__, 0xc0021fd0, 0x9b1e712f, 0xbfeccccc, 0xcccccccc, 0xbfe7ffff, 0xfffffffe},	/* -2.26553=f(-0.9, -0.75)*/
{64, 0,123,__LINE__, 0xc001dace, 0xaa5dc056, 0xbfeccccc, 0xcccccccc, 0xbfe66666, 0x66666664},	/* -2.23184=f(-0.9, -0.7)*/
{64, 0,123,__LINE__, 0xc00191fb, 0xf721ce52, 0xbfeccccc, 0xcccccccc, 0xbfe4cccc, 0xccccccca},	/* -2.19628=f(-0.9, -0.65)*/
{64, 0,123,__LINE__, 0xc0014538, 0x5fa3af71, 0xbfeccccc, 0xcccccccc, 0xbfe33333, 0x33333330},	/* -2.1588=f(-0.9, -0.6)*/
{64, 0,123,__LINE__, 0xc000f46b, 0x88a03601, 0xbfeccccc, 0xcccccccc, 0xbfe19999, 0x99999996},	/* -2.11935=f(-0.9, -0.55)*/
{64, 0,123,__LINE__, 0xc0009f87, 0x5343d018, 0xbfeccccc, 0xcccccccc, 0xbfdfffff, 0xfffffff9},	/* -2.07789=f(-0.9, -0.5)*/
{63, 0,123,__LINE__, 0xc000468a, 0x8ace4df5, 0xbfeccccc, 0xcccccccc, 0xbfdccccc, 0xccccccc6},	/* -2.03444=f(-0.9, -0.45)*/
{64, 0,123,__LINE__, 0xbfffd307, 0x52e3200b, 0xbfeccccc, 0xcccccccc, 0xbfd99999, 0x99999993},	/* -1.98902=f(-0.9, -0.4)*/
{63, 0,123,__LINE__, 0xbfff1127, 0x088152ac, 0xbfeccccc, 0xcccccccc, 0xbfd66666, 0x66666660},	/* -1.94169=f(-0.9, -0.35)*/
{63, 0,123,__LINE__, 0xbffe47df, 0x3d0dd4cf, 0xbfeccccc, 0xcccccccc, 0xbfd33333, 0x3333332d},	/* -1.89255=f(-0.9, -0.3)*/
{63, 0,123,__LINE__, 0xbffd77c7, 0xb196b31f, 0xbfeccccc, 0xcccccccc, 0xbfcfffff, 0xfffffff4},	/* -1.84174=f(-0.9, -0.25)*/
{64, 0,123,__LINE__, 0xbffca1a6, 0x56770bcf, 0xbfeccccc, 0xcccccccc, 0xbfc99999, 0x9999998e},	/* -1.78947=f(-0.9, -0.2)*/
{64, 0,123,__LINE__, 0xbffbc66e, 0x44cbc073, 0xbfeccccc, 0xcccccccc, 0xbfc33333, 0x33333328},	/* -1.73595=f(-0.9, -0.15)*/
{64, 0,123,__LINE__, 0xbffae73b, 0xd5e44e5a, 0xbfeccccc, 0xcccccccc, 0xbfb99999, 0x99999983},	/* -1.68145=f(-0.9, -0.1)*/
{64, 0,123,__LINE__, 0xbffa054d, 0xbad44abd, 0xbfeccccc, 0xcccccccc, 0xbfa99999, 0x9999996c},	/* -1.62629=f(-0.9, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d17, 0xbfeccccc, 0xcccccccc, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.9, 3.19189e-16)*/
{64, 0,123,__LINE__, 0xbff83ea8, 0xedb40f71, 0xbfeccccc, 0xcccccccc, 0x3fa99999, 0x999999c8},	/* -1.5153=f(-0.9, 0.05)*/
{64, 0,123,__LINE__, 0xbff75cba, 0xd2a40bd4, 0xbfeccccc, 0xcccccccc, 0x3fb99999, 0x999999b1},	/* -1.46014=f(-0.9, 0.1)*/
{64, 0,123,__LINE__, 0xbff67d88, 0x63bc99bb, 0xbfeccccc, 0xcccccccc, 0x3fc33333, 0x3333333f},	/* -1.40565=f(-0.9, 0.15)*/
{64, 0,123,__LINE__, 0xbff5a250, 0x52114e5e, 0xbfeccccc, 0xcccccccc, 0x3fc99999, 0x999999a6},	/* -1.35213=f(-0.9, 0.2)*/
{64, 0,123,__LINE__, 0xbff4cc2e, 0xf6f1a70e, 0xbfeccccc, 0xcccccccc, 0x3fd00000, 0x00000006},	/* -1.29985=f(-0.9, 0.25)*/
{64, 0,123,__LINE__, 0xbff3fc17, 0x6b7a855e, 0xbfeccccc, 0xcccccccc, 0x3fd33333, 0x33333339},	/* -1.24905=f(-0.9, 0.3)*/
{64, 0,123,__LINE__, 0xbff332cf, 0xa0070782, 0xbfeccccc, 0xcccccccc, 0x3fd66666, 0x6666666c},	/* -1.19991=f(-0.9, 0.35)*/
{64, 0,123,__LINE__, 0xbff270ef, 0x55a53a23, 0xbfeccccc, 0xcccccccc, 0x3fd99999, 0x9999999f},	/* -1.15257=f(-0.9, 0.4)*/
{64, 0,123,__LINE__, 0xbff1b6e1, 0x92ebbe43, 0xbfeccccc, 0xcccccccc, 0x3fdccccc, 0xccccccd2},	/* -1.10715=f(-0.9, 0.45)*/
{64, 0,123,__LINE__, 0xbff104e8, 0x0200b9fe, 0xbfeccccc, 0xcccccccc, 0x3fe00000, 0x00000003},	/* -1.0637=f(-0.9, 0.5)*/
{64, 0,123,__LINE__, 0xbff05b1f, 0x9747ee2c, 0xbfeccccc, 0xcccccccc, 0x3fe19999, 0x9999999d},	/* -1.02225=f(-0.9, 0.55)*/
{64, 0,123,__LINE__, 0xbfef730b, 0xd281f698, 0xbfeccccc, 0xcccccccc, 0x3fe33333, 0x33333337},	/* -0.982794=f(-0.9, 0.6)*/
{64, 0,123,__LINE__, 0xbfee3ffd, 0x74897b16, 0xbfeccccc, 0xcccccccc, 0x3fe4cccc, 0xccccccd1},	/* -0.945311=f(-0.9, 0.65)*/
{63, 0,123,__LINE__, 0xbfed1cb2, 0xa799b302, 0xbfeccccc, 0xcccccccc, 0x3fe66666, 0x6666666b},	/* -0.909753=f(-0.9, 0.7)*/
{63, 0,123,__LINE__, 0xbfec08aa, 0xe496efa2, 0xbfeccccc, 0xcccccccc, 0x3fe80000, 0x00000005},	/* -0.876058=f(-0.9, 0.75)*/
{64, 0,123,__LINE__, 0xbfeb034f, 0x38649c84, 0xbfeccccc, 0xcccccccc, 0x3fe99999, 0x9999999f},	/* -0.844154=f(-0.9, 0.8)*/
{64, 0,123,__LINE__, 0xbfea0bf9, 0xa94cde18, 0xbfeccccc, 0xcccccccc, 0x3feb3333, 0x33333339},	/* -0.813962=f(-0.9, 0.85)*/
{64, 0,123,__LINE__, 0xbfe921fb, 0x54442d14, 0xbfeccccc, 0xcccccccc, 0x3feccccc, 0xccccccd3},	/* -0.785398=f(-0.9, 0.9)*/
{64, 0,123,__LINE__, 0xbfe844a1, 0x571188fa, 0xbfeccccc, 0xcccccccc, 0x3fee6666, 0x6666666d},	/* -0.758378=f(-0.9, 0.95)*/
{63, 0,123,__LINE__, 0xc0037f2d, 0x8b93012b, 0xbfeb3333, 0x33333332, 0xbff00000, 0x00000000},	/* -2.4371=f(-0.85, -1)*/
{64, 0,123,__LINE__, 0xc0034b25, 0xb27b30a5, 0xbfeb3333, 0x33333332, 0xbfee6666, 0x66666666},	/* -2.41169=f(-0.85, -0.95)*/
{64, 0,123,__LINE__, 0xc00313fc, 0x14754e13, 0xbfeb3333, 0x33333332, 0xbfeccccc, 0xcccccccc},	/* -2.38476=f(-0.85, -0.9)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfeb3333, 0x33333332, 0xbfeb3333, 0x33333332},	/* -2.35619=f(-0.85, -0.85)*/
{64, 0,123,__LINE__, 0xc0029b71, 0xd79223d7, 0xbfeb3333, 0x33333332, 0xbfe99999, 0x99999998},	/* -2.3259=f(-0.85, -0.8)*/
{64, 0,123,__LINE__, 0xc00259a7, 0x10566dda, 0xbfeb3333, 0x33333332, 0xbfe7ffff, 0xfffffffe},	/* -2.29378=f(-0.85, -0.75)*/
{64, 0,123,__LINE__, 0xc00213e8, 0x74487c34, 0xbfeb3333, 0x33333332, 0xbfe66666, 0x66666664},	/* -2.25972=f(-0.85, -0.7)*/
{64, 0,123,__LINE__, 0xc001ca05, 0x51b12411, 0xbfeb3333, 0x33333332, 0xbfe4cccc, 0xccccccca},	/* -2.22364=f(-0.85, -0.65)*/
{63, 0,123,__LINE__, 0xc0017bd2, 0x1306a2e1, 0xbfeb3333, 0x33333332, 0xbfe33333, 0x33333330},	/* -2.18546=f(-0.85, -0.6)*/
{64, 0,123,__LINE__, 0xc001292a, 0xcb9e5e97, 0xbfeb3333, 0x33333332, 0xbfe19999, 0x99999996},	/* -2.1451=f(-0.85, -0.55)*/
{64, 0,123,__LINE__, 0xc000d1f6, 0x365d11c8, 0xbfeb3333, 0x33333332, 0xbfdfffff, 0xfffffff9},	/* -2.10252=f(-0.85, -0.5)*/
{63, 0,123,__LINE__, 0xc0007629, 0x16cab415, 0xbfeb3333, 0x33333332, 0xbfdccccc, 0xccccccc6},	/* -2.0577=f(-0.85, -0.45)*/
{64, 0,123,__LINE__, 0xc00015c9, 0xda46bdfc, 0xbfeb3333, 0x33333332, 0xbfd99999, 0x99999993},	/* -2.01064=f(-0.85, -0.4)*/
{63, 0,123,__LINE__, 0xbfff61e8, 0x80287a20, 0xbfeb3333, 0x33333332, 0xbfd66666, 0x66666660},	/* -1.9614=f(-0.85, -0.35)*/
{64, 0,123,__LINE__, 0xbffe8fb9, 0x6bf1d8f4, 0xbfeb3333, 0x33333332, 0xbfd33333, 0x3333332d},	/* -1.91009=f(-0.85, -0.3)*/
{63, 0,123,__LINE__, 0xbffdb5a6, 0x01769192, 0xbfeb3333, 0x33333332, 0xbfcfffff, 0xfffffff4},	/* -1.85685=f(-0.85, -0.25)*/
{63, 0,123,__LINE__, 0xbffcd487, 0x74e47388, 0xbfeb3333, 0x33333332, 0xbfc99999, 0x9999998e},	/* -1.80189=f(-0.85, -0.2)*/
{63, 0,123,__LINE__, 0xbffbed70, 0x67a8594c, 0xbfeb3333, 0x33333332, 0xbfc33333, 0x33333328},	/* -1.74547=f(-0.85, -0.15)*/
{63, 0,123,__LINE__, 0xbffb01a8, 0xbf84055b, 0xbfeb3333, 0x33333332, 0xbfb99999, 0x99999983},	/* -1.68791=f(-0.85, -0.1)*/
{63, 0,123,__LINE__, 0xbffa12a5, 0x465464ce, 0xbfeb3333, 0x33333332, 0xbfa99999, 0x9999996c},	/* -1.62955=f(-0.85, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d17, 0xbfeb3333, 0x33333332, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.85, 3.19189e-16)*/
{64, 0,123,__LINE__, 0xbff83151, 0x6233f55f, 0xbfeb3333, 0x33333332, 0x3fa99999, 0x999999c8},	/* -1.51204=f(-0.85, 0.05)*/
{64, 0,123,__LINE__, 0xbff7424d, 0xe90454d2, 0xbfeb3333, 0x33333332, 0x3fb99999, 0x999999b1},	/* -1.45369=f(-0.85, 0.1)*/
{64, 0,123,__LINE__, 0xbff65686, 0x40e000e1, 0xbfeb3333, 0x33333332, 0x3fc33333, 0x3333333f},	/* -1.39612=f(-0.85, 0.15)*/
{64, 0,123,__LINE__, 0xbff56f6f, 0x33a3e6a5, 0xbfeb3333, 0x33333332, 0x3fc99999, 0x999999a6},	/* -1.33971=f(-0.85, 0.2)*/
{64, 0,123,__LINE__, 0xbff48e50, 0xa711c89b, 0xbfeb3333, 0x33333332, 0x3fd00000, 0x00000006},	/* -1.28474=f(-0.85, 0.25)*/
{64, 0,123,__LINE__, 0xbff3b43d, 0x3c96813a, 0xbfeb3333, 0x33333332, 0x3fd33333, 0x33333339},	/* -1.2315=f(-0.85, 0.3)*/
{64, 0,123,__LINE__, 0xbff2e20e, 0x285fe00d, 0xbfeb3333, 0x33333332, 0x3fd66666, 0x6666666c},	/* -1.18019=f(-0.85, 0.35)*/
{64, 0,123,__LINE__, 0xbff21862, 0xf3fade35, 0xbfeb3333, 0x33333332, 0x3fd99999, 0x9999999f},	/* -1.13095=f(-0.85, 0.4)*/
{64, 0,123,__LINE__, 0xbff157a4, 0x7af2f203, 0xbfeb3333, 0x33333332, 0x3fdccccc, 0xccccccd2},	/* -1.0839=f(-0.85, 0.45)*/
{64, 0,123,__LINE__, 0xbff0a00a, 0x3bce369d, 0xbfeb3333, 0x33333332, 0x3fe00000, 0x00000003},	/* -1.03907=f(-0.85, 0.5)*/
{64, 0,123,__LINE__, 0xbfefe342, 0x229739ff, 0xbfeb3333, 0x33333332, 0x3fe19999, 0x9999999d},	/* -0.996491=f(-0.85, 0.55)*/
{63, 0,123,__LINE__, 0xbfee98a5, 0x04f628da, 0xbfeb3333, 0x33333332, 0x3fe33333, 0x33333337},	/* -0.956133=f(-0.85, 0.6)*/
{64, 0,123,__LINE__, 0xbfed5fd8, 0x0a4c2417, 0xbfeb3333, 0x33333332, 0x3fe4cccc, 0xccccccd1},	/* -0.91795=f(-0.85, 0.65)*/
{63, 0,123,__LINE__, 0xbfec384b, 0x7feec38b, 0xbfeb3333, 0x33333332, 0x3fe66666, 0x6666666b},	/* -0.881872=f(-0.85, 0.7)*/
{64, 0,123,__LINE__, 0xbfeb2151, 0x0fb6fcf3, 0xbfeb3333, 0x33333332, 0x3fe80000, 0x00000005},	/* -0.847817=f(-0.85, 0.75)*/
{64, 0,123,__LINE__, 0xbfea1a25, 0xf2c82502, 0xbfeb3333, 0x33333332, 0x3fe99999, 0x9999999f},	/* -0.815692=f(-0.85, 0.8)*/
{64, 0,123,__LINE__, 0xbfe921fb, 0x54442d14, 0xbfeb3333, 0x33333332, 0x3feb3333, 0x33333339},	/* -0.785398=f(-0.85, 0.85)*/
{64, 0,123,__LINE__, 0xbfe837fc, 0xff3b7c10, 0xbfeb3333, 0x33333332, 0x3feccccc, 0xccccccd3},	/* -0.756835=f(-0.85, 0.9)*/
{64, 0,123,__LINE__, 0xbfe75b56, 0x8723f1c8, 0xbfeb3333, 0x33333332, 0x3fee6666, 0x6666666d},	/* -0.7299=f(-0.85, 0.95)*/
{64, 0,123,__LINE__, 0xc003bc1c, 0xc0033274, 0xbfe99999, 0x99999998, 0xbff00000, 0x00000000},	/* -2.46685=f(-0.8, -1)*/
{64, 0,123,__LINE__, 0xc0038899, 0xe572fe86, 0xbfe99999, 0x99999998, 0xbfee6666, 0x66666666},	/* -2.4417=f(-0.8, -0.95)*/
{64, 0,123,__LINE__, 0xc00351d1, 0x783b3dae, 0xbfe99999, 0x99999998, 0xbfeccccc, 0xcccccccc},	/* -2.41495=f(-0.8, -0.9)*/
{64, 0,123,__LINE__, 0xc0031787, 0x26d41fce, 0xbfe99999, 0x99999998, 0xbfeb3333, 0x33333332},	/* -2.38649=f(-0.8, -0.85)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfe99999, 0x99999998, 0xbfe99999, 0x99999998},	/* -2.35619=f(-0.8, -0.8)*/
{64, 0,123,__LINE__, 0xc0029771, 0xd7e7791f, 0xbfe99999, 0x99999998, 0xbfe7ffff, 0xfffffffe},	/* -2.32395=f(-0.8, -0.75)*/
{64, 0,123,__LINE__, 0xc0025127, 0x9b802819, 0xbfe99999, 0x99999998, 0xbfe66666, 0x66666664},	/* -2.28963=f(-0.8, -0.7)*/
{64, 0,123,__LINE__, 0xc0020660, 0x0be7bd52, 0xbfe99999, 0x99999998, 0xbfe4cccc, 0xccccccca},	/* -2.25311=f(-0.8, -0.65)*/
{64, 0,123,__LINE__, 0xc001b6e1, 0x92ebbe44, 0xbfe99999, 0x99999998, 0xbfe33333, 0x33333330},	/* -2.2143=f(-0.8, -0.6)*/
{64, 0,123,__LINE__, 0xc0016279, 0xb155a47a, 0xbfe99999, 0x99999998, 0xbfe19999, 0x99999996},	/* -2.17308=f(-0.8, -0.55)*/
{63, 0,123,__LINE__, 0xc0010900, 0x9519d639, 0xbfe99999, 0x99999998, 0xbfdfffff, 0xfffffff9},	/* -2.1294=f(-0.8, -0.5)*/
{63, 0,123,__LINE__, 0xc000aa5d, 0x4f58e2bf, 0xbfe99999, 0x99999998, 0xbfdccccc, 0xccccccc6},	/* -2.08319=f(-0.8, -0.45)*/
{63, 0,123,__LINE__, 0xc000468a, 0x8ace4df5, 0xbfe99999, 0x99999998, 0xbfd99999, 0x99999993},	/* -2.03444=f(-0.8, -0.4)*/
{63, 0,123,__LINE__, 0xbfffbb37, 0x05373616, 0xbfe99999, 0x99999998, 0xbfd66666, 0x66666660},	/* -1.98321=f(-0.8, -0.35)*/
{64, 0,123,__LINE__, 0xbffedf81, 0xa4bd64d3, 0xbfe99999, 0x99999998, 0xbfd33333, 0x3333332d},	/* -1.92957=f(-0.8, -0.3)*/
{64, 0,123,__LINE__, 0xbffdfa99, 0x2206280a, 0xbfe99999, 0x99999998, 0xbfcfffff, 0xfffffff4},	/* -1.87368=f(-0.8, -0.25)*/
{63, 0,123,__LINE__, 0xbffd0d6a, 0x1369bd32, 0xbfe99999, 0x99999998, 0xbfc99999, 0x9999998e},	/* -1.81577=f(-0.8, -0.2)*/
{63, 0,123,__LINE__, 0xbffc192a, 0xbdbdf877, 0xbfe99999, 0x99999998, 0xbfc33333, 0x33333328},	/* -1.75614=f(-0.8, -0.15)*/
{64, 0,123,__LINE__, 0xbffb1f56, 0xfdeef00e, 0xbfe99999, 0x99999998, 0xbfb99999, 0x99999983},	/* -1.69515=f(-0.8, -0.1)*/
{64, 0,123,__LINE__, 0xbffa21a6, 0x31fd9506, 0xbfe99999, 0x99999998, 0xbfa99999, 0x9999996c},	/* -1.63322=f(-0.8, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d16, 0xbfe99999, 0x99999998, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.8, 3.19189e-16)*/
{64, 0,123,__LINE__, 0xbff82250, 0x768ac527, 0xbfe99999, 0x99999998, 0x3fa99999, 0x999999c8},	/* -1.50838=f(-0.8, 0.05)*/
{63, 0,123,__LINE__, 0xbff7249f, 0xaa996a1f, 0xbfe99999, 0x99999998, 0x3fb99999, 0x999999b1},	/* -1.44644=f(-0.8, 0.1)*/
{64, 0,123,__LINE__, 0xbff62acb, 0xeaca61b6, 0xbfe99999, 0x99999998, 0x3fc33333, 0x3333333f},	/* -1.38545=f(-0.8, 0.15)*/
{64, 0,123,__LINE__, 0xbff5368c, 0x951e9cfb, 0xbfe99999, 0x99999998, 0x3fc99999, 0x999999a6},	/* -1.32582=f(-0.8, 0.2)*/
{64, 0,123,__LINE__, 0xbff4495d, 0x86823223, 0xbfe99999, 0x99999998, 0x3fd00000, 0x00000006},	/* -1.26791=f(-0.8, 0.25)*/
{64, 0,123,__LINE__, 0xbff36475, 0x03caf55a, 0xbfe99999, 0x99999998, 0x3fd33333, 0x33333339},	/* -1.21203=f(-0.8, 0.3)*/
{64, 0,123,__LINE__, 0xbff288bf, 0xa3512417, 0xbfe99999, 0x99999998, 0x3fd66666, 0x6666666c},	/* -1.15839=f(-0.8, 0.35)*/
{64, 0,123,__LINE__, 0xbff1b6e1, 0x92ebbe43, 0xbfe99999, 0x99999998, 0x3fd99999, 0x9999999f},	/* -1.10715=f(-0.8, 0.4)*/
{64, 0,123,__LINE__, 0xbff0ef3c, 0x09d694af, 0xbfe99999, 0x99999998, 0x3fdccccc, 0xccccccd2},	/* -1.05841=f(-0.8, 0.45)*/
{63, 0,123,__LINE__, 0xbff031f5, 0x7e54adbd, 0xbfe99999, 0x99999998, 0x3fe00000, 0x00000003},	/* -1.0122=f(-0.8, 0.5)*/
{63, 0,123,__LINE__, 0xbfeefe06, 0x8bba2271, 0xbfe99999, 0x99999998, 0x3fe19999, 0x9999999d},	/* -0.968509=f(-0.8, 0.55)*/
{63, 0,123,__LINE__, 0xbfedac67, 0x0561bb4b, 0xbfe99999, 0x99999998, 0x3fe33333, 0x33333337},	/* -0.927295=f(-0.8, 0.6)*/
{64, 0,123,__LINE__, 0xbfec6e6d, 0x2171bf14, 0xbfe99999, 0x99999998, 0x3fe4cccc, 0xccccccd1},	/* -0.88848=f(-0.8, 0.65)*/
{64, 0,123,__LINE__, 0xbfeb434e, 0xe31013f8, 0xbfe99999, 0x99999998, 0x3fe66666, 0x6666666b},	/* -0.851966=f(-0.8, 0.7)*/
{64, 0,123,__LINE__, 0xbfea2a25, 0xf172cfdf, 0xbfe99999, 0x99999998, 0x3fe80000, 0x00000005},	/* -0.817645=f(-0.8, 0.75)*/
{64, 0,123,__LINE__, 0xbfe921fb, 0x54442d14, 0xbfe99999, 0x99999998, 0x3fe99999, 0x9999999f},	/* -0.785398=f(-0.8, 0.8)*/
{64, 0,123,__LINE__, 0xbfe829d0, 0xb5c03526, 0xbfe99999, 0x99999998, 0x3feb3333, 0x33333339},	/* -0.755104=f(-0.8, 0.85)*/
{64, 0,123,__LINE__, 0xbfe740a7, 0x7023bda5, 0xbfe99999, 0x99999998, 0x3feccccc, 0xccccccd3},	/* -0.726642=f(-0.8, 0.9)*/
{64, 0,123,__LINE__, 0xbfe66585, 0xbb44ba45, 0xbfe99999, 0x99999998, 0x3fee6666, 0x6666666d},	/* -0.699893=f(-0.8, 0.95)*/
{64, 0,123,__LINE__, 0xc003fc17, 0x6b7a8560, 0xbfe7ffff, 0xfffffffe, 0xbff00000, 0x00000000},	/* -2.49809=f(-0.75, -1)*/
{64, 0,123,__LINE__, 0xc003c953, 0x34d30df5, 0xbfe7ffff, 0xfffffffe, 0xbfee6666, 0x66666666},	/* -2.4733=f(-0.75, -0.95)*/
{64, 0,123,__LINE__, 0xc0039328, 0x6347d276, 0xbfe7ffff, 0xfffffffe, 0xbfeccccc, 0xcccccccc},	/* -2.44685=f(-0.75, -0.9)*/
{64, 0,123,__LINE__, 0xc0035951, 0xee0fd5ca, 0xbfe7ffff, 0xfffffffe, 0xbfeb3333, 0x33333332},	/* -2.41861=f(-0.75, -0.85)*/
{64, 0,123,__LINE__, 0xc0031b87, 0x267eca85, 0xbfe7ffff, 0xfffffffe, 0xbfe99999, 0x99999998},	/* -2.38844=f(-0.75, -0.8)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfe7ffff, 0xfffffffe, 0xbfe7ffff, 0xfffffffe},	/* -2.35619=f(-0.75, -0.75)*/
{64, 0,123,__LINE__, 0xc00292e4, 0xc2c70244, 0xbfe7ffff, 0xfffffffe, 0xbfe66666, 0x66666664},	/* -2.32173=f(-0.75, -0.7)*/
{64, 0,123,__LINE__, 0xc0024772, 0xd9496c96, 0xbfe7ffff, 0xfffffffe, 0xbfe4cccc, 0xccccccca},	/* -2.28489=f(-0.75, -0.65)*/
{64, 0,123,__LINE__, 0xc001f6dc, 0x3e631130, 0xbfe7ffff, 0xfffffffe, 0xbfe33333, 0x33333330},	/* -2.24554=f(-0.75, -0.6)*/
{63, 0,123,__LINE__, 0xc001a0dc, 0x49296b7d, 0xbfe7ffff, 0xfffffffe, 0xbfe19999, 0x99999996},	/* -2.20355=f(-0.75, -0.55)*/
{64, 0,123,__LINE__, 0xc0014538, 0x5fa3af71, 0xbfe7ffff, 0xfffffffe, 0xbfdfffff, 0xfffffff9},	/* -2.1588=f(-0.75, -0.5)*/
{64, 0,123,__LINE__, 0xc000e3c5, 0x1fa059c4, 0xbfe7ffff, 0xfffffffe, 0xbfdccccc, 0xccccccc6},	/* -2.11122=f(-0.75, -0.45)*/
{63, 0,123,__LINE__, 0xc0007c6c, 0x6947a6a7, 0xbfe7ffff, 0xfffffffe, 0xbfd99999, 0x99999993},	/* -2.06075=f(-0.75, -0.4)*/
{64, 0,123,__LINE__, 0xc0000f34, 0x0b81a4ef, 0xbfe7ffff, 0xfffffffe, 0xbfd66666, 0x66666660},	/* -2.00742=f(-0.75, -0.35)*/
{64, 0,123,__LINE__, 0xbfff3889, 0x2f1e0c87, 0xbfe7ffff, 0xfffffffe, 0xbfd33333, 0x3333332d},	/* -1.9513=f(-0.75, -0.3)*/
{63, 0,123,__LINE__, 0xbffe47df, 0x3d0dd4cf, 0xbfe7ffff, 0xfffffffe, 0xbfcfffff, 0xfffffff4},	/* -1.89255=f(-0.75, -0.25)*/
{64, 0,123,__LINE__, 0xbffd4d68, 0xbe213418, 0xbfe7ffff, 0xfffffffe, 0xbfc99999, 0x9999998e},	/* -1.8314=f(-0.75, -0.2)*/
{63, 0,123,__LINE__, 0xbffc4a83, 0x936311d8, 0xbfe7ffff, 0xfffffffe, 0xbfc33333, 0x33333328},	/* -1.76819=f(-0.75, -0.15)*/
{64, 0,123,__LINE__, 0xbffb40e9, 0xaf482898, 0xbfe7ffff, 0xfffffffe, 0xbfb99999, 0x99999983},	/* -1.70335=f(-0.75, -0.1)*/
{64, 0,123,__LINE__, 0xbffa32a5, 0x1baa2089, 0xbfe7ffff, 0xfffffffe, 0xbfa99999, 0x9999996c},	/* -1.63736=f(-0.75, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d16, 0xbfe7ffff, 0xfffffffe, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.75, 3.19189e-16)*/
{64, 0,123,__LINE__, 0xbff81151, 0x8cde39a4, 0xbfe7ffff, 0xfffffffe, 0x3fa99999, 0x999999c8},	/* -1.50423=f(-0.75, 0.05)*/
{64, 0,123,__LINE__, 0xbff7030c, 0xf9403195, 0xbfe7ffff, 0xfffffffe, 0x3fb99999, 0x999999b1},	/* -1.43824=f(-0.75, 0.1)*/
{64, 0,123,__LINE__, 0xbff5f973, 0x15254855, 0xbfe7ffff, 0xfffffffe, 0x3fc33333, 0x3333333f},	/* -1.3734=f(-0.75, 0.15)*/
{64, 0,123,__LINE__, 0xbff4f68d, 0xea672615, 0xbfe7ffff, 0xfffffffe, 0x3fc99999, 0x999999a6},	/* -1.31019=f(-0.75, 0.2)*/
{64, 0,123,__LINE__, 0xbff3fc17, 0x6b7a855e, 0xbfe7ffff, 0xfffffffe, 0x3fd00000, 0x00000006},	/* -1.24905=f(-0.75, 0.25)*/
{64, 0,123,__LINE__, 0xbff30b6d, 0x796a4da6, 0xbfe7ffff, 0xfffffffe, 0x3fd33333, 0x33333339},	/* -1.19029=f(-0.75, 0.3)*/
{63, 0,123,__LINE__, 0xbff2258e, 0x91851050, 0xbfe7ffff, 0xfffffffe, 0x3fd66666, 0x6666666c},	/* -1.13417=f(-0.75, 0.35)*/
{64, 0,123,__LINE__, 0xbff14b1d, 0xd5f90cdf, 0xbfe7ffff, 0xfffffffe, 0x3fd99999, 0x9999999f},	/* -1.08084=f(-0.75, 0.4)*/
{64, 0,123,__LINE__, 0xbff07c6c, 0x6947a6a6, 0xbfe7ffff, 0xfffffffe, 0x3fdccccc, 0xccccccd2},	/* -1.03038=f(-0.75, 0.45)*/
{64, 0,123,__LINE__, 0xbfef730b, 0xd281f697, 0xbfe7ffff, 0xfffffffe, 0x3fe00000, 0x00000003},	/* -0.982794=f(-0.75, 0.5)*/
{64, 0,123,__LINE__, 0xbfee047c, 0x2c6b0665, 0xbfe7ffff, 0xfffffffe, 0x3fe19999, 0x9999999d},	/* -0.938047=f(-0.75, 0.55)*/
{64, 0,123,__LINE__, 0xbfecac7c, 0x57846f9a, 0xbfe7ffff, 0xfffffffe, 0x3fe33333, 0x33333337},	/* -0.896055=f(-0.75, 0.6)*/
{64, 0,123,__LINE__, 0xbfeb6a21, 0xebeb0204, 0xbfe7ffff, 0xfffffffe, 0x3fe4cccc, 0xccccccd1},	/* -0.856706=f(-0.75, 0.65)*/
{64, 0,123,__LINE__, 0xbfea3c5a, 0x45f4ab4c, 0xbfe7ffff, 0xfffffffe, 0x3fe66666, 0x6666666b},	/* -0.819867=f(-0.75, 0.7)*/
{64, 0,123,__LINE__, 0xbfe921fb, 0x54442d14, 0xbfe7ffff, 0xfffffffe, 0x3fe80000, 0x00000005},	/* -0.785398=f(-0.75, 0.75)*/
{64, 0,123,__LINE__, 0xbfe819d0, 0xb7158a48, 0xbfe7ffff, 0xfffffffe, 0x3fe99999, 0x9999999f},	/* -0.753151=f(-0.75, 0.8)*/
{64, 0,123,__LINE__, 0xbfe722a5, 0x98d15d35, 0xbfe7ffff, 0xfffffffe, 0x3feb3333, 0x33333339},	/* -0.722979=f(-0.75, 0.85)*/
{64, 0,123,__LINE__, 0xbfe63b4b, 0xc3f16a86, 0xbfe7ffff, 0xfffffffe, 0x3feccccc, 0xccccccd3},	/* -0.694738=f(-0.75, 0.9)*/
{64, 0,123,__LINE__, 0xbfe562a0, 0x7dc47c8a, 0xbfe7ffff, 0xfffffffe, 0x3fee6666, 0x6666666d},	/* -0.668289=f(-0.75, 0.95)*/
{64, 0,123,__LINE__, 0xc0043f37, 0x08e537ed, 0xbfe66666, 0x66666664, 0xbff00000, 0x00000000},	/* -2.53087=f(-0.7, -1)*/
{64, 0,123,__LINE__, 0xc0040d72, 0x6e9f7ad5, 0xbfe66666, 0x66666664, 0xbfee6666, 0x66666666},	/* -2.50657=f(-0.7, -0.95)*/
{64, 0,123,__LINE__, 0xc003d82a, 0x5408834e, 0xbfe66666, 0x66666664, 0xbfeccccc, 0xcccccccc},	/* -2.48055=f(-0.7, -0.9)*/
{64, 0,123,__LINE__, 0xc0039f10, 0x8a1dc770, 0xbfe66666, 0x66666664, 0xbfeb3333, 0x33333332},	/* -2.45267=f(-0.7, -0.85)*/
{64, 0,123,__LINE__, 0xc00361d1, 0x62e61b8c, 0xbfe66666, 0x66666664, 0xbfe99999, 0x99999998},	/* -2.42276=f(-0.7, -0.8)*/
{64, 0,123,__LINE__, 0xc0032014, 0x3b9f4160, 0xbfe66666, 0x66666664, 0xbfe7ffff, 0xfffffffe},	/* -2.39066=f(-0.7, -0.75)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfe66666, 0x66666664, 0xbfe66666, 0x66666664},	/* -2.35619=f(-0.7, -0.7)*/
{64, 0,123,__LINE__, 0xc0028dab, 0x4b5b59d0, 0xbfe66666, 0x66666664, 0xbfe4cccc, 0xccccccca},	/* -2.31917=f(-0.7, -0.65)*/
{64, 0,123,__LINE__, 0xc0023c41, 0xea611604, 0xbfe66666, 0x66666664, 0xbfe33333, 0x33333330},	/* -2.27942=f(-0.7, -0.6)*/
{64, 0,123,__LINE__, 0xc001e4e5, 0x5817921e, 0xbfe66666, 0x66666664, 0xbfe19999, 0x99999996},	/* -2.23677=f(-0.7, -0.55)*/
{64, 0,123,__LINE__, 0xc0018743, 0x06ef5824, 0xbfe66666, 0x66666664, 0xbfdfffff, 0xfffffff9},	/* -2.19105=f(-0.7, -0.5)*/
{64, 0,123,__LINE__, 0xc0012317, 0x0c990104, 0xbfe66666, 0x66666664, 0xbfdccccc, 0xccccccc6},	/* -2.14213=f(-0.7, -0.45)*/
{64, 0,123,__LINE__, 0xc000b833, 0xbe165cc8, 0xbfe66666, 0x66666664, 0xbfd99999, 0x99999993},	/* -2.08994=f(-0.7, -0.4)*/
{63, 0,123,__LINE__, 0xc000468a, 0x8ace4df5, 0xbfe66666, 0x66666664, 0xbfd66666, 0x66666660},	/* -2.03444=f(-0.7, -0.35)*/
{63, 0,123,__LINE__, 0xbfff9c6b, 0x238c6433, 0xbfe66666, 0x66666664, 0xbfd33333, 0x3333332d},	/* -1.97569=f(-0.7, -0.3)*/
{64, 0,123,__LINE__, 0xbffe9f02, 0x0021cec6, 0xbfe66666, 0x66666664, 0xbfcfffff, 0xfffffff4},	/* -1.91382=f(-0.7, -0.25)*/
{63, 0,123,__LINE__, 0xbffd95e5, 0xac22d08a, 0xbfe66666, 0x66666664, 0xbfc99999, 0x9999998e},	/* -1.8491=f(-0.7, -0.2)*/
{64, 0,123,__LINE__, 0xbffc829e, 0xbb6db38c, 0xbfe66666, 0x66666664, 0xbfc33333, 0x33333328},	/* -1.78189=f(-0.7, -0.15)*/
{63, 0,123,__LINE__, 0xbffb6731, 0x2cd2f432, 0xbfe66666, 0x66666664, 0xbfb99999, 0x99999983},	/* -1.71269=f(-0.7, -0.1)*/
{64, 0,123,__LINE__, 0xbffa460e, 0xa017978f, 0xbfe66666, 0x66666664, 0xbfa99999, 0x9999996c},	/* -1.6421=f(-0.7, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d16, 0xbfe66666, 0x66666664, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.7, 3.19189e-16)*/
{64, 0,123,__LINE__, 0xbff7fde8, 0x0870c29e, 0xbfe66666, 0x66666664, 0x3fa99999, 0x999999c8},	/* -1.49949=f(-0.7, 0.05)*/
{64, 0,123,__LINE__, 0xbff6dcc5, 0x7bb565fa, 0xbfe66666, 0x66666664, 0x3fb99999, 0x999999b1},	/* -1.4289=f(-0.7, 0.1)*/
{64, 0,123,__LINE__, 0xbff5c157, 0xed1aa6a1, 0xbfe66666, 0x66666664, 0x3fc33333, 0x3333333f},	/* -1.3597=f(-0.7, 0.15)*/
{64, 0,123,__LINE__, 0xbff4ae10, 0xfc6589a2, 0xbfe66666, 0x66666664, 0x3fc99999, 0x999999a6},	/* -1.2925=f(-0.7, 0.2)*/
{64, 0,123,__LINE__, 0xbff3a4f4, 0xa8668b67, 0xbfe66666, 0x66666664, 0x3fd00000, 0x00000006},	/* -1.22777=f(-0.7, 0.25)*/
{64, 0,123,__LINE__, 0xbff2a78b, 0x84fbf5fa, 0xbfe66666, 0x66666664, 0x3fd33333, 0x33333339},	/* -1.1659=f(-0.7, 0.3)*/
{64, 0,123,__LINE__, 0xbff1b6e1, 0x92ebbe42, 0xbfe66666, 0x66666664, 0x3fd66666, 0x6666666c},	/* -1.10715=f(-0.7, 0.35)*/
{64, 0,123,__LINE__, 0xbff0d38f, 0x2c5ba09c, 0xbfe66666, 0x66666664, 0x3fd99999, 0x9999999f},	/* -1.05165=f(-0.7, 0.4)*/
{63, 0,123,__LINE__, 0xbfeffb91, 0x1eacb04c, 0xbfe66666, 0x66666664, 0x3fdccccc, 0xccccccd2},	/* -0.999459=f(-0.7, 0.45)*/
{64, 0,123,__LINE__, 0xbfee6ae1, 0x355353cb, 0xbfe66666, 0x66666664, 0x3fe00000, 0x00000003},	/* -0.950547=f(-0.7, 0.5)*/
{64, 0,123,__LINE__, 0xbfecf457, 0xf0b26be3, 0xbfe66666, 0x66666664, 0x3fe19999, 0x9999999d},	/* -0.904827=f(-0.7, 0.55)*/
{64, 0,123,__LINE__, 0xbfeb96e5, 0xa78c5c4d, 0xbfe66666, 0x66666664, 0x3fe33333, 0x33333337},	/* -0.86217=f(-0.7, 0.6)*/
{64, 0,123,__LINE__, 0xbfea5140, 0x23a34d1b, 0xbfe66666, 0x66666664, 0x3fe4cccc, 0xccccccd1},	/* -0.822418=f(-0.7, 0.65)*/
{64, 0,123,__LINE__, 0xbfe921fb, 0x54442d13, 0xbfe66666, 0x66666664, 0x3fe66666, 0x6666666b},	/* -0.785398=f(-0.7, 0.7)*/
{63, 0,123,__LINE__, 0xbfe8079c, 0x6293aedb, 0xbfe66666, 0x66666664, 0x3fe80000, 0x00000005},	/* -0.750929=f(-0.7, 0.75)*/
{64, 0,123,__LINE__, 0xbfe700a7, 0xc578462f, 0xbfe66666, 0x66666664, 0x3fe99999, 0x9999999f},	/* -0.71883=f(-0.7, 0.8)*/
{64, 0,123,__LINE__, 0xbfe60bab, 0x2899969c, 0xbfe66666, 0x66666664, 0x3feb3333, 0x33333339},	/* -0.688924=f(-0.7, 0.85)*/
{64, 0,123,__LINE__, 0xbfe52744, 0x00eea726, 0xbfe66666, 0x66666664, 0x3feccccc, 0xccccccd3},	/* -0.661043=f(-0.7, 0.9)*/
{63, 0,123,__LINE__, 0xbfe45223, 0x9692c90a, 0xbfe66666, 0x66666664, 0x3fee6666, 0x6666666d},	/* -0.635027=f(-0.7, 0.95)*/
{64, 0,123,__LINE__, 0xc0048590, 0xb7aedd64, 0xbfe4cccc, 0xccccccca, 0xbff00000, 0x00000000},	/* -2.56522=f(-0.65, -1)*/
{64, 0,123,__LINE__, 0xc0045514, 0x33f00783, 0xbfe4cccc, 0xccccccca, 0xbfee6666, 0x66666666},	/* -2.54154=f(-0.65, -0.95)*/
{64, 0,123,__LINE__, 0xc00420fd, 0x07447553, 0xbfe4cccc, 0xccccccca, 0xbfeccccc, 0xcccccccc},	/* -2.51611=f(-0.65, -0.9)*/
{64, 0,123,__LINE__, 0xc003e8f3, 0xacb51f93, 0xbfe4cccc, 0xccccccca, 0xbfeb3333, 0x33333332},	/* -2.48875=f(-0.65, -0.85)*/
{63, 0,123,__LINE__, 0xc003ac98, 0xf27e8653, 0xbfe4cccc, 0xccccccca, 0xbfe99999, 0x99999998},	/* -2.45928=f(-0.65, -0.8)*/
{63, 0,123,__LINE__, 0xc0036b86, 0x251cd70f, 0xbfe4cccc, 0xccccccca, 0xbfe7ffff, 0xfffffffe},	/* -2.4275=f(-0.65, -0.75)*/
{64, 0,123,__LINE__, 0xc003254d, 0xb30ae9d4, 0xbfe4cccc, 0xccccccca, 0xbfe66666, 0x66666664},	/* -2.39321=f(-0.65, -0.7)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfe4cccc, 0xccccccca, 0xbfe4cccc, 0xccccccca},	/* -2.35619=f(-0.65, -0.65)*/
{64, 0,123,__LINE__, 0xc002879c, 0x26a5479d, 0xbfe4cccc, 0xccccccca, 0xbfe33333, 0x33333330},	/* -2.31622=f(-0.65, -0.6)*/
{64, 0,123,__LINE__, 0xc0022f36, 0x8bf3da20, 0xbfe4cccc, 0xccccccca, 0xbfe19999, 0x99999996},	/* -2.27305=f(-0.65, -0.55)*/
{64, 0,123,__LINE__, 0xc001cfdb, 0x0358ca07, 0xbfe4cccc, 0xccccccca, 0xbfdfffff, 0xfffffff9},	/* -2.22649=f(-0.65, -0.5)*/
{63, 0,123,__LINE__, 0xc0016925, 0x7715b183, 0xbfe4cccc, 0xccccccca, 0xbfdccccc, 0xccccccc6},	/* -2.17634=f(-0.65, -0.45)*/
{64, 0,123,__LINE__, 0xc000fac7, 0xc0872c2c, 0xbfe4cccc, 0xccccccca, 0xbfd99999, 0x99999993},	/* -2.12245=f(-0.65, -0.4)*/
{64, 0,123,__LINE__, 0xc0008495, 0x326f4bf1, 0xbfe4cccc, 0xccccccca, 0xbfd66666, 0x66666660},	/* -2.06474=f(-0.65, -0.35)*/
{63, 0,123,__LINE__, 0xc000068f, 0xdf56fb09, 0xbfe4cccc, 0xccccccca, 0xbfd33333, 0x3333332d},	/* -2.0032=f(-0.65, -0.3)*/
{63, 0,123,__LINE__, 0xbfff01ec, 0xffc750af, 0xbfe4cccc, 0xccccccca, 0xbfcfffff, 0xfffffff4},	/* -1.93797=f(-0.65, -0.25)*/
{63, 0,123,__LINE__, 0xbffde8a2, 0x2515088f, 0xbfe4cccc, 0xccccccca, 0xbfc99999, 0x9999998e},	/* -1.8693=f(-0.65, -0.2)*/
{64, 0,123,__LINE__, 0xbffcc2f3, 0x2876c449, 0xbfe4cccc, 0xccccccca, 0xbfc33333, 0x33333328},	/* -1.7976=f(-0.65, -0.15)*/
{63, 0,123,__LINE__, 0xbffb933b, 0xc05799bf, 0xbfe4cccc, 0xccccccca, 0xbfb99999, 0x99999983},	/* -1.72345=f(-0.65, -0.1)*/
{64, 0,123,__LINE__, 0xbffa5c70, 0x7de844b3, 0xbfe4cccc, 0xccccccca, 0xbfa99999, 0x9999996c},	/* -1.64757=f(-0.65, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d16, 0xbfe4cccc, 0xccccccca, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.65, 3.19189e-16)*/
{64, 0,123,__LINE__, 0xbff7e786, 0x2aa01579, 0xbfe4cccc, 0xccccccca, 0x3fa99999, 0x999999c8},	/* -1.49402=f(-0.65, 0.05)*/
{64, 0,123,__LINE__, 0xbff6b0ba, 0xe830c06d, 0xbfe4cccc, 0xccccccca, 0x3fb99999, 0x999999b1},	/* -1.41815=f(-0.65, 0.1)*/
{64, 0,123,__LINE__, 0xbff58103, 0x801195e3, 0xbfe4cccc, 0xccccccca, 0x3fc33333, 0x3333333f},	/* -1.344=f(-0.65, 0.15)*/
{64, 0,123,__LINE__, 0xbff45b54, 0x8373519d, 0xbfe4cccc, 0xccccccca, 0x3fc99999, 0x999999a6},	/* -1.2723=f(-0.65, 0.2)*/
{64, 0,123,__LINE__, 0xbff34209, 0xa8c1097d, 0xbfe4cccc, 0xccccccca, 0x3fd00000, 0x00000006},	/* -1.20362=f(-0.65, 0.25)*/
{64, 0,123,__LINE__, 0xbff236d6, 0xe9da641a, 0xbfe4cccc, 0xccccccca, 0x3fd33333, 0x33333339},	/* -1.13839=f(-0.65, 0.3)*/
{64, 0,123,__LINE__, 0xbff13acc, 0x43a9c24b, 0xbfe4cccc, 0xccccccca, 0x3fd66666, 0x6666666c},	/* -1.07685=f(-0.65, 0.35)*/
{64, 0,123,__LINE__, 0xbff04e67, 0x277a01d5, 0xbfe4cccc, 0xccccccca, 0x3fd99999, 0x9999999f},	/* -1.01914=f(-0.65, 0.4)*/
{64, 0,123,__LINE__, 0xbfeee357, 0x74b9ee4d, 0xbfe4cccc, 0xccccccca, 0x3fdccccc, 0xccccccd2},	/* -0.965252=f(-0.65, 0.45)*/
{64, 0,123,__LINE__, 0xbfed4881, 0x43ad8c3f, 0xbfe4cccc, 0xccccccca, 0x3fe00000, 0x00000003},	/* -0.915101=f(-0.65, 0.5)*/
{64, 0,123,__LINE__, 0xbfebcb13, 0x21414bdb, 0xbfe4cccc, 0xccccccca, 0x3fe19999, 0x9999999d},	/* -0.868539=f(-0.65, 0.55)*/
{63, 0,123,__LINE__, 0xbfea697c, 0xb67b95e8, 0xbfe4cccc, 0xccccccca, 0x3fe33333, 0x33333337},	/* -0.825377=f(-0.65, 0.6)*/
{64, 0,123,__LINE__, 0xbfe921fb, 0x54442d13, 0xbfe4cccc, 0xccccccca, 0x3fe4cccc, 0xccccccd1},	/* -0.785398=f(-0.65, 0.65)*/
{64, 0,123,__LINE__, 0xbfe7f2b6, 0x84e50d0b, 0xbfe4cccc, 0xccccccca, 0x3fe66666, 0x6666666b},	/* -0.748378=f(-0.65, 0.7)*/
{64, 0,123,__LINE__, 0xbfe6d9d4, 0xbc9d5822, 0xbfe4cccc, 0xccccccca, 0x3fe80000, 0x00000005},	/* -0.714091=f(-0.65, 0.75)*/
{64, 0,123,__LINE__, 0xbfe5d589, 0x87169b13, 0xbfe4cccc, 0xccccccca, 0x3fe99999, 0x9999999f},	/* -0.682317=f(-0.65, 0.8)*/
{64, 0,123,__LINE__, 0xbfe4e41e, 0x9e3c3610, 0xbfe4cccc, 0xccccccca, 0x3feb3333, 0x33333339},	/* -0.652847=f(-0.65, 0.85)*/
{64, 0,123,__LINE__, 0xbfe403f9, 0x33fedf12, 0xbfe4cccc, 0xccccccca, 0x3feccccc, 0xccccccd3},	/* -0.625485=f(-0.65, 0.9)*/
{64, 0,123,__LINE__, 0xbfe3339c, 0x81509652, 0xbfe4cccc, 0xccccccca, 0x3fee6666, 0x6666666d},	/* -0.60005=f(-0.65, 0.95)*/
{63, 0,123,__LINE__, 0xc004cf33, 0xdec5e9e1, 0xbfe33333, 0x33333330, 0xbff00000, 0x00000000},	/* -2.60117=f(-0.6, -1)*/
{63, 0,123,__LINE__, 0xc004a04f, 0x5f80df4d, 0xbfe33333, 0x33333330, 0xbfee6666, 0x66666666},	/* -2.57828=f(-0.6, -0.95)*/
{63, 0,123,__LINE__, 0xc0046dc0, 0x9ec29433, 0xbfe33333, 0x33333330, 0xbfeccccc, 0xcccccccc},	/* -2.55359=f(-0.6, -0.9)*/
{64, 0,123,__LINE__, 0xc0043726, 0xeb5fa0c4, 0xbfe33333, 0x33333330, 0xbfeb3333, 0x33333332},	/* -2.52693=f(-0.6, -0.85)*/
{64, 0,123,__LINE__, 0xc003fc17, 0x6b7a8560, 0xbfe33333, 0x33333330, 0xbfe99999, 0x99999998},	/* -2.49809=f(-0.6, -0.8)*/
{64, 0,123,__LINE__, 0xc003bc1c, 0xc0033274, 0xbfe33333, 0x33333330, 0xbfe7ffff, 0xfffffffe},	/* -2.46685=f(-0.6, -0.75)*/
{64, 0,123,__LINE__, 0xc00376b7, 0x14052da1, 0xbfe33333, 0x33333330, 0xbfe66666, 0x66666664},	/* -2.43297=f(-0.6, -0.7)*/
{64, 0,123,__LINE__, 0xc0032b5c, 0xd7c0fc08, 0xbfe33333, 0x33333330, 0xbfe4cccc, 0xccccccca},	/* -2.39617=f(-0.6, -0.65)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfe33333, 0x33333330, 0xbfe33333, 0x33333330},	/* -2.35619=f(-0.6, -0.6)*/
{64, 0,123,__LINE__, 0xc002807f, 0xb6bd9fb0, 0xbfe33333, 0x33333330, 0xbfe19999, 0x99999996},	/* -2.31274=f(-0.6, -0.55)*/
{63, 0,123,__LINE__, 0xc0021fd0, 0x9b1e712f, 0xbfe33333, 0x33333330, 0xbfdfffff, 0xfffffff9},	/* -2.26553=f(-0.6, -0.5)*/
{64, 0,123,__LINE__, 0xc001b6e1, 0x92ebbe44, 0xbfe33333, 0x33333330, 0xbfdccccc, 0xccccccc6},	/* -2.2143=f(-0.6, -0.45)*/
{64, 0,123,__LINE__, 0xc0014538, 0x5fa3af71, 0xbfe33333, 0x33333330, 0xbfd99999, 0x99999993},	/* -2.1588=f(-0.6, -0.4)*/
{63, 0,123,__LINE__, 0xc000ca7c, 0xc2d0d7fd, 0xbfe33333, 0x33333330, 0xbfd66666, 0x66666660},	/* -2.09887=f(-0.6, -0.35)*/
{64, 0,123,__LINE__, 0xc000468a, 0x8ace4df6, 0xbfe33333, 0x33333330, 0xbfd33333, 0x3333332d},	/* -2.03444=f(-0.6, -0.3)*/
{64, 0,123,__LINE__, 0xbfff730b, 0xd281f69a, 0xbfe33333, 0x33333330, 0xbfcfffff, 0xfffffff4},	/* -1.96559=f(-0.6, -0.25)*/
{63, 0,123,__LINE__, 0xbffe47df, 0x3d0dd4cf, 0xbfe33333, 0x33333330, 0xbfc99999, 0x9999998e},	/* -1.89255=f(-0.6, -0.2)*/
{63, 0,123,__LINE__, 0xbffd0d6a, 0x1369bd32, 0xbfe33333, 0x33333330, 0xbfc33333, 0x33333328},	/* -1.81577=f(-0.6, -0.15)*/
{63, 0,123,__LINE__, 0xbffbc66e, 0x44cbc072, 0xbfe33333, 0x33333330, 0xbfb99999, 0x99999983},	/* -1.73595=f(-0.6, -0.1)*/
{63, 0,123,__LINE__, 0xbffa7687, 0x3ac2bc7a, 0xbfe33333, 0x33333330, 0xbfa99999, 0x9999996c},	/* -1.65394=f(-0.6, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d16, 0xbfe33333, 0x33333330, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.6, 3.19189e-16)*/
{64, 0,123,__LINE__, 0xbff7cd6f, 0x6dc59db2, 0xbfe33333, 0x33333330, 0x3fa99999, 0x999999c8},	/* -1.48766=f(-0.6, 0.05)*/
{64, 0,123,__LINE__, 0xbff67d88, 0x63bc99ba, 0xbfe33333, 0x33333330, 0x3fb99999, 0x999999b1},	/* -1.40565=f(-0.6, 0.1)*/
{64, 0,123,__LINE__, 0xbff5368c, 0x951e9cfa, 0xbfe33333, 0x33333330, 0x3fc33333, 0x3333333f},	/* -1.32582=f(-0.6, 0.15)*/
{64, 0,123,__LINE__, 0xbff3fc17, 0x6b7a855d, 0xbfe33333, 0x33333330, 0x3fc99999, 0x999999a6},	/* -1.24905=f(-0.6, 0.2)*/
{64, 0,123,__LINE__, 0xbff2d0ea, 0xd6066392, 0xbfe33333, 0x33333330, 0x3fd00000, 0x00000006},	/* -1.17601=f(-0.6, 0.25)*/
{64, 0,123,__LINE__, 0xbff1b6e1, 0x92ebbe41, 0xbfe33333, 0x33333330, 0x3fd33333, 0x33333339},	/* -1.10715=f(-0.6, 0.3)*/
{64, 0,123,__LINE__, 0xbff0aefd, 0x22e6aa34, 0xbfe33333, 0x33333330, 0x3fd66666, 0x6666666c},	/* -1.04272=f(-0.6, 0.35)*/
{64, 0,123,__LINE__, 0xbfef730b, 0xd281f696, 0xbfe33333, 0x33333330, 0x3fd99999, 0x9999999f},	/* -0.982794=f(-0.6, 0.4)*/
{64, 0,123,__LINE__, 0xbfedac67, 0x0561bb4a, 0xbfe33333, 0x33333330, 0x3fdccccc, 0xccccccd2},	/* -0.927295=f(-0.6, 0.45)*/
{64, 0,123,__LINE__, 0xbfec08aa, 0xe496efa0, 0xbfe33333, 0x33333330, 0x3fe00000, 0x00000003},	/* -0.876058=f(-0.6, 0.5)*/
{64, 0,123,__LINE__, 0xbfea85ee, 0x761a359c, 0xbfe33333, 0x33333330, 0x3fe19999, 0x9999999d},	/* -0.828849=f(-0.6, 0.55)*/
{64, 0,123,__LINE__, 0xbfe921fb, 0x54442d12, 0xbfe33333, 0x33333330, 0x3fe33333, 0x33333337},	/* -0.785398=f(-0.6, 0.6)*/
{64, 0,123,__LINE__, 0xbfe7da79, 0xf20cc43d, 0xbfe33333, 0x33333330, 0x3fe4cccc, 0xccccccd1},	/* -0.745419=f(-0.6, 0.65)*/
{64, 0,123,__LINE__, 0xbfe6ad11, 0x00fbfdd9, 0xbfe33333, 0x33333330, 0x3fe66666, 0x6666666b},	/* -0.708626=f(-0.6, 0.7)*/
{64, 0,123,__LINE__, 0xbfe5977a, 0x5103ea8c, 0xbfe33333, 0x33333330, 0x3fe80000, 0x00000005},	/* -0.674741=f(-0.6, 0.75)*/
{64, 0,123,__LINE__, 0xbfe4978f, 0xa3269edb, 0xbfe33333, 0x33333330, 0x3fe99999, 0x9999999f},	/* -0.643501=f(-0.6, 0.8)*/
{64, 0,123,__LINE__, 0xbfe3ab51, 0xa392314e, 0xbfe33333, 0x33333330, 0x3feb3333, 0x33333339},	/* -0.614663=f(-0.6, 0.85)*/
{64, 0,123,__LINE__, 0xbfe2d0ea, 0xd6066390, 0xbfe33333, 0x33333330, 0x3feccccc, 0xccccccd3},	/* -0.588003=f(-0.6, 0.9)*/
{64, 0,123,__LINE__, 0xbfe206af, 0xd30d372c, 0xbfe33333, 0x33333330, 0x3fee6666, 0x6666666d},	/* -0.563316=f(-0.6, 0.95)*/
{64, 0,123,__LINE__, 0xc0051c28, 0xaaf491e0, 0xbfe19999, 0x99999996, 0xbff00000, 0x00000000},	/* -2.63875=f(-0.55, -1)*/
{64, 0,123,__LINE__, 0xc004ef33, 0x3421a553, 0xbfe19999, 0x99999996, 0xbfee6666, 0x66666666},	/* -2.6168=f(-0.55, -0.95)*/
{64, 0,123,__LINE__, 0xc004be8d, 0x75c60da4, 0xbfe19999, 0x99999996, 0xbfeccccc, 0xcccccccc},	/* -2.59304=f(-0.55, -0.9)*/
{63, 0,123,__LINE__, 0xc00489ce, 0x32c7e50d, 0xbfe19999, 0x99999996, 0xbfeb3333, 0x33333332},	/* -2.56729=f(-0.55, -0.85)*/
{64, 0,123,__LINE__, 0xc004507f, 0x4d109f2a, 0xbfe19999, 0x99999996, 0xbfe99999, 0x99999998},	/* -2.53931=f(-0.55, -0.8)*/
{64, 0,123,__LINE__, 0xc004121c, 0xb53cd827, 0xbfe19999, 0x99999996, 0xbfe7ffff, 0xfffffffe},	/* -2.50884=f(-0.55, -0.75)*/
{64, 0,123,__LINE__, 0xc003ce13, 0xa64eb186, 0xbfe19999, 0x99999996, 0xbfe66666, 0x66666664},	/* -2.47562=f(-0.55, -0.7)*/
{64, 0,123,__LINE__, 0xc00383c2, 0x72726984, 0xbfe19999, 0x99999996, 0xbfe4cccc, 0xccccccca},	/* -2.43934=f(-0.55, -0.65)*/
{64, 0,123,__LINE__, 0xc0033279, 0x47a8a3f5, 0xbfe19999, 0x99999996, 0xbfe33333, 0x33333330},	/* -2.39965=f(-0.55, -0.6)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfe19999, 0x99999996, 0xbfe19999, 0x99999996},	/* -2.35619=f(-0.55, -0.55)*/
{64, 0,123,__LINE__, 0xc0027809, 0x3f2fcc25, 0xbfe19999, 0x99999996, 0xbfdfffff, 0xfffffff9},	/* -2.30861=f(-0.55, -0.5)*/
{64, 0,123,__LINE__, 0xc0020d5d, 0x6b1c0b70, 0xbfe19999, 0x99999996, 0xbfdccccc, 0xccccccc6},	/* -2.25653=f(-0.55, -0.45)*/
{64, 0,123,__LINE__, 0xc00198c4, 0x031217a4, 0xbfe19999, 0x99999996, 0xbfd99999, 0x99999993},	/* -2.19959=f(-0.55, -0.4)*/
{64, 0,123,__LINE__, 0xc00119a6, 0xfe19b276, 0xbfe19999, 0x99999996, 0xbfd66666, 0x66666660},	/* -2.13753=f(-0.55, -0.35)*/
{64, 0,123,__LINE__, 0xc0008fa7, 0x2899ef94, 0xbfe19999, 0x99999996, 0xbfd33333, 0x3333332d},	/* -2.07014=f(-0.55, -0.3)*/
{63, 0,123,__LINE__, 0xbffff572, 0xaded0be7, 0xbfe19999, 0x99999996, 0xbfcfffff, 0xfffffff4},	/* -1.99742=f(-0.55, -0.25)*/
{63, 0,123,__LINE__, 0xbffeb68c, 0x3ba726dc, 0xbfe19999, 0x99999996, 0xbfc99999, 0x9999998e},	/* -1.91957=f(-0.55, -0.2)*/
{63, 0,123,__LINE__, 0xbffd648c, 0xd67db729, 0xbfe19999, 0x99999996, 0xbfc33333, 0x33333328},	/* -1.83705=f(-0.55, -0.15)*/
{63, 0,123,__LINE__, 0xbffc02a9, 0x647f0db3, 0xbfe19999, 0x99999996, 0xbfb99999, 0x99999983},	/* -1.75065=f(-0.55, -0.1)*/
{64, 0,123,__LINE__, 0xbffa9553, 0x1c6d8e5d, 0xbfe19999, 0x99999996, 0xbfa99999, 0x9999996c},	/* -1.66146=f(-0.55, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d16, 0xbfe19999, 0x99999996, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.55, 3.19189e-16)*/
{64, 0,123,__LINE__, 0xbff7aea3, 0x8c1acbce, 0xbfe19999, 0x99999996, 0x3fa99999, 0x999999c8},	/* -1.48014=f(-0.55, 0.05)*/
{64, 0,123,__LINE__, 0xbff6414d, 0x44094c78, 0xbfe19999, 0x99999996, 0x3fb99999, 0x999999b1},	/* -1.39094=f(-0.55, 0.1)*/
{63, 0,123,__LINE__, 0xbff4df69, 0xd20aa303, 0xbfe19999, 0x99999996, 0x3fc33333, 0x3333333f},	/* -1.30454=f(-0.55, 0.15)*/
{64, 0,123,__LINE__, 0xbff38d6a, 0x6ce1334f, 0xbfe19999, 0x99999996, 0x3fc99999, 0x999999a6},	/* -1.22203=f(-0.55, 0.2)*/
{64, 0,123,__LINE__, 0xbff24e83, 0xfa9b4e45, 0xbfe19999, 0x99999996, 0x3fd00000, 0x00000006},	/* -1.14417=f(-0.55, 0.25)*/
{64, 0,123,__LINE__, 0xbff124a8, 0x57547b04, 0xbfe19999, 0x99999996, 0x3fd33333, 0x33333339},	/* -1.07145=f(-0.55, 0.3)*/
{64, 0,123,__LINE__, 0xbff010a8, 0xac54f541, 0xbfe19999, 0x99999996, 0x3fd66666, 0x6666666c},	/* -1.00407=f(-0.55, 0.35)*/
{64, 0,123,__LINE__, 0xbfee24dd, 0x44c855cb, 0xbfe19999, 0x99999996, 0x3fd99999, 0x9999999f},	/* -0.942=f(-0.55, 0.4)*/
{64, 0,123,__LINE__, 0xbfec5277, 0xa4a0869c, 0xbfe19999, 0x99999996, 0x3fdccccc, 0xccccccd2},	/* -0.885067=f(-0.55, 0.45)*/
{64, 0,123,__LINE__, 0xbfeaa7c8, 0x545183c7, 0xbfe19999, 0x99999996, 0x3fe00000, 0x00000003},	/* -0.832981=f(-0.55, 0.5)*/
{64, 0,123,__LINE__, 0xbfe921fb, 0x54442d12, 0xbfe19999, 0x99999996, 0x3fe19999, 0x9999999d},	/* -0.785398=f(-0.55, 0.55)*/
{63, 0,123,__LINE__, 0xbfe7be08, 0x326e2488, 0xbfe19999, 0x99999996, 0x3fe33333, 0x33333337},	/* -0.741947=f(-0.55, 0.6)*/
{64, 0,123,__LINE__, 0xbfe678e3, 0x87470e4a, 0xbfe19999, 0x99999996, 0x3fe4cccc, 0xccccccd1},	/* -0.702257=f(-0.55, 0.65)*/
{64, 0,123,__LINE__, 0xbfe54f9e, 0xb7d5ee43, 0xbfe19999, 0x99999996, 0x3fe66666, 0x6666666b},	/* -0.665969=f(-0.55, 0.7)*/
{64, 0,123,__LINE__, 0xbfe43f7a, 0x7c1d53c1, 0xbfe19999, 0x99999996, 0x3fe80000, 0x00000005},	/* -0.632749=f(-0.55, 0.75)*/
{64, 0,123,__LINE__, 0xbfe345f0, 0x1cce37b5, 0xbfe19999, 0x99999996, 0x3fe99999, 0x9999999f},	/* -0.602287=f(-0.55, 0.8)*/
{64, 0,123,__LINE__, 0xbfe260b4, 0x85f12028, 0xbfe19999, 0x99999996, 0x3feb3333, 0x33333339},	/* -0.574305=f(-0.55, 0.85)*/
{64, 0,123,__LINE__, 0xbfe18db7, 0x79f87dcf, 0xbfe19999, 0x99999996, 0x3feccccc, 0xccccccd3},	/* -0.548549=f(-0.55, 0.9)*/
{64, 0,123,__LINE__, 0xbfe0cb20, 0x808a1f11, 0xbfe19999, 0x99999996, 0x3fee6666, 0x6666666d},	/* -0.524796=f(-0.55, 0.95)*/
{64, 0,123,__LINE__, 0xc0056c6e, 0x7397f5af, 0xbfdfffff, 0xfffffff9, 0xbff00000, 0x00000000},	/* -2.67795=f(-0.5, -1)*/
{64, 0,123,__LINE__, 0xc00541c5, 0x5d5d64c1, 0xbfdfffff, 0xfffffff9, 0xbfee6666, 0x66666666},	/* -2.65711=f(-0.5, -0.95)*/
{64, 0,123,__LINE__, 0xc0051371, 0xab22738d, 0xbfdfffff, 0xfffffff9, 0xbfeccccc, 0xcccccccc},	/* -2.63449=f(-0.5, -0.9)*/
{64, 0,123,__LINE__, 0xc004e102, 0xc80931dc, 0xbfdfffff, 0xfffffff9, 0xbfeb3333, 0x33333332},	/* -2.60987=f(-0.5, -0.85)*/
{64, 0,123,__LINE__, 0xc004a9f8, 0x694c6d6c, 0xbfdfffff, 0xfffffff9, 0xbfe99999, 0x99999998},	/* -2.58299=f(-0.5, -0.8)*/
{63, 0,123,__LINE__, 0xc0046dc0, 0x9ec29433, 0xbfdfffff, 0xfffffff9, 0xbfe7ffff, 0xfffffffe},	/* -2.55359=f(-0.5, -0.75)*/
{64, 0,123,__LINE__, 0xc0042bb5, 0xf776eb80, 0xbfdfffff, 0xfffffff9, 0xbfe66666, 0x66666664},	/* -2.52134=f(-0.5, -0.7)*/
{64, 0,123,__LINE__, 0xc003e31d, 0xfb0d799d, 0xbfdfffff, 0xfffffff9, 0xbfe4cccc, 0xccccccca},	/* -2.4859=f(-0.5, -0.65)*/
{64, 0,123,__LINE__, 0xc0039328, 0x6347d276, 0xbfdfffff, 0xfffffff9, 0xbfe33333, 0x33333330},	/* -2.44685=f(-0.5, -0.6)*/
{64, 0,123,__LINE__, 0xc0033aef, 0xbf36777f, 0xbfdfffff, 0xfffffff9, 0xbfe19999, 0x99999996},	/* -2.40378=f(-0.5, -0.55)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfdfffff, 0xfffffff9, 0xbfdfffff, 0xfffffff9},	/* -2.35619=f(-0.5, -0.5)*/
{64, 0,123,__LINE__, 0xc0026dcb, 0xd423977c, 0xbfdfffff, 0xfffffff9, 0xbfdccccc, 0xccccccc6},	/* -2.30361=f(-0.5, -0.45)*/
{63, 0,123,__LINE__, 0xc001f6dc, 0x3e631131, 0xbfdfffff, 0xfffffff9, 0xbfd99999, 0x99999993},	/* -2.24554=f(-0.5, -0.4)*/
{64, 0,123,__LINE__, 0xc00173c1, 0xf5810bb7, 0xbfdfffff, 0xfffffff9, 0xbfd66666, 0x66666660},	/* -2.18152=f(-0.5, -0.35)*/
{64, 0,123,__LINE__, 0xc000e3c5, 0x1fa059c4, 0xbfdfffff, 0xfffffff9, 0xbfd33333, 0x3333332d},	/* -2.11122=f(-0.5, -0.3)*/
{64, 0,123,__LINE__, 0xc000468a, 0x8ace4df6, 0xbfdfffff, 0xfffffff9, 0xbfcfffff, 0xfffffff4},	/* -2.03444=f(-0.5, -0.25)*/
{64, 0,123,__LINE__, 0xbfff3889, 0x2f1e0c87, 0xbfdfffff, 0xfffffff9, 0xbfc99999, 0x9999998e},	/* -1.9513=f(-0.5, -0.2)*/
{63, 0,123,__LINE__, 0xbffdcbc9, 0xedcbd8d8, 0xbfdfffff, 0xfffffff9, 0xbfc33333, 0x33333328},	/* -1.86225=f(-0.5, -0.15)*/
{64, 0,123,__LINE__, 0xbffc4a83, 0x936311d8, 0xbfdfffff, 0xfffffff9, 0xbfb99999, 0x99999983},	/* -1.76819=f(-0.5, -0.1)*/
{64, 0,123,__LINE__, 0xbffaba39, 0x7c7259db, 0xbfdfffff, 0xfffffff9, 0xbfa99999, 0x9999996c},	/* -1.67046=f(-0.5, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d15, 0xbfdfffff, 0xfffffff9, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.5, 3.19189e-16)*/
{64, 0,123,__LINE__, 0xbff789bd, 0x2c160050, 0xbfdfffff, 0xfffffff9, 0x3fa99999, 0x999999c8},	/* -1.47113=f(-0.5, 0.05)*/
{64, 0,123,__LINE__, 0xbff5f973, 0x15254853, 0xbfdfffff, 0xfffffff9, 0x3fb99999, 0x999999b1},	/* -1.3734=f(-0.5, 0.1)*/
{64, 0,123,__LINE__, 0xbff4782c, 0xbabc8153, 0xbfdfffff, 0xfffffff9, 0x3fc33333, 0x3333333f},	/* -1.27934=f(-0.5, 0.15)*/
{64, 0,123,__LINE__, 0xbff30b6d, 0x796a4da4, 0xbfdfffff, 0xfffffff9, 0x3fc99999, 0x999999a6},	/* -1.19029=f(-0.5, 0.2)*/
{64, 0,123,__LINE__, 0xbff1b6e1, 0x92ebbe41, 0xbfdfffff, 0xfffffff9, 0x3fd00000, 0x00000006},	/* -1.10715=f(-0.5, 0.25)*/
{64, 0,123,__LINE__, 0xbff07c6c, 0x6947a6a4, 0xbfdfffff, 0xfffffff9, 0x3fd33333, 0x33333339},	/* -1.03038=f(-0.5, 0.3)*/
{64, 0,123,__LINE__, 0xbfeeb8e5, 0x7b0c857c, 0xbfdfffff, 0xfffffff9, 0x3fd66666, 0x6666666c},	/* -0.96007=f(-0.5, 0.35)*/
{63, 0,123,__LINE__, 0xbfecac7c, 0x57846f98, 0xbfdfffff, 0xfffffff9, 0x3fd99999, 0x9999999f},	/* -0.896055=f(-0.5, 0.4)*/
{64, 0,123,__LINE__, 0xbfead0be, 0x0082566c, 0xbfdfffff, 0xfffffff9, 0x3fdccccc, 0xccccccd2},	/* -0.837981=f(-0.5, 0.45)*/
{64, 0,123,__LINE__, 0xbfe921fb, 0x54442d12, 0xbfdfffff, 0xfffffff9, 0x3fe00000, 0x00000003},	/* -0.785398=f(-0.5, 0.5)*/
{64, 0,123,__LINE__, 0xbfe79c2e, 0x5436d65d, 0xbfdfffff, 0xfffffff9, 0x3fe19999, 0x9999999d},	/* -0.737815=f(-0.5, 0.55)*/
{64, 0,123,__LINE__, 0xbfe63b4b, 0xc3f16a84, 0xbfdfffff, 0xfffffff9, 0x3fe33333, 0x33333337},	/* -0.694738=f(-0.5, 0.6)*/
{64, 0,123,__LINE__, 0xbfe4fb75, 0x64dacde6, 0xbfdfffff, 0xfffffff9, 0x3fe4cccc, 0xccccccd1},	/* -0.655696=f(-0.5, 0.65)*/
{63, 0,123,__LINE__, 0xbfe3d915, 0x7335065b, 0xbfdfffff, 0xfffffff9, 0x3fe66666, 0x6666666b},	/* -0.620249=f(-0.5, 0.7)*/
{64, 0,123,__LINE__, 0xbfe2d0ea, 0xd606638f, 0xbfdfffff, 0xfffffff9, 0x3fe80000, 0x00000005},	/* -0.588003=f(-0.5, 0.75)*/
{63, 0,123,__LINE__, 0xbfe1e00b, 0xabdefeae, 0xbfdfffff, 0xfffffff9, 0x3fe99999, 0x9999999f},	/* -0.558599=f(-0.5, 0.8)*/
{64, 0,123,__LINE__, 0xbfe103e2, 0x30ebeced, 0xbfdfffff, 0xfffffff9, 0x3feb3333, 0x33333339},	/* -0.531724=f(-0.5, 0.85)*/
{64, 0,123,__LINE__, 0xbfe03a26, 0xa486e62b, 0xbfdfffff, 0xfffffff9, 0x3feccccc, 0xccccccd3},	/* -0.507099=f(-0.5, 0.9)*/
{64, 0,123,__LINE__, 0xbfdf01af, 0xb73642b2, 0xbfdfffff, 0xfffffff9, 0x3fee6666, 0x6666666d},	/* -0.484478=f(-0.5, 0.95)*/
{63, 0,123,__LINE__, 0xc005bffa, 0x17065de1, 0xbfdccccc, 0xccccccc6, 0xbff00000, 0x00000000},	/* -2.71874=f(-0.45, -1)*/
{64, 0,123,__LINE__, 0xc00597ff, 0xd521f2aa, 0xbfdccccc, 0xccccccc6, 0xbfee6666, 0x66666666},	/* -2.69922=f(-0.45, -0.95)*/
{64, 0,123,__LINE__, 0xc0056c6e, 0x7397f5af, 0xbfdccccc, 0xccccccc6, 0xbfeccccc, 0xcccccccc},	/* -2.67795=f(-0.45, -0.9)*/
{64, 0,123,__LINE__, 0xc0053ccf, 0xe79b8f8f, 0xbfdccccc, 0xccccccc6, 0xbfeb3333, 0x33333332},	/* -2.65469=f(-0.45, -0.85)*/
{64, 0,123,__LINE__, 0xc005089b, 0xaf0d60e5, 0xbfdccccc, 0xccccccc6, 0xbfe99999, 0x99999998},	/* -2.6292=f(-0.45, -0.8)*/
{63, 0,123,__LINE__, 0xc004cf33, 0xdec5e9e1, 0xbfdccccc, 0xccccccc6, 0xbfe7ffff, 0xfffffffe},	/* -2.60117=f(-0.45, -0.75)*/
{64, 0,123,__LINE__, 0xc0048fe1, 0xf1cd42a1, 0xbfdccccc, 0xccccccc6, 0xbfe66666, 0x66666664},	/* -2.57026=f(-0.45, -0.7)*/
{64, 0,123,__LINE__, 0xc00449d3, 0x87509221, 0xbfdccccc, 0xccccccc6, 0xbfe4cccc, 0xccccccca},	/* -2.53605=f(-0.45, -0.65)*/
{64, 0,123,__LINE__, 0xc003fc17, 0x6b7a8560, 0xbfdccccc, 0xccccccc6, 0xbfe33333, 0x33333330},	/* -2.49809=f(-0.45, -0.6)*/
{64, 0,123,__LINE__, 0xc003a59b, 0x934a3835, 0xbfdccccc, 0xccccccc6, 0xbfe19999, 0x99999996},	/* -2.45586=f(-0.45, -0.55)*/
{64, 0,123,__LINE__, 0xc003452d, 0x2a42ac29, 0xbfdccccc, 0xccccccc6, 0xbfdfffff, 0xfffffff9},	/* -2.40878=f(-0.45, -0.5)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfdccccc, 0xccccccc6, 0xbfdccccc, 0xccccccc6},	/* -2.35619=f(-0.45, -0.45)*/
{64, 0,123,__LINE__, 0xc0026127, 0x862b05f6, 0xbfdccccc, 0xccccccc6, 0xbfd99999, 0x99999993},	/* -2.29744=f(-0.45, -0.4)*/
{63, 0,123,__LINE__, 0xc001dace, 0xaa5dc057, 0xbfdccccc, 0xccccccc6, 0xbfd66666, 0x66666660},	/* -2.23184=f(-0.45, -0.35)*/
{64, 0,123,__LINE__, 0xc0014538, 0x5fa3af71, 0xbfdccccc, 0xccccccc6, 0xbfd33333, 0x3333332d},	/* -2.1588=f(-0.45, -0.3)*/
{64, 0,123,__LINE__, 0xc0009f87, 0x5343d018, 0xbfdccccc, 0xccccccc6, 0xbfcfffff, 0xfffffff4},	/* -2.07789=f(-0.45, -0.25)*/
{64, 0,123,__LINE__, 0xbfffd307, 0x52e3200b, 0xbfdccccc, 0xccccccc6, 0xbfc99999, 0x9999998e},	/* -1.98902=f(-0.45, -0.2)*/
{64, 0,123,__LINE__, 0xbffe47df, 0x3d0dd4cf, 0xbfdccccc, 0xccccccc6, 0xbfc33333, 0x33333328},	/* -1.89255=f(-0.45, -0.15)*/
{63, 0,123,__LINE__, 0xbffca1a6, 0x56770bce, 0xbfdccccc, 0xccccccc6, 0xbfb99999, 0x99999983},	/* -1.78947=f(-0.45, -0.1)*/
{64, 0,123,__LINE__, 0xbffae73b, 0xd5e44e59, 0xbfdccccc, 0xccccccc6, 0xbfa99999, 0x9999996c},	/* -1.68145=f(-0.45, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d15, 0xbfdccccc, 0xccccccc6, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.45, 3.19189e-16)*/
{64, 0,123,__LINE__, 0xbff75cba, 0xd2a40bd2, 0xbfdccccc, 0xccccccc6, 0x3fa99999, 0x999999c8},	/* -1.46014=f(-0.45, 0.05)*/
{64, 0,123,__LINE__, 0xbff5a250, 0x52114e5c, 0xbfdccccc, 0xccccccc6, 0x3fb99999, 0x999999b1},	/* -1.35213=f(-0.45, 0.1)*/
{64, 0,123,__LINE__, 0xbff3fc17, 0x6b7a855c, 0xbfdccccc, 0xccccccc6, 0x3fc33333, 0x3333333f},	/* -1.24905=f(-0.45, 0.15)*/
{64, 0,123,__LINE__, 0xbff270ef, 0x55a53a20, 0xbfdccccc, 0xccccccc6, 0x3fc99999, 0x999999a6},	/* -1.15257=f(-0.45, 0.2)*/
{64, 0,123,__LINE__, 0xbff104e8, 0x0200b9fc, 0xbfdccccc, 0xccccccc6, 0x3fd00000, 0x00000006},	/* -1.0637=f(-0.45, 0.25)*/
{64, 0,123,__LINE__, 0xbfef730b, 0xd281f693, 0xbfdccccc, 0xccccccc6, 0x3fd33333, 0x33333339},	/* -0.982794=f(-0.45, 0.3)*/
{63, 0,123,__LINE__, 0xbfed1cb2, 0xa799b2fe, 0xbfdccccc, 0xccccccc6, 0x3fd66666, 0x6666666c},	/* -0.909753=f(-0.45, 0.35)*/
{63, 0,123,__LINE__, 0xbfeb034f, 0x38649c80, 0xbfdccccc, 0xccccccc6, 0x3fd99999, 0x9999999f},	/* -0.844154=f(-0.45, 0.4)*/
{64, 0,123,__LINE__, 0xbfe921fb, 0x54442d12, 0xbfdccccc, 0xccccccc6, 0x3fdccccc, 0xccccccd2},	/* -0.785398=f(-0.45, 0.45)*/
{64, 0,123,__LINE__, 0xbfe77338, 0xa80603b8, 0xbfdccccc, 0xccccccc6, 0x3fe00000, 0x00000003},	/* -0.732815=f(-0.45, 0.5)*/
{64, 0,123,__LINE__, 0xbfe5f17f, 0x03e7d388, 0xbfdccccc, 0xccccccc6, 0x3fe19999, 0x9999999d},	/* -0.68573=f(-0.45, 0.55)*/
{63, 0,123,__LINE__, 0xbfe4978f, 0xa3269eda, 0xbfdccccc, 0xccccccc6, 0x3fe33333, 0x33333337},	/* -0.643501=f(-0.45, 0.6)*/
{64, 0,123,__LINE__, 0xbfe3609f, 0x33ce6bd8, 0xbfdccccc, 0xccccccc6, 0x3fe4cccc, 0xccccccd1},	/* -0.605545=f(-0.45, 0.65)*/
{64, 0,123,__LINE__, 0xbfe24865, 0x89dba9d9, 0xbfdccccc, 0xccccccc6, 0x3fe66666, 0x6666666b},	/* -0.571337=f(-0.45, 0.7)*/
{64, 0,123,__LINE__, 0xbfe14b1d, 0xd5f90cdb, 0xbfdccccc, 0xccccccc6, 0x3fe80000, 0x00000005},	/* -0.54042=f(-0.45, 0.75)*/
{64, 0,123,__LINE__, 0xbfe0657e, 0x94db30ca, 0xbfdccccc, 0xccccccc6, 0x3fe99999, 0x9999999f},	/* -0.512389=f(-0.45, 0.8)*/
{63, 0,123,__LINE__, 0xbfdf295b, 0x6544ec44, 0xbfdccccc, 0xccccccc6, 0x3feb3333, 0x33333339},	/* -0.486899=f(-0.45, 0.85)*/
{64, 0,123,__LINE__, 0xbfddac67, 0x0561bb44, 0xbfdccccc, 0xccccccc6, 0x3feccccc, 0xccccccd3},	/* -0.463648=f(-0.45, 0.9)*/
{64, 0,123,__LINE__, 0xbfdc4fdb, 0xf911d369, 0xbfdccccc, 0xccccccc6, 0x3fee6666, 0x6666666d},	/* -0.442374=f(-0.45, 0.95)*/
{64, 0,123,__LINE__, 0xc00616b4, 0x66d73d61, 0xbfd99999, 0x99999993, 0xbff00000, 0x00000000},	/* -2.76109=f(-0.4, -1)*/
{63, 0,123,__LINE__, 0xc005f1ce, 0xcb0d4d6f, 0xbfd99999, 0x99999993, 0xbfee6666, 0x66666666},	/* -2.74307=f(-0.4, -0.95)*/
{64, 0,123,__LINE__, 0xc005c975, 0x54f4b39f, 0xbfd99999, 0x99999993, 0xbfeccccc, 0xcccccccc},	/* -2.72337=f(-0.4, -0.9)*/
{64, 0,123,__LINE__, 0xc0059d2f, 0x241f85a8, 0xbfd99999, 0x99999993, 0xbfeb3333, 0x33333332},	/* -2.70175=f(-0.4, -0.85)*/
{64, 0,123,__LINE__, 0xc0056c6e, 0x7397f5af, 0xbfd99999, 0x99999993, 0xbfe99999, 0x99999998},	/* -2.67795=f(-0.4, -0.8)*/
{64, 0,123,__LINE__, 0xc005368c, 0x951e9cfd, 0xbfd99999, 0x99999993, 0xbfe7ffff, 0xfffffffe},	/* -2.65164=f(-0.4, -0.75)*/
{64, 0,123,__LINE__, 0xc004fac5, 0x404fe6dc, 0xbfd99999, 0x99999993, 0xbfe66666, 0x66666664},	/* -2.62245=f(-0.4, -0.7)*/
{64, 0,123,__LINE__, 0xc004b831, 0x3ddf1778, 0xbfd99999, 0x99999993, 0xbfe4cccc, 0xccccccca},	/* -2.58994=f(-0.4, -0.65)*/
{64, 0,123,__LINE__, 0xc0046dc0, 0x9ec29433, 0xbfd99999, 0x99999993, 0xbfe33333, 0x33333330},	/* -2.55359=f(-0.4, -0.6)*/
{63, 0,123,__LINE__, 0xc0041a34, 0xfb542c01, 0xbfd99999, 0x99999993, 0xbfe19999, 0x99999996},	/* -2.5128=f(-0.4, -0.55)*/
{64, 0,123,__LINE__, 0xc003bc1c, 0xc0033274, 0xbfd99999, 0x99999993, 0xbfdfffff, 0xfffffff9},	/* -2.46685=f(-0.4, -0.5)*/
{64, 0,123,__LINE__, 0xc00351d1, 0x783b3dae, 0xbfd99999, 0x99999993, 0xbfdccccc, 0xccccccc6},	/* -2.41495=f(-0.4, -0.45)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfd99999, 0x99999993, 0xbfd99999, 0x99999993},	/* -2.35619=f(-0.4, -0.4)*/
{64, 0,123,__LINE__, 0xc0025127, 0x9b802819, 0xbfd99999, 0x99999993, 0xbfd66666, 0x66666660},	/* -2.28963=f(-0.4, -0.35)*/
{64, 0,123,__LINE__, 0xc001b6e1, 0x92ebbe44, 0xbfd99999, 0x99999993, 0xbfd33333, 0x3333332d},	/* -2.2143=f(-0.4, -0.3)*/
{64, 0,123,__LINE__, 0xc0010900, 0x9519d639, 0xbfd99999, 0x99999993, 0xbfcfffff, 0xfffffff4},	/* -2.1294=f(-0.4, -0.25)*/
{63, 0,123,__LINE__, 0xc000468a, 0x8ace4df5, 0xbfd99999, 0x99999993, 0xbfc99999, 0x9999998e},	/* -2.03444=f(-0.4, -0.2)*/
{64, 0,123,__LINE__, 0xbffedf81, 0xa4bd64d3, 0xbfd99999, 0x99999993, 0xbfc33333, 0x33333328},	/* -1.92957=f(-0.4, -0.15)*/
{64, 0,123,__LINE__, 0xbffd0d6a, 0x1369bd32, 0xbfd99999, 0x99999993, 0xbfb99999, 0x99999983},	/* -1.81577=f(-0.4, -0.1)*/
{63, 0,123,__LINE__, 0xbffb1f56, 0xfdeef00c, 0xbfd99999, 0x99999993, 0xbfa99999, 0x9999996c},	/* -1.69515=f(-0.4, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d15, 0xbfd99999, 0x99999993, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.4, 3.19189e-16)*/
{64, 0,123,__LINE__, 0xbff7249f, 0xaa996a1d, 0xbfd99999, 0x99999993, 0x3fa99999, 0x999999c8},	/* -1.44644=f(-0.4, 0.05)*/
{64, 0,123,__LINE__, 0xbff5368c, 0x951e9cf8, 0xbfd99999, 0x99999993, 0x3fb99999, 0x999999b1},	/* -1.32582=f(-0.4, 0.1)*/
{64, 0,123,__LINE__, 0xbff36475, 0x03caf558, 0xbfd99999, 0x99999993, 0x3fc33333, 0x3333333f},	/* -1.21203=f(-0.4, 0.15)*/
{64, 0,123,__LINE__, 0xbff1b6e1, 0x92ebbe40, 0xbfd99999, 0x99999993, 0x3fc99999, 0x999999a6},	/* -1.10715=f(-0.4, 0.2)*/
{64, 0,123,__LINE__, 0xbff031f5, 0x7e54adba, 0xbfd99999, 0x99999993, 0x3fd00000, 0x00000006},	/* -1.0122=f(-0.4, 0.25)*/
{64, 0,123,__LINE__, 0xbfedac67, 0x0561bb47, 0xbfd99999, 0x99999993, 0x3fd33333, 0x33333339},	/* -0.927295=f(-0.4, 0.3)*/
{64, 0,123,__LINE__, 0xbfeb434e, 0xe31013f5, 0xbfd99999, 0x99999993, 0x3fd66666, 0x6666666c},	/* -0.851966=f(-0.4, 0.35)*/
{64, 0,123,__LINE__, 0xbfe921fb, 0x54442d11, 0xbfd99999, 0x99999993, 0x3fd99999, 0x9999999f},	/* -0.785398=f(-0.4, 0.4)*/
{64, 0,123,__LINE__, 0xbfe740a7, 0x7023bda2, 0xbfd99999, 0x99999993, 0x3fdccccc, 0xccccccd2},	/* -0.726642=f(-0.4, 0.45)*/
{64, 0,123,__LINE__, 0xbfe5977a, 0x5103ea8b, 0xbfd99999, 0x99999993, 0x3fe00000, 0x00000003},	/* -0.674741=f(-0.4, 0.5)*/
{64, 0,123,__LINE__, 0xbfe41f19, 0x63c00458, 0xbfd99999, 0x99999993, 0x3fe19999, 0x9999999d},	/* -0.628796=f(-0.4, 0.55)*/
{64, 0,123,__LINE__, 0xbfe2d0ea, 0xd606638f, 0xbfd99999, 0x99999993, 0x3fe33333, 0x33333337},	/* -0.588003=f(-0.4, 0.6)*/
{64, 0,123,__LINE__, 0xbfe1a728, 0x5994567c, 0xbfd99999, 0x99999993, 0x3fe4cccc, 0xccccccd1},	/* -0.551655=f(-0.4, 0.65)*/
{64, 0,123,__LINE__, 0xbfe09cd8, 0x4fd118ed, 0xbfd99999, 0x99999993, 0x3fe66666, 0x6666666b},	/* -0.519146=f(-0.4, 0.7)*/
{64, 0,123,__LINE__, 0xbfdf5b75, 0xf92c80d1, 0xbfd99999, 0x99999993, 0x3fe80000, 0x00000005},	/* -0.489957=f(-0.4, 0.75)*/
{64, 0,123,__LINE__, 0xbfddac67, 0x0561bb43, 0xbfd99999, 0x99999993, 0x3fe99999, 0x9999999f},	/* -0.463648=f(-0.4, 0.8)*/
{64, 0,123,__LINE__, 0xbfdc2661, 0x81253b7c, 0xbfd99999, 0x99999993, 0x3feb3333, 0x33333339},	/* -0.439843=f(-0.4, 0.85)*/
{64, 0,123,__LINE__, 0xbfdac42f, 0xfa7bcbc4, 0xbfd99999, 0x99999993, 0x3feccccc, 0xccccccd3},	/* -0.418224=f(-0.4, 0.9)*/
{64, 0,123,__LINE__, 0xbfd98164, 0x49b6fd49, 0xbfd99999, 0x99999993, 0x3fee6666, 0x6666666d},	/* -0.398522=f(-0.4, 0.95)*/
{64, 0,123,__LINE__, 0xc0067078, 0xc2eef45e, 0xbfd66666, 0x66666660, 0xbff00000, 0x00000000},	/* -2.80492=f(-0.35, -1)*/
{63, 0,123,__LINE__, 0xc0064f0e, 0xb4680651, 0xbfd66666, 0x66666660, 0xbfee6666, 0x66666666},	/* -2.7886=f(-0.35, -0.95)*/
{64, 0,123,__LINE__, 0xc0062a65, 0x7a259a4e, 0xbfd66666, 0x66666660, 0xbfeccccc, 0xcccccccc},	/* -2.7707=f(-0.35, -0.9)*/
{64, 0,123,__LINE__, 0xc0060204, 0xbe520694, 0xbfd66666, 0x66666660, 0xbfeb3333, 0x33333332},	/* -2.75099=f(-0.35, -0.85)*/
{64, 0,123,__LINE__, 0xc005d55d, 0x7bcaa899, 0xbfd66666, 0x66666660, 0xbfe99999, 0x99999998},	/* -2.72918=f(-0.35, -0.8)*/
{64, 0,123,__LINE__, 0xc005a3c4, 0xf2e49eb6, 0xbfd66666, 0x66666660, 0xbfe7ffff, 0xfffffffe},	/* -2.70497=f(-0.35, -0.75)*/
{64, 0,123,__LINE__, 0xc0056c6e, 0x7397f5af, 0xbfd66666, 0x66666660, 0xbfe66666, 0x66666664},	/* -2.67795=f(-0.35, -0.7)*/
{64, 0,123,__LINE__, 0xc0052e63, 0xcbf6f7b3, 0xbfd66666, 0x66666660, 0xbfe4cccc, 0xccccccca},	/* -2.64765=f(-0.35, -0.65)*/
{64, 0,123,__LINE__, 0xc004e87c, 0x3b956ba8, 0xbfd66666, 0x66666660, 0xbfe33333, 0x33333330},	/* -2.61352=f(-0.35, -0.6)*/
{64, 0,123,__LINE__, 0xc0049952, 0x004c912f, 0xbfd66666, 0x66666660, 0xbfe19999, 0x99999996},	/* -2.57486=f(-0.35, -0.55)*/
{64, 0,123,__LINE__, 0xc0043f37, 0x08e537ed, 0xbfd66666, 0x66666660, 0xbfdfffff, 0xfffffff9},	/* -2.53087=f(-0.35, -0.5)*/
{64, 0,123,__LINE__, 0xc003d82a, 0x5408834e, 0xbfd66666, 0x66666660, 0xbfdccccc, 0xccccccc6},	/* -2.48055=f(-0.35, -0.45)*/
{63, 0,123,__LINE__, 0xc00361d1, 0x62e61b8b, 0xbfd66666, 0x66666660, 0xbfd99999, 0x99999993},	/* -2.42276=f(-0.35, -0.4)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfd66666, 0x66666660, 0xbfd66666, 0x66666660},	/* -2.35619=f(-0.35, -0.35)*/
{64, 0,123,__LINE__, 0xc0023c41, 0xea611604, 0xbfd66666, 0x66666660, 0xbfd33333, 0x3333332d},	/* -2.27942=f(-0.35, -0.3)*/
{64, 0,123,__LINE__, 0xc0018743, 0x06ef5824, 0xbfd66666, 0x66666660, 0xbfcfffff, 0xfffffff4},	/* -2.19105=f(-0.35, -0.25)*/
{64, 0,123,__LINE__, 0xc000b833, 0xbe165cc8, 0xbfd66666, 0x66666660, 0xbfc99999, 0x9999998e},	/* -2.08994=f(-0.35, -0.2)*/
{64, 0,123,__LINE__, 0xbfff9c6b, 0x238c6433, 0xbfd66666, 0x66666660, 0xbfc33333, 0x33333328},	/* -1.97569=f(-0.35, -0.15)*/
{63, 0,123,__LINE__, 0xbffd95e5, 0xac22d089, 0xbfd66666, 0x66666660, 0xbfb99999, 0x99999983},	/* -1.8491=f(-0.35, -0.1)*/
{63, 0,123,__LINE__, 0xbffb6731, 0x2cd2f430, 0xbfd66666, 0x66666660, 0xbfa99999, 0x9999996c},	/* -1.71269=f(-0.35, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d14, 0xbfd66666, 0x66666660, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.35, 3.19189e-16)*/
{64, 0,123,__LINE__, 0xbff6dcc5, 0x7bb565f8, 0xbfd66666, 0x66666660, 0x3fa99999, 0x999999c8},	/* -1.4289=f(-0.35, 0.05)*/
{64, 0,123,__LINE__, 0xbff4ae10, 0xfc6589a0, 0xbfd66666, 0x66666660, 0x3fb99999, 0x999999b1},	/* -1.2925=f(-0.35, 0.1)*/
{64, 0,123,__LINE__, 0xbff2a78b, 0x84fbf5f7, 0xbfd66666, 0x66666660, 0x3fc33333, 0x3333333f},	/* -1.1659=f(-0.35, 0.15)*/
{64, 0,123,__LINE__, 0xbff0d38f, 0x2c5ba099, 0xbfd66666, 0x66666660, 0x3fc99999, 0x999999a6},	/* -1.05165=f(-0.35, 0.2)*/
{64, 0,123,__LINE__, 0xbfee6ae1, 0x355353c6, 0xbfd66666, 0x66666660, 0x3fd00000, 0x00000006},	/* -0.950547=f(-0.35, 0.25)*/
{64, 0,123,__LINE__, 0xbfeb96e5, 0xa78c5c48, 0xbfd66666, 0x66666660, 0x3fd33333, 0x33333339},	/* -0.86217=f(-0.35, 0.3)*/
{64, 0,123,__LINE__, 0xbfe921fb, 0x54442d10, 0xbfd66666, 0x66666660, 0x3fd66666, 0x6666666c},	/* -0.785398=f(-0.35, 0.35)*/
{64, 0,123,__LINE__, 0xbfe700a7, 0xc578462c, 0xbfd66666, 0x66666660, 0x3fd99999, 0x9999999f},	/* -0.71883=f(-0.35, 0.4)*/
{64, 0,123,__LINE__, 0xbfe52744, 0x00eea723, 0xbfd66666, 0x66666660, 0x3fdccccc, 0xccccccd2},	/* -0.661043=f(-0.35, 0.45)*/
{64, 0,123,__LINE__, 0xbfe38b11, 0x2d7bd4a6, 0xbfd66666, 0x66666660, 0x3fe00000, 0x00000003},	/* -0.610726=f(-0.35, 0.5)*/
{64, 0,123,__LINE__, 0xbfe222a5, 0x4fde6fa1, 0xbfd66666, 0x66666660, 0x3fe19999, 0x9999999d},	/* -0.566729=f(-0.35, 0.55)*/
{63, 0,123,__LINE__, 0xbfe0e5fc, 0x62bb05bc, 0xbfd66666, 0x66666660, 0x3fe33333, 0x33333337},	/* -0.528074=f(-0.35, 0.6)*/
{64, 0,123,__LINE__, 0xbfdf9cbc, 0x4269ab1e, 0xbfd66666, 0x66666660, 0x3fe4cccc, 0xccccccd1},	/* -0.493941=f(-0.35, 0.65)*/
{64, 0,123,__LINE__, 0xbfddac67, 0x0561bb43, 0xbfd66666, 0x66666660, 0x3fe66666, 0x6666666b},	/* -0.463648=f(-0.35, 0.7)*/
{64, 0,123,__LINE__, 0xbfdbf1b3, 0x0afc730f, 0xbfd66666, 0x66666660, 0x3fe80000, 0x00000005},	/* -0.436627=f(-0.35, 0.75)*/
{64, 0,123,__LINE__, 0xbfda64ee, 0xc3cc23f1, 0xbfd66666, 0x66666660, 0x3fe99999, 0x9999999f},	/* -0.41241=f(-0.35, 0.8)*/
{64, 0,123,__LINE__, 0xbfd8ffb4, 0xaf91341a, 0xbfd66666, 0x66666660, 0x3feb3333, 0x33333339},	/* -0.390607=f(-0.35, 0.85)*/
{64, 0,123,__LINE__, 0xbfd7bcae, 0xd0f4964a, 0xbfd66666, 0x66666660, 0x3feccccc, 0xccccccd3},	/* -0.370891=f(-0.35, 0.9)*/
{64, 0,123,__LINE__, 0xbfd69764, 0xfee13639, 0xbfd66666, 0x66666660, 0x3fee6666, 0x6666666d},	/* -0.35299=f(-0.35, 0.95)*/
{64, 0,123,__LINE__, 0xc006cd14, 0x07805738, 0xbfd33333, 0x3333332d, 0xbff00000, 0x00000000},	/* -2.85014=f(-0.3, -1)*/
{64, 0,123,__LINE__, 0xc006af8a, 0xb51a6805, 0xbfd33333, 0x3333332d, 0xbfee6666, 0x66666666},	/* -2.83571=f(-0.3, -0.95)*/
{64, 0,123,__LINE__, 0xc0068f09, 0x5fdf593d, 0xbfd33333, 0x3333332d, 0xbfeccccc, 0xcccccccc},	/* -2.81984=f(-0.3, -0.9)*/
{64, 0,123,__LINE__, 0xc0066b1c, 0x486d572a, 0xbfd33333, 0x3333332d, 0xbfeb3333, 0x33333332},	/* -2.8023=f(-0.3, -0.85)*/
{64, 0,123,__LINE__, 0xc0064338, 0x2c07913b, 0xbfd33333, 0x3333332d, 0xbfe99999, 0x99999998},	/* -2.78282=f(-0.3, -0.8)*/
{64, 0,123,__LINE__, 0xc00616b4, 0x66d73d61, 0xbfd33333, 0x3333332d, 0xbfe7ffff, 0xfffffffe},	/* -2.76109=f(-0.3, -0.75)*/
{64, 0,123,__LINE__, 0xc005e4c3, 0x6ca0118b, 0xbfd33333, 0x3333332d, 0xbfe66666, 0x66666664},	/* -2.7367=f(-0.3, -0.7)*/
{64, 0,123,__LINE__, 0xc005ac69, 0x1f0f489b, 0xbfd33333, 0x3333332d, 0xbfe4cccc, 0xccccccca},	/* -2.70918=f(-0.3, -0.65)*/
{64, 0,123,__LINE__, 0xc0056c6e, 0x7397f5af, 0xbfd33333, 0x3333332d, 0xbfe33333, 0x33333330},	/* -2.67795=f(-0.3, -0.6)*/
{64, 0,123,__LINE__, 0xc0052351, 0xd5cc5410, 0xbfd33333, 0x3333332d, 0xbfe19999, 0x99999996},	/* -2.64225=f(-0.3, -0.55)*/
{64, 0,123,__LINE__, 0xc004cf33, 0xdec5e9e0, 0xbfd33333, 0x3333332d, 0xbfdfffff, 0xfffffff9},	/* -2.60117=f(-0.3, -0.5)*/
{64, 0,123,__LINE__, 0xc0046dc0, 0x9ec29433, 0xbfd33333, 0x3333332d, 0xbfdccccc, 0xccccccc6},	/* -2.55359=f(-0.3, -0.45)*/
{64, 0,123,__LINE__, 0xc003fc17, 0x6b7a8560, 0xbfd33333, 0x3333332d, 0xbfd99999, 0x99999993},	/* -2.49809=f(-0.3, -0.4)*/
{64, 0,123,__LINE__, 0xc00376b7, 0x14052da1, 0xbfd33333, 0x3333332d, 0xbfd66666, 0x66666660},	/* -2.43297=f(-0.3, -0.35)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfd33333, 0x3333332d, 0xbfd33333, 0x3333332d},	/* -2.35619=f(-0.3, -0.3)*/
{63, 0,123,__LINE__, 0xc0021fd0, 0x9b1e712f, 0xbfd33333, 0x3333332d, 0xbfcfffff, 0xfffffff4},	/* -2.26553=f(-0.3, -0.25)*/
{64, 0,123,__LINE__, 0xc0014538, 0x5fa3af71, 0xbfd33333, 0x3333332d, 0xbfc99999, 0x9999998e},	/* -2.1588=f(-0.3, -0.2)*/
{63, 0,123,__LINE__, 0xc000468a, 0x8ace4df5, 0xbfd33333, 0x3333332d, 0xbfc33333, 0x33333328},	/* -2.03444=f(-0.3, -0.15)*/
{64, 0,123,__LINE__, 0xbffe47df, 0x3d0dd4ce, 0xbfd33333, 0x3333332d, 0xbfb99999, 0x99999983},	/* -1.89255=f(-0.3, -0.1)*/
{63, 0,123,__LINE__, 0xbffbc66e, 0x44cbc070, 0xbfd33333, 0x3333332d, 0xbfa99999, 0x9999996c},	/* -1.73595=f(-0.3, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d13, 0xbfd33333, 0x3333332d, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.3, 3.19189e-16)*/
{64, 0,123,__LINE__, 0xbff67d88, 0x63bc99b7, 0xbfd33333, 0x3333332d, 0x3fa99999, 0x999999c8},	/* -1.40565=f(-0.3, 0.05)*/
{64, 0,123,__LINE__, 0xbff3fc17, 0x6b7a855a, 0xbfd33333, 0x3333332d, 0x3fb99999, 0x999999b1},	/* -1.24905=f(-0.3, 0.1)*/
{64, 0,123,__LINE__, 0xbff1b6e1, 0x92ebbe3e, 0xbfd33333, 0x3333332d, 0x3fc33333, 0x3333333f},	/* -1.10715=f(-0.3, 0.15)*/
{64, 0,123,__LINE__, 0xbfef730b, 0xd281f68f, 0xbfd33333, 0x3333332d, 0x3fc99999, 0x999999a6},	/* -0.982794=f(-0.3, 0.2)*/
{64, 0,123,__LINE__, 0xbfec08aa, 0xe496ef9b, 0xbfd33333, 0x3333332d, 0x3fd00000, 0x00000006},	/* -0.876058=f(-0.3, 0.25)*/
{64, 0,123,__LINE__, 0xbfe921fb, 0x54442d0e, 0xbfd33333, 0x3333332d, 0x3fd33333, 0x33333339},	/* -0.785398=f(-0.3, 0.3)*/
{64, 0,123,__LINE__, 0xbfe6ad11, 0x00fbfdd6, 0xbfd33333, 0x3333332d, 0x3fd66666, 0x6666666c},	/* -0.708626=f(-0.3, 0.35)*/
{64, 0,123,__LINE__, 0xbfe4978f, 0xa3269ed9, 0xbfd33333, 0x3333332d, 0x3fd99999, 0x9999999f},	/* -0.643501=f(-0.3, 0.4)*/
{64, 0,123,__LINE__, 0xbfe2d0ea, 0xd606638e, 0xbfd33333, 0x3333332d, 0x3fdccccc, 0xccccccd2},	/* -0.588003=f(-0.3, 0.45)*/
{63, 0,123,__LINE__, 0xbfe14b1d, 0xd5f90cda, 0xbfd33333, 0x3333332d, 0x3fe00000, 0x00000003},	/* -0.54042=f(-0.3, 0.5)*/
{63, 0,123,__LINE__, 0xbfdff54b, 0xf3bec835, 0xbfd33333, 0x3333332d, 0x3fe19999, 0x9999999d},	/* -0.499347=f(-0.3, 0.55)*/
{64, 0,123,__LINE__, 0xbfddac67, 0x0561bb42, 0xbfd33333, 0x3333332d, 0x3fe33333, 0x33333337},	/* -0.463648=f(-0.3, 0.6)*/
{64, 0,123,__LINE__, 0xbfdbac91, 0xa9a723e0, 0xbfd33333, 0x3333332d, 0x3fe4cccc, 0xccccccd1},	/* -0.432408=f(-0.3, 0.65)*/
{64, 0,123,__LINE__, 0xbfd9e9bf, 0x3d20dc65, 0xbfd33333, 0x3333332d, 0x3fe66666, 0x6666666b},	/* -0.404892=f(-0.3, 0.7)*/
{64, 0,123,__LINE__, 0xbfd85a37, 0x6b677db4, 0xbfd33333, 0x3333332d, 0x3fe80000, 0x00000005},	/* -0.380506=f(-0.3, 0.75)*/
{64, 0,123,__LINE__, 0xbfd6f619, 0x41e4dee5, 0xbfd33333, 0x3333332d, 0x3fe99999, 0x9999999f},	/* -0.358771=f(-0.3, 0.8)*/
{64, 0,123,__LINE__, 0xbfd5b6f8, 0x5eb6af69, 0xbfd33333, 0x3333332d, 0x3feb3333, 0x33333339},	/* -0.339293=f(-0.3, 0.85)*/
{64, 0,123,__LINE__, 0xbfd4978f, 0xa3269ed7, 0xbfd33333, 0x3333332d, 0x3feccccc, 0xccccccd3},	/* -0.321751=f(-0.3, 0.9)*/
{64, 0,123,__LINE__, 0xbfd39384, 0xf94e2896, 0xbfd33333, 0x3333332d, 0x3fee6666, 0x6666666d},	/* -0.305879=f(-0.3, 0.95)*/
{64, 0,123,__LINE__, 0xc0072c43, 0xf4b1650b, 0xbfcfffff, 0xfffffff4, 0xbff00000, 0x00000000},	/* -2.89661=f(-0.25, -1)*/
{64, 0,123,__LINE__, 0xc00712fb, 0x97e1e344, 0xbfcfffff, 0xfffffff4, 0xbfee6666, 0x66666666},	/* -2.88427=f(-0.25, -0.95)*/
{64, 0,123,__LINE__, 0xc006f715, 0x259aea15, 0xbfcfffff, 0xfffffff4, 0xbfeccccc, 0xcccccccc},	/* -2.87065=f(-0.25, -0.9)*/
{64, 0,123,__LINE__, 0xc006d825, 0xfdaafadb, 0xbfcfffff, 0xfffffff4, 0xbfeb3333, 0x33333332},	/* -2.85554=f(-0.25, -0.85)*/
{64, 0,123,__LINE__, 0xc006b5ac, 0x6d632fa0, 0xbfcfffff, 0xfffffff4, 0xbfe99999, 0x99999998},	/* -2.83871=f(-0.25, -0.8)*/
{64, 0,123,__LINE__, 0xc0068f09, 0x5fdf593d, 0xbfcfffff, 0xfffffff4, 0xbfe7ffff, 0xfffffffe},	/* -2.81984=f(-0.25, -0.75)*/
{64, 0,123,__LINE__, 0xc0066377, 0xfe555c41, 0xbfcfffff, 0xfffffff4, 0xbfe66666, 0x66666664},	/* -2.79857=f(-0.25, -0.7)*/
{64, 0,123,__LINE__, 0xc0063202, 0x7e829b4d, 0xbfcfffff, 0xfffffff4, 0xbfe4cccc, 0xccccccca},	/* -2.77442=f(-0.25, -0.65)*/
{64, 0,123,__LINE__, 0xc005f973, 0x15254857, 0xbfcfffff, 0xfffffff4, 0xbfe33333, 0x33333330},	/* -2.7468=f(-0.25, -0.6)*/
{64, 0,123,__LINE__, 0xc005b83f, 0xa76fbdb1, 0xbfcfffff, 0xfffffff4, 0xbfe19999, 0x99999996},	/* -2.71497=f(-0.25, -0.55)*/
{64, 0,123,__LINE__, 0xc0056c6e, 0x7397f5af, 0xbfcfffff, 0xfffffff4, 0xbfdfffff, 0xfffffff9},	/* -2.67795=f(-0.25, -0.5)*/
{64, 0,123,__LINE__, 0xc0051371, 0xab22738c, 0xbfcfffff, 0xfffffff4, 0xbfdccccc, 0xccccccc6},	/* -2.63449=f(-0.25, -0.45)*/
{64, 0,123,__LINE__, 0xc004a9f8, 0x694c6d6c, 0xbfcfffff, 0xfffffff4, 0xbfd99999, 0x99999993},	/* -2.58299=f(-0.25, -0.4)*/
{64, 0,123,__LINE__, 0xc0042bb5, 0xf776eb80, 0xbfcfffff, 0xfffffff4, 0xbfd66666, 0x66666660},	/* -2.52134=f(-0.25, -0.35)*/
{64, 0,123,__LINE__, 0xc0039328, 0x6347d276, 0xbfcfffff, 0xfffffff4, 0xbfd33333, 0x3333332d},	/* -2.44685=f(-0.25, -0.3)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfcfffff, 0xfffffff4, 0xbfcfffff, 0xfffffff4},	/* -2.35619=f(-0.25, -0.25)*/
{64, 0,123,__LINE__, 0xc001f6dc, 0x3e631130, 0xbfcfffff, 0xfffffff4, 0xbfc99999, 0x9999998e},	/* -2.24554=f(-0.25, -0.2)*/
{64, 0,123,__LINE__, 0xc000e3c5, 0x1fa059c4, 0xbfcfffff, 0xfffffff4, 0xbfc33333, 0x33333328},	/* -2.11122=f(-0.25, -0.15)*/
{63, 0,123,__LINE__, 0xbfff3889, 0x2f1e0c85, 0xbfcfffff, 0xfffffff4, 0xbfb99999, 0x99999983},	/* -1.9513=f(-0.25, -0.1)*/
{63, 0,123,__LINE__, 0xbffc4a83, 0x936311d5, 0xbfcfffff, 0xfffffff4, 0xbfa99999, 0x9999996c},	/* -1.76819=f(-0.25, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d13, 0xbfcfffff, 0xfffffff4, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.25, 3.19189e-16)*/
{64, 0,123,__LINE__, 0xbff5f973, 0x15254850, 0xbfcfffff, 0xfffffff4, 0x3fa99999, 0x999999c8},	/* -1.3734=f(-0.25, 0.05)*/
{64, 0,123,__LINE__, 0xbff30b6d, 0x796a4da1, 0xbfcfffff, 0xfffffff4, 0x3fb99999, 0x999999b1},	/* -1.19029=f(-0.25, 0.1)*/
{64, 0,123,__LINE__, 0xbff07c6c, 0x6947a6a1, 0xbfcfffff, 0xfffffff4, 0x3fc33333, 0x3333333f},	/* -1.03038=f(-0.25, 0.15)*/
{64, 0,123,__LINE__, 0xbfecac7c, 0x57846f91, 0xbfcfffff, 0xfffffff4, 0x3fc99999, 0x999999a6},	/* -0.896055=f(-0.25, 0.2)*/
{64, 0,123,__LINE__, 0xbfe921fb, 0x54442d0c, 0xbfcfffff, 0xfffffff4, 0x3fd00000, 0x00000006},	/* -0.785398=f(-0.25, 0.25)*/
{64, 0,123,__LINE__, 0xbfe63b4b, 0xc3f16a80, 0xbfcfffff, 0xfffffff4, 0x3fd33333, 0x33333339},	/* -0.694738=f(-0.25, 0.3)*/
{63, 0,123,__LINE__, 0xbfe3d915, 0x73350657, 0xbfcfffff, 0xfffffff4, 0x3fd66666, 0x6666666c},	/* -0.620249=f(-0.25, 0.35)*/
{63, 0,123,__LINE__, 0xbfe1e00b, 0xabdefeac, 0xbfcfffff, 0xfffffff4, 0x3fd99999, 0x9999999f},	/* -0.558599=f(-0.25, 0.4)*/
{64, 0,123,__LINE__, 0xbfe03a26, 0xa486e62a, 0xbfcfffff, 0xfffffff4, 0x3fdccccc, 0xccccccd2},	/* -0.507099=f(-0.25, 0.45)*/
{64, 0,123,__LINE__, 0xbfddac67, 0x0561bb41, 0xbfcfffff, 0xfffffff4, 0x3fe00000, 0x00000003},	/* -0.463648=f(-0.25, 0.5)*/
{63, 0,123,__LINE__, 0xbfdb4ddd, 0x66a37b32, 0xbfcfffff, 0xfffffff4, 0x3fe19999, 0x9999999d},	/* -0.426627=f(-0.25, 0.55)*/
{64, 0,123,__LINE__, 0xbfd94441, 0xf8f725fe, 0xbfcfffff, 0xfffffff4, 0x3fe33333, 0x33333337},	/* -0.394791=f(-0.25, 0.6)*/
{64, 0,123,__LINE__, 0xbfd77fc6, 0xae0c8e55, 0xbfcfffff, 0xfffffff4, 0x3fe4cccc, 0xccccccd1},	/* -0.367174=f(-0.25, 0.65)*/
{63, 0,123,__LINE__, 0xbfd5f41a, 0xaf7686b0, 0xbfcfffff, 0xfffffff4, 0x3fe66666, 0x6666666b},	/* -0.343024=f(-0.25, 0.7)*/
{64, 0,123,__LINE__, 0xbfd4978f, 0xa3269ed6, 0xbfcfffff, 0xfffffff4, 0x3fe80000, 0x00000005},	/* -0.321751=f(-0.25, 0.75)*/
{64, 0,123,__LINE__, 0xbfd36277, 0x3707ebc1, 0xbfcfffff, 0xfffffff4, 0x3fe99999, 0x9999999f},	/* -0.302885=f(-0.25, 0.8)*/
{64, 0,123,__LINE__, 0xbfd24eaa, 0xb4c991e4, 0xbfcfffff, 0xfffffff4, 0x3feb3333, 0x33333339},	/* -0.286051=f(-0.25, 0.85)*/
{64, 0,123,__LINE__, 0xbfd15731, 0x754a1817, 0xbfcfffff, 0xfffffff4, 0x3feccccc, 0xccccccd3},	/* -0.270947=f(-0.25, 0.9)*/
{64, 0,123,__LINE__, 0xbfd077fd, 0xe3124ea1, 0xbfcfffff, 0xfffffff4, 0x3fee6666, 0x6666666d},	/* -0.257324=f(-0.25, 0.95)*/
{64, 0,123,__LINE__, 0xc0078db7, 0x34b4bab8, 0xbfc99999, 0x9999998e, 0xbff00000, 0x00000000},	/* -2.9442=f(-0.2, -1)*/
{64, 0,123,__LINE__, 0xc0077907, 0x8c2f83ec, 0xbfc99999, 0x9999998e, 0xbfee6666, 0x66666666},	/* -2.9341=f(-0.2, -0.95)*/
{64, 0,123,__LINE__, 0xc0076225, 0xd32abdbd, 0xbfc99999, 0x9999998e, 0xbfeccccc, 0xcccccccc},	/* -2.92292=f(-0.2, -0.9)*/
{64, 0,123,__LINE__, 0xc00748b5, 0x43f409e0, 0xbfc99999, 0x9999998e, 0xbfeb3333, 0x33333332},	/* -2.9105=f(-0.2, -0.85)*/
{64, 0,123,__LINE__, 0xc0072c43, 0xf4b1650b, 0xbfc99999, 0x9999998e, 0xbfe99999, 0x99999998},	/* -2.89661=f(-0.2, -0.8)*/
{63, 0,123,__LINE__, 0xc0070c44, 0x9f55a999, 0xbfc99999, 0x9999998e, 0xbfe7ffff, 0xfffffffe},	/* -2.88099=f(-0.2, -0.75)*/
{64, 0,123,__LINE__, 0xc006e806, 0x2854db5f, 0xbfc99999, 0x9999998e, 0xbfe66666, 0x66666664},	/* -2.86329=f(-0.2, -0.7)*/
{64, 0,123,__LINE__, 0xc006bea7, 0xebdbbf5d, 0xbfc99999, 0x9999998e, 0xbfe4cccc, 0xccccccca},	/* -2.84309=f(-0.2, -0.65)*/
{64, 0,123,__LINE__, 0xc0068f09, 0x5fdf593d, 0xbfc99999, 0x9999998e, 0xbfe33333, 0x33333330},	/* -2.81984=f(-0.2, -0.6)*/
{64, 0,123,__LINE__, 0xc00657b2, 0xe092b036, 0xbfc99999, 0x9999998e, 0xbfe19999, 0x99999996},	/* -2.79282=f(-0.2, -0.55)*/
{64, 0,123,__LINE__, 0xc00616b4, 0x66d73d61, 0xbfc99999, 0x9999998e, 0xbfdfffff, 0xfffffff9},	/* -2.76109=f(-0.2, -0.5)*/
{64, 0,123,__LINE__, 0xc005c975, 0x54f4b39f, 0xbfc99999, 0x9999998e, 0xbfdccccc, 0xccccccc6},	/* -2.72337=f(-0.2, -0.45)*/
{64, 0,123,__LINE__, 0xc0056c6e, 0x7397f5af, 0xbfc99999, 0x9999998e, 0xbfd99999, 0x99999993},	/* -2.67795=f(-0.2, -0.4)*/
{64, 0,123,__LINE__, 0xc004fac5, 0x404fe6dc, 0xbfc99999, 0x9999998e, 0xbfd66666, 0x66666660},	/* -2.62245=f(-0.2, -0.35)*/
{64, 0,123,__LINE__, 0xc0046dc0, 0x9ec29433, 0xbfc99999, 0x9999998e, 0xbfd33333, 0x3333332d},	/* -2.55359=f(-0.2, -0.3)*/
{64, 0,123,__LINE__, 0xc003bc1c, 0xc0033274, 0xbfc99999, 0x9999998e, 0xbfcfffff, 0xfffffff4},	/* -2.46685=f(-0.2, -0.25)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfc99999, 0x9999998e, 0xbfc99999, 0x9999998e},	/* -2.35619=f(-0.2, -0.2)*/
{64, 0,123,__LINE__, 0xc001b6e1, 0x92ebbe44, 0xbfc99999, 0x9999998e, 0xbfc33333, 0x33333328},	/* -2.2143=f(-0.2, -0.15)*/
{64, 0,123,__LINE__, 0xc000468a, 0x8ace4df5, 0xbfc99999, 0x9999998e, 0xbfb99999, 0x99999983},	/* -2.03444=f(-0.2, -0.1)*/
{64, 0,123,__LINE__, 0xbffd0d6a, 0x1369bd2f, 0xbfc99999, 0x9999998e, 0xbfa99999, 0x9999996c},	/* -1.81577=f(-0.2, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d11, 0xbfc99999, 0x9999998e, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.2, 3.19189e-16)*/
{64, 0,123,__LINE__, 0xbff5368c, 0x951e9cf4, 0xbfc99999, 0x9999998e, 0x3fa99999, 0x999999c8},	/* -1.32582=f(-0.2, 0.05)*/
{64, 0,123,__LINE__, 0xbff1b6e1, 0x92ebbe3c, 0xbfc99999, 0x9999998e, 0x3fb99999, 0x999999b1},	/* -1.10715=f(-0.2, 0.1)*/
{64, 0,123,__LINE__, 0xbfedac67, 0x0561bb3f, 0xbfc99999, 0x9999998e, 0x3fc33333, 0x3333333f},	/* -0.927295=f(-0.2, 0.15)*/
{64, 0,123,__LINE__, 0xbfe921fb, 0x54442d09, 0xbfc99999, 0x9999998e, 0x3fc99999, 0x999999a6},	/* -0.785398=f(-0.2, 0.2)*/
{64, 0,123,__LINE__, 0xbfe5977a, 0x5103ea85, 0xbfc99999, 0x9999998e, 0x3fd00000, 0x00000006},	/* -0.674741=f(-0.2, 0.25)*/
{64, 0,123,__LINE__, 0xbfe2d0ea, 0xd606638a, 0xbfc99999, 0x9999998e, 0x3fd33333, 0x33333339},	/* -0.588003=f(-0.2, 0.3)*/
{63, 0,123,__LINE__, 0xbfe09cd8, 0x4fd118ea, 0xbfc99999, 0x9999998e, 0x3fd66666, 0x6666666c},	/* -0.519146=f(-0.2, 0.35)*/
{63, 0,123,__LINE__, 0xbfddac67, 0x0561bb3e, 0xbfc99999, 0x9999998e, 0x3fd99999, 0x9999999f},	/* -0.463648=f(-0.2, 0.4)*/
{63, 0,123,__LINE__, 0xbfdac42f, 0xfa7bcbc0, 0xbfc99999, 0x9999998e, 0x3fdccccc, 0xccccccd2},	/* -0.418224=f(-0.2, 0.45)*/
{63, 0,123,__LINE__, 0xbfd85a37, 0x6b677db2, 0xbfc99999, 0x9999998e, 0x3fe00000, 0x00000003},	/* -0.380506=f(-0.2, 0.5)*/
{63, 0,123,__LINE__, 0xbfd65243, 0x9d8be708, 0xbfc99999, 0x9999998e, 0x3fe19999, 0x9999999d},	/* -0.348771=f(-0.2, 0.55)*/
{63, 0,123,__LINE__, 0xbfd4978f, 0xa3269ed5, 0xbfc99999, 0x9999998e, 0x3fe33333, 0x33333337},	/* -0.321751=f(-0.2, 0.6)*/
{64, 0,123,__LINE__, 0xbfd31a9b, 0x43436dd5, 0xbfc99999, 0x9999998e, 0x3fe4cccc, 0xccccccd1},	/* -0.298499=f(-0.2, 0.65)*/
{64, 0,123,__LINE__, 0xbfd1cfa9, 0x5f7a8dc3, 0xbfc99999, 0x9999998e, 0x3fe66666, 0x6666666b},	/* -0.2783=f(-0.2, 0.7)*/
{64, 0,123,__LINE__, 0xbfd0adb5, 0xa7741bf9, 0xbfc99999, 0x9999998e, 0x3fe80000, 0x00000005},	/* -0.260602=f(-0.2, 0.75)*/
{63, 0,123,__LINE__, 0xbfcf5b75, 0xf92c80c9, 0xbfc99999, 0x9999998e, 0x3fe99999, 0x9999999f},	/* -0.244979=f(-0.2, 0.8)*/
{64, 0,123,__LINE__, 0xbfcd9461, 0x05023378, 0xbfc99999, 0x9999998e, 0x3feb3333, 0x33333339},	/* -0.231091=f(-0.2, 0.85)*/
{64, 0,123,__LINE__, 0xbfcbfd58, 0x1196f5af, 0xbfc99999, 0x9999998e, 0x3feccccc, 0xccccccd3},	/* -0.218669=f(-0.2, 0.9)*/
{64, 0,123,__LINE__, 0xbfca8f3c, 0x814a92c5, 0xbfc99999, 0x9999998e, 0x3fee6666, 0x6666666d},	/* -0.207496=f(-0.2, 0.95)*/
{64, 0,123,__LINE__, 0xc007f10e, 0x1dc6b049, 0xbfc33333, 0x33333328, 0xbff00000, 0x00000000},	/* -2.9927=f(-0.15, -1)*/
{64, 0,123,__LINE__, 0xc007e142, 0xd82322eb, 0xbfc33333, 0x33333328, 0xbfee6666, 0x66666666},	/* -2.98499=f(-0.15, -0.95)*/
{64, 0,123,__LINE__, 0xc007cfc1, 0xdc00636b, 0xbfc33333, 0x33333328, 0xbfeccccc, 0xcccccccc},	/* -2.97644=f(-0.15, -0.9)*/
{64, 0,123,__LINE__, 0xc007bc40, 0xca9216fe, 0xbfc33333, 0x33333328, 0xbfeb3333, 0x33333332},	/* -2.96692=f(-0.15, -0.85)*/
{64, 0,123,__LINE__, 0xc007a663, 0x9f874769, 0xbfc33333, 0x33333328, 0xbfe99999, 0x99999998},	/* -2.95624=f(-0.15, -0.8)*/
{64, 0,123,__LINE__, 0xc0078db7, 0x34b4bab8, 0xbfc33333, 0x33333328, 0xbfe7ffff, 0xfffffffe},	/* -2.9442=f(-0.15, -0.75)*/
{64, 0,123,__LINE__, 0xc00771a9, 0xa0af69de, 0xbfc33333, 0x33333328, 0xbfe66666, 0x66666664},	/* -2.9305=f(-0.15, -0.7)*/
{64, 0,123,__LINE__, 0xc007517f, 0x6a2ae180, 0xbfc33333, 0x33333328, 0xbfe4cccc, 0xccccccca},	/* -2.91479=f(-0.15, -0.65)*/
{64, 0,123,__LINE__, 0xc0072c43, 0xf4b1650b, 0xbfc33333, 0x33333328, 0xbfe33333, 0x33333330},	/* -2.89661=f(-0.15, -0.6)*/
{64, 0,123,__LINE__, 0xc00700b2, 0x93276810, 0xbfc33333, 0x33333328, 0xbfe19999, 0x99999996},	/* -2.87534=f(-0.15, -0.55)*/
{64, 0,123,__LINE__, 0xc006cd14, 0x07805738, 0xbfc33333, 0x33333328, 0xbfdfffff, 0xfffffff9},	/* -2.85014=f(-0.15, -0.5)*/
{64, 0,123,__LINE__, 0xc0068f09, 0x5fdf593d, 0xbfc33333, 0x33333328, 0xbfdccccc, 0xccccccc6},	/* -2.81984=f(-0.15, -0.45)*/
{64, 0,123,__LINE__, 0xc0064338, 0x2c07913b, 0xbfc33333, 0x33333328, 0xbfd99999, 0x99999993},	/* -2.78282=f(-0.15, -0.4)*/
{64, 0,123,__LINE__, 0xc005e4c3, 0x6ca0118b, 0xbfc33333, 0x33333328, 0xbfd66666, 0x66666660},	/* -2.7367=f(-0.15, -0.35)*/
{64, 0,123,__LINE__, 0xc0056c6e, 0x7397f5af, 0xbfc33333, 0x33333328, 0xbfd33333, 0x3333332d},	/* -2.67795=f(-0.15, -0.3)*/
{64, 0,123,__LINE__, 0xc004cf33, 0xdec5e9e1, 0xbfc33333, 0x33333328, 0xbfcfffff, 0xfffffff4},	/* -2.60117=f(-0.15, -0.25)*/
{64, 0,123,__LINE__, 0xc003fc17, 0x6b7a8560, 0xbfc33333, 0x33333328, 0xbfc99999, 0x9999998e},	/* -2.49809=f(-0.15, -0.2)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfc33333, 0x33333328, 0xbfc33333, 0x33333328},	/* -2.35619=f(-0.15, -0.15)*/
{64, 0,123,__LINE__, 0xc0014538, 0x5fa3af70, 0xbfc33333, 0x33333328, 0xbfb99999, 0x99999983},	/* -2.1588=f(-0.15, -0.1)*/
{64, 0,123,__LINE__, 0xbffe47df, 0x3d0dd4cb, 0xbfc33333, 0x33333328, 0xbfa99999, 0x9999996c},	/* -1.89255=f(-0.15, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d0f, 0xbfc33333, 0x33333328, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.15, 3.19189e-16)*/
{63, 0,123,__LINE__, 0xbff3fc17, 0x6b7a8554, 0xbfc33333, 0x33333328, 0x3fa99999, 0x999999c8},	/* -1.24905=f(-0.15, 0.05)*/
{64, 0,123,__LINE__, 0xbfef730b, 0xd281f685, 0xbfc33333, 0x33333328, 0x3fb99999, 0x999999b1},	/* -0.982794=f(-0.15, 0.1)*/
{64, 0,123,__LINE__, 0xbfe921fb, 0x54442d05, 0xbfc33333, 0x33333328, 0x3fc33333, 0x3333333f},	/* -0.785398=f(-0.15, 0.15)*/
{64, 0,123,__LINE__, 0xbfe4978f, 0xa3269ed1, 0xbfc33333, 0x33333328, 0x3fc99999, 0x999999a6},	/* -0.643501=f(-0.15, 0.2)*/
{63, 0,123,__LINE__, 0xbfe14b1d, 0xd5f90cd3, 0xbfc33333, 0x33333328, 0x3fd00000, 0x00000006},	/* -0.54042=f(-0.15, 0.25)*/
{64, 0,123,__LINE__, 0xbfddac67, 0x0561bb39, 0xbfc33333, 0x33333328, 0x3fd33333, 0x33333339},	/* -0.463648=f(-0.15, 0.3)*/
{64, 0,123,__LINE__, 0xbfd9e9bf, 0x3d20dc5e, 0xbfc33333, 0x33333328, 0x3fd66666, 0x6666666c},	/* -0.404892=f(-0.15, 0.35)*/
{64, 0,123,__LINE__, 0xbfd6f619, 0x41e4dee0, 0xbfc33333, 0x33333328, 0x3fd99999, 0x9999999f},	/* -0.358771=f(-0.15, 0.4)*/
{64, 0,123,__LINE__, 0xbfd4978f, 0xa3269ed2, 0xbfc33333, 0x33333328, 0x3fdccccc, 0xccccccd2},	/* -0.321751=f(-0.15, 0.45)*/
{64, 0,123,__LINE__, 0xbfd2a73a, 0x661eaef8, 0xbfc33333, 0x33333328, 0x3fe00000, 0x00000003},	/* -0.291457=f(-0.15, 0.5)*/
{64, 0,123,__LINE__, 0xbfd10a46, 0x08e6283d, 0xbfc33333, 0x33333328, 0x3fe19999, 0x9999999d},	/* -0.266252=f(-0.15, 0.55)*/
{64, 0,123,__LINE__, 0xbfcf5b75, 0xf92c80c6, 0xbfc33333, 0x33333328, 0x3fe33333, 0x33333337},	/* -0.244979=f(-0.15, 0.6)*/
{64, 0,123,__LINE__, 0xbfcd07be, 0xa194b97b, 0xbfc33333, 0x33333328, 0x3fe4cccc, 0xccccccd1},	/* -0.226799=f(-0.15, 0.65)*/
{64, 0,123,__LINE__, 0xbfcb051b, 0x394c3396, 0xbfc33333, 0x33333328, 0x3fe66666, 0x6666666b},	/* -0.211093=f(-0.15, 0.7)*/
{64, 0,123,__LINE__, 0xbfc94441, 0xf8f725f8, 0xbfc33333, 0x33333328, 0x3fe80000, 0x00000005},	/* -0.197396=f(-0.15, 0.75)*/
{64, 0,123,__LINE__, 0xbfc7b97b, 0x4bce5af0, 0xbfc33333, 0x33333328, 0x3fe99999, 0x9999999f},	/* -0.185348=f(-0.15, 0.8)*/
{64, 0,123,__LINE__, 0xbfc65ba8, 0x9b21619a, 0xbfc33333, 0x33333328, 0x3feb3333, 0x33333339},	/* -0.174672=f(-0.15, 0.85)*/
{64, 0,123,__LINE__, 0xbfc52397, 0x843c9acd, 0xbfc33333, 0x33333328, 0x3feccccc, 0xccccccd3},	/* -0.165149=f(-0.15, 0.9)*/
{64, 0,123,__LINE__, 0xbfc40b87, 0xc210a2d5, 0xbfc33333, 0x33333328, 0x3fee6666, 0x6666666d},	/* -0.156602=f(-0.15, 0.95)*/
{64, 0,123,__LINE__, 0xc00855dc, 0x402d16b7, 0xbfb99999, 0x99999983, 0xbff00000, 0x00000000},	/* -3.04192=f(-0.1, -1)*/
{64, 0,123,__LINE__, 0xc0084b31, 0x9bd4918d, 0xbfb99999, 0x99999983, 0xbfee6666, 0x66666666},	/* -3.03672=f(-0.1, -0.95)*/
{64, 0,123,__LINE__, 0xc0083f5b, 0x13741c78, 0xbfb99999, 0x99999983, 0xbfeccccc, 0xcccccccc},	/* -3.03094=f(-0.1, -0.9)*/
{64, 0,123,__LINE__, 0xc0083224, 0x9ea440f7, 0xbfb99999, 0x99999983, 0xbfeb3333, 0x33333332},	/* -3.02448=f(-0.1, -0.85)*/
{64, 0,123,__LINE__, 0xc008234d, 0x7f6ecb9e, 0xbfb99999, 0x99999983, 0xbfe99999, 0x99999998},	/* -3.01724=f(-0.1, -0.8)*/
{64, 0,123,__LINE__, 0xc0081284, 0x26c22f58, 0xbfb99999, 0x99999983, 0xbfe7ffff, 0xfffffffe},	/* -3.00904=f(-0.1, -0.75)*/
{64, 0,123,__LINE__, 0xc007ff60, 0x67fcc98b, 0xbfb99999, 0x99999983, 0xbfe66666, 0x66666664},	/* -2.9997=f(-0.1, -0.7)*/
{64, 0,123,__LINE__, 0xc007e95b, 0x1e3a76c5, 0xbfb99999, 0x99999983, 0xbfe4cccc, 0xccccccca},	/* -2.98894=f(-0.1, -0.65)*/
{64, 0,123,__LINE__, 0xc007cfc1, 0xdc00636b, 0xbfb99999, 0x99999983, 0xbfe33333, 0x33333330},	/* -2.97644=f(-0.1, -0.6)*/
{64, 0,123,__LINE__, 0xc007b1a4, 0x4c26bccb, 0xbfb99999, 0x99999983, 0xbfe19999, 0x99999996},	/* -2.96174=f(-0.1, -0.55)*/
{64, 0,123,__LINE__, 0xc0078db7, 0x34b4bab9, 0xbfb99999, 0x99999983, 0xbfdfffff, 0xfffffff9},	/* -2.9442=f(-0.1, -0.5)*/
{64, 0,123,__LINE__, 0xc0076225, 0xd32abdbd, 0xbfb99999, 0x99999983, 0xbfdccccc, 0xccccccc6},	/* -2.92292=f(-0.1, -0.45)*/
{64, 0,123,__LINE__, 0xc0072c43, 0xf4b1650c, 0xbfb99999, 0x99999983, 0xbfd99999, 0x99999993},	/* -2.89661=f(-0.1, -0.4)*/
{64, 0,123,__LINE__, 0xc006e806, 0x2854db60, 0xbfb99999, 0x99999983, 0xbfd66666, 0x66666660},	/* -2.86329=f(-0.1, -0.35)*/
{63, 0,123,__LINE__, 0xc0068f09, 0x5fdf593d, 0xbfb99999, 0x99999983, 0xbfd33333, 0x3333332d},	/* -2.81984=f(-0.1, -0.3)*/
{64, 0,123,__LINE__, 0xc00616b4, 0x66d73d62, 0xbfb99999, 0x99999983, 0xbfcfffff, 0xfffffff4},	/* -2.76109=f(-0.1, -0.25)*/
{64, 0,123,__LINE__, 0xc0056c6e, 0x7397f5b0, 0xbfb99999, 0x99999983, 0xbfc99999, 0x9999998e},	/* -2.67795=f(-0.1, -0.2)*/
{64, 0,123,__LINE__, 0xc0046dc0, 0x9ec29434, 0xbfb99999, 0x99999983, 0xbfc33333, 0x33333328},	/* -2.55359=f(-0.1, -0.15)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfb99999, 0x99999983, 0xbfb99999, 0x99999983},	/* -2.35619=f(-0.1, -0.1)*/
{63, 0,123,__LINE__, 0xc000468a, 0x8ace4df3, 0xbfb99999, 0x99999983, 0xbfa99999, 0x9999996c},	/* -2.03444=f(-0.1, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442d0a, 0xbfb99999, 0x99999983, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.1, 3.19189e-16)*/
{64, 0,123,__LINE__, 0xbff1b6e1, 0x92ebbe33, 0xbfb99999, 0x99999983, 0x3fa99999, 0x999999c8},	/* -1.10715=f(-0.1, 0.05)*/
{64, 0,123,__LINE__, 0xbfe921fb, 0x54442cfc, 0xbfb99999, 0x99999983, 0x3fb99999, 0x999999b1},	/* -0.785398=f(-0.1, 0.1)*/
{64, 0,123,__LINE__, 0xbfe2d0ea, 0xd606637f, 0xbfb99999, 0x99999983, 0x3fc33333, 0x3333333f},	/* -0.588003=f(-0.1, 0.15)*/
{64, 0,123,__LINE__, 0xbfddac67, 0x0561bb2c, 0xbfb99999, 0x99999983, 0x3fc99999, 0x999999a6},	/* -0.463648=f(-0.1, 0.2)*/
{64, 0,123,__LINE__, 0xbfd85a37, 0x6b677da4, 0xbfb99999, 0x99999983, 0x3fd00000, 0x00000006},	/* -0.380506=f(-0.1, 0.25)*/
{64, 0,123,__LINE__, 0xbfd4978f, 0xa3269eca, 0xbfb99999, 0x99999983, 0x3fd33333, 0x33333339},	/* -0.321751=f(-0.1, 0.3)*/
{63, 0,123,__LINE__, 0xbfd1cfa9, 0x5f7a8dbb, 0xbfb99999, 0x99999983, 0x3fd66666, 0x6666666c},	/* -0.2783=f(-0.1, 0.35)*/
{64, 0,123,__LINE__, 0xbfcf5b75, 0xf92c80bc, 0xbfb99999, 0x99999983, 0x3fd99999, 0x9999999f},	/* -0.244979=f(-0.1, 0.4)*/
{63, 0,123,__LINE__, 0xbfcbfd58, 0x1196f5a5, 0xbfb99999, 0x99999983, 0x3fdccccc, 0xccccccd2},	/* -0.218669=f(-0.1, 0.45)*/
{64, 0,123,__LINE__, 0xbfc94441, 0xf8f725f1, 0xbfb99999, 0x99999983, 0x3fe00000, 0x00000003},	/* -0.197396=f(-0.1, 0.5)*/
{64, 0,123,__LINE__, 0xbfc70570, 0x81d704ce, 0xbfb99999, 0x99999983, 0x3fe19999, 0x9999999d},	/* -0.179853=f(-0.1, 0.55)*/
{64, 0,123,__LINE__, 0xbfc52397, 0x843c9ac7, 0xbfb99999, 0x99999983, 0x3fe33333, 0x33333337},	/* -0.165149=f(-0.1, 0.6)*/
{64, 0,123,__LINE__, 0xbfc38a03, 0x609b6530, 0xbfb99999, 0x99999983, 0x3fe4cccc, 0xccccccd1},	/* -0.152649=f(-0.1, 0.65)*/
{64, 0,123,__LINE__, 0xbfc229ae, 0xc47638c9, 0xbfb99999, 0x99999983, 0x3fe66666, 0x6666666b},	/* -0.141897=f(-0.1, 0.7)*/
{63, 0,123,__LINE__, 0xbfc0f772, 0xd81fdbf9, 0xbfb99999, 0x99999983, 0x3fe80000, 0x00000005},	/* -0.132552=f(-0.1, 0.75)*/
{64, 0,123,__LINE__, 0xbfbfd5ba, 0x9aac2f4b, 0xbfb99999, 0x99999983, 0x3fe99999, 0x9999999f},	/* -0.124355=f(-0.1, 0.8)*/
{64, 0,123,__LINE__, 0xbfbdfad6, 0xb3fd8429, 0xbfb99999, 0x99999983, 0x3feb3333, 0x33333339},	/* -0.117109=f(-0.1, 0.85)*/
{64, 0,123,__LINE__, 0xbfbc5408, 0x1a021411, 0xbfb99999, 0x99999983, 0x3feccccc, 0xccccccd3},	/* -0.110657=f(-0.1, 0.9)*/
{64, 0,123,__LINE__, 0xbfbad937, 0x0df3715e, 0xbfb99999, 0x99999983, 0x3fee6666, 0x6666666d},	/* -0.104877=f(-0.1, 0.95)*/
{64, 0,123,__LINE__, 0xc008bbaa, 0xbde5e29c, 0xbfa99999, 0x9999996c, 0xbff00000, 0x00000000},	/* -3.09163=f(-0.05, -1)*/
{64, 0,123,__LINE__, 0xc008b64a, 0xa934a2c3, 0xbfa99999, 0x9999996c, 0xbfee6666, 0x66666666},	/* -3.08901=f(-0.05, -0.95)*/
{64, 0,123,__LINE__, 0xc008b052, 0x20fc1e46, 0xbfa99999, 0x9999996c, 0xbfeccccc, 0xcccccccc},	/* -3.08609=f(-0.05, -0.9)*/
{64, 0,123,__LINE__, 0xc008a9a6, 0x5b3c113d, 0xbfa99999, 0x9999996c, 0xbfeb3333, 0x33333332},	/* -3.08284=f(-0.05, -0.85)*/
{64, 0,123,__LINE__, 0xc008a225, 0xe5677921, 0xbfa99999, 0x9999996c, 0xbfe99999, 0x99999998},	/* -3.07917=f(-0.05, -0.8)*/
{64, 0,123,__LINE__, 0xc00899a6, 0x70913360, 0xbfa99999, 0x9999996c, 0xbfe7ffff, 0xfffffffe},	/* -3.07502=f(-0.05, -0.75)*/
{64, 0,123,__LINE__, 0xc0088ff1, 0xae5a77dd, 0xbfa99999, 0x9999996c, 0xbfe66666, 0x66666664},	/* -3.07029=f(-0.05, -0.7)*/
{64, 0,123,__LINE__, 0xc00884c0, 0xbf72214b, 0xbfa99999, 0x9999996c, 0xbfe4cccc, 0xccccccca},	/* -3.06482=f(-0.05, -0.65)*/
{64, 0,123,__LINE__, 0xc00877b5, 0x6104e567, 0xbfa99999, 0x9999996c, 0xbfe33333, 0x33333330},	/* -3.05845=f(-0.05, -0.6)*/
{64, 0,123,__LINE__, 0xc008684f, 0x702f7c76, 0xbfa99999, 0x9999996c, 0xbfe19999, 0x99999996},	/* -3.05093=f(-0.05, -0.55)*/
{64, 0,123,__LINE__, 0xc00855dc, 0x402d16b7, 0xbfa99999, 0x9999996c, 0xbfdfffff, 0xfffffff9},	/* -3.04192=f(-0.05, -0.5)*/
{64, 0,123,__LINE__, 0xc0083f5b, 0x13741c78, 0xbfa99999, 0x9999996c, 0xbfdccccc, 0xccccccc6},	/* -3.03094=f(-0.05, -0.45)*/
{64, 0,123,__LINE__, 0xc008234d, 0x7f6ecb9e, 0xbfa99999, 0x9999996c, 0xbfd99999, 0x99999993},	/* -3.01724=f(-0.05, -0.4)*/
{64, 0,123,__LINE__, 0xc007ff60, 0x67fcc98c, 0xbfa99999, 0x9999996c, 0xbfd66666, 0x66666660},	/* -2.9997=f(-0.05, -0.35)*/
{64, 0,123,__LINE__, 0xc007cfc1, 0xdc00636c, 0xbfa99999, 0x9999996c, 0xbfd33333, 0x3333332d},	/* -2.97644=f(-0.05, -0.3)*/
{64, 0,123,__LINE__, 0xc0078db7, 0x34b4baba, 0xbfa99999, 0x9999996c, 0xbfcfffff, 0xfffffff4},	/* -2.9442=f(-0.05, -0.25)*/
{64, 0,123,__LINE__, 0xc0072c43, 0xf4b1650d, 0xbfa99999, 0x9999996c, 0xbfc99999, 0x9999998e},	/* -2.89661=f(-0.05, -0.2)*/
{64, 0,123,__LINE__, 0xc0068f09, 0x5fdf593f, 0xbfa99999, 0x9999996c, 0xbfc33333, 0x33333328},	/* -2.81984=f(-0.05, -0.15)*/
{64, 0,123,__LINE__, 0xc0056c6e, 0x7397f5b1, 0xbfa99999, 0x9999996c, 0xbfb99999, 0x99999983},	/* -2.67795=f(-0.05, -0.1)*/
{64, 0,123,__LINE__, 0xc002d97c, 0x7f3321d2, 0xbfa99999, 0x9999996c, 0xbfa99999, 0x9999996c},	/* -2.35619=f(-0.05, -0.05)*/
{64, 0,123,__LINE__, 0xbff921fb, 0x54442cfc, 0xbfa99999, 0x9999996c, 0x3cb70000, 0x00000000},	/* -1.5708=f(-0.05, 3.19189e-16)*/
{64, 0,123,__LINE__, 0xbfe921fb, 0x54442cdf, 0xbfa99999, 0x9999996c, 0x3fa99999, 0x999999c8},	/* -0.785398=f(-0.05, 0.05)*/
{63, 0,123,__LINE__, 0xbfddac67, 0x0561bb0a, 0xbfa99999, 0x9999996c, 0x3fb99999, 0x999999b1},	/* -0.463648=f(-0.05, 0.1)*/
{64, 0,123,__LINE__, 0xbfd4978f, 0xa3269eb3, 0xbfa99999, 0x9999996c, 0x3fc33333, 0x3333333f},	/* -0.321751=f(-0.05, 0.15)*/
{63, 0,123,__LINE__, 0xbfcf5b75, 0xf92c8099, 0xbfa99999, 0x9999996c, 0x3fc99999, 0x999999a6},	/* -0.244979=f(-0.05, 0.2)*/
{64, 0,123,__LINE__, 0xbfc94441, 0xf8f725d6, 0xbfa99999, 0x9999996c, 0x3fd00000, 0x00000006},	/* -0.197396=f(-0.05, 0.25)*/
{64, 0,123,__LINE__, 0xbfc52397, 0x843c9ab2, 0xbfa99999, 0x9999996c, 0x3fd33333, 0x33333339},	/* -0.165149=f(-0.05, 0.3)*/
{64, 0,123,__LINE__, 0xbfc229ae, 0xc47638b8, 0xbfa99999, 0x9999996c, 0x3fd66666, 0x6666666c},	/* -0.141897=f(-0.05, 0.35)*/
{64, 0,123,__LINE__, 0xbfbfd5ba, 0x9aac2f2f, 0xbfa99999, 0x9999996c, 0x3fd99999, 0x9999999f},	/* -0.124355=f(-0.05, 0.4)*/
{64, 0,123,__LINE__, 0xbfbc5408, 0x1a0213f9, 0xbfa99999, 0x9999996c, 0x3fdccccc, 0xccccccd2},	/* -0.110657=f(-0.05, 0.45)*/
{64, 0,123,__LINE__, 0xbfb983e2, 0x82e2cc1a, 0xbfa99999, 0x9999996c, 0x3fe00000, 0x00000003},	/* -0.0996687=f(-0.05, 0.5)*/
{64, 0,123,__LINE__, 0xbfb7357c, 0x82961441, 0xbfa99999, 0x9999996c, 0x3fe19999, 0x9999999d},	/* -0.0906599=f(-0.05, 0.55)*/
{64, 0,123,__LINE__, 0xbfb548be, 0x67e8f615, 0xbfa99999, 0x9999996c, 0x3fe33333, 0x33333337},	/* -0.0831412=f(-0.05, 0.6)*/
{64, 0,123,__LINE__, 0xbfb3a752, 0x9a4179a3, 0xbfa99999, 0x9999996c, 0x3fe4cccc, 0xccccccd1},	/* -0.0767719=f(-0.05, 0.65)*/
{64, 0,123,__LINE__, 0xbfb24134, 0xbd36a760, 0xbfa99999, 0x9999996c, 0x3fe66666, 0x6666666b},	/* -0.0713075=f(-0.05, 0.7)*/
{64, 0,123,__LINE__, 0xbfb10a9c, 0x765f3702, 0xbfa99999, 0x9999996c, 0x3fe80000, 0x00000005},	/* -0.0665682=f(-0.05, 0.75)*/
{64, 0,123,__LINE__, 0xbfaff55b, 0xb72cfdaa, 0xbfa99999, 0x9999996c, 0x3fe99999, 0x9999999f},	/* -0.0624188=f(-0.05, 0.8)*/
{64, 0,123,__LINE__, 0xbfae153e, 0x4206f6b9, 0xbfa99999, 0x9999996c, 0x3feb3333, 0x33333339},	/* -0.0587558=f(-0.05, 0.85)*/
{64, 0,123,__LINE__, 0xbfac6a4c, 0xd203b483, 0xbfa99999, 0x9999996c, 0x3feccccc, 0xccccccd3},	/* -0.0554985=f(-0.05, 0.9)*/
{64, 0,123,__LINE__, 0xbfaaec2a, 0xc3e29569, 0xbfa99999, 0x9999996c, 0x3fee6666, 0x6666666d},	/* -0.0525831=f(-0.05, 0.95)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d18, 0x3cb70000, 0x00000000, 0xbff00000, 0x00000000},	/* 3.14159=f(3.19189e-16, -1)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d18, 0x3cb70000, 0x00000000, 0xbfee6666, 0x66666666},	/* 3.14159=f(3.19189e-16, -0.95)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d17, 0x3cb70000, 0x00000000, 0xbfeccccc, 0xcccccccc},	/* 3.14159=f(3.19189e-16, -0.9)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d17, 0x3cb70000, 0x00000000, 0xbfeb3333, 0x33333332},	/* 3.14159=f(3.19189e-16, -0.85)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d17, 0x3cb70000, 0x00000000, 0xbfe99999, 0x99999998},	/* 3.14159=f(3.19189e-16, -0.8)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d17, 0x3cb70000, 0x00000000, 0xbfe7ffff, 0xfffffffe},	/* 3.14159=f(3.19189e-16, -0.75)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d17, 0x3cb70000, 0x00000000, 0xbfe66666, 0x66666664},	/* 3.14159=f(3.19189e-16, -0.7)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d17, 0x3cb70000, 0x00000000, 0xbfe4cccc, 0xccccccca},	/* 3.14159=f(3.19189e-16, -0.65)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d17, 0x3cb70000, 0x00000000, 0xbfe33333, 0x33333330},	/* 3.14159=f(3.19189e-16, -0.6)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d17, 0x3cb70000, 0x00000000, 0xbfe19999, 0x99999996},	/* 3.14159=f(3.19189e-16, -0.55)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d17, 0x3cb70000, 0x00000000, 0xbfdfffff, 0xfffffff9},	/* 3.14159=f(3.19189e-16, -0.5)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d17, 0x3cb70000, 0x00000000, 0xbfdccccc, 0xccccccc6},	/* 3.14159=f(3.19189e-16, -0.45)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d16, 0x3cb70000, 0x00000000, 0xbfd99999, 0x99999993},	/* 3.14159=f(3.19189e-16, -0.4)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d16, 0x3cb70000, 0x00000000, 0xbfd66666, 0x66666660},	/* 3.14159=f(3.19189e-16, -0.35)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d16, 0x3cb70000, 0x00000000, 0xbfd33333, 0x3333332d},	/* 3.14159=f(3.19189e-16, -0.3)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d15, 0x3cb70000, 0x00000000, 0xbfcfffff, 0xfffffff4},	/* 3.14159=f(3.19189e-16, -0.25)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d15, 0x3cb70000, 0x00000000, 0xbfc99999, 0x9999998e},	/* 3.14159=f(3.19189e-16, -0.2)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d13, 0x3cb70000, 0x00000000, 0xbfc33333, 0x33333328},	/* 3.14159=f(3.19189e-16, -0.15)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d11, 0x3cb70000, 0x00000000, 0xbfb99999, 0x99999983},	/* 3.14159=f(3.19189e-16, -0.1)*/
{64, 0,123,__LINE__, 0x400921fb, 0x54442d0a, 0x3cb70000, 0x00000000, 0xbfa99999, 0x9999996c},	/* 3.14159=f(3.19189e-16, -0.05)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3cb70000, 0x00000000, 0x3cb70000, 0x00000000},	/* 0.785398=f(3.19189e-16, 3.19189e-16)*/
{64, 0,123,__LINE__, 0x3cfcbfff, 0xffffffcc, 0x3cb70000, 0x00000000, 0x3fa99999, 0x999999c8},	/* 6.38378e-15=f(3.19189e-16, 0.05)*/
{64, 0,123,__LINE__, 0x3cecbfff, 0xffffffe6, 0x3cb70000, 0x00000000, 0x3fb99999, 0x999999b1},	/* 3.19189e-15=f(3.19189e-16, 0.1)*/
{64, 0,123,__LINE__, 0x3ce32aaa, 0xaaaaaa9f, 0x3cb70000, 0x00000000, 0x3fc33333, 0x3333333f},	/* 2.12793e-15=f(3.19189e-16, 0.15)*/
{64, 0,123,__LINE__, 0x3cdcbfff, 0xfffffff2, 0x3cb70000, 0x00000000, 0x3fc99999, 0x999999a6},	/* 1.59595e-15=f(3.19189e-16, 0.2)*/
{64, 0,123,__LINE__, 0x3cd6ffff, 0xfffffff7, 0x3cb70000, 0x00000000, 0x3fd00000, 0x00000006},	/* 1.27676e-15=f(3.19189e-16, 0.25)*/
{64, 0,123,__LINE__, 0x3cd32aaa, 0xaaaaaaa5, 0x3cb70000, 0x00000000, 0x3fd33333, 0x33333339},	/* 1.06396e-15=f(3.19189e-16, 0.3)*/
{64, 0,123,__LINE__, 0x3cd06db6, 0xdb6db6d7, 0x3cb70000, 0x00000000, 0x3fd66666, 0x6666666c},	/* 9.11969e-16=f(3.19189e-16, 0.35)*/
{64, 0,123,__LINE__, 0x3cccbfff, 0xfffffffa, 0x3cb70000, 0x00000000, 0x3fd99999, 0x9999999f},	/* 7.97973e-16=f(3.19189e-16, 0.4)*/
{64, 0,123,__LINE__, 0x3cc98e38, 0xe38e38df, 0x3cb70000, 0x00000000, 0x3fdccccc, 0xccccccd2},	/* 7.09309e-16=f(3.19189e-16, 0.45)*/
{64, 0,123,__LINE__, 0x3cc6ffff, 0xfffffffc, 0x3cb70000, 0x00000000, 0x3fe00000, 0x00000003},	/* 6.38378e-16=f(3.19189e-16, 0.5)*/
{64, 0,123,__LINE__, 0x3cc4e8ba, 0x2e8ba2e5, 0x3cb70000, 0x00000000, 0x3fe19999, 0x9999999d},	/* 5.80344e-16=f(3.19189e-16, 0.55)*/
{64, 0,123,__LINE__, 0x3cc32aaa, 0xaaaaaaa7, 0x3cb70000, 0x00000000, 0x3fe33333, 0x33333337},	/* 5.31982e-16=f(3.19189e-16, 0.6)*/
{64, 0,123,__LINE__, 0x3cc1b13b, 0x13b13b10, 0x3cb70000, 0x00000000, 0x3fe4cccc, 0xccccccd1},	/* 4.9106e-16=f(3.19189e-16, 0.65)*/
{64, 0,123,__LINE__, 0x3cc06db6, 0xdb6db6d8, 0x3cb70000, 0x00000000, 0x3fe66666, 0x6666666b},	/* 4.55984e-16=f(3.19189e-16, 0.7)*/
{64, 0,123,__LINE__, 0x3cbeaaaa, 0xaaaaaaa4, 0x3cb70000, 0x00000000, 0x3fe80000, 0x00000005},	/* 4.25585e-16=f(3.19189e-16, 0.75)*/
{64, 0,123,__LINE__, 0x3cbcbfff, 0xfffffffa, 0x3cb70000, 0x00000000, 0x3fe99999, 0x9999999f},	/* 3.98986e-16=f(3.19189e-16, 0.8)*/
{64, 0,123,__LINE__, 0x3cbb0f0f, 0x0f0f0f09, 0x3cb70000, 0x00000000, 0x3feb3333, 0x33333339},	/* 3.75517e-16=f(3.19189e-16, 0.85)*/
{64, 0,123,__LINE__, 0x3cb98e38, 0xe38e38de, 0x3cb70000, 0x00000000, 0x3feccccc, 0xccccccd3},	/* 3.54655e-16=f(3.19189e-16, 0.9)*/
{64, 0,123,__LINE__, 0x3cb835e5, 0x0d794359, 0x3cb70000, 0x00000000, 0x3fee6666, 0x6666666d},	/* 3.35989e-16=f(3.19189e-16, 0.95)*/
{64, 0,123,__LINE__, 0x4008bbaa, 0xbde5e29b, 0x3fa99999, 0x999999c8, 0xbff00000, 0x00000000},	/* 3.09163=f(0.05, -1)*/
{64, 0,123,__LINE__, 0x4008b64a, 0xa934a2c1, 0x3fa99999, 0x999999c8, 0xbfee6666, 0x66666666},	/* 3.08901=f(0.05, -0.95)*/
{64, 0,123,__LINE__, 0x4008b052, 0x20fc1e45, 0x3fa99999, 0x999999c8, 0xbfeccccc, 0xcccccccc},	/* 3.08609=f(0.05, -0.9)*/
{64, 0,123,__LINE__, 0x4008a9a6, 0x5b3c113c, 0x3fa99999, 0x999999c8, 0xbfeb3333, 0x33333332},	/* 3.08284=f(0.05, -0.85)*/
{64, 0,123,__LINE__, 0x4008a225, 0xe5677920, 0x3fa99999, 0x999999c8, 0xbfe99999, 0x99999998},	/* 3.07917=f(0.05, -0.8)*/
{64, 0,123,__LINE__, 0x400899a6, 0x7091335e, 0x3fa99999, 0x999999c8, 0xbfe7ffff, 0xfffffffe},	/* 3.07502=f(0.05, -0.75)*/
{64, 0,123,__LINE__, 0x40088ff1, 0xae5a77db, 0x3fa99999, 0x999999c8, 0xbfe66666, 0x66666664},	/* 3.07029=f(0.05, -0.7)*/
{64, 0,123,__LINE__, 0x400884c0, 0xbf722149, 0x3fa99999, 0x999999c8, 0xbfe4cccc, 0xccccccca},	/* 3.06482=f(0.05, -0.65)*/
{64, 0,123,__LINE__, 0x400877b5, 0x6104e565, 0x3fa99999, 0x999999c8, 0xbfe33333, 0x33333330},	/* 3.05845=f(0.05, -0.6)*/
{64, 0,123,__LINE__, 0x4008684f, 0x702f7c73, 0x3fa99999, 0x999999c8, 0xbfe19999, 0x99999996},	/* 3.05093=f(0.05, -0.55)*/
{64, 0,123,__LINE__, 0x400855dc, 0x402d16b4, 0x3fa99999, 0x999999c8, 0xbfdfffff, 0xfffffff9},	/* 3.04192=f(0.05, -0.5)*/
{64, 0,123,__LINE__, 0x40083f5b, 0x13741c75, 0x3fa99999, 0x999999c8, 0xbfdccccc, 0xccccccc6},	/* 3.03094=f(0.05, -0.45)*/
{64, 0,123,__LINE__, 0x4008234d, 0x7f6ecb9b, 0x3fa99999, 0x999999c8, 0xbfd99999, 0x99999993},	/* 3.01724=f(0.05, -0.4)*/
{64, 0,123,__LINE__, 0x4007ff60, 0x67fcc988, 0x3fa99999, 0x999999c8, 0xbfd66666, 0x66666660},	/* 2.9997=f(0.05, -0.35)*/
{64, 0,123,__LINE__, 0x4007cfc1, 0xdc006368, 0x3fa99999, 0x999999c8, 0xbfd33333, 0x3333332d},	/* 2.97644=f(0.05, -0.3)*/
{64, 0,123,__LINE__, 0x40078db7, 0x34b4bab4, 0x3fa99999, 0x999999c8, 0xbfcfffff, 0xfffffff4},	/* 2.9442=f(0.05, -0.25)*/
{64, 0,123,__LINE__, 0x40072c43, 0xf4b16506, 0x3fa99999, 0x999999c8, 0xbfc99999, 0x9999998e},	/* 2.89661=f(0.05, -0.2)*/
{64, 0,123,__LINE__, 0x40068f09, 0x5fdf5936, 0x3fa99999, 0x999999c8, 0xbfc33333, 0x33333328},	/* 2.81984=f(0.05, -0.15)*/
{64, 0,123,__LINE__, 0x40056c6e, 0x7397f5a6, 0x3fa99999, 0x999999c8, 0xbfb99999, 0x99999983},	/* 2.67795=f(0.05, -0.1)*/
{64, 0,123,__LINE__, 0x4002d97c, 0x7f3321c4, 0x3fa99999, 0x999999c8, 0xbfa99999, 0x9999996c},	/* 2.35619=f(0.05, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442cfc, 0x3fa99999, 0x999999c8, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.05, 3.19189e-16)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fa99999, 0x999999c8, 0x3fa99999, 0x999999c8},	/* 0.785398=f(0.05, 0.05)*/
{64, 0,123,__LINE__, 0x3fddac67, 0x0561bb66, 0x3fa99999, 0x999999c8, 0x3fb99999, 0x999999b1},	/* 0.463648=f(0.05, 0.1)*/
{64, 0,123,__LINE__, 0x3fd4978f, 0xa3269ef8, 0x3fa99999, 0x999999c8, 0x3fc33333, 0x3333333f},	/* 0.321751=f(0.05, 0.15)*/
{64, 0,123,__LINE__, 0x3fcf5b75, 0xf92c8105, 0x3fa99999, 0x999999c8, 0x3fc99999, 0x999999a6},	/* 0.244979=f(0.05, 0.2)*/
{63, 0,123,__LINE__, 0x3fc94441, 0xf8f7262f, 0x3fa99999, 0x999999c8, 0x3fd00000, 0x00000006},	/* 0.197396=f(0.05, 0.25)*/
{64, 0,123,__LINE__, 0x3fc52397, 0x843c9afd, 0x3fa99999, 0x999999c8, 0x3fd33333, 0x33333339},	/* 0.165149=f(0.05, 0.3)*/
{64, 0,123,__LINE__, 0x3fc229ae, 0xc47638f9, 0x3fa99999, 0x999999c8, 0x3fd66666, 0x6666666c},	/* 0.141897=f(0.05, 0.35)*/
{63, 0,123,__LINE__, 0x3fbfd5ba, 0x9aac2fa0, 0x3fa99999, 0x999999c8, 0x3fd99999, 0x9999999f},	/* 0.124355=f(0.05, 0.4)*/
{64, 0,123,__LINE__, 0x3fbc5408, 0x1a02145e, 0x3fa99999, 0x999999c8, 0x3fdccccc, 0xccccccd2},	/* 0.110657=f(0.05, 0.45)*/
{64, 0,123,__LINE__, 0x3fb983e2, 0x82e2cc75, 0x3fa99999, 0x999999c8, 0x3fe00000, 0x00000003},	/* 0.0996687=f(0.05, 0.5)*/
{64, 0,123,__LINE__, 0x3fb7357c, 0x82961494, 0x3fa99999, 0x999999c8, 0x3fe19999, 0x9999999d},	/* 0.0906599=f(0.05, 0.55)*/
{64, 0,123,__LINE__, 0x3fb548be, 0x67e8f661, 0x3fa99999, 0x999999c8, 0x3fe33333, 0x33333337},	/* 0.0831412=f(0.05, 0.6)*/
{64, 0,123,__LINE__, 0x3fb3a752, 0x9a4179e9, 0x3fa99999, 0x999999c8, 0x3fe4cccc, 0xccccccd1},	/* 0.0767719=f(0.05, 0.65)*/
{64, 0,123,__LINE__, 0x3fb24134, 0xbd36a7a2, 0x3fa99999, 0x999999c8, 0x3fe66666, 0x6666666b},	/* 0.0713075=f(0.05, 0.7)*/
{64, 0,123,__LINE__, 0x3fb10a9c, 0x765f373f, 0x3fa99999, 0x999999c8, 0x3fe80000, 0x00000005},	/* 0.0665682=f(0.05, 0.75)*/
{63, 0,123,__LINE__, 0x3faff55b, 0xb72cfe1d, 0x3fa99999, 0x999999c8, 0x3fe99999, 0x9999999f},	/* 0.0624188=f(0.05, 0.8)*/
{63, 0,123,__LINE__, 0x3fae153e, 0x4206f725, 0x3fa99999, 0x999999c8, 0x3feb3333, 0x33333339},	/* 0.0587558=f(0.05, 0.85)*/
{64, 0,123,__LINE__, 0x3fac6a4c, 0xd203b4e9, 0x3fa99999, 0x999999c8, 0x3feccccc, 0xccccccd3},	/* 0.0554985=f(0.05, 0.9)*/
{64, 0,123,__LINE__, 0x3faaec2a, 0xc3e295c9, 0x3fa99999, 0x999999c8, 0x3fee6666, 0x6666666d},	/* 0.0525831=f(0.05, 0.95)*/
{64, 0,123,__LINE__, 0x400855dc, 0x402d16b5, 0x3fb99999, 0x999999b1, 0xbff00000, 0x00000000},	/* 3.04192=f(0.1, -1)*/
{64, 0,123,__LINE__, 0x40084b31, 0x9bd4918c, 0x3fb99999, 0x999999b1, 0xbfee6666, 0x66666666},	/* 3.03672=f(0.1, -0.95)*/
{64, 0,123,__LINE__, 0x40083f5b, 0x13741c76, 0x3fb99999, 0x999999b1, 0xbfeccccc, 0xcccccccc},	/* 3.03094=f(0.1, -0.9)*/
{64, 0,123,__LINE__, 0x40083224, 0x9ea440f5, 0x3fb99999, 0x999999b1, 0xbfeb3333, 0x33333332},	/* 3.02448=f(0.1, -0.85)*/
{64, 0,123,__LINE__, 0x4008234d, 0x7f6ecb9c, 0x3fb99999, 0x999999b1, 0xbfe99999, 0x99999998},	/* 3.01724=f(0.1, -0.8)*/
{63, 0,123,__LINE__, 0x40081284, 0x26c22f57, 0x3fb99999, 0x999999b1, 0xbfe7ffff, 0xfffffffe},	/* 3.00904=f(0.1, -0.75)*/
{64, 0,123,__LINE__, 0x4007ff60, 0x67fcc989, 0x3fb99999, 0x999999b1, 0xbfe66666, 0x66666664},	/* 2.9997=f(0.1, -0.7)*/
{64, 0,123,__LINE__, 0x4007e95b, 0x1e3a76c3, 0x3fb99999, 0x999999b1, 0xbfe4cccc, 0xccccccca},	/* 2.98894=f(0.1, -0.65)*/
{64, 0,123,__LINE__, 0x4007cfc1, 0xdc006369, 0x3fb99999, 0x999999b1, 0xbfe33333, 0x33333330},	/* 2.97644=f(0.1, -0.6)*/
{64, 0,123,__LINE__, 0x4007b1a4, 0x4c26bcc8, 0x3fb99999, 0x999999b1, 0xbfe19999, 0x99999996},	/* 2.96174=f(0.1, -0.55)*/
{64, 0,123,__LINE__, 0x40078db7, 0x34b4bab6, 0x3fb99999, 0x999999b1, 0xbfdfffff, 0xfffffff9},	/* 2.9442=f(0.1, -0.5)*/
{64, 0,123,__LINE__, 0x40076225, 0xd32abdba, 0x3fb99999, 0x999999b1, 0xbfdccccc, 0xccccccc6},	/* 2.92292=f(0.1, -0.45)*/
{64, 0,123,__LINE__, 0x40072c43, 0xf4b16508, 0x3fb99999, 0x999999b1, 0xbfd99999, 0x99999993},	/* 2.89661=f(0.1, -0.4)*/
{64, 0,123,__LINE__, 0x4006e806, 0x2854db5c, 0x3fb99999, 0x999999b1, 0xbfd66666, 0x66666660},	/* 2.86329=f(0.1, -0.35)*/
{64, 0,123,__LINE__, 0x40068f09, 0x5fdf5939, 0x3fb99999, 0x999999b1, 0xbfd33333, 0x3333332d},	/* 2.81984=f(0.1, -0.3)*/
{64, 0,123,__LINE__, 0x400616b4, 0x66d73d5d, 0x3fb99999, 0x999999b1, 0xbfcfffff, 0xfffffff4},	/* 2.76109=f(0.1, -0.25)*/
{64, 0,123,__LINE__, 0x40056c6e, 0x7397f5aa, 0x3fb99999, 0x999999b1, 0xbfc99999, 0x9999998e},	/* 2.67795=f(0.1, -0.2)*/
{63, 0,123,__LINE__, 0x40046dc0, 0x9ec2942d, 0x3fb99999, 0x999999b1, 0xbfc33333, 0x33333328},	/* 2.55359=f(0.1, -0.15)*/
{64, 0,123,__LINE__, 0x4002d97c, 0x7f3321cb, 0x3fb99999, 0x999999b1, 0xbfb99999, 0x99999983},	/* 2.35619=f(0.1, -0.1)*/
{63, 0,123,__LINE__, 0x4000468a, 0x8ace4ded, 0x3fb99999, 0x999999b1, 0xbfa99999, 0x9999996c},	/* 2.03444=f(0.1, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d0a, 0x3fb99999, 0x999999b1, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.1, 3.19189e-16)*/
{64, 0,123,__LINE__, 0x3ff1b6e1, 0x92ebbe3f, 0x3fb99999, 0x999999b1, 0x3fa99999, 0x999999c8},	/* 1.10715=f(0.1, 0.05)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fb99999, 0x999999b1, 0x3fb99999, 0x999999b1},	/* 0.785398=f(0.1, 0.1)*/
{64, 0,123,__LINE__, 0x3fe2d0ea, 0xd606639a, 0x3fb99999, 0x999999b1, 0x3fc33333, 0x3333333f},	/* 0.588003=f(0.1, 0.15)*/
{63, 0,123,__LINE__, 0x3fddac67, 0x0561bb5a, 0x3fb99999, 0x999999b1, 0x3fc99999, 0x999999a6},	/* 0.463648=f(0.1, 0.2)*/
{63, 0,123,__LINE__, 0x3fd85a37, 0x6b677dcc, 0x3fb99999, 0x999999b1, 0x3fd00000, 0x00000006},	/* 0.380506=f(0.1, 0.25)*/
{64, 0,123,__LINE__, 0x3fd4978f, 0xa3269eed, 0x3fb99999, 0x999999b1, 0x3fd33333, 0x33333339},	/* 0.321751=f(0.1, 0.3)*/
{63, 0,123,__LINE__, 0x3fd1cfa9, 0x5f7a8dda, 0x3fb99999, 0x999999b1, 0x3fd66666, 0x6666666c},	/* 0.2783=f(0.1, 0.35)*/
{63, 0,123,__LINE__, 0x3fcf5b75, 0xf92c80f3, 0x3fb99999, 0x999999b1, 0x3fd99999, 0x9999999f},	/* 0.244979=f(0.1, 0.4)*/
{64, 0,123,__LINE__, 0x3fcbfd58, 0x1196f5d5, 0x3fb99999, 0x999999b1, 0x3fdccccc, 0xccccccd2},	/* 0.218669=f(0.1, 0.45)*/
{64, 0,123,__LINE__, 0x3fc94441, 0xf8f7261d, 0x3fb99999, 0x999999b1, 0x3fe00000, 0x00000003},	/* 0.197396=f(0.1, 0.5)*/
{64, 0,123,__LINE__, 0x3fc70570, 0x81d704f6, 0x3fb99999, 0x999999b1, 0x3fe19999, 0x9999999d},	/* 0.179853=f(0.1, 0.55)*/
{63, 0,123,__LINE__, 0x3fc52397, 0x843c9aec, 0x3fb99999, 0x999999b1, 0x3fe33333, 0x33333337},	/* 0.165149=f(0.1, 0.6)*/
{64, 0,123,__LINE__, 0x3fc38a03, 0x609b6553, 0x3fb99999, 0x999999b1, 0x3fe4cccc, 0xccccccd1},	/* 0.152649=f(0.1, 0.65)*/
{64, 0,123,__LINE__, 0x3fc229ae, 0xc47638e9, 0x3fb99999, 0x999999b1, 0x3fe66666, 0x6666666b},	/* 0.141897=f(0.1, 0.7)*/
{64, 0,123,__LINE__, 0x3fc0f772, 0xd81fdc17, 0x3fb99999, 0x999999b1, 0x3fe80000, 0x00000005},	/* 0.132552=f(0.1, 0.75)*/
{63, 0,123,__LINE__, 0x3fbfd5ba, 0x9aac2f84, 0x3fb99999, 0x999999b1, 0x3fe99999, 0x9999999f},	/* 0.124355=f(0.1, 0.8)*/
{64, 0,123,__LINE__, 0x3fbdfad6, 0xb3fd845e, 0x3fb99999, 0x999999b1, 0x3feb3333, 0x33333339},	/* 0.117109=f(0.1, 0.85)*/
{63, 0,123,__LINE__, 0x3fbc5408, 0x1a021444, 0x3fb99999, 0x999999b1, 0x3feccccc, 0xccccccd3},	/* 0.110657=f(0.1, 0.9)*/
{64, 0,123,__LINE__, 0x3fbad937, 0x0df3718e, 0x3fb99999, 0x999999b1, 0x3fee6666, 0x6666666d},	/* 0.104877=f(0.1, 0.95)*/
{64, 0,123,__LINE__, 0x4007f10e, 0x1dc6b047, 0x3fc33333, 0x3333333f, 0xbff00000, 0x00000000},	/* 2.9927=f(0.15, -1)*/
{64, 0,123,__LINE__, 0x4007e142, 0xd82322e9, 0x3fc33333, 0x3333333f, 0xbfee6666, 0x66666666},	/* 2.98499=f(0.15, -0.95)*/
{64, 0,123,__LINE__, 0x4007cfc1, 0xdc00636a, 0x3fc33333, 0x3333333f, 0xbfeccccc, 0xcccccccc},	/* 2.97644=f(0.15, -0.9)*/
{64, 0,123,__LINE__, 0x4007bc40, 0xca9216fd, 0x3fc33333, 0x3333333f, 0xbfeb3333, 0x33333332},	/* 2.96692=f(0.15, -0.85)*/
{64, 0,123,__LINE__, 0x4007a663, 0x9f874767, 0x3fc33333, 0x3333333f, 0xbfe99999, 0x99999998},	/* 2.95624=f(0.15, -0.8)*/
{64, 0,123,__LINE__, 0x40078db7, 0x34b4bab6, 0x3fc33333, 0x3333333f, 0xbfe7ffff, 0xfffffffe},	/* 2.9442=f(0.15, -0.75)*/
{64, 0,123,__LINE__, 0x400771a9, 0xa0af69dc, 0x3fc33333, 0x3333333f, 0xbfe66666, 0x66666664},	/* 2.9305=f(0.15, -0.7)*/
{64, 0,123,__LINE__, 0x4007517f, 0x6a2ae17e, 0x3fc33333, 0x3333333f, 0xbfe4cccc, 0xccccccca},	/* 2.91479=f(0.15, -0.65)*/
{64, 0,123,__LINE__, 0x40072c43, 0xf4b16509, 0x3fc33333, 0x3333333f, 0xbfe33333, 0x33333330},	/* 2.89661=f(0.15, -0.6)*/
{64, 0,123,__LINE__, 0x400700b2, 0x9327680d, 0x3fc33333, 0x3333333f, 0xbfe19999, 0x99999996},	/* 2.87534=f(0.15, -0.55)*/
{64, 0,123,__LINE__, 0x4006cd14, 0x07805736, 0x3fc33333, 0x3333333f, 0xbfdfffff, 0xfffffff9},	/* 2.85014=f(0.15, -0.5)*/
{64, 0,123,__LINE__, 0x40068f09, 0x5fdf593a, 0x3fc33333, 0x3333333f, 0xbfdccccc, 0xccccccc6},	/* 2.81984=f(0.15, -0.45)*/
{64, 0,123,__LINE__, 0x40064338, 0x2c079138, 0x3fc33333, 0x3333333f, 0xbfd99999, 0x99999993},	/* 2.78282=f(0.15, -0.4)*/
{64, 0,123,__LINE__, 0x4005e4c3, 0x6ca01188, 0x3fc33333, 0x3333333f, 0xbfd66666, 0x66666660},	/* 2.7367=f(0.15, -0.35)*/
{64, 0,123,__LINE__, 0x40056c6e, 0x7397f5ab, 0x3fc33333, 0x3333333f, 0xbfd33333, 0x3333332d},	/* 2.67795=f(0.15, -0.3)*/
{63, 0,123,__LINE__, 0x4004cf33, 0xdec5e9dd, 0x3fc33333, 0x3333333f, 0xbfcfffff, 0xfffffff4},	/* 2.60117=f(0.15, -0.25)*/
{64, 0,123,__LINE__, 0x4003fc17, 0x6b7a855c, 0x3fc33333, 0x3333333f, 0xbfc99999, 0x9999998e},	/* 2.49809=f(0.15, -0.2)*/
{63, 0,123,__LINE__, 0x4002d97c, 0x7f3321cd, 0x3fc33333, 0x3333333f, 0xbfc33333, 0x33333328},	/* 2.35619=f(0.15, -0.15)*/
{64, 0,123,__LINE__, 0x40014538, 0x5fa3af6c, 0x3fc33333, 0x3333333f, 0xbfb99999, 0x99999983},	/* 2.1588=f(0.15, -0.1)*/
{64, 0,123,__LINE__, 0x3ffe47df, 0x3d0dd4c5, 0x3fc33333, 0x3333333f, 0xbfa99999, 0x9999996c},	/* 1.89255=f(0.15, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d0f, 0x3fc33333, 0x3333333f, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.15, 3.19189e-16)*/
{64, 0,123,__LINE__, 0x3ff3fc17, 0x6b7a855a, 0x3fc33333, 0x3333333f, 0x3fa99999, 0x999999c8},	/* 1.24905=f(0.15, 0.05)*/
{64, 0,123,__LINE__, 0x3fef730b, 0xd281f697, 0x3fc33333, 0x3333333f, 0x3fb99999, 0x999999b1},	/* 0.982794=f(0.15, 0.1)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fc33333, 0x3333333f, 0x3fc33333, 0x3333333f},	/* 0.785398=f(0.15, 0.15)*/
{64, 0,123,__LINE__, 0x3fe4978f, 0xa3269ee3, 0x3fc33333, 0x3333333f, 0x3fc99999, 0x999999a6},	/* 0.643501=f(0.15, 0.2)*/
{64, 0,123,__LINE__, 0x3fe14b1d, 0xd5f90ce4, 0x3fc33333, 0x3333333f, 0x3fd00000, 0x00000006},	/* 0.54042=f(0.15, 0.25)*/
{64, 0,123,__LINE__, 0x3fddac67, 0x0561bb57, 0x3fc33333, 0x3333333f, 0x3fd33333, 0x33333339},	/* 0.463648=f(0.15, 0.3)*/
{64, 0,123,__LINE__, 0x3fd9e9bf, 0x3d20dc79, 0x3fc33333, 0x3333333f, 0x3fd66666, 0x6666666c},	/* 0.404892=f(0.15, 0.35)*/
{64, 0,123,__LINE__, 0x3fd6f619, 0x41e4def9, 0x3fc33333, 0x3333333f, 0x3fd99999, 0x9999999f},	/* 0.358771=f(0.15, 0.4)*/
{63, 0,123,__LINE__, 0x3fd4978f, 0xa3269ee9, 0x3fc33333, 0x3333333f, 0x3fdccccc, 0xccccccd2},	/* 0.321751=f(0.15, 0.45)*/
{64, 0,123,__LINE__, 0x3fd2a73a, 0x661eaf0d, 0x3fc33333, 0x3333333f, 0x3fe00000, 0x00000003},	/* 0.291457=f(0.15, 0.5)*/
{64, 0,123,__LINE__, 0x3fd10a46, 0x08e62851, 0x3fc33333, 0x3333333f, 0x3fe19999, 0x9999999d},	/* 0.266252=f(0.15, 0.55)*/
{63, 0,123,__LINE__, 0x3fcf5b75, 0xf92c80ea, 0x3fc33333, 0x3333333f, 0x3fe33333, 0x33333337},	/* 0.244979=f(0.15, 0.6)*/
{64, 0,123,__LINE__, 0x3fcd07be, 0xa194b99d, 0x3fc33333, 0x3333333f, 0x3fe4cccc, 0xccccccd1},	/* 0.226799=f(0.15, 0.65)*/
{64, 0,123,__LINE__, 0x3fcb051b, 0x394c33b5, 0x3fc33333, 0x3333333f, 0x3fe66666, 0x6666666b},	/* 0.211093=f(0.15, 0.7)*/
{64, 0,123,__LINE__, 0x3fc94441, 0xf8f72615, 0x3fc33333, 0x3333333f, 0x3fe80000, 0x00000005},	/* 0.197396=f(0.15, 0.75)*/
{64, 0,123,__LINE__, 0x3fc7b97b, 0x4bce5b0c, 0x3fc33333, 0x3333333f, 0x3fe99999, 0x9999999f},	/* 0.185348=f(0.15, 0.8)*/
{64, 0,123,__LINE__, 0x3fc65ba8, 0x9b2161b4, 0x3fc33333, 0x3333333f, 0x3feb3333, 0x33333339},	/* 0.174672=f(0.15, 0.85)*/
{64, 0,123,__LINE__, 0x3fc52397, 0x843c9ae6, 0x3fc33333, 0x3333333f, 0x3feccccc, 0xccccccd3},	/* 0.165149=f(0.15, 0.9)*/
{63, 0,123,__LINE__, 0x3fc40b87, 0xc210a2ed, 0x3fc33333, 0x3333333f, 0x3fee6666, 0x6666666d},	/* 0.156602=f(0.15, 0.95)*/
{64, 0,123,__LINE__, 0x40078db7, 0x34b4bab7, 0x3fc99999, 0x999999a6, 0xbff00000, 0x00000000},	/* 2.9442=f(0.2, -1)*/
{64, 0,123,__LINE__, 0x40077907, 0x8c2f83ea, 0x3fc99999, 0x999999a6, 0xbfee6666, 0x66666666},	/* 2.9341=f(0.2, -0.95)*/
{64, 0,123,__LINE__, 0x40076225, 0xd32abdbb, 0x3fc99999, 0x999999a6, 0xbfeccccc, 0xcccccccc},	/* 2.92292=f(0.2, -0.9)*/
{64, 0,123,__LINE__, 0x400748b5, 0x43f409df, 0x3fc99999, 0x999999a6, 0xbfeb3333, 0x33333332},	/* 2.9105=f(0.2, -0.85)*/
{64, 0,123,__LINE__, 0x40072c43, 0xf4b16509, 0x3fc99999, 0x999999a6, 0xbfe99999, 0x99999998},	/* 2.89661=f(0.2, -0.8)*/
{64, 0,123,__LINE__, 0x40070c44, 0x9f55a997, 0x3fc99999, 0x999999a6, 0xbfe7ffff, 0xfffffffe},	/* 2.88099=f(0.2, -0.75)*/
{64, 0,123,__LINE__, 0x4006e806, 0x2854db5d, 0x3fc99999, 0x999999a6, 0xbfe66666, 0x66666664},	/* 2.86329=f(0.2, -0.7)*/
{64, 0,123,__LINE__, 0x4006bea7, 0xebdbbf5b, 0x3fc99999, 0x999999a6, 0xbfe4cccc, 0xccccccca},	/* 2.84309=f(0.2, -0.65)*/
{64, 0,123,__LINE__, 0x40068f09, 0x5fdf593b, 0x3fc99999, 0x999999a6, 0xbfe33333, 0x33333330},	/* 2.81984=f(0.2, -0.6)*/
{64, 0,123,__LINE__, 0x400657b2, 0xe092b034, 0x3fc99999, 0x999999a6, 0xbfe19999, 0x99999996},	/* 2.79282=f(0.2, -0.55)*/
{64, 0,123,__LINE__, 0x400616b4, 0x66d73d5e, 0x3fc99999, 0x999999a6, 0xbfdfffff, 0xfffffff9},	/* 2.76109=f(0.2, -0.5)*/
{64, 0,123,__LINE__, 0x4005c975, 0x54f4b39c, 0x3fc99999, 0x999999a6, 0xbfdccccc, 0xccccccc6},	/* 2.72337=f(0.2, -0.45)*/
{64, 0,123,__LINE__, 0x40056c6e, 0x7397f5ac, 0x3fc99999, 0x999999a6, 0xbfd99999, 0x99999993},	/* 2.67795=f(0.2, -0.4)*/
{64, 0,123,__LINE__, 0x4004fac5, 0x404fe6d9, 0x3fc99999, 0x999999a6, 0xbfd66666, 0x66666660},	/* 2.62245=f(0.2, -0.35)*/
{64, 0,123,__LINE__, 0x40046dc0, 0x9ec29430, 0x3fc99999, 0x999999a6, 0xbfd33333, 0x3333332d},	/* 2.55359=f(0.2, -0.3)*/
{64, 0,123,__LINE__, 0x4003bc1c, 0xc0033270, 0x3fc99999, 0x999999a6, 0xbfcfffff, 0xfffffff4},	/* 2.46685=f(0.2, -0.25)*/
{64, 0,123,__LINE__, 0x4002d97c, 0x7f3321ce, 0x3fc99999, 0x999999a6, 0xbfc99999, 0x9999998e},	/* 2.35619=f(0.2, -0.2)*/
{64, 0,123,__LINE__, 0x4001b6e1, 0x92ebbe40, 0x3fc99999, 0x999999a6, 0xbfc33333, 0x33333328},	/* 2.2143=f(0.2, -0.15)*/
{64, 0,123,__LINE__, 0x4000468a, 0x8ace4df2, 0x3fc99999, 0x999999a6, 0xbfb99999, 0x99999983},	/* 2.03444=f(0.2, -0.1)*/
{63, 0,123,__LINE__, 0x3ffd0d6a, 0x1369bd2b, 0x3fc99999, 0x999999a6, 0xbfa99999, 0x9999996c},	/* 1.81577=f(0.2, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d11, 0x3fc99999, 0x999999a6, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.2, 3.19189e-16)*/
{64, 0,123,__LINE__, 0x3ff5368c, 0x951e9cf8, 0x3fc99999, 0x999999a6, 0x3fa99999, 0x999999c8},	/* 1.32582=f(0.2, 0.05)*/
{64, 0,123,__LINE__, 0x3ff1b6e1, 0x92ebbe42, 0x3fc99999, 0x999999a6, 0x3fb99999, 0x999999b1},	/* 1.10715=f(0.2, 0.1)*/
{63, 0,123,__LINE__, 0x3fedac67, 0x0561bb4d, 0x3fc99999, 0x999999a6, 0x3fc33333, 0x3333333f},	/* 0.927295=f(0.2, 0.15)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fc99999, 0x999999a6, 0x3fc99999, 0x999999a6},	/* 0.785398=f(0.2, 0.2)*/
{64, 0,123,__LINE__, 0x3fe5977a, 0x5103ea94, 0x3fc99999, 0x999999a6, 0x3fd00000, 0x00000006},	/* 0.674741=f(0.2, 0.25)*/
{64, 0,123,__LINE__, 0x3fe2d0ea, 0xd6066398, 0x3fc99999, 0x999999a6, 0x3fd33333, 0x33333339},	/* 0.588003=f(0.2, 0.3)*/
{64, 0,123,__LINE__, 0x3fe09cd8, 0x4fd118f7, 0x3fc99999, 0x999999a6, 0x3fd66666, 0x6666666c},	/* 0.519146=f(0.2, 0.35)*/
{64, 0,123,__LINE__, 0x3fddac67, 0x0561bb56, 0x3fc99999, 0x999999a6, 0x3fd99999, 0x9999999f},	/* 0.463648=f(0.2, 0.4)*/
{64, 0,123,__LINE__, 0x3fdac42f, 0xfa7bcbd6, 0x3fc99999, 0x999999a6, 0x3fdccccc, 0xccccccd2},	/* 0.418224=f(0.2, 0.45)*/
{64, 0,123,__LINE__, 0x3fd85a37, 0x6b677dc6, 0x3fc99999, 0x999999a6, 0x3fe00000, 0x00000003},	/* 0.380506=f(0.2, 0.5)*/
{64, 0,123,__LINE__, 0x3fd65243, 0x9d8be71c, 0x3fc99999, 0x999999a6, 0x3fe19999, 0x9999999d},	/* 0.348771=f(0.2, 0.55)*/
{63, 0,123,__LINE__, 0x3fd4978f, 0xa3269ee7, 0x3fc99999, 0x999999a6, 0x3fe33333, 0x33333337},	/* 0.321751=f(0.2, 0.6)*/
{64, 0,123,__LINE__, 0x3fd31a9b, 0x43436de6, 0x3fc99999, 0x999999a6, 0x3fe4cccc, 0xccccccd1},	/* 0.298499=f(0.2, 0.65)*/
{64, 0,123,__LINE__, 0x3fd1cfa9, 0x5f7a8dd3, 0x3fc99999, 0x999999a6, 0x3fe66666, 0x6666666b},	/* 0.2783=f(0.2, 0.7)*/
{64, 0,123,__LINE__, 0x3fd0adb5, 0xa7741c08, 0x3fc99999, 0x999999a6, 0x3fe80000, 0x00000005},	/* 0.260602=f(0.2, 0.75)*/
{63, 0,123,__LINE__, 0x3fcf5b75, 0xf92c80e6, 0x3fc99999, 0x999999a6, 0x3fe99999, 0x9999999f},	/* 0.244979=f(0.2, 0.8)*/
{64, 0,123,__LINE__, 0x3fcd9461, 0x05023393, 0x3fc99999, 0x999999a6, 0x3feb3333, 0x33333339},	/* 0.231091=f(0.2, 0.85)*/
{64, 0,123,__LINE__, 0x3fcbfd58, 0x1196f5c9, 0x3fc99999, 0x999999a6, 0x3feccccc, 0xccccccd3},	/* 0.218669=f(0.2, 0.9)*/
{63, 0,123,__LINE__, 0x3fca8f3c, 0x814a92dd, 0x3fc99999, 0x999999a6, 0x3fee6666, 0x6666666d},	/* 0.207496=f(0.2, 0.95)*/
{64, 0,123,__LINE__, 0x40072c43, 0xf4b1650a, 0x3fd00000, 0x00000006, 0xbff00000, 0x00000000},	/* 2.89661=f(0.25, -1)*/
{64, 0,123,__LINE__, 0x400712fb, 0x97e1e342, 0x3fd00000, 0x00000006, 0xbfee6666, 0x66666666},	/* 2.88427=f(0.25, -0.95)*/
{64, 0,123,__LINE__, 0x4006f715, 0x259aea13, 0x3fd00000, 0x00000006, 0xbfeccccc, 0xcccccccc},	/* 2.87065=f(0.25, -0.9)*/
{64, 0,123,__LINE__, 0x4006d825, 0xfdaafada, 0x3fd00000, 0x00000006, 0xbfeb3333, 0x33333332},	/* 2.85554=f(0.25, -0.85)*/
{64, 0,123,__LINE__, 0x4006b5ac, 0x6d632f9e, 0x3fd00000, 0x00000006, 0xbfe99999, 0x99999998},	/* 2.83871=f(0.25, -0.8)*/
{64, 0,123,__LINE__, 0x40068f09, 0x5fdf593b, 0x3fd00000, 0x00000006, 0xbfe7ffff, 0xfffffffe},	/* 2.81984=f(0.25, -0.75)*/
{64, 0,123,__LINE__, 0x40066377, 0xfe555c40, 0x3fd00000, 0x00000006, 0xbfe66666, 0x66666664},	/* 2.79857=f(0.25, -0.7)*/
{64, 0,123,__LINE__, 0x40063202, 0x7e829b4b, 0x3fd00000, 0x00000006, 0xbfe4cccc, 0xccccccca},	/* 2.77442=f(0.25, -0.65)*/
{64, 0,123,__LINE__, 0x4005f973, 0x15254855, 0x3fd00000, 0x00000006, 0xbfe33333, 0x33333330},	/* 2.7468=f(0.25, -0.6)*/
{63, 0,123,__LINE__, 0x4005b83f, 0xa76fbdaf, 0x3fd00000, 0x00000006, 0xbfe19999, 0x99999996},	/* 2.71497=f(0.25, -0.55)*/
{64, 0,123,__LINE__, 0x40056c6e, 0x7397f5ac, 0x3fd00000, 0x00000006, 0xbfdfffff, 0xfffffff9},	/* 2.67795=f(0.25, -0.5)*/
{64, 0,123,__LINE__, 0x40051371, 0xab22738a, 0x3fd00000, 0x00000006, 0xbfdccccc, 0xccccccc6},	/* 2.63449=f(0.25, -0.45)*/
{64, 0,123,__LINE__, 0x4004a9f8, 0x694c6d69, 0x3fd00000, 0x00000006, 0xbfd99999, 0x99999993},	/* 2.58299=f(0.25, -0.4)*/
{64, 0,123,__LINE__, 0x40042bb5, 0xf776eb7e, 0x3fd00000, 0x00000006, 0xbfd66666, 0x66666660},	/* 2.52134=f(0.25, -0.35)*/
{64, 0,123,__LINE__, 0x40039328, 0x6347d273, 0x3fd00000, 0x00000006, 0xbfd33333, 0x3333332d},	/* 2.44685=f(0.25, -0.3)*/
{64, 0,123,__LINE__, 0x4002d97c, 0x7f3321cf, 0x3fd00000, 0x00000006, 0xbfcfffff, 0xfffffff4},	/* 2.35619=f(0.25, -0.25)*/
{64, 0,123,__LINE__, 0x4001f6dc, 0x3e63112d, 0x3fd00000, 0x00000006, 0xbfc99999, 0x9999998e},	/* 2.24554=f(0.25, -0.2)*/
{64, 0,123,__LINE__, 0x4000e3c5, 0x1fa059c1, 0x3fd00000, 0x00000006, 0xbfc33333, 0x33333328},	/* 2.11122=f(0.25, -0.15)*/
{63, 0,123,__LINE__, 0x3fff3889, 0x2f1e0c81, 0x3fd00000, 0x00000006, 0xbfb99999, 0x99999983},	/* 1.9513=f(0.25, -0.1)*/
{63, 0,123,__LINE__, 0x3ffc4a83, 0x936311d3, 0x3fd00000, 0x00000006, 0xbfa99999, 0x9999996c},	/* 1.76819=f(0.25, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d13, 0x3fd00000, 0x00000006, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.25, 3.19189e-16)*/
{64, 0,123,__LINE__, 0x3ff5f973, 0x15254852, 0x3fd00000, 0x00000006, 0x3fa99999, 0x999999c8},	/* 1.3734=f(0.25, 0.05)*/
{64, 0,123,__LINE__, 0x3ff30b6d, 0x796a4da5, 0x3fd00000, 0x00000006, 0x3fb99999, 0x999999b1},	/* 1.19029=f(0.25, 0.1)*/
{64, 0,123,__LINE__, 0x3ff07c6c, 0x6947a6a6, 0x3fd00000, 0x00000006, 0x3fc33333, 0x3333333f},	/* 1.03038=f(0.25, 0.15)*/
{64, 0,123,__LINE__, 0x3fecac7c, 0x57846f9d, 0x3fd00000, 0x00000006, 0x3fc99999, 0x999999a6},	/* 0.896055=f(0.25, 0.2)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fd00000, 0x00000006, 0x3fd00000, 0x00000006},	/* 0.785398=f(0.25, 0.25)*/
{64, 0,123,__LINE__, 0x3fe63b4b, 0xc3f16a8c, 0x3fd00000, 0x00000006, 0x3fd33333, 0x33333339},	/* 0.694738=f(0.25, 0.3)*/
{64, 0,123,__LINE__, 0x3fe3d915, 0x73350663, 0x3fd00000, 0x00000006, 0x3fd66666, 0x6666666c},	/* 0.620249=f(0.25, 0.35)*/
{64, 0,123,__LINE__, 0x3fe1e00b, 0xabdefeb6, 0x3fd00000, 0x00000006, 0x3fd99999, 0x9999999f},	/* 0.558599=f(0.25, 0.4)*/
{64, 0,123,__LINE__, 0x3fe03a26, 0xa486e634, 0x3fd00000, 0x00000006, 0x3fdccccc, 0xccccccd2},	/* 0.507099=f(0.25, 0.45)*/
{64, 0,123,__LINE__, 0x3fddac67, 0x0561bb54, 0x3fd00000, 0x00000006, 0x3fe00000, 0x00000003},	/* 0.463648=f(0.25, 0.5)*/
{63, 0,123,__LINE__, 0x3fdb4ddd, 0x66a37b44, 0x3fd00000, 0x00000006, 0x3fe19999, 0x9999999d},	/* 0.426627=f(0.25, 0.55)*/
{64, 0,123,__LINE__, 0x3fd94441, 0xf8f7260f, 0x3fd00000, 0x00000006, 0x3fe33333, 0x33333337},	/* 0.394791=f(0.25, 0.6)*/
{64, 0,123,__LINE__, 0x3fd77fc6, 0xae0c8e66, 0x3fd00000, 0x00000006, 0x3fe4cccc, 0xccccccd1},	/* 0.367174=f(0.25, 0.65)*/
{64, 0,123,__LINE__, 0x3fd5f41a, 0xaf7686c0, 0x3fd00000, 0x00000006, 0x3fe66666, 0x6666666b},	/* 0.343024=f(0.25, 0.7)*/
{64, 0,123,__LINE__, 0x3fd4978f, 0xa3269ee4, 0x3fd00000, 0x00000006, 0x3fe80000, 0x00000005},	/* 0.321751=f(0.25, 0.75)*/
{64, 0,123,__LINE__, 0x3fd36277, 0x3707ebcf, 0x3fd00000, 0x00000006, 0x3fe99999, 0x9999999f},	/* 0.302885=f(0.25, 0.8)*/
{64, 0,123,__LINE__, 0x3fd24eaa, 0xb4c991f1, 0x3fd00000, 0x00000006, 0x3feb3333, 0x33333339},	/* 0.286051=f(0.25, 0.85)*/
{64, 0,123,__LINE__, 0x3fd15731, 0x754a1824, 0x3fd00000, 0x00000006, 0x3feccccc, 0xccccccd3},	/* 0.270947=f(0.25, 0.9)*/
{64, 0,123,__LINE__, 0x3fd077fd, 0xe3124ead, 0x3fd00000, 0x00000006, 0x3fee6666, 0x6666666d},	/* 0.257324=f(0.25, 0.95)*/
{64, 0,123,__LINE__, 0x4006cd14, 0x07805737, 0x3fd33333, 0x33333339, 0xbff00000, 0x00000000},	/* 2.85014=f(0.3, -1)*/
{64, 0,123,__LINE__, 0x4006af8a, 0xb51a6804, 0x3fd33333, 0x33333339, 0xbfee6666, 0x66666666},	/* 2.83571=f(0.3, -0.95)*/
{64, 0,123,__LINE__, 0x40068f09, 0x5fdf593b, 0x3fd33333, 0x33333339, 0xbfeccccc, 0xcccccccc},	/* 2.81984=f(0.3, -0.9)*/
{64, 0,123,__LINE__, 0x40066b1c, 0x486d5729, 0x3fd33333, 0x33333339, 0xbfeb3333, 0x33333332},	/* 2.8023=f(0.3, -0.85)*/
{64, 0,123,__LINE__, 0x40064338, 0x2c079139, 0x3fd33333, 0x33333339, 0xbfe99999, 0x99999998},	/* 2.78282=f(0.3, -0.8)*/
{64, 0,123,__LINE__, 0x400616b4, 0x66d73d5f, 0x3fd33333, 0x33333339, 0xbfe7ffff, 0xfffffffe},	/* 2.76109=f(0.3, -0.75)*/
{64, 0,123,__LINE__, 0x4005e4c3, 0x6ca01189, 0x3fd33333, 0x33333339, 0xbfe66666, 0x66666664},	/* 2.7367=f(0.3, -0.7)*/
{64, 0,123,__LINE__, 0x4005ac69, 0x1f0f4899, 0x3fd33333, 0x33333339, 0xbfe4cccc, 0xccccccca},	/* 2.70918=f(0.3, -0.65)*/
{64, 0,123,__LINE__, 0x40056c6e, 0x7397f5ad, 0x3fd33333, 0x33333339, 0xbfe33333, 0x33333330},	/* 2.67795=f(0.3, -0.6)*/
{64, 0,123,__LINE__, 0x40052351, 0xd5cc540e, 0x3fd33333, 0x33333339, 0xbfe19999, 0x99999996},	/* 2.64225=f(0.3, -0.55)*/
{64, 0,123,__LINE__, 0x4004cf33, 0xdec5e9de, 0x3fd33333, 0x33333339, 0xbfdfffff, 0xfffffff9},	/* 2.60117=f(0.3, -0.5)*/
{64, 0,123,__LINE__, 0x40046dc0, 0x9ec29431, 0x3fd33333, 0x33333339, 0xbfdccccc, 0xccccccc6},	/* 2.55359=f(0.3, -0.45)*/
{64, 0,123,__LINE__, 0x4003fc17, 0x6b7a855e, 0x3fd33333, 0x33333339, 0xbfd99999, 0x99999993},	/* 2.49809=f(0.3, -0.4)*/
{64, 0,123,__LINE__, 0x400376b7, 0x14052d9e, 0x3fd33333, 0x33333339, 0xbfd66666, 0x66666660},	/* 2.43297=f(0.3, -0.35)*/
{64, 0,123,__LINE__, 0x4002d97c, 0x7f3321d0, 0x3fd33333, 0x33333339, 0xbfd33333, 0x3333332d},	/* 2.35619=f(0.3, -0.3)*/
{64, 0,123,__LINE__, 0x40021fd0, 0x9b1e712c, 0x3fd33333, 0x33333339, 0xbfcfffff, 0xfffffff4},	/* 2.26553=f(0.3, -0.25)*/
{64, 0,123,__LINE__, 0x40014538, 0x5fa3af6f, 0x3fd33333, 0x33333339, 0xbfc99999, 0x9999998e},	/* 2.1588=f(0.3, -0.2)*/
{63, 0,123,__LINE__, 0x4000468a, 0x8ace4df3, 0x3fd33333, 0x33333339, 0xbfc33333, 0x33333328},	/* 2.03444=f(0.3, -0.15)*/
{64, 0,123,__LINE__, 0x3ffe47df, 0x3d0dd4cb, 0x3fd33333, 0x33333339, 0xbfb99999, 0x99999983},	/* 1.89255=f(0.3, -0.1)*/
{64, 0,123,__LINE__, 0x3ffbc66e, 0x44cbc06f, 0x3fd33333, 0x33333339, 0xbfa99999, 0x9999996c},	/* 1.73595=f(0.3, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d13, 0x3fd33333, 0x33333339, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.3, 3.19189e-16)*/
{64, 0,123,__LINE__, 0x3ff67d88, 0x63bc99b9, 0x3fd33333, 0x33333339, 0x3fa99999, 0x999999c8},	/* 1.40565=f(0.3, 0.05)*/
{64, 0,123,__LINE__, 0x3ff3fc17, 0x6b7a855d, 0x3fd33333, 0x33333339, 0x3fb99999, 0x999999b1},	/* 1.24905=f(0.3, 0.1)*/
{64, 0,123,__LINE__, 0x3ff1b6e1, 0x92ebbe42, 0x3fd33333, 0x33333339, 0x3fc33333, 0x3333333f},	/* 1.10715=f(0.3, 0.15)*/
{63, 0,123,__LINE__, 0x3fef730b, 0xd281f698, 0x3fd33333, 0x33333339, 0x3fc99999, 0x999999a6},	/* 0.982794=f(0.3, 0.2)*/
{64, 0,123,__LINE__, 0x3fec08aa, 0xe496efa5, 0x3fd33333, 0x33333339, 0x3fd00000, 0x00000006},	/* 0.876058=f(0.3, 0.25)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fd33333, 0x33333339, 0x3fd33333, 0x33333339},	/* 0.785398=f(0.3, 0.3)*/
{64, 0,123,__LINE__, 0x3fe6ad11, 0x00fbfde0, 0x3fd33333, 0x33333339, 0x3fd66666, 0x6666666c},	/* 0.708626=f(0.3, 0.35)*/
{63, 0,123,__LINE__, 0x3fe4978f, 0xa3269ee3, 0x3fd33333, 0x33333339, 0x3fd99999, 0x9999999f},	/* 0.643501=f(0.3, 0.4)*/
{64, 0,123,__LINE__, 0x3fe2d0ea, 0xd6066397, 0x3fd33333, 0x33333339, 0x3fdccccc, 0xccccccd2},	/* 0.588003=f(0.3, 0.45)*/
{63, 0,123,__LINE__, 0x3fe14b1d, 0xd5f90ce3, 0x3fd33333, 0x33333339, 0x3fe00000, 0x00000003},	/* 0.54042=f(0.3, 0.5)*/
{64, 0,123,__LINE__, 0x3fdff54b, 0xf3bec845, 0x3fd33333, 0x33333339, 0x3fe19999, 0x9999999d},	/* 0.499347=f(0.3, 0.55)*/
{63, 0,123,__LINE__, 0x3fddac67, 0x0561bb52, 0x3fd33333, 0x33333339, 0x3fe33333, 0x33333337},	/* 0.463648=f(0.3, 0.6)*/
{63, 0,123,__LINE__, 0x3fdbac91, 0xa9a723f0, 0x3fd33333, 0x33333339, 0x3fe4cccc, 0xccccccd1},	/* 0.432408=f(0.3, 0.65)*/
{64, 0,123,__LINE__, 0x3fd9e9bf, 0x3d20dc73, 0x3fd33333, 0x33333339, 0x3fe66666, 0x6666666b},	/* 0.404892=f(0.3, 0.7)*/
{64, 0,123,__LINE__, 0x3fd85a37, 0x6b677dc2, 0x3fd33333, 0x33333339, 0x3fe80000, 0x00000005},	/* 0.380506=f(0.3, 0.75)*/
{64, 0,123,__LINE__, 0x3fd6f619, 0x41e4def2, 0x3fd33333, 0x33333339, 0x3fe99999, 0x9999999f},	/* 0.358771=f(0.3, 0.8)*/
{64, 0,123,__LINE__, 0x3fd5b6f8, 0x5eb6af76, 0x3fd33333, 0x33333339, 0x3feb3333, 0x33333339},	/* 0.339293=f(0.3, 0.85)*/
{64, 0,123,__LINE__, 0x3fd4978f, 0xa3269ee3, 0x3fd33333, 0x33333339, 0x3feccccc, 0xccccccd3},	/* 0.321751=f(0.3, 0.9)*/
{64, 0,123,__LINE__, 0x3fd39384, 0xf94e28a1, 0x3fd33333, 0x33333339, 0x3fee6666, 0x6666666d},	/* 0.305879=f(0.3, 0.95)*/
{64, 0,123,__LINE__, 0x40067078, 0xc2eef45d, 0x3fd66666, 0x6666666c, 0xbff00000, 0x00000000},	/* 2.80492=f(0.35, -1)*/
{64, 0,123,__LINE__, 0x40064f0e, 0xb468064f, 0x3fd66666, 0x6666666c, 0xbfee6666, 0x66666666},	/* 2.7886=f(0.35, -0.95)*/
{64, 0,123,__LINE__, 0x40062a65, 0x7a259a4d, 0x3fd66666, 0x6666666c, 0xbfeccccc, 0xcccccccc},	/* 2.7707=f(0.35, -0.9)*/
{64, 0,123,__LINE__, 0x40060204, 0xbe520693, 0x3fd66666, 0x6666666c, 0xbfeb3333, 0x33333332},	/* 2.75099=f(0.35, -0.85)*/
{64, 0,123,__LINE__, 0x4005d55d, 0x7bcaa898, 0x3fd66666, 0x6666666c, 0xbfe99999, 0x99999998},	/* 2.72918=f(0.35, -0.8)*/
{64, 0,123,__LINE__, 0x4005a3c4, 0xf2e49eb4, 0x3fd66666, 0x6666666c, 0xbfe7ffff, 0xfffffffe},	/* 2.70497=f(0.35, -0.75)*/
{64, 0,123,__LINE__, 0x40056c6e, 0x7397f5ad, 0x3fd66666, 0x6666666c, 0xbfe66666, 0x66666664},	/* 2.67795=f(0.35, -0.7)*/
{64, 0,123,__LINE__, 0x40052e63, 0xcbf6f7b2, 0x3fd66666, 0x6666666c, 0xbfe4cccc, 0xccccccca},	/* 2.64765=f(0.35, -0.65)*/
{64, 0,123,__LINE__, 0x4004e87c, 0x3b956ba6, 0x3fd66666, 0x6666666c, 0xbfe33333, 0x33333330},	/* 2.61352=f(0.35, -0.6)*/
{64, 0,123,__LINE__, 0x40049952, 0x004c912d, 0x3fd66666, 0x6666666c, 0xbfe19999, 0x99999996},	/* 2.57486=f(0.35, -0.55)*/
{64, 0,123,__LINE__, 0x40043f37, 0x08e537eb, 0x3fd66666, 0x6666666c, 0xbfdfffff, 0xfffffff9},	/* 2.53087=f(0.35, -0.5)*/
{64, 0,123,__LINE__, 0x4003d82a, 0x5408834c, 0x3fd66666, 0x6666666c, 0xbfdccccc, 0xccccccc6},	/* 2.48055=f(0.35, -0.45)*/
{64, 0,123,__LINE__, 0x400361d1, 0x62e61b89, 0x3fd66666, 0x6666666c, 0xbfd99999, 0x99999993},	/* 2.42276=f(0.35, -0.4)*/
{64, 0,123,__LINE__, 0x4002d97c, 0x7f3321d0, 0x3fd66666, 0x6666666c, 0xbfd66666, 0x66666660},	/* 2.35619=f(0.35, -0.35)*/
{64, 0,123,__LINE__, 0x40023c41, 0xea611602, 0x3fd66666, 0x6666666c, 0xbfd33333, 0x3333332d},	/* 2.27942=f(0.35, -0.3)*/
{64, 0,123,__LINE__, 0x40018743, 0x06ef5822, 0x3fd66666, 0x6666666c, 0xbfcfffff, 0xfffffff4},	/* 2.19105=f(0.35, -0.25)*/
{64, 0,123,__LINE__, 0x4000b833, 0xbe165cc7, 0x3fd66666, 0x6666666c, 0xbfc99999, 0x9999998e},	/* 2.08994=f(0.35, -0.2)*/
{64, 0,123,__LINE__, 0x3fff9c6b, 0x238c6430, 0x3fd66666, 0x6666666c, 0xbfc33333, 0x33333328},	/* 1.97569=f(0.35, -0.15)*/
{64, 0,123,__LINE__, 0x3ffd95e5, 0xac22d087, 0x3fd66666, 0x6666666c, 0xbfb99999, 0x99999983},	/* 1.8491=f(0.35, -0.1)*/
{63, 0,123,__LINE__, 0x3ffb6731, 0x2cd2f42f, 0x3fd66666, 0x6666666c, 0xbfa99999, 0x9999996c},	/* 1.71269=f(0.35, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d14, 0x3fd66666, 0x6666666c, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.35, 3.19189e-16)*/
{64, 0,123,__LINE__, 0x3ff6dcc5, 0x7bb565f9, 0x3fd66666, 0x6666666c, 0x3fa99999, 0x999999c8},	/* 1.4289=f(0.35, 0.05)*/
{64, 0,123,__LINE__, 0x3ff4ae10, 0xfc6589a2, 0x3fd66666, 0x6666666c, 0x3fb99999, 0x999999b1},	/* 1.2925=f(0.35, 0.1)*/
{64, 0,123,__LINE__, 0x3ff2a78b, 0x84fbf5fa, 0x3fd66666, 0x6666666c, 0x3fc33333, 0x3333333f},	/* 1.1659=f(0.35, 0.15)*/
{64, 0,123,__LINE__, 0x3ff0d38f, 0x2c5ba09d, 0x3fd66666, 0x6666666c, 0x3fc99999, 0x999999a6},	/* 1.05165=f(0.35, 0.2)*/
{64, 0,123,__LINE__, 0x3fee6ae1, 0x355353ce, 0x3fd66666, 0x6666666c, 0x3fd00000, 0x00000006},	/* 0.950547=f(0.35, 0.25)*/
{64, 0,123,__LINE__, 0x3feb96e5, 0xa78c5c51, 0x3fd66666, 0x6666666c, 0x3fd33333, 0x33333339},	/* 0.86217=f(0.35, 0.3)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fd66666, 0x6666666c, 0x3fd66666, 0x6666666c},	/* 0.785398=f(0.35, 0.35)*/
{64, 0,123,__LINE__, 0x3fe700a7, 0xc5784634, 0x3fd66666, 0x6666666c, 0x3fd99999, 0x9999999f},	/* 0.71883=f(0.35, 0.4)*/
{64, 0,123,__LINE__, 0x3fe52744, 0x00eea72c, 0x3fd66666, 0x6666666c, 0x3fdccccc, 0xccccccd2},	/* 0.661043=f(0.35, 0.45)*/
{63, 0,123,__LINE__, 0x3fe38b11, 0x2d7bd4ae, 0x3fd66666, 0x6666666c, 0x3fe00000, 0x00000003},	/* 0.610726=f(0.35, 0.5)*/
{64, 0,123,__LINE__, 0x3fe222a5, 0x4fde6fa9, 0x3fd66666, 0x6666666c, 0x3fe19999, 0x9999999d},	/* 0.566729=f(0.35, 0.55)*/
{64, 0,123,__LINE__, 0x3fe0e5fc, 0x62bb05c4, 0x3fd66666, 0x6666666c, 0x3fe33333, 0x33333337},	/* 0.528074=f(0.35, 0.6)*/
{64, 0,123,__LINE__, 0x3fdf9cbc, 0x4269ab2c, 0x3fd66666, 0x6666666c, 0x3fe4cccc, 0xccccccd1},	/* 0.493941=f(0.35, 0.65)*/
{64, 0,123,__LINE__, 0x3fddac67, 0x0561bb51, 0x3fd66666, 0x6666666c, 0x3fe66666, 0x6666666b},	/* 0.463648=f(0.35, 0.7)*/
{64, 0,123,__LINE__, 0x3fdbf1b3, 0x0afc731c, 0x3fd66666, 0x6666666c, 0x3fe80000, 0x00000005},	/* 0.436627=f(0.35, 0.75)*/
{64, 0,123,__LINE__, 0x3fda64ee, 0xc3cc23fe, 0x3fd66666, 0x6666666c, 0x3fe99999, 0x9999999f},	/* 0.41241=f(0.35, 0.8)*/
{64, 0,123,__LINE__, 0x3fd8ffb4, 0xaf913426, 0x3fd66666, 0x6666666c, 0x3feb3333, 0x33333339},	/* 0.390607=f(0.35, 0.85)*/
{64, 0,123,__LINE__, 0x3fd7bcae, 0xd0f49656, 0x3fd66666, 0x6666666c, 0x3feccccc, 0xccccccd3},	/* 0.370891=f(0.35, 0.9)*/
{64, 0,123,__LINE__, 0x3fd69764, 0xfee13644, 0x3fd66666, 0x6666666c, 0x3fee6666, 0x6666666d},	/* 0.35299=f(0.35, 0.95)*/
{64, 0,123,__LINE__, 0x400616b4, 0x66d73d60, 0x3fd99999, 0x9999999f, 0xbff00000, 0x00000000},	/* 2.76109=f(0.4, -1)*/
{64, 0,123,__LINE__, 0x4005f1ce, 0xcb0d4d6d, 0x3fd99999, 0x9999999f, 0xbfee6666, 0x66666666},	/* 2.74307=f(0.4, -0.95)*/
{64, 0,123,__LINE__, 0x4005c975, 0x54f4b39e, 0x3fd99999, 0x9999999f, 0xbfeccccc, 0xcccccccc},	/* 2.72337=f(0.4, -0.9)*/
{63, 0,123,__LINE__, 0x40059d2f, 0x241f85a7, 0x3fd99999, 0x9999999f, 0xbfeb3333, 0x33333332},	/* 2.70175=f(0.4, -0.85)*/
{63, 0,123,__LINE__, 0x40056c6e, 0x7397f5ad, 0x3fd99999, 0x9999999f, 0xbfe99999, 0x99999998},	/* 2.67795=f(0.4, -0.8)*/
{64, 0,123,__LINE__, 0x4005368c, 0x951e9cfc, 0x3fd99999, 0x9999999f, 0xbfe7ffff, 0xfffffffe},	/* 2.65164=f(0.4, -0.75)*/
{64, 0,123,__LINE__, 0x4004fac5, 0x404fe6da, 0x3fd99999, 0x9999999f, 0xbfe66666, 0x66666664},	/* 2.62245=f(0.4, -0.7)*/
{64, 0,123,__LINE__, 0x4004b831, 0x3ddf1776, 0x3fd99999, 0x9999999f, 0xbfe4cccc, 0xccccccca},	/* 2.58994=f(0.4, -0.65)*/
{64, 0,123,__LINE__, 0x40046dc0, 0x9ec29432, 0x3fd99999, 0x9999999f, 0xbfe33333, 0x33333330},	/* 2.55359=f(0.4, -0.6)*/
{64, 0,123,__LINE__, 0x40041a34, 0xfb542bff, 0x3fd99999, 0x9999999f, 0xbfe19999, 0x99999996},	/* 2.5128=f(0.4, -0.55)*/
{64, 0,123,__LINE__, 0x4003bc1c, 0xc0033272, 0x3fd99999, 0x9999999f, 0xbfdfffff, 0xfffffff9},	/* 2.46685=f(0.4, -0.5)*/
{64, 0,123,__LINE__, 0x400351d1, 0x783b3dac, 0x3fd99999, 0x9999999f, 0xbfdccccc, 0xccccccc6},	/* 2.41495=f(0.4, -0.45)*/
{64, 0,123,__LINE__, 0x4002d97c, 0x7f3321d0, 0x3fd99999, 0x9999999f, 0xbfd99999, 0x99999993},	/* 2.35619=f(0.4, -0.4)*/
{64, 0,123,__LINE__, 0x40025127, 0x9b802817, 0x3fd99999, 0x9999999f, 0xbfd66666, 0x66666660},	/* 2.28963=f(0.4, -0.35)*/
{64, 0,123,__LINE__, 0x4001b6e1, 0x92ebbe42, 0x3fd99999, 0x9999999f, 0xbfd33333, 0x3333332d},	/* 2.2143=f(0.4, -0.3)*/
{64, 0,123,__LINE__, 0x40010900, 0x9519d637, 0x3fd99999, 0x9999999f, 0xbfcfffff, 0xfffffff4},	/* 2.1294=f(0.4, -0.25)*/
{64, 0,123,__LINE__, 0x4000468a, 0x8ace4df4, 0x3fd99999, 0x9999999f, 0xbfc99999, 0x9999998e},	/* 2.03444=f(0.4, -0.2)*/
{63, 0,123,__LINE__, 0x3ffedf81, 0xa4bd64d0, 0x3fd99999, 0x9999999f, 0xbfc33333, 0x33333328},	/* 1.92957=f(0.4, -0.15)*/
{64, 0,123,__LINE__, 0x3ffd0d6a, 0x1369bd30, 0x3fd99999, 0x9999999f, 0xbfb99999, 0x99999983},	/* 1.81577=f(0.4, -0.1)*/
{63, 0,123,__LINE__, 0x3ffb1f56, 0xfdeef00b, 0x3fd99999, 0x9999999f, 0xbfa99999, 0x9999996c},	/* 1.69515=f(0.4, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d15, 0x3fd99999, 0x9999999f, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.4, 3.19189e-16)*/
{64, 0,123,__LINE__, 0x3ff7249f, 0xaa996a1e, 0x3fd99999, 0x9999999f, 0x3fa99999, 0x999999c8},	/* 1.44644=f(0.4, 0.05)*/
{64, 0,123,__LINE__, 0x3ff5368c, 0x951e9cfa, 0x3fd99999, 0x9999999f, 0x3fb99999, 0x999999b1},	/* 1.32582=f(0.4, 0.1)*/
{64, 0,123,__LINE__, 0x3ff36475, 0x03caf55a, 0x3fd99999, 0x9999999f, 0x3fc33333, 0x3333333f},	/* 1.21203=f(0.4, 0.15)*/
{64, 0,123,__LINE__, 0x3ff1b6e1, 0x92ebbe43, 0x3fd99999, 0x9999999f, 0x3fc99999, 0x999999a6},	/* 1.10715=f(0.4, 0.2)*/
{64, 0,123,__LINE__, 0x3ff031f5, 0x7e54adbd, 0x3fd99999, 0x9999999f, 0x3fd00000, 0x00000006},	/* 1.0122=f(0.4, 0.25)*/
{64, 0,123,__LINE__, 0x3fedac67, 0x0561bb4e, 0x3fd99999, 0x9999999f, 0x3fd33333, 0x33333339},	/* 0.927295=f(0.4, 0.3)*/
{64, 0,123,__LINE__, 0x3feb434e, 0xe31013fc, 0x3fd99999, 0x9999999f, 0x3fd66666, 0x6666666c},	/* 0.851966=f(0.4, 0.35)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fd99999, 0x9999999f, 0x3fd99999, 0x9999999f},	/* 0.785398=f(0.4, 0.4)*/
{64, 0,123,__LINE__, 0x3fe740a7, 0x7023bda9, 0x3fd99999, 0x9999999f, 0x3fdccccc, 0xccccccd2},	/* 0.726642=f(0.4, 0.45)*/
{64, 0,123,__LINE__, 0x3fe5977a, 0x5103ea93, 0x3fd99999, 0x9999999f, 0x3fe00000, 0x00000003},	/* 0.674741=f(0.4, 0.5)*/
{64, 0,123,__LINE__, 0x3fe41f19, 0x63c0045f, 0x3fd99999, 0x9999999f, 0x3fe19999, 0x9999999d},	/* 0.628796=f(0.4, 0.55)*/
{64, 0,123,__LINE__, 0x3fe2d0ea, 0xd6066396, 0x3fd99999, 0x9999999f, 0x3fe33333, 0x33333337},	/* 0.588003=f(0.4, 0.6)*/
{64, 0,123,__LINE__, 0x3fe1a728, 0x59945683, 0x3fd99999, 0x9999999f, 0x3fe4cccc, 0xccccccd1},	/* 0.551655=f(0.4, 0.65)*/
{64, 0,123,__LINE__, 0x3fe09cd8, 0x4fd118f3, 0x3fd99999, 0x9999999f, 0x3fe66666, 0x6666666b},	/* 0.519146=f(0.4, 0.7)*/
{64, 0,123,__LINE__, 0x3fdf5b75, 0xf92c80dd, 0x3fd99999, 0x9999999f, 0x3fe80000, 0x00000005},	/* 0.489957=f(0.4, 0.75)*/
{64, 0,123,__LINE__, 0x3fddac67, 0x0561bb4f, 0x3fd99999, 0x9999999f, 0x3fe99999, 0x9999999f},	/* 0.463648=f(0.4, 0.8)*/
{64, 0,123,__LINE__, 0x3fdc2661, 0x81253b88, 0x3fd99999, 0x9999999f, 0x3feb3333, 0x33333339},	/* 0.439843=f(0.4, 0.85)*/
{63, 0,123,__LINE__, 0x3fdac42f, 0xfa7bcbcf, 0x3fd99999, 0x9999999f, 0x3feccccc, 0xccccccd3},	/* 0.418224=f(0.4, 0.9)*/
{64, 0,123,__LINE__, 0x3fd98164, 0x49b6fd53, 0x3fd99999, 0x9999999f, 0x3fee6666, 0x6666666d},	/* 0.398522=f(0.4, 0.95)*/
{64, 0,123,__LINE__, 0x4005bffa, 0x17065de0, 0x3fdccccc, 0xccccccd2, 0xbff00000, 0x00000000},	/* 2.71874=f(0.45, -1)*/
{64, 0,123,__LINE__, 0x400597ff, 0xd521f2a9, 0x3fdccccc, 0xccccccd2, 0xbfee6666, 0x66666666},	/* 2.69922=f(0.45, -0.95)*/
{64, 0,123,__LINE__, 0x40056c6e, 0x7397f5ae, 0x3fdccccc, 0xccccccd2, 0xbfeccccc, 0xcccccccc},	/* 2.67795=f(0.45, -0.9)*/
{64, 0,123,__LINE__, 0x40053ccf, 0xe79b8f8e, 0x3fdccccc, 0xccccccd2, 0xbfeb3333, 0x33333332},	/* 2.65469=f(0.45, -0.85)*/
{64, 0,123,__LINE__, 0x4005089b, 0xaf0d60e4, 0x3fdccccc, 0xccccccd2, 0xbfe99999, 0x99999998},	/* 2.6292=f(0.45, -0.8)*/
{64, 0,123,__LINE__, 0x4004cf33, 0xdec5e9df, 0x3fdccccc, 0xccccccd2, 0xbfe7ffff, 0xfffffffe},	/* 2.60117=f(0.45, -0.75)*/
{64, 0,123,__LINE__, 0x40048fe1, 0xf1cd429f, 0x3fdccccc, 0xccccccd2, 0xbfe66666, 0x66666664},	/* 2.57026=f(0.45, -0.7)*/
{63, 0,123,__LINE__, 0x400449d3, 0x8750921f, 0x3fdccccc, 0xccccccd2, 0xbfe4cccc, 0xccccccca},	/* 2.53605=f(0.45, -0.65)*/
{64, 0,123,__LINE__, 0x4003fc17, 0x6b7a855f, 0x3fdccccc, 0xccccccd2, 0xbfe33333, 0x33333330},	/* 2.49809=f(0.45, -0.6)*/
{64, 0,123,__LINE__, 0x4003a59b, 0x934a3833, 0x3fdccccc, 0xccccccd2, 0xbfe19999, 0x99999996},	/* 2.45586=f(0.45, -0.55)*/
{64, 0,123,__LINE__, 0x4003452d, 0x2a42ac27, 0x3fdccccc, 0xccccccd2, 0xbfdfffff, 0xfffffff9},	/* 2.40878=f(0.45, -0.5)*/
{63, 0,123,__LINE__, 0x4002d97c, 0x7f3321d1, 0x3fdccccc, 0xccccccd2, 0xbfdccccc, 0xccccccc6},	/* 2.35619=f(0.45, -0.45)*/
{63, 0,123,__LINE__, 0x40026127, 0x862b05f5, 0x3fdccccc, 0xccccccd2, 0xbfd99999, 0x99999993},	/* 2.29744=f(0.45, -0.4)*/
{64, 0,123,__LINE__, 0x4001dace, 0xaa5dc055, 0x3fdccccc, 0xccccccd2, 0xbfd66666, 0x66666660},	/* 2.23184=f(0.45, -0.35)*/
{64, 0,123,__LINE__, 0x40014538, 0x5fa3af70, 0x3fdccccc, 0xccccccd2, 0xbfd33333, 0x3333332d},	/* 2.1588=f(0.45, -0.3)*/
{63, 0,123,__LINE__, 0x40009f87, 0x5343d017, 0x3fdccccc, 0xccccccd2, 0xbfcfffff, 0xfffffff4},	/* 2.07789=f(0.45, -0.25)*/
{63, 0,123,__LINE__, 0x3fffd307, 0x52e32008, 0x3fdccccc, 0xccccccd2, 0xbfc99999, 0x9999998e},	/* 1.98902=f(0.45, -0.2)*/
{64, 0,123,__LINE__, 0x3ffe47df, 0x3d0dd4cd, 0x3fdccccc, 0xccccccd2, 0xbfc33333, 0x33333328},	/* 1.89255=f(0.45, -0.15)*/
{64, 0,123,__LINE__, 0x3ffca1a6, 0x56770bcd, 0x3fdccccc, 0xccccccd2, 0xbfb99999, 0x99999983},	/* 1.78947=f(0.45, -0.1)*/
{64, 0,123,__LINE__, 0x3ffae73b, 0xd5e44e58, 0x3fdccccc, 0xccccccd2, 0xbfa99999, 0x9999996c},	/* 1.68145=f(0.45, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d15, 0x3fdccccc, 0xccccccd2, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.45, 3.19189e-16)*/
{64, 0,123,__LINE__, 0x3ff75cba, 0xd2a40bd2, 0x3fdccccc, 0xccccccd2, 0x3fa99999, 0x999999c8},	/* 1.46014=f(0.45, 0.05)*/
{64, 0,123,__LINE__, 0x3ff5a250, 0x52114e5e, 0x3fdccccc, 0xccccccd2, 0x3fb99999, 0x999999b1},	/* 1.35213=f(0.45, 0.1)*/
{64, 0,123,__LINE__, 0x3ff3fc17, 0x6b7a855e, 0x3fdccccc, 0xccccccd2, 0x3fc33333, 0x3333333f},	/* 1.24905=f(0.45, 0.15)*/
{64, 0,123,__LINE__, 0x3ff270ef, 0x55a53a23, 0x3fdccccc, 0xccccccd2, 0x3fc99999, 0x999999a6},	/* 1.15257=f(0.45, 0.2)*/
{64, 0,123,__LINE__, 0x3ff104e8, 0x0200b9fe, 0x3fdccccc, 0xccccccd2, 0x3fd00000, 0x00000006},	/* 1.0637=f(0.45, 0.25)*/
{64, 0,123,__LINE__, 0x3fef730b, 0xd281f699, 0x3fdccccc, 0xccccccd2, 0x3fd33333, 0x33333339},	/* 0.982794=f(0.45, 0.3)*/
{64, 0,123,__LINE__, 0x3fed1cb2, 0xa799b305, 0x3fdccccc, 0xccccccd2, 0x3fd66666, 0x6666666c},	/* 0.909753=f(0.45, 0.35)*/
{64, 0,123,__LINE__, 0x3feb034f, 0x38649c87, 0x3fdccccc, 0xccccccd2, 0x3fd99999, 0x9999999f},	/* 0.844154=f(0.45, 0.4)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fdccccc, 0xccccccd2, 0x3fdccccc, 0xccccccd2},	/* 0.785398=f(0.45, 0.45)*/
{64, 0,123,__LINE__, 0x3fe77338, 0xa80603be, 0x3fdccccc, 0xccccccd2, 0x3fe00000, 0x00000003},	/* 0.732815=f(0.45, 0.5)*/
{63, 0,123,__LINE__, 0x3fe5f17f, 0x03e7d38f, 0x3fdccccc, 0xccccccd2, 0x3fe19999, 0x9999999d},	/* 0.68573=f(0.45, 0.55)*/
{64, 0,123,__LINE__, 0x3fe4978f, 0xa3269ee1, 0x3fdccccc, 0xccccccd2, 0x3fe33333, 0x33333337},	/* 0.643501=f(0.45, 0.6)*/
{64, 0,123,__LINE__, 0x3fe3609f, 0x33ce6bdf, 0x3fdccccc, 0xccccccd2, 0x3fe4cccc, 0xccccccd1},	/* 0.605545=f(0.45, 0.65)*/
{63, 0,123,__LINE__, 0x3fe24865, 0x89dba9e0, 0x3fdccccc, 0xccccccd2, 0x3fe66666, 0x6666666b},	/* 0.571337=f(0.45, 0.7)*/
{64, 0,123,__LINE__, 0x3fe14b1d, 0xd5f90ce1, 0x3fdccccc, 0xccccccd2, 0x3fe80000, 0x00000005},	/* 0.54042=f(0.45, 0.75)*/
{64, 0,123,__LINE__, 0x3fe0657e, 0x94db30cf, 0x3fdccccc, 0xccccccd2, 0x3fe99999, 0x9999999f},	/* 0.512389=f(0.45, 0.8)*/
{63, 0,123,__LINE__, 0x3fdf295b, 0x6544ec4f, 0x3fdccccc, 0xccccccd2, 0x3feb3333, 0x33333339},	/* 0.486899=f(0.45, 0.85)*/
{64, 0,123,__LINE__, 0x3fddac67, 0x0561bb4f, 0x3fdccccc, 0xccccccd2, 0x3feccccc, 0xccccccd3},	/* 0.463648=f(0.45, 0.9)*/
{64, 0,123,__LINE__, 0x3fdc4fdb, 0xf911d373, 0x3fdccccc, 0xccccccd2, 0x3fee6666, 0x6666666d},	/* 0.442374=f(0.45, 0.95)*/
{64, 0,123,__LINE__, 0x40056c6e, 0x7397f5ae, 0x3fe00000, 0x00000003, 0xbff00000, 0x00000000},	/* 2.67795=f(0.5, -1)*/
{64, 0,123,__LINE__, 0x400541c5, 0x5d5d64c0, 0x3fe00000, 0x00000003, 0xbfee6666, 0x66666666},	/* 2.65711=f(0.5, -0.95)*/
{64, 0,123,__LINE__, 0x40051371, 0xab22738b, 0x3fe00000, 0x00000003, 0xbfeccccc, 0xcccccccc},	/* 2.63449=f(0.5, -0.9)*/
{64, 0,123,__LINE__, 0x4004e102, 0xc80931db, 0x3fe00000, 0x00000003, 0xbfeb3333, 0x33333332},	/* 2.60987=f(0.5, -0.85)*/
{64, 0,123,__LINE__, 0x4004a9f8, 0x694c6d6a, 0x3fe00000, 0x00000003, 0xbfe99999, 0x99999998},	/* 2.58299=f(0.5, -0.8)*/
{64, 0,123,__LINE__, 0x40046dc0, 0x9ec29432, 0x3fe00000, 0x00000003, 0xbfe7ffff, 0xfffffffe},	/* 2.55359=f(0.5, -0.75)*/
{64, 0,123,__LINE__, 0x40042bb5, 0xf776eb7f, 0x3fe00000, 0x00000003, 0xbfe66666, 0x66666664},	/* 2.52134=f(0.5, -0.7)*/
{64, 0,123,__LINE__, 0x4003e31d, 0xfb0d799c, 0x3fe00000, 0x00000003, 0xbfe4cccc, 0xccccccca},	/* 2.4859=f(0.5, -0.65)*/
{64, 0,123,__LINE__, 0x40039328, 0x6347d274, 0x3fe00000, 0x00000003, 0xbfe33333, 0x33333330},	/* 2.44685=f(0.5, -0.6)*/
{64, 0,123,__LINE__, 0x40033aef, 0xbf36777e, 0x3fe00000, 0x00000003, 0xbfe19999, 0x99999996},	/* 2.40378=f(0.5, -0.55)*/
{63, 0,123,__LINE__, 0x4002d97c, 0x7f3321d1, 0x3fe00000, 0x00000003, 0xbfdfffff, 0xfffffff9},	/* 2.35619=f(0.5, -0.5)*/
{64, 0,123,__LINE__, 0x40026dcb, 0xd423977a, 0x3fe00000, 0x00000003, 0xbfdccccc, 0xccccccc6},	/* 2.30361=f(0.5, -0.45)*/
{64, 0,123,__LINE__, 0x4001f6dc, 0x3e63112f, 0x3fe00000, 0x00000003, 0xbfd99999, 0x99999993},	/* 2.24554=f(0.5, -0.4)*/
{64, 0,123,__LINE__, 0x400173c1, 0xf5810bb6, 0x3fe00000, 0x00000003, 0xbfd66666, 0x66666660},	/* 2.18152=f(0.5, -0.35)*/
{64, 0,123,__LINE__, 0x4000e3c5, 0x1fa059c3, 0x3fe00000, 0x00000003, 0xbfd33333, 0x3333332d},	/* 2.11122=f(0.5, -0.3)*/
{64, 0,123,__LINE__, 0x4000468a, 0x8ace4df4, 0x3fe00000, 0x00000003, 0xbfcfffff, 0xfffffff4},	/* 2.03444=f(0.5, -0.25)*/
{64, 0,123,__LINE__, 0x3fff3889, 0x2f1e0c85, 0x3fe00000, 0x00000003, 0xbfc99999, 0x9999998e},	/* 1.9513=f(0.5, -0.2)*/
{63, 0,123,__LINE__, 0x3ffdcbc9, 0xedcbd8d6, 0x3fe00000, 0x00000003, 0xbfc33333, 0x33333328},	/* 1.86225=f(0.5, -0.15)*/
{63, 0,123,__LINE__, 0x3ffc4a83, 0x936311d6, 0x3fe00000, 0x00000003, 0xbfb99999, 0x99999983},	/* 1.76819=f(0.5, -0.1)*/
{64, 0,123,__LINE__, 0x3ffaba39, 0x7c7259da, 0x3fe00000, 0x00000003, 0xbfa99999, 0x9999996c},	/* 1.67046=f(0.5, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d15, 0x3fe00000, 0x00000003, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.5, 3.19189e-16)*/
{64, 0,123,__LINE__, 0x3ff789bd, 0x2c160051, 0x3fe00000, 0x00000003, 0x3fa99999, 0x999999c8},	/* 1.47113=f(0.5, 0.05)*/
{64, 0,123,__LINE__, 0x3ff5f973, 0x15254855, 0x3fe00000, 0x00000003, 0x3fb99999, 0x999999b1},	/* 1.3734=f(0.5, 0.1)*/
{64, 0,123,__LINE__, 0x3ff4782c, 0xbabc8155, 0x3fe00000, 0x00000003, 0x3fc33333, 0x3333333f},	/* 1.27934=f(0.5, 0.15)*/
{64, 0,123,__LINE__, 0x3ff30b6d, 0x796a4da7, 0x3fe00000, 0x00000003, 0x3fc99999, 0x999999a6},	/* 1.19029=f(0.5, 0.2)*/
{64, 0,123,__LINE__, 0x3ff1b6e1, 0x92ebbe43, 0x3fe00000, 0x00000003, 0x3fd00000, 0x00000006},	/* 1.10715=f(0.5, 0.25)*/
{64, 0,123,__LINE__, 0x3ff07c6c, 0x6947a6a7, 0x3fe00000, 0x00000003, 0x3fd33333, 0x33333339},	/* 1.03038=f(0.5, 0.3)*/
{64, 0,123,__LINE__, 0x3feeb8e5, 0x7b0c8582, 0x3fe00000, 0x00000003, 0x3fd66666, 0x6666666c},	/* 0.96007=f(0.5, 0.35)*/
{64, 0,123,__LINE__, 0x3fecac7c, 0x57846f9e, 0x3fe00000, 0x00000003, 0x3fd99999, 0x9999999f},	/* 0.896055=f(0.5, 0.4)*/
{64, 0,123,__LINE__, 0x3fead0be, 0x00825672, 0x3fe00000, 0x00000003, 0x3fdccccc, 0xccccccd2},	/* 0.837981=f(0.5, 0.45)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fe00000, 0x00000003, 0x3fe00000, 0x00000003},	/* 0.785398=f(0.5, 0.5)*/
{64, 0,123,__LINE__, 0x3fe79c2e, 0x5436d664, 0x3fe00000, 0x00000003, 0x3fe19999, 0x9999999d},	/* 0.737815=f(0.5, 0.55)*/
{64, 0,123,__LINE__, 0x3fe63b4b, 0xc3f16a8a, 0x3fe00000, 0x00000003, 0x3fe33333, 0x33333337},	/* 0.694738=f(0.5, 0.6)*/
{64, 0,123,__LINE__, 0x3fe4fb75, 0x64dacded, 0x3fe00000, 0x00000003, 0x3fe4cccc, 0xccccccd1},	/* 0.655696=f(0.5, 0.65)*/
{63, 0,123,__LINE__, 0x3fe3d915, 0x73350661, 0x3fe00000, 0x00000003, 0x3fe66666, 0x6666666b},	/* 0.620249=f(0.5, 0.7)*/
{64, 0,123,__LINE__, 0x3fe2d0ea, 0xd6066395, 0x3fe00000, 0x00000003, 0x3fe80000, 0x00000005},	/* 0.588003=f(0.5, 0.75)*/
{64, 0,123,__LINE__, 0x3fe1e00b, 0xabdefeb4, 0x3fe00000, 0x00000003, 0x3fe99999, 0x9999999f},	/* 0.558599=f(0.5, 0.8)*/
{64, 0,123,__LINE__, 0x3fe103e2, 0x30ebecf2, 0x3fe00000, 0x00000003, 0x3feb3333, 0x33333339},	/* 0.531724=f(0.5, 0.85)*/
{64, 0,123,__LINE__, 0x3fe03a26, 0xa486e631, 0x3fe00000, 0x00000003, 0x3feccccc, 0xccccccd3},	/* 0.507099=f(0.5, 0.9)*/
{63, 0,123,__LINE__, 0x3fdf01af, 0xb73642bc, 0x3fe00000, 0x00000003, 0x3fee6666, 0x6666666d},	/* 0.484478=f(0.5, 0.95)*/
{64, 0,123,__LINE__, 0x40051c28, 0xaaf491df, 0x3fe19999, 0x9999999d, 0xbff00000, 0x00000000},	/* 2.63875=f(0.55, -1)*/
{64, 0,123,__LINE__, 0x4004ef33, 0x3421a552, 0x3fe19999, 0x9999999d, 0xbfee6666, 0x66666666},	/* 2.6168=f(0.55, -0.95)*/
{64, 0,123,__LINE__, 0x4004be8d, 0x75c60da2, 0x3fe19999, 0x9999999d, 0xbfeccccc, 0xcccccccc},	/* 2.59304=f(0.55, -0.9)*/
{64, 0,123,__LINE__, 0x400489ce, 0x32c7e50c, 0x3fe19999, 0x9999999d, 0xbfeb3333, 0x33333332},	/* 2.56729=f(0.55, -0.85)*/
{63, 0,123,__LINE__, 0x4004507f, 0x4d109f29, 0x3fe19999, 0x9999999d, 0xbfe99999, 0x99999998},	/* 2.53931=f(0.55, -0.8)*/
{63, 0,123,__LINE__, 0x4004121c, 0xb53cd825, 0x3fe19999, 0x9999999d, 0xbfe7ffff, 0xfffffffe},	/* 2.50884=f(0.55, -0.75)*/
{64, 0,123,__LINE__, 0x4003ce13, 0xa64eb185, 0x3fe19999, 0x9999999d, 0xbfe66666, 0x66666664},	/* 2.47562=f(0.55, -0.7)*/
{64, 0,123,__LINE__, 0x400383c2, 0x72726983, 0x3fe19999, 0x9999999d, 0xbfe4cccc, 0xccccccca},	/* 2.43934=f(0.55, -0.65)*/
{64, 0,123,__LINE__, 0x40033279, 0x47a8a3f3, 0x3fe19999, 0x9999999d, 0xbfe33333, 0x33333330},	/* 2.39965=f(0.55, -0.6)*/
{64, 0,123,__LINE__, 0x4002d97c, 0x7f3321d1, 0x3fe19999, 0x9999999d, 0xbfe19999, 0x99999996},	/* 2.35619=f(0.55, -0.55)*/
{63, 0,123,__LINE__, 0x40027809, 0x3f2fcc23, 0x3fe19999, 0x9999999d, 0xbfdfffff, 0xfffffff9},	/* 2.30861=f(0.55, -0.5)*/
{64, 0,123,__LINE__, 0x40020d5d, 0x6b1c0b6e, 0x3fe19999, 0x9999999d, 0xbfdccccc, 0xccccccc6},	/* 2.25653=f(0.55, -0.45)*/
{64, 0,123,__LINE__, 0x400198c4, 0x031217a2, 0x3fe19999, 0x9999999d, 0xbfd99999, 0x99999993},	/* 2.19959=f(0.55, -0.4)*/
{64, 0,123,__LINE__, 0x400119a6, 0xfe19b274, 0x3fe19999, 0x9999999d, 0xbfd66666, 0x66666660},	/* 2.13753=f(0.55, -0.35)*/
{64, 0,123,__LINE__, 0x40008fa7, 0x2899ef93, 0x3fe19999, 0x9999999d, 0xbfd33333, 0x3333332d},	/* 2.07014=f(0.55, -0.3)*/
{64, 0,123,__LINE__, 0x3ffff572, 0xaded0be5, 0x3fe19999, 0x9999999d, 0xbfcfffff, 0xfffffff4},	/* 1.99742=f(0.55, -0.25)*/
{63, 0,123,__LINE__, 0x3ffeb68c, 0x3ba726da, 0x3fe19999, 0x9999999d, 0xbfc99999, 0x9999998e},	/* 1.91957=f(0.55, -0.2)*/
{64, 0,123,__LINE__, 0x3ffd648c, 0xd67db728, 0x3fe19999, 0x9999999d, 0xbfc33333, 0x33333328},	/* 1.83705=f(0.55, -0.15)*/
{64, 0,123,__LINE__, 0x3ffc02a9, 0x647f0db2, 0x3fe19999, 0x9999999d, 0xbfb99999, 0x99999983},	/* 1.75065=f(0.55, -0.1)*/
{63, 0,123,__LINE__, 0x3ffa9553, 0x1c6d8e5c, 0x3fe19999, 0x9999999d, 0xbfa99999, 0x9999996c},	/* 1.66146=f(0.55, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d16, 0x3fe19999, 0x9999999d, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.55, 3.19189e-16)*/
{64, 0,123,__LINE__, 0x3ff7aea3, 0x8c1acbcf, 0x3fe19999, 0x9999999d, 0x3fa99999, 0x999999c8},	/* 1.48014=f(0.55, 0.05)*/
{64, 0,123,__LINE__, 0x3ff6414d, 0x44094c7a, 0x3fe19999, 0x9999999d, 0x3fb99999, 0x999999b1},	/* 1.39094=f(0.55, 0.1)*/
{64, 0,123,__LINE__, 0x3ff4df69, 0xd20aa304, 0x3fe19999, 0x9999999d, 0x3fc33333, 0x3333333f},	/* 1.30454=f(0.55, 0.15)*/
{64, 0,123,__LINE__, 0x3ff38d6a, 0x6ce13351, 0x3fe19999, 0x9999999d, 0x3fc99999, 0x999999a6},	/* 1.22203=f(0.55, 0.2)*/
{64, 0,123,__LINE__, 0x3ff24e83, 0xfa9b4e47, 0x3fe19999, 0x9999999d, 0x3fd00000, 0x00000006},	/* 1.14417=f(0.55, 0.25)*/
{64, 0,123,__LINE__, 0x3ff124a8, 0x57547b07, 0x3fe19999, 0x9999999d, 0x3fd33333, 0x33333339},	/* 1.07145=f(0.55, 0.3)*/
{64, 0,123,__LINE__, 0x3ff010a8, 0xac54f544, 0x3fe19999, 0x9999999d, 0x3fd66666, 0x6666666c},	/* 1.00407=f(0.55, 0.35)*/
{64, 0,123,__LINE__, 0x3fee24dd, 0x44c855d1, 0x3fe19999, 0x9999999d, 0x3fd99999, 0x9999999f},	/* 0.942=f(0.55, 0.4)*/
{64, 0,123,__LINE__, 0x3fec5277, 0xa4a086a2, 0x3fe19999, 0x9999999d, 0x3fdccccc, 0xccccccd2},	/* 0.885067=f(0.55, 0.45)*/
{64, 0,123,__LINE__, 0x3feaa7c8, 0x545183cd, 0x3fe19999, 0x9999999d, 0x3fe00000, 0x00000003},	/* 0.832981=f(0.55, 0.5)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fe19999, 0x9999999d, 0x3fe19999, 0x9999999d},	/* 0.785398=f(0.55, 0.55)*/
{64, 0,123,__LINE__, 0x3fe7be08, 0x326e248f, 0x3fe19999, 0x9999999d, 0x3fe33333, 0x33333337},	/* 0.741947=f(0.55, 0.6)*/
{64, 0,123,__LINE__, 0x3fe678e3, 0x87470e50, 0x3fe19999, 0x9999999d, 0x3fe4cccc, 0xccccccd1},	/* 0.702257=f(0.55, 0.65)*/
{64, 0,123,__LINE__, 0x3fe54f9e, 0xb7d5ee49, 0x3fe19999, 0x9999999d, 0x3fe66666, 0x6666666b},	/* 0.665969=f(0.55, 0.7)*/
{64, 0,123,__LINE__, 0x3fe43f7a, 0x7c1d53c7, 0x3fe19999, 0x9999999d, 0x3fe80000, 0x00000005},	/* 0.632749=f(0.55, 0.75)*/
{64, 0,123,__LINE__, 0x3fe345f0, 0x1cce37bb, 0x3fe19999, 0x9999999d, 0x3fe99999, 0x9999999f},	/* 0.602287=f(0.55, 0.8)*/
{64, 0,123,__LINE__, 0x3fe260b4, 0x85f1202d, 0x3fe19999, 0x9999999d, 0x3feb3333, 0x33333339},	/* 0.574305=f(0.55, 0.85)*/
{63, 0,123,__LINE__, 0x3fe18db7, 0x79f87dd5, 0x3fe19999, 0x9999999d, 0x3feccccc, 0xccccccd3},	/* 0.548549=f(0.55, 0.9)*/
{64, 0,123,__LINE__, 0x3fe0cb20, 0x808a1f16, 0x3fe19999, 0x9999999d, 0x3fee6666, 0x6666666d},	/* 0.524796=f(0.55, 0.95)*/
{64, 0,123,__LINE__, 0x4004cf33, 0xdec5e9df, 0x3fe33333, 0x33333337, 0xbff00000, 0x00000000},	/* 2.60117=f(0.6, -1)*/
{64, 0,123,__LINE__, 0x4004a04f, 0x5f80df4b, 0x3fe33333, 0x33333337, 0xbfee6666, 0x66666666},	/* 2.57828=f(0.6, -0.95)*/
{64, 0,123,__LINE__, 0x40046dc0, 0x9ec29432, 0x3fe33333, 0x33333337, 0xbfeccccc, 0xcccccccc},	/* 2.55359=f(0.6, -0.9)*/
{63, 0,123,__LINE__, 0x40043726, 0xeb5fa0c3, 0x3fe33333, 0x33333337, 0xbfeb3333, 0x33333332},	/* 2.52693=f(0.6, -0.85)*/
{64, 0,123,__LINE__, 0x4003fc17, 0x6b7a855f, 0x3fe33333, 0x33333337, 0xbfe99999, 0x99999998},	/* 2.49809=f(0.6, -0.8)*/
{63, 0,123,__LINE__, 0x4003bc1c, 0xc0033273, 0x3fe33333, 0x33333337, 0xbfe7ffff, 0xfffffffe},	/* 2.46685=f(0.6, -0.75)*/
{64, 0,123,__LINE__, 0x400376b7, 0x14052d9f, 0x3fe33333, 0x33333337, 0xbfe66666, 0x66666664},	/* 2.43297=f(0.6, -0.7)*/
{64, 0,123,__LINE__, 0x40032b5c, 0xd7c0fc06, 0x3fe33333, 0x33333337, 0xbfe4cccc, 0xccccccca},	/* 2.39617=f(0.6, -0.65)*/
{64, 0,123,__LINE__, 0x4002d97c, 0x7f3321d1, 0x3fe33333, 0x33333337, 0xbfe33333, 0x33333330},	/* 2.35619=f(0.6, -0.6)*/
{64, 0,123,__LINE__, 0x4002807f, 0xb6bd9fae, 0x3fe33333, 0x33333337, 0xbfe19999, 0x99999996},	/* 2.31274=f(0.6, -0.55)*/
{64, 0,123,__LINE__, 0x40021fd0, 0x9b1e712d, 0x3fe33333, 0x33333337, 0xbfdfffff, 0xfffffff9},	/* 2.26553=f(0.6, -0.5)*/
{64, 0,123,__LINE__, 0x4001b6e1, 0x92ebbe43, 0x3fe33333, 0x33333337, 0xbfdccccc, 0xccccccc6},	/* 2.2143=f(0.6, -0.45)*/
{64, 0,123,__LINE__, 0x40014538, 0x5fa3af70, 0x3fe33333, 0x33333337, 0xbfd99999, 0x99999993},	/* 2.1588=f(0.6, -0.4)*/
{63, 0,123,__LINE__, 0x4000ca7c, 0xc2d0d7fb, 0x3fe33333, 0x33333337, 0xbfd66666, 0x66666660},	/* 2.09887=f(0.6, -0.35)*/
{64, 0,123,__LINE__, 0x4000468a, 0x8ace4df4, 0x3fe33333, 0x33333337, 0xbfd33333, 0x3333332d},	/* 2.03444=f(0.6, -0.3)*/
{64, 0,123,__LINE__, 0x3fff730b, 0xd281f698, 0x3fe33333, 0x33333337, 0xbfcfffff, 0xfffffff4},	/* 1.96559=f(0.6, -0.25)*/
{63, 0,123,__LINE__, 0x3ffe47df, 0x3d0dd4cd, 0x3fe33333, 0x33333337, 0xbfc99999, 0x9999998e},	/* 1.89255=f(0.6, -0.2)*/
{64, 0,123,__LINE__, 0x3ffd0d6a, 0x1369bd31, 0x3fe33333, 0x33333337, 0xbfc33333, 0x33333328},	/* 1.81577=f(0.6, -0.15)*/
{63, 0,123,__LINE__, 0x3ffbc66e, 0x44cbc071, 0x3fe33333, 0x33333337, 0xbfb99999, 0x99999983},	/* 1.73595=f(0.6, -0.1)*/
{64, 0,123,__LINE__, 0x3ffa7687, 0x3ac2bc7a, 0x3fe33333, 0x33333337, 0xbfa99999, 0x9999996c},	/* 1.65394=f(0.6, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d16, 0x3fe33333, 0x33333337, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.6, 3.19189e-16)*/
{64, 0,123,__LINE__, 0x3ff7cd6f, 0x6dc59db2, 0x3fe33333, 0x33333337, 0x3fa99999, 0x999999c8},	/* 1.48766=f(0.6, 0.05)*/
{64, 0,123,__LINE__, 0x3ff67d88, 0x63bc99bb, 0x3fe33333, 0x33333337, 0x3fb99999, 0x999999b1},	/* 1.40565=f(0.6, 0.1)*/
{64, 0,123,__LINE__, 0x3ff5368c, 0x951e9cfb, 0x3fe33333, 0x33333337, 0x3fc33333, 0x3333333f},	/* 1.32582=f(0.6, 0.15)*/
{64, 0,123,__LINE__, 0x3ff3fc17, 0x6b7a855f, 0x3fe33333, 0x33333337, 0x3fc99999, 0x999999a6},	/* 1.24905=f(0.6, 0.2)*/
{64, 0,123,__LINE__, 0x3ff2d0ea, 0xd6066394, 0x3fe33333, 0x33333337, 0x3fd00000, 0x00000006},	/* 1.17601=f(0.6, 0.25)*/
{64, 0,123,__LINE__, 0x3ff1b6e1, 0x92ebbe44, 0x3fe33333, 0x33333337, 0x3fd33333, 0x33333339},	/* 1.10715=f(0.6, 0.3)*/
{64, 0,123,__LINE__, 0x3ff0aefd, 0x22e6aa36, 0x3fe33333, 0x33333337, 0x3fd66666, 0x6666666c},	/* 1.04272=f(0.6, 0.35)*/
{64, 0,123,__LINE__, 0x3fef730b, 0xd281f69b, 0x3fe33333, 0x33333337, 0x3fd99999, 0x9999999f},	/* 0.982794=f(0.6, 0.4)*/
{64, 0,123,__LINE__, 0x3fedac67, 0x0561bb50, 0x3fe33333, 0x33333337, 0x3fdccccc, 0xccccccd2},	/* 0.927295=f(0.6, 0.45)*/
{64, 0,123,__LINE__, 0x3fec08aa, 0xe496efa6, 0x3fe33333, 0x33333337, 0x3fe00000, 0x00000003},	/* 0.876058=f(0.6, 0.5)*/
{63, 0,123,__LINE__, 0x3fea85ee, 0x761a35a2, 0x3fe33333, 0x33333337, 0x3fe19999, 0x9999999d},	/* 0.828849=f(0.6, 0.55)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fe33333, 0x33333337, 0x3fe33333, 0x33333337},	/* 0.785398=f(0.6, 0.6)*/
{64, 0,123,__LINE__, 0x3fe7da79, 0xf20cc443, 0x3fe33333, 0x33333337, 0x3fe4cccc, 0xccccccd1},	/* 0.745419=f(0.6, 0.65)*/
{64, 0,123,__LINE__, 0x3fe6ad11, 0x00fbfddf, 0x3fe33333, 0x33333337, 0x3fe66666, 0x6666666b},	/* 0.708626=f(0.6, 0.7)*/
{64, 0,123,__LINE__, 0x3fe5977a, 0x5103ea92, 0x3fe33333, 0x33333337, 0x3fe80000, 0x00000005},	/* 0.674741=f(0.6, 0.75)*/
{64, 0,123,__LINE__, 0x3fe4978f, 0xa3269ee1, 0x3fe33333, 0x33333337, 0x3fe99999, 0x9999999f},	/* 0.643501=f(0.6, 0.8)*/
{64, 0,123,__LINE__, 0x3fe3ab51, 0xa3923153, 0x3fe33333, 0x33333337, 0x3feb3333, 0x33333339},	/* 0.614663=f(0.6, 0.85)*/
{64, 0,123,__LINE__, 0x3fe2d0ea, 0xd6066395, 0x3fe33333, 0x33333337, 0x3feccccc, 0xccccccd3},	/* 0.588003=f(0.6, 0.9)*/
{64, 0,123,__LINE__, 0x3fe206af, 0xd30d3731, 0x3fe33333, 0x33333337, 0x3fee6666, 0x6666666d},	/* 0.563316=f(0.6, 0.95)*/
{64, 0,123,__LINE__, 0x40048590, 0xb7aedd62, 0x3fe4cccc, 0xccccccd1, 0xbff00000, 0x00000000},	/* 2.56522=f(0.65, -1)*/
{64, 0,123,__LINE__, 0x40045514, 0x33f00782, 0x3fe4cccc, 0xccccccd1, 0xbfee6666, 0x66666666},	/* 2.54154=f(0.65, -0.95)*/
{64, 0,123,__LINE__, 0x400420fd, 0x07447552, 0x3fe4cccc, 0xccccccd1, 0xbfeccccc, 0xcccccccc},	/* 2.51611=f(0.65, -0.9)*/
{64, 0,123,__LINE__, 0x4003e8f3, 0xacb51f92, 0x3fe4cccc, 0xccccccd1, 0xbfeb3333, 0x33333332},	/* 2.48875=f(0.65, -0.85)*/
{64, 0,123,__LINE__, 0x4003ac98, 0xf27e8651, 0x3fe4cccc, 0xccccccd1, 0xbfe99999, 0x99999998},	/* 2.45928=f(0.65, -0.8)*/
{64, 0,123,__LINE__, 0x40036b86, 0x251cd70d, 0x3fe4cccc, 0xccccccd1, 0xbfe7ffff, 0xfffffffe},	/* 2.4275=f(0.65, -0.75)*/
{64, 0,123,__LINE__, 0x4003254d, 0xb30ae9d3, 0x3fe4cccc, 0xccccccd1, 0xbfe66666, 0x66666664},	/* 2.39321=f(0.65, -0.7)*/
{64, 0,123,__LINE__, 0x4002d97c, 0x7f3321d1, 0x3fe4cccc, 0xccccccd1, 0xbfe4cccc, 0xccccccca},	/* 2.35619=f(0.65, -0.65)*/
{64, 0,123,__LINE__, 0x4002879c, 0x26a5479b, 0x3fe4cccc, 0xccccccd1, 0xbfe33333, 0x33333330},	/* 2.31622=f(0.65, -0.6)*/
{64, 0,123,__LINE__, 0x40022f36, 0x8bf3da1f, 0x3fe4cccc, 0xccccccd1, 0xbfe19999, 0x99999996},	/* 2.27305=f(0.65, -0.55)*/
{64, 0,123,__LINE__, 0x4001cfdb, 0x0358ca06, 0x3fe4cccc, 0xccccccd1, 0xbfdfffff, 0xfffffff9},	/* 2.22649=f(0.65, -0.5)*/
{64, 0,123,__LINE__, 0x40016925, 0x7715b182, 0x3fe4cccc, 0xccccccd1, 0xbfdccccc, 0xccccccc6},	/* 2.17634=f(0.65, -0.45)*/
{63, 0,123,__LINE__, 0x4000fac7, 0xc0872c2b, 0x3fe4cccc, 0xccccccd1, 0xbfd99999, 0x99999993},	/* 2.12245=f(0.65, -0.4)*/
{64, 0,123,__LINE__, 0x40008495, 0x326f4bf0, 0x3fe4cccc, 0xccccccd1, 0xbfd66666, 0x66666660},	/* 2.06474=f(0.65, -0.35)*/
{64, 0,123,__LINE__, 0x4000068f, 0xdf56fb08, 0x3fe4cccc, 0xccccccd1, 0xbfd33333, 0x3333332d},	/* 2.0032=f(0.65, -0.3)*/
{64, 0,123,__LINE__, 0x3fff01ec, 0xffc750ae, 0x3fe4cccc, 0xccccccd1, 0xbfcfffff, 0xfffffff4},	/* 1.93797=f(0.65, -0.25)*/
{64, 0,123,__LINE__, 0x3ffde8a2, 0x2515088e, 0x3fe4cccc, 0xccccccd1, 0xbfc99999, 0x9999998e},	/* 1.8693=f(0.65, -0.2)*/
{64, 0,123,__LINE__, 0x3ffcc2f3, 0x2876c448, 0x3fe4cccc, 0xccccccd1, 0xbfc33333, 0x33333328},	/* 1.7976=f(0.65, -0.15)*/
{63, 0,123,__LINE__, 0x3ffb933b, 0xc05799be, 0x3fe4cccc, 0xccccccd1, 0xbfb99999, 0x99999983},	/* 1.72345=f(0.65, -0.1)*/
{63, 0,123,__LINE__, 0x3ffa5c70, 0x7de844b2, 0x3fe4cccc, 0xccccccd1, 0xbfa99999, 0x9999996c},	/* 1.64757=f(0.65, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d16, 0x3fe4cccc, 0xccccccd1, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.65, 3.19189e-16)*/
{64, 0,123,__LINE__, 0x3ff7e786, 0x2aa0157a, 0x3fe4cccc, 0xccccccd1, 0x3fa99999, 0x999999c8},	/* 1.49402=f(0.65, 0.05)*/
{64, 0,123,__LINE__, 0x3ff6b0ba, 0xe830c06e, 0x3fe4cccc, 0xccccccd1, 0x3fb99999, 0x999999b1},	/* 1.41815=f(0.65, 0.1)*/
{64, 0,123,__LINE__, 0x3ff58103, 0x801195e5, 0x3fe4cccc, 0xccccccd1, 0x3fc33333, 0x3333333f},	/* 1.344=f(0.65, 0.15)*/
{64, 0,123,__LINE__, 0x3ff45b54, 0x8373519f, 0x3fe4cccc, 0xccccccd1, 0x3fc99999, 0x999999a6},	/* 1.2723=f(0.65, 0.2)*/
{64, 0,123,__LINE__, 0x3ff34209, 0xa8c1097f, 0x3fe4cccc, 0xccccccd1, 0x3fd00000, 0x00000006},	/* 1.20362=f(0.65, 0.25)*/
{63, 0,123,__LINE__, 0x3ff236d6, 0xe9da641c, 0x3fe4cccc, 0xccccccd1, 0x3fd33333, 0x33333339},	/* 1.13839=f(0.65, 0.3)*/
{64, 0,123,__LINE__, 0x3ff13acc, 0x43a9c24d, 0x3fe4cccc, 0xccccccd1, 0x3fd66666, 0x6666666c},	/* 1.07685=f(0.65, 0.35)*/
{64, 0,123,__LINE__, 0x3ff04e67, 0x277a01d7, 0x3fe4cccc, 0xccccccd1, 0x3fd99999, 0x9999999f},	/* 1.01914=f(0.65, 0.4)*/
{64, 0,123,__LINE__, 0x3feee357, 0x74b9ee52, 0x3fe4cccc, 0xccccccd1, 0x3fdccccc, 0xccccccd2},	/* 0.965252=f(0.65, 0.45)*/
{64, 0,123,__LINE__, 0x3fed4881, 0x43ad8c44, 0x3fe4cccc, 0xccccccd1, 0x3fe00000, 0x00000003},	/* 0.915101=f(0.65, 0.5)*/
{64, 0,123,__LINE__, 0x3febcb13, 0x21414be0, 0x3fe4cccc, 0xccccccd1, 0x3fe19999, 0x9999999d},	/* 0.868539=f(0.65, 0.55)*/
{63, 0,123,__LINE__, 0x3fea697c, 0xb67b95ee, 0x3fe4cccc, 0xccccccd1, 0x3fe33333, 0x33333337},	/* 0.825377=f(0.65, 0.6)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fe4cccc, 0xccccccd1, 0x3fe4cccc, 0xccccccd1},	/* 0.785398=f(0.65, 0.65)*/
{64, 0,123,__LINE__, 0x3fe7f2b6, 0x84e50d11, 0x3fe4cccc, 0xccccccd1, 0x3fe66666, 0x6666666b},	/* 0.748378=f(0.65, 0.7)*/
{64, 0,123,__LINE__, 0x3fe6d9d4, 0xbc9d5828, 0x3fe4cccc, 0xccccccd1, 0x3fe80000, 0x00000005},	/* 0.714091=f(0.65, 0.75)*/
{64, 0,123,__LINE__, 0x3fe5d589, 0x87169b18, 0x3fe4cccc, 0xccccccd1, 0x3fe99999, 0x9999999f},	/* 0.682317=f(0.65, 0.8)*/
{64, 0,123,__LINE__, 0x3fe4e41e, 0x9e3c3615, 0x3fe4cccc, 0xccccccd1, 0x3feb3333, 0x33333339},	/* 0.652847=f(0.65, 0.85)*/
{64, 0,123,__LINE__, 0x3fe403f9, 0x33fedf17, 0x3fe4cccc, 0xccccccd1, 0x3feccccc, 0xccccccd3},	/* 0.625485=f(0.65, 0.9)*/
{64, 0,123,__LINE__, 0x3fe3339c, 0x81509658, 0x3fe4cccc, 0xccccccd1, 0x3fee6666, 0x6666666d},	/* 0.60005=f(0.65, 0.95)*/
{64, 0,123,__LINE__, 0x40043f37, 0x08e537ec, 0x3fe66666, 0x6666666b, 0xbff00000, 0x00000000},	/* 2.53087=f(0.7, -1)*/
{64, 0,123,__LINE__, 0x40040d72, 0x6e9f7ad4, 0x3fe66666, 0x6666666b, 0xbfee6666, 0x66666666},	/* 2.50657=f(0.7, -0.95)*/
{64, 0,123,__LINE__, 0x4003d82a, 0x5408834d, 0x3fe66666, 0x6666666b, 0xbfeccccc, 0xcccccccc},	/* 2.48055=f(0.7, -0.9)*/
{64, 0,123,__LINE__, 0x40039f10, 0x8a1dc76f, 0x3fe66666, 0x6666666b, 0xbfeb3333, 0x33333332},	/* 2.45267=f(0.7, -0.85)*/
{64, 0,123,__LINE__, 0x400361d1, 0x62e61b8a, 0x3fe66666, 0x6666666b, 0xbfe99999, 0x99999998},	/* 2.42276=f(0.7, -0.8)*/
{64, 0,123,__LINE__, 0x40032014, 0x3b9f415f, 0x3fe66666, 0x6666666b, 0xbfe7ffff, 0xfffffffe},	/* 2.39066=f(0.7, -0.75)*/
{64, 0,123,__LINE__, 0x4002d97c, 0x7f3321d1, 0x3fe66666, 0x6666666b, 0xbfe66666, 0x66666664},	/* 2.35619=f(0.7, -0.7)*/
{64, 0,123,__LINE__, 0x40028dab, 0x4b5b59cf, 0x3fe66666, 0x6666666b, 0xbfe4cccc, 0xccccccca},	/* 2.31917=f(0.7, -0.65)*/
{64, 0,123,__LINE__, 0x40023c41, 0xea611602, 0x3fe66666, 0x6666666b, 0xbfe33333, 0x33333330},	/* 2.27942=f(0.7, -0.6)*/
{64, 0,123,__LINE__, 0x4001e4e5, 0x5817921d, 0x3fe66666, 0x6666666b, 0xbfe19999, 0x99999996},	/* 2.23677=f(0.7, -0.55)*/
{64, 0,123,__LINE__, 0x40018743, 0x06ef5823, 0x3fe66666, 0x6666666b, 0xbfdfffff, 0xfffffff9},	/* 2.19105=f(0.7, -0.5)*/
{63, 0,123,__LINE__, 0x40012317, 0x0c990103, 0x3fe66666, 0x6666666b, 0xbfdccccc, 0xccccccc6},	/* 2.14213=f(0.7, -0.45)*/
{63, 0,123,__LINE__, 0x4000b833, 0xbe165cc7, 0x3fe66666, 0x6666666b, 0xbfd99999, 0x99999993},	/* 2.08994=f(0.7, -0.4)*/
{64, 0,123,__LINE__, 0x4000468a, 0x8ace4df4, 0x3fe66666, 0x6666666b, 0xbfd66666, 0x66666660},	/* 2.03444=f(0.7, -0.35)*/
{63, 0,123,__LINE__, 0x3fff9c6b, 0x238c6431, 0x3fe66666, 0x6666666b, 0xbfd33333, 0x3333332d},	/* 1.97569=f(0.7, -0.3)*/
{63, 0,123,__LINE__, 0x3ffe9f02, 0x0021cec4, 0x3fe66666, 0x6666666b, 0xbfcfffff, 0xfffffff4},	/* 1.91382=f(0.7, -0.25)*/
{63, 0,123,__LINE__, 0x3ffd95e5, 0xac22d089, 0x3fe66666, 0x6666666b, 0xbfc99999, 0x9999998e},	/* 1.8491=f(0.7, -0.2)*/
{64, 0,123,__LINE__, 0x3ffc829e, 0xbb6db38b, 0x3fe66666, 0x6666666b, 0xbfc33333, 0x33333328},	/* 1.78189=f(0.7, -0.15)*/
{63, 0,123,__LINE__, 0x3ffb6731, 0x2cd2f431, 0x3fe66666, 0x6666666b, 0xbfb99999, 0x99999983},	/* 1.71269=f(0.7, -0.1)*/
{63, 0,123,__LINE__, 0x3ffa460e, 0xa017978e, 0x3fe66666, 0x6666666b, 0xbfa99999, 0x9999996c},	/* 1.6421=f(0.7, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d16, 0x3fe66666, 0x6666666b, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.7, 3.19189e-16)*/
{64, 0,123,__LINE__, 0x3ff7fde8, 0x0870c29e, 0x3fe66666, 0x6666666b, 0x3fa99999, 0x999999c8},	/* 1.49949=f(0.7, 0.05)*/
{64, 0,123,__LINE__, 0x3ff6dcc5, 0x7bb565fb, 0x3fe66666, 0x6666666b, 0x3fb99999, 0x999999b1},	/* 1.4289=f(0.7, 0.1)*/
{64, 0,123,__LINE__, 0x3ff5c157, 0xed1aa6a2, 0x3fe66666, 0x6666666b, 0x3fc33333, 0x3333333f},	/* 1.3597=f(0.7, 0.15)*/
{63, 0,123,__LINE__, 0x3ff4ae10, 0xfc6589a4, 0x3fe66666, 0x6666666b, 0x3fc99999, 0x999999a6},	/* 1.2925=f(0.7, 0.2)*/
{64, 0,123,__LINE__, 0x3ff3a4f4, 0xa8668b68, 0x3fe66666, 0x6666666b, 0x3fd00000, 0x00000006},	/* 1.22777=f(0.7, 0.25)*/
{64, 0,123,__LINE__, 0x3ff2a78b, 0x84fbf5fc, 0x3fe66666, 0x6666666b, 0x3fd33333, 0x33333339},	/* 1.1659=f(0.7, 0.3)*/
{64, 0,123,__LINE__, 0x3ff1b6e1, 0x92ebbe44, 0x3fe66666, 0x6666666b, 0x3fd66666, 0x6666666c},	/* 1.10715=f(0.7, 0.35)*/
{64, 0,123,__LINE__, 0x3ff0d38f, 0x2c5ba09f, 0x3fe66666, 0x6666666b, 0x3fd99999, 0x9999999f},	/* 1.05165=f(0.7, 0.4)*/
{64, 0,123,__LINE__, 0x3feffb91, 0x1eacb051, 0x3fe66666, 0x6666666b, 0x3fdccccc, 0xccccccd2},	/* 0.999459=f(0.7, 0.45)*/
{64, 0,123,__LINE__, 0x3fee6ae1, 0x355353d0, 0x3fe66666, 0x6666666b, 0x3fe00000, 0x00000003},	/* 0.950547=f(0.7, 0.5)*/
{63, 0,123,__LINE__, 0x3fecf457, 0xf0b26be8, 0x3fe66666, 0x6666666b, 0x3fe19999, 0x9999999d},	/* 0.904827=f(0.7, 0.55)*/
{64, 0,123,__LINE__, 0x3feb96e5, 0xa78c5c52, 0x3fe66666, 0x6666666b, 0x3fe33333, 0x33333337},	/* 0.86217=f(0.7, 0.6)*/
{64, 0,123,__LINE__, 0x3fea5140, 0x23a34d20, 0x3fe66666, 0x6666666b, 0x3fe4cccc, 0xccccccd1},	/* 0.822418=f(0.7, 0.65)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fe66666, 0x6666666b, 0x3fe66666, 0x6666666b},	/* 0.785398=f(0.7, 0.7)*/
{64, 0,123,__LINE__, 0x3fe8079c, 0x6293aee0, 0x3fe66666, 0x6666666b, 0x3fe80000, 0x00000005},	/* 0.750929=f(0.7, 0.75)*/
{64, 0,123,__LINE__, 0x3fe700a7, 0xc5784634, 0x3fe66666, 0x6666666b, 0x3fe99999, 0x9999999f},	/* 0.71883=f(0.7, 0.8)*/
{64, 0,123,__LINE__, 0x3fe60bab, 0x289996a1, 0x3fe66666, 0x6666666b, 0x3feb3333, 0x33333339},	/* 0.688924=f(0.7, 0.85)*/
{63, 0,123,__LINE__, 0x3fe52744, 0x00eea72a, 0x3fe66666, 0x6666666b, 0x3feccccc, 0xccccccd3},	/* 0.661043=f(0.7, 0.9)*/
{64, 0,123,__LINE__, 0x3fe45223, 0x9692c90f, 0x3fe66666, 0x6666666b, 0x3fee6666, 0x6666666d},	/* 0.635027=f(0.7, 0.95)*/
{64, 0,123,__LINE__, 0x4003fc17, 0x6b7a855f, 0x3fe80000, 0x00000005, 0xbff00000, 0x00000000},	/* 2.49809=f(0.75, -1)*/
{64, 0,123,__LINE__, 0x4003c953, 0x34d30df4, 0x3fe80000, 0x00000005, 0xbfee6666, 0x66666666},	/* 2.4733=f(0.75, -0.95)*/
{64, 0,123,__LINE__, 0x40039328, 0x6347d275, 0x3fe80000, 0x00000005, 0xbfeccccc, 0xcccccccc},	/* 2.44685=f(0.75, -0.9)*/
{64, 0,123,__LINE__, 0x40035951, 0xee0fd5c9, 0x3fe80000, 0x00000005, 0xbfeb3333, 0x33333332},	/* 2.41861=f(0.75, -0.85)*/
{64, 0,123,__LINE__, 0x40031b87, 0x267eca84, 0x3fe80000, 0x00000005, 0xbfe99999, 0x99999998},	/* 2.38844=f(0.75, -0.8)*/
{64, 0,123,__LINE__, 0x4002d97c, 0x7f3321d1, 0x3fe80000, 0x00000005, 0xbfe7ffff, 0xfffffffe},	/* 2.35619=f(0.75, -0.75)*/
{64, 0,123,__LINE__, 0x400292e4, 0xc2c70243, 0x3fe80000, 0x00000005, 0xbfe66666, 0x66666664},	/* 2.32173=f(0.75, -0.7)*/
{64, 0,123,__LINE__, 0x40024772, 0xd9496c95, 0x3fe80000, 0x00000005, 0xbfe4cccc, 0xccccccca},	/* 2.28489=f(0.75, -0.65)*/
{64, 0,123,__LINE__, 0x4001f6dc, 0x3e63112f, 0x3fe80000, 0x00000005, 0xbfe33333, 0x33333330},	/* 2.24554=f(0.75, -0.6)*/
{64, 0,123,__LINE__, 0x4001a0dc, 0x49296b7c, 0x3fe80000, 0x00000005, 0xbfe19999, 0x99999996},	/* 2.20355=f(0.75, -0.55)*/
{64, 0,123,__LINE__, 0x40014538, 0x5fa3af70, 0x3fe80000, 0x00000005, 0xbfdfffff, 0xfffffff9},	/* 2.1588=f(0.75, -0.5)*/
{64, 0,123,__LINE__, 0x4000e3c5, 0x1fa059c3, 0x3fe80000, 0x00000005, 0xbfdccccc, 0xccccccc6},	/* 2.11122=f(0.75, -0.45)*/
{64, 0,123,__LINE__, 0x40007c6c, 0x6947a6a6, 0x3fe80000, 0x00000005, 0xbfd99999, 0x99999993},	/* 2.06075=f(0.75, -0.4)*/
{64, 0,123,__LINE__, 0x40000f34, 0x0b81a4ee, 0x3fe80000, 0x00000005, 0xbfd66666, 0x66666660},	/* 2.00742=f(0.75, -0.35)*/
{63, 0,123,__LINE__, 0x3fff3889, 0x2f1e0c85, 0x3fe80000, 0x00000005, 0xbfd33333, 0x3333332d},	/* 1.9513=f(0.75, -0.3)*/
{64, 0,123,__LINE__, 0x3ffe47df, 0x3d0dd4ce, 0x3fe80000, 0x00000005, 0xbfcfffff, 0xfffffff4},	/* 1.89255=f(0.75, -0.25)*/
{64, 0,123,__LINE__, 0x3ffd4d68, 0xbe213417, 0x3fe80000, 0x00000005, 0xbfc99999, 0x9999998e},	/* 1.8314=f(0.75, -0.2)*/
{63, 0,123,__LINE__, 0x3ffc4a83, 0x936311d7, 0x3fe80000, 0x00000005, 0xbfc33333, 0x33333328},	/* 1.76819=f(0.75, -0.15)*/
{63, 0,123,__LINE__, 0x3ffb40e9, 0xaf482897, 0x3fe80000, 0x00000005, 0xbfb99999, 0x99999983},	/* 1.70335=f(0.75, -0.1)*/
{63, 0,123,__LINE__, 0x3ffa32a5, 0x1baa2088, 0x3fe80000, 0x00000005, 0xbfa99999, 0x9999996c},	/* 1.63736=f(0.75, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d16, 0x3fe80000, 0x00000005, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.75, 3.19189e-16)*/
{64, 0,123,__LINE__, 0x3ff81151, 0x8cde39a4, 0x3fe80000, 0x00000005, 0x3fa99999, 0x999999c8},	/* 1.50423=f(0.75, 0.05)*/
{64, 0,123,__LINE__, 0x3ff7030c, 0xf9403195, 0x3fe80000, 0x00000005, 0x3fb99999, 0x999999b1},	/* 1.43824=f(0.75, 0.1)*/
{64, 0,123,__LINE__, 0x3ff5f973, 0x15254856, 0x3fe80000, 0x00000005, 0x3fc33333, 0x3333333f},	/* 1.3734=f(0.75, 0.15)*/
{64, 0,123,__LINE__, 0x3ff4f68d, 0xea672616, 0x3fe80000, 0x00000005, 0x3fc99999, 0x999999a6},	/* 1.31019=f(0.75, 0.2)*/
{64, 0,123,__LINE__, 0x3ff3fc17, 0x6b7a855f, 0x3fe80000, 0x00000005, 0x3fd00000, 0x00000006},	/* 1.24905=f(0.75, 0.25)*/
{64, 0,123,__LINE__, 0x3ff30b6d, 0x796a4da8, 0x3fe80000, 0x00000005, 0x3fd33333, 0x33333339},	/* 1.19029=f(0.75, 0.3)*/
{64, 0,123,__LINE__, 0x3ff2258e, 0x91851051, 0x3fe80000, 0x00000005, 0x3fd66666, 0x6666666c},	/* 1.13417=f(0.75, 0.35)*/
{64, 0,123,__LINE__, 0x3ff14b1d, 0xd5f90ce1, 0x3fe80000, 0x00000005, 0x3fd99999, 0x9999999f},	/* 1.08084=f(0.75, 0.4)*/
{64, 0,123,__LINE__, 0x3ff07c6c, 0x6947a6a8, 0x3fe80000, 0x00000005, 0x3fdccccc, 0xccccccd2},	/* 1.03038=f(0.75, 0.45)*/
{64, 0,123,__LINE__, 0x3fef730b, 0xd281f69b, 0x3fe80000, 0x00000005, 0x3fe00000, 0x00000003},	/* 0.982794=f(0.75, 0.5)*/
{64, 0,123,__LINE__, 0x3fee047c, 0x2c6b066a, 0x3fe80000, 0x00000005, 0x3fe19999, 0x9999999d},	/* 0.938047=f(0.75, 0.55)*/
{64, 0,123,__LINE__, 0x3fecac7c, 0x57846f9e, 0x3fe80000, 0x00000005, 0x3fe33333, 0x33333337},	/* 0.896055=f(0.75, 0.6)*/
{64, 0,123,__LINE__, 0x3feb6a21, 0xebeb0209, 0x3fe80000, 0x00000005, 0x3fe4cccc, 0xccccccd1},	/* 0.856706=f(0.75, 0.65)*/
{64, 0,123,__LINE__, 0x3fea3c5a, 0x45f4ab51, 0x3fe80000, 0x00000005, 0x3fe66666, 0x6666666b},	/* 0.819867=f(0.75, 0.7)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fe80000, 0x00000005, 0x3fe80000, 0x00000005},	/* 0.785398=f(0.75, 0.75)*/
{64, 0,123,__LINE__, 0x3fe819d0, 0xb7158a4d, 0x3fe80000, 0x00000005, 0x3fe99999, 0x9999999f},	/* 0.753151=f(0.75, 0.8)*/
{64, 0,123,__LINE__, 0x3fe722a5, 0x98d15d3a, 0x3fe80000, 0x00000005, 0x3feb3333, 0x33333339},	/* 0.722979=f(0.75, 0.85)*/
{64, 0,123,__LINE__, 0x3fe63b4b, 0xc3f16a8a, 0x3fe80000, 0x00000005, 0x3feccccc, 0xccccccd3},	/* 0.694738=f(0.75, 0.9)*/
{64, 0,123,__LINE__, 0x3fe562a0, 0x7dc47c8f, 0x3fe80000, 0x00000005, 0x3fee6666, 0x6666666d},	/* 0.668289=f(0.75, 0.95)*/
{64, 0,123,__LINE__, 0x4003bc1c, 0xc0033273, 0x3fe99999, 0x9999999f, 0xbff00000, 0x00000000},	/* 2.46685=f(0.8, -1)*/
{64, 0,123,__LINE__, 0x40038899, 0xe572fe85, 0x3fe99999, 0x9999999f, 0xbfee6666, 0x66666666},	/* 2.4417=f(0.8, -0.95)*/
{64, 0,123,__LINE__, 0x400351d1, 0x783b3dad, 0x3fe99999, 0x9999999f, 0xbfeccccc, 0xcccccccc},	/* 2.41495=f(0.8, -0.9)*/
{63, 0,123,__LINE__, 0x40031787, 0x26d41fcd, 0x3fe99999, 0x9999999f, 0xbfeb3333, 0x33333332},	/* 2.38649=f(0.8, -0.85)*/
{64, 0,123,__LINE__, 0x4002d97c, 0x7f3321d1, 0x3fe99999, 0x9999999f, 0xbfe99999, 0x99999998},	/* 2.35619=f(0.8, -0.8)*/
{64, 0,123,__LINE__, 0x40029771, 0xd7e7791e, 0x3fe99999, 0x9999999f, 0xbfe7ffff, 0xfffffffe},	/* 2.32395=f(0.8, -0.75)*/
{64, 0,123,__LINE__, 0x40025127, 0x9b802818, 0x3fe99999, 0x9999999f, 0xbfe66666, 0x66666664},	/* 2.28963=f(0.8, -0.7)*/
{64, 0,123,__LINE__, 0x40020660, 0x0be7bd51, 0x3fe99999, 0x9999999f, 0xbfe4cccc, 0xccccccca},	/* 2.25311=f(0.8, -0.65)*/
{64, 0,123,__LINE__, 0x4001b6e1, 0x92ebbe43, 0x3fe99999, 0x9999999f, 0xbfe33333, 0x33333330},	/* 2.2143=f(0.8, -0.6)*/
{63, 0,123,__LINE__, 0x40016279, 0xb155a479, 0x3fe99999, 0x9999999f, 0xbfe19999, 0x99999996},	/* 2.17308=f(0.8, -0.55)*/
{64, 0,123,__LINE__, 0x40010900, 0x9519d638, 0x3fe99999, 0x9999999f, 0xbfdfffff, 0xfffffff9},	/* 2.1294=f(0.8, -0.5)*/
{64, 0,123,__LINE__, 0x4000aa5d, 0x4f58e2bf, 0x3fe99999, 0x9999999f, 0xbfdccccc, 0xccccccc6},	/* 2.08319=f(0.8, -0.45)*/
{63, 0,123,__LINE__, 0x4000468a, 0x8ace4df5, 0x3fe99999, 0x9999999f, 0xbfd99999, 0x99999993},	/* 2.03444=f(0.8, -0.4)*/
{64, 0,123,__LINE__, 0x3fffbb37, 0x05373615, 0x3fe99999, 0x9999999f, 0xbfd66666, 0x66666660},	/* 1.98321=f(0.8, -0.35)*/
{64, 0,123,__LINE__, 0x3ffedf81, 0xa4bd64d2, 0x3fe99999, 0x9999999f, 0xbfd33333, 0x3333332d},	/* 1.92957=f(0.8, -0.3)*/
{64, 0,123,__LINE__, 0x3ffdfa99, 0x22062809, 0x3fe99999, 0x9999999f, 0xbfcfffff, 0xfffffff4},	/* 1.87368=f(0.8, -0.25)*/
{63, 0,123,__LINE__, 0x3ffd0d6a, 0x1369bd31, 0x3fe99999, 0x9999999f, 0xbfc99999, 0x9999998e},	/* 1.81577=f(0.8, -0.2)*/
{63, 0,123,__LINE__, 0x3ffc192a, 0xbdbdf876, 0x3fe99999, 0x9999999f, 0xbfc33333, 0x33333328},	/* 1.75614=f(0.8, -0.15)*/
{64, 0,123,__LINE__, 0x3ffb1f56, 0xfdeef00d, 0x3fe99999, 0x9999999f, 0xbfb99999, 0x99999983},	/* 1.69515=f(0.8, -0.1)*/
{64, 0,123,__LINE__, 0x3ffa21a6, 0x31fd9506, 0x3fe99999, 0x9999999f, 0xbfa99999, 0x9999996c},	/* 1.63322=f(0.8, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d16, 0x3fe99999, 0x9999999f, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.8, 3.19189e-16)*/
{64, 0,123,__LINE__, 0x3ff82250, 0x768ac527, 0x3fe99999, 0x9999999f, 0x3fa99999, 0x999999c8},	/* 1.50838=f(0.8, 0.05)*/
{64, 0,123,__LINE__, 0x3ff7249f, 0xaa996a20, 0x3fe99999, 0x9999999f, 0x3fb99999, 0x999999b1},	/* 1.44644=f(0.8, 0.1)*/
{64, 0,123,__LINE__, 0x3ff62acb, 0xeaca61b7, 0x3fe99999, 0x9999999f, 0x3fc33333, 0x3333333f},	/* 1.38545=f(0.8, 0.15)*/
{64, 0,123,__LINE__, 0x3ff5368c, 0x951e9cfc, 0x3fe99999, 0x9999999f, 0x3fc99999, 0x999999a6},	/* 1.32582=f(0.8, 0.2)*/
{64, 0,123,__LINE__, 0x3ff4495d, 0x86823225, 0x3fe99999, 0x9999999f, 0x3fd00000, 0x00000006},	/* 1.26791=f(0.8, 0.25)*/
{64, 0,123,__LINE__, 0x3ff36475, 0x03caf55c, 0x3fe99999, 0x9999999f, 0x3fd33333, 0x33333339},	/* 1.21203=f(0.8, 0.3)*/
{64, 0,123,__LINE__, 0x3ff288bf, 0xa3512419, 0x3fe99999, 0x9999999f, 0x3fd66666, 0x6666666c},	/* 1.15839=f(0.8, 0.35)*/
{64, 0,123,__LINE__, 0x3ff1b6e1, 0x92ebbe44, 0x3fe99999, 0x9999999f, 0x3fd99999, 0x9999999f},	/* 1.10715=f(0.8, 0.4)*/
{64, 0,123,__LINE__, 0x3ff0ef3c, 0x09d694b1, 0x3fe99999, 0x9999999f, 0x3fdccccc, 0xccccccd2},	/* 1.05841=f(0.8, 0.45)*/
{64, 0,123,__LINE__, 0x3ff031f5, 0x7e54adbe, 0x3fe99999, 0x9999999f, 0x3fe00000, 0x00000003},	/* 1.0122=f(0.8, 0.5)*/
{63, 0,123,__LINE__, 0x3feefe06, 0x8bba2276, 0x3fe99999, 0x9999999f, 0x3fe19999, 0x9999999d},	/* 0.968509=f(0.8, 0.55)*/
{64, 0,123,__LINE__, 0x3fedac67, 0x0561bb50, 0x3fe99999, 0x9999999f, 0x3fe33333, 0x33333337},	/* 0.927295=f(0.8, 0.6)*/
{64, 0,123,__LINE__, 0x3fec6e6d, 0x2171bf19, 0x3fe99999, 0x9999999f, 0x3fe4cccc, 0xccccccd1},	/* 0.88848=f(0.8, 0.65)*/
{63, 0,123,__LINE__, 0x3feb434e, 0xe31013fd, 0x3fe99999, 0x9999999f, 0x3fe66666, 0x6666666b},	/* 0.851966=f(0.8, 0.7)*/
{64, 0,123,__LINE__, 0x3fea2a25, 0xf172cfe4, 0x3fe99999, 0x9999999f, 0x3fe80000, 0x00000005},	/* 0.817645=f(0.8, 0.75)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fe99999, 0x9999999f, 0x3fe99999, 0x9999999f},	/* 0.785398=f(0.8, 0.8)*/
{64, 0,123,__LINE__, 0x3fe829d0, 0xb5c0352b, 0x3fe99999, 0x9999999f, 0x3feb3333, 0x33333339},	/* 0.755104=f(0.8, 0.85)*/
{64, 0,123,__LINE__, 0x3fe740a7, 0x7023bda9, 0x3fe99999, 0x9999999f, 0x3feccccc, 0xccccccd3},	/* 0.726642=f(0.8, 0.9)*/
{64, 0,123,__LINE__, 0x3fe66585, 0xbb44ba4a, 0x3fe99999, 0x9999999f, 0x3fee6666, 0x6666666d},	/* 0.699893=f(0.8, 0.95)*/
{64, 0,123,__LINE__, 0x40037f2d, 0x8b93012a, 0x3feb3333, 0x33333339, 0xbff00000, 0x00000000},	/* 2.4371=f(0.85, -1)*/
{64, 0,123,__LINE__, 0x40034b25, 0xb27b30a4, 0x3feb3333, 0x33333339, 0xbfee6666, 0x66666666},	/* 2.41169=f(0.85, -0.95)*/
{64, 0,123,__LINE__, 0x400313fc, 0x14754e12, 0x3feb3333, 0x33333339, 0xbfeccccc, 0xcccccccc},	/* 2.38476=f(0.85, -0.9)*/
{64, 0,123,__LINE__, 0x4002d97c, 0x7f3321d1, 0x3feb3333, 0x33333339, 0xbfeb3333, 0x33333332},	/* 2.35619=f(0.85, -0.85)*/
{64, 0,123,__LINE__, 0x40029b71, 0xd79223d6, 0x3feb3333, 0x33333339, 0xbfe99999, 0x99999998},	/* 2.3259=f(0.85, -0.8)*/
{64, 0,123,__LINE__, 0x400259a7, 0x10566dd9, 0x3feb3333, 0x33333339, 0xbfe7ffff, 0xfffffffe},	/* 2.29378=f(0.85, -0.75)*/
{64, 0,123,__LINE__, 0x400213e8, 0x74487c33, 0x3feb3333, 0x33333339, 0xbfe66666, 0x66666664},	/* 2.25972=f(0.85, -0.7)*/
{64, 0,123,__LINE__, 0x4001ca05, 0x51b12410, 0x3feb3333, 0x33333339, 0xbfe4cccc, 0xccccccca},	/* 2.22364=f(0.85, -0.65)*/
{64, 0,123,__LINE__, 0x40017bd2, 0x1306a2e0, 0x3feb3333, 0x33333339, 0xbfe33333, 0x33333330},	/* 2.18546=f(0.85, -0.6)*/
{64, 0,123,__LINE__, 0x4001292a, 0xcb9e5e96, 0x3feb3333, 0x33333339, 0xbfe19999, 0x99999996},	/* 2.1451=f(0.85, -0.55)*/
{63, 0,123,__LINE__, 0x4000d1f6, 0x365d11c7, 0x3feb3333, 0x33333339, 0xbfdfffff, 0xfffffff9},	/* 2.10252=f(0.85, -0.5)*/
{64, 0,123,__LINE__, 0x40007629, 0x16cab415, 0x3feb3333, 0x33333339, 0xbfdccccc, 0xccccccc6},	/* 2.0577=f(0.85, -0.45)*/
{64, 0,123,__LINE__, 0x400015c9, 0xda46bdfc, 0x3feb3333, 0x33333339, 0xbfd99999, 0x99999993},	/* 2.01064=f(0.85, -0.4)*/
{64, 0,123,__LINE__, 0x3fff61e8, 0x80287a1f, 0x3feb3333, 0x33333339, 0xbfd66666, 0x66666660},	/* 1.9614=f(0.85, -0.35)*/
{64, 0,123,__LINE__, 0x3ffe8fb9, 0x6bf1d8f3, 0x3feb3333, 0x33333339, 0xbfd33333, 0x3333332d},	/* 1.91009=f(0.85, -0.3)*/
{63, 0,123,__LINE__, 0x3ffdb5a6, 0x01769191, 0x3feb3333, 0x33333339, 0xbfcfffff, 0xfffffff4},	/* 1.85685=f(0.85, -0.25)*/
{63, 0,123,__LINE__, 0x3ffcd487, 0x74e47387, 0x3feb3333, 0x33333339, 0xbfc99999, 0x9999998e},	/* 1.80189=f(0.85, -0.2)*/
{63, 0,123,__LINE__, 0x3ffbed70, 0x67a8594b, 0x3feb3333, 0x33333339, 0xbfc33333, 0x33333328},	/* 1.74547=f(0.85, -0.15)*/
{64, 0,123,__LINE__, 0x3ffb01a8, 0xbf84055b, 0x3feb3333, 0x33333339, 0xbfb99999, 0x99999983},	/* 1.68791=f(0.85, -0.1)*/
{63, 0,123,__LINE__, 0x3ffa12a5, 0x465464ce, 0x3feb3333, 0x33333339, 0xbfa99999, 0x9999996c},	/* 1.62955=f(0.85, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d17, 0x3feb3333, 0x33333339, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.85, 3.19189e-16)*/
{64, 0,123,__LINE__, 0x3ff83151, 0x6233f55f, 0x3feb3333, 0x33333339, 0x3fa99999, 0x999999c8},	/* 1.51204=f(0.85, 0.05)*/
{64, 0,123,__LINE__, 0x3ff7424d, 0xe90454d2, 0x3feb3333, 0x33333339, 0x3fb99999, 0x999999b1},	/* 1.45369=f(0.85, 0.1)*/
{64, 0,123,__LINE__, 0x3ff65686, 0x40e000e2, 0x3feb3333, 0x33333339, 0x3fc33333, 0x3333333f},	/* 1.39612=f(0.85, 0.15)*/
{64, 0,123,__LINE__, 0x3ff56f6f, 0x33a3e6a6, 0x3feb3333, 0x33333339, 0x3fc99999, 0x999999a6},	/* 1.33971=f(0.85, 0.2)*/
{64, 0,123,__LINE__, 0x3ff48e50, 0xa711c89c, 0x3feb3333, 0x33333339, 0x3fd00000, 0x00000006},	/* 1.28474=f(0.85, 0.25)*/
{64, 0,123,__LINE__, 0x3ff3b43d, 0x3c96813b, 0x3feb3333, 0x33333339, 0x3fd33333, 0x33333339},	/* 1.2315=f(0.85, 0.3)*/
{64, 0,123,__LINE__, 0x3ff2e20e, 0x285fe00f, 0x3feb3333, 0x33333339, 0x3fd66666, 0x6666666c},	/* 1.18019=f(0.85, 0.35)*/
{64, 0,123,__LINE__, 0x3ff21862, 0xf3fade36, 0x3feb3333, 0x33333339, 0x3fd99999, 0x9999999f},	/* 1.13095=f(0.85, 0.4)*/
{63, 0,123,__LINE__, 0x3ff157a4, 0x7af2f205, 0x3feb3333, 0x33333339, 0x3fdccccc, 0xccccccd2},	/* 1.0839=f(0.85, 0.45)*/
{64, 0,123,__LINE__, 0x3ff0a00a, 0x3bce369f, 0x3feb3333, 0x33333339, 0x3fe00000, 0x00000003},	/* 1.03907=f(0.85, 0.5)*/
{64, 0,123,__LINE__, 0x3fefe342, 0x22973a03, 0x3feb3333, 0x33333339, 0x3fe19999, 0x9999999d},	/* 0.996491=f(0.85, 0.55)*/
{64, 0,123,__LINE__, 0x3fee98a5, 0x04f628dd, 0x3feb3333, 0x33333339, 0x3fe33333, 0x33333337},	/* 0.956133=f(0.85, 0.6)*/
{64, 0,123,__LINE__, 0x3fed5fd8, 0x0a4c241b, 0x3feb3333, 0x33333339, 0x3fe4cccc, 0xccccccd1},	/* 0.91795=f(0.85, 0.65)*/
{63, 0,123,__LINE__, 0x3fec384b, 0x7feec38f, 0x3feb3333, 0x33333339, 0x3fe66666, 0x6666666b},	/* 0.881872=f(0.85, 0.7)*/
{64, 0,123,__LINE__, 0x3feb2151, 0x0fb6fcf7, 0x3feb3333, 0x33333339, 0x3fe80000, 0x00000005},	/* 0.847817=f(0.85, 0.75)*/
{64, 0,123,__LINE__, 0x3fea1a25, 0xf2c82506, 0x3feb3333, 0x33333339, 0x3fe99999, 0x9999999f},	/* 0.815692=f(0.85, 0.8)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3feb3333, 0x33333339, 0x3feb3333, 0x33333339},	/* 0.785398=f(0.85, 0.85)*/
{63, 0,123,__LINE__, 0x3fe837fc, 0xff3b7c15, 0x3feb3333, 0x33333339, 0x3feccccc, 0xccccccd3},	/* 0.756835=f(0.85, 0.9)*/
{63, 0,123,__LINE__, 0x3fe75b56, 0x8723f1cc, 0x3feb3333, 0x33333339, 0x3fee6666, 0x6666666d},	/* 0.7299=f(0.85, 0.95)*/
{64, 0,123,__LINE__, 0x4003452d, 0x2a42ac28, 0x3feccccc, 0xccccccd3, 0xbff00000, 0x00000000},	/* 2.40878=f(0.9, -1)*/
{64, 0,123,__LINE__, 0x400310d2, 0xfe7fcad8, 0x3feccccc, 0xccccccd3, 0xbfee6666, 0x66666666},	/* 2.38321=f(0.9, -0.95)*/
{64, 0,123,__LINE__, 0x4002d97c, 0x7f3321d1, 0x3feccccc, 0xccccccd3, 0xbfeccccc, 0xcccccccc},	/* 2.35619=f(0.9, -0.9)*/
{64, 0,123,__LINE__, 0x40029efc, 0xe9f0f590, 0x3feccccc, 0xccccccd3, 0xbfeb3333, 0x33333332},	/* 2.32763=f(0.9, -0.85)*/
{64, 0,123,__LINE__, 0x40026127, 0x862b05f5, 0x3feccccc, 0xccccccd3, 0xbfe99999, 0x99999998},	/* 2.29744=f(0.9, -0.8)*/
{64, 0,123,__LINE__, 0x40021fd0, 0x9b1e712e, 0x3feccccc, 0xccccccd3, 0xbfe7ffff, 0xfffffffe},	/* 2.26553=f(0.9, -0.75)*/
{64, 0,123,__LINE__, 0x4001dace, 0xaa5dc056, 0x3feccccc, 0xccccccd3, 0xbfe66666, 0x66666664},	/* 2.23184=f(0.9, -0.7)*/
{63, 0,123,__LINE__, 0x400191fb, 0xf721ce51, 0x3feccccc, 0xccccccd3, 0xbfe4cccc, 0xccccccca},	/* 2.19628=f(0.9, -0.65)*/
{64, 0,123,__LINE__, 0x40014538, 0x5fa3af70, 0x3feccccc, 0xccccccd3, 0xbfe33333, 0x33333330},	/* 2.1588=f(0.9, -0.6)*/
{64, 0,123,__LINE__, 0x4000f46b, 0x88a03600, 0x3feccccc, 0xccccccd3, 0xbfe19999, 0x99999996},	/* 2.11935=f(0.9, -0.55)*/
{64, 0,123,__LINE__, 0x40009f87, 0x5343d017, 0x3feccccc, 0xccccccd3, 0xbfdfffff, 0xfffffff9},	/* 2.07789=f(0.9, -0.5)*/
{64, 0,123,__LINE__, 0x4000468a, 0x8ace4df5, 0x3feccccc, 0xccccccd3, 0xbfdccccc, 0xccccccc6},	/* 2.03444=f(0.9, -0.45)*/
{64, 0,123,__LINE__, 0x3fffd307, 0x52e32009, 0x3feccccc, 0xccccccd3, 0xbfd99999, 0x99999993},	/* 1.98902=f(0.9, -0.4)*/
{64, 0,123,__LINE__, 0x3fff1127, 0x088152ab, 0x3feccccc, 0xccccccd3, 0xbfd66666, 0x66666660},	/* 1.94169=f(0.9, -0.35)*/
{64, 0,123,__LINE__, 0x3ffe47df, 0x3d0dd4ce, 0x3feccccc, 0xccccccd3, 0xbfd33333, 0x3333332d},	/* 1.89255=f(0.9, -0.3)*/
{63, 0,123,__LINE__, 0x3ffd77c7, 0xb196b31e, 0x3feccccc, 0xccccccd3, 0xbfcfffff, 0xfffffff4},	/* 1.84174=f(0.9, -0.25)*/
{63, 0,123,__LINE__, 0x3ffca1a6, 0x56770bce, 0x3feccccc, 0xccccccd3, 0xbfc99999, 0x9999998e},	/* 1.78947=f(0.9, -0.2)*/
{64, 0,123,__LINE__, 0x3ffbc66e, 0x44cbc072, 0x3feccccc, 0xccccccd3, 0xbfc33333, 0x33333328},	/* 1.73595=f(0.9, -0.15)*/
{63, 0,123,__LINE__, 0x3ffae73b, 0xd5e44e59, 0x3feccccc, 0xccccccd3, 0xbfb99999, 0x99999983},	/* 1.68145=f(0.9, -0.1)*/
{63, 0,123,__LINE__, 0x3ffa054d, 0xbad44abc, 0x3feccccc, 0xccccccd3, 0xbfa99999, 0x9999996c},	/* 1.62629=f(0.9, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d17, 0x3feccccc, 0xccccccd3, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.9, 3.19189e-16)*/
{64, 0,123,__LINE__, 0x3ff83ea8, 0xedb40f71, 0x3feccccc, 0xccccccd3, 0x3fa99999, 0x999999c8},	/* 1.5153=f(0.9, 0.05)*/
{64, 0,123,__LINE__, 0x3ff75cba, 0xd2a40bd4, 0x3feccccc, 0xccccccd3, 0x3fb99999, 0x999999b1},	/* 1.46014=f(0.9, 0.1)*/
{64, 0,123,__LINE__, 0x3ff67d88, 0x63bc99bc, 0x3feccccc, 0xccccccd3, 0x3fc33333, 0x3333333f},	/* 1.40565=f(0.9, 0.15)*/
{64, 0,123,__LINE__, 0x3ff5a250, 0x52114e5f, 0x3feccccc, 0xccccccd3, 0x3fc99999, 0x999999a6},	/* 1.35213=f(0.9, 0.2)*/
{64, 0,123,__LINE__, 0x3ff4cc2e, 0xf6f1a70f, 0x3feccccc, 0xccccccd3, 0x3fd00000, 0x00000006},	/* 1.29985=f(0.9, 0.25)*/
{64, 0,123,__LINE__, 0x3ff3fc17, 0x6b7a8560, 0x3feccccc, 0xccccccd3, 0x3fd33333, 0x33333339},	/* 1.24905=f(0.9, 0.3)*/
{64, 0,123,__LINE__, 0x3ff332cf, 0xa0070783, 0x3feccccc, 0xccccccd3, 0x3fd66666, 0x6666666c},	/* 1.19991=f(0.9, 0.35)*/
{64, 0,123,__LINE__, 0x3ff270ef, 0x55a53a25, 0x3feccccc, 0xccccccd3, 0x3fd99999, 0x9999999f},	/* 1.15257=f(0.9, 0.4)*/
{64, 0,123,__LINE__, 0x3ff1b6e1, 0x92ebbe45, 0x3feccccc, 0xccccccd3, 0x3fdccccc, 0xccccccd2},	/* 1.10715=f(0.9, 0.45)*/
{64, 0,123,__LINE__, 0x3ff104e8, 0x0200ba00, 0x3feccccc, 0xccccccd3, 0x3fe00000, 0x00000003},	/* 1.0637=f(0.9, 0.5)*/
{64, 0,123,__LINE__, 0x3ff05b1f, 0x9747ee2e, 0x3feccccc, 0xccccccd3, 0x3fe19999, 0x9999999d},	/* 1.02225=f(0.9, 0.55)*/
{64, 0,123,__LINE__, 0x3fef730b, 0xd281f69b, 0x3feccccc, 0xccccccd3, 0x3fe33333, 0x33333337},	/* 0.982794=f(0.9, 0.6)*/
{63, 0,123,__LINE__, 0x3fee3ffd, 0x74897b1a, 0x3feccccc, 0xccccccd3, 0x3fe4cccc, 0xccccccd1},	/* 0.945311=f(0.9, 0.65)*/
{64, 0,123,__LINE__, 0x3fed1cb2, 0xa799b306, 0x3feccccc, 0xccccccd3, 0x3fe66666, 0x6666666b},	/* 0.909753=f(0.9, 0.7)*/
{64, 0,123,__LINE__, 0x3fec08aa, 0xe496efa6, 0x3feccccc, 0xccccccd3, 0x3fe80000, 0x00000005},	/* 0.876058=f(0.9, 0.75)*/
{64, 0,123,__LINE__, 0x3feb034f, 0x38649c88, 0x3feccccc, 0xccccccd3, 0x3fe99999, 0x9999999f},	/* 0.844154=f(0.9, 0.8)*/
{64, 0,123,__LINE__, 0x3fea0bf9, 0xa94cde1c, 0x3feccccc, 0xccccccd3, 0x3feb3333, 0x33333339},	/* 0.813962=f(0.9, 0.85)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3feccccc, 0xccccccd3, 0x3feccccc, 0xccccccd3},	/* 0.785398=f(0.9, 0.9)*/
{64, 0,123,__LINE__, 0x3fe844a1, 0x571188fe, 0x3feccccc, 0xccccccd3, 0x3fee6666, 0x6666666d},	/* 0.758378=f(0.9, 0.95)*/
{64, 0,123,__LINE__, 0x40030dfc, 0xd57ce4cc, 0x3fee6666, 0x6666666d, 0xbff00000, 0x00000000},	/* 2.38183=f(0.95, -1)*/
{64, 0,123,__LINE__, 0x4002d97c, 0x7f3321d1, 0x3fee6666, 0x6666666d, 0xbfee6666, 0x66666666},	/* 2.35619=f(0.95, -0.95)*/
{64, 0,123,__LINE__, 0x4002a225, 0xffe678cb, 0x3fee6666, 0x6666666d, 0xbfeccccc, 0xcccccccc},	/* 2.32917=f(0.95, -0.9)*/
{64, 0,123,__LINE__, 0x400267d3, 0x4beb12fe, 0x3fee6666, 0x6666666d, 0xbfeb3333, 0x33333332},	/* 2.3007=f(0.95, -0.85)*/
{63, 0,123,__LINE__, 0x40022a5f, 0x18f3451d, 0x3fee6666, 0x6666666d, 0xbfe99999, 0x99999998},	/* 2.27069=f(0.95, -0.8)*/
{64, 0,123,__LINE__, 0x4001e9a5, 0xc99335af, 0x3fee6666, 0x6666666d, 0xbfe7ffff, 0xfffffffe},	/* 2.23909=f(0.95, -0.75)*/
{64, 0,123,__LINE__, 0x4001a586, 0x8fc6c8cf, 0x3fee6666, 0x6666666d, 0xbfe66666, 0x66666664},	/* 2.20582=f(0.95, -0.7)*/
{64, 0,123,__LINE__, 0x40015de4, 0xca763c21, 0x3fee6666, 0x6666666d, 0xbfe4cccc, 0xccccccca},	/* 2.17085=f(0.95, -0.65)*/
{63, 0,123,__LINE__, 0x400112a9, 0x9ee56457, 0x3fee6666, 0x6666666d, 0xbfe33333, 0x33333330},	/* 2.13411=f(0.95, -0.6)*/
{64, 0,123,__LINE__, 0x4000c3c5, 0xca449e50, 0x3fee6666, 0x6666666d, 0xbfe19999, 0x99999996},	/* 2.09559=f(0.95, -0.55)*/
{64, 0,123,__LINE__, 0x40007133, 0xa108dee2, 0x3fee6666, 0x6666666d, 0xbfdfffff, 0xfffffff9},	/* 2.05527=f(0.95, -0.5)*/
{63, 0,123,__LINE__, 0x40001af9, 0x294450f9, 0x3fee6666, 0x6666666d, 0xbfdccccc, 0xccccccc6},	/* 2.01317=f(0.95, -0.45)*/
{63, 0,123,__LINE__, 0x3fff8254, 0x66b1ec6a, 0x3fee6666, 0x6666666d, 0xbfd99999, 0x99999993},	/* 1.96932=f(0.95, -0.4)*/
{64, 0,123,__LINE__, 0x3ffec7d4, 0x93fc7aa7, 0x3fee6666, 0x6666666d, 0xbfd66666, 0x66666660},	/* 1.92379=f(0.95, -0.35)*/
{64, 0,123,__LINE__, 0x3ffe06dc, 0x9297b73e, 0x3fee6666, 0x6666666d, 0xbfd33333, 0x3333332d},	/* 1.87668=f(0.95, -0.3)*/
{63, 0,123,__LINE__, 0x3ffd3ffa, 0xcd08c0c0, 0x3fee6666, 0x6666666d, 0xbfcfffff, 0xfffffff4},	/* 1.82812=f(0.95, -0.25)*/
{64, 0,123,__LINE__, 0x3ffc73e2, 0xe46d7f71, 0x3fee6666, 0x6666666d, 0xbfc99999, 0x9999998e},	/* 1.77829=f(0.95, -0.2)*/
{64, 0,123,__LINE__, 0x3ffba36c, 0x4c864173, 0x3fee6666, 0x6666666d, 0xbfc33333, 0x33333328},	/* 1.7274=f(0.95, -0.15)*/
{63, 0,123,__LINE__, 0x3ffacf8e, 0xc523642e, 0x3fee6666, 0x6666666d, 0xbfb99999, 0x99999983},	/* 1.67567=f(0.95, -0.1)*/
{64, 0,123,__LINE__, 0x3ff9f95c, 0xaa6341c4, 0x3fee6666, 0x6666666d, 0xbfa99999, 0x9999996c},	/* 1.62338=f(0.95, -0.05)*/
{64, 0,123,__LINE__, 0x3ff921fb, 0x54442d17, 0x3fee6666, 0x6666666d, 0x3cb70000, 0x00000000},	/* 1.5708=f(0.95, 3.19189e-16)*/
{64, 0,123,__LINE__, 0x3ff84a99, 0xfe25186a, 0x3fee6666, 0x6666666d, 0x3fa99999, 0x999999c8},	/* 1.51821=f(0.95, 0.05)*/
{64, 0,123,__LINE__, 0x3ff77467, 0xe364f5ff, 0x3fee6666, 0x6666666d, 0x3fb99999, 0x999999b1},	/* 1.46592=f(0.95, 0.1)*/
{64, 0,123,__LINE__, 0x3ff6a08a, 0x5c0218bb, 0x3fee6666, 0x6666666d, 0x3fc33333, 0x3333333f},	/* 1.41419=f(0.95, 0.15)*/
{64, 0,123,__LINE__, 0x3ff5d013, 0xc41adabd, 0x3fee6666, 0x6666666d, 0x3fc99999, 0x999999a6},	/* 1.3633=f(0.95, 0.2)*/
{64, 0,123,__LINE__, 0x3ff503fb, 0xdb7f996d, 0x3fee6666, 0x6666666d, 0x3fd00000, 0x00000006},	/* 1.31347=f(0.95, 0.25)*/
{64, 0,123,__LINE__, 0x3ff43d1a, 0x15f0a2f0, 0x3fee6666, 0x6666666d, 0x3fd33333, 0x33333339},	/* 1.26492=f(0.95, 0.3)*/
{64, 0,123,__LINE__, 0x3ff37c22, 0x148bdf87, 0x3fee6666, 0x6666666d, 0x3fd66666, 0x6666666c},	/* 1.21781=f(0.95, 0.35)*/
{64, 0,123,__LINE__, 0x3ff2c1a2, 0x41d66dc3, 0x3fee6666, 0x6666666d, 0x3fd99999, 0x9999999f},	/* 1.17227=f(0.95, 0.4)*/
{63, 0,123,__LINE__, 0x3ff20e04, 0x55ffb83b, 0x3fee6666, 0x6666666d, 0x3fdccccc, 0xccccccd2},	/* 1.12842=f(0.95, 0.45)*/
{64, 0,123,__LINE__, 0x3ff1618f, 0x66769c69, 0x3fee6666, 0x6666666d, 0x3fe00000, 0x00000003},	/* 1.08632=f(0.95, 0.5)*/
{64, 0,123,__LINE__, 0x3ff0bc6b, 0x13ff1d8d, 0x3fee6666, 0x6666666d, 0x3fe19999, 0x9999999d},	/* 1.046=f(0.95, 0.55)*/
{64, 0,123,__LINE__, 0x3ff01ea3, 0x6abd9180, 0x3fee6666, 0x6666666d, 0x3fe33333, 0x33333337},	/* 1.00748=f(0.95, 0.6)*/
{64, 0,123,__LINE__, 0x3fef105a, 0x2737c3d9, 0x3fee6666, 0x6666666d, 0x3fe4cccc, 0xccccccd1},	/* 0.970746=f(0.95, 0.65)*/
{64, 0,123,__LINE__, 0x3fedf1d3, 0x11f59121, 0x3fee6666, 0x6666666d, 0x3fe66666, 0x6666666b},	/* 0.93577=f(0.95, 0.7)*/
{63, 0,123,__LINE__, 0x3fece156, 0x2ac3dda2, 0x3fee6666, 0x6666666d, 0x3fe80000, 0x00000005},	/* 0.902507=f(0.95, 0.75)*/
{64, 0,123,__LINE__, 0x3febde70, 0xed439fe7, 0x3fee6666, 0x6666666d, 0x3fe99999, 0x9999999f},	/* 0.870903=f(0.95, 0.8)*/
{64, 0,123,__LINE__, 0x3feae8a0, 0x21646864, 0x3fee6666, 0x6666666d, 0x3feb3333, 0x33333339},	/* 0.840897=f(0.95, 0.85)*/
{64, 0,123,__LINE__, 0x3fe9ff55, 0x5176d133, 0x3fee6666, 0x6666666d, 0x3feccccc, 0xccccccd3},	/* 0.812419=f(0.95, 0.9)*/
{64, 0,123,__LINE__, 0x3fe921fb, 0x54442d18, 0x3fee6666, 0x6666666d, 0x3fee6666, 0x6666666d},	/* 0.785398=f(0.95, 0.95)*/
{0}
};
void test_atan2(m)   {run_vector_1(m,atan2_vec,(char *)(atan2),"atan2","ddd");   }	
