# ***** BEGIN LICENSE BLOCK *****
# Version: RCSL 1.0/RPSL 1.0/GPL 2.0
#
# Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved.
# Portions Copyright (c) 2006 Lukas Lalinsky. All Rights Reserved.
#
# The contents of this file, and the files included with this file, are
# subject to the current version of the RealNetworks Public Source License
# Version 1.0 (the "RPSL") available at
# http://www.helixcommunity.org/content/rpsl unless you have licensed
# the file under the RealNetworks Community Source License Version 1.0
# (the "RCSL") available at http://www.helixcommunity.org/content/rcsl,
# in which case the RCSL will apply. You may also obtain the license terms
# directly from RealNetworks.  You may not use this file except in
# compliance with the RPSL or, if you have a valid RCSL with RealNetworks
# applicable to this file, the RCSL.  Please see the applicable RPSL or
# RCSL for the rights, obligations and limitations governing use of the
# contents of the file.
#
# This file is part of the Helix DNA Technology. RealNetworks is the
# developer of the Original Code and owns the copyrights in the portions
# it created.
#
# This file, and the files included with this file, is distributed and made
# available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
# EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS ALL SUCH WARRANTIES,
# INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
#
# Technology Compatibility Kit Test Suite(s) Location:
#    http://www.helixcommunity.org/content/tck
#
# --------------------------------------------------------------------
#
# picard is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# picard is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with picard; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
#
# Contributor(s):
#   Lukas Lalinsky
#
#
# ***** END LICENSE BLOCK *****

import wx
import sys
import images
from picard.browser import launch

class NagDialog(wx.Dialog):

    def __init__(self, parent):
        
        wx.Dialog.__init__(self, parent, -1, _("Please donate to MusicBrainz!"),
            style = wx.DEFAULT_DIALOG_STYLE)

        
        
        t = _("The Picard Tagger is a free application and you may\n"
              "use it as long as you wish. However, providing\n"
              "the MusicBrainz service does cost money and we rely\n"
              "on donations from the community to keep the service\n"
              "running. Please donate $10 to the MetaBrainz Foundation\n"
              "which operates the MusicBrainz project. All donations\n"
              "are tax deductible for US residents and will keep this\n"
              "service alive and moving forward.")

        staticText = wx.StaticText(self, -1, t, style=wx.ALIGN_CENTER_HORIZONTAL)
        font = staticText.GetFont()
        font.SetWeight(wx.BOLD)
        staticText.SetFont(font)         
        
        donateButton = wx.Button(self, -1, _("Donate"))
        donateButton.SetDefault()
        laterButton = wx.Button(self, -1, _("Later"))
        
        self.Bind(wx.EVT_BUTTON, self.OnDonate, donateButton)
        self.Bind(wx.EVT_BUTTON, self.OnLater, laterButton)
        
        buttonBox = wx.BoxSizer(wx.HORIZONTAL)
        buttonBox.Add(laterButton, 0, wx.ALL, 5)
        buttonBox.Add(donateButton, 0, wx.ALL, 5)
        
        vbox = wx.BoxSizer(wx.VERTICAL)
        vbox.Add(wx.StaticBitmap(self, -1, images.getBannerBitmap()), 0, wx.LEFT | wx.RIGHT | wx.TOP, 4)
        vbox.Add(staticText, 1, wx.EXPAND | wx.LEFT | wx.RIGHT | wx.TOP, 12)
        vbox.Add(buttonBox, 0, wx.ALIGN_CENTER | wx.ALL, 8)

        self.SetSizer(vbox)
        self.Fit()

    def OnLater(self, event):
        self.EndModal(0)
    
    def OnDonate(self, event):
        l = launch.Launch(None)
        l.launch('http://metabrainz.org/donate/')
        self.EndModal(1)

