<?php
// configuration file
// $Id: config.inc,v 1.5 2002/06/21 13:46:34 blorson Exp $
//
pql_set_define("PQL_CONF_HOST","ldapi://%2fvar%2frun%2fldapi;;ou=QmailLDAP,dc=bayour,dc=com+aurora.bayour.com;389;ou=QmailLDAP,o=Bayour.COM,c=SE+ldap://alfred.swe.net;389;ou=QmailLDAP,o=Swe.Net AB,c=SE");

pql_set_define("PQL_CONF_SUBTREE_USERS", "ou=People");
pql_set_define("PQL_CONF_SUBTREE_GROUPS", "ou=Groups");
pql_set_define("PQL_CONF_EZMLM_USER", "alias");

function user_generate_mailstore($ldap, $email, $dn, $entry, $type) {
	if($dn) {
		$mailstore = pql_domain_get_value($ldap, $dn, "basemaildir");
		$domain    = pql_domain_get_value($ldap, $dn, "defaultdomain");
	} else {
		$mailstore = "/var/mail";
		$domain    = $entry[BRANCH_NAME];
	}
	
    if($type == 'branch')
      // We're creating a branch, so add the domain to string
      $branch = '%d%/';

	if(! ereg("/$", $mailstore)) {
		$mailstore = $mailstore . "/" . $branch . "%u%";
	} else {
		$mailstore = $mailstore . $branch . "%u%";
	}

	$mailstore = pql_complete_constant($mailstore, array("d" => $domain, 
														 "u" => pql_format_international(pql_maybe_decode($entry[pql_get_define("PQL_ATTR_UID")])),
														 "h" => $entry[pql_get_define("PQL_ATTR_MAILHOST")]));
	return($mailstore);
}

function user_generate_homedir($ldap, $email, $dn, $entry, $type) {
	if($dn) {
		$homedir = pql_domain_get_value($ldap, $dn, "basehomedir");
		$domain  = pql_domain_get_value($ldap, $dn, "defaultdomain");
	} else {
		$homedir = "/home";
		$domain  = $entry[BRANCH_NAME];
	}
	
    if($type == 'branch')
      // We're creating a branch, so add the domain to string
      $branch = '%d%/';

	if(! ereg("/$", $homedir)) {
		$homedir = $homedir . "/" . $branch . "%u%";
	} else {
		$homedir = $homedir . $branch . "%u%";
	}
	
	$homedir = pql_complete_constant($homedir, array("d" => $domain, 
													 "u" => $entry[pql_get_define("PQL_ATTR_UID")], 
													 "h" => $entry[pql_get_define("PQL_ATTR_MAILHOST")]));
	return($homedir);
}

function user_generate_uid($ldap, $surname, $name, $email, $domain, $account_type) {
	return(pql_get_next_username($ldap, $domain));		// Use prefix from branch to generate UID.
}

function user_generate_email($ldap_linkid, $surname, $lastname, $domainname, $domain, $account_type) {
	// Compose the username with first+last name with dot in between.
	if(!empty($surname))
	  $mail = $surname;
	if(!empty($lastname))
	  $mail .= ".$lastname";
	if(!empty($domainname))
	  $mail .= "@$domainname";

	return(lc($mail));
}

// ----------------------------
function user_generate_aci($ldap_linkid, $user, $type) {
	$i = 0;

	// Public entries
	$aci[$i] = "$i#entry#grant;r,s,c;objectClass,[entry]#public#"; $i++;
	
	// Non-public entries
	if($type == 'user') {
		$aci[$i] = "$i#entry#grant;x;userPassword,krb5PrincipalName#public#"; $i++;
		$aci[$i] = "$i#entry#grant;x;cn,mail,mailAlternateAddress#public#"; $i++;
		$aci[$i] = "$i#entry#grant;s;userPassword,krb5PrincipalName,cn,mail,mailAlternateAddress#access-id#uid=proxy,ou=System,o=Bayour.COM,c=SE"; $i++;
		$aci[$i] = "$i#entry#grant;r,s,c;uid,cn,accountStatus,uidNumber,gidNumber,gecos,homeDirectory,loginShell,trustModel,accessTo,mailMessageStore#public#"; $i++;
		$aci[$i] = "$i#entry#grant;r,s,c;mail,mailAlternateAddress,mailHost,mailQuotaSize,mailQuotaCount,accountStatus,deliveryMode,userPassword,mailMessageStore,deliveryProgramPath#access-id#uid=qmail,ou=System,o=Bayour.COM,c=SE"; $i++;
		$aci[$i] = "$i#entry#grant;r,s,c;sn,givenName,homePostalAddress,mobile,homePhone,labeledURI,mailForwardingAddress,street,physicalDeliveryOfficeName,mailMessageStore,o,l,st,telephoneNumber,postalCode,title#users#"; $i++;
		$aci[$i] = "$i#entry#grant;w,r,s,c;sn,givenName,homePostalAddress,mobile,homePhone,labeledURI,mailForwardingAddress,street,physicalDeliveryOfficeName,o,l,st,telephoneNumber,postalCode,title,deliveryMode,userPassword#self#"; $i++;
		$aci[$i] = "$i#entry#grant;w,r,s,c,x;[all]#access-id#$user"; $i++;
	} elseif($type == 'group') {
		$aci[$i] = "$i#entry#grant;r,s,c;cn,gidNumber#public#"; $i++;
	} elseif($type == 'branch') {
		if(pql_get_define("PQL_CONF_REFERENCE_DOMAINS_WITH", $_REQUEST["rootdn"]) == "o") {
			$aci[$i] = "$i#entry#grant;r,s,c;o#public#"; $i++;
		} else {
			$aci[$i] = "$i#entry#grant;r,s,c;dc#public#"; $i++;
		}

		$aci[$i] = "$i#entry#grant;w,r,s,c,x;[all]#access-id#$user"; $i++;
	} elseif($type == 'qmail') {
		$aci[$i] = "$i#entry#grant;r,s;[all]#access-id#ENTER_WHOEVER_YOUR_QMAILSERVER_USES"; $i++;
	}

	// Non-public entries
	$aci[$i] = "$i#entry#grant;w,r,s,c;[children]#access-id#$user"; $i++;
	$aci[$i] = "$i#entry#grant;w,r,s,c,x;[all]#access-id#$user"; $i++;

	return($aci);
}

function do_exec($command, $output, &$return) {
	return(@exec($command, $output, $return));

	$return = 100;
	return(false);
}

/*
 * Local variables:
 * mode: php
 * tab-width: 4
 * End:
 */
?>
