/*
 * Decompiled with CFR 0.152.
 */
package de.mud.jta.plugin;

import de.mud.jta.FilterPlugin;
import de.mud.jta.Plugin;
import de.mud.jta.PluginBus;
import de.mud.jta.PluginConfig;
import de.mud.jta.event.ConfigurationListener;
import de.mud.jta.event.EndOfRecordRequest;
import de.mud.jta.event.LocalEchoRequest;
import de.mud.jta.event.OnlineStatusListener;
import de.mud.jta.event.TelnetCommandListener;
import de.mud.jta.event.TerminalTypeRequest;
import de.mud.jta.event.WindowSizeRequest;
import de.mud.telnet.TelnetProtocolHandler;
import java.awt.Dimension;
import java.io.IOException;

public class Telnet
extends Plugin
implements FilterPlugin {
    protected FilterPlugin source;
    protected TelnetProtocolHandler handler;
    private static final int debug = 0;

    public Telnet(final PluginBus bus, String id) {
        super(bus, id);
        this.handler = new TelnetProtocolHandler(){

            public String getTerminalType() {
                return (String)bus.broadcast(new TerminalTypeRequest());
            }

            public Dimension getWindowSize() {
                return (Dimension)bus.broadcast(new WindowSizeRequest());
            }

            public void setLocalEcho(boolean echo) {
                bus.broadcast(new LocalEchoRequest(echo));
            }

            public void notifyEndOfRecord() {
                bus.broadcast(new EndOfRecordRequest());
            }

            public void write(byte[] b) throws IOException {
                Telnet.this.source.write(b);
            }
        };
        bus.registerPluginListener(new OnlineStatusListener(){

            public void online() {
                Telnet.this.handler.reset();
                try {
                    Telnet.this.handler.startup();
                }
                catch (IOException e) {
                    // empty catch block
                }
                bus.broadcast(new LocalEchoRequest(true));
            }

            public void offline() {
                Telnet.this.handler.reset();
                bus.broadcast(new LocalEchoRequest(true));
            }
        });
        bus.registerPluginListener(new ConfigurationListener(){

            public void setConfiguration(PluginConfig config) {
                Telnet.this.configure(config);
            }
        });
        bus.registerPluginListener(new TelnetCommandListener(){

            public void sendTelnetCommand(byte command) throws IOException {
                Telnet.this.handler.sendTelnetControl(command);
            }
        });
    }

    public void configure(PluginConfig cfg) {
        String cr;
        String crlf = cfg.getProperty("Telnet", this.id, "crlf");
        if (crlf != null) {
            this.handler.setCRLF(crlf);
        }
        if ((cr = cfg.getProperty("Telnet", this.id, "cr")) != null) {
            this.handler.setCR(cr);
        }
    }

    public void setFilterSource(FilterPlugin source) {
        this.source = source;
    }

    public FilterPlugin getFilterSource() {
        return this.source;
    }

    public int read(byte[] b) throws IOException {
        int n;
        do {
            if ((n = this.handler.negotiate(b)) <= 0) continue;
            return n;
        } while (n == 0);
        n = this.source.read(b);
        if (n <= 0) {
            return n;
        }
        this.handler.inputfeed(b, n);
        n = 0;
        do {
            if ((n = this.handler.negotiate(b)) <= 0) continue;
            return n;
        } while (n != -1);
        return 0;
    }

    public void write(byte[] b) throws IOException {
        this.handler.transpose(b);
    }
}

