<?php
  /**************************************************************************\
  * phpGroupWare module (File Manager)                                       *
  * http://www.phpgroupware.org                                              *
  * Written by Dan Kuykendall <dan@kuykendall.org>                           *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

#    filemanager by Lacey Pevey
#    v0.02 - 1999/12/05 13:46 CST
#
#    You are free to use and distribute this code provided this tiny
#    header is included. No warranties, fitness for purpose, etc. etc.
#
#    Please send comments/bugfixes/enhancements to
#    lpevey@mailhost.tcs.tulane.edu.

	/* $Id: index.php,v 1.34.2.1 2002/01/15 20:51:55 seek3r Exp $ */

	$GLOBALS['phpgw_info']['flags'] = array(
		'currentapp'           => 'filemanager',
		'enable_browser_class' => True,
		'noheader'             => True
	);
	include('../header.inc.php');

	/* Use app vfs class */
	$GLOBALS['phpgw']->vfs = CreateObject('filemanager.vfs');

	$action    = $GLOBALS['HTTP_POST_VARS']['action'];
	$download  = $GLOBALS['HTTP_POST_VARS']['download'];
	$actiondir = $GLOBALS['HTTP_POST_VARS']['actiondir'];
	$pwd       = $GLOBALS['HTTP_POST_VARS']['pwd'];
	$fn        = $GLOBALS['HTTP_POST_VARS']['fn'];
	$exit      = $GLOBALS['HTTP_POST_VARS']['exit'];
	$edit      = $GLOBALS['HTTP_POST_VARS']['edit'];
	$save      = $GLOBALS['HTTP_POST_VARS']['save'];
	$copy      = $GLOBALS['HTTP_POST_VARS']['copy'];
	$rename    = $GLOBALS['HTTP_POST_VARS']['rename'];
	$newfile   = $GLOBALS['HTTP_POST_VARS']['newfile'];
	$newname   = $GLOBALS['HTTP_POST_VARS']['newname'];
	$oldname   = $GLOBALS['HTTP_POST_VARS']['oldname'];
	$delete    = $GLOBALS['HTTP_POST_VARS']['delete'];
	$upload    = $GLOBALS['HTTP_POST_VARS']['upload'];
	$contents  = $GLOBALS['HTTP_POST_VARS']['contents'];

	/* Converted to use browser class for content header 16/05/2001 */
	if ($download)
	{
		$GLOBALS['phpgw']->browser->content_header($fn);
		echo $GLOBALS['phpgw']->vfs->read($actiondir.$pwd.$fn);
		$GLOBALS['phpgw']->common->phpgw_exit();
	}
	else
	{
		$GLOBALS['phpgw']->common->phpgw_header();
	}

	if (!empty($exit))
	{
		unset($edit);
		unset($upload);
	}
	$GLOBALS['phpgw']->vfs->verifydir();

	if (empty($currentdir))
	{
		$GLOBALS['phpgw']->vfs->cd('/');
	}
	else
	{
		$GLOBALS['phpgw']->vfs->cd($currentdir);
	}

	if (empty($pwd))
	{
		$pwd = '/';
	}
	/* echo "<BR>first actiondir:" . $actiondir . "<BR>"; */
	if (empty($actiondir))
	{
		$actiondir = $currentdir;
	}
	/* echo "second actiondir:" . $actiondir . "<BR>"; */

	if ($action == 'upload')
	{
		$GLOBALS['phpgw']->vfs->mv($userfile,"$actiondir$pwd$userfile_name",True);
	}

	$file = "$actiondir$pwd$fn";

//-------------------------------------------------------------------------------------------------
	if ($copy)
	{
		if ($action == 'copy')
		{
			$GLOBALS['phpgw']->vfs->cp($actiondir.$oldname,$actiondir.'/'.$newname);
		}
		else
		{
?>
    <table align="center" bgcolor="<?php echo $GLOBALS['phpgw_info']['theme']['table_bg']; ?>" border="2" cellspacing="0" cellpadding="3">
      <tr>
        <td>
          <form name="copy" method="post" action="<?php echo $GLOBALS['phpgw']->link('/filemanager/index.php');?>">
            <input type="hidden" name="oldname"   value="<?php echo $pwd.$fn; ?>">
            <input type="hidden" name="action"    value="copy">
            <input type="hidden" name="pwd"       value="<?php echo $pwd; ?>">
            <input type="hidden" name="actiondir" value="<?php echo "$actiondir"; ?>">
            <font  face="Verdana"><small><?php echo lang('Clipboard Contents: x', $fn); ?></small></font><br>
            <input type="submit" name="copy"      value="<?php echo lang('copy_as') ?>">
            <input type="text"   name="newname"   size="56" value="<?php echo $fn; ?>"><br>
            <input type="submit" name="exit"      value="Cancel">
          </form>
        </td>
      </tr>
    </table>
    <br><br>
<?php
		}
	}
//-------------------------------------------------------------------------------------------------
	if ($rename)
	{
		if ($action == 'rename')
		{
			$GLOBALS['phpgw']->vfs->mv("$actiondir$oldname","$actiondir$pwd$newname");
		}
		else
		{
?>
    <table align="center" bgcolor="<?php echo $GLOBALS['phpgw_info']['theme']['table_bg']; ?>" border="2" cellspacing="0" cellpadding="3">
      <tr>
        <td>
          <form name="move" method="post" action="<?php echo $GLOBALS['phpgw']->link('/filemanager/index.php');?>">
            <input type="hidden" name="pwd"       value="<?php echo $pwd; ?>">
            <input type="hidden" name="actiondir" value="<?php echo "$actiondir"; ?>">
            <font  face="Verdana"><small><?php echo lang('Clipboard Contents: x',$fn); ?></small></font><br>
            <input type="submit" name="rename"    value="<?php echo lang('rename_to'); ?>">
            <input type="text"   name="newname" size="56" value="<?php echo $fn; ?>"><br>
            <input type="hidden" name="oldname"   value="<?php echo $pwd.$fn; ?>">
            <input type="hidden" name="action"    value="rename">
            <input type="submit" name="exit"      value="<?php echo lang("cancel"); ?>">
          </form>
        </td>
      </tr>
    </table>
    <br><br>
<?php
		}
	}
//-------------------------------------------------------------------------------------------------
	if ($newfile)
	{
		if (!empty($fn))
		{
			if (!file_exists($file))
			{
				$GLOBALS['phpgw']->vfs->write($file, "");
				$edit = 1;
			}
			else
			{
				echo '<B><blink>File already exist. Please edit the existing file, or choose a different file name.</blink></B>';
			}
		}
		else
		{
			echo 'You must specify a name for the file you wish to create.';
		}
		echo $result;
	}
//-------------------------------------------------------------------------------------------------
	if ($delete)
	{
		if ($action == 'delete')
		{
			$GLOBALS['phpgw']->vfs->rm($file);
		}
		else
		{
?>
    <table align="center" bgcolor="<?php echo $GLOBALS['phpgw_info']['theme']['table_bg']; ?>" border="2" cellspacing="0" cellpadding="3">
      <tr>
        <td>
          <form name="delete" method="post" action="<?php echo $GLOBALS['phpgw']->link('/filemanager/index.php');?>">
            <font face="Verdana"><small><?php echo lang('do_delete x', $fn); ?>?</small></font>
            <input type="submit" name="delete" value="<?php echo lang('yes'); ?>">
            <input type="submit" name="exit"   value="<?php echo lang('no'); ?>">
            <input type="hidden" name="pwd"    value="<?php echo $pwd; ?>">
            <input type="hidden" name="actiondir" value="<?php echo "$actiondir"; ?>">
            <input type="hidden" name="fn"     value="<?php echo $fn; ?>">
            &nbsp;<input type="hidden" name="action" value="delete">
          </form>
        </td>
      </tr>
    </table>
    <br><br>
<?php
		}
	}

//-------------------------------------------------------------------------------------------------
	if (isset($edit))
	{
		if (!(isset($fn)))
		{
			echo 'No filename was specified.';
		}
		else
		{
			if ($save)
			{
				if ((isset($file)) && (isset($contents)))
				{
					$contents = stripslashes($contents);
					$GLOBALS['phpgw']->vfs->write($file, $contents);
				}
				else
				{
					echo 'Error saving file to disk';
				}
			}
?>
    <table bgcolor="<?php echo $GLOBALS['phpgw_info']['theme']['table_bg']; ?>" border="2" cellspacing="0" cellpadding="3" align="center">
      <tr>
        <td><?php echo lang('current file') . ':' . $fn; ?></td>
      </tr>
      <tr>
        <td align="center">
          <form method="post" action="<?php echo $GLOBALS['phpgw']->link('/filemanager/index.php');?>">
            <textarea name="contents" cols="100" rows="25"><?php $contents = $GLOBALS['phpgw']->vfs->read($actiondir."/".$fn); echo $GLOBALS['phpgw']->strip_html($contents); ?></textarea><br>
            <input type="submit" name="save" value="<?php echo lang('save'); ?>">
            <input type="submit" name="exit" value="<?php echo lang('exit'); ?>">
            <input type="hidden" name="pwd"  value="<?php echo $pwd; ?>">
            <input type="hidden" name="actiondir" value="<?php echo "$actiondir"; ?>">
            <input type="hidden" name="fn"   value="<?php echo $fn; ?>">
            <input type="hidden" name="edit" value="<?php echo lang('edit'); ?>">
          </form>
        </td>
      </tr>
    </table></form><br>
<?php
		}
	}
//-------------------------------------------------------------------------------------------------
// Display user files.
?>
<table align="center" bgcolor="<?php echo $GLOBALS['phpgw_info']["theme"]["table_bg"]; ?>" border="2" cellspacing="0" cellpadding="3">
<?php
	$dirs = $GLOBALS['phpgw']->vfs->ls();
	$dir_count = count($dirs);
	for ($diridx=0;$diridx<$dir_count;++$diridx)
	{
		$currentdir = $dirs[$diridx]['name'];
		if ($dirs[$diridx]['type'] == 'dir')
		{
?>
<tr><td align="center">
<?php
			if ($dirs[$diridx]['name'] == 'home')
			{
				if (strtolower(substr($GLOBALS['phpgw_info']['user']['userid'],-1,1)) != 's')
				{
					$apos = "'s";
				}
				else
				{
					$apos = "'";
				}
				echo $GLOBALS['phpgw_info']['user']['userid'] . $apos?> <?php echo lang('private_files');
			}
			else
			{
				echo $dirs[$diridx]['name'].' '.lang('group_files');
			}
?>
  :</td></tr>
  <tr bgcolor="<?php echo $GLOBALS['phpgw_info']["theme"]["row_on"]; ?>">
    <td align="center">
      <form method="post" action="<?php echo $GLOBALS['phpgw']->link('/filemanager/index.php');?>" name="files">
        <font face="Verdana"><small><?php echo lang('files'); ?>:</small></font><br>
        <select name="fn">
<?php
			$files = $GLOBALS['phpgw']->vfs->ls($GLOBALS['phpgw']->vfs->pwd().$dirs[$diridx]['name']);

			if (!empty ($files))
			{
				$file_count = count($files);
				for ($fileidx=0;$fileidx<$file_count;++$fileidx)
				{
					if ($files[$fileidx]['type'] == 'file')
					{
						echo '<option value="'.$files[$fileidx]['name'].'">'.$files[$fileidx]['name']."\n";
					}
				}
			}
?>
        </select>
        <input type="hidden" name="pwd"       value="<?php echo $pwd; ?>">
        <input type="hidden" name="actiondir" value="<?php echo $GLOBALS['phpgw']->vfs->pwd().$dirs[$diridx]['name']; ?>">
        <BR>
        <input type="submit" name="edit"      value="<?php echo lang('edit'); ?>">
        <input type="submit" name="copy"      value="<?php echo lang('copy'); ?>">
        <input type="submit" name="delete"    value="<?php echo lang('delete'); ?>">
        <input type="submit" name="rename"    value="<?php echo lang('rename'); ?>">
        <input type="submit" name="download"  value="<?php echo lang('download'); ?>">
      </form>
    </td>
    <td>
      <form method="post" action="<?php echo $GLOBALS['phpgw']->link('/filemanager/index.php');?>" name="newfile">
        <input type="hidden" name="pwd"       value="<?php echo $pwd; ?>">
        <input type="hidden" name="actiondir" value="<?php echo $GLOBALS['phpgw']->vfs->pwd().$dirs[$diridx]['name']; ?>">
        <font  face="Verdana"><small><?php echo lang('new_file') . ':'; ?></small></font><br>
        <input type="text"   name="fn" size="20" maxlength="100">
        <input type="submit" name="newfile"   value="<?php echo lang('create'); ?>">
      </form>
    </td>
      <td>
      <form method="post" enctype="multipart/form-data" action="<?php echo $GLOBALS['phpgw']->link('/filemanager/index.php');?>">
        <font  face="Verdana"><small><?php echo lang('file_upload') . ":"; ?></small></font><br>
        <input type="hidden" name="pwd"       value="<?php echo $pwd; ?>">
        <input type="hidden" name="actiondir" value="<?php echo $GLOBALS['phpgw']->vfs->pwd().$dirs[$diridx]['name']; ?>">
        <input type="hidden" name="action"    value="upload">
        <input type="file"   name="userfile"  size="40">
        <input type="submit" name="upload"    value="<?php echo lang('Upload'); ?>">
      </form>
    </td>
  </tr>
<?php
		}//end the if
	}
//}

//-------------------------------------------------------------------------------------------------
// Close table.
?>
</table>
<br>
<br>
<?php
	$GLOBALS['phpgw']->common->phpgw_footer();
?>
