<?php
/**
*
* common [Dutch]
*
* @package language
* @copyright (c) 2005 phpBB Group, 2007 phpBBservice.nl
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » “ ” …
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> 'Vertaald door <a href="http://www.phpBBservice.nl/">phpBBservice.nl</a>.',
	'DIRECTION'			=> 'ltr',
	'DATE_FORMAT'		=> '|d M Y|',	// 01 Jan 2007 (with Relative days enabled)
	'USER_LANG'			=> 'nl-x-formal',  

	'1_DAY'			=> '1 dag',
	'1_MONTH'		=> '1 maand',
	'1_YEAR'		=> '1 jaar',
	'2_WEEKS'		=> '2 weken',
	'3_MONTHS'		=> '3 maanden',
	'6_MONTHS'		=> '6 maanden',
	'7_DAYS'		=> '7 dagen',

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'Uw account is al geactiveerd.',
	'ACCOUNT_DEACTIVATED'			=> 'Uw account is handmatig gedeactiveerd en kan alleen door een beheerder weer worden geactiveerd.',
	'ACCOUNT_NOT_ACTIVATED'			=> 'Uw account is nog niet geactiveerd.',
	'ACP'							=> 'Beheerderspaneel',
	'ACTIVE'						=> 'actief',
	'ACTIVE_ERROR'					=> 'De opgegeven gebruikersnaam is momenteel inactief. Als u problemen heeft met het activeren van uw account, neem dan contact op met de beheerder van dit forum.',
	'ADMINISTRATOR'					=> 'Beheerder',
	'ADMINISTRATORS'				=> 'Beheerders',
	'AGE'							=> 'Leeftijd',
	'AIM'							=> 'AIM',
	'ALLOWED'						=> 'Toegestaan',
	'ALL_FILES'						=> 'Alle bestanden',
	'ALL_FORUMS'					=> 'Alle forums',
	'ALL_MESSAGES'					=> 'Alle berichten',
	'ALL_POSTS'						=> 'Alle berichten',
	'ALL_TIMES'						=> 'Alle tijden zijn %1$s %2$s',
	'ALL_TOPICS'					=> 'Alle onderwerpen',
	'AND'							=> 'En',
	'ARE_WATCHING_FORUM'			=> 'U bent geabonneerd om e-mailberichten te ontvangen wanneer er nieuwe berichten zijn in dit forum.',
	'ARE_WATCHING_TOPIC'			=> 'U bent geabonneerd om e-mailberichten te ontvangen wanneer er nieuwe berichten zijn in dit onderwerp.',
	'ASCENDING'						=> 'Oplopend',
	'ATTACHMENTS'					=> 'Bijlagen',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'Het afbeeldingsbestand dat u als bijlage probeerde toe te voegen is ongeldig.',
	'AUTHOR'						=> 'Auteur',
	'AUTH_NO_PROFILE_CREATED'		=> 'Het aanmaken van een gebruikersprofiel is niet gelukt.',
	'AVATAR_DISALLOWED_CONTENT'		=> 'Het bestand is geweigerd omdat het geüploade bestand herkend is als een mogelijk veiligheidsprobleem.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'Dit bestand kan niet worden weergegeven omdat de extensie <strong>%s</strong> niet is toegestaan.',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'De opgegeven avatar kan niet geüpload worden, omdat het bestand waarschijnlijk corrupt of ongeldig is.',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'Het geüploade avatar-bestand is leeg.',
	'AVATAR_INVALID_FILENAME'		=> '%s is een ongeldige bestandsnaam.',
	'AVATAR_NOT_UPLOADED'			=> 'Avatar kan niet worden geüpload.',
	'AVATAR_NO_SIZE'				=> 'De breedte en hoogte van de gelinkte avatar kon niet worden vastgesteld. Voer deze handmatig in.',
	'AVATAR_PARTIAL_UPLOAD'			=> 'Het opgegeven bestand is maar gedeeltelijk geüpload.',
	'AVATAR_PHP_SIZE_NA'			=> 'De bestandsgrootte van de avatar is te groot.<br />De maximale toegestaande bestandsgrootte die ingesteld is in php.ini kon niet worden vastgesteld.',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'De bestandsgrootte van de avatar is te groot. De maximale toegestaande bestandsgrootte is %1$d %2$s.<br />Vergeet niet dat dit ingesteld is in php.ini en niet kan worden overschreden.',
	'AVATAR_URL_INVALID'			=> 'De opgegeven URL is ongeldig.',
	'AVATAR_URL_NOT_FOUND'			=> 'Het opgegeven bestand kan niet worden gevonden.',
	'AVATAR_WRONG_FILESIZE'			=> 'De bestandsgrootte van de avatar moet tussen de 0 en %1d %2s zijn.',
	'AVATAR_WRONG_SIZE'				=> 'De opgegeven avatar is %5$d pixels breed en %6$d pixels hoog. Avatars moeten minstens %1$d pixels breed en %2$d pixels hoog zijn, maar mogen niet groter zijn dan %3$d pixels breed en %4$d pixels hoog.',

	'BACK_TO_TOP'			=> 'Omhoog',
	'BACK_TO_PREV'			=> 'Terug naar vorige pagina',
	'BAN_TRIGGERED_BY_EMAIL'=> 'Een verbanning is gegeven op uw e-mailadres.',
	'BAN_TRIGGERED_BY_IP'	=> 'Een verbanning is gegeven op uw IP-adres.',
	'BAN_TRIGGERED_BY_USER'	=> 'Een verbanning is gegeven op uw gebruikersnaam.',
	'BBCODE_GUIDE'			=> 'BBCode handleiding',
	'BCC'					=> 'BCC',
	'BIRTHDAYS'				=> 'Verjaardagen',
	'BOARD_BAN_PERM'		=> 'U bent <strong>permanent</strong> verbannen van dit forum.<br /><br />Neem contact op met de %2$sforumbeheerder%3$s voor meer informatie.',
	'BOARD_BAN_REASON'		=> 'Reden voor verbanning: <strong>%s</strong>',
	'BOARD_BAN_TIME'		=> 'U bent verbannen van dit forum tot <strong>%1$s</strong>.<br /><br />Neem contact op met de %2$sforumbeheerder%3$s voor meer informatie.',
	'BOARD_DISABLE'			=> 'Dit forum is momenteel niet beschikbaar. Onze excuses voor het ongemak.',
	'BOARD_DISABLED'		=> 'Dit forum is momenteel uitgeschakeld.',
	'BOARD_UNAVAILABLE'		=> 'Het forum is tijdelijk niet beschikbaar. Probeer het over een paar minuten opnieuw. Onze excuses voor het ongemak.',
	'BROWSING_FORUM'		=> 'Gebruikers in dit forum: %1$s',
	'BROWSING_FORUM_GUEST'	=> 'Gebruikers in dit forum: %1$s en %2$d gast',
	'BROWSING_FORUM_GUESTS'	=> 'Gebruikers in dit forum: %1$s en %2$d gasten',
	'BYTES'					=> 'Bytes',

	'CANCEL'				=> 'Annuleren',
	'CHANGE'				=> 'Wijzigen',
	'CHANGE_FONT_SIZE'		=> 'Lettergrootte wijzigen',
	'CHANGING_PREFERENCES'	=> 'Bezig met wijzigen van de forumvoorkeuren',
	'CHANGING_PROFILE'		=> 'Bezig met wijzigen van de profielinstellingen',
	'CLICK_VIEW_PRIVMSG'	=> '%sNaar uw Postvak IN gaan%s',
	'COLLAPSE_VIEW'			=> 'Beeld inklappen',
	'CLOSE_WINDOW'			=> 'Venster sluiten',
	'COLOUR_SWATCH'			=> 'Kleurenoverzicht',
	'COMMA_SEPARATOR'		=> ', ',	// Used in pagination of ACP & prosilver, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'Bevestigen',
	'CONFIRM_CODE'			=> 'Bevestigingscode',
	'CONFIRM_CODE_EXPLAIN'	=> 'Voer de code exact in zoals deze wordt weergegeven. Alle letters zijn ongevoelig voor hoofdletters.',
	'CONFIRM_CODE_WRONG'	=> 'De bevestigingscode die u heeft ingevoerd is onjuist',
	'CONFIRM_OPERATION'		=> 'Weet u zeker dat u deze actie wilt uitvoeren?',
	'CONGRATULATIONS'		=> 'Gefeliciteerd',
	'CONNECTION_FAILED'		=> 'Verbinding mislukt.',
	'CONNECTION_SUCCESS'	=> 'Verbinding is succesvol!',
	'COOKIES_DELETED'		=> 'Alle forumcookies zijn succesvol verwijderd.',
	'CURRENT_TIME'			=> 'Het is momenteel %s',

	'DAY'					=> 'Dag',
	'DAYS'					=> 'Dagen',
	'DELETE'				=> 'Verwijderen',
	'DELETE_ALL'			=> 'Alles verwijderen',
	'DELETE_COOKIES'		=> 'Alle forumcookies verwijderen',
	'DELETE_MARKED'			=> 'Gemarkeerde verwijderen',
	'DELETE_POST'			=> 'Verwijder bericht',
	'DELIMITER'				=> 'Scheiding',
	'DESCENDING'			=> 'Aflopend',
	'DISABLED'				=> 'Uitgeschakeld',
	'DISPLAY'				=> 'Weergeven',
	'DISPLAY_GUESTS'		=> 'Gasten weergeven',
	'DISPLAY_MESSAGES'		=> 'Berichten weergeven van de afgelopen',
	'DISPLAY_POSTS'			=> 'Berichten weergeven van de afgelopen',
	'DISPLAY_TOPICS'		=> 'Onderwerpen weergeven van de afgelopen',
	'DOWNLOADED'			=> 'Gedownload',
	'DOWNLOADING_FILE'		=> 'Bezig met downloaden van een bestand',
	'DOWNLOAD_COUNT'		=> '%d keer gedownload',
	'DOWNLOAD_COUNTS'		=> '%d keer gedownload',
	'DOWNLOAD_COUNT_NONE'	=> 'Nog niet gedownload',
	'VIEWED_COUNT'			=> '%d keer bekeken',
	'VIEWED_COUNTS'			=> '%d keer bekeken',
	'VIEWED_COUNT_NONE'		=> 'Nog niet bekeken',

	'EDIT_POST'							=> 'Bericht wijzigen',
	'EMAIL'								=> 'E-mail', // Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'E-mailadres',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'Met het versturen van het e-mailbericht zijn er fouten opgetreden <strong>regel %1$s</strong>. Reactie: %2$s.',
	'EMPTY_SUBJECT'						=> 'U moet een onderwerptitel invoeren voordat u een nieuw onderwerp kunt plaatsen.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'U moet een onderwerptitel invoeren voordat u een nieuw bericht kunt plaatsen.',
	'ENABLED'							=> 'Ingeschakeld',
	'ENCLOSURE'							=> 'Bijsluiten',
	'ENTER_USERNAME'					=> 'Voer gebruikersnaam in',
	'ERR_CHANGING_DIRECTORY'			=> 'Kon de directory niet wijzigen.',
	'ERR_CONNECTING_SERVER'				=> 'Er is een fout opgetreden bij het maken van een verbinding met de server.',
	'ERR_JAB_AUTH'						=> 'Kon niet aanmelden op de Jabber-server.',
	'ERR_JAB_CONNECT'					=> 'Kon geen verbinding maken met de Jabber-server.',
	'ERR_UNABLE_TO_LOGIN'				=> 'De opgegeven gebruikersnaam of wachtwoord is onjuist.',
	'ERR_UNWATCHING'					=> 'Er is een fout opgetreden terwijl u het abonnement aan het stopzetten was.',
	'ERR_WATCHING'						=> 'Er is een fout opgetreden terwijl u aan het abonneren was.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'Het opgegeven pad voor phpBB blijkt ongeldig te zijn.',
	'EXPAND_VIEW'						=> 'Beeld uitklappen',
	'EXTENSION'							=> 'Extensie',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'De extensie <strong>%s</strong> is gedeactiveerd en kan niet langer worden weergeven.',

	'FAQ'					=> 'FAQ',
	'FAQ_EXPLAIN'			=> 'Meest gestelde vragen',
	'FILENAME'				=> 'Bestandsnaam',
	'FILESIZE'				=> 'Bestandsgrootte',
	'FILEDATE'				=> 'Bestandsdatum',
	'FILE_COMMENT'			=> 'Bestandsbeschrijving',
	'FILE_NOT_FOUND'		=> 'Het opgevraagde bestand kon niet worden gevonden.',
	'FIND_USERNAME'			=> 'Een gebruiker zoeken',
	'FOLDER'				=> 'Map',
	'FORGOT_PASS'			=> 'Ik ben mijn wachtwoord vergeten',
	'FORM_INVALID'			=> 'Het verstuurde formulier was ongeldig. Probeer het opnieuw te versturen.',
	'FORUM'					=> 'Forum',
	'FORUMS'				=> 'Forums',
	'FORUMS_MARKED'			=> 'Forums zijn als gelezen gemarkeerd.',
	'FORUM_CAT'				=> 'Forumcategorie',
	'FORUM_INDEX'			=> 'Forumindex',
	'FORUM_LINK'			=> 'Forumlink',
	'FORUM_LOCATION'		=> 'Forumlocatie',
	'FORUM_LOCKED'			=> 'Forum gesloten',
	'FORUM_RULES'			=> 'Forumregels',
	'FORUM_RULES_LINK'		=> 'Klik hier om de forumregels te bekijken',
	'FROM'					=> 'van',
	'FSOCK_DISABLED'		=> 'De actie kon niet worden uitgevoerd, omdat de <code>fsockopen</code>-functie is uitgeschakeld of dat de opgevraagde server niet kon worden gevonden.',
	'FSOCK_TIMEOUT'			=> 'Een tijdsonderbreking heeft zich voorgedaan tijdens het lezen van de netwerk-stream.',

	'FTP_FSOCK_HOST'				=> 'FTP-host',
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'FTP-server die gebruikt wordt om verbinding te maken met uw site.',
	'FTP_FSOCK_PASSWORD'			=> 'FTP-wachtwoord',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'Wachtwoord van uw FTP-gebruikersnaam.',
	'FTP_FSOCK_PORT'				=> 'FTP-poort',
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'Poort die gebruikt wordt om verbinding te maken met uw server.',
	'FTP_FSOCK_ROOT_PATH'			=> 'Pad naar phpBB',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'Pad van de hoofdmap naar uw phpBB forum.',
	'FTP_FSOCK_TIMEOUT'				=> 'FTP-timeout',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'De tijd in seconden dat het systeem zal wachten voor een reactie van de server.',
	'FTP_FSOCK_USERNAME'			=> 'FTP-gebruikersnaam',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'Gebruikersnaam die gebruikt wordt om verbinding te maken met uw server.',

	'FTP_HOST'					=> 'FTP-host',
	'FTP_HOST_EXPLAIN'			=> 'FTP-server die gebruikt wordt om verbinding te maken met uw site.',
	'FTP_PASSWORD'				=> 'FTP-wachtwoord',
	'FTP_PASSWORD_EXPLAIN'		=> 'Wachtwoord van uw FTP-gebruikersnaam.',
	'FTP_PORT'					=> 'FTP-poort',
	'FTP_PORT_EXPLAIN'			=> 'Poort die gebruikt wordt om verbinding te maken met uw server.',
	'FTP_ROOT_PATH'				=> 'Pad naar phpBB',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'Pad van de hoofdmap naar uw phpBB forum.',
	'FTP_TIMEOUT'				=> 'FTP-timeout',
	'FTP_TIMEOUT_EXPLAIN'		=> 'De tijd in seconden dat het systeem zal wachten voor een reactie van de server.',
	'FTP_USERNAME'				=> 'FTP-gebruikersnaam',
	'FTP_USERNAME_EXPLAIN'		=> 'Gebruikersnaam die gebruikt wordt om verbinding te maken met uw server.',

	'GENERAL_ERROR'				=> 'Algemene fout',
	'GB'						=> 'GB',
	'GIB'						=> 'GiB',
	'GO'						=> 'Ok',
	'GOTO_PAGE'					=> 'Ga naar pagina',
	'GROUP'						=> 'Groep',
	'GROUPS'					=> 'Groepen',
	'GROUP_ERR_TYPE'			=> 'Onjuist groepstype opgegeven.',
	'GROUP_ERR_USERNAME'		=> 'Er is geen groepsnaam opgegeven.',
	'GROUP_ERR_USER_LONG'		=> 'Groepsnamen kunnen niet meer dan 60 tekens bevatten. De opgegeven groepsnaam is te lang.',
	'GUEST'						=> 'Gast',
	'GUEST_USERS_ONLINE'		=> 'Er zijn %d gasten online',
	'GUEST_USERS_TOTAL'			=> '%d gasten',
	'GUEST_USERS_ZERO_ONLINE'	=> 'Er zijn 0 gasten online',
	'GUEST_USERS_ZERO_TOTAL'	=> '0 gasten',
	'GUEST_USER_ONLINE'			=> 'Er is %d gast online',
	'GUEST_USER_TOTAL'			=> '%d gast',
	'G_ADMINISTRATORS'			=> 'Beheerders',
	'G_BOTS'					=> 'Bots',
	'G_GUESTS'					=> 'Gasten',
	'G_REGISTERED'				=> 'Geregistreerde gebruikers',
	'G_REGISTERED_COPPA'		=> 'Geregistreerde COPPA-gebruikers',
	'G_GLOBAL_MODERATORS'		=> 'Globale moderators',
	'G_NEWLY_REGISTERED'		=> 'Pas geregistreerde gebruikers',

	'HIDDEN_USERS_ONLINE'			=> '%d verborgen gebruikers online',
	'HIDDEN_USERS_TOTAL'			=> '%d verborgen',
	'HIDDEN_USERS_TOTAL_AND'		=> '%d verborgen en ',
	'HIDDEN_USERS_ZERO_ONLINE'		=> '0 verborgen gebruikers online',
	'HIDDEN_USERS_ZERO_TOTAL'		=> '0 verborgen',
	'HIDDEN_USERS_ZERO_TOTAL_AND'	=> '0 verborgen en ',
	'HIDDEN_USER_ONLINE'			=> '%d verborgen gebruiker online',
	'HIDDEN_USER_TOTAL'				=> '%d verborgen',
	'HIDDEN_USER_TOTAL_AND'			=> '%d verborgen en ',
	'HIDE_GUESTS'					=> 'Gasten verbergen',
	'HIDE_ME'						=> 'Mijn onlinestatus voor deze sessie verbergen',
	'HOURS'							=> 'Uren',
	'HOME'							=> 'Home',

	'ICQ'						=> 'ICQ',
	'ICQ_STATUS'				=> 'ICQ-status',
	'IF'						=> 'Als',
	'IMAGE'						=> 'Afbeelding',
	'IMAGE_FILETYPE_INVALID'	=> 'Afbeeldingsbestandstype %d voor mimetype %s wordt niet ondersteund.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'Slechte aanpassingstype van afbeeldingsbestand : verwachte extensie %1$s maar extensie %2$s is gegeven.',
	'IN'						=> 'in',
	'INDEX'						=> 'Forumindex',
	'INFORMATION'				=> 'Informatie',
	'INTERESTS'					=> 'Interesses',
	'INVALID_DIGEST_CHALLENGE'	=> 'Ongeldige digest-uitdaging.',
	'INVALID_EMAIL_LOG'			=> '<strong>%s</strong> is waarschijnlijk een ongeldig e-mailadres?',
	'IP'						=> 'IP-adres',
	'IP_BLACKLISTED'			=> 'Uw IP-adres %1$s is geblokeerd omdat het op de zwarte lijst voorkomt. Voor details bekijkt u de volgende link <a href="%2$s">%2$s</a>.',

	'JABBER'				=> 'Jabber',
	'JOINED'				=> 'Geregistreerd',
	'JUMP_PAGE'				=> 'Voer het nummer in van de pagina waar u naartoe wilt gaan',
	'JUMP_TO'				=> 'Ga naar',
	'JUMP_TO_PAGE'			=> 'Ga naar pagina…',

	'KB'					=> 'KB',
	'KIB'					=> 'KiB',

	'LAST_POST'							=> 'Laatste bericht',
	'LAST_UPDATED'						=> 'Laatst gewijzigd',
	'LAST_VISIT'						=> 'Laatste bezoek',
	'LDAP_NO_LDAP_EXTENSION'			=> 'LDAP-extensie is niet beschikbaar.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'Er kon geen verbinding worden gemaakt met de LDAP-server.',
	'LDAP_SEARCH_FAILED'                => 'Er is een fout opgetreden tijdens het doorzoeken van de LDAP-directory.',
	'LEGEND'							=> 'Legenda',
	'LOCATION'							=> 'Woonplaats',
	'LOCK_POST'							=> 'Bericht sluiten',
	'LOCK_POST_EXPLAIN'					=> 'Voorkomt dat dit bericht nog gewijzigd kan worden',
	'LOCK_TOPIC'						=> 'Onderwerp sluiten',
	'LOGIN'								=> 'Aanmelden',
	'LOGIN_CHECK_PM'					=> 'Meldt u aan om uw privéberichten te lezen.',
	'LOGIN_CONFIRMATION'				=> 'Bevestiging van aanmelding',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'Om aanvallen op accounts te voorkomen, moet u een bevestigingscode invoeren na een maximaal aantal mislukte aanmeldingspogingen. De code is weergegeven in de afbeelding die u hieronder kunt zien. Wanneer u visueel gehandicapt bent, of u kunt de code niet lezen, neem dan contact op met de %sforumbeheerder%s.',  // taalvariabele wordt niet gebruikt
	'LOGIN_ERROR_ATTEMPTS'				=> 'U heeft het maximaal aantal toegestane aanmeldingspogingen bereikt. Naast u gebruikersnaam en wachtwoord moet u nu ook de CAPTCHA oplossen die hieronder is weergegeven.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'U bent niet geautoriseerd door Apache.',
	'LOGIN_ERROR_PASSWORD'				=> 'U heeft een ongeldig wachtwoord opgegeven. Controleer uw wachtwoord en probeer het nog eens. Neem contact op met de %sforumbeheerder%s wanneer dit probleem zich blijft voordoen.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'Het was niet mogelijk om uw wachtwoord mee te converteren toen deze forumsoftware was geüpdate. Vraag %seen nieuw wachtwoord%s aan. Als u nog steeds problemen ondervindt, neem dan contact op met de %sforumbeheerder%s.',
	'LOGIN_ERROR_USERNAME'				=> 'U heeft een ongeldige gebruikersnaam opgegeven. Controleer uw gebruikersnaam en probeer het nog eens. Neem contact op met de %sforumbeheerder%s wanneer dit probleem zich blijft voordoen.',
	'LOGIN_FORUM'						=> 'Om dit forum te kunnen bekijken of er berichten in te kunnen plaatsen, moet u het wachtwoord, wat voor dit forum geldt, opgeven.',
	'LOGIN_INFO'						=> 'Om u te kunnen aanmelden moet u eerst geregisteerd zijn. Registeren neemt alleen een paar secondes in beslag, maar het geeft u veel meer mogelijkheden. Het is mogelijk dat de forumbeheerder extra permissies geeft aan geregistreerde gebruikers. Voordat u gaat registeren, wees er dan zeker van dat u bekend wordt met onze gebruikersvoorwaarden en de andere relaterende voorwaarden. Wees er ook zeker van dat u de forumregels doorleest wanneer u dit forum doorzoekt.',
	'LOGIN_VIEWFORUM'					=> 'Om dit forum te kunnen bekijken moet u geregistreerd en aangemeld zijn.',
	'LOGIN_EXPLAIN_EDIT'				=> 'Om berichten te kunnen wijzigen in dit forum moet u geregistreerd en aangemeld zijn.',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'Om de wie is er online lijst te kunnen bekijken moet u geregistreerd en aangemeld zijn.',
	'LOGOUT'							=> 'Afmelden',
	'LOGOUT_USER'						=> 'Afmelden [ %s ]',
	'LOG_ME_IN'							=> 'Bij elk bezoek mij automatisch aanmelden',

	'MARK'					=> 'Markeren',
	'MARK_ALL'				=> 'Alles markeren',
	'MARK_FORUMS_READ'		=> 'Alle forums als gelezen markeren',
	'MARK_SUBFORUMS_READ'	=> 'Subforums als gelezen markeren',
	'MB'					=> 'MB',
	'MIB'					=> 'MiB',
	'MCP'					=> 'Moderatorpaneel',
	'MEMBERLIST'			=> 'Leden',
	'MEMBERLIST_EXPLAIN'	=> 'Bekijk de complete ledenlijst',
	'MERGE'					=> 'Samenvoegen',
	'MERGE_POSTS'			=> 'Berichten verplaatsen',
	'MERGE_TOPIC'			=> 'Onderwerp samenvoegen',
	'MESSAGE'				=> 'Bericht',
	'MESSAGES'				=> 'Berichten',
	'MESSAGE_BODY'			=> 'Berichtinhoud',
	'MINUTES'				=> 'Minuten',
	'MODERATE'				=> 'Modereren',
	'MODERATOR'				=> 'Moderator',
	'MODERATORS'			=> 'Moderators',
	'MONTH'					=> 'Maand',
	'MOVE'					=> 'Verplaatsen',
	'MSNM'					=> 'MSNM/WLM',

	'NA'						=> 'N. v. t.',
	'NEWEST_USER'				=> 'Onze nieuwste gebruiker is <strong>%s</strong>',
	'NEW_MESSAGE'				=> 'Nieuw bericht',
	'NEW_MESSAGES'				=> 'Nieuwe berichten',
	'NEW_PM'					=> '<strong>%d</strong> nieuw bericht',
	'NEW_PMS'					=> '<strong>%d</strong> nieuwe berichten',
	'NEW_POST'					=> 'Nieuw bericht', // taalvariabele wordt niet gebruikt
	'NEW_POSTS'					=> 'Nieuwe berichten', // taalvariabele wordt niet gebruikt
	'NEXT'						=> 'Volgende',		// Used in pagination
	'NEXT_STEP'					=> 'Volgende',
	'NEVER'						=> 'Nooit',
	'NO'						=> 'Nee',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'U bent niet bevoegd om deze groep te beheren.',
	'NOT_AUTHORISED'			=> 'U bent niet bevoegd om deze sectie te bekijken.',
	'NOT_WATCHING_FORUM'		=> 'U bent niet langer geabonneerd voor updates van dit forum.',
	'NOT_WATCHING_TOPIC'		=> 'U bent niet langer geabonneerd voor dit onderwerp.',
	'NOTIFY_ADMIN'				=> 'Neem contact op met de forumbeheerder of webmaster.',
	'NOTIFY_ADMIN_EMAIL'		=> 'Neem contact op met de forumbeheerder of webmaster: <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'		=> 'U bent niet bevoegd om dit bestand te openen.',
	'NO_ACTION'					=> 'Er is geen actie opgegeven.',
	'NO_ADMINISTRATORS'			=> 'Er zijn geen beheerders.',
	'NO_AUTH_ADMIN'				=> 'Toegang tot het beheerderspaneel is niet toegestaan, omdat u geen beheerderspermissies heeft.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'U kunt u niet opnieuw aanmelden als een andere gebruiker.',
	'NO_AUTH_OPERATION'			=> 'U heeft niet de benodigde permissies om deze operatie te voltooien.',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'Er kon geen verbinding worden gemaakt met de smtp-host : %1$s : %2$s',
	'NO_BIRTHDAYS'				=> 'Er zijn geen verjaardagen vandaag',
	'NO_EMAIL_MESSAGE'			=> 'E-mailbericht is leeg.',
	'NO_EMAIL_RESPONSE_CODE'	=> 'Kon geen reactie-code verkrijgen van de e-mailserver.',
	'NO_EMAIL_SUBJECT'			=> 'Er is geen onderwerptitel opgegeven voor de e-mail.',
	'NO_FORUM'					=> 'Het forum wat u geselecteerd heeft bestaat niet.',
	'NO_FORUMS'					=> 'Er zijn geen forums beschikbaar.',
	'NO_GROUP'					=> 'De opgevraagde gebruikersgroep bestaat niet.',
	'NO_GROUP_MEMBERS'			=> 'Deze groep heeft op dit moment geen leden.',
	'NO_IPS_DEFINED'			=> 'Er zijn geen IP-adressen of hostnamen opgegeven',
	'NO_MEMBERS'				=> 'Er zijn geen gebruikers gevonden met deze zoekopdracht.',
	'NO_MESSAGES'				=> 'Er zijn geen berichten',
	'NO_MODE'					=> 'Er is geen mode opgegeven.',
	'NO_MODERATORS'				=> 'Er zijn geen moderators.',
	'NO_NEW_MESSAGES'			=> 'Er zijn geen nieuwe berichten',
	'NO_NEW_PM'					=> '<strong>0</strong> nieuwe berichten',
	'NO_NEW_POSTS'				=> 'Er zijn geen nieuwe berichten', // taalvariabele wordt niet gebruikt
	'NO_ONLINE_USERS'			=> 'Geen geregistreerde gebruikers',
	'NO_POSTS'					=> 'Er zijn geen berichten',
	'NO_POSTS_TIME_FRAME'		=> 'Er bestaan geen berichten binnen dit onderwerp voor de geselecteerde tijdsperiode.',
	'NO_FEED_ENABLED'			=> 'Feeds zijn niet beschikbaar op dit forum.',
	'NO_FEED'					=> 'De opgevraagde feed is niet beschikbaar.',
	'NO_SUBJECT'				=> 'Er is geen onderwerptitel opgegeven',								// Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'		=> 'De opgegeven zoekbackend bestaat niet.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'Er zijn ondersteunde autorisatie-methodes.',
	'NO_TOPIC'					=> 'Het opgevraagde onderwerp bestaat niet.',
	'NO_TOPIC_FORUM'			=> 'Het onderwerp of forum bestaat niet langer meer.',
	'NO_TOPICS'					=> 'Er zijn geen onderwerpen of berichten in dit forum.',
	'NO_TOPICS_TIME_FRAME'		=> 'Er bestaan geen onderwerpen in dit forum voor de geselecteerde tijdsperiode.',
	'NO_UNREAD_PM'				=> '<strong>0</strong> ongelezen berichten',
	'NO_UNREAD_POSTS'           => 'Geen ongelezen berichten',
	'NO_UPLOAD_FORM_FOUND'		=> 'De upload is gestart, maar er is geen geldig bestandsupload-formulier gevonden.',
	'NO_USER'					=> 'De opgevraagde gebruiker bestaat niet.',
	'NO_USERS'					=> 'De opgevraagde gebruikers bestaan niet.',
	'NO_USER_SPECIFIED'			=> 'Er is geen gebruikersnaam opgegeven.',

	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_POSTS_IN_QUEUE'		=> array(
		0			=> 'Geen berichten in de wachtrij',		// 0
		1			=> '1 bericht in de wachtrij',			// 1
		2			=> '%d berichten in de wachtrij',		// 2+
	),

	'OCCUPATION'				=> 'Beroep',
	'OFFLINE'					=> 'Offline',
	'ONLINE'					=> 'Online',
	'ONLINE_BUDDIES'			=> 'Online vrienden',
	'ONLINE_USERS_TOTAL'		=> 'Er zijn in totaal <strong>%d</strong> gebruikers online :: ',
	'ONLINE_USERS_ZERO_TOTAL'	=> 'Er zijn in totaal <strong>0</strong> gebruikers online :: ',
	'ONLINE_USER_TOTAL'			=> 'Er is in totaal <strong>1</strong> gebruiker online :: ',
	'OPTIONS'					=> 'Opties',

	'PAGE_OF'					=> 'Pagina <strong>%1$d</strong> van <strong>%2$d</strong>',
	'PASSWORD'					=> 'Wachtwoord',
	'PIXEL'						=> 'px',	
	'PLAY_QUICKTIME_FILE'		=> 'Quicktime-bestand afspelen',
	'PM'						=> 'PB',
	'PM_REPORTED'               => 'Klik hier om de melding te bekijken', 
	'POSTING_MESSAGE'			=> 'Plaatst een bericht in %s',
	'POSTING_PRIVATE_MESSAGE'	=> 'Stelt een privébericht samen',
	'POST'						=> 'Bericht',
	'POST_ANNOUNCEMENT'			=> 'Mededeling',
	'POST_STICKY'				=> 'Sticky',
	'POSTED'					=> 'Geplaatst',
	'POSTED_IN_FORUM'			=> 'in',
	'POSTED_ON_DATE'			=> 'op',
	'POSTS'						=> 'Berichten',
	'POSTS_UNAPPROVED'			=> 'Tenminste één bericht in dit ondewerp is nog niet goedgekeurd.',
	'POWERED_BY'          		=> 'Powered by %s',
	'POST_BY_AUTHOR'			=> 'door',
	'POST_BY_FOE'				=> 'Dit bericht is geschreven door <strong>%1$s</strong>, maar deze gebruiker staat op uw vijandenlijst. %2$sDit bericht weergeven%3$s.',
	'POST_DAY'					=> '%.2f berichten per dag',
	'POST_DETAILS'				=> 'Berichtdetails',
	'POST_NEW_TOPIC'			=> 'Plaats een nieuw onderwerp',
	'POST_PCT'					=> '%.2f%% van alle berichten',
	'POST_PCT_ACTIVE'			=> '%.2f%% van de gebruikersberichten',
	'POST_PCT_ACTIVE_OWN'		=> '%.2f%% van uw berichten',
	'POST_REPLY'				=> 'Plaats een reactie',
	'POST_REPORTED'				=> 'Klik om de melding te bekijken',
	'POST_SUBJECT'				=> 'Titel',
	'POST_TIME'					=> 'Plaatsingstijd',
	'POST_TOPIC'				=> 'Plaats een nieuw onderwerp',
	'POST_UNAPPROVED'			=> 'Dit bericht wacht op goedkeuring',
	'PREVIEW'					=> 'Voorbeeld',
	'PREVIOUS'					=> 'Vorige',		// Used in pagination
	'PREVIOUS_STEP'				=> 'Vorige',
	'PRIVACY'					=> 'Privacybeleid',
	'PRIVATE_MESSAGE'			=> 'Privébericht',
	'PRIVATE_MESSAGES'			=> 'Privéberichten',
	'PRIVATE_MESSAGING'			=> 'Privéberichten',
	'PROFILE'					=> 'Gebruikerspaneel',
	'RANK'						=> 'Rang',

	'READING_FORUM'				=> 'Bekijkt onderwerpen in %s',
	'READING_GLOBAL_ANNOUNCE'	=> 'Leest een forummededeling',
	'READING_LINK'				=> 'Volgt de forumlink %s',
	'READING_TOPIC'				=> 'Leest een onderwerp in %s',
	'READ_PROFILE'				=> 'Profiel',
	'REASON'					=> 'Reden',
	'RECORD_ONLINE_USERS'		=> 'De meeste gebruikers ooit tegelijkertijd online was <strong>%1$s</strong> op %2$s',
	'REDIRECT'					=> 'Doorverwijzing',
	'REDIRECTS'					=> 'Totaal doorverwijzingen',
	'REGISTER'					=> 'Registreren',
	'REGISTERED_USERS'			=> 'Geregistreerde gebruikers:',
	'REG_USERS_ONLINE'			=> 'Er zijn %d geregistreerde gebruikers online en ',
	'REG_USERS_TOTAL'			=> '%d geregistreerd, ',
	'REG_USERS_TOTAL_AND'		=> '%d geregistreerd en ',
	'REG_USERS_ZERO_ONLINE'		=> 'Er zijn 0 geregistreerde gebruikers online en ',
	'REG_USERS_ZERO_TOTAL'		=> '0 geregistreerd, ',
	'REG_USERS_ZERO_TOTAL_AND'	=> '0 geregistreerd en ',
	'REG_USER_ONLINE'			=> 'Er is %d geregistreerde gebruiker online en ',
	'REG_USER_TOTAL'			=> '%d geregistreerd, ',
	'REG_USER_TOTAL_AND'		=> '%d geregistreerd en ',
	'REMOVE'					=> 'Verwijderen',
	'REMOVE_INSTALL'			=> 'Verwijder, verplaats of hernoem de install-directory voordat u dit forum gaat gebruiken. Als deze directory nog steeds aanwezig is, dan zal alleen het beheerderspaneel toegankelijk zijn.',
	'REPLIES'					=> 'Reacties',
	'REPLY_WITH_QUOTE'			=> 'Reageer met citaat',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'Reageert op een forummededeling',
	'REPLYING_MESSAGE'			=> 'Reageert op een bericht in %s',
	'REPORT_BY'					=> 'Gemeld door',
	'REPORT_POST'				=> 'Meld dit bericht',
	'REPORTING_POST'			=> 'Bezig met melden van een bericht',
	'RESEND_ACTIVATION'			=> 'Activatie e-mail hersturen',
	'RESET'						=> 'Reset',
	'RESTORE_PERMISSIONS'		=> 'Permissies herstellen',
	'RETURN_INDEX'				=> '%sTerug naar de forumindex%s',
	'RETURN_FORUM'				=> '%sTerug naar het laatst bezochte forum%s',
	'RETURN_PAGE'				=> '%sTerug naar de vorige pagina%s',
	'RETURN_TOPIC'				=> '%sTerug naar het laatst bezochte onderwerp%s',
	'RETURN_TO'					=> 'Terug naar',
	'FEED'						=> 'Feed',
	'FEED_NEWS'					=> 'Nieuws',
	'FEED_TOPICS_ACTIVE'		=> 'Actieve onderwerpen',
	'FEED_TOPICS_NEW'			=> 'Nieuwe onderwerpen',	
	'RULES_ATTACH_CAN'			=> 'U <strong>mag</strong> bijlagen plaatsen in dit forum',
	'RULES_ATTACH_CANNOT'		=> 'U <strong>mag geen</strong> bijlagen plaatsen in dit forum',
	'RULES_DELETE_CAN'			=> 'U <strong>mag</strong> uw berichten verwijderen in dit forum',
	'RULES_DELETE_CANNOT'		=> 'U <strong>mag</strong> uw berichten <strong>niet</strong> verwijderen in dit forum',
	'RULES_DOWNLOAD_CAN'		=> 'U <strong>mag</strong> bijlagen downloaden in dit forum',
	'RULES_DOWNLOAD_CANNOT'		=> 'U <strong>mag geen</strong> bijlagen downloaden in dit forum',
	'RULES_EDIT_CAN'			=> 'U <strong>mag</strong> uw berichten wijzigen in dit forum',
	'RULES_EDIT_CANNOT'			=> 'U <strong>mag</strong> uw berichten <strong>niet</strong> wijzigen in dit forum',
	'RULES_LOCK_CAN'			=> 'U <strong>mag</strong> uw eigen onderwerpen sluiten in dit forum',
	'RULES_LOCK_CANNOT'			=> 'U <strong>mag</strong> uw eigen onderwerpen <strong>niet</strong> sluiten in dit forum',
	'RULES_POST_CAN'			=> 'U <strong>mag</strong> nieuwe onderwerpen plaatsen in dit forum',
	'RULES_POST_CANNOT'			=> 'U <strong>mag geen</strong> nieuwe onderwerpen plaatsen in dit forum',
	'RULES_REPLY_CAN'			=> 'U <strong>mag</strong> reacties plaatsen op onderwerpen in dit forum',
	'RULES_REPLY_CANNOT'		=> 'U <strong>mag geen</strong> reacties plaatsen op onderwerpen in dit forum',
	'RULES_VOTE_CAN'			=> 'U <strong>mag</strong> stemmen in peilingen in dit forum',
	'RULES_VOTE_CANNOT'			=> 'U <strong>mag niet</strong> stemmen in peilingen in dit forum',

	'SEARCH'					=> 'Zoeken',
	'SEARCH_MINI'				=> 'Zoeken…',
	'SEARCH_ADV'				=> 'Uitgebreid zoeken',
	'SEARCH_ADV_EXPLAIN'		=> 'Bekijk de uitgebreide zoekopties',
	'SEARCH_KEYWORDS'			=> 'Op trefwoorden zoeken',
	'SEARCHING_FORUMS'			=> 'Doorzoekt forums',
	'SEARCH_ACTIVE_TOPICS'		=> 'Bekijk actieve onderwerpen',
	'SEARCH_FOR'				=> 'Zoeken naar',
	'SEARCH_FORUM'				=> 'Forum doorzoeken…',
	'SEARCH_NEW'				=> 'Bekijk nieuwe berichten',
	'SEARCH_POSTS_BY'			=> 'Zoeken naar berichten van',
	'SEARCH_SELF'				=> 'Bekijk uw eigen berichten',
	'SEARCH_TOPIC'				=> 'Doorzoek dit onderwerp…',
	'SEARCH_UNANSWERED'			=> 'Bekijk onbeantwoorde berichten',
	'SEARCH_UNREAD'				=> 'Bekijk ongelezen berichten',
	'SEARCH_USER_POSTS'			=> 'Berichten van gebruiker zoeken',
	'SECONDS'					=> 'Seconden',
	'SELECT'					=> 'Selecteren',
	'SELECT_ALL_CODE'			=> 'Alles selecteren',
	'SELECT_DESTINATION_FORUM'	=> 'Een doelforum selecteren',
	'SELECT_FORUM'				=> 'Een forum selecteren',
	'SEND_EMAIL'				=> 'E-mail', // Used for submit buttons
	'SEND_EMAIL_USER'			=> 'E-mail', // Used as: {L_SEND_EMAIL_USER} {USERNAME} -> E-mail UserX
	'SEND_PRIVATE_MESSAGE'		=> 'Privébericht versturen',
	'SETTINGS'					=> 'Instellingen',
	'SIGNATURE'					=> 'Onderschrift',
	'SKIP'						=> 'Inhoud overslaan',
	'SMTP_NO_AUTH_SUPPORT'		=> 'SMTP-server ondersteund geen authenticatie.',
	'SORRY_AUTH_READ'			=> 'U bent niet bevoegd om dit forum te lezen.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'U bent niet bevoegd om deze bijlage te downloaden.',
	'SORT_BY'					=> 'Sorteer op',
	'SORT_JOINED'				=> 'Registratiedatum',
	'SORT_LOCATION'				=> 'Woonplaats',
	'SORT_RANK'					=> 'Rang',
	'SORT_POSTS'				=> 'Berichten',
	'SORT_TOPIC_TITLE'			=> 'Onderwerptitel',
	'SORT_USERNAME'				=> 'Gebruikersnaam',
	'SPLIT_TOPIC'				=> 'Onderwerp splitsen',
	'SQL_ERROR_OCCURRED'		=> 'Er is een SQL-fout opgetreden tijdens het ophalen van deze pagina. Neem contact op met de %sforumbeheerder%s als dit probleem zich blijft voordoen.',
	'STATISTICS'				=> 'Statistieken',
	'START_WATCHING_FORUM'		=> 'Op dit forum abonneren',
	'START_WATCHING_TOPIC'		=> 'Op dit onderwerp abonneren',
	'STOP_WATCHING_FORUM'		=> 'Abonnement op dit forum stopzetten',
	'STOP_WATCHING_TOPIC'		=> 'Abonnement op dit onderwerp stopzetten',
	'SUBFORUM'					=> 'Subforum',
	'SUBFORUMS'					=> 'Subforums',
	'SUBJECT'					=> 'Onderwerptitel',
	'SUBMIT'					=> 'Versturen',

	'TERMS_USE'			        => 'Gebruikersvoorwaarden',
	'TEST_CONNECTION'	        => 'Verbinding testen',
	'THE_TEAM'			        => 'Het team',
	'TIME'				        => 'Tijd',
	'TOO_LARGE'                 => 'De waarde die u heeft opgegeven is te lang.',
	'TOO_LARGE_MAX_RECIPIENTS'  => 'De waarde van de <strong>maximaal aantal toegestane ontvangers per privébericht</strong> instelling die u heeft opgegeven is te lang.',

	'TOO_LONG'						=> 'De waarde die u heeft ingevoerd is te lang.',

	'TOO_LONG_AIM'					=> 'De schermnaam die u heeft ingevoerd is te lang.',
	'TOO_LONG_CONFIRM_CODE'			=> 'De bevestigingscode die u heeft ingevoerd is te lang.',
	'TOO_LONG_DATEFORMAT'			=> 'Het datumformaat dat u heeft ingevoerd is te lang.',
	'TOO_LONG_ICQ'					=> 'Het ICQ-nummer dat u heeft ingevoerd is te lang.',
	'TOO_LONG_INTERESTS'			=> 'De interesses die u heeft ingevoerd zijn te lang.',
	'TOO_LONG_JABBER'				=> 'De Jabber-accountnaam dat u heeft ingevoerd is te lang.',
	'TOO_LONG_LOCATION'				=> 'De woonplaats die u heeft ingevoerd is te lang.',
	'TOO_LONG_MSN'					=> 'De MSNM/WLM-naam die u heeft ingevoerd is te lang.',
	'TOO_LONG_NEW_PASSWORD'			=> 'Het wachtwoord dat u heeft ingevoerd is te lang.',
	'TOO_LONG_OCCUPATION'			=> 'Het beroep dat u heeft ingevoerd is te lang.',
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'De bevestiging van het wachtwoord dat u heeft ingevoerd is te lang.',
	'TOO_LONG_USER_PASSWORD'		=> 'Het wachtwoord dat u heeft ingevoerd is te lang.',
	'TOO_LONG_USERNAME'				=> 'De gebruikersnaam die u heeft ingevoerd is te lang.',
	'TOO_LONG_EMAIL'				=> 'Het e-mailadres dat u heeft ingevoerd is te lang.',
	'TOO_LONG_EMAIL_CONFIRM'		=> 'De bevestiging van uw e-mailadres dat u heeft ingevoerd is te lang.',
	'TOO_LONG_WEBSITE'				=> 'Het website-adres dat u heeft ingevoerd is te lang.',
	'TOO_LONG_YIM'					=> 'De Yahoo! Messenger-gebruikersnaam die u heeft ingevoerd is te lang.',

	'TOO_MANY_VOTE_OPTIONS'			=> 'U heeft geprobeerd om op teveel opties te stemmen.',

	'TOO_SHORT'						=> 'De waarde die u heeft ingevoerd is te kort.',

	'TOO_SHORT_AIM'					=> 'De schermnaam die u heeft ingevoerd is te kort.',
	'TOO_SHORT_CONFIRM_CODE'		=> 'De bevestigingscode die u heeft ingevoerd is te kort.',
	'TOO_SHORT_DATEFORMAT'			=> 'Het datumformaat dat u heeft ingevoerd is te kort.',
	'TOO_SHORT_ICQ'					=> 'Het ICQ-nummer dat u heeft ingevoerd is te kort.',
	'TOO_SHORT_INTERESTS'			=> 'De interesses die u heeft ingevoerd zijn te kort.',
	'TOO_SHORT_JABBER'				=> 'De Jabber-accountnaam die u heeft ingevoerd is te kort.',
	'TOO_SHORT_LOCATION'			=> 'De woonplaats die u heeft ingevoerd is te kort.',
	'TOO_SHORT_MSN'					=> 'De MSNM/WLM-naam die u heeft ingevoerd is te kort.',
	'TOO_SHORT_NEW_PASSWORD'		=> 'Het wachtwoord dat u heeft ingevoerd is te kort.',
	'TOO_SHORT_OCCUPATION'			=> 'Het beroep dat u heeft ingevoerd is te kort.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'De bevestiging van het wachtwoord dat u heeft ingevoerd is te kort.',
	'TOO_SHORT_USER_PASSWORD'		=> 'Het wachtwoord dat u heeft ingevoerd is te kort.',
	'TOO_SHORT_USERNAME'			=> 'De gebruikersnaam die u heeft ingevoerd is te kort.',
	'TOO_SHORT_EMAIL'				=> 'Het e-mailadres dat u heeft ingevoerd is te kort.',
	'TOO_SHORT_EMAIL_CONFIRM'		=> 'De bevestiging van uw e-mailadres dat u heeft ingevoerd is te kort.',
	'TOO_SHORT_WEBSITE'				=> 'Het website-adres dat u heeft ingevoerd is te kort.',
	'TOO_SHORT_YIM'					=> 'De Yahoo! Messenger-gebruikersnaam die u heeft ingevoerd is te kort.',
	
	'TOO_SMALL'                     => 'De waarde die u heeft opgegeven is te kort.',
    'TOO_SMALL_MAX_RECIPIENTS'      => 'De waarde van de <strong>maximaal aantal toegestane ontvangers per privébericht</strong> instelling die u heeft opgegeven is te kort.',

	'TOPIC'					=> 'Onderwerp',
	'TOPICS'				=> 'Onderwerpen',
	'TOPICS_UNAPPROVED'		=> 'Tenminste één onderwerp in dit forum is nog niet goedgekeurd.',
	'TOPIC_ICON'			=> 'Onderwerppictogram',
	'TOPIC_LOCKED'			=> 'Dit onderwerp is gesloten. U kunt geen berichten wijzigen of nieuwe reacties plaatsen.',
	'TOPIC_LOCKED_SHORT'	=> 'Gesloten onderwerp',
	'TOPIC_MOVED'			=> 'Verplaatst onderwerp',
	'TOPIC_REVIEW'			=> 'Onderwerpoverzicht',
	'TOPIC_TITLE'			=> 'Onderwerptitel',
	'TOPIC_UNAPPROVED'		=> 'Dit onderwerp is niet goedgekeurd',
	'TOTAL_ATTACHMENTS'		=> 'Bijlage(n)',
	'TOTAL_LOG'				=> '1 logboekmelding',
	'TOTAL_LOGS'			=> '%d logboekmeldingen',
	'TOTAL_NO_PM'			=> 'In totaal 0 privéberichten',
	'TOTAL_PM'				=> 'In totaal 1 privébericht',
	'TOTAL_PMS'				=> 'In totaal $d privéberichten',
	'TOTAL_POSTS'			=> 'Aantal berichten',
	'TOTAL_POSTS_OTHER'		=> 'Aantal berichten: <strong>%d</strong>',
	'TOTAL_POSTS_ZERO'		=> 'Aantal berichten: <strong>0</strong>',
	'TOPIC_REPORTED'		=> 'Dit onderwerp is gemeld',
	'TOTAL_TOPICS_OTHER'	=> 'Aantal onderwerpen: <strong>%d</strong>',
	'TOTAL_TOPICS_ZERO'		=> 'Aantal onderwerpen: <strong>0</strong>',
	'TOTAL_USERS_OTHER'		=> 'Geregistreerde gebruikers: <strong>%d</strong>',
	'TOTAL_USERS_ZERO'		=> 'Geregistreerde gebruikers: <strong>0</strong>',
	'TRACKED_PHP_ERROR'		=> '%s gevonden PHP-fouten',

	'UNABLE_GET_IMAGE_SIZE'		=> 'Het was onmogelijk om de afmeting van de afbeelding te bepalen.',
	'UNABLE_TO_DELIVER_FILE'	=> 'Het bestand kan niet worden afgeleverd.',
	'UNKNOWN_BROWSER'			=> 'Onbekende browser',
	'UNMARK_ALL'				=> 'Alle markeringen verwijderen',
	'UNREAD_MESSAGES'			=> 'Ongelezen berichten',
	'UNREAD_PM'					=> '<strong>%d</strong> ongelezen bericht',
	'UNREAD_PMS'				=> '<strong>%d</strong> ongelezen berichten',
	'UNREAD_POST'				=> 'Ongelezen bericht',
	'UNREAD_POSTS'				=> 'Ongelezen berichten',
	'UNWATCHED_FORUMS'			=> 'U bent niet meer geabonneerd op de geselecteerde forums.',
	'UNWATCH_FORUM_CONFIRM'		=> 'Weet u zeker dat u het abonnement wilt stopzetten van dit forum?',
	'UNWATCH_FORUM_DETAILED'	=> 'Weet u zeker dat u het abonnement van het forum “%s” wilt stopzetten?',
	'UNWATCH_TOPIC_CONFIRM'		=> 'Weet u zeker dat u het abonnement wilt stopzetten van dit onderwerp?',
	'UNWATCH_TOPIC_DETAILED'	=> 'Weet u zeker dat u het abonnement van het onderwerp “%s” wilt stopzetten?',
	'UNWATCHED_TOPICS'			=> 'U bent niet meer geabonneerd op de geselecteerde onderwerpen.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'U bent niet meer geabonneerd op de geselecteerde forums en onderwerpen.',
	'UPDATE'					=> 'Update',
	'UPLOAD_IN_PROGRESS'		=> 'Het uploadproces is momenteel aan de gang.',
	'URL_REDIRECT'				=> 'Als uw internetbrowser geen meta-redirectie ondersteunt %sklik dan hier om gelijk doorverwezen te worden%s.',
	'USERGROUPS'				=> 'Groepen',
	'USERNAME'					=> 'Gebruikersnaam',
	'USERNAMES'					=> 'Gebruikersnamen',
	'USER_AVATAR'				=> 'Gebruikers-avatar',
	'USER_CANNOT_READ'			=> 'U kunt geen berichten lezen in dit forum.',
	'USER_POST'					=> '%d bericht',
	'USER_POSTS'				=> '%d berichten',
	'USERS'						=> 'Gebruikers',
	'USE_PERMISSIONS'			=> 'Gebruikerspermissies uittesten',

	'USER_NEW_PERMISSION_DISALLOWED'	=> 'Het spijt ons, maar u bent niet bevoegd om deze functie te gebruiken. U bent net geregistreerd hier en/of u moet meer deelnemen aan het forum om deze functie te kunnen gebruiken.',

	'VARIANT_DATE_SEPARATOR'	=> ' / ', // Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'Bekeken',
	'VIEWING_FAQ'				=> 'Bekijkt de FAQ',
	'VIEWING_MEMBERS'			=> 'Bekijkt de ledenlijst',
	'VIEWING_ONLINE'			=> 'Bekijkt wie er online zijn',
	'VIEWING_MCP'				=> 'Bekijkt het moderatorpaneel',
	'VIEWING_MEMBER_PROFILE'	=> 'Bekijkt een ledenprofiel',
	'VIEWING_PRIVATE_MESSAGES'	=> 'Bekijkt zijn/haar privéberichten',
	'VIEWING_REGISTER'			=> 'Registreert een account',
	'VIEWING_UCP'				=> 'Bekijkt het gebruikerspaneel',
	'VIEWS'						=> 'Bekeken',
	'VIEW_BOOKMARKS'			=> 'Bladwijzers bekijken',
	'VIEW_FORUM_LOGS'			=> 'Logboeken bekijken',
	'VIEW_LATEST_POST'			=> 'Laatste bericht bekijken',
	'VIEW_NEWEST_POST'			=> 'Eerste ongelezen bericht bekijken',
	'VIEW_NOTES'				=> 'Gebruikersnotities bekijken',
	'VIEW_ONLINE_TIME'			=> 'Gebaseerd op de gebruikers die actief waren gedurende %d minuut',
	'VIEW_ONLINE_TIMES'			=> 'Gebaseerd op de gebruikers die actief waren gedurende %d minuten',
	'VIEW_TOPIC'				=> 'Bekijk onderwerp',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'Mededeling: ',
	'VIEW_TOPIC_GLOBAL'			=> 'Forummededeling: ',
	'VIEW_TOPIC_LOCKED'			=> 'Gesloten: ',
	'VIEW_TOPIC_LOGS'			=> 'Logboek bekijken',
	'VIEW_TOPIC_MOVED'			=> 'Verplaatst: ',
	'VIEW_TOPIC_POLL'			=> 'Peiling: ',
	'VIEW_TOPIC_STICKY'			=> 'Sticky: ',
	'VISIT_WEBSITE'				=> 'Website bezoeken',

	'WARNINGS'			=> 'Waarschuwingen',
	'WATCH_FORUM_CONFIRM'	=> 'Weet u zeker dat u zich wilt abonneren op dit forum?',
	'WATCH_FORUM_DETAILED'	=> 'Weet u zeker dat u zich wilt abonneren op het forum “%s”?',
	'WATCH_TOPIC_CONFIRM'	=> 'Weet u zeker dat u zich wilt abonneren op dit onderwerp?',
	'WATCH_TOPIC_DETAILED'	=> 'Weet u zeker dat u zich wilt abonneren op het onderwerp “%s”?',
	'WARN_USER'			=> 'Gebruiker waarschuwen',
	'WELCOME_SUBJECT'	=> 'Welkom op het %s-forum',
	'WEBSITE'			=> 'Website',
	'WHOIS'				=> 'Whois',
	'WHO_IS_ONLINE'		=> 'Wie is er online?',
	'WRONG_PASSWORD'	=> 'U heeft een onjuist wachtwoord ingevoerd.',

	'WRONG_DATA_ICQ'			=> 'Het nummer dat u heeft ingevoerd is een niet geldig ICQ-nummer.',
	'WRONG_DATA_JABBER'			=> 'De naam die u heeft ingevoerd is een niet geldige Jabber-accountnaam.',
	'WRONG_DATA_LANG'			=> 'De taal die u heeft opgegeven is niet geldig.',
	'WRONG_DATA_WEBSITE'		=> 'Het website-adres moet een geldige url zijn, inclusief http://. Bijvoorbeeld: http://www.phpbbservice.nl/.',
	'WROTE'						=> 'schreef',

	'YEAR'				=> 'Jaar',
	'YEAR_MONTH_DAY'	=> '(JJJJ-MM-DD)',
	'YES'				=> 'Ja',
	'YIM'				=> 'YIM',
	'YOU_LAST_VISIT'	=> 'Uw laatste bezoek was: %s',
	'YOU_NEW_PM'		=> 'Er is een nieuw privébericht aanwezig in uw Postvak IN.',
	'YOU_NEW_PMS'		=> 'Er zijn meerdere nieuwe privéberichten aanwezig in uw Postvak IN.',
	'YOU_NO_NEW_PM'		=> 'Er zijn geen nieuwe privéberichten.',

	'datetime'	=> array(
		'TODAY'		=> 'Vandaag',
		'TOMORROW'	=> 'Morgen',
		'YESTERDAY'	=> 'Gisteren',
		'AGO'		=> array(
			0		=> 'minder dan een minuut geleden',
			1		=> '%d minuut geleden',
			2		=> '%d minuten geleden',
			60		=> '1 uur geleden',
		),

		'Sunday'	=> 'Zondag',
		'Monday'	=> 'Maandag',
		'Tuesday'	=> 'Dinsdag',
		'Wednesday'	=> 'Woensdag',
		'Thursday'	=> 'Donderdag',
		'Friday'	=> 'Vrijdag',
		'Saturday'	=> 'Zaterdag',

		'Sun'		=> 'Zo',
		'Mon'		=> 'Ma',
		'Tue'		=> 'Di',
		'Wed'		=> 'Wo',
		'Thu'		=> 'Do',
		'Fri'		=> 'Vr',
		'Sat'		=> 'Za',

		'January'	=> 'Januari',
		'February'	=> 'Februari',
		'March'		=> 'Maart',
		'April'		=> 'April',
		'May'		=> 'Mei',
		'June'		=> 'Juni',
		'July'		=> 'Juli',
		'August'	=> 'Augustus',
		'September'	=> 'September',
		'October'	=> 'Oktober',
		'November'	=> 'November',
		'December'	=> 'December',

		'Jan'		=> 'Jan',
		'Feb'		=> 'Feb',
		'Mar'		=> 'Mrt',
		'Apr'		=> 'Apr',
		'May_short'	=> 'Mei', // Short representation of "May". May_short used because in English the short and long date are the same for May.
		'Jun'		=> 'Jun',
		'Jul'		=> 'Jul',
		'Aug'		=> 'Aug',
		'Sep'		=> 'Sep',
		'Oct'		=> 'Okt',
		'Nov'		=> 'Nov',
		'Dec'		=> 'Dec',
	),

	'tz'		=> array(
		'-12'	=> 'UTC - 12 uur',
		'-11'	=> 'UTC - 11 uur',
		'-10'	=> 'UTC - 10 uur',
		'-9.5'	=> 'UTC - 9:30 uur',
		'-9'	=> 'UTC - 9 uur',
		'-8'	=> 'UTC - 8 uur',
		'-7'	=> 'UTC - 7 uur',
		'-6'	=> 'UTC - 6 uur',
		'-5'	=> 'UTC - 5 uur',
		'-4.5'	=> 'UTC - 4:30 uur',
		'-4'	=> 'UTC - 4 uur',
		'-3.5'	=> 'UTC - 3:30 uur',
		'-3'	=> 'UTC - 3 uur',
		'-2'	=> 'UTC - 2 uur',
		'-1'	=> 'UTC - 1 uur',
		'0'		=> 'UTC',
		'1'		=> 'UTC + 1 uur',
		'2'		=> 'UTC + 2 uur',
		'3'		=> 'UTC + 3 uur',
		'3.5'	=> 'UTC + 3:30 uur',
		'4'		=> 'UTC + 4 uur',
		'4.5'	=> 'UTC + 4:30 uur',
		'5'		=> 'UTC + 5 uur',
		'5.5'	=> 'UTC + 5:30 uur',
		'5.75'	=> 'UTC + 5:45 uur',
		'6'		=> 'UTC + 6 uur',
		'6.5'	=> 'UTC + 6:30 uur',
		'7'		=> 'UTC + 7 uur',
		'8'		=> 'UTC + 8 uur',
		'8.75'	=> 'UTC + 8:45 uur',
		'9'		=> 'UTC + 9 uur',
		'9.5'	=> 'UTC + 9:30 uur',
		'10'	=> 'UTC + 10 uur',
		'10.5'	=> 'UTC + 10:30 uur',
		'11'	=> 'UTC + 11 uur',
		'11.5'	=> 'UTC + 11:30 uur',
		'12'	=> 'UTC + 12 uur',
		'12.75'	=> 'UTC + 12:45 uur',
		'13'	=> 'UTC + 13 uur',
		'14'	=> 'UTC + 14 uur',
		'dst'	=> '[ Zomertijd ]',
	),

	'tz_zones'	=> array(
		'-12'	=> '[UTC - 12] Bakereiland tijd',
		'-11'	=> '[UTC - 11] Niue tijd, Samoa standaardtijd',
		'-10'	=> '[UTC - 10] Hawaii-Aleutian standaardtijd, Cookeiland tijd',
		'-9.5'	=> '[UTC - 9:30] Marquesas eiland tijd',
		'-9'	=> '[UTC - 9] Alaska standaardtijd, Gambier eiland tijd',
		'-8'	=> '[UTC - 8] Pacifische standaardtijd',
		'-7'	=> '[UTC - 7] Mountain standaardtijd',
		'-6'	=> '[UTC - 6] Centrale standaardtijd',
		'-5'	=> '[UTC - 5] Eastern standaardtijd',
		'-4.5'	=> '[UTC - 4:30] Venezuela standaardtijd',
		'-4'	=> '[UTC - 4] Atlantische standaardtijd',
		'-3.5'	=> '[UTC - 3:30] Newfoundland standaardtijd',
		'-3'	=> '[UTC - 3] Amazone standaardtijd, Centraal Groenland tijd',
		'-2'	=> '[UTC - 2] Fernando de Noronha tijd, Zuidelijk Georgia &amp; de South-Sandwich eiland tijd',
		'-1'	=> '[UTC - 1] Azores standaardtijd, Kaapverdië tijd, Oostelijk Groenland tijd',
		'0'		=> '[UTC] West-Europese tijd, Greenwich tijd',
		'1'		=> '[UTC + 1] Centraal-Europese tijd (CET), West-Afrikaanse tijd',
		'2'		=> '[UTC + 2] Oost-Europese tijd (EAT), Centraal-Afrikaanse tijd',
		'3'		=> '[UTC + 3] Moskou standaardtijd, Oost-Afrikaanse tijd',
		'3.5'	=> '[UTC + 3:30] Iraneese standaardtijd',
		'4'		=> '[UTC + 4] Arabische golf standaardtijd, Samara standaardtijd',
		'4.5'	=> '[UTC + 4:30] Afghanistan tijd',
		'5'		=> '[UTC + 5] Pakistan standaardtijd, Yekaterinburg standaardtijd',
		'5.5'	=> '[UTC + 5:30] India standaardtijd, Sri Lanka tijd',
		'5.75'	=> '[UTC + 5:45] Nepal tijd',
		'6'		=> '[UTC + 6] Bangladesh tijd, Bhutan tijd , Novosibirsk standaardtijd',
		'6.5'	=> '[UTC + 6:30] Cocos-eiland tijd, Myanmar tijd',
		'7'		=> '[UTC + 7] Indochina tijd, Krasnoyarsk standaardtijd',
		'8'		=> '[UTC + 8] Chinese standaardtijd, West-Australische standaardtijd, Irkutsk standaardtijd',
		'8.75'	=> '[UTC + 8:45] Westelijk Zuidoost-Australische standaardtijd',
		'9'		=> '[UTC + 9] Japan standaardtijd, Korea standaardtijd, China standaardtijd',
		'9.5'	=> '[UTC + 9:30] Centraal-Australische standaardtijd',
		'10'	=> '[UTC + 10] Oost-Australische standaardtijd, Vladivostok standaardtijd',
		'10.5'	=> '[UTC + 10:30] Lord Howe standaardtijd',
		'11'	=> '[UTC + 11] Solomoneiland tijd, Magadan standaardtijd',
		'11.5'	=> '[UTC + 11:30] Norfolkeiland tijd',
		'12'	=> '[UTC + 12] Nieuw-Zeeland tijd, Fiji tijd, Kamchatka standaardtijd',
		'12.75'	=> '[UTC + 12:45] Chathameiland tijd',
		'13'	=> '[UTC + 13] Tonga tijd, Phoenixeiland tijd',
		'14'	=> '[UTC + 14] Line-eilanden tijd',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'd M Y, H:i'			=> '01 Jan 2007, 13:37',
		'd M Y H:i'				=> '01 Jan 2007 13:37',
		'M jS, \'y, H:i'		=> 'Jan 1st, \'07, 13:37',
		'D M d, Y g:i a'		=> 'Ma Jan 01, 2007 1:37 pm',
		'F jS, Y, g:i a'		=> 'Januari 1ste, 2007, 1:37 pm',
		'|d M Y|, H:i'			=> 'Vandaag, 13:37 / 01 Jan 2007, 13:37',
		'|F jS, Y|, g:i a'		=> 'Vandaag, 1:37 pm / Januari 1st, 2007, 1:37 pm'
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=> 'D d M Y, H:i', // Mon Jan 01, 2007 1:37 pm

));

?>