<?php

require_once dirname(__FILE__) . '/../../../prods/src/ProdsPath.class.php';
require_once dirname(__FILE__) . '/../../../prods/src/ProdsDir.class.php';
require_once dirname(__FILE__) . '/../../../prods/src/ProdsFile.class.php';
require_once dirname(__FILE__) . '/../../../prods/src/RODSAccount.class.php';
require_once dirname(__FILE__) . '/../../../prods/src/RODSException.class.php';
require_once dirname(__FILE__) . '/../../../prods/src/RODSMeta.class.php';
require_once dirname(__FILE__) . '/stubRODSConnManager.class.php';

/**
 * Test class for ProdsPath.
 * Generated by PHPUnit on 2011-02-24 at 16:39:17.
 */
class ProdsPathTest extends PHPUnit_Framework_TestCase {

    /**
     * @var prodsPath
     */
    protected $prodsPath;
    protected $rodsAcct;
    protected $rodsMeta;
    protected $path_str = "/testit/home";
    protected $parent_path;
    protected $path_exists;
    protected $name;

    // values for initialization of RODSAccount
    protected $id = "1";
    protected $user = "me";
    protected $zone = "myZone";
    protected $host = "myirods.myhost.mycom";
    protected $port = "1111";
    protected $passwd = "meme";
    protected $type = "rodsuser";
    protected $ctime = "01298479459";
    protected $mtime = "01298479459";
    protected $comment = "foo";
    protected $info = "bar";
    protected $dn = "";


    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp() {

        $this->rodsAcct = new RODSAccount($this->host, $this->port, $this->user, $this->passwd, $this->zone);
        $this->rodsMeta = new RODSMeta("test_meta", "this is a test meta");

    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown() {

    }

    /**
     * @todo Implement test__toString().
     */
    public function test__toString() {

        $path = "/path/tonowhere";
        $expected = $this->user . "." . $this->zone . ":(password hidden)@" . $this->host . ":" . $this->port . $path;
        $mocked_prodspath_construct_params = array(&$this->rodsAcct, $path);

        $prods_path_stub = $this->getMockForAbstractClass('ProdsPath', $mocked_prodspath_construct_params);
        $this->assertEquals($expected, $prods_path_stub->__toString());

    }

    /**
     * @todo Implement testExists().
     */
    public function testExists() {

        $this->markTestIncomplete(
                'This test has not been implemented yet.'
        );

        $path = "/path/tonowhere";
        $mocked_prodspath_construct_params = array(&$this->rodsAcct, $path);

        $prods_path_stub = $this->getMockForAbstractClass('ProdsPath', $mocked_prodspath_construct_params);
        //$prods_path_stub->expects($this->any())->method('verify')->will($this->returnValue($path));

        $this->assertEquals(NULL, $prods_path_stub->exists());

        // need to figure out how to test this path of the code - cannot seem to access protected property path_exists
        //$prods_path_stub->path_exists = $path;
        $this->assertEquals($path, $prods_path_stub->exists());
    }

    /**
     * @todo Implement testGetMeta().
     */
    public function testGetMeta() {

        $this->markTestIncomplete(
                'This test has not been implemented yet.'
        );

        $path = "/path/tonowhere";
        $mocked_prodspath_construct_params = array(&$this->rodsAcct, $path);

        $prods_path_stub = $this->getMockForAbstractClass('ProdsPath', $mocked_prodspath_construct_params, 'ProdsDir');
        $meta_array = $prods_path_stub->getMeta(
                array('stubRODSConnManager', 'getConn'),
                array('stubRODSConnManager', 'releaseConn'));

        $this->assertEquals("this is a test of metadata", $meta_array[0]);

        try {
          $ti_class = new testInstanceOf($this->rodsAcct, $this->path_str);
          $ti_class->getMeta();
        }
        catch(RODSException $ex) {
            return;
        }
        $this->fail("An expected exception has not been raised");

    }

    /**
     * @todo Implement testUpdateMeta().
     */
    public function testUpdateMeta() {
        // Remove the following lines when you implement this test.
        $this->markTestIncomplete(
                'This test has not been implemented yet.'
        );
    }

    /**
     * @todo Implement testAddMeta().
     */
    public function testAddMeta() {

        $this->markTestIncomplete(
                'This test has not been implemented yet.'
        );
        
        $path = "/path/tonowhere";
        $mocked_prodspath_construct_params = array(&$this->rodsAcct, $path);

        $prods_path_stub = $this->getMockForAbstractClass('ProdsPath', $mocked_prodspath_construct_params, 'ProdsDir');
        $prods_path_stub->addMeta(
                $this->rodsMeta,
                array('stubRODSConnManager', 'getConn'),
                array('stubRODSConnManager', 'releaseConn'));
        $params_array = stubRODSConn::getParams();

        $this->assertEquals("c", $params_array[0]);
        $this->assertEquals($path, $params_array[1]);
        $this->assertEquals($this->rodsMeta, $params_array[2]);

        try {
          $ti_class = new testInstanceOf($this->rodsAcct, $this->path_str);
          $ti_class->addMeta($this->rodsMeta);
        }
        catch(RODSException $ex) {
            return;
        }
        $this->fail("An expected exception has not been raised");
    }

    /**
     * @todo Implement testRmMeta().
     */
    public function testRmMeta() {

        $this->markTestIncomplete(
                'This test has not been implemented yet.'
        );

        $path = "/path/tohere";
        $mocked_prodspath_construct_params = array(&$this->rodsAcct, $path);

        $prods_path_stub = $this->getMockForAbstractClass('ProdsPath', $mocked_prodspath_construct_params, 'ProdsFile');
        $prods_path_stub->rmMeta(
                $this->rodsMeta,
                array('stubRODSConnManager', 'getConn'),
                array('stubRODSConnManager', 'releaseConn'));
        $params_array = stubRODSConn::getParams();

        $this->assertEquals("d", $params_array[0]);
        $this->assertEquals($path, $params_array[1]);
        $this->assertEquals($this->rodsMeta, $params_array[2]);

        try {
          $ti_class = new testInstanceOf($this->rodsAcct, $this->path_str);
          $ti_class->rmMeta($this->rodsMeta);
        }
        catch(RODSException $ex) {
            return;
        }
        $this->fail("An expected exception has not been raised");
    }

    /**
     * @todo Implement testRmMetaByID().
     */
    public function testRmMetaByID() {

        $this->markTestIncomplete(
                'This test has not been implemented yet.'
        );

        $test_id = "test_meta";
        $path = "/path/tohere";
        $mocked_prodspath_construct_params = array(&$this->rodsAcct, $path);

        $prods_path_stub = $this->getMockForAbstractClass('ProdsPath', $mocked_prodspath_construct_params, 'ProdsFile');
        $prods_path_stub->rmMetaByID(
                $test_id,
                array('stubRODSConnManager', 'getConn'),
                array('stubRODSConnManager', 'releaseConn'));
        $params_array = stubRODSConn::getParams();

        $this->assertEquals("d", $params_array[0]);
        $this->assertEquals($path, $params_array[1]);
        $this->assertEquals($test_id, $params_array[2]);

        try {
          $ti_class = new testInstanceOf($this->rodsAcct, $this->path_str);
          $ti_class->rmMetaByID($test_id);
        }
        catch(RODSException $ex) {
            return;
        }
        $this->fail("An expected exception has not been raised");

    }

    /**
     * @todo Implement testCpMeta().
     */
    public function testCpMeta() {

        $this->markTestIncomplete(
                'This test has not been implemented yet.'
        );

        $path = "/path/tonowhere";
        $mocked_prodspath_construct_params = array(&$this->rodsAcct, $path);
        $mocked_prodsdir_construct_params = array(&$this->rodsAcct, $this->path_str);
        $mocked_prodsdir_methods = array('exists');

        $prods_dir_stub = $this->getMock('ProdsDir', $mocked_prodsdir_methods, $mocked_prodsdir_construct_params);
        $prods_dir_stub->expects($this->any())->method('exists')->will($this->returnValue(TRUE));

        $prods_path_stub = $this->getMockForAbstractClass('ProdsPath', $mocked_prodspath_construct_params, 'ProdsDir');
        $prods_path_stub->cpMeta(
                $prods_dir_stub,
                array('stubRODSConnManager', 'getConn'),
                array('stubRODSConnManager', 'releaseConn'));
        $params_array = stubRODSConn::getParams();

        $this->assertEquals("c", $params_array[0]);
        $this->assertEquals("c", $params_array[1]);
        $this->assertEquals($path, $params_array[2]);
        $this->assertEquals($path, $params_array[3]);

        try {
          $ti_class = new testInstanceOf($this->rodsAcct, $this->path_str);
          $ti_class->cpMeta($prods_dir_stub);
        }
        catch(RODSException $ex) {
            return;
        }
        $this->fail("An expected exception has not been raised");
    }

    /**
     * @todo Implement testRename().
     */
    public function testRename() {

        $path = "/path/tohere";
        $new_ppath = "/path";
        $new_name = "to_new_here";
        $new_path = $new_ppath . "/" . $new_name;
        $mocked_prodspath_construct_params = array(&$this->rodsAcct, $path);

        $prods_path_stub = $this->getMockForAbstractClass('ProdsPath', $mocked_prodspath_construct_params, 'ProdsFile1');
        $prods_path_stub->rename(
                $new_path,
                array('stubRODSConnManager', 'getConn'),
                array('stubRODSConnManager', 'releaseConn'));
        $params_array = stubRODSConn::getParams();

        $this->assertEquals($path, $params_array[0]);
        $this->assertEquals($new_path, $params_array[1]);
        // PROBABLY SHOULD ALSO ADD TEST FOR INSTANCE OF PRODSFILE PATH (params_array[2] = "0") IN METHOD SOURCE CODE
        $this->assertEquals("1", $params_array[2]);
        
        $this->assertEquals($new_path, $prods_path_stub->getPath());
        $this->assertEquals($new_ppath, $prods_path_stub->getParentPath());
        $this->assertEquals($new_name, $prods_path_stub->getName());

    }

    /**
     * @todo Implement testGetName().
     */
    public function testGetName() {

        $this->markTestIncomplete(
                'This test has not been implemented yet.'
        );

        $base = "/path/";
        $name = "tonowhere";
        $path = $base . $name;
        $mocked_prodspath_construct_params = array(&$this->rodsAcct, $path);

        $prods_path_stub = $this->getMockForAbstractClass('ProdsPath', $mocked_prodspath_construct_params);
        $this->assertEquals($name, $prods_path_stub->getName());
    }

    /**
     * @todo Implement testGetPath().
     */
    public function testGetPath() {

        $base = "/path/";
        $name = "tonowhere";
        $path = $base . $name;
        $mocked_prodspath_construct_params = array(&$this->rodsAcct, $path);

        $prods_path_stub = $this->getMockForAbstractClass('ProdsPath', $mocked_prodspath_construct_params);
        $this->assertEquals($path, $prods_path_stub->getPath());
    }

    /**
     * @todo Implement testGetParentPath().
     */
    public function testGetParentPath() {
        
        $nopath ="/";
        $base = "/path";
        $name = "/tonowhere";
        $path = $base . $name;
        $mocked_prodspath_construct_params = array(&$this->rodsAcct, $nopath);

        $prods_path_stub = $this->getMockForAbstractClass('ProdsPath', $mocked_prodspath_construct_params);
        $this->assertEquals(NULL, $prods_path_stub->getParentPath());

        $mocked_prodspath_construct_params = array(&$this->rodsAcct, $path);
        $prods_path_stub = $this->getMockForAbstractClass('ProdsPath', $mocked_prodspath_construct_params);
        $this->assertEquals($base, $prods_path_stub->getParentPath());
    }

    /**
     * @todo Implement testToURI().
     */
    public function testToURI() {

        $base = "/path/";
        $name = "tonowhere";
        $path = $base . $name;
        $expected = $this->user . "." . $this->zone . "@" . $this->host . ":" . $this->port . $path;
        $mocked_prodspath_construct_params = array(&$this->rodsAcct, $path);

        $prods_path_stub = $this->getMockForAbstractClass('ProdsPath', $mocked_prodspath_construct_params);
        $this->assertEquals($expected, $prods_path_stub->toURI());
    }

}

class testInstanceOf extends ProdsPath
{
    public function  __construct(RODSAccount &$account, $path_str) {
        parent::__construct($account, $path_str);
    }
    public function verify() {
        
    }

}

?>
