<?php
 if(!extension_loaded('clam')) {
         dl('clam.so');
 }
 $module = 'clam';
 $functions = get_extension_funcs($module);
 echo "Functions available \n";
 echo "------------------- \n";
 foreach($functions as $func) {
         echo $func."\n";
 }
 echo "\n";
?>

<?php
 if(!extension_loaded('clam')) {
         dl('clam.so');
 }
#=========================================================================
function check_file ($file,$method) {
	if (!file_exists($file)) {
		return "No such file";
	} else {
		if ($method == "buffer") {
			$fp = fopen($file,"r");
			$contents = fread($fp, filesize($file));
			$tmp = clam_scan_buffer($contents);
		} elseif ($method == "file") {
			$tmp = clam_scan_file($file);
		} else {
			return "no valid scan mechanism specified";
		}
		if (!$tmp) {
			return "No virus or something messed up";
		} else {
			return $tmp;
		}
	}
}


print "
================================================
eicar.com	:: standard simple test file
------------------------------------------------\n";
print "Buffer : expected TRUE : ".check_file("test_files/eicar.com","buffer")."\n";
print "File : expected TRUE : ".check_file("test_files/eicar.com","file")."\n";

print "
================================================
eicar.com.txt	:: hidden extension test file
------------------------------------------------\n";
print "Buffer : expected TRUE : ".check_file("test_files/eicar.com.txt","buffer")."\n";
print "File : expected TRUE : ".check_file("test_files/eicar.com.txt","file")."\n";

print "
================================================
eicar_com.zip	:: simple one-depth zip test
------------------------------------------------\n";
print "Buffer : expected FALSE : ".check_file("test_files/eicar_com.zip","buffer")."\n";
print "File : expected TRUE : ".check_file("test_files/eicar_com.zip","file")."\n";

print "
================================================
eicarcom_2.zip	:: multi-depth complex zip test
------------------------------------------------\n";
print "Buffer : expected FALSE : ".check_file("test_files/eicarcom_2.zip","buffer")."\n";
print "File : expected TRUE : ".check_file("test_files/eicarcom_2.zip","file")."\n";

print clam_test();
?>

