dnl config.m4 for clam anti-virus extension


dnl If your extension references something external, use with:

PHP_ARG_WITH(clam, for clam support, [  --with-clam             Include clam support])


if test "$PHP_CLAM" != "no"; then

	# --with-clam -> check with-path
	SEARCH_PATH="/usr/local /usr"     # you might want to change this
	SEARCH_FOR="/include/clam.h"  # you most likely want to change this
	if test -r $PHP_CLAM/; then # path given as parameter
		CLAM_DIR=$PHP_CLAM
	else
		# search default path list
		AC_MSG_CHECKING([for clam files in default path])
		for i in $SEARCH_PATH ; do
			if test -r $i/$SEARCH_FOR; then
				CLAM_DIR=$i
				AC_MSG_RESULT(found in $i)
			fi
		done
	fi

	if test -z "$CLAM_DIR"; then
		AC_MSG_RESULT([not found])
		AC_MSG_ERROR([Please reinstall the clam distribution])
	fi

	# --with-clam -> add include path
	PHP_ADD_INCLUDE($CLAM_DIR/include)

	# --with-clam -> check for lib and symbol presence
	LIBNAME=clamav # you may want to change this
	LIBSYMBOL=cl_retver # you most likely want to change this

	PHP_CHECK_LIBRARY($LIBNAME,$LIBSYMBOL,
	[
		PHP_ADD_LIBRARY_WITH_PATH($LIBNAME, $CLAM_DIR/lib, CLAM_SHARED_LIBADD)
		AC_DEFINE(HAVE_CLAMLIB,1,[ ])
	],[
		AC_MSG_ERROR([wrong clam lib version or lib not found])
	],[
		-L$CLAM_DIR/lib -lm -ldl
	])

	PHP_SUBST(CLAM_SHARED_LIBADD)
	PHP_NEW_EXTENSION(clam, clam.c, $ext_shared)

fi
