#include <iostream>
#include <gtk/gtk.h>

#include "ppeffect.h"
#include "effects_dialog.h"
#include "effectselector.h"
#include "effectlist.h"

#include "../config.h"
#include "../gettext.h"
#define _(x) gettext(x)
#define N_(x) gettext_noop(x)

using namespace std;

struct dialogstate
{
	PPEffectHeader *header;
	GtkWidget *preview;
	GdkPixbuf *previewsourcepb;
	GtkWidget *availselector;
	GtkWidget *currentselector;
};


static void add_effect(GtkWidget *w,gpointer userdata)
{
	struct dialogstate *ds=(struct dialogstate *)userdata;
	EffectListItem *eli;
	if((eli=effectselector_get_selected(EFFECTSELECTOR(ds->availselector))))
	{
		cerr << "Got selection: " << eli->name << endl;
		eli->Action();
		effectselector_refresh(EFFECTSELECTOR(ds->currentselector));
	}
}


static void effect_settings(GtkWidget *w,gpointer userdata)
{
	struct dialogstate *ds=(struct dialogstate *)userdata;
	EffectListItem *eli;
	if((eli=effectselector_get_selected(EFFECTSELECTOR(ds->currentselector))))
	{
		cerr << "Got selection: " << eli->name << endl;
		eli->Action();
	}
}


static void remove_effect(GtkWidget *w,gpointer userdata)
{
	struct dialogstate *ds=(struct dialogstate *)userdata;
	EffectListItem *eli;
	if((eli=effectselector_get_selected(EFFECTSELECTOR(ds->currentselector))))
	{
		cerr << "Got selection: " << eli->name << endl;
		eli->Remove();
		effectselector_refresh(EFFECTSELECTOR(ds->currentselector));
	}
}


void EffectsDialog(PPEffectHeader &header,GtkWindow *parent,GdkPixbuf *thumbnail)
{
	dialogstate st;
	st.header=&header;
	st.previewsourcepb=thumbnail;

	GtkWidget *dialog;
	GtkWidget *hbox;
	GtkWidget *tmp;

 	dialog=gtk_dialog_new_with_buttons(_("Effects..."),
		parent,GtkDialogFlags(0),
//		GTK_STOCK_CANCEL,GTK_RESPONSE_CANCEL,
		GTK_STOCK_OK,GTK_RESPONSE_OK,
		NULL);

	gtk_window_set_default_size(GTK_WINDOW(dialog),400,400);

	GtkWidget *table=gtk_table_new(2,4,FALSE);
	gtk_container_set_border_width(GTK_CONTAINER(table),5);
	gtk_table_set_row_spacings(GTK_TABLE(table),5);
	gtk_table_set_col_spacings(GTK_TABLE(table),10);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),table,TRUE,TRUE,5);
	gtk_widget_show(table);

	tmp=gtk_label_new(_("Available:"));
	gtk_table_attach(GTK_TABLE(table),tmp,0,1,0,1,
		GtkAttachOptions(GTK_FILL),GtkAttachOptions(GTK_FILL),0,0);
	gtk_widget_show(tmp);

	tmp=gtk_label_new(_("Currently used:"));
	gtk_table_attach(GTK_TABLE(table),tmp,1,2,0,1,
		GtkAttachOptions(GTK_FILL),GtkAttachOptions(GTK_FILL),0,0);
	gtk_widget_show(tmp);
	

	AvailableEffectSource fxs(header);
	st.availselector=effectselector_new(&fxs);
	gtk_table_attach(GTK_TABLE(table),st.availselector,0,1,1,3,
		GtkAttachOptions(GTK_FILL|GTK_EXPAND),GtkAttachOptions(GTK_FILL|GTK_EXPAND),0,0);
	gtk_widget_show(st.availselector);

	CurrentEffectSource fxs2(header,thumbnail);
	st.currentselector=effectselector_new(&fxs2);
	gtk_table_attach(GTK_TABLE(table),st.currentselector,1,2,1,2,
		GtkAttachOptions(GTK_FILL|GTK_EXPAND),GtkAttachOptions(GTK_FILL|GTK_EXPAND),0,0);
	gtk_widget_show(st.currentselector);

	tmp=gtk_button_new_with_label(_("Add"));
	gtk_table_attach(GTK_TABLE(table),tmp,0,1,3,4,
		GtkAttachOptions(GTK_FILL),GtkAttachOptions(GTK_FILL),0,0);
	g_signal_connect(G_OBJECT(tmp),"clicked",G_CALLBACK(add_effect),&st);
	gtk_widget_show(tmp);

	tmp=gtk_button_new_with_label(_("Settings..."));
	gtk_table_attach(GTK_TABLE(table),tmp,1,2,2,3,
		GtkAttachOptions(GTK_FILL),GtkAttachOptions(GTK_FILL),0,0);
	g_signal_connect(G_OBJECT(tmp),"clicked",G_CALLBACK(effect_settings),&st);
	gtk_widget_show(tmp);

	tmp=gtk_button_new_with_label(_("Remove"));
	gtk_table_attach(GTK_TABLE(table),tmp,1,2,3,4,
		GtkAttachOptions(GTK_FILL),GtkAttachOptions(GTK_FILL),0,0);
	g_signal_connect(G_OBJECT(tmp),"clicked",G_CALLBACK(remove_effect),&st);
	gtk_widget_show(tmp);

#if 0

	tmp=gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),tmp,FALSE,FALSE,5);
	gtk_widget_show(tmp);

	table=gtk_table_new(2,2,FALSE);
	gtk_container_set_border_width(GTK_CONTAINER(table),5);
	gtk_table_set_col_spacings(GTK_TABLE(table),10);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),table,FALSE,FALSE,5);
	gtk_widget_show(table);

	tmp=gtk_label_new(_("Before:"));
	gtk_table_attach_defaults(GTK_TABLE(table),tmp,0,1,0,1);
	gtk_widget_show(tmp);

	tmp=gtk_label_new(_("After:"));
	gtk_table_attach_defaults(GTK_TABLE(table),tmp,1,2,0,1);
	gtk_widget_show(tmp);

	GtkWidget *image1 = gtk_image_new_from_pixbuf(thumbnail);
	GtkWidget *image2 = gtk_image_new_from_pixbuf(thumbnail);

	gtk_table_attach_defaults(GTK_TABLE(table),image1,0,1,1,2);
	gtk_widget_show(image1);

	gtk_table_attach_defaults(GTK_TABLE(table),image2,1,2,1,2);
	gtk_widget_show(image2);
	st.preview=image2;
#endif

	gtk_widget_show(dialog);
	
	bool done=false;
	while(!done)
	{
		gint result=gtk_dialog_run(GTK_DIALOG(dialog));
		switch(result)
		{
			case GTK_RESPONSE_CANCEL:
				cerr << "Clicked Cancel" << endl;
				done=true;
				break;
			case GTK_RESPONSE_OK:
				cerr << "Clicked OK" << endl;
				done=true;
				break;
		}
	}
	gtk_widget_destroy(dialog);
}

