# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/

# Embedded icon is taken from www.openclipart.org (public domain)

# Follows PEP8

from core import models
from lib.reverse_translation import _t

#--- PIL function


def init():
    #lazy import
    global Image, ImageOps, imtools
    import Image
    import ImageOps
    from lib import imtools


def equalize(image, amount=100):
    image = imtools.convert_safe_mode(image)
    if imtools.has_alpha(image):
        equalized = imtools.remove_alpha(image)
    else:
        equalized = image
    equalized = ImageOps.equalize(equalized)
    if imtools.has_alpha(image):
        imtools.put_alpha(equalized, imtools.get_alpha(image))
    if amount < 100:
        equalized = imtools.blend(image, equalized, amount / 100.0)
    return equalized

#--- Phatch Action


class Action(models.Action):
    label = _t('Equalize')
    author = 'Stani'
    email = 'spe.stani.be@gmail.com'
    init = staticmethod(init)
    pil = staticmethod(equalize)
    version = '0.1'
    tags = [_t('color')]
    __doc__ = _t('Equalize the image histogram')

    def interface(self, fields):
        fields[_t('Amount')] = self.SliderField(100, 1, 100)

    icon = \
'x\xda\x01/\x08\xd0\xf7\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\
\x00\x000\x08\x06\x00\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\x08\
\x08|\x08d\x88\x00\x00\x07\xe6IDATh\x81\xed\x99{p\\e\x19\xc6\x7f\xefwv\xb3\
\x97\x93\xec&\x92@!0Z\xa5-c\xbd!\x8e\nV\x1c\xd0z\xa1#\xbd`K\x0b8:\xc3\x80cg\
\xac\x83J\x81q\xbb\xa7\x1b\x828^!\xdc\x84b\x99iK\x9ar\x1bT\x94J\xabe\x80\x80\
V\x90\x02\t\xa1M\x1aB\xc8u\xb3I\xb6\xdb\xecn\x92\xdds>\xffH\xdb\xc1\xda\xec%\
\x97v\x9c\xe1\xf9o\xcf\xf9\xf6}\x9f\xe7|\xef\xf7\x9c\xf7\xfb\x8eh\xad\xf9\
\x7f\x86:\xd5\x04\xa6\x8b\xf7\x05\x9cj\xbc/`\xbaX6$\x1f]\x1e\x93\x1fG\x90)q\
\x91S\xe9B\xcb\xa3\xf2m-\xdc\x07\x98\x08\xbb\x95\xcd\xd5O\x9c\xa1\xa3\xc5\
\xc48%\x02Vu\x89o\xcc\xc3]\x02\xd7\xfe\x17\x19T\xaf\x83\xb3\xfa\x0fU\xfa\xb9\
Bc\x9dt\x01+b2\xdf\xd1<\n|\x02@a\xe0\x11?n\xf1\xa00\xd0h;\xe5\x8cl|\xac*u\
\x9b&?\xb9\x93*`iLV\x8b\xe6\x01\xa0\x0c\xc0#~\xbcR\x8aWL\xdcx0\xc4\x05@Vg9\
\xac\x87v\x8d\x8cF\xd7<Q\xad\x07s\xc5<)\x02DD\x96\xecW[\\\x15\xce5G\xafy\xc4\
\xc4\x94 ~\t\xe2\x15\x93\x12\xf1a\xe0B\xa3\xb1\xc90\xa6\xd3\x0cf\xba\x87\x07\
;\x87/~\xea3cM\x93\xc5\x9eu\x17\xda\xb0a\xc3W\xc2\xe1p\xa4\xfbQ\xe3\x82T\xdb\
D:\xb7x\xf0K\x00SUP\xaa*(S\xa7\x11P\x95\x04T\x15\x01UI\xa9T06>F\xdf\xfexE2*g\
\xe7\x8a?\xab\x02,\xcb\xbaZD\xc2\xb6mo\xca\x1cF\xbd\xbbC\x11\xdbcP\xa2\xfd\
\xf8\xa4\x14\xbf\x94aJ9e\xf2\x01\x02RI@UbJ9\x9d\xf16\xdez\xad\x95\xcc\xe1\
\xfc\xd51\xab\x02\xb4\xd6o\x1a\x86qimm\xed\xbb\x00\xda\x81\xd8\x0bB\xeb\xc3i\
\xec\xa4\xc2\x839!D\x95S\xa6*q\xe1\xa6\xb1\xf3iZ\x9b\xdb\xd1\xd9\xc2r\xcc\
\xb8\x00\xcb\xb2.\xb1,\xeb\x12\x80\x9a\x9a\x9aW\x01B\xa1\xd0\xa2\xf7\x8eI\
\xb4gy\xe9\xfe\xb7\xe9\xeb\x8c\xe2\x16/^\xfc\xc42\xdd<\xf9\xfaf\xfa\xde\x19(\
*\x9fk\xc6\x98\x03\xe1p\xf8G\xc0*\xc7q\xae\x00\x08\x85B\xd5J\xa9\xedJ\xa9-\
\xc7\x8f\x1dO8<\xbf\xb9\x85C_Ms\xe6\xc7*xc\xff>tF\x8a\xce9\xa33 "\xc3\x86a\\\
\\[[\xdb\r\xa0\x94Z\xa9\xb5\xae\xa9\xa9\xa9y\xf0D\xe3\xb5\x03\xaf\xed\xec\
\xe0\xe5\xe7\xa6F\x1ef\xc0FC\xa1\xd0En\xb7\xbb\xc9\xb2\xac\x04\xc0\xaaU\xab\
\x8c\x85\x0b\x17VY\x96\xd5wt\xcc\xe5\xfd2\xb7\xfd\xb7\xee\xa7\xb3)\xbd\xe0D1\
N\xbb@\xf0T\x9dX\x80F\xbe\xb1\xe7\xb2\xd1\x9d\x93\xe5\xcf;\x03\x91Hd\xced\
\xf7\xc2\xe1\xf0z\xa5T\x1d\x90=:\xf6\xbc\xf3\xce\xdb\xe58\xce\xc7\x01\x04\
\x91\xa5\x03\x12R\x8a\xd69\x97g\xe7\x88;_\xb6\xe2\x91S@(\x14\xfa\xacm\xdb\r\
\'\xba\xb7n\xdd:\x8f\xd6\xfa\\\xc30\x16=\xfb\x9d\x8d\x0e\x80m\xdbw\x8b\xc8\
\xaf#\x91\xc8\xaeU}R\xb5t\x80\x9d\x02\xb7\x02F\xe9<\x1d\x9c{\xad\x8d\xa7rf_\
\x9c9\x17\xb1\x88\x9c\x05x\xdf{-\x12\x89|\xc8\xb2\xac\x8e\xba\xba\xba1\xe0\
\xfa\xe5Q\xd7\xb2\xa0\xf0\xe0\xb2\x98\xd4\x9d?g\xedw\xad\xb5\xf7\x8c\xac\x18\
\x90E\x8eA\x03P\r\xa0P\xb8\xc5\x87y\xba\x9b\x8a\xeb\x85\x8e?\xa7\x19|\xad@\
\x9f\x9c\x8e\x80\xe3\x11\x0e\x87\xd7\x01K\x80\xaf}\x0fq\xc7\xde\xf5\xdd\xa9\
\xbd\xf6\xf7\x01\xd0D\xf6\xad\xbcw\xd1\xf2\xe8\xbd\xff\xd0\xc2-Gc{\xc4\xc4+&\
\x1e\xf1aP\x82*Q|r\xb9C\xe7\xdcA\x0e>\x95(\xd8\xef\xa7-\xc0\xb2\xac/\x03\x17\
\xa4\xd3\xe9\x15\xcb\x86\xe4\x1c\x9d\xe5\x11\xf1\xa6?\x7f\xf4\xbe[<\x18\xb8\
\x16ka\xf1\xb8N\xa1\xd1\xf8%\x80_\x82\xf8\xa4\x14\x8f\x98\xb8\xa4\x04Ap\xb0\
\x99\x7f~\x19\x15\xd51^o\xe8=9\x02\x94R\x8d\x96e\xfdm\xd9\x80\\\x86\xcd\x16\
\x11N\x9b \xee\x9dh\xc6\xf0b\x88\x1b\x85\xc2\xc6&\xe9\xc41%\x88\xa9\xca\xf1I\
\xe0H\xc7\xe9ED\xb0u\x96qR\xc4K\x07)\xfd0\xe0L\x9e\xd7\xc9\xe4^\xa7\x05\x0bh\
\xb66fVt\xdd~\x07%\xfc\x90#\x8e\xe7\x95R\xfc\x12\xc0\'\xa5\x94\x88\x0f\x17%\
\x88(\x1cm\xe37\x82\xa4\xf4!<\xf8)\x95\n\xfc\x12\xc0-^\x04!\xcd\x08o\xf5\xef\
\xa3\xe7`\x14;%\x18\xdeI\x16\xb6\xc6N\xf7\xd9#""z\x12\xbf/X\xc0\xe0\x96\xaa\
\xdb|\x17\r\xadsy&~O\xb4\xc3\xe5\x98*x\xec\t\xbb(AP\xd8\x92a\\\xa7\x19\xcf\
\xa6\xe9\x8dus\xe6\xd9\xe7bJ\x05^1\x19\xb6{y\xf1\xc03\xc4\xa3#9\xf3\xd9)=\
\xdc\xf5\';\xd2\xbe\xc5i\x06\x04\x98\x9e\x80\xd4\x01\xca\xfa[D\xce\xfc\xa6"0\
O\x1d\xe9&\x03\x98R~\xa4\xce\xcb\x8e=\xe1\x8c\x1e\xa35\xf1oZ\xf7\xbf\xc3\x19\
\x81\xb3\xf0`\xe2\x97\x00\x9d\xe9\x16\x9em\xfa\x0b\x99T\x8e\x9a\x01\xd2=\xba\
\xe9\xad\xdfd6\xc4[\xd8\x0b$&#_\x94\x80$\xc3\xb1l\x12\xba\x1eQ\x9c~\xa1A\xc5\
\xa5^\xbc.\x13\x9f\x04&JD\x05\xf1\x88\x9fQ\x9d\xe4_]\x7f\xa7\xbb\xa3\x0f4\
\x0c\x0e\x0e2\xa6\x93\xbc\xd0\xdf\xc8\xfe\x03\x07r\xd6;\x0eN\xece\xfd\xd8\
\x1b?\xcb\xfc\x92\x0c\xed\xc0!\xad\xb5\x9d\x8bW\xd1\xcd\x9cv\xa0\xbf\xd1&\
\xdd\xdd\xcf\xe7VVP\x19\xf4\xe1\x95RL\t\x92\xc8\x0e\xf1L\xcb#$\x86\x92\xc7\
\xc6\'zFi\xd8\xb1\x03\x7fu\xee^\xc7N\xebx\xe7\xe3\xf6/:\xb6;\x8f\x03=@Jk\x9d\
{\xaa\xa6"\xe0\x18\xb1\x8e,{\xeek\xe6\x0bWj>\xfd\x919\xb4\x1c\xde\xcb?\x9b^\
\xc0\x19\xff\xdf\xd9\x1e\x8f\x83\xbfz\x92@\x9a\xb6t\x1f\xc9\xb7\xb7ej\xe2M\
\xec\x05\x06\x80\xf1\xc9\x16\xed\x8c\t\x00\xc8\x8eh\x9e{\xa8\x99\x83_\xea\
\xc0\xf1\xa6sT\xea\xe4\x18;\xa4\x9f\xdfws\xa6\x0e\xe8\x04\x12Z\x17\xf7j\x9bv\
;\xad\x1d\x18jK\x15M^;d\x06\x1a\xed\xbb\xf6\xdd\x9c\xa9\x05Z\x81x\xb1\xe4a\
\x8674\x85";B\xdf\xdb\xdb\xedP\xd7\x93\xf6N&J&Sh\xc9\x1c\x8f\x93. \xf9\x8e~\
\xb1\xe5W\x99\x9b\x0e\xb7\xf3&\x05\xb8L>\x14.@3\xb5-\xd3\x84q\xaa#%\xb3\xa9\
\xf9\xe7\xf6\x9d\x14\xe12\xf9P\x90\x00\x11\x91\x857\xba\xa6\xb4\x1dQ\x06\xaf\
\xd8\x87\xb5\xab\xed!\xe7\x9e\xae\'\xec\xbfR\xa4\xcb\xe4C\xa13\xe0\x1aM\x90t\
\x95\x14\x9f\xc0\xc9\xd2\xfe\xfa\xad\xd9\x9b\x808\x90\x9c\xcaB\xcd\x85\xbc.\
\xa4\x94\xb2\x01\xe7\xe0\xfd\xd9McQ\xee\x00\xc6\x0b\t\xacA\xc7\x9bu\xfd\xbe\
\x1fdn\x06z\x99\x82E\x16\x82\x9c\x02\x82\xc1`\xef\xfc\xf9\xf3\xab\xeb\xeb\
\xeb\x1fX\xbf~}\xaacG\xf6\xf6\xe1W\xf4\xb5Z\xeb\xfe\\\xff\xb3\xc7t\xa2\xe7\
\x8f\xceO^]\x9fY?:J\x0f\xd3p\x99|\xc8{*Q__\x7f\x89\x88\xd4\x03\x03\xc9d\xf2\
\xca\xeb\xae\xbb\xae\xc7]\xc9\xbc\x0f^a\xd4\x19%r!\x80\xff\x1c\xa1|\xe1\xc4\
\x1a\x1f\x1b\xd0\xcdm\x9b\xf4\r\xd1\xc6\xec+\xcc\x80\xcb\xe4C\xde\x12\xba\
\xea\xaa\xab\xf6\xb8\\\xae\xf3\x81\x98i\x9a{\xb7m\xdb\xb6$\x13\xa3\xb9\xed~\
\xfb\x9a\xd1\xa8\xbe\x1b\x99()\r:\xde\xa4w\xbc|}\xe6[\xd1\xc6\xecKL\xbc\x98f\
\x95<\x14q.\x14\x89D\xd4\x82\x05\x0b6j\xad\x7f\nl\xda\xbd{\xf7\x8d\x9b7o6O_d\
,\x9e\xb3Xn\x19\xed\xe5\xf7\x07~\x97\xdd\xc1\x0c\xbbL>\x14}\xb0\xb5}\xfb\xf6\
\xc5\xc0\xc3@w<\x1e_\xbdv\xed\xda^\xc0\x04R\xcc\x82\xcb\xe4C\xd1\xbd\xd0\x9a\
5kv\x89\xc8\xa7\x80Dyy\xf9\xde\xad[\xb7~\x1d\xe8g\x96\\&\x1f\xa6\xd4\xcc\xad\
^\xbd\xba\xc7\xe5r]\n\xdcc\x18FC}}\xfd\r\'\xabd\x8e\xc7\xb4\xcfF\x1b\x1a\x1a\
\xbeh\x18\xc6\xab+W\xae\xcc\xbd\xc9\x9d%\x9c\xd2\xef\xc43\x81S\xfe\xa5~\xba\
\xf8\x0f\xac\x9f\x81\xbf\n!y:\x00\x00\x00\x00IEND\xaeB`\x82]\x90\x14H'
