# -*- coding: utf-8 -*-
# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/
#
# Phatch recommends SPE (http://pythonide.stani.be) for editing python files.

# Embedded icon is designed by Alexandre Moore (http://nuovext.pwsp.net/).

# Follows PEP8

from core import ct, models
from lib.reverse_translation import _t

#no need to lazily import these as they are always imported
import re

METHODS = [_t('All'), 'Exif', 'Iptc', _t('One')]


class Action(models.Action):
    label = _t('Delete Tags')
    author = 'Juho Vepsäläinen, Stani'
    email = 'bebraw@gmail.com'
    version = '0.1'
    tags = [_t('metadata')]
    __doc__ = _t('Delete Exif or Iptc tags')

    def apply(self, photo, setting, cache):
        info = photo.info
        method = self.get_field('Method', info)
        if method == METHODS[-1]: #One
            tag = self.get_field('Tag', info)
            del info[tag]
        elif method == 'all':
            for tag in info:
                del info[tag]
        else:
            for tag in info:
                if tag.startswith(method):
                    del info[tag]
        return photo

    def interface(self, fields):
        fields[_t('Method')] = self.ChoiceField(METHODS[0], METHODS)
        fields[_t('Tag')]= self.ExifItpcField('Exif_Image_ImageDescription',
            choices=self.EXIF_IPTC)

    def get_relevant_field_labels(self):
        """If this method is present, Phatch will only show relevant
        fields.

        :returns: list of the field labels which are relevant
        :rtype: list of strings

        .. note::

            It is very important that the list of labels has EXACTLY
            the same order as defined in the interface method.
        """
        relevant = ['Method']
        if self.get_field_string('Method') == 'One':
            relevant.append('Tag')
        return relevant

    icon = \
'x\xda\x01\xcb\t4\xf6\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\
\x00\x000\x08\x06\x00\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\x08\
\x08|\x08d\x88\x00\x00\t\x82IDATh\x81\xedZ]l\x1cW\x15\xfe\xee\x9d\xdd\x9d];\
\xb6\xe3\xdf\xfa\xa7\x90\x88\xb8\x94\x14\xd2\x96H\x84\x8a<\x80\xa8\x90JU\xfa\
\x80PE)\xaa\xa2\xa8\x15\x08\xf5\xa9 *\x10B* \xc2\x1b\x0fU\x8bD\xc5O\xa4\xa2\
\x8a<\x14\x01\xad\x8b\x84\x8a\x9b\xaa-)\xa4u\x9b\xb4i\x1dG\xb1c\xa7u\xe2\x7f\
{\xd7\xbb;\xb3s\xce\xe1\xe1\xde;;k\xaf\xe3m\xb3\xe5\x011\xd2\xd1\xec\xec\xae\
g\xbe\xef\x9e\xef;\xe7\xcc\xac\x81\xffo[o\xa3\xa3\xa3\xa9c\xc7\x8ee>\xcck\
\xa8\xab=\xc1\xefFG\xb34\xf5\xdeW*\x14\xdd\xe3y\xde\x8d~\xc6\xefKg\xfc\\*\
\x95RJ)\x05\x00"\x02\x8a"\x8e\xa2JX\x89\xa2%\xa6hR\x98\x9eom\xdf\xf9\xe47\
\xbev\xe7[\xffu\x02###\xfe\xf9\xe9K\x0f\xf9\xbe\xff@{{GO\xa1\x90W+\xcb\x8b(\
\x14\n\xc8\xe7\xf3\x08\xcae\x84a\x04f\x02\xa0\x90J\xa7\x91\xf2R\xc8\xe62\xc8\
\xb5\xb4\xa0\xa5%\'mm\x1d\xaa\xa3\xa3\x13J\xa9\xcazi}4\xc5\xfa\xc7\x87\x0f\
\xdf\xfd\xca\x87J`dd\xc4?{\xfe\xdd\xdf\xf6\xf6\xf5~\xbdT\\\xd73\xd3S\x98<?\
\x89B\xa1\x88(\x12(\xa5\xa0\xb5\x86\xa7=(\xad\xe1i\r\xad=h\xadm\xd8\xd7\x9e\
\x07O)\xa8\x94\xa0\xbd\xbd\x15\xfd\x03\x03\x18\x18\xbc\x16\xe5Rq\x82\x82\xf0\
\xab\xf7\xddw\xef\x9bM\'p\xf4\xe8\x1f\x0ex\xd9\xdc\xf10\x0c\xb3\xa7\xc7^\xc5\
\xf8\xf8\x04J\xa50\x01n+\xb0\x1aZyf\xbf\xc5w<\xad\xe0g5\x86\xaf\xdb\x83\xdd\
\xbb\xf7\xc8\xf2\xd2\xe2\xfd\x87\xee\xbd\xfb7M#\xf0\xc4\xb1c\xfbZs\xed\xaf\
\x9f\x1d\x7f[\x8f>7\x8a\xd5\xd5<\x94Rql\x04\xeby\xdaf\xa0\x0e\xa1M\xc7\x89\
\xbf\xf54\x86\x86zq\xcb-\x07eyun\xff=w\xdd\xf5\xfav\xd8R\x8d\x10H{\xd9\xe3g\
\xc7\xcf\xe8?\xff\xe9\xaf\x88\xa2\x08\n\x068,\x01f6d"\xb5u&6\x82\xad\xc9@\
\xf5;\xd3\x93\xef\xa1\xbb\xfb\x8c\x1a\x18\xfc\xc8\xb3\x00\x06\xae\x9a\xc0\
\xa3\x8f\x8e\xee\xd8\xf5\xd1\xce\xce\'\x8e\xfe\x1e\xe5r\xb9f\xe5M\x91\xa9=6d\
\xc8\x1ekx\x9b\xa4\xb3M&\xb4\xc6{\x17gq\xf3M\xfb\xfb\x1aY\xdcm\t\\\xbc\xf8O\
\x7f\xdf\xcd\xb7bhp\x003\xd3\x17kV>\x8e\x9a\x8c\xa0\xe63"\x15\x9b{+\xa9\xd5\
\x1a\xdfC_\x7f\x1f._\xbe,\x8d\x10\xd0\xdb}\xe1\xc8\x91\x1f.^\x9e\x9d\xc5\xfd\
\xdf\xfe\x16\x0e\xdcr\x00D\x04\xb6A.\xd8\x04ST\xfb>\x11\x98M\x10E\xa8TB\x84a\
\x800\x08\x10\x86e\x04\x81}\x1d\x04\x08\x822\xc2 \xc0\xc0P\x1f>\xfb\x99\x03\
\x98\xba0\xc3M\xc9\x00\x00\xf4\xf4\xf6a\xe2\xec\x04\x1e\xfc\xee\x838\xfd\xa5\
Sx\xec\xb1\xc7\xb00\xb7\xb8!\x1b\xd8"#\x9b\xb3\x15{FEP\xcad \x9b\xcd\xe0\xcb\
\xb7\xdf\x86\xbd{o\xc0\x8b/\x9e\x80\xf6\xd2\xd44\x02J)tw\xf5\xe3\x8d\xb1\xd3\
\xe8\xe8\xd8\x81_?\xfe8\xc6\xdfy\x07#\xcf<\x83\x97_:\x01\xa2hKi\xd5%\x91\xf8\
l\xf7\xae!|\xe1\x8b\x9f\xc7\xf5\x9f\xd8\x8bs\xe7\xcecnn\x0e;\xdaZQ,\x96\x1b"\
\xd0P\x19\x1d}\xfee&\x86Jer\xe8h\xef\xc0\xa5\xd9\x19\x04A\x01\x83\x03\x03\
\xe8\xea\xee\xc6\xc5\x8b3\x18\x1f\x1f\xc7\xcc\xf4\x0c\xa6/Lcna\x01\xf9\xb55\
\x94J\x01\x00AkK\x0br\xb9\x16tuwa\xe8\xda!\x0c\x0e\xf4c\xcf\x9ea\xf4\xf5_\
\x83\xf5\xf5\x12&\'\xa7\x10\x04!n\xd8{=Z[r\xf8\xf7\xc91\x14K\xe5\x95\x87\xbe\
\xf7@\xe7v\xd8\x1a\xca@D\x04\xadS\x80\x08\xb4\xe7\xe1\x93\x9f\xba\x19;\xda\
\xda\xb1\xb4\xb4\x80\x0b\x93\xe7\x90\xcf\xaf\xa1\xbf\xbf\x1f\x1f\xdb\xb3\x07\
]\x9d\x9dhkkG:\x93\x81\xa7\x8d\xc5\x98\x19\xc5b\t\x85\xf5<\x96\x97\x97\xb1\
\xba\x9a\xc7\xcaj\x1e\xf3\x8b\xcbH\xa52\xc8f[\xe1\xfbY\xf8\x99\x0c\x04\x00\
\x84!,\xcd\xf3\x00\xb3\x88\xf6\xd4\xa6luu\xf5\xa0\xab\xab\'\x06Y\tC\xcc\xcf_\
\xc6\xfc\xe2*\x8a\xc5"\xc20\x00\x11!\x9dJC\x04H\xa7\xd3\xf0\xb3;\xd1\xe7\xef\
D\x10\x94Q.\xdb\x08\xca\x80\x95\x94\x88@D\x01"\xe5\xa6\x11 "\xced\x94vumc}cf\
cL\xad\xd1\xd3{\r\xba\xba{\xe3\xf7\x98\t\x95J\x14W\x9d \x08\x10\x94\xcb`\x16\
@\xc4\x00f\x01\xc0\x80\x889\xb9\x08\x889l\x04\xdb\xb6e\x14\x00\x98X\x94R\xe6\
\x02\x90\x1a\x06U\xa0\xd5\x90\r{0\x81\xd9\x00\x15f\x88\x08X\xd8\xbc\'bec*\
\x99\x88\x80\x0c\x8b\xe6\x11 \x8eX;\x05%\xc0\x8b\x88\x01*\x1c\xefE\x18\\\xb3\
\x17\x10\x1c\x19\xb2\x12q\xe1V\x9dQ\x93]\x11\x10S\xbei\x04\x989\x82v\x04\x04\
\x02I\x80\xaf%Q?\x04$\x0c\x8eW\x9e!,\xf1\xb1\x88\x83\xae\xec\xf9\x04\xcc\x08\
\x9aF\x80\x88Y+e/\x04s\xf1-\xc1\xd6\tr\x80\x19D6S\xb1\xe6\x8d\xac,\xfe\xaaL)\
Zo\x04[\x83U\x88C3\xb81\x18f\xe5\x88(^}\xb3b.6{@\x98\xc1D\x00\x1b\xb98?\xb0\
\x95R\xacKA,\xaf\x88h\xb9i\x04\x88\x89\xec\xed\xad5"\x19s\xcaf\xc0\xf5\xc1\'\
$\x96\xd0\xbfH\xe2\xd82\xb0E\x08"\\j\x1e\x01\xa2\x8a\xd6\xca^\xd4\xea\x96\
\xd9x\x819>\xe6\x18dB\xef\xc2`\xb8\xe3*x\x971\x03\xd8\xe8G\xb9>\x00F$j\xb1\
\x89\x048T\n\x06\x845 \xd9\nR\x03\xda\xae0\xd7\xf5\x88\x9bL\xab\xe5\x13n\x01\
 H\xc1U \x93\xe5(\n\x9a\'!\x08BW!\xe2\xaaC&\x03\x8d\x98\x98,p\xe1\xaat\xcc\
\xb9\x00a\x87\xdc\x0cxq\x89%^k\x1a\x81rX\xa9h\xa5 \x16\x0c%j|=\x0fT\xc3V\x18\
B\\\x85\x98\x12\x12\x94\xaa\x0c\xe3\x8cX\x02J\xd4t\xd3\x08hH\x11\nq\xfb\x87\
\xeb\xa8@}\x0fl\xe8\x01q\xed\'\x8eG\x07\x86+\x9f\xa6\x0f\x88\xbbE\xb5\x12\
\x8c\xa2\xcaR\xd3\x08T\xa2 \xd2J\xd7H\x88\xd8\x0c\x8bn$\xa8\x01_cf\x935\x11\
\xb1E\x98\xec\xaa\x0b\x18\x80]\x06 Q\x87\x8c4\xf5B\xd3\x08\x10I\xc1\x9c]@\t\
\x80\x00\x12\x86\x95\xcd\xe0\x13\xd2"G\xd4\xca)\x1e\xe2X\xc0\x02(;<\x8b5\xf1\
#\x8f\x1c\x19o\x1a\x01\x08*Zk\x08l\xed\xa6$\x81+\x0frL\x04\x16\x01b\x13\'g 7\
\xc8\xb9>`^\xdb\x96\xd3\xbc[\xca0\xaa\xac(\x85j\xf3\x8a\xfb\x006\x18X\xaa]\
\xd6\xbd\'b\xcb\xa7\xab\xff\x89l\x81\xe3\xba\xef$\xc4\x90\xf7\xf5\xc0\xb3\
\xd1\x0c\x90\xd2f\x16"\xb2> \x064j\x07\xb9:{\x8a\xb3A\xb6\x919\xd0\x02\xb0\
\xf1P\xdc\x00\xe2]C#Z\xe3\x04*\xe5p\xc1uI\x16\x8a\xbb\xab\x03\xb0\x15\xf8\
\xb8\xb1\xb9.\x9c\x1c\xa7\xad\xf1!\xa6A&\x9f\xf2!\x1e\x1b\x9bD \x02i\xd3\xed\
m\xa5 i\xc0\x03VN\xe4\x9aX5\x03\xae\x87\xb8\xe1\r\x90Z\xd5pC\xb7\xc3\x00\xb6\
\xcf\x95\x02\xd0\xbe\xb40\x9f7\xd3\'b\x00\xf5L[o\x90\x93$xr\x1e1\x05\xb5\x9a\
\r\xc0I\xdfd\x19\x02 \xdb\x0c\x02\xad\x00Z\xd3i/\r\x81\x99*I\x12f\xe5\xc4~\
\xab1\x82a\xfa\x95kb\x1c7BFU\xff\x1b:\x81\x00\x18\x04\x90\xbe\x1a\x02\xbe\
\x8b\xb5\x95\x95u\xe5i\xbb:\xa6\xaa\x08\xb9\xc1-\xb9\xaf\xef\x03cr\x80\xdc\
\x08\x1d\xaf>b9)\x11\xb8B\x11U*\x04`\xa7\x8d+nW\xf2@\xca\x8676\xf6\xda\x19\
\xad\x15\xb2\xbe_\xed\xc6 \x80U\x03&\xb6\x95H\xc8\xc9#>\x07l?\xb05\xc9n\x82\
\xb7N\x9f\x1e\x05\x90\x81\x91\x91\xc2\xe6\x07!\re \xdeN\x9cx\xe9\xdc\xab\'O\
\xbe\xdd\xd9\xd5\x0e\xed\x99\x95$\xda\xc2\xb4nN\xb2\x81\xf8;\xc9*\xe4\xfa\
\x83\x85n\xab\x10\xa0055]y\xea\xa9\'\x7f\x85j#\xbb"\xc6+}H\x00"\x17\x87\x0f}\
\xf3\xd0\xbf^ye\xb2\xb7\xa7\x13~\xca\xdb\xfa\xee\xab\x8e\x07bB\xf1-(\xe2\xee\
k\x8a\x91@k\x85\xf9\xb9\x05\xf9\xc5\x91\x87\xbf\x0f \x0f\xa0\x04\xa0\x8cm:\
\xb2w\x85\xcf\xc4\x12t\xa1\xfe\xf6\xec\xd3\x7f\xb9\xa6o\xf0\xc6}7\xed\x1b\
\xcaf\xd2\x88"BDT\xc7\xbc\xc9\xf9\x88\xac\x91\xabY3\x8f\xdb\x05L\x11\x94V\
\xf03>\x8a\xc5<\xfd\xf4\xe1\x1f\xfd`rr\xf2\r\x00\xcb6V\xec\x02~`\x02\xeeYA\
\xfc\xde\xf1\xe3\xff\xf8\xfb\x9b\xa7\xc6&\x86\xaf\xfb\xf8\xc1\xdd\xbb\xaeMg\
\xb2)c\xbc\xf8\xf7\x00\xa7\x7f7\xa1\xba\xdf\x12\xeckfh\rd\xfc4v\xb4\xb6\x00\
\x10\xbc\xf6\xda\xc9\xa9\x9f\xff\xec\'\xdfYX\x98\x1f\x07\xb0\x94 \xb0\xed\
\x93\x89F\xa6\x8e\x14\x80\\"\xb2.>w\xf0\xe0\x9d\xf7\xdc{\xf8\xfe\xfd\x9f\xde\
\xdf\xdb\xdd\xd5\x89("\x94\xca\x01\xc2 D%"T\xa2\x08Dd\x1f!2\x942I\x8d\xa2\
\x08\x97fg\xe5\xd4\xa97f\xfe\xf8\xe4\xd1_\xce\xce\xce\x8eY\xb0y\x00k0+\xdf\
\xd0M\xfd\xfb\xf9\x9d\xd8O\x82G\xb5\xccf|\xdf\xef\x19\x1e\xde{\xeb\xedw\xdcq\
\xdb\xf0u\xc3\xbb\xba\xbb\xba[s\xb9\x16O{\x1e\x98\x08\xc5b\x11\x85\xc2:\xcd^\
\x9a-\\8?\xf9\xee\x0b/<\xf7\xf4\xc4\xc4\xb9\xd1(\n\x96\x00\x04\x00\x8a\x96@\
\xc1\x92hx\x94\xf8 \xbf\xd4g\x1cp\x1b\xe9Dx0\x19\xd3\x00t6\x9bm\x03\xa0\xcb\
\xe5\xf2\x1a`\xef_\xaa\x85!\xb4\xe0\xcb0\xab]\xfc\x00X\xae\xfa\x7f%R\x16x\
\xdc3l\xe8\r\xe7\xb6\x8f\x9fA6*0\x04\x1az\x80\xfb?\xbd\xfd\x07=\xd2\xb2P\x06\
\x87 \n\x00\x00\x00\x00IEND\xaeB`\x82+1\xa1U'
