#!/usr/bin/env python

# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008  www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/

import glob, os, sys, subprocess
from distutils.core import setup
from phatch.data import info

#centralised info generates README and AUTHORS
#Temporarily execute the following statement if these files needs update.
#info.write_readme_credits()

write               = sys.stdout.write
error               = sys.stderr.write
WINDOWS             = sys.platform.startswith('win')
MAC                 = sys.platform.startswith('darwin')
LINUX               = sys.platform.startswith('linux')
INSTALL             = len(sys.argv) > 1 and sys.argv[1] == 'install'
CLEAN               = len(sys.argv) > 1 and sys.argv[1] == 'clean'
ROOT                = os.geteuid() == 0
NAUTILUS_SCRIPTS    = ['linux/phatch_image_inspector.py',
                        'linux/phatch_recent.py',
                        ]

LINUX_SYMLINKS      = [
                        ('phatch.png','share/pixmaps'),
                        ('phatch.png','share/icons/hicolor/48x48/apps'),
                        ('phatch.svg','share/icons/hicolor/scalable/apps'),
            ]

if not WINDOWS:
    DOC_PATH    = 'share/phatch/docs'
    LOCALE_PATH = 'share/'

def doc(x=''):
    return os.path.join(DOC_PATH,x)

PACKAGES    = [ 'phatch','phatch.actions','phatch.console','phatch.core',
                'phatch.core.lib','phatch.data','phatch.other','phatch.pyWx',
                'phatch.pyWx.lib','phatch.pyWx.wxGlade','phatch.templates']

#Create an array with all the locale filenames
i18n_files = []
for filepath in glob.glob("locale/*/LC_MESSAGES/phatch.mo"):
    targetpath = os.path.dirname(os.path.join(LOCALE_PATH, filepath))
    i18n_files.append((targetpath, [filepath]))
#docs
doc_files   = [
    (doc(),['docs/phatch_dev.txt']),
    (doc('phatch_dev'),glob.glob('docs/phatch_dev/*.*')),
    (doc('phatch_dev/images'),
        glob.glob('docs/phatch_dev/images/*.png')),
    (doc('phatch_dev/images/icons'),
        glob.glob('docs/phatch_dev/images/icons/*.png')),
    (doc('phatch_dev/images/icons/callouts'),
        glob.glob('docs/phatch_dev/images/icons/callouts/*.png')),
]

#images & icons
if WINDOWS:
    #todo: fixme
    os_files = []
else:
    PACKAGES    += ['phatch.linux','phatch.linux.lib']
    os_files = [
        #desktop
        ('share/applications', ['linux/phatch.desktop']),
        #images
        ('share/phatch/images', glob.glob("images/*.png")+\
            glob.glob("images/*.svg")),
        ('share/phatch/images/masks', glob.glob("images/masks/*.jpg")),
        #library
        ('share/phatch/actionlists', glob.glob("actionlists/*.phatch")),
        #man page
        ('share/man/man1',['linux/phatch.1']),
        #mime type
        ('share/mime/packages',['linux/phatch.xml']),
    ]
    os_files.extend([(target,[os.path.join('images',im)]) \
        for im, target in LINUX_SYMLINKS])

if LINUX:
    #python nautilus extension integration
    #pkg-config --variable=pythondir nautilus-python
    python_nautilus_extensions_path = subprocess.Popen(
            ['pkg-config','--variable=pythondir','nautilus-python'],
            stdout=subprocess.PIPE,
        ).stdout.read().strip()
    os_files.append((python_nautilus_extensions_path, NAUTILUS_SCRIPTS))

dist =  setup(
            packages        = PACKAGES,
            scripts         = ['bin/phatch'],
            data_files      = i18n_files + doc_files + os_files,
            **info.SETUP
        )

if not WINDOWS:
    # Update the mime types
    if ROOT and dist != None:
        
        #update the mimetypes database
        try: 
            subprocess.call(["update-mime-database", 
                os.path.join(sys.prefix,"share/mime/")])
            write('Updating the mime types database.\n')
        except:
            error('Failed to update the mime types database.\n')

        #update the .desktop file database
        try:
            subprocess.call(["update-desktop-database"])
            write('Updating the .desktop file database.\n')
        except:
            error('Failed to update the .desktop file database.\n')

write(  "\nInstallation finished! You can now run Phatch by typing 'phatch' \n"
        "or through your applications menu.\n")
