# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/

# Embedded icon is taken from www.openclipart.org (public domain)

from core import models
from core.translation import _t

#--- PIL function
def init():
    #lazy import
    global Image, ImageOps
    import Image, ImageOps
        
def equalize(image,amount=100):
    if image.mode in ['RGBA']:
        equalized      = image.convert('RGB')
    else:
        equalized      = image
    equalized = ImageOps.equalize(equalized)
    if image.mode == 'RGBA':
        equalized  = equalized.convert('RGBA')
        equalized.putalpha(image.split()[-1])
    if amount < 100:
        equalized  = Image.blend(image, equalized, amount/100.0)
    return equalized
            
#--- Phatch Action
class Action(models.Action):
    label       = _t('Equalize')
    author      = 'Stani'
    email       = 'spe.stani.be@gmail.com'
    init        = staticmethod(init)
    pil         = staticmethod(equalize)
    version     = '0.1'
    tags        = [_t('colours')]
    __doc__     = _t('Equalize the image histogram')
    
    def interface(self,fields):
        fields[_t('Amount')] = self.SliderField(100,1,100)
        
    icon = \
'x\xda\x01T\x05\xab\xfa\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\
\x00\x000\x08\x06\x00\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\x08\
\x08|\x08d\x88\x00\x00\x05\x0bIDATh\x81\xd5\x9a\xcbo[E\x14\xc6\x7fg\xee\xdck\
_\xd7I\xda\xa6B\x85\xaa/\x9a\nZ$@\x15\x15\xf0\x1f\xb0f\x0bK@\x08Pwl\x10\xe2/\
\x80\r\x82MY\xb0e\x9b\x15]\xd1"6i\xc5\xa6\x9b\xb6\x02TB%\\\xda\xb8I\x13;\x8e\
}\xe7\xce\x0c\x8b$m\xec{\xfd\x88\xed\xe6\xf1I\x96<\x8fs\xcf\xf7\xc9\xe7\xcc\
\x99\x99k\x99\x9b\x9b\x9b\x04~\x8c\xa2\xe8|\x92$\x13\xde{\xbc\xf7\x86\rx\xef\
\xd9\x8a\xce\xb6s\xae\xe7x\xb7\xf6\xa0\xf3\xb6\xfa\x11\x11%"\xcaZ\xdb\\^^\
\x9e\xafT*\xefk\xe7\xdc\x0f\x17/^|Wk\x8ds.Ch/`\xab\x98 \x08PJ\xe1\x9c\x9b\
\x99\x9d\x9d\xfdZ\x8b\xc8I\xad5\xf5z\x9d4Mw\x91\xe6\xe0\x88\xa2\x88R\xa9\x84\
\xd6\xfa\x94\x12\x11\xef\xbd\xdf7\xe4\x01\x92$\xc1{O\x92$\x07\x14d\xe3m?\xc0\
9\x87\xb5V\xeb\xce\x81z\xbd\xce\xda\xda\xdanp\x1a\x08\xe5r\x998\x8e\xd9Xl\
\xc8\x08\xa8\xd5j\x18c\x98\x9e\x9ef3\xb4\xb6&v\x10\x04\xcf\x94\xa0\xf7\xbe\
\xcd\xdff\xdbZK\xa3\xd1 \x0cC\xe28FD\x88\xa2(\xc9\x08p\xceq\xf8\xf0a\x8e\x1d\
;\xf6L\x89\x0e\x83[\xb7n=\xf9."h\xad\x8d\xea\x9c\xe4\xbdGDv\x94\xd80\xd8\xe4\
\x98+`?a\xdf\x0b\xc8\xe4\xc0N\x0b\x98_\xfa\x99\xdf\xee~\x89\xb1-\x8c1\x14\
\xc3)\xb4\x9a\xe2P\xfc\x12o\x9f\xfe\x9cC\xa5\x93=\xed3\x02v\x1a\xbf\xde\xfd\
\x82\xd3/>\xe6i\xda-\x00\x0b\xac5\xefp}^\xf1\xce\xf9o{\xdagBh\xc7\xe1\r\xdd\
\xd6\x8c\x86y\xd8\xd7|\xf7\x05\xf4\x08\x02!\x1c\xc1z\x87\x10\xc8\x04\xcdd\
\x01h\xff\x19Z\xc6\x12\x87G\xfa\xda\xef\xba\x80P\xa6\xb9\xf7\xf0z\xa6?5\x9es\
\xe5\x17\xfa\xda\xf7\x15p\xe7\xd2%\x1e^\xbb\x86\n\x02\x14\xa0\x0b\x05\xc2R\
\x89xf\x86\x97/_\x1e\x8at\x1b\x01u\xa0\xebX\xa4\xe3\xfe\xf6\xbd\x06]\x92\xb0\
x\xe5\no\xcc\xcc\xa0T{\xba\xdc\xbbq\x03\xdfl"\xc5\xe2\x80T\xbb\x10\x90\xd1\
\xec{\'\xb1\x08\x85b1C~}HHWVFr>\x0e\xf4\x14\xa0\xc2\x90\xd4\xda\xdc1\xef=n\
\x0fT\xed\xbe9 G\x8ep\xbfR\xc9\xf4\xd7VWQ#\x86\xcf8\xd0W\x80\x8ec\x92j5\xd3\
\xef\xa3\x88\xb4V#\x9c\x9az&\xc4\x06E_\x01*{h[7\x9c\x98\xc87h\xfc\x07i#\xc7\
\xa0\x08\xa5\xfe\xcb\xe2v1|\x1d\xc8Il\x00\xaa\x1f\xc0\xf1\xdaz]\xf2\x026X\
\xff\xdcUp\xe6\'\x88\x0e\x0e\xed2\x97\xc6X\x9f\x060i\x9f\x16U\xf1\xa0S(\xb4\
\xe0\xf9\x08V\xb3\xb94*\xc6/\xa0\xd5\xe5\xcc\xec\x02\x08\xbb\x84\xdd\x08\x18\
\xffV\xa2Z\x82\x92\x03:\x96\xd8z\x19\x8eN\x8e\xdd\xddx\x05\xa4\xab\xb0\x16\
\xe2\xab\xd9\x95I\xea\x13\xf0\\2Vw0J\x08\x19\x93\xeds)\xf4*n\xe9\xf8\xef\x9b\
2\x02\x06\xbd\x91\xf0{\xe4*rh\x01\xf9O\x8bF\xe12\x9c\xcb~\x13$\xec~*\x92\xce\
Z0\xc0\xf6w\xdc\x18i\x19\xdd\xf6^(Y\x1e\xc5]>\x87~\x13\\\xb3\xd9u\xcc,.n\xcf\
[0\xfe\xcd__\x01\xbe\x87\x80\xd6\xa3G\xdb\xf3\x16\x142]a0Z\xd8\xe5\xd6\x81\
\x89\xc6w\xf0\xd7\xef\x00H\xe3\x1f \xc7\x89[\xc1\xdc\xfe\x0c\xa6;\xf66\xc9\
\x12p6;\x7f\xed&\xcc\xbf\x07\x1da\'\xb5?\xa1[\x81^\xf8\x1e\xec\xec\x16\xb2_\
\x01\xa5\xfe\x02\x8a\xc9/\x90\xdc\x00\xc0\xdb\xa3]\x04\x18\xd2\xeaM\xa8m\xa9\
\x07\x0e\xe0\\>\x19\xbb\x04\x8d\xdb\xd0Y>\x92\x80\xae\x81\xd0\xfa\x03jw\x9e4\
\x83\xf0S\xe0x\xdb\x94\\K\xb7E\xa5\xb3\xdd\x0bS\x10u\x8c\t\xd0\xeb%\xe1\x18\
\xea\xbe\xed8!\xe6>\xd2\xab\xa7aq\xf0\xadU\x16\xe6\x0ca,\x04\x1a\x9c8$\xf4\
\x84S\x96\xe9\xd7;\x8e\x9b\x02\xd4\xe6\x91\xdb\x8f\xc1\xb2\xfe\xd9\xd4\xa8\
\xeap"\x9f\x94\xcb9\xb5Z;X=\xd2i\x9af\x16z\x97\xc4 g\xc0{f>\x0e\x99\xf9$^_A\
\xa4\xffM\x19\xa7\x07\xf2\xfb\x04\xaf\xd1\xa0X_d\xd5&8<\xc6y\x8aJS\x0e\x03^\
\x9d\x9c\x04\xe5\xc1;\x08\xa7\xb1n\x8a\xce\xbd\xaeN\xd3\xb4\xedWH\xd3\x94\
\x7f\xd7\xde\xa4\xd4\xf08kI\xe5\x00\x862.\xe7\xfeFaP\xe2\x10R\x02R\x04\x08h\
\x01\x10H\n8\x94X\x94\xcf\xd97m\x12\x00^\xe1T{\xa7\x03\x8c\xa1\xbe\x9a\xd0\
\xf0\t"\x82\r\x0eR/\x19J\x81\xc9\xd8\xb7\xe5\xc1\xd2\xd2\x12\xf7\x9bg\xc9]Iv\
\x19\xaa\xe581\xd1\x9ec\xda9\xd7&\xe0\xc2\x85\x0b;Jj\x14h\xad\x13\xa5\x94ry\
\x17W\xfb\x01"\xe2\x94R*\x01(\x14\xb2Ur\xaf\xa2P( "\x18cB\xbd\xb2\xb2\xf28MS\
\xe28\xa6P(\xec\xb9wd\x9d|\x94R(\xa5h6\x9b\xd4j\xb5\xaa^\\\\\xfc\xf0\xea\xd5\
\xab\xdf\x94\xcb\xe5\x93\xde\xfb\xd2\xc6kV\x1f\x86a\xdb\x89e\xd8\xbf\xd5tko\
\xe7\xb9"\x12\x88H\xa4\x94*Xk[@\xe3\xc1\x83\x07\x7fW*\x95\x8f\xfe\x07\xcc\
\xf7\x16\xae\x99\xc6%[\x00\x00\x00\x00IEND\xaeB`\x82sP\x8f\x17'
