<?php

final class PhabricatorMetaMTAMailViewController
  extends PhabricatorMetaMTAController {

  public function handleRequest(AphrontRequest $request) {
    $viewer = $request->getUser();

    $mail = id(new PhabricatorMetaMTAMailQuery())
      ->setViewer($viewer)
      ->withIDs(array($request->getURIData('id')))
      ->executeOne();
    if (!$mail) {
      return new Aphront404Response();
    }

    if ($mail->hasSensitiveContent()) {
      $title = pht('Content Redacted');
    } else {
      $title = $mail->getSubject();
    }
    $header = id(new PHUIHeaderView())
      ->setHeader($title)
      ->setUser($this->getRequest()->getUser())
      ->setPolicyObject($mail);

    $crumbs = $this->buildApplicationCrumbs()
      ->addTextCrumb(
        'Mail '.$mail->getID());
    $object_box = id(new PHUIObjectBoxView())
      ->setHeader($header)
      ->addPropertyList($this->buildPropertyView($mail));

    return $this->buildApplicationPage(
      array(
        $crumbs,
        $object_box,
      ),
      array(
        'title' => $title,
        'pageObjects' => array($mail->getPHID()),
      ));
  }

  private function buildPropertyView(PhabricatorMetaMTAMail $mail) {
    $viewer = $this->getViewer();

    $properties = id(new PHUIPropertyListView())
      ->setUser($viewer)
      ->setObject($mail);

    $properties->addProperty(
      pht('ID'),
      $mail->getID());

    $properties->addProperty(
      pht('Status'),
      $mail->getStatus());

    if ($mail->getMessage()) {
      $properties->addProperty(
        pht('Status Details'),
        $mail->getMessage());
    }

    if ($mail->getRelatedPHID()) {
      $properties->addProperty(
        pht('Related Object'),
        $viewer->renderHandle($mail->getRelatedPHID()));
    }

    if ($mail->getActorPHID()) {
      $actor_str = $viewer->renderHandle($mail->getActorPHID());
    } else {
      $actor_str = pht('Generated by Phabricator');
    }
    $properties->addProperty(
      pht('Actor'),
      $actor_str);

    if ($mail->getFrom()) {
      $from_str = $viewer->renderHandle($mail->getFrom());
    } else {
      $from_str = pht('Sent by Phabricator');
    }
    $properties->addProperty(
      pht('From'),
      $from_str);

    if ($mail->getToPHIDs()) {
      $to_list = $viewer->renderHandleList($mail->getToPHIDs());
    } else {
      $to_list = pht('None');
    }
    $properties->addProperty(
      pht('To'),
      $to_list);

    if ($mail->getCcPHIDs()) {
      $cc_list = $viewer->renderHandleList($mail->getCcPHIDs());
    } else {
      $cc_list = pht('None');
    }
    $properties->addProperty(
      pht('Cc'),
      $cc_list);

    return $properties;
  }

}
